#include "infodialog.h"

InfoDialog::InfoDialog(int action, QWidget *parent, Qt::WFlags f) :  QDialog(parent, f)
{
    setupUi(this);

    this->action=action;

    switch (this->action){
    case 0:
        this->setWindowTitle(tr("Winetriks plugin notification"));
        this->txtInfo->setHtml("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\" \"http://www.w3.org/TR/REC-html40/strict.dtd\"> \
                               <html><head><meta name=\"qrichtext\" content=\"1\" /><style type=\"text/css\"> \
                               p, li { white-space: pre-wrap; } \
                               </style></head><body><p style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-weight:600;\">winetricks</span> is a quick and dirty script to download and install various redistributable runtime libraries sometimes needed to run programs in Wine.</p> \
                               <p style=\"-qt-paragraph-type:empty; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"></p> \
                               <p style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\">The script is maintained and hosted by <a href=\"http://wiki.winehq.org/DanKegel\"><span style=\" text-decoration: underline; color:#0057ae;\">DanKegel</span></a> at <a href=\"http://www.kegel.com/wine/winetricks\"><span style=\" text-decoration: underline; color:#0057ae;\">http://www.kegel.com/wine/winetricks</span></a>, you can read more here <a href=\"http://www.kegel.com/wine/winetricks\"><span style=\" text-decoration: underline; color:#0057ae;\">http://wiki.winehq.org/winetricks</span></a>.</p> \
                               <p style=\"-qt-paragraph-type:empty; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"></p> \
                               <p style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-weight:600;\">winetricks </span>plugin for<span style=\" font-weight:600;\"> q4wine </span>was writed by <a href=\"http://wiki.winehq.org/DanKegel\"><span style=\" text-decoration: underline; color:#0057ae;\">Pavel Zinin</span></a>.</p> \
                               <p style=\"-qt-paragraph-type:empty; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"></p> \
                               <p style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-weight:600;\">NOTE: q4wine</span> officially do not support <span style=\" font-weight:600;\">winetriks</span>, so repport all bugs directly to <span style=\" font-weight:600;\">winetriks</span> developers.</p></body></html>");
        break;
    case 1:
        this->setWindowTitle(tr("AppDB browser notification"));
        this->txtInfo->setHtml("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\" \"http://www.w3.org/TR/REC-html40/strict.dtd\"> \
                               <html><head><meta name=\"qrichtext\" content=\"1\" /><style type=\"text/css\"> \
                               p, li { white-space: pre-wrap; } \
                               </style></head><body><p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-weight:600;\">AppDB browser</span> allows you to browse <a href=\"http://appdb.winehq.org/\"><span style=\" text-decoration: underline; color:#0057ae;\">wine AppDB database</span></a>.</p> \
                               <p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-weight:600;\">Note:</span> Unfortunately, <a href=\"http://old.nabble.com/Re:-Wine-AppDB-xmlexport-script-td27137399.html\"><span style=\" text-decoration: underline; color:#0057ae;\">almost no one of wine devels not interested in my xml export script</span></a>. Also I don't get any answer on my letter about hosting request at winehq.com host site. (Before creating script, I ask for a hosting in <a href=\"mailto:appdb@winehq.org\"><span style=\" text-decoration: underline; color:#0057ae;\">appdb@winehq.org</span></a> maillist and Alexander N. Sørnes says that it can be done. But...).</p> \
                               <p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\">For now, I port xml export script to <a href=\"http://www.djangoproject.com/\"><span style=\" text-decoration: underline; color:#0057ae;\">django framework</span></a> and thx to <a href=\"mailto:opium@jabber.com.ua\"><span style=\" text-decoration: underline; color:#0057ae;\">Opium</span></a>, we can host it on <a href=\"http://q4wine.brezblock.org.ua/\"><span style=\" text-decoration: underline; color:#0057ae;\">q4wine hosting site</span></a>.</p> \
                               <p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-weight:600;\">Note</span>: Because we have <span style=\" color:#aa0000;\">no direct access</span> to appdb database, we can't use it actual copy.</p> \
                               <p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-weight:600;\">Note</span>: In case, if you wish to add my xmlexport code to appdb engine, I can provide information and support, just feel free to contact <a href=\"mailto:brezerk@gmail.com\"><span style=\" text-decoration: underline; color:#0057ae;\">me</span></a>.</p></body></html>");
        break;
    }

    connect(cmdOk, SIGNAL(clicked()), this, SLOT(cmdOk_clicked()));
    connect(cmdCancel, SIGNAL(clicked()), this, SLOT(cmdCancel_clicked()));
}

void InfoDialog::cmdOk_clicked(){
    if (cbDontShow->isChecked()){
        QSettings settings(APP_SHORT_NAME, "default");
                settings.beginGroup("DialogFlags");
    switch(this->action){
    case 0:
        settings.setValue("winetriksPlugin", 1);
        break;
    case 1:
        settings.setValue("appdbBrowser", 1);
        break;
    }
    settings.endGroup();
}

    this->accept();
}

void InfoDialog::cmdCancel_clicked(){
    this->reject();
}
