/****************************************************************************
    Qt-BSch3V schematic capture
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#include <assert.h>
#include <qlineedit.h>
#include <qlineedit.h>
#include <qradiobutton.h>

#include "edittagimpl.h"
#include "xbsch.h"
#include "xbschtag.h"


/* 
 *  Constructs a edittag which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
EditTag::EditTag( QWidget* parent,  const char* name, bool modal, Qt::WFlags fl )
    : EditTagBase( parent, name, modal, fl )
{
	m_nType=0;
}

/*  
 *  Destroys the object and frees any allocated resources
 */
EditTag::~EditTag()
{
    // no need to delete child widgets, Qt does it all for us
}

int EditTag::exec()
{
	LineEdit2->setText(m_strLabel);
	LineEdit2->setFocus();
	RadioButton5->setChecked(m_nType == SXBSchTag::TAG_SQ);
	RadioButton6->setChecked(m_nType == SXBSchTag::TAG_BI);
	RadioButton7->setChecked(m_nType == SXBSchTag::TAG_LU);
	RadioButton8->setChecked(m_nType == SXBSchTag::TAG_RD);
	return EditTagBase::exec();
}

void EditTag::accept()
{
	//qDebug("EditTag::accept\n");
	m_strLabel = LineEdit2->text();
	if(RadioButton5->isChecked()){
		m_nType = SXBSchTag::TAG_SQ;
	}else if(RadioButton6->isChecked()){
		m_nType = SXBSchTag::TAG_BI;
	}else if(RadioButton7->isChecked()){
		m_nType = SXBSchTag::TAG_LU;
	}else{
		m_nType = SXBSchTag::TAG_RD;
	}
	EditTagBase::accept();
}

void EditTag::setType(int n)
{
	if(n>0 && n<=3){
		m_nType=n;
	}else{
		m_nType=0;
	}
}


int EditTag::type()
{
	return m_nType;
}

void EditTag::setText(const QString & text)
{
	m_strLabel=text;
}

QString EditTag::text ()
{
	return m_strLabel;
}
