/****************************************************************************
    Qt-BSch3V schematic capture
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/


#include <q3listbox.h>
#include <qlineedit.h>
#include <qfileinfo.h>
#include <qstring.h>
#include <qmessagebox.h>
#include <qlayout.h>

#include <string.h>
#include <assert.h>
#include <list>
#include <string>
using namespace std;
#include "xbschglobal.h"
#include "selcompimpl.h"



#include "coord.h"
#include "complib.h"

/* 
 *  Constructs a selcomp which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
SelComp::SelComp( QWidget* parent,  const char* name, bool modal, Qt::WFlags fl )
    : selcompBase( parent, name, modal, fl )
{
	m_pCompIndex = NULL;
	m_nLib = -1;
	m_nIndex = -1;
	editchangeName = false;
	compSelectionChange = false;
	componentWidget = new SComponentWidget;
	componentView = new QScrollArea(this);
	
	QPalette palette;
	palette.setColor(QPalette::Window,Qt::white);
	componentView->viewport()->setPalette(palette);
	
    //componentView->setBackgroundRole(QPalette::Dark);
    componentView->setWidget(componentWidget);
	componentView->setProperty( "minimumSize", QSize( 200, 0 ) );
	selcompBaseLayout->addMultiCellWidget(componentView,1,2,2,2);
}

/*  
 *  Destroys the object and frees any allocated resources
 */
SelComp::~SelComp()
{
    // no need to delete child widgets, Qt does it all for us
}

void SelComp::libraryChanged()
{
	int nLib =ListBoxLibrary->currentItem();
	setComponentName(nLib);
}

void SelComp::componentChanged()
{
	QString name = ListBoxName->currentText();
	compSelectionChange = true;
	if(!editchangeName){
		LineEditName->setText(name);
	}
	compSelectionChange = false;
	string strName = name.latin1();
	//int l,i;
	m_nLib = ListBoxLibrary->currentItem();
	m_nIndex = ListBoxName->currentItem();
	
	const SCompLib* pLib = g_LibraryInfo(m_nLib);
	m_pCompIndex = pLib->compIndex(m_nIndex);
//	const SCompIndex* pIndex = g_SearchComponentIndex(strName.c_str(),&l,&i,NULL);
	componentWidget->setComponentIndex(m_pCompIndex);
	//editchangeName = false;
}

void SelComp::editnameChanged()
{
	if(compSelectionChange) return;

	editchangeName = true;
	int l,i;
	QString name = LineEditName->text();
	string strName = name.latin1();
	m_pCompIndex = g_SearchComponentIndex(strName.c_str(),&l,&i,NULL);
	if(m_pCompIndex){
		ListBoxLibrary->setSelected (l,true);
		ListBoxName->setSelected (i,true);
		ListBoxName->ensureCurrentVisible();
		m_nLib = l;
		m_nIndex = i;
	}
	editchangeName = false;
}


int SelComp::exec()
{
	setLibraryName();
	setComponentName(0);
	LineEditName->setFocus();
	LineEditName->selectAll();
	return selcompBase::exec();
}


void SelComp::setLibraryName()
{
	ListBoxLibrary->clear();	
	int nCount = g_LibraryCount();
	if(nCount==0) return;
	int n;
	for(n=0;n<nCount;n++){
		const SCompLib* pLib = g_LibraryInfo(n);
		const char* name = pLib->libraryName();//̾ϥѥ̾
		QFileInfo finfo(QString::fromLocal8Bit(name));
		QString baseName = finfo.baseName(); 
		ListBoxLibrary->insertItem(baseName);
	}
	ListBoxLibrary->setSelected (0,true);
}

void SelComp::setComponentName(int nLib)
{
	ListBoxName->clear();
	const SCompLib* pLib = g_LibraryInfo(nLib);
	if(pLib == NULL) return;
	//Ƥʤο
	int nCount = pLib->count();
	int n;
	for(n=0;n<nCount;n++){
		SCompIndex* pCIndex = pLib->compIndex(n);
		const char* name = pCIndex->name();
		ListBoxName->insertItem(QString::fromLocal8Bit(name));
	}
	ListBoxName->setSelected (0,true);
	ListBoxName->ensureCurrentVisible();
	//editchangeName = false;
}

void SelComp::accept()
{
	QString qsName = LineEditName->text();
	string strName = string(qsName.local8Bit());
	if(m_pCompIndex == NULL){
		m_nLib = -1;
		m_nIndex = -1;

		QString msg ="\"";
		msg += qsName;
		msg += "\" is not found. Continue?";
		int n = QMessageBox::warning (	this,
										"Qt-BSch",
										msg,
										"OK",
										"Cancel",
										QString::null,
										0,
										1 );
		if(n==1){
			selcompBase::reject();
		}
	}else{
		m_strComponentName = strName;
		selcompBase::accept();
	}	
	
	
//	int nLib;
//	int nIndex;
//	const SCompIndex* pCompIndex = g_SearchComponentIndex(strName.c_str(),&nLib,&nIndex,NULL);
//	if(pCompIndex != NULL){
//		m_strComponentName = strName;
//		m_nLib = nLib;
//		m_nIndex = nIndex;
//		m_pCompIndex = pCompIndex;
//		selcompBase::accept();
//	}else{
//		QString msg ="\"";
//		msg += qsName;
//		msg += "\" is not found. Continue?";
//		int n = QMessageBox::warning (	this,
//										"Qt-BSch",
//										msg,
//										"OK",
//										"Cancel",
//										QString::null,
//										0,
//										1 );
//		if(n==1){
//			selcompBase::reject();
//		}
//	}
}



