/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2006 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#pragma once

#include "ce3io.h"
#include "coord.h"

enum VECTPTN
{
	VECTPTN_L			=1,
	VECTPTN_C			=2,
	VECTPTN_PG			=3,
	VECTPTN_AR			=4,
	VECTPTN_TXT			=5
};

class SPtnObj
{
public:
	int m_style;
	int m_width;
	int m_nFill;
public:
	SPtnObj(void);
	virtual ~SPtnObj(void);
public:
	virtual  int id(){return 0;}
	//ʣ
	virtual SPtnObj* duplicate() = 0;
	//ͭʥǡɤ֤
	virtual bool qValid(){return true;}
	//֤ư
	virtual void move(int offsetx,int offsety) = 0;
	//åפο֤
	virtual int gripCount() = 0;
	//åפΰ֤֤
	virtual SPoint gripPos(int grip) = 0;
	//åפΰ֤ư
	virtual void setGripPos(int grip,int x,int y) = 0;
	

	//XɸꤷƺȿžԤ
	virtual void mirrorH(int x) = 0;
	//ȿžԤ
	virtual void mirrorH() = 0;
	//XY濴ɸꤷơžԤ
	virtual void rotate(const SPoint& p) = 0;
	//žԤ
	virtual void rotate() = 0;
	//ϰϤꤷåԤ
	virtual bool testIntersect(const SRect& ){return false;}
	//ꤷåԤ
	virtual bool testIntersect(const SPoint& ){return false;}
	//ͭϰϤ֤
	virtual SRect area() = 0;

	virtual bool readCe3(SReadCE3& rce3) = 0;
	virtual bool writeCe3(SWriteCE3& wce3,SPoint* pOrigin=NULL) = 0;

public:
	//XY濴ɸꤷơžԤ
	static SPoint rotatePoint(SPoint pt,SPoint pCenter);
	//XɸꤷƺȿžԤ
	static SPoint mirrorPoint(SPoint pt,int xCenter);
	//p0p1üɸȤpνŤʤƥ
	static bool testIntersectLinePoint(const SPoint& p0,const SPoint& p1,const SPoint& p);

};
