/****************************************************************************
    Qt-BSch3V schematic capture
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#include <qpaintdevice.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qimage.h>
#include <string.h>
#include <stdio.h>
#include "xbsch.h"
#include "xbschpattern.h"
//#include "xbschview.h"





class SBmpWorkArea
{
private:
	unsigned char* bitreverse_table;
	void init_bitreverse_table();
public:
	SBmpWorkArea();
	~SBmpWorkArea();
	unsigned char* buff0;
	unsigned char* buff1;
	unsigned char bitreverse(unsigned char c) const;
};

SBmpWorkArea::SBmpWorkArea()
{
	bitreverse_table = (unsigned char*) new char[256];
	init_bitreverse_table();
	buff0 = (unsigned char*) new char[0x10000];
	buff1 = (unsigned char*) new char[0x10000];
}

SBmpWorkArea::~SBmpWorkArea()
{
	delete[]bitreverse_table;
	delete[]buff0;
	delete[]buff1;
}

void SBmpWorkArea::init_bitreverse_table()
{
	for(int n =0;n<256;n++){
		unsigned char sbit = 0x01;
		unsigned char dbit = 0x80;
		unsigned char d = 0;
		for(int i=0;i<8;i++){
			if(n & sbit) d |= dbit;
			sbit<<=1;
			dbit>>=1;
		}
		bitreverse_table[n]=d;
	}
}

unsigned char SBmpWorkArea::bitreverse(unsigned char c) const
{
	unsigned char rc = bitreverse_table[c];
	return rc;
}


//////////////////////////////////////////////////////////////////////
//Хѿ
static SBmpWorkArea bmpworkarea;

//  岼ȿžȿž岼ȿžϹ®˼¹ԤǤ롣
//  90ٲžϥӥåȼΤǻ֤롣
//
//    (0) 0      (1) 90     (2) 180    (3) 270
//                                
//    ԡ     ̡     ¡     ҡ     
//  ̢Ң ¢Ԣ Ң̢ Ԣ¢
//    ¡     ҡ     ԡ     ̡     
//                                
//
//    (4) M0     (5) M90    (6) M180   (7) M270
//                                
//    ԡ     ̡     ¡     ҡ     
//  Ң̢ Ԣ¢ ̢Ң ¢Ԣ
//    ¡     ҡ     ԡ     ̡     
//                                
//
//	1  0 90ٲž
//	2  0                     岼ȿž
//	3  0 270ٲž
//	4  0                         ȿž
//	5  0 90ٲžΤ      ȿž
//	6  0                     岼    ȿž
//	7  0 90ٲžΤ  岼    ȿž


//ӥåȥޥåפ岼ȿžԡ
//ȥǥƥ͡ƱǤOK
void g_bmp_vmirror(int sx,int sy,const unsigned char *s,unsigned char *d)
{
	int xbyte=((sx+15)/16)*2;
	const unsigned char* sUpper = s;
	const unsigned char* sLower = s+xbyte*(sy-1);
	unsigned char* dUpper = d;
	unsigned char* dLower = d+xbyte*(sy-1);
	unsigned char c;
	int ymax = (sy+1)/2;
	for(int y=0;y<ymax;y++){
		for(int i=0;i<xbyte;i++){
			c			=sUpper[i];
			dUpper[i]	=sLower[i];
			dLower[i]	=c;
		}
		sUpper += xbyte;
		sLower -= xbyte;
		dUpper += xbyte;
		dLower -= xbyte;
	}
}


//ӥåȥޥåפ򺸱ȿžԡ
//ȿž̡ӥåȥޥåפϥɥ饤ȱͤˤʤ
//ȥǥƥ͡ƱǤOK
void g_bmp_hmirror(int sx,int sy,const unsigned char *s,unsigned char *d)
{
	int xbyte=((sx+15)/16)*2;
	const unsigned char* sTop = s;
	unsigned char* dTop = d;
	unsigned char c;
	int xmax = xbyte/2; 
	for(int y=0;y<sy;y++){
		int i,j;
		for(i=0,j=xbyte-1;i<xmax;i++,j--){
			c			=sTop[i];
			dTop[i]		=bmpworkarea.bitreverse(sTop[j]);
			dTop[j]		=bmpworkarea.bitreverse(c);
		}
		sTop += xbyte;
		dTop += xbyte;
	}
}

//ӥåȥޥåפ岼ȿžԡ
//ȿž̡ӥåȥޥåפϥɥ饤ȱͤˤʤ
//ȥǥƥ͡ƱǤOK
void g_bmp_vhmirror(int sx,int sy,const unsigned char *s,unsigned char *d)
{
	int xbyte=((sx+15)/16)*2;
	const unsigned char* sUpper = s;
	const unsigned char* sLower = s+xbyte*(sy-1);
	unsigned char* dUpper = d;
	unsigned char* dLower = d+xbyte*(sy-1);
	unsigned char c;
	int ymax = (sy+1)/2;
	for(int y=0;y<ymax;y++){
		int i,j;
		for(i=0,j=xbyte-1;i<xbyte;i++,j--){
			c			=sUpper[i];
			dUpper[i]	=bmpworkarea.bitreverse(sLower[j]);
			dLower[j]	=bmpworkarea.bitreverse(c);
		}
		sUpper += xbyte;
		sLower -= xbyte;
		dUpper += xbyte;
		dLower -= xbyte;
	}
}


//ӥåȥޥåפ90ٲžԡ
//򺸲ĥ󡢥ǥƥ͡Ǿ饤󤫤鲣
//                 
//                        
//                 
//                    
//
void g_bmp_rot90(int sx,int sy,const unsigned char *s,int& dx,int& dy,unsigned char *d)
{
	dy = sx;
	dx = sy;
	int sxbyte=((sx+15)/16)*2;
	int dxbyte=((dx+15)/16)*2;
	int x,y;
	unsigned char* pch=d;
	for(y=0;y<dy;y++){
		for(x=0;x<dxbyte;x++){
			*pch++=0;
		}
	}


	unsigned char bitSrc,bitDst;
	const unsigned char* pSrcTop=s + sxbyte*(sy-1);	//ΥХȤؤ
	unsigned char* pDstTop=d;						//ΥХȤؤ
	bitSrc=0x80;
	for(x=0;x<sx;x++){
		const unsigned char* pSrc=pSrcTop;
		unsigned char* pDst=pDstTop;
		*pDst=0;
		bitDst=0x80;
		for(y=0;y<sy;y++){
			if(bitDst==0x80) *pDst=0;		//
			if(*pSrc & bitSrc) *pDst |= bitDst;
			pSrc-=sxbyte;		//1˰ư
			if(bitDst==0x01){	//ǥƥ͡ϺΥӥåȤ˰ư
				bitDst=0x80;	//٤ΥХȤ˰ܤȤ
				pDst++;
//				*pDst=0;		//ܤäΥХȤ
			}else{
				bitDst>>=1;
			}
		}
		//󤬽ä
		if(bitSrc==0x01){		//٤ΥӥåȤ˰ư
			bitSrc=0x80;
			pSrcTop++;
		}else{
			bitSrc>>=1;
		}
		pDstTop+=dxbyte;		//ǥƥ͡򼡤ιԤ˰ư
	}
}



//ӥåȥޥåפ270ٲžԡ
//򺸾夫ĥ󡢥ǥƥ͡򺸲鲣
//                 
//                        
//                 
//                    
//                 
void g_bmp_rot270(int sx,int sy,const unsigned char *s,int& dx,int& dy,unsigned char *d)
{
	dy = sx;
	dx = sy;
	int sxbyte=((sx+15)/16)*2;
	int dxbyte=((dx+15)/16)*2;
	int x,y;
	unsigned char* pch=d;
	for(y=0;y<dy;y++){
		for(x=0;x<dxbyte;x++){
			*pch++=0;
		}
	}


	unsigned char bitSrc,bitDst;
	const unsigned char* pSrcTop=s;	//ΥХȤؤ
	unsigned char* pDstTop=d+dxbyte*(dy-1);//ΥХȤؤ
	bitSrc=0x80;
	for(x=0;x<sx;x++){
		const unsigned char* pSrc=pSrcTop;
		unsigned char* pDst=pDstTop;
		*pDst=0;
		bitDst=0x80;
		for(y=0;y<sy;y++){
			if(bitDst==0x80) *pDst=0;		//
			if(*pSrc & bitSrc) *pDst |= bitDst;
			pSrc+=sxbyte;		//1󲼤˰ư
			if(bitDst==0x01){	//ǥƥ͡ϱΥӥåȤ˰ư
				bitDst=0x80;	//٤ΥХȤ˰ܤȤ
				pDst++;
			}else{
				bitDst>>=1;
			}
		}
		//󤬽ä
		if(bitSrc==0x01){		//٤ΥӥåȤ˰ư
			bitSrc=0x80;
			pSrcTop++;
		}else{
			bitSrc>>=1;
		}
		pDstTop-=dxbyte;		//ǥƥ͡򼡤ιԤ˰ư
	}
}

void g_put_bmp(
		QPainter* pPainter,			//
		int x,
		int y,						//ϰ
		const unsigned char* bitmap,			//Ϥӥåȥޥå(ɥ饤 Υ)
		int w,						//ԥ
		int h,						//ԥ
		int dir,					//
		int scale,					// 1,2,5Τɤ줫
		int scaleMul,					// 1,2,5Τɤ줫
		const QColor& color,		//Ͽ
		unsigned  nMode				//⡼
		)
{
	const unsigned char* srcbmp;
	QColor col;	
	srcbmp = bitmap;
		
/*	
	switch(scale){
	case 1:
		srcbmp = bitmap;
		break;
	case 2:
		g_bmp_50percent(w,h,bitmap,w,h,bmpworkarea.buff1);
		srcbmp = bmpworkarea.buff1;
		break;
	case 5:
		g_bmp_20percent(w,h,bitmap,w,h,bmpworkarea.buff1);
		srcbmp = bmpworkarea.buff1;
		break;
	default:
		return;
	}
*/
	switch(dir){
	case 0:
		break;
	case 1:	// 1  0 90ٲž
		g_bmp_rot90(w,h,srcbmp,w,h,bmpworkarea.buff0);
		srcbmp = bmpworkarea.buff0;
		break;
	case 2: // 2  0 岼ȿž
		g_bmp_vhmirror(w,h,srcbmp,bmpworkarea.buff0);
		srcbmp = bmpworkarea.buff0;
		break;
	case 3: // 3  0 270ٲž
//		g_bmp_rot90(w,h,srcbmp,w,h,bmpworkarea.buff0);
//		g_bmp_vhmirror(w,h,bmpworkarea.buff0,bmpworkarea.buff0);
		g_bmp_rot270(w,h,srcbmp,w,h,bmpworkarea.buff0);
		srcbmp = bmpworkarea.buff0;
		break;
	case 4: // 4  0 򺸱ȿž
		g_bmp_hmirror(w,h,srcbmp,bmpworkarea.buff0);
		srcbmp = bmpworkarea.buff0;
		break;
	case 5: // 5  0 90ٲžΤ򺸱ȿž
		g_bmp_rot90(w,h,srcbmp,w,h,bmpworkarea.buff0);
		g_bmp_hmirror(w,h,bmpworkarea.buff0,bmpworkarea.buff0);
		srcbmp = bmpworkarea.buff0;
		break;
	case 6: // 6  0 岼ȿž
		g_bmp_vmirror(w,h,srcbmp,bmpworkarea.buff0);
		srcbmp = bmpworkarea.buff0;
		break;
	case 7: // 7  0 90ٲžΤ岼ȿž
		g_bmp_rot90(w,h,srcbmp,w,h,bmpworkarea.buff0);
		g_bmp_vmirror(w,h,bmpworkarea.buff0,bmpworkarea.buff0);
		srcbmp = bmpworkarea.buff0;
		break;
	default:
		return;
	}
	
	int buffPixelWidth = ((w+15)/16)*16;
	if(dir==2 || dir==4 ||dir==5){
		x += (w-buffPixelWidth);
	}


	
	switch(nMode & 0xffff){
	  case DRAW_ON:
		col = color;
		break;

	  case DRAW_OFF:
		col =QColor("white");
		break;

	  case DRAW_MONO:
		col = QColor("black");
		break;

	case DRAW_TEMP:
		col = color;
		break;

	}
	
	x=x*scaleMul / scale - scaleMul / (scale*2);
	y=y*scaleMul / scale - scaleMul / (scale*2);
	double mag=1.0*scaleMul/scale;	
#ifdef Q_WS_MACX
	QBitmap bmp(buffPixelWidth,h,srcbmp,false);	
	QRegion region(bmp);
	pPainter->save();
	pPainter->translate(x,y);
	pPainter->scale(mag,mag);	
	pPainter->setClipRegion(region);
	pPainter->fillRect(0,0,buffPixelWidth,h,QBrush (col));
	pPainter->restore();
#else	
	QBitmap bmp(buffPixelWidth,h,srcbmp,false);	
	QPixmap Pmp(buffPixelWidth,h);
	Pmp.fill(col);
	Pmp.setMask(bmp);
	pPainter->save();
	pPainter->translate(x,y);
	pPainter->scale(mag,mag);	
	pPainter->drawPixmap(0,0,Pmp);
	pPainter->restore();
#endif
	
	
	return;
}
