/****************************************************************************
    Qt-LCoV Library Editor for Qt-BSch3V
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#ifndef APPLICATION_H
#define APPLICATION_H

#include <q3mainwindow.h>
//Added by qt3to4:
#include <QGridLayout>
#include <QKeyEvent>
#include <Q3PopupMenu>
#include <QCloseEvent>

class Q3TextEdit;
class QToolButton;
class QGridLayout;
//class QVBoxLayout;
//class QHBoxLayout;
class Q3ListBox;
class Q3PopupMenu;

class SComponentView;
class QAction;


#include <qwidget.h>

#include "lcovdoc.h"

class ApplicationWindow: public Q3MainWindow
{
    Q_OBJECT

public:
    ApplicationWindow();
    ~ApplicationWindow();
	
	QString fileName();

protected:
	void keyPressEvent ( QKeyEvent * e );
	void closeEvent( QCloseEvent* );
	void setAppCaption(const QString &fileName );	//ץꥱΥץΥå
	void setCompIndexToListBox();		//ʥǥåꥹȥܥå˥å
	
	void doSave(); //ե¸μº
	void doComponentCopy(); //ComponentCopyμº
	void doComponentDelete(); //ComponentDeleteκ
	void doComponentPaste(); //ComponentPasteμº

	void redrawAll();
	
	void setToolButtonState();//ܥξ֤
	
private slots:
	void newDoc();
	void choose();
	void load( const QString &fileName );
	void save(); // FILE-SAVE ϥɥ
	void saveAs(); // FILE-SAVE AS ϥɥ
	//void print();
	
	void editUndo(); //EDIT-Undo  ϥɥ
	void editCut(); //EDIT-Cut  ϥɥ
	void editCopy(); //EDIT-Copy  ϥɥ
	void editPaste(); //EDIT-Paste  ϥɥ
	void editDelete(); //EDIT-Delete  ϥɥ
	void editMirror(); //EDIT- Mirror ϥɥ
	void editRotate(); //EDIT-Rotate  ϥɥ
	void editProperty(); //EDIT-Property  ϥɥ
	void editCompCut(); //EDIT-ComponentCut  ϥɥ
	void editCompCopy(); //EDIT-ComponentCopy  ϥɥ
	void editCompPaste(); //EDIT-ComponentPaste  ϥɥ
	void editCompNew(); //EDIT-ComponentNew  ϥɥ
	void editCompProperty(); //EDIT-ComponentProperty  ϥɥ
	void editAddAlias(); //EDIT-AddAlias  ϥɥ
	
	void toolSelect();
	void toolPin();
	void toolLine();
	void toolEllipse();
	void toolPolygon();
	void toolArc();
	void toolHandle();
	void toolText();
	void toolCreateBitPattern();
	
	void listboxSelectionChanged();	//̾ꥹȥܥåѹ줿Ȥ˸ƤФ
	void onButtonUp(); //ưܥ󤬲줿ȤΥϥɥ
	void onButtonDown();	//ưܥ󤬲줿ȤΥϥɥ
	
	//View Menu ϥɥ
	void viewZoomIn();
	void viewZoomOut();
	
	
	//Set Menu ϥɥ
	void setFont();
	
	//Window Menu ϥɥ
	void setupWindowMenu(); //Window˥塼Υߥ󥰤
	void selectActiveDocument(QAction* action); //Window˥塼Υƥब򤵤줿ȤSLOT

	
    void about();
    void aboutQt();

private:
    //QPrinter *printer;
    QString m_filename;
	
	QFont* fontMenuBar;
	
	QToolButton* m_ptbToolSelect;
	QToolButton* m_ptbToolPin;
	QToolButton* m_ptbToolLine;
	QToolButton* m_ptbToolEllipse;
	QToolButton* m_ptbToolPolygon;
	QToolButton* m_ptbToolArc;
	QToolButton* m_ptbToolHandle;
	QToolButton* m_ptbToolText;
	
	QWidget* m_mainWidget;
	
	QGridLayout* m_gridLayout;
	
	QToolButton* m_buttonUp;
	QToolButton* m_buttonDown;
	
	QMenu* m_menuWindow;	//Window˥塼
	Q3ListBox* m_componentListBox;	//̾ꥹȥܥå
	
	SComponentView* m_componentView;
	
	QAction* m_menuActionToolSelect;
	QAction* m_menuActionToolPin;
	QAction* m_menuActionToolLine;
	QAction* m_menuActionToolEllipse;
	QAction* m_menuActionToolPolygon;
	QAction* m_menuActionToolArc;
	QAction* m_menuActionToolHandle;
	QAction* m_menuActionToolText;
	
	
	
//Static Сѿ
	static QWidgetList m_appWindowList;
	
	SLCoVDoc m_LCoVDoc;

	
};


#endif
