/***************************************************************************
 *   Copyright (C) 2006-2008 by Tomasz Moń                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; under version 2 of the License.         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#ifndef SETTINGS_H
#define SETTINGS_H

#include "ui_settingsWin.h"
#include <QApplication>
#include <QtGui>

class QTScrob;

class Settings : public QDialog, private Ui::settingsWin {
		Q_OBJECT
	private:
		QTScrob *qtscrob;

	private slots:
		void winauthchanged(int);

	public:
		Settings(QTScrob *parent = 0);

	public slots:
		QString username();
		QString password();
		int utc_offset();
		bool tz_override();
		bool checkAutoOpen();
		bool checkDelPlayList();
		QString proxy_host();
		int proxy_port();
		QString proxy_user();
		QString proxy_pass();
		bool proxy_winauth();
};

#endif
