# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

require "tmail"
require File.join(File.dirname(__FILE__), "read-buckets-to-buffer")

class MessageRfc822
  SUPPORTED_VERSION = 1
  MIME_TYPE = "message/rfc822"

  include ReadBucketsToBuffer

  def process_buffer(filter, mime_type)
    mail = TMail::Mail.parse(@buffer)
    db_encoding = filter.db_encoding
    input_encoding = get_charset(mime_type) || mail.charset || db_encoding
    rename_properties = {"from" => "author", "subject" => "title"}
    ["from", "to", "subject"].each do |name|
      value = mail.header_string(name)
      if value
        value = Rast::EncodingConverter.convert_encoding(input_encoding,
                                                         db_encoding,
                                                         value)
        filter.set_property(name, value)
        if rename_properties[name]
          filter.set_property(rename_properties[name], value)
        end
      end
    end

    next_brigade = Rast::Brigade.new
    next_brigade.insert_tail(Rast::TransientBucket.new(mail.body))
    next_brigade.insert_tail(Rast::EOSBucket.new)
    filter.pass(next_brigade, "text/plain")
  end

  private

  def get_charset(mime_type)
    if match_data = /; charset=/i.match(mime_type)
      return match_data.post_match
    else
      return nil
    end
  end
end
