/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import netrexx.lang.Rexx;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class NetRexxC
extends MatchingTask {
    private boolean binary;
    private String classpath;
    private boolean comments;
    private boolean compact;
    private boolean compile = true;
    private boolean console;
    private boolean crossref;
    private boolean decimal = true;
    private File destDir;
    private boolean diag;
    private boolean explicit;
    private boolean format;
    private boolean java;
    private boolean keep;
    private boolean logo = true;
    private boolean replace;
    private boolean savelog;
    private File srcDir;
    private boolean sourcedir = true;
    private boolean strictargs;
    private boolean strictassign;
    private boolean strictcase;
    private boolean strictimport;
    private boolean strictprops;
    private boolean strictsignal;
    private boolean symbols;
    private boolean time;
    private String trace = "trace2";
    private boolean utf8;
    private String verbose = "verbose3";
    private Vector compileList = new Vector();
    private Hashtable filecopyList = new Hashtable();
    private String oldClasspath = System.getProperty("java.class.path");

    public void setBinary(boolean bl) {
        this.binary = bl;
    }

    public void setClasspath(String string) {
        this.classpath = string;
    }

    public void setComments(boolean bl) {
        this.comments = bl;
    }

    public void setCompact(boolean bl) {
        this.compact = bl;
    }

    public void setCompile(boolean bl) {
        this.compile = bl;
        if (!this.compile && !this.keep) {
            this.keep = true;
        }
    }

    public void setConsole(boolean bl) {
        this.console = bl;
    }

    public void setCrossref(boolean bl) {
        this.crossref = bl;
    }

    public void setDecimal(boolean bl) {
        this.decimal = bl;
    }

    public void setDestDir(String string) {
        this.destDir = ((Task)this).project.resolveFile(string);
    }

    public void setDiag(boolean bl) {
        this.diag = bl;
    }

    public void setExplicit(boolean bl) {
        this.explicit = bl;
    }

    public void setFormat(boolean bl) {
        this.format = bl;
    }

    public void setJava(boolean bl) {
        this.java = bl;
    }

    public void setKeep(boolean bl) {
        this.keep = bl;
    }

    public void setLogo(boolean bl) {
        this.logo = bl;
    }

    public void setReplace(boolean bl) {
        this.replace = bl;
    }

    public void setSavelog(boolean bl) {
        this.savelog = bl;
    }

    public void setSourcedir(boolean bl) {
        this.sourcedir = bl;
    }

    public void setSrcDir(String string) {
        this.srcDir = ((Task)this).project.resolveFile(string);
    }

    public void setStrictargs(boolean bl) {
        this.strictargs = bl;
    }

    public void setStrictassign(boolean bl) {
        this.strictassign = bl;
    }

    public void setStrictcase(boolean bl) {
        this.strictcase = bl;
    }

    public void setStrictimport(boolean bl) {
        this.strictimport = bl;
    }

    public void setStrictprops(boolean bl) {
        this.strictprops = bl;
    }

    public void setStrictsignal(boolean bl) {
        this.strictsignal = bl;
    }

    public void setSymbols(boolean bl) {
        this.symbols = bl;
    }

    public void setTime(boolean bl) {
        this.time = bl;
    }

    public void setTrace(String string) {
        if (!(string.equalsIgnoreCase("trace") || string.equalsIgnoreCase("trace1") || string.equalsIgnoreCase("trace2") || string.equalsIgnoreCase("notrace"))) {
            throw new BuildException("Unknown trace value specified: '" + string + "'");
        }
        this.trace = string;
    }

    public void setUtf8(boolean bl) {
        this.utf8 = bl;
    }

    public void setVerbose(String string) {
        this.verbose = string;
    }

    public void execute() throws BuildException {
        if (this.srcDir == null || this.destDir == null) {
            throw new BuildException("srcDir and destDir attributes must be set!");
        }
        DirectoryScanner directoryScanner = this.getDirectoryScanner(this.srcDir);
        String[] stringArray = directoryScanner.getIncludedFiles();
        this.scanDir(this.srcDir, this.destDir, stringArray);
        this.copyFilesToDestination();
        if (this.compileList.size() > 0) {
            this.log("Compiling " + this.compileList.size() + " source file" + (this.compileList.size() == 1 ? "" : "s") + " to " + this.destDir);
            this.doNetRexxCompile();
        }
    }

    private void scanDir(File file, File file2, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            File file3 = new File(file, stringArray[n]);
            File file4 = new File(file2, stringArray[n]);
            String string = stringArray[n];
            if (string.toLowerCase().endsWith(".nrx")) {
                File file5 = new File(file2, string.substring(0, string.lastIndexOf(46)) + ".class");
                if (!this.compile || file3.lastModified() > file5.lastModified()) {
                    this.filecopyList.put(file3.getAbsolutePath(), file4.getAbsolutePath());
                    this.compileList.addElement(file4.getAbsolutePath());
                }
            } else if (file3.lastModified() > file4.lastModified()) {
                this.filecopyList.put(file3.getAbsolutePath(), file4.getAbsolutePath());
            }
            ++n;
        }
    }

    private void copyFilesToDestination() {
        if (this.filecopyList.size() > 0) {
            this.log("Copying " + this.filecopyList.size() + " file" + (this.filecopyList.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            Enumeration enumeration = this.filecopyList.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this.filecopyList.get(string);
                try {
                    ((Task)this).project.copyFile(string, string2);
                }
                catch (IOException iOException) {
                    String string3 = "Failed to copy " + string + " to " + string2 + " due to " + iOException.getMessage();
                    throw new BuildException(string3, (Throwable)iOException);
                }
            }
        }
    }

    private void doNetRexxCompile() throws BuildException {
        this.log("Using NetRexx compiler", 3);
        String string = this.getCompileClasspath();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String[] stringArray = this.getCompileOptionsAsArray();
        String[] stringArray2 = new String[this.compileList.size()];
        Enumeration enumeration = this.compileList.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray2[n] = (String)enumeration.nextElement();
            ++n;
        }
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray3[n2] = stringArray[n2];
            ++n2;
        }
        int n3 = 0;
        while (n3 < stringArray2.length) {
            stringArray3[n3 + stringArray.length] = stringArray2[n3];
            ++n3;
        }
        stringBuffer.append("Compilation args: ");
        int n4 = 0;
        while (n4 < stringArray.length) {
            stringBuffer.append(stringArray[n4]);
            stringBuffer.append(" ");
            ++n4;
        }
        this.log(stringBuffer.toString(), 3);
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer3 = new StringBuffer("Files to be compiled:" + string2);
        int n5 = 0;
        while (n5 < this.compileList.size()) {
            stringBuffer3.append("    ");
            stringBuffer3.append(this.compileList.elementAt(n5).toString());
            stringBuffer3.append(string2);
            ++n5;
        }
        this.log(stringBuffer3.toString(), 3);
        String string3 = System.getProperty("java.class.path");
        Properties properties = System.getProperties();
        ((Hashtable)properties).put("java.class.path", string);
        try {
            StringWriter stringWriter = new StringWriter();
            int n6 = COM.ibm.netrexx.process.NetRexxC.main((Rexx)new Rexx(stringArray3), (PrintWriter)new PrintWriter(stringWriter));
            if (n6 > 1) {
                this.log(stringWriter.toString(), 0);
                String string4 = "Compile failed, messages should have been provided.";
                throw new BuildException(string4);
            }
            if (n6 == 1) {
                this.log(stringWriter.toString(), 1);
            } else {
                this.log(stringWriter.toString(), 2);
            }
            Object var21_20 = null;
        }
        catch (Throwable throwable) {
            Object var21_21 = null;
            properties = System.getProperties();
            ((Hashtable)properties).put("java.class.path", string3);
            throw throwable;
        }
        properties = System.getProperties();
        ((Hashtable)properties).put("java.class.path", string3);
    }

    private String getCompileClasspath() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.destDir.getAbsolutePath());
        if (this.classpath != null) {
            this.addExistingToClasspath(stringBuffer, this.classpath);
        }
        return stringBuffer.toString();
    }

    private String[] getCompileOptionsAsArray() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(this.binary ? "-binary" : "-nobinary");
        vector.addElement(this.comments ? "-comments" : "-nocomments");
        vector.addElement(this.compile ? "-compile" : "-nocompile");
        vector.addElement(this.compact ? "-compact" : "-nocompact");
        vector.addElement(this.console ? "-console" : "-noconsole");
        vector.addElement(this.crossref ? "-crossref" : "-nocrossref");
        vector.addElement(this.decimal ? "-decimal" : "-nodecimal");
        vector.addElement(this.diag ? "-diag" : "-nodiag");
        vector.addElement(this.explicit ? "-explicit" : "-noexplicit");
        vector.addElement(this.format ? "-format" : "-noformat");
        vector.addElement(this.keep ? "-keep" : "-nokeep");
        vector.addElement(this.logo ? "-logo" : "-nologo");
        vector.addElement(this.replace ? "-replace" : "-noreplace");
        vector.addElement(this.savelog ? "-savelog" : "-nosavelog");
        vector.addElement(this.sourcedir ? "-sourcedir" : "-nosourcedir");
        vector.addElement(this.strictargs ? "-strictargs" : "-nostrictargs");
        vector.addElement(this.strictassign ? "-strictassign" : "-nostrictassign");
        vector.addElement(this.strictcase ? "-strictcase" : "-nostrictcase");
        vector.addElement(this.strictimport ? "-strictimport" : "-nostrictimport");
        vector.addElement(this.strictprops ? "-strictprops" : "-nostrictprops");
        vector.addElement(this.strictsignal ? "-strictsignal" : "-nostrictsignal");
        vector.addElement(this.symbols ? "-symbols" : "-nosymbols");
        vector.addElement(this.time ? "-time" : "-notime");
        vector.addElement("-" + this.trace);
        vector.addElement(this.utf8 ? "-utf8" : "-noutf8");
        vector.addElement("-" + this.verbose);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void addExistingToClasspath(StringBuffer stringBuffer, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("path.separator"), false);
        while (stringTokenizer.hasMoreTokens()) {
            File file = ((Task)this).project.resolveFile(stringTokenizer.nextToken());
            if (file.exists()) {
                stringBuffer.append(File.pathSeparator);
                stringBuffer.append(file.getAbsolutePath());
                continue;
            }
            this.log("Dropping from classpath: " + file.getAbsolutePath(), 3);
        }
    }
}

