/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.depend.constantpool;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ClassCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPool;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.DoubleCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.FieldRefCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.FloatCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.IntegerCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.InterfaceMethodRefCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.LongCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.MethodRefCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.NameAndTypeCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.StringCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.Utf8CPInfo;

public abstract class ConstantPoolEntry {
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_FieldRef = 9;
    public static final int CONSTANT_MethodRef = 10;
    public static final int CONSTANT_InterfaceMethodRef = 11;
    public static final int CONSTANT_NameAndType = 12;
    private int tag;
    private int numEntries;
    private boolean resolved;

    public ConstantPoolEntry(int n, int n2) {
        this.tag = n;
        this.numEntries = n2;
        this.resolved = false;
    }

    public static ConstantPoolEntry readEntry(DataInputStream dataInputStream) throws IOException {
        ConstantPoolEntry constantPoolEntry = null;
        int n = dataInputStream.readUnsignedByte();
        switch (n) {
            case 1: {
                constantPoolEntry = new Utf8CPInfo();
                break;
            }
            case 3: {
                constantPoolEntry = new IntegerCPInfo();
                break;
            }
            case 4: {
                constantPoolEntry = new FloatCPInfo();
                break;
            }
            case 5: {
                constantPoolEntry = new LongCPInfo();
                break;
            }
            case 6: {
                constantPoolEntry = new DoubleCPInfo();
                break;
            }
            case 7: {
                constantPoolEntry = new ClassCPInfo();
                break;
            }
            case 8: {
                constantPoolEntry = new StringCPInfo();
                break;
            }
            case 9: {
                constantPoolEntry = new FieldRefCPInfo();
                break;
            }
            case 10: {
                constantPoolEntry = new MethodRefCPInfo();
                break;
            }
            case 11: {
                constantPoolEntry = new InterfaceMethodRefCPInfo();
                break;
            }
            case 12: {
                constantPoolEntry = new NameAndTypeCPInfo();
                break;
            }
            default: {
                throw new ClassFormatError("Invalid Constant Pool entry Type " + n);
            }
        }
        constantPoolEntry.read(dataInputStream);
        return constantPoolEntry;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void resolve(ConstantPool constantPool) {
        this.resolved = true;
    }

    public abstract void read(DataInputStream var1) throws IOException;

    public int getTag() {
        return this.tag;
    }

    public final int getNumEntries() {
        return this.numEntries;
    }
}

