/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.dotnet;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;

public class NetCommand {
    protected Task _owner;
    protected Execute _exe;
    protected Commandline _commandLine;
    protected String _title;
    protected String _program;
    protected boolean _traceCommandLine = false;
    protected boolean _failOnError;

    public NetCommand(Task task, String string, String string2) {
        this._owner = task;
        this._title = string;
        this._program = string2;
        this._commandLine = new Commandline();
        this._commandLine.setExecutable(this._program);
        this.prepareExecutor();
    }

    public void setTraceCommandLine(boolean bl) {
        this._traceCommandLine = bl;
    }

    public void setFailOnError(boolean bl) {
        this._failOnError = bl;
    }

    public boolean getFailFailOnError() {
        return this._failOnError;
    }

    protected void logVerbose(String string) {
        this._owner.getProject().log(string, 3);
    }

    protected void logError(String string) {
        this._owner.getProject().log(string, 0);
    }

    public void addArgument(String string) {
        if (string != null && string.length() != 0) {
            this._commandLine.createArgument().setValue(string);
        }
    }

    protected void prepareExecutor() {
        File file = this._owner.getProject().getBaseDir();
        LogStreamHandler logStreamHandler = new LogStreamHandler(this._owner, 2, 1);
        this._exe = new Execute((ExecuteStreamHandler)logStreamHandler, null);
        this._exe.setAntRun(this._owner.getProject());
        this._exe.setWorkingDirectory(file);
    }

    public void runCommand() throws BuildException {
        int n = -1;
        try {
            if (this._traceCommandLine) {
                this._owner.log(this._commandLine.toString());
            } else {
                this.logVerbose(this._commandLine.toString());
            }
            this._exe.setCommandline(this._commandLine.getCommandline());
            n = this._exe.execute();
            if (n != 0) {
                if (this._failOnError) {
                    throw new BuildException(this._title + " returned: " + n, this._owner.getLocation());
                }
                this._owner.log(this._title + "  Result: " + n, 0);
            }
        }
        catch (IOException iOException) {
            throw new BuildException(this._title + " failed: " + iOException, (Throwable)iOException, this._owner.getLocation());
        }
    }
}

