/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;

public class SummaryJUnitResultFormatter
implements JUnitResultFormatter {
    private NumberFormat nf = NumberFormat.getInstance();
    private OutputStream out;

    public void startTestSuite(JUnitTest jUnitTest) {
    }

    public void startTest(Test test) {
    }

    public void endTest(Test test) {
    }

    public void addFailure(Test test, Throwable throwable) {
    }

    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
        this.addFailure(test, (Throwable)assertionFailedError);
    }

    public void addError(Test test, Throwable throwable) {
    }

    public void setOutput(OutputStream outputStream) {
        this.out = outputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endTestSuite(JUnitTest jUnitTest) throws BuildException {
        StringBuffer stringBuffer = new StringBuffer("Tests run: ");
        stringBuffer.append(jUnitTest.runCount());
        stringBuffer.append(", Failures: ");
        stringBuffer.append(jUnitTest.failureCount());
        stringBuffer.append(", Errors: ");
        stringBuffer.append(jUnitTest.errorCount());
        stringBuffer.append(", Time elapsed: ");
        stringBuffer.append(this.nf.format((double)jUnitTest.getRunTime() / 1000.0));
        stringBuffer.append(" sec");
        stringBuffer.append(System.getProperty("line.separator"));
        try {
            try {
                this.out.write(stringBuffer.toString().getBytes());
                this.out.flush();
            }
            catch (IOException iOException) {
                throw new BuildException("Unable to write summary output", (Throwable)iOException);
            }
            Object var5_3 = null;
            if (this.out == System.out) return;
            if (this.out == System.err) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (this.out == System.out) throw throwable;
            if (this.out == System.err) throw throwable;
            try {
                this.out.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        this.out.close();
        return;
    }
}

