/****************************************************************************
** Créé par Anacr0x : anacr0x@free.fr
**
** Sous licence GPL v2 ou plus
****************************************************************************/

#ifndef BASICTREEWIDGET_H
#define BASICTREEWIDGET_H

#include <QTreeWidget>
#include <QMouseEvent>

/*************************************************************************/
//! Simplifie l'utilisation d'un QTreeWidget

/*! BasicTreeWidget rajoute simplement quelques fonctions pratiques au
   QTreeWidget de Qt. */
/*************************************************************************/

class BasicTreeWidget:public QTreeWidget
{
	Q_OBJECT

public:
	/*! Le constructeur */
	BasicTreeWidget (QWidget *parent) : QTreeWidget(parent)
	{}
	;

	/*! Récupère un pointeur sur le premier item sélectionné */
	inline QTreeWidgetItem* firstSelectedItem ()
	{
		QList<QTreeWidgetItem*> list = selectedItems ();
		if (!list.isEmpty ())
			return list.first ();
		else
			return NULL;
	}

	/*! Renvoit la liste des items de la liste */
	inline QList<QTreeWidgetItem*> itemsList ()
	{
		return findItems("", Qt::MatchContains);
	}

signals:
	/*! Si un clic */
	void buttonClickedOnVoid ();

	/*! Si clic gauche */
	void leftButtonClickedOnVoid ();

	/*! Si clic droit */
	void rightButtonClickedOnVoid (QPoint);

	/*! Si clic du milieu */
	void middleButtonClickedOnVoid (QPoint);

	/*! Si un clic sur un item */
	void buttonClickedOnItem (QTreeWidgetItem *);

	/*! Si clic gauche sur un item */
	void leftButtonClickedOnItem (QTreeWidgetItem *);

	/*! Si clic droit sur un item */
	void rightButtonClickedOnItem (QTreeWidgetItem *, QPoint);

	/*! Si clic du milieu sur un item */
	void middleButtonClickedOnItem (QTreeWidgetItem *, QPoint);

	/*! Si double clic sur un item */
	void doubleClickedOnItem (QTreeWidgetItem *);

	/*! Si un clic sur un item ou non*/
	void buttonClicked (QTreeWidgetItem *);

	/*! Si clic gauche sur un item ou non */
	void leftButtonClicked (QTreeWidgetItem *);

	/*! Si clic droit sur un item ou non */
	void rightButtonClicked (QTreeWidgetItem *, QPoint);

	/*! Si clic du milieu sur un item ou non */
	void middleButtonClicked (QTreeWidgetItem *, QPoint);

private:
	/*! Utilisé pour récupérer les clics de souris */
	void mousePressEvent (QMouseEvent *event);

	/*! Utilisé pour récupérer les doubles clics de souris */
	void mouseDoubleClickEvent (QMouseEvent *event);
};

#endif
