/****************************************************************************
** Liste des signets FTP pour Scythia
** Créé par Anacr0x : anacr0x@free.fr
**
** Sous licence GPL v2 ou plus
****************************************************************************/

#include "liste_signet.h"

extern QString CheminConf;

int ListeSignet::DebutItem(int nb)
{
	if (nb == 0)
		return 0;

	// On regarde où se situe le début de l'item dans la liste
	int debut = 0;
	for (int i = 0; i < nb * NB_PARAM; i++)
		debut = list.indexOf('\n', debut + 1);

	return debut + 1;
}

QString ListeSignet::Crypte(const QString & str, int code)
{
	// Si aucun caractère, on quitte
	int len = str.length();
	if (!len)
		return "";

	// On crée une autre chaîne de la même taille
	QString crypte = str;
	// On crypte str et la met dans crypte
	/*-------- Algo de cryptage méga simple--------*/
	for (int i = 0; i < len; i++)
		crypte[i] = QChar(str[i].toAscii() + code);
	/*--------------------------------------------*/
	// On renvoi la chaîne cryptée
	return crypte;
}

ListeSignet::ListeSignet()
{
	// Ouvre le fichier en lecture seule
	QFile conf(CheminConf + "scythia-signets");
	if (conf.open(QIODevice::ReadOnly))
	{
		// Lit tout le fichier et le met dans la liste (restaure l'ancienne liste)
		list = QString(conf.readAll());

		conf.close();
	}
	else
		list = "";
}

bool ListeSignet::CreerFichier()
{
	// Ouvre le fichier en écriture seule
	QFile conf(CheminConf + "scythia-signets");
	if (conf.open(QIODevice::WriteOnly))
	{
		// Ecrit toute la liste dans le fichier et ferme
		conf.write(list.toLocal8Bit(), list.size());
		conf.close();
		return true;
	}
	return false;
}

int ListeSignet::NbItem()
{
	// Compte le nombre de '\n' dans la liste
	int nb = list.count('\n');
	// Et divise par NB_PARAM pour avoir le nombre d'item
	return nb / NB_PARAM;
}

int ListeSignet::IdentifiantToItem(const QString & Identifiant)
{
	// On regarde où se situe le début de l'item dans la liste
	int debut = list.indexOf(Identifiant);
	if (debut == -1)
		return -1;

	QString tmp = list;
	tmp.truncate(debut);
	// Compte le nb de '\n' dans la liste
	int nb = tmp.count('\n');
	// Et divise par NB_PARAM pour avoir le nb de l'item
	return nb / NB_PARAM;
}

QString ListeSignet::RecupIdentifiant(int nb)
{
	QString Ident = list.section('\n', NB_PARAM * nb, NB_PARAM * nb);
	// On enlève le '[' et le ']' avant de le passer
	Ident.truncate(Ident.size() - 1);
	return Ident.remove(0, 1);
}

void ListeSignet::Ajouter(const QString & Identifiant, const QString & Login,
                          const QString & Hote, const QString & MotDePasse, int Port,
                          const QString & TransferMode, const QString & ProxyName,
                          int ProxyPort)
{
	list.append('[');
	list.append(Identifiant);
	list.append("]\n");
	list.append(Login);
	list.append('\n');
	list.append(Hote);
	list.append('\n');
	list.append(Crypte(MotDePasse, 1));
	list.append('\n');
	list.append(QString::number(Port));
	list.append('\n');
	list.append(TransferMode);
	list.append('\n');
	list.append(ProxyName);
	list.append('\n');
	list.append(QString::number(ProxyPort));
	list.append('\n');
}

void ListeSignet::Supprimer(int nb)
{
	// On regarde où se situe le début de l'item dans la liste
	int debut = DebutItem(nb);
	// On calcule sa taille
	int len =
	    list.section('\n', NB_PARAM * nb, NB_PARAM * nb + NB_PARAM - 1).size() + 1;
	// On vire à partir du début de l'item et sur toute la longueur de sa taille
	list.remove(debut, len);
}

void ListeSignet::ModifItem(int nb, const QString & Identifiant,
                            const QString & Login, const QString & Hote,
                            const QString & MotDePasse, int Port,
                            const QString & TransferMode, const QString & ProxyName,
                            int ProxyPort)
{
	// On crée l'item
	QString temp;
	temp.append('[');
	temp.append(Identifiant);
	temp.append("]\n");
	temp.append(Login);
	temp.append('\n');
	temp.append(Hote);
	temp.append('\n');
	temp.append(Crypte(MotDePasse, 1));
	temp.append('\n');
	temp.append(QString::number(Port));
	temp.append('\n');
	temp.append(TransferMode);
	temp.append('\n');
	temp.append(ProxyName);
	temp.append('\n');
	temp.append(QString::number(ProxyPort));
	temp.append('\n');

	// On regarde où se situe le début de l'item dans la liste
	int debut = DebutItem(nb);
	// On calcule sa taille
	int len =
	    list.section('\n', NB_PARAM * nb, NB_PARAM * nb + NB_PARAM - 1).size() + 1;

	// On remplace l'ancien par le nouveau
	list.replace(debut, len, temp);
}
