/*                                                     -*- linux-c -*-
    Copyright (C) 2004 Tom Szilagyi

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: export.c,v 1.3 2004/06/12 13:56:46 tszilagyi Exp $
*/


#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>

#include "common.h"
#include "file_io.h"
#include "gui_ext.h"
#include "export.h"


extern GtkWidget * export_button;


GtkWidget * export_window;
GtkWidget * entry_path_save;
GtkWidget * entry_exp_h;
GtkWidget * entry_exp_rdf;


int
export_window_close(GtkWidget *widget, gpointer * data) {

	gtk_widget_set_sensitive(GTK_WIDGET(export_button), TRUE);
	return 0;
}


void
export_clicked_close(GtkWidget *widget, gpointer * data) {

        gtk_widget_destroy(export_window);
        gtk_widget_set_sensitive(GTK_WIDGET(export_button), TRUE);
}

void
export_clicked_save(GtkWidget *widget, gpointer * data) {

	char message[MAXLEN];
	const char * str = gtk_entry_get_text(GTK_ENTRY(entry_path_save));

	if (save_revtypes(str)) {
		sprintf(message, "   Some error occured when attempting to write to %s   ", str);
		message_box("Error", message, export_window, GTK_MESSAGE_ERROR);
	} else {
		sprintf(message, "   Reverb Types were saved to %s   ", str);
		message_box("Notice", message, export_window, GTK_MESSAGE_INFO);
	}
}

void
clicked_exp_h(GtkWidget *widget, gpointer * data) {

	char message[MAXLEN];
	const char * str = gtk_entry_get_text(GTK_ENTRY(entry_exp_h));

	if (write_tap_reverb_presets_h(str)) {
		sprintf(message, "   Some error occured when attempting to write to %s   ", str);
		message_box("Error", message, export_window, GTK_MESSAGE_ERROR);
	} else {
		sprintf(message, "   tap_reverb_presets.h was written to %s   ", str);
		message_box("Notice", message, export_window, GTK_MESSAGE_INFO);
	}
}

void
clicked_exp_rdf(GtkWidget *widget, gpointer * data) {

	char message[MAXLEN];
	const char * str = gtk_entry_get_text(GTK_ENTRY(entry_exp_rdf));

	if (write_tap_reverb_rdf(str)) {
		sprintf(message, "   Some error occured when attempting to write to %s   ", str);
		message_box("Error", message, export_window, GTK_MESSAGE_ERROR);
	} else {
		sprintf(message, "   tap_reverb.rdf was written to %s   ", str);
		message_box("Notice", message, export_window, GTK_MESSAGE_INFO);
	}
}


void
export_setup_dialog(void) {

	GdkColor color;

	GtkWidget * vbox;
	GtkWidget * frame_save;
	GtkWidget * frame_export;
	GtkWidget * vbox_save;
	GtkWidget * table_export;

	GtkWidget * hbox_save;
	GtkWidget * label_descr_save;
	GtkWidget * label_path_save;
	GtkWidget * button_save;

	GtkWidget * label_descr_exp;
	GtkWidget * label_exp_h;
	GtkWidget * button_exp_h;
	GtkWidget * label_exp_rdf;
	GtkWidget * button_exp_rdf;

        GtkWidget * button_close;

	char * home;
	char save_path[MAXLEN];
	char tap_h_path[MAXLEN];
	char tap_rdf_path[MAXLEN];

        if (!(home = getenv("HOME")))
                home = ".";
	sprintf(save_path, "%s/%s", home, NAME_REVERBED);
	sprintf(tap_h_path, "%s/%s", home, NAME_TAP_H);
	sprintf(tap_rdf_path, "%s/%s", home, NAME_TAP_RDF);

        export_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
        color.red = WINDOW_R;
        color.green = WINDOW_G;
        color.blue = WINDOW_B;
        gtk_widget_modify_bg(GTK_WIDGET(export_window), GTK_STATE_NORMAL, &color);
        gtk_window_set_title(GTK_WINDOW(export_window), "Save / Export");
        gtk_window_set_position(GTK_WINDOW(export_window), GTK_WIN_POS_CENTER);
        g_signal_connect(G_OBJECT(export_window), "delete_event", G_CALLBACK(export_window_close), NULL);

	vbox = gtk_vbox_new(FALSE, 4);
        gtk_container_add(GTK_CONTAINER(export_window), vbox);
        gtk_container_set_border_width(GTK_CONTAINER(vbox), 4);
        gtk_widget_show(vbox);

        frame_save = gtk_frame_new("Save");
        gtk_box_pack_start(GTK_BOX(vbox), frame_save, TRUE, TRUE, 2);
        gtk_widget_show(frame_save);

        frame_export = gtk_frame_new("Export");
        gtk_box_pack_start(GTK_BOX(vbox), frame_export, TRUE, TRUE, 2);
        gtk_widget_show(frame_export);

        vbox_save = gtk_vbox_new(FALSE, 3);
        gtk_container_set_border_width(GTK_CONTAINER(vbox_save), 8);
        gtk_container_add(GTK_CONTAINER(frame_save), vbox_save);
        gtk_widget_show(vbox_save);

        table_export = gtk_table_new(3, 3, FALSE);
        gtk_container_add(GTK_CONTAINER(frame_export), table_export);
        gtk_widget_show(table_export);


	label_descr_save = gtk_label_new(
		"Choose a location to save the .reverbed file to. "
		"This file is the one that TAP Reverb Editor uses to store "
		"all data about Reverb Types. It should usually reside in "
		"the home directory of the user running the program, but "
		"you may want to save it in another place. This way you can "
		"maintain different versions of the file for example. "
		"Note, however, that TAP Reverb Editor will always read the file "
		"~/.reverbed (in the home directory of the user running the program) "
		"on program startup.");
	gtk_label_set_line_wrap(GTK_LABEL(label_descr_save), TRUE);
        gtk_box_pack_start(GTK_BOX(vbox_save), label_descr_save, TRUE, TRUE, 2);
        gtk_widget_show(label_descr_save);

        hbox_save = gtk_hbox_new(FALSE, 3);
        gtk_box_pack_start(GTK_BOX(vbox_save), hbox_save, FALSE, TRUE, 2);
        gtk_widget_show(hbox_save);

	label_path_save = gtk_label_new("Save .reverbed to:");
        gtk_box_pack_start(GTK_BOX(hbox_save), label_path_save, FALSE, TRUE, 2);
        gtk_widget_show(label_path_save);

	entry_path_save = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(entry_path_save), save_path);
        gtk_box_pack_start(GTK_BOX(hbox_save), entry_path_save, TRUE, TRUE, 2);
        gtk_widget_show(entry_path_save);

        button_save = gtk_button_new_with_label("Save");
        gtk_box_pack_start(GTK_BOX(hbox_save), button_save, FALSE, TRUE, 2);
        g_signal_connect(G_OBJECT(button_save), "clicked", G_CALLBACK(export_clicked_save), NULL);
        gtk_widget_show(button_save);


	label_descr_exp = gtk_label_new(
		"Exporting refers to the process of making the Reverb Types designed "
		"with this program available to TAP Reverberator, the LADSPA "
		"version of this effect. TAP Reverberator relies on two files, which "
		"reside in the source directory of the TAP-plugins package. By pressing "
		"the buttons below, the program writes the updated version of these files "
		"to a place you specify. Then all you have to do is overwrite the corresponding "
		"files in your TAP-plugins source directory with the newly output files, "
		"and re-compile TAP-plugins. After that you will have the same "
		"set of Reverb Types available in the LADSPA version.");
	gtk_label_set_line_wrap(GTK_LABEL(label_descr_exp), TRUE);
        gtk_table_attach(GTK_TABLE(table_export), label_descr_exp, 0, 3, 0, 1,
                         GTK_FILL, GTK_FILL, 4, 4);
        gtk_widget_show(label_descr_exp);

	label_exp_h = gtk_label_new("Write tap_reverb_presets.h to:");
        gtk_table_attach(GTK_TABLE(table_export), label_exp_h, 0, 1, 1, 2,
                         GTK_FILL, GTK_FILL, 4, 4);
        gtk_widget_show(label_exp_h);

	entry_exp_h = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(entry_exp_h), tap_h_path);
        gtk_table_attach(GTK_TABLE(table_export), entry_exp_h, 1, 2, 1, 2,
                         GTK_FILL | GTK_EXPAND, GTK_FILL, 4, 4);
        gtk_widget_show(entry_exp_h);

        button_exp_h = gtk_button_new_with_label("Export .h");
        gtk_table_attach(GTK_TABLE(table_export), button_exp_h, 2, 3, 1, 2,
                         GTK_FILL, GTK_FILL, 4, 4);
        g_signal_connect(G_OBJECT(button_exp_h), "clicked", G_CALLBACK(clicked_exp_h), NULL);
        gtk_widget_show(button_exp_h);


	label_exp_rdf = gtk_label_new("Write tap_reverb.rdf to:");
        gtk_table_attach(GTK_TABLE(table_export), label_exp_rdf, 0, 1, 2, 3,
                         GTK_FILL, GTK_FILL, 4, 4);
        gtk_widget_show(label_exp_rdf);

	entry_exp_rdf = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(entry_exp_rdf), tap_rdf_path);
        gtk_table_attach(GTK_TABLE(table_export), entry_exp_rdf, 1, 2, 2, 3,
                         GTK_FILL | GTK_EXPAND, GTK_FILL, 4, 4);
        gtk_widget_show(entry_exp_rdf);

        button_exp_rdf = gtk_button_new_with_label("Export .rdf");
        gtk_table_attach(GTK_TABLE(table_export), button_exp_rdf, 2, 3, 2, 3,
                         GTK_FILL, GTK_FILL, 4, 4);
        g_signal_connect(G_OBJECT(button_exp_rdf), "clicked", G_CALLBACK(clicked_exp_rdf), NULL);
        gtk_widget_show(button_exp_rdf);

        button_close = gtk_button_new_with_label("Close");
        gtk_box_pack_start(GTK_BOX(vbox), button_close, FALSE, TRUE, 2);
        g_signal_connect(G_OBJECT(button_close), "clicked", G_CALLBACK(export_clicked_close), NULL);
        gtk_widget_show(button_close);


        color.red = NORMAL_R;
        color.green = NORMAL_G;
        color.blue = NORMAL_B;
        gtk_widget_modify_bg(GTK_WIDGET(button_save), GTK_STATE_NORMAL, &color);
        gtk_widget_modify_bg(GTK_WIDGET(button_exp_h), GTK_STATE_NORMAL, &color);
        gtk_widget_modify_bg(GTK_WIDGET(button_exp_rdf), GTK_STATE_NORMAL, &color);
        gtk_widget_modify_bg(GTK_WIDGET(button_close), GTK_STATE_NORMAL, &color);
        gtk_widget_modify_bg(GTK_WIDGET(entry_exp_h), GTK_STATE_NORMAL, &color);
        gtk_widget_modify_bg(GTK_WIDGET(entry_exp_rdf), GTK_STATE_NORMAL, &color);
        gtk_widget_modify_bg(GTK_WIDGET(entry_path_save), GTK_STATE_NORMAL, &color);
        gtk_widget_modify_bg(GTK_WIDGET(frame_save), GTK_STATE_NORMAL, &color);
        gtk_widget_modify_bg(GTK_WIDGET(frame_export), GTK_STATE_NORMAL, &color);


        color.red = ACTIVE_R;
        color.green = ACTIVE_G;
        color.blue = ACTIVE_B;
        gtk_widget_modify_bg(GTK_WIDGET(button_save), GTK_STATE_ACTIVE, &color);
        gtk_widget_modify_bg(GTK_WIDGET(button_exp_h), GTK_STATE_ACTIVE, &color);
        gtk_widget_modify_bg(GTK_WIDGET(button_exp_rdf), GTK_STATE_ACTIVE, &color);
        gtk_widget_modify_bg(GTK_WIDGET(button_close), GTK_STATE_ACTIVE, &color);
        gtk_widget_modify_bg(GTK_WIDGET(entry_exp_h), GTK_STATE_ACTIVE, &color);
        gtk_widget_modify_bg(GTK_WIDGET(entry_exp_rdf), GTK_STATE_ACTIVE, &color);
        gtk_widget_modify_bg(GTK_WIDGET(entry_path_save), GTK_STATE_ACTIVE, &color);
        gtk_widget_modify_bg(GTK_WIDGET(frame_save), GTK_STATE_ACTIVE, &color);
        gtk_widget_modify_bg(GTK_WIDGET(frame_export), GTK_STATE_ACTIVE, &color);


        color.red = PRELIGHT_R;
        color.green = PRELIGHT_G;
        color.blue = PRELIGHT_B;
        gtk_widget_modify_bg(GTK_WIDGET(button_save), GTK_STATE_PRELIGHT, &color);
        gtk_widget_modify_bg(GTK_WIDGET(button_exp_h), GTK_STATE_PRELIGHT, &color);
        gtk_widget_modify_bg(GTK_WIDGET(button_exp_rdf), GTK_STATE_PRELIGHT, &color);
        gtk_widget_modify_bg(GTK_WIDGET(button_close), GTK_STATE_PRELIGHT, &color);
        gtk_widget_modify_bg(GTK_WIDGET(entry_exp_h), GTK_STATE_PRELIGHT, &color);
        gtk_widget_modify_bg(GTK_WIDGET(entry_exp_rdf), GTK_STATE_PRELIGHT, &color);
        gtk_widget_modify_bg(GTK_WIDGET(entry_path_save), GTK_STATE_PRELIGHT, &color);
        gtk_widget_modify_bg(GTK_WIDGET(frame_save), GTK_STATE_PRELIGHT, &color);
        gtk_widget_modify_bg(GTK_WIDGET(frame_export), GTK_STATE_PRELIGHT, &color);

        gtk_widget_show(export_window);
}
