@nocode MH
= class TMail::Mail

== Class Methods

: new(port = TMail::StringPort.new, config = DEFAULT_CONFIG) -> TMail::Mail
    port: TMail::Port
    config: TMail::Config

j
    port  Mail ֥Ȥޤ
e
    creates a new 'TMail::Mail' object from PORT.
.

: load(filename) -> TMail::Mail
    filename: String

j
    ե filename ᡼ɤ Mail ֥Ȥޤ
    ɤե MH Υ᡼Τ褦˥᡼̤եҤȤĤ
    бƤʤФޤ

    ,UNIX mbox Τ褦ʷñȤǤбƤޤ
    <a href="mbox.html">᡼ܥå饹</a>ȤäƤ
e
    creates a new 'TMail::Mail' object. FILENAME is the name of file
    which contains just one mail (e.g. MH mail file).
.

: parse(str) -> TMail::Mail
    str: String

j
    ʸ str ѡ TMail::Mail ֥Ȥޤ
    str ϥ᡼ʬǤʤФޤ
e
    parses STR and creates a new 'TMail::Mail' object.
.

== Instance Methods

: port -> TMail::Port
j
    Υ᡼륪֥ȤΥݡȤǤ
e
    the source port of this mail.
.

: body_port -> TMail::Port
j
    ᡼ʸ¸ƤݡȤ֤ޤ

    ˽񤭤ǤɸΥե(ʸ)ѹޤ
    ºݤѹ뤿ˤϤΥݡȤ˽񤭤 #write_back Ƥ
    ɬפޤ
e
    the port to save body of this mail.
.

: each {|line| .... }
    line: String

j
    ʸʸγƹԤФ뷫֤
    body_port.ropen {|f| f.each } ƱǤ
e
    iterates for each lines of mail body.
.

: body -> String
: preamble -> String
j
    ᡼ܥǥ(ʸ)ƤʸȤ֤ޤ
    MIME ޥѡȥ᡼ΤȤ preamble ޤ
    ֤ͤѹƤ⥪ꥸʥѹޤ
e
    the mail body. If the mail is a MIME multipart mail,
    this attribute represents "preamble".
.

: parts -> [TMail::Mail]
j
    ᡼뤬 MIME ޥѡȥ᡼λƥѡȤ TMail::Mail Ȥ
    ǼƤޤޥѡȥ᡼ǤʤȤ϶Ǥ

    ˽񤭤ǤɸΥե(ʸ)ѹޤ
    ºݤѹ뤿ˤϤΥ֥Ȥ˽񤭤 #write_back 
    Ƥɬפޤ
e
    parts of this mail. (valid only if this mail is a MIME multipart mail)
.

: epilogue -> String
j
    MIME ޥѡȥ᡼Ǥ epilogue ʸǤ
    ̾Υ᡼ΤȤ϶ʸäƤޤ

    ˽񤭤ǤɸΥե(ʸ)ѹޤ
    ºݤѹ뤿ˤϽ񤭤 #write_back Ƥɬפޤ
e
    If the mail was MIME multipart mail, this represent "epilogue" string.
    Else, empty string.
.

: multipart?
j
    ᡼뤬 MIME ޥѡȤΤȤ
    Υ᥽åɤ Content-Type إåƤǿȽǤޤ
e
    true if the message is a multi-part mail.
.

: encoded(eol = "\n", encoding = 'j') -> String
    eol: String
    encoding: String

j
    ᡼ RFC2822 ˥󥳡ɤʸѴޤ
    κݡإåιɤ eol ˡإåΥ󥳡
    ܸʸʸɤ encoding Ѵޤ
     encoding  "j" (JIS) ưޤ

    С 0.9  #to_s  #decoded ̾ˤʤäΤǡ
    ᥽åɤȤϰ㤦Ϥ餭򤷤ޤ
e
    converts the mail object to a MIME encoded string.
.

: decoded(eol = "\n", encoding = 'e') -> String
: to_s(eol = "\n", encoding = 'e') -> String
    eol: String
    encoding: String

j
    ᡼ǥɤ줿ʸѴޤκݡإåι
    ɤ eol ˡإåΥ󥳡ܸʸʸɤ
    encoding Ѵޤ

    С 0.9 ʹߤ #to_s ϤΥ᥽åɤ̾ˤʤޤ
e
    converts the mail object to a decoded string.
.

: inspect -> String
j
     #decoded ̾ǤС 0.9 
    "#<TMail::Mail port=<StringPort:str=...>>"
    Τ褦ʴʷʸ󲽤Ԥޤ
e
    returns simple string representation like
    '"#<TMail::Mail port=<StringPort:str=...>>"'
.

: write_back(eol = "\n", encoding = 'e')
    eol: String
    encoding: String

j
    ᡼Τʸ󲽤 body_port ˽ᤷޤκݡإå
    ɤ eol ˡإåܸʸʸɤ encoding 
    Ѵޤ
e
    converts this mail into string and write back to 'body_port',
    setting line terminator to EOL.
.

j
=== °ΤΥ᥽å
e
=== Property Access Method
.

: date(default = nil) -> Time
: date=(datetime)
    datetime: Time
    default: Object

j
    Date: إåб Time ֥ȡ
    ˥륿Ѵޤ
e
    a Time object of Date: header field.
.

: strftime(format, default = nil) -> String
    format: String
    default: Object

j
    Date: إåɽ줿б Time ֥ȤФ
    strftime ƤӤޤDate: إå¸ߤʤ default 
    ֤ޤ
e
    is equals to 'date.strftime(format)'.
    If date is not exist, this method does nothing and
    returns DEFAULT.
.

: to(default = nil)  ->  [String]
: to=(specs)
    specs: String | [String]
    default: Object

j
    To: ɥ쥹 spec 
e
    address specs for To: header field.
.

: to_addrs(default = nil)  ->  [TMail::Address | TMail::AddressGroup]
: to_addrs=(addrs)
    addrs: TMail::Address | [TMail::Address]
    default: Object

j
    To: ɥ쥹
e
    adresses which is represented in To: header field.
.

: cc(default = nil)  ->  [String]
: cc=(specs)
    specs: String | [String]
    default: Object

j
    Cc: ɥ쥹 spec 
e
    address specs for Cc: header field.
.

: cc_addrs(default = nil)  ->  [TMail::Address]
: cc_addrs=(addrs)
    addrs: TMail::Address | [TMail::Address]
    default: Object

j
    Cc: ɥ쥹
e
    addresses which is represented in Cc: header field.
.

: bcc(default = nil)  ->  [String]
: bcc=(specs)
    specs: String | [String]
    default: Object

j
    Bcc: ɥ쥹 spec 
e
    address specs for Bcc: header field.
.

: bcc_addrs(default = nil) -> [TMail::Address]
: bcc_addrs=(addrs)
    addrs: TMail::Address | [TMail::Address]
    default: Object

j
    Bcc: ɥ쥹
e
    adresses which is represented in Bcc: header field.
.

: from(default = nil) -> [String]
: from=(specs)
    specs: String | [String]
    default: Object

j
    From: ɥ쥹 spec 
e
    address specs for From: header field.
.

: from_addrs(default = nil) -> [TMail::Address]
: from_addrs=(addrs)
    addrs: TMail::Address | [TMail::Address]
    default: Object

j
    From: ɥ쥹
e
    adresses which is represented in From: header field.
.

: friendly_from(default = nil) -> String
    default: Object

j
    From: κǽΥɥ쥹 phrase ޤ spec
    From: ¸ߤʤȤ default ֤ޤ
e
    a "phrase" part or address spec of the first From: address.
.

: reply_to(default = nil) -> [String]
: reply_to=(specs)
    specs: String | [String]
    default: Object

j
    Reply-To: ɥ쥹 spec 
e
    address specs of Reply-To: header field.
.

: reply_to_addrs(default = nil) -> [TMail::Address]
: reply_to_addrs=(addrs)
    addrs: TMail::Address | [TMail::Address]
    default: Object

j
    Reply-To: ɥ쥹
e
    adresses which is represented in Reply-To: header field.
.

: sender(default = nil) -> String
: sender=(spec)
    spec: String

j
    Sender: ɥ쥹 spec
e
    address spec for Sender: header field.
.

: sender_addr(default = nil) -> TMail::Address
: sender_addr=(addr)
    addr: TMail::Address

j
    Sender: ɥ쥹
e
    an address which is represented in Sender: header field.
.

: subject(default = nil) -> String
: subject=(sbj)
    sbj: String

j
    Subject: ơ
    Subject: ¸ߤʤȤ default ֤ޤ
e
    the subject of the message.
.

: message_id(default = nil) -> String
: message_id=(id)
    id: String

j
    ᡼Υå ID
e
    message ID string.
.

: in_reply_to(default = nil) -> [String]
: in_reply_to=(ids)
    ids: String | [String]

j
    In-Reply-To: ˴ޤޤå ID Υꥹȡ
e
    message IDs of replying mails.
.

: references(default = nil) -> [String]
: references=(ids)
    ids: String | [String]

j
    References: ˴ޤޤå ID Υꥹȡ
    ߤ References: ˤϥå ID ʳ
    ޤޤ(RFC2822)
e
    message IDs of all referencing (replying) mails.
.

: mime_version(default = nil) -> String
: mime_version=(ver)
    ver: String

j
    MIME С󡣸ߤϾ "1.0" Ǥ
    إå¸ߤʤ default ֤ޤ
e
    MIME version.
    If it does not exist, returns the DEFAULT.
.

: set_mime_version(major, minor)
    major: Integer
    minor: Integer

j
    MIME С򥻥åȤޤ
e
    set MIME version from integers.
.

: content_type(default = nil) -> String
j
    ᡼ΤΥե륿פ򼨤ʸ㤨 "text/plain"
    إå¸ߤʤ default ֤ޤ
e
    the content type of the mail message (e.g. "text/plain").
    If it does not exist, returns the DEFAULT.
.

: main_type(default = nil) -> String
j
    ᡼ΤΥᥤ󥿥 (㡧"text")
    ˾ʸ줵ޤ
    إå¸ߤʤ default ֤ޤ
e
    the main content type of the mail message. (e.g. "text")
    If it does not exist, returns the DEFAULT.
.

: sub_type(default = nil) -> String
j
    ᡼ΤΥ֥ (㡧"plain")
    ˾ʸ줵ޤ
    إå¸ߤʤ default ֤ޤ
e
    the sub content type of the mail message. (e.g. "plain")
    If it does not exist, returns the DEFAULT.
.

: content_type=(ctype)
    ctype: String

j
    Content-Type Υᥤ󥿥ס֥פ main_sub 饻å
    ޤmain_sub 㤨 "text/plain" Τ褦ʷǤʤ
    ޤ
e
    set content type to STR.
.

: set_content_type(main, sub, params = nil)
    main: String
    sub: String
    params: {String => String}

j
    ƥȥפ main/sub; param; param; ... Τ褦ꤷޤ
e
    set Content-type: header as "main/sub; param=val; param=val; ...".
.

: type_param(name, default = nil) -> String
    name: String

j
    Content-Type  name ѥ᡼֤ͤޤ
    name бͤإåΤΤ¸ߤʤ default 
    ֤ޤ
e
    returns the value corresponding to the case-insensitive
    NAME of Content-Type parameter.
    If it does not exist, returns the DEFAULT.
.
      --
      # example
      mail['Content-Type'] = 'text/plain; charset=iso-2022-jp'
      p mail.type_param('charset')   # "iso-2022-jp"
      --

: multipart? -> true | false
j
    Content-Type  MIME ޥѡȥ᡼Ǥ뤳Ȥ
    Ƥʤп
e
    judge if this mail is MIME multi part mail,
    by inspecting Content-Type: header field.
.

: transfer_encoding(default = nil) -> String
: transfer_encoding=(encoding)
    encoding: String
j
    žŬѤ󥳡ǥ (Content-Transfer-Encoding)
    '7bit' '8bit' 'Base64' 'Binary' ʤɡ
e
    Content-Transfer-Encoding. (e.g. "7bit" "Base64")
.

: disposition(default = nil) -> String
: disposition=(pos)
    pos: String

j
    Content-Disposition μ (ʸ)֤ͤϾ˾ʸ줵ޤ
    name бͤإåΤΤ¸ߤʤ default 
    ֤ޤ
e
    Content-Disposition main value (e.g. "attachment").
    If it does not exist, returns the DEFAULT.
.
      --
      # example
      mail['Content-Disposition'] = 'attachement; filename="test.rb"'
      p mail.disposition   # "attachment"
      --

: set_content_disposition(pos, params = nil)
    pos: String
    params: {String => String}

j
    disposition ʸȥѥ᡼Υϥå夫 Content-Disposition 
    åȤޤ
e
    set content disposition.
.

: disposition_param(key, default = nil) -> String
    key: String

j
    Content-Disposition ղåѥ᡼ name ͤޤ
    name бͤإåΤΤ¸ߤʤ default 
    ֤ޤ
e
    returns a value corresponding to the Content-Disposition
    parameter NAME (e.g. filename).
    If it does not exist, returns the DEFAULT.
.
      --
      # example
      mail.disposition_param('filename')
      -- 

: destinations(default = nil) -> [String]
j
    ToCcBcc ٤ƤΥɥ쥹ڥåʸ
    ֤ޤҤȤĤ¸ߤʤ default ֤ޤ
e
    all address specs which are contained in To:, Cc: and
    Bcc: header fields.
.

: reply_addresses(default = nil) -> [TMail::Address]
j
    ֿ٤ɥ쥹ȽǤAddress ֥Ȥ
    ֤ޤֿ٤ɥ쥹ߤĤʤ
    DEFAULT ֤ޤ
e
    addresses to we reply to.
.

: error_reply_addresses(default = nil) -> [TMail::Address]
j
    顼᡼٤ɥ쥹ȽǤAddress ֥Ȥ
    ֤ޤ٤ɥ쥹ߤĤʤ default ֤ޤ
e
    addresses to use when returning error message.
.

j
=== إåեľѥ᥽å
e
=== Direct Header Handling Methods
.

: clear
j
    إåƾõޤ
e
    clears all header.
.

: keys -> [TMail::HeaderField]
j
    إå֤̾ޤ
e
    returns an array of contained header names.
.

: [](name) -> TMail::HeaderField
    name: String

j
    إå̾إå֥Ȥ֤ޤ
e
    returns a header field object corresponding to the case-insensitive
    key NAME. e.g. mail["To"]
.

: []=(name, field)
    name: String
    field: TMail::HeaderField

j
    name إå field ꤷޤfield ʸ TMail::HeaderField ֥ȤǤ
    Received ʤɰΥإåФƤϤˤͿ뤳ȤǤޤ
e
    set NAME header field to FIELD.
.

: delete(name)
    name: String
j
    name إåäޤ
e
    deletes header corresponding to case-insensitive key NAME.
.

: delete_if {|name, field| .... }
    name: String
    field: TMail::HeaderField

j
    إå̾ȥإåͿƥ֥åɾʤ餽δϢŤäޤ
e
    evaluates block with a name of header and header field object,
    and delete the header if block returns true.
.

: each_header {|name, field| .... }
: each_pair {|name, field| .... }
    name: String
    field: TMail::HeaderField

j
    ƤΥإå̾ȥإå֥ȤФ뤯꤫
e
    iterates for each header name and its field object.
.

: each_header_name {|name| .... }
: each_key {|name| .... }
    name: String

j
    ƤΥإå̾Ф뤯꤫
e
    iterates for each contained header names.
.

: each_field {|field| .... }
: each_value {|field| .... }
    field: TMail::HeaderField

j
    ƤΥإå֥ȤФ뤯꤫
e
    iterates for each header field objects.

: orderd_each {|name, field| .... }
    name: String
    field: TMail::HeaderField

j
    إåνդ each_header Ǥǽ˻ꤷΤꤷ
    ֤¤ӡ¾Υإå³ޤʸ
    TMail::Mail::FIELD_ORDER ꤷƤ(ܺ٤ϥɤ򻲾)
e
    iterates for each header field objects, in canonical order.
.

: key?(name)
    name: String

j
    name إåп
e
    returns true if the mail has NAME header.
.

: value?(field)
    field: TMail::HeaderField

j
    field إå֥Ȥп
e
    returns true if the mail has FIELD header field object.
.

: values_at(*names) -> [TMail::HeaderField]
: indexes(*names) -> [TMail::HeaderField]
: indices(*names) -> [TMail::HeaderField]
    names: [String]

j
    Ƥ names ˤĤ fetch ̤֤ޤ
e
    equals to 'names.collect {|k| mail[k] }'.
.

: values -> [TMail::HeaderField]
j
    ϿƤƤΥإå֥Ȥ֤ޤ
e
    returns an array of all header field object.
.
