/*
 * loadsave.c
 * Thomas Nemeth, le 15.10.2003
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "defines.h"
#include <ncurses.h>
#include <readline/readline.h>
#include "terminal.h"
#include "control.h"
#include "tmms.h"
#include "xmem.h"
#include "input.h"
#include "playlist.h"
#include "playerwin.h"
#include "playlistwin.h"
#include "loadsave.h"


static char *get_playlist(char *title)
{
        char *line, *filename = NULL;

        player_display = FALSE;
        display_input(title, "Playlist : ");
        line = readline(NULL);
        if (line && (line[0] != 0))
        {
                filename = xstrdup(stripwhite(line));
                if (strncmp(filename, "~/", 2) == 0)
                {
                        char *Home = robust_home(NULL);
                        int len = strlen(filename) + strlen(Home) + 3;
                        char *expanded = xmalloc(len);
                        snprintf(expanded, len - 1, "%s/%s", Home, filename + 2);
                        free(filename);
                        filename = expanded;
                }
                else if (filename[0] == '~')
                {
                        /* XXX should be replaced by the real user's home directory */
                        char *Home = "/home";
                        int len = strlen(filename) + strlen(Home) + 3;
                        char *expanded = xmalloc(len);
                        snprintf(expanded, len - 1, "%s/%s", Home, filename + 1);
                        free(filename);
                        filename = expanded;
                }
                free(line);
        }
        close_input();

        return filename;
}


int load_fileordir()
{
        char *pl = get_playlist("Load playlist...");

        if (pl)
        {
                playlist_free();
                set_command(STOPPED);
                load_playlist(pl);
                free(pl);
        }
        display_playlist();

        return CONT;
}


int add_playlist()
{
        char *pl = get_playlist("Add playlist...");

        if (pl)
        {
                set_command(STOPPED);
                load_playlist(pl);
                free(pl);
        }
        display_playlist();

        return CONT;
}


int save_fileordir()
{
        char *pl = get_playlist("Save playlist...");

        if (pl)
        {
                struct stat s;
                int ok = TRUE;
                if (stat(pl, &s) != -1)
                {
                        ok = FALSE;
                        if (S_ISREG(s.st_mode))
                        {
                                int rep = yes_or_no("Save playlist",
                                          "File already exists. Overwrite ? ",
                                          NO);
                                if (rep == 'Y')
                                {
                                        ok = TRUE;
                                }
                                display_playlist();
                        }
                }
                if (ok)
                {
                        save_playlist(pl);
                }
                free(pl);
        }

        return CONT;
}


int add_fileorstream()
{
        char *pl = get_playlist("Add title/stream...");

        if (pl)
        {
                struct stat s;
                if (((stat(pl, &s) != -1) && (S_ISREG(s.st_mode))) ||
                    (strncmp(pl, "http://", 7) == 0))
                {
                        playlist_add(pl);
                }
                free(pl);
        }

        return CONT;
}

