/***************************************************************************
@author:    Fabian Wuertz <xadras@sidux.com>
@copyright: Fabian Wuertz <xadras@sidux.com>
@license:   GPL2, GPL3

@project:   Waheela
@file:      metadata.h    
***************************************************************************/

#ifndef METADATA_H
#define METADATA_H

#include <QWidget>
#include <KPushButton>
#include <KConfig>
#include <QLabel>

#include "ui_metadataSettings.h"

class Metadata : public QLabel
{
	Q_OBJECT

	public:
		Metadata(QWidget* parent = 0, Qt::WFlags flags = 0);
		void setMetadata(const QVariantMap&);
		void showMetadata();
		void setup(KConfigGroup, QString);
		void setTheme(QString);
		void showButtons();
		void hideButtons();
		void show2();
		void hide2();
		
	private:
		QString theme, artist, title, album;
		Ui::metadataPage metadataUi;
		QWidget *settingsWidget;
		KPushButton *settingsButton;

	public slots:
		virtual void showSettingsDialog();
		virtual void applySettings();
};
#endif