#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "hexdump.h"

void hexdump(char *prefix, unsigned char *data, size_t size)
{
    char ascii[17];
    int i, same = 0;

    for (i = 0; i < size; i++) {
        if (0 == (i%16)) {
	    if (i && 0 == memcmp(data+i, data+i-16, 16)) {
		same++;
		if (1 == same)
		    fprintf(stderr, "*\n");
		i += 15;
		continue;
	    }
	    same = 0;
            fprintf(stderr,"%s%s%04x:",
                    prefix ? prefix : "",
                    prefix ? ": "   : "",
                    i);
            memset(ascii,0,sizeof(ascii));
        }
        if (0 == (i%4))
            fprintf(stderr," ");
        fprintf(stderr," %02x",data[i]);
        ascii[i%16] = isprint(data[i]) ? data[i] : '.';
        if (15 == (i%16))
            fprintf(stderr," %s\n",ascii);
    }
    if (0 != (i%16)) {
        while (0 != (i%16)) {
            if (0 == (i%4))
                fprintf(stderr," ");
            fprintf(stderr,"   ");
            i++;
        };
        fprintf(stderr," %s\n",ascii);
    }
}
