
#define IOAPIC_NUM_PINS  KVM_IOAPIC_NUM_PINS
#define IOAPIC_VERSION_ID 0x11	/* IOAPIC version */
#define IOAPIC_EDGE_TRIG  0
#define IOAPIC_LEVEL_TRIG 1

#define IOAPIC_DEFAULT_BASE_ADDRESS  0xfec00000
#define IOAPIC_MEM_LENGTH            0x100

/* Direct registers. */
#define IOAPIC_REG_SELECT  0x00
#define IOAPIC_REG_WINDOW  0x10
#define IOAPIC_REG_EOI     0x40	/* IA64 IOSAPIC only */

/* Indirect registers. */
#define IOAPIC_REG_APIC_ID 0x00	/* x86 IOAPIC only */
#define IOAPIC_REG_VERSION 0x01
#define IOAPIC_REG_ARB_ID  0x02	/* x86 IOAPIC only */

/*ioapic delivery mode*/
#define	IOAPIC_FIXED			0x0
#define	IOAPIC_LOWEST_PRIORITY		0x1
#define	IOAPIC_PMI			0x2
#define	IOAPIC_NMI			0x4
#define	IOAPIC_INIT			0x5
#define	IOAPIC_EXTINT			0x7

struct IO_APIC_route_entry {
        uint32_t vector          :  8,
                 delivery_mode   :  3,   /* 000: FIXED
                                          * 001: lowest prio
                                          * 111: ExtINT
                                          */
                 dest_mode       :  1,   /* 0: physical, 1: logical */
                 delivery_status :  1,
                 polarity        :  1,
                 irr             :  1,
                 trigger         :  1,   /* 0: edge, 1: level */
                 mask            :  1,   /* 0: enabled, 1: disabled */
                 __reserved_2    : 15;
        uint32_t __reserved_3    : 24,
                 dest            :  8;
} __attribute__ ((packed));
