#!/bin/bash

header="$1"
strings="$2"

function mklist() {
    local name="$1"
    local lcname=$(echo $name | tr "A-Z" "a-z")

    (
      echo "/* --- ${name} --- */"
      echo "const char *${lcname}_names[] = {"
      grep -e "#define[ \t]\+${name}_[a-zA-u0-9]\+[ \t]\+[0-9]\+" \
		/usr/include/xen/*.h \
	| awk '{printf "    [ %-32s ] = \"%s\", \n", $2, $2 }' \
	| sed -e "s/\"${name}_/\"/"
      echo "};"
      echo "const int ${lcname}_count = sizeof(${lcname}_names)/sizeof(${lcname}_names[0]);"
      echo
    ) | grep -v XENMEM_translate_gpfn_list >> $strings

    (
      echo "extern const char *${lcname}_names[];"
      echo "extern const int ${lcname}_count;"
      echo "#define ${lcname}_name(i) (((i) < ${lcname}_count && ${lcname}_names[i]) ? ${lcname}_names[i] : \"UNKNOWN\")"
      echo
    ) >> $header
}

cat <<EOF > "$strings"
/*
 * don't edit, generated by $0
 */

#include <inttypes.h>

#include <xen/xen.h>
#include <xen/version.h>
#include <xen/sched.h>
#include <xen/memory.h>
#include <xen/nmi.h>
#include <xen/callback.h>
#include <xen/physdev.h>
#include <xen/vcpu.h>
#include <xen/grant_table.h>

EOF

cat <<EOF > "$header"
/*
 * don't edit, generated by $0
 */

EOF

mklist __HYPERVISOR
mklist XENVER
mklist VMASST_TYPE
mklist VMASST_CMD
mklist SCHEDOP
mklist CONSOLEIO
mklist XENMEM
mklist XENNMI
mklist CALLBACKOP
mklist CALLBACKTYPE
mklist MMUEXT
mklist PHYSDEVOP
mklist VCPUOP
mklist EVTCHNOP
mklist VIRQ
mklist GNTTABOP
