#include <inttypes.h>

#include "xenner-emudev.h"

void emudev_write_entry(struct emudev_state *e, uint32_t value)
{
    e->entry = value;
}

void emudev_write_value(struct emudev_state *e, uint32_t value)
{
    uint16_t type, index;

    type  = e->entry >> 16;
    index = e->entry & 0xffff;
    switch (type) {
    case EMUDEV_CONF_GRANT_TABLE_PFNS:
	if (index < EMUDEV_CONF_GRANT_TABLE_COUNT)
	    e->gnttab[index] = value;
	break;
    case EMUDEV_CONF_EVTCHN_TO_PIN:
	if (index < EMUDEV_CONF_EVTCHN_TO_PIN_COUNT)
	    e->evtchn[index] = value;
	break;
    case EMUDEV_CONF_COMMAND_RESULT:
	if (index < EMUDEV_CONF_COMMAND_RESULT_COUNT)
	    e->result[index] = value;
	break;
    default:
	if (type < EMUDEV_CONF_SIMPLE_COUNT)
	    e->config[type] = value;
	break;
    }
}

uint32_t emudev_read_value(struct emudev_state *e)
{
    uint16_t type, index;

    type  = e->entry >> 16;
    index = e->entry & 0xffff;
    switch (type) {
    case EMUDEV_CONF_GRANT_TABLE_PFNS:
	if (index < EMUDEV_CONF_GRANT_TABLE_COUNT)
	    return e->gnttab[index];
	break;
    case EMUDEV_CONF_EVTCHN_TO_PIN:
	if (index < EMUDEV_CONF_EVTCHN_TO_PIN_COUNT)
	    return e->evtchn[index];
	break;
    case EMUDEV_CONF_COMMAND_RESULT:
	if (index < EMUDEV_CONF_COMMAND_RESULT_COUNT)
	    return e->result[index];
	break;
    default:
	if (type < EMUDEV_CONF_SIMPLE_COUNT)
	    return e->config[type];
	break;
    }
    return -1;
}
