#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <stdarg.h>
#include <dirent.h>
#include <fcntl.h>
#include <inttypes.h>

#include <xs.h>
#include <xenctrl.h>

/* -------------------------------------------------------------- */

static void usage(FILE *fp)
{
    fprintf(fp,
	    "\n"
	    "xenner-list  --  list xen(ner) domains.\n"
	    "\n"
	    "options:\n"
	    "   -h        print this text\n"
	    "\n"
	    "-- \n"
	    "(c) 2008 Gerd Hoffmann <kraxel@redhat.com>\n"
	    "\n");
}

int main(int argc, char *argv[])
{
    xc_dominfo_t info;
    int domid;
    int xc, count = 0;
    int c;

    for (;;) {
        if (-1 == (c = getopt(argc, argv, "h")))
            break;
        switch (c) {
        case 'h':
            usage(stdout);
            exit(0);
        default:
            usage(stderr);
            exit(1);
        }
    }

    xc = xc_interface_open();
    if (-1 == xc) {
        fprintf(stderr, "can't open xen interface\n");
        exit(1);
    }

    printf(" id | status  | pages  | MB\n");
    printf("----+---------+--------+----\n");
    for (domid = 0; ; domid = info.domid+1) {
	if (0 == xc_domain_getinfo(xc, domid, 1, &info))
	    break;
        if (info.domid == 0 && domid > 0)
            break;
        printf("%3d | %c%c%c%c%c%c%c | %6ld | %3ld\n",
               info.domid,
               info.dying    ? 'd' : '.',
               info.crashed  ? 'c' : '.',
               info.shutdown ? 's' : '.',
               info.paused   ? 'p' : '.',
               info.blocked  ? 'b' : '.',
               info.running  ? 'r' : '.',
               info.hvm      ? 'h' : '.',
               info.nr_pages,
               info.nr_pages >> 8);
	count++;
    }
    xc_interface_close(xc);

    return 0;
}
