/* stopwatch.vala
 *
 * Copyright (c) 2009 Diego Ongaro <ongardie@gmail.com>
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <libxfce4panel/libxfce4panel.h>
#include <libxfce4util/libxfce4util.h>
#include <stdio.h>
#include <gdk/gdk.h>


#define TYPE_MY_TIME_VAL (my_time_val_get_type ())
typedef struct _MyTimeVal MyTimeVal;

#define TYPE_TIMER (timer_get_type ())
#define TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TIMER, Timer))
#define TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TIMER, TimerClass))
#define IS_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TIMER))
#define IS_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TIMER))
#define TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TIMER, TimerClass))

typedef struct _Timer Timer;
typedef struct _TimerClass TimerClass;
typedef struct _TimerPrivate TimerPrivate;

#define TYPE_TIMER_BUTTON (timer_button_get_type ())
#define TIMER_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TIMER_BUTTON, TimerButton))
#define TIMER_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TIMER_BUTTON, TimerButtonClass))
#define IS_TIMER_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TIMER_BUTTON))
#define IS_TIMER_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TIMER_BUTTON))
#define TIMER_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TIMER_BUTTON, TimerButtonClass))

typedef struct _TimerButton TimerButton;
typedef struct _TimerButtonClass TimerButtonClass;
typedef struct _TimerButtonPrivate TimerButtonPrivate;

#define TYPE_STOPWATCH_PLUGIN (stopwatch_plugin_get_type ())
#define STOPWATCH_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STOPWATCH_PLUGIN, StopwatchPlugin))
#define STOPWATCH_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STOPWATCH_PLUGIN, StopwatchPluginClass))
#define IS_STOPWATCH_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STOPWATCH_PLUGIN))
#define IS_STOPWATCH_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STOPWATCH_PLUGIN))
#define STOPWATCH_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STOPWATCH_PLUGIN, StopwatchPluginClass))

typedef struct _StopwatchPlugin StopwatchPlugin;
typedef struct _StopwatchPluginClass StopwatchPluginClass;
typedef struct _StopwatchPluginPrivate StopwatchPluginPrivate;

struct _MyTimeVal {
	glong tv_sec;
	glong tv_usec;
};

struct _Timer {
	GObject parent_instance;
	TimerPrivate * priv;
};

struct _TimerClass {
	GObjectClass parent_class;
};

struct _TimerPrivate {
	MyTimeVal committed;
	guint tickId;
	MyTimeVal* started;
};

struct _TimerButton {
	GtkToggleButton parent_instance;
	TimerButtonPrivate * priv;
};

struct _TimerButtonClass {
	GtkToggleButtonClass parent_class;
};

struct _TimerButtonPrivate {
	Timer* timer;
};

struct _StopwatchPlugin {
	GObject parent_instance;
	StopwatchPluginPrivate * priv;
};

struct _StopwatchPluginClass {
	GObjectClass parent_class;
};

struct _StopwatchPluginPrivate {
	Timer* timer;
	TimerButton* timerButton;
	XfceHVBox* box;
};


static gpointer timer_parent_class = NULL;
static gpointer timer_button_parent_class = NULL;
static StopwatchPlugin* stopwatch_plugin_plugin;
static StopwatchPlugin* stopwatch_plugin_plugin = NULL;
static gpointer stopwatch_plugin_parent_class = NULL;

GType my_time_val_get_type (void);
MyTimeVal* my_time_val_dup (const MyTimeVal* self);
void my_time_val_free (MyTimeVal* self);
void my_time_val_init_now (MyTimeVal *self);
void my_time_val_init_zero (MyTimeVal *self);
void my_time_val_init_add (MyTimeVal *self, const MyTimeVal* a, const MyTimeVal* b);
void my_time_val_init_sub (MyTimeVal *self, const MyTimeVal* a, const MyTimeVal* b);
GType timer_get_type (void);
#define TIMER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TIMER, TimerPrivate))
enum  {
	TIMER_DUMMY_PROPERTY,
	TIMER_ELAPSED
};
void timer_reset (Timer* self);
Timer* timer_new (void);
Timer* timer_construct (GType object_type);
Timer* timer_new (void);
static gboolean timer_tick (Timer* self);
static gboolean _timer_tick_gsource_func (gpointer self);
void timer_start (Timer* self);
void timer_stop (Timer* self);
void timer_set_elapsed (Timer* self, MyTimeVal* value);
void timer_get_elapsed (Timer* self, MyTimeVal* value);
static void timer_finalize (GObject* obj);
static void timer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void timer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType timer_button_get_type (void);
#define TIMER_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TIMER_BUTTON, TimerButtonPrivate))
enum  {
	TIMER_BUTTON_DUMMY_PROPERTY
};
static void timer_button_updateDisplay (TimerButton* self, const MyTimeVal* elapsed);
void timer_button_start (TimerButton* self);
void timer_button_stop (TimerButton* self);
static void _lambda1_ (TimerButton* s, TimerButton* self);
static void __lambda1__gtk_toggle_button_toggled (TimerButton* _sender, gpointer self);
static void _lambda2_ (Timer* s, TimerButton* self);
static void __lambda2__timer_changed (Timer* _sender, gpointer self);
TimerButton* timer_button_new (Timer* timer);
TimerButton* timer_button_construct (GType object_type, Timer* timer);
TimerButton* timer_button_new (Timer* timer);
void timer_button_reset (TimerButton* self);
static void timer_button_finalize (GObject* obj);
GType stopwatch_plugin_get_type (void);
#define STOPWATCH_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_STOPWATCH_PLUGIN, StopwatchPluginPrivate))
enum  {
	STOPWATCH_PLUGIN_DUMMY_PROPERTY
};
static void stopwatch_plugin_save (StopwatchPlugin* self, XfcePanelPlugin* panel_plugin);
static void stopwatch_plugin_load (StopwatchPlugin* self, XfcePanelPlugin* panel_plugin);
static void _lambda3_ (XfcePanelPlugin* s, GtkOrientation orientation, StopwatchPlugin* self);
static void __lambda3__xfce_panel_plugin_orientation_changed (XfcePanelPlugin* _sender, GtkOrientation orientation, gpointer self);
static void _lambda4_ (GtkButton* s, StopwatchPlugin* self);
static void __lambda4__gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean _lambda5_ (XfcePanelPlugin* p, gint size, StopwatchPlugin* self);
static gboolean __lambda5__xfce_panel_plugin_size_changed (XfcePanelPlugin* _sender, gint size, gpointer self);
static void _stopwatch_plugin_save_xfce_panel_plugin_save (XfcePanelPlugin* _sender, gpointer self);
StopwatchPlugin* stopwatch_plugin_new (XfcePanelPlugin* panel_plugin);
StopwatchPlugin* stopwatch_plugin_construct (GType object_type, XfcePanelPlugin* panel_plugin);
StopwatchPlugin* stopwatch_plugin_new (XfcePanelPlugin* panel_plugin);
void stopwatch_plugin_register (XfcePanelPlugin* panel_plugin);
static void _lambda0_ (void);
static void __lambda0__gcallback (void);
static void _stopwatch_plugin_register_xfce_panel_plugin_func (XfcePanelPlugin* panel_plugin);
gint stopwatch_plugin_main (char** args, int args_length1);
static void stopwatch_plugin_finalize (GObject* obj);



void my_time_val_init_now (MyTimeVal *self) {
	GTimeVal _tmp0_ = {0};
	GTimeVal source;
	memset (self, 0, sizeof (MyTimeVal));
	source = (g_get_current_time (&_tmp0_), _tmp0_);
	(*self).tv_sec = source.tv_sec;
	(*self).tv_usec = source.tv_usec;
}


void my_time_val_init_zero (MyTimeVal *self) {
	memset (self, 0, sizeof (MyTimeVal));
	(*self).tv_sec = (glong) 0;
	(*self).tv_usec = (glong) 0;
}


void my_time_val_init_add (MyTimeVal *self, const MyTimeVal* a, const MyTimeVal* b) {
	memset (self, 0, sizeof (MyTimeVal));
	if (((*b).tv_usec + (*a).tv_usec) > 1000000) {
		/* carry */
		(*self).tv_usec = ((*a).tv_usec + (*b).tv_usec) - 1000000;
		(*self).tv_sec = ((*a).tv_sec + (*b).tv_sec) + 1;
	} else {
		(*self).tv_usec = (*a).tv_usec + (*b).tv_usec;
		(*self).tv_sec = (*a).tv_sec + (*b).tv_sec;
	}
}


void my_time_val_init_sub (MyTimeVal *self, const MyTimeVal* a, const MyTimeVal* b) {
	memset (self, 0, sizeof (MyTimeVal));
	if ((*b).tv_usec > (*a).tv_usec) {
		/* borrow */
		(*self).tv_usec = ((*a).tv_usec + 1000000) - (*b).tv_usec;
		(*self).tv_sec = ((*a).tv_sec - 1) - (*b).tv_sec;
	} else {
		(*self).tv_usec = (*a).tv_usec - (*b).tv_usec;
		(*self).tv_sec = (*a).tv_sec - (*b).tv_sec;
	}
}


MyTimeVal* my_time_val_dup (const MyTimeVal* self) {
	MyTimeVal* dup;
	dup = g_new0 (MyTimeVal, 1);
	memcpy (dup, self, sizeof (MyTimeVal));
	return dup;
}


void my_time_val_free (MyTimeVal* self) {
	g_free (self);
}


GType my_time_val_get_type (void) {
	static GType my_time_val_type_id = 0;
	if (my_time_val_type_id == 0) {
		my_time_val_type_id = g_boxed_type_register_static ("MyTimeVal", (GBoxedCopyFunc) my_time_val_dup, (GBoxedFreeFunc) my_time_val_free);
	}
	return my_time_val_type_id;
}


Timer* timer_construct (GType object_type) {
	Timer * self;
	self = g_object_newv (object_type, 0, NULL);
	timer_reset (self);
	return self;
}


Timer* timer_new (void) {
	return timer_construct (TYPE_TIMER);
}


static gboolean timer_tick (Timer* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->started == NULL) {
		result = FALSE;
		return result;
	}
	g_signal_emit_by_name (self, "changed");
	result = TRUE;
	return result;
}


static gboolean _timer_tick_gsource_func (gpointer self) {
	return timer_tick (self);
}


void timer_start (Timer* self) {
	MyTimeVal* _tmp3_;
	MyTimeVal* _tmp2_;
	MyTimeVal _tmp1_ = {0};
	MyTimeVal _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	self->priv->started = (_tmp3_ = (_tmp2_ = (_tmp1_ = (my_time_val_init_now (&_tmp0_), _tmp0_), &_tmp1_), (_tmp2_ == NULL) ? NULL : my_time_val_dup (_tmp2_)), (self->priv->started == NULL) ? NULL : (self->priv->started = (my_time_val_free (self->priv->started), NULL)), _tmp3_);
	self->priv->tickId = g_timeout_add_seconds ((guint) 1, _timer_tick_gsource_func, self);
}


void timer_stop (Timer* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->tickId > 0) {
		g_source_remove (self->priv->tickId);
		self->priv->tickId = (guint) 0;
	}
	if (self->priv->started != NULL) {
		MyTimeVal _tmp4_ = {0};
		MyTimeVal _tmp2_ = {0};
		MyTimeVal _tmp0_ = {0};
		MyTimeVal _tmp1_ = {0};
		MyTimeVal _tmp3_ = {0};
		MyTimeVal* _tmp5_;
		self->priv->committed = (my_time_val_init_add (&_tmp3_, &self->priv->committed, (_tmp4_ = (my_time_val_init_sub (&_tmp1_, (_tmp2_ = (my_time_val_init_now (&_tmp0_), _tmp0_), &_tmp2_), self->priv->started), _tmp1_), &_tmp4_)), _tmp3_);
		_tmp5_ = NULL;
		self->priv->started = (_tmp5_ = NULL, (self->priv->started == NULL) ? NULL : (self->priv->started = (my_time_val_free (self->priv->started), NULL)), _tmp5_);
	}
	g_signal_emit_by_name (self, "changed");
}


void timer_reset (Timer* self) {
	MyTimeVal _tmp0_ = {0};
	MyTimeVal _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	timer_set_elapsed (self, (_tmp1_ = (my_time_val_init_zero (&_tmp0_), _tmp0_), &_tmp1_));
}


void timer_get_elapsed (Timer* self, MyTimeVal* value) {
	MyTimeVal result;
	g_return_if_fail (self != NULL);
	if (self->priv->started == NULL) {
		result = self->priv->committed;
		*value = result;
		return;
	} else {
		MyTimeVal _tmp4_ = {0};
		MyTimeVal _tmp2_ = {0};
		MyTimeVal _tmp0_ = {0};
		MyTimeVal _tmp1_ = {0};
		MyTimeVal _tmp3_ = {0};
		result = (my_time_val_init_add (&_tmp3_, &self->priv->committed, (_tmp4_ = (my_time_val_init_sub (&_tmp1_, (_tmp2_ = (my_time_val_init_now (&_tmp0_), _tmp0_), &_tmp2_), self->priv->started), _tmp1_), &_tmp4_)), _tmp3_);
		*value = result;
		return;
	}
}


void timer_set_elapsed (Timer* self, MyTimeVal* value) {
	g_return_if_fail (self != NULL);
	timer_stop (self);
	self->priv->committed = (*value);
	g_signal_emit_by_name (self, "changed");
	g_object_notify ((GObject *) self, "elapsed");
}


static void timer_class_init (TimerClass * klass) {
	timer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TimerPrivate));
	G_OBJECT_CLASS (klass)->get_property = timer_get_property;
	G_OBJECT_CLASS (klass)->set_property = timer_set_property;
	G_OBJECT_CLASS (klass)->finalize = timer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TIMER_ELAPSED, g_param_spec_boxed ("elapsed", "elapsed", "elapsed", TYPE_MY_TIME_VAL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("changed", TYPE_TIMER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void timer_instance_init (Timer * self) {
	self->priv = TIMER_GET_PRIVATE (self);
}


static void timer_finalize (GObject* obj) {
	Timer * self;
	self = TIMER (obj);
	(self->priv->started == NULL) ? NULL : (self->priv->started = (my_time_val_free (self->priv->started), NULL));
	G_OBJECT_CLASS (timer_parent_class)->finalize (obj);
}


GType timer_get_type (void) {
	static GType timer_type_id = 0;
	if (timer_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (TimerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) timer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Timer), 0, (GInstanceInitFunc) timer_instance_init, NULL };
		timer_type_id = g_type_register_static (G_TYPE_OBJECT, "Timer", &g_define_type_info, 0);
	}
	return timer_type_id;
}


static void timer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Timer * self;
	gpointer boxed;
	self = TIMER (object);
	switch (property_id) {
		case TIMER_ELAPSED:
		boxed = g_new0 (MyTimeVal, 1);
		g_value_take_boxed (value, boxed);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void timer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Timer * self;
	self = TIMER (object);
	switch (property_id) {
		case TIMER_ELAPSED:
		timer_set_elapsed (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void timer_button_updateDisplay (TimerButton* self, const MyTimeVal* elapsed) {
	gint seconds;
	gint minutes;
	gint hours;
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	seconds = (gint) ((*elapsed).tv_sec % 60);
	minutes = (gint) (((*elapsed).tv_sec / 60) % 60);
	hours = (gint) (((*elapsed).tv_sec / 60) / 60);
	_tmp0_ = NULL;
	gtk_button_set_label ((GtkButton*) self, _tmp0_ = g_strdup_printf ("%02d:%02d:%02d", hours, minutes, seconds));
	_tmp0_ = (g_free (_tmp0_), NULL);
}


static void _lambda1_ (TimerButton* s, TimerButton* self) {
	g_return_if_fail (s != NULL);
	if (gtk_toggle_button_get_active ((GtkToggleButton*) self)) {
		timer_button_start (self);
	} else {
		timer_button_stop (self);
	}
}


static void __lambda1__gtk_toggle_button_toggled (TimerButton* _sender, gpointer self) {
	_lambda1_ (_sender, self);
}


static void _lambda2_ (Timer* s, TimerButton* self) {
	MyTimeVal _tmp1_ = {0};
	MyTimeVal _tmp0_ = {0};
	g_return_if_fail (s != NULL);
	timer_button_updateDisplay (self, (_tmp1_ = (timer_get_elapsed (self->priv->timer, &_tmp0_), _tmp0_), &_tmp1_));
}


static void __lambda2__timer_changed (Timer* _sender, gpointer self) {
	_lambda2_ (_sender, self);
}


TimerButton* timer_button_construct (GType object_type, Timer* timer) {
	TimerButton * self;
	Timer* _tmp1_;
	Timer* _tmp0_;
	MyTimeVal _tmp3_ = {0};
	MyTimeVal _tmp2_ = {0};
	g_return_val_if_fail (timer != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->timer = (_tmp1_ = (_tmp0_ = timer, (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_)), (self->priv->timer == NULL) ? NULL : (self->priv->timer = (g_object_unref (self->priv->timer), NULL)), _tmp1_);
	g_object_set ((GtkWidget*) self, "can-default", FALSE, NULL);
	g_object_set ((GtkWidget*) self, "can-focus", FALSE, NULL);
	gtk_button_set_focus_on_click ((GtkButton*) self, FALSE);
	gtk_button_set_relief ((GtkButton*) self, GTK_RELIEF_NONE);
	timer_button_updateDisplay (self, (_tmp3_ = (timer_get_elapsed (self->priv->timer, &_tmp2_), _tmp2_), &_tmp3_));
	g_signal_connect ((GtkToggleButton*) self, "toggled", (GCallback) __lambda1__gtk_toggle_button_toggled, self);
	g_signal_connect (self->priv->timer, "changed", (GCallback) __lambda2__timer_changed, self);
	return self;
}


TimerButton* timer_button_new (Timer* timer) {
	return timer_button_construct (TYPE_TIMER_BUTTON, timer);
}


void timer_button_start (TimerButton* self) {
	g_return_if_fail (self != NULL);
	gtk_toggle_button_set_active ((GtkToggleButton*) self, TRUE);
	timer_start (self->priv->timer);
}


void timer_button_stop (TimerButton* self) {
	g_return_if_fail (self != NULL);
	gtk_toggle_button_set_active ((GtkToggleButton*) self, FALSE);
	timer_stop (self->priv->timer);
}


void timer_button_reset (TimerButton* self) {
	g_return_if_fail (self != NULL);
	gtk_toggle_button_set_active ((GtkToggleButton*) self, FALSE);
	timer_reset (self->priv->timer);
}


static void timer_button_class_init (TimerButtonClass * klass) {
	timer_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TimerButtonPrivate));
	G_OBJECT_CLASS (klass)->finalize = timer_button_finalize;
}


static void timer_button_instance_init (TimerButton * self) {
	self->priv = TIMER_BUTTON_GET_PRIVATE (self);
}


static void timer_button_finalize (GObject* obj) {
	TimerButton * self;
	self = TIMER_BUTTON (obj);
	(self->priv->timer == NULL) ? NULL : (self->priv->timer = (g_object_unref (self->priv->timer), NULL));
	G_OBJECT_CLASS (timer_button_parent_class)->finalize (obj);
}


GType timer_button_get_type (void) {
	static GType timer_button_type_id = 0;
	if (timer_button_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (TimerButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) timer_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TimerButton), 0, (GInstanceInitFunc) timer_button_instance_init, NULL };
		timer_button_type_id = g_type_register_static (GTK_TYPE_TOGGLE_BUTTON, "TimerButton", &g_define_type_info, 0);
	}
	return timer_button_type_id;
}


static void stopwatch_plugin_save (StopwatchPlugin* self, XfcePanelPlugin* panel_plugin) {
	char* _tmp0_;
	XfceRc* _tmp1_;
	XfceRc* rc;
	MyTimeVal _tmp2_ = {0};
	MyTimeVal elapsed;
	char* _tmp3_;
	char* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (panel_plugin != NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	rc = (_tmp1_ = xfce_rc_simple_open (_tmp0_ = xfce_panel_plugin_save_location (panel_plugin, TRUE), FALSE), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	elapsed = (timer_get_elapsed (self->priv->timer, &_tmp2_), _tmp2_);
	_tmp3_ = NULL;
	xfce_rc_write_entry (rc, "elapsed_sec", _tmp3_ = g_strdup_printf ("%ld", elapsed.tv_sec));
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp4_ = NULL;
	xfce_rc_write_entry (rc, "elapsed_usec", _tmp4_ = g_strdup_printf ("%ld", elapsed.tv_usec));
	_tmp4_ = (g_free (_tmp4_), NULL);
	(rc == NULL) ? NULL : (rc = (xfce_rc_close (rc), NULL));
}


static void stopwatch_plugin_load (StopwatchPlugin* self, XfcePanelPlugin* panel_plugin) {
	char* _tmp0_;
	XfceRc* _tmp1_;
	XfceRc* rc;
	MyTimeVal _tmp2_ = {0};
	MyTimeVal elapsed;
	g_return_if_fail (self != NULL);
	g_return_if_fail (panel_plugin != NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	rc = (_tmp1_ = xfce_rc_simple_open (_tmp0_ = xfce_panel_plugin_lookup_rc_file (panel_plugin), TRUE), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	elapsed = (my_time_val_init_zero (&_tmp2_), _tmp2_);
	sscanf (xfce_rc_read_entry (rc, "elapsed_sec", "0"), "%ld", &elapsed.tv_sec);
	sscanf (xfce_rc_read_entry (rc, "elapsed_usec", "0"), "%ld", &elapsed.tv_usec);
	timer_set_elapsed (self->priv->timer, &elapsed);
	(rc == NULL) ? NULL : (rc = (xfce_rc_close (rc), NULL));
}


static void _lambda3_ (XfcePanelPlugin* s, GtkOrientation orientation, StopwatchPlugin* self) {
	g_return_if_fail (s != NULL);
	xfce_hvbox_set_orientation (self->priv->box, orientation);
}


static void __lambda3__xfce_panel_plugin_orientation_changed (XfcePanelPlugin* _sender, GtkOrientation orientation, gpointer self) {
	_lambda3_ (_sender, orientation, self);
}


static void _lambda4_ (GtkButton* s, StopwatchPlugin* self) {
	g_return_if_fail (s != NULL);
	timer_button_reset (self->priv->timerButton);
}


static void __lambda4__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda4_ (_sender, self);
}


static gboolean _lambda5_ (XfcePanelPlugin* p, gint size, StopwatchPlugin* self) {
	gboolean result;
	g_return_val_if_fail (p != NULL, FALSE);
	result = TRUE;
	return result;
}


static gboolean __lambda5__xfce_panel_plugin_size_changed (XfcePanelPlugin* _sender, gint size, gpointer self) {
	return _lambda5_ (_sender, size, self);
}


static void _stopwatch_plugin_save_xfce_panel_plugin_save (XfcePanelPlugin* _sender, gpointer self) {
	stopwatch_plugin_save (self, _sender);
}


StopwatchPlugin* stopwatch_plugin_construct (GType object_type, XfcePanelPlugin* panel_plugin) {
	StopwatchPlugin * self;
	Timer* _tmp0_;
	GtkOrientation orientation;
	XfceHVBox* _tmp1_;
	TimerButton* _tmp2_;
	GtkButton* resetButton;
	GtkImage* refreshImage;
	g_return_val_if_fail (panel_plugin != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	_tmp0_ = NULL;
	self->priv->timer = (_tmp0_ = timer_new (), (self->priv->timer == NULL) ? NULL : (self->priv->timer = (g_object_unref (self->priv->timer), NULL)), _tmp0_);
	stopwatch_plugin_load (self, panel_plugin);
	orientation = xfce_panel_plugin_get_orientation (panel_plugin);
	_tmp1_ = NULL;
	self->priv->box = (_tmp1_ = g_object_ref_sink (xfce_hvbox_new (orientation, FALSE, 0)), (self->priv->box == NULL) ? NULL : (self->priv->box = (g_object_unref (self->priv->box), NULL)), _tmp1_);
	g_signal_connect (panel_plugin, "orientation-changed", (GCallback) __lambda3__xfce_panel_plugin_orientation_changed, self);
	_tmp2_ = NULL;
	self->priv->timerButton = (_tmp2_ = g_object_ref_sink (timer_button_new (self->priv->timer)), (self->priv->timerButton == NULL) ? NULL : (self->priv->timerButton = (g_object_unref (self->priv->timerButton), NULL)), _tmp2_);
	xfce_panel_plugin_add_action_widget (panel_plugin, (GtkWidget*) self->priv->timerButton);
	gtk_container_add ((GtkContainer*) self->priv->box, (GtkWidget*) self->priv->timerButton);
	resetButton = g_object_ref_sink ((GtkButton*) gtk_button_new ());
	g_object_set ((GtkWidget*) resetButton, "can-default", FALSE, NULL);
	g_object_set ((GtkWidget*) resetButton, "can-focus", FALSE, NULL);
	gtk_button_set_focus_on_click (resetButton, FALSE);
	gtk_button_set_relief (resetButton, GTK_RELIEF_NONE);
	refreshImage = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_REFRESH, GTK_ICON_SIZE_BUTTON));
	gtk_button_set_image (resetButton, (GtkWidget*) refreshImage);
	g_signal_connect (resetButton, "clicked", (GCallback) __lambda4__gtk_button_clicked, self);
	xfce_panel_plugin_add_action_widget (panel_plugin, (GtkWidget*) resetButton);
	gtk_container_add ((GtkContainer*) self->priv->box, (GtkWidget*) resetButton);
	gtk_container_add ((GtkContainer*) panel_plugin, (GtkWidget*) self->priv->box);
	gtk_widget_show_all ((GtkWidget*) panel_plugin);
	g_signal_connect (panel_plugin, "size-changed", (GCallback) __lambda5__xfce_panel_plugin_size_changed, self);
	g_signal_connect_object (panel_plugin, "save", (GCallback) _stopwatch_plugin_save_xfce_panel_plugin_save, self, 0);
	(resetButton == NULL) ? NULL : (resetButton = (g_object_unref (resetButton), NULL));
	(refreshImage == NULL) ? NULL : (refreshImage = (g_object_unref (refreshImage), NULL));
	return self;
}


StopwatchPlugin* stopwatch_plugin_new (XfcePanelPlugin* panel_plugin) {
	return stopwatch_plugin_construct (TYPE_STOPWATCH_PLUGIN, panel_plugin);
}


void stopwatch_plugin_register (XfcePanelPlugin* panel_plugin) {
	StopwatchPlugin* _tmp0_;
	g_return_if_fail (panel_plugin != NULL);
	_tmp0_ = NULL;
	stopwatch_plugin_plugin = (_tmp0_ = stopwatch_plugin_new (panel_plugin), (stopwatch_plugin_plugin == NULL) ? NULL : (stopwatch_plugin_plugin = (g_object_unref (stopwatch_plugin_plugin), NULL)), _tmp0_);
}


static void _lambda0_ (void) {
	gtk_main_quit ();
}


static void __lambda0__gcallback (void) {
	_lambda0_ ();
}


static gint xfce_PanelPluginRegisterExternalFull (int* argv_length1, char*** argv, XfcePanelPluginFunc _register_, XfcePanelPluginPreInit preinit, XfcePanelPluginCheck check) {
	gint result;
	XfceExternalPanelPlugin* panel_plugin;
	if (preinit != NULL) {
		if (!preinit (*argv_length1, (*argv))) {
			result = 3;
			return result;
		}
	}
	gtk_init (&(*argv_length1), &(*argv));
	if (check != NULL) {
		if (!check (gdk_screen_get_default ())) {
			result = 2;
			return result;
		}
	}
	panel_plugin = g_object_ref_sink (xfce_external_panel_plugin_new (*argv_length1, (*argv), _register_));
	if (panel_plugin == NULL) {
		result = 1;
		(panel_plugin == NULL) ? NULL : (panel_plugin = (g_object_unref (panel_plugin), NULL));
		return result;
	}
	g_signal_connect_after (panel_plugin, "destroy", __lambda0__gcallback, NULL);
	gtk_widget_show ((GtkWidget*) panel_plugin);
	gtk_main ();
	result = 0;
	(panel_plugin == NULL) ? NULL : (panel_plugin = (g_object_unref (panel_plugin), NULL));
	return result;
}


static gint xfce_PanelPluginRegisterExternal (int* argv_length1, char*** argv, XfcePanelPluginFunc _register_) {
	gint result;
	result = xfce_PanelPluginRegisterExternalFull (&(*argv_length1), &(*argv), _register_, NULL, NULL);
	return result;
}


static void _stopwatch_plugin_register_xfce_panel_plugin_func (XfcePanelPlugin* panel_plugin) {
	stopwatch_plugin_register (panel_plugin);
}


gint stopwatch_plugin_main (char** args, int args_length1) {
	gint result;
	result = xfce_PanelPluginRegisterExternal (&args_length1, &args, _stopwatch_plugin_register_xfce_panel_plugin_func);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return stopwatch_plugin_main (argv, argc);
}


static void stopwatch_plugin_class_init (StopwatchPluginClass * klass) {
	stopwatch_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (StopwatchPluginPrivate));
	G_OBJECT_CLASS (klass)->finalize = stopwatch_plugin_finalize;
}


static void stopwatch_plugin_instance_init (StopwatchPlugin * self) {
	self->priv = STOPWATCH_PLUGIN_GET_PRIVATE (self);
}


static void stopwatch_plugin_finalize (GObject* obj) {
	StopwatchPlugin * self;
	self = STOPWATCH_PLUGIN (obj);
	(self->priv->timer == NULL) ? NULL : (self->priv->timer = (g_object_unref (self->priv->timer), NULL));
	(self->priv->timerButton == NULL) ? NULL : (self->priv->timerButton = (g_object_unref (self->priv->timerButton), NULL));
	(self->priv->box == NULL) ? NULL : (self->priv->box = (g_object_unref (self->priv->box), NULL));
	G_OBJECT_CLASS (stopwatch_plugin_parent_class)->finalize (obj);
}


GType stopwatch_plugin_get_type (void) {
	static GType stopwatch_plugin_type_id = 0;
	if (stopwatch_plugin_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (StopwatchPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) stopwatch_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StopwatchPlugin), 0, (GInstanceInitFunc) stopwatch_plugin_instance_init, NULL };
		stopwatch_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "StopwatchPlugin", &g_define_type_info, 0);
	}
	return stopwatch_plugin_type_id;
}




