/*
 *  xfmedia - simple gtk2 media player based on xine
 *
 *  Copyright (c) 2004-2005 Brian Tarricone, <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __XFMEDIA__VIDEO_WINDOW_H__
#define __XFMEDIA__VIDEO_WINDOW_H__

#include <glib.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define XFMEDIA_TYPE_VIDEO_WINDOW     (xfmedia_video_window_get_type())
#define XFMEDIA_VIDEO_WINDOW(obj)     (G_TYPE_CHECK_INSTANCE_CAST((obj), XFMEDIA_TYPE_VIDEO_WINDOW, XfmediaVideoWindow))
#define XFMEDIA_IS_VIDEO_WINDOW(obj)  (G_TYPE_CHECK_INSTANCE_TYPE((obj), XFMEDIA_TYPE_VIDEO_WINDOW))

typedef struct _XfmediaVideoWindow      XfmediaVideoWindow;
typedef struct _XfmediaVideoWindowClass XfmediaVideoWindowClass;
typedef struct _XfmediaVideoWindowPriv  XfmediaVideoWindowPriv;

struct _XfmediaVideoWindow
{
    GtkWindow parent;
    
    /*< private >*/
    XfmediaVideoWindowPriv *priv;
};

struct _XfmediaVideoWindowClass
{
    GtkWindowClass parent;
};

GType      xfmedia_video_window_get_type        () G_GNUC_CONST;

GtkWidget *xfmedia_video_window_new             (GtkWidget *video_widget);

void       xfmedia_video_window_set_video_widget(XfmediaVideoWindow *video_window,
                                                 GtkWidget *video_widget);
GtkWidget *xfmedia_video_window_get_video_widget(XfmediaVideoWindow *video_window);

void       xfmedia_video_window_set_fullscreen  (XfmediaVideoWindow *video_window,
                                                 gboolean fullscreen);
gboolean   xfmedia_video_window_get_fullscreen  (XfmediaVideoWindow *video_window);

void       xfmedia_video_window_set_aspect      (XfmediaVideoWindow *video_window,
                                                 gint width,
                                                 gint height);
void       xfmedia_video_window_get_aspect      (XfmediaVideoWindow *video_window,
                                                 gint *width,
                                                 gint *height);

void       xfmedia_video_window_set_fixed_size  (XfmediaVideoWindow *video_window,
                                                 gint width,
                                                 gint height);
gboolean   xfmedia_video_window_has_fixed_size  (XfmediaVideoWindow *video_window);

G_END_DECLS

#endif
