# -*- coding: utf-8 -*-
#
# Conditional language support packages, via a yum plugin
#
# Copyright © 2009 Red Hat, Inc.
#
# Authors: Bill Nottingham <notting@redhat.com>
#          Jens Petersen <petersen@redhat.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

from yum.plugins import TYPE_CORE

import fnmatch
import glob
import locale
import rpm

requires_api_version = '2.5'
plugin_type = TYPE_CORE

langs = []

# This needs to be in the metadata somewhere. For a POC, this works.
conditional_pkgs = {
  'aspell' : [ 'aspell-%s', 'hunspell-%s' ],
  'eclipse-platform' : [ 'eclipse-nls-%s' ],
  'gcompris' : [ 'gcompris-sound-%s'],
  'hunspell' : [ 'hunspell-%s' ],
  'hyphen' : [ 'hyphen-%s' ],
  'kdelibs3' : [ 'kde-i18n-%s' ],
  'kdelibs' : [ 'kde-l10n-%s' ],
  'koffice-core' : [ 'koffice-langpack-%s' ],
  'LabPlot-doc' : [ 'LabPlot-doc-%s' ],
  'man-pages' : [ 'man-pages-%s' ],
  'moodle' : [ 'moodle-%s' ],
  'openoffice.org-core' : [ 'openoffice.org-langpack-%s' ],
  'tesseract' : [ 'tesseract-langpack-%s' ]
}

def config_hook(conduit):
    global conditional_pkgs
    
    # FIXME: Here is where we would read conditional pkgs from some sort of
    # metadata. For now, they're defined above

    global langs
    
    (lang, encoding) = locale.getdefaultlocale()
    conflist = conduit.confString('main', 'langpack_locales', default=lang)
    if conflist:
        conduit.info(2, "Adding %s to language list" % (conflist))
        tmp = conflist.split(",")
        for confitem in tmp:
            langs.append(confitem.strip())

def add_deps_to_ts(conduit, po):
    conds = conditional_pkgs[po.name]
    sack = conduit.getRepos().getPackageSack()
    yb = conduit._base
    for lang in langs:
        pkgs = sack.returnPackages(patterns = map(lambda x: x % (lang,), conds))
        if not pkgs and lang != '*':
            shortlang = lang.split('_')[0]
            pkgs = sack.returnPackages(patterns = map(lambda x: x % (shortlang,), conds))
        for pkg in pkgs:
            if yb.rpmdb.searchNevra(name=pkg.name):
                continue
            if yb.tsInfo.matchNaevr(name=pkg.name):
                continue
            yb.install(pattern=pkg.name)

def remove_deps_from_ts(conduit, po):
    conds = conditional_pkgs[po.name]
    yb = conduit._base
    pkgmatches = []
    for c in conds:
        for lang in langs:
            pkgmatches.append(c % (lang,))
            shortlang = lang.split('_')[0]
            pkgmatches.append(c % (shortlang,))
    for pkg in yb.rpmdb.returnPackages(patterns=pkgmatches):
        yb.remove(pattern=pkg.name)

def postresolve_hook(conduit):
    for member in conduit.getTsInfo().getMembers():
        po = member.po
        if po.name in conditional_pkgs:
            if member.ts_state in ('i', 'u'):
                add_deps_to_ts(conduit, po)
            elif member.ts_state in ('e', None):
                remove_deps_from_ts(conduit, po)
