#!/bin/bash -l
DIRCURR=$(cd $(dirname "$0") && pwd); cd "$DIRCURR" || exit
package=$(($(ls *-ure-* | wc -l)))
if [ $package -ne 1 ]; then
  /usr/bin/zenity --title=LO_OfflineInstall --width=400 --error --text 'Looks like you extracted the OfflineInstaller into an old existing LO-rpms directory. Please remove any existing LO-rpms directory and then extract the OfflineInstaller again.'
  xdg-open ReadmeFirst.txt 
  exit 1
fi
sysarch=$(getconf LONG_BIT)
package=$(($(ls *-ure-*|grep -c i586) * -32 + 64))
if [ "$sysarch" -ne $package ]; then
  /usr/bin/zenity --title=LO_OfflineInstall --width=400 --error --text 'Please use the '"$sysarch"'-bit OfflineInstaller on this PC.'
  xdg-open ReadmeFirst.txt 
  exit 1
fi
if [ ! -e /usr/bin/java ];then
  /usr/bin/zenity --title=LO_OfflineInstall --width=400 --error --text 'Please install task-java on this PC.'
  xdg-open ReadmeFirst.txt 
  exit 1
fi
if [ "$UID" != "0" ]; then
  /usr/bin/zenity --title=LO_OfflineInstall --width=400 --error --text 'Please run this script as root\!'
  xdg-open ReadmeFirst.txt 
  exit 1
fi
for idx in synaptic kpackage apt-get dnf dnf5_launcher
do
 if [ "`ps -ef|grep -w $idx | wc -l`" -ge 2 ];then
   /usr/bin/zenity --title=LO_OfflineInstall --width=400 --error --text "Please close '$idx', then run this script again"
  exit 1
 fi
done
set -- /usr/bin/ooffice2*; if [ -f "$1" ];then QQ=$#; else QQ=0;fi
if [ $QQ != "0" ] || [ -e /usr/bin/ooffice3.0 ] || [ -e /usr/bin/openoffice.org3 ] || [ -e /usr/bin/libreoffice* ] ; then
  /usr/bin/zenity --title=LO_OfflineInstall --width=400 --error --text 'Please run lomanager and select:\n  Completely remove LibreOffice\n\nthen run this script again'
  if [ -e /usr/bin/lomanager ];then xhost +;lomanager;fi
  /usr/bin/zenity --title=LO_OfflineInstall --width=400 --info --text 'Please run LO_OfflineInstall again'
  exit 1
fi
/usr/bin/zenity --title=LO_OfflineInstall --info --width=400 --timeout 30 --text "Installing LibreOffice.\nThis process is finished once the new window\n\n'LibreOffice is now installed'.\n\nwill appear. Please be patient... :-)\nThis window will auto-close in 30 seconds...." &
rpm -Uvh --replacepkgs ./*.rpm
/bin/cp -f /usr/share/icons/hicolor/32x32/apps/libreoffice* /usr/share/icons/
if [ -n "$(pidof lxsession)" ];then lxpanelctl restart;fi
sed -i '/Categories=Office;*/c\Categories=Office' /opt/libreoffice*/share/xdg/base.desktop >/dev/null 2>&1
sed -i '/Categories=Office;*/c\Categories=Office' /opt/libreoffice*/share/xdg/calc.desktop >/dev/null 2>&1
sed -i '/Categories=Office;*/c\Categories=Office' /opt/libreoffice*/share/xdg/draw.desktop >/dev/null 2>&1
sed -i '/Categories=Office;*/c\Categories=Office' /opt/libreoffice*/share/xdg/impress.desktop >/dev/null 2>&1
sed -i '/Categories=Office;*/c\Categories=Office' /opt/libreoffice*/share/xdg/math.desktop >/dev/null 2>&1
sed -i '/Categories=Office;*/c\Categories=Office' /opt/libreoffice*/share/xdg/writer.desktop >/dev/null 2>&1
xdg-desktop-menu forceupdate
SYSUSERS=$(grep [0-9][0-9][0-9]:.*/home /etc/passwd | grep -f /etc/shells | cut -d: -f1)

for idx in $SYSUSERS
  do
  udir=/home/$idx/.config/libreoffice/4/user
  regfile=/home/$idx/.config/libreoffice/4/user/registrymodifications.xcu
    if [ -e "$regfile" ]; then
      pushd "$udir" || exit
      onlinechecker=$(cat registrymodifications.xcu|grep AutoCheckEnabled | grep -c "<value>true</value>")
      if [ "$onlinechecker" -eq 1 ]; then
        ll=$(cat registrymodifications.xcu|grep -n AutoCheckEnabled |awk -F':' '{printf$1}')
        sed -i "${ll}s/true/false/" registrymodifications.xcu
      else
        sed -i '$d' registrymodifications.xcu
        echo \<item oor:path=\"/org.openoffice.Office.Jobs/Jobs/org.openoffice.Office.Jobs:Job[\'UpdateCheck\']/Arguments\"\>\<prop oor:name=\"AutoCheckEnabled\" oor:op=\"fuse\" oor:type=\"xs:boolean\"\>\<value\>false\</value\>\</prop\>\</item\>  >> registrymodifications.xcu
        echo \</oor:items\> >> registrymodifications.xcu
      fi
      popd || exit
    else
      mkdir -p "$udir"
      echo \<?xml version=\"1.0\" encoding=\"UTF-8\"?\>  >> "$regfile"
      echo \<oor:items xmlns:oor=\"https://openoffice.org/2001/registry\" xmlns:xs=\"https://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"https://www.w3.org/2001/XMLSchema-instance\"\>  >> "$regfile"
      echo \<item oor:path=\"/org.openoffice.Office.Jobs/Jobs/org.openoffice.Office.Jobs:Job[\'UpdateCheck\']/Arguments\"\>\<prop oor:name=\"AutoCheckEnabled\" oor:op=\"fuse\" oor:type=\"xs:boolean\"\>\<value\>false\</value\>\</prop\>\</item\>  >> $regfile
      echo \</oor:items\> >> "$regfile"
      chown -R "$idx":$(id -gn "$idx") /home/"$idx"/.config/libreoffice
    fi
done
regfile=/etc/skel/.config/libreoffice/4/user/registrymodifications.xcu
if [ ! -e $regfile ]; then
  mkdir -p /etc/skel/.config/libreoffice/4/user
  echo \<?xml version=\"1.0\" encoding=\"UTF-8\"?\>  >> "$regfile"
  echo \<oor:items xmlns:oor=\"https://openoffice.org/2001/registry\" xmlns:xs=\"https://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"https://www.w3.org/2001/XMLSchema-instance\"\>  >> "$regfile"
  echo \<item oor:path=\"/org.openoffice.Office.Jobs/Jobs/org.openoffice.Office.Jobs:Job[\'UpdateCheck\']/Arguments\"\>\<prop oor:name=\"AutoCheckEnabled\" oor:op=\"fuse\" oor:type=\"xs:boolean\"\>\<value\>false\</value\>\</prop\>\</item\>  >> "$regfile"
  echo \</oor:items\> >> $regfile
fi
/usr/bin/zenity --timeout 8 --title=LO_OfflineInstall --width=400 --info --text 'LibreOffice is now installed'
for idx in $SYSUSERS
  do
  find /home/"$idx" -maxdepth 1 -type f \( ! -iname ".*" \) -name "core.[:0-9:]*" -exec rm {} \;
done
exit 0
