//i2c.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2012-2013
 *
 *  This file is part of aroarfw, a RoarAudio framework for
 *  embedded systems (Controlers).
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  or (at your option) any later version as published by
 *  the Free Software Foundation.
 *
 *  aroarfw is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef _AROARFW_I2C_H_
#define _AROARFW_I2C_H_

#include <stdint.h>
#include <aroarfw/types.h>

//! Offset of interface version
#define I2C_OFFSET_IFVERSION          0x00
//! Offset of status byte 0
#define I2C_OFFSET_STATUS0            0x01
//! offset of bank select byte (command byte)
#define I2C_OFFSET_BANKSELECT         0x02
//! Offset of device error code
#define I2C_OFFSET_DEVERROR           0x03
//! Offset of bank data
#define I2C_OFFSET_BANKDATA           0x04

//! Version of the current interface
#define RI2C_INTERFACE_VERSION        0x00

//! Initial value for status byte 0
#define RI2C_STATUS0_NONE             0x00
//! Device ready (device has fully booted or reseted)
#define RI2C_STATUS0_DEVICE_READY     0x01
//! Seflcheck passed
#define RI2C_STATUS0_SELFCHECK_PASSED 0x02
//! Selfcheck returned error
#define RI2C_STATUS0_SELFCHECK_ERROR  0x04
//! There are panding device status updates (e.g. <b>any</b> DAC or GPI level change)
#define RI2C_STATUS0_UPDATES_PENDING  0x08

//! Initial value for status byte 1
#define RI2C_STATUS1_NONE             0x00
//! Initial value for status byte 2
#define RI2C_STATUS2_NONE             0x00

//! Caps Byte 0 for RI2C_DEV_BRIDGE: No caps set.
#define RI2C_CAPS0_BRIDGE_NONE        0x00
//! Caps Byte 0 for RI2C_DEV_BRIDGE: Network present (any kind of network).
#define RI2C_CAPS0_BRIDGE_NETWORK     0x01
//! Caps Byte 0 for RI2C_DEV_BRIDGE: Ethernet present.
#define RI2C_CAPS0_BRIDGE_ETHERNET    0x02
//! Caps Byte 0 for RI2C_DEV_BRIDGE: IC present.
#define RI2C_CAPS0_BRIDGE_I2C         0x04
//! Caps Byte 0 for RI2C_DEV_BRIDGE: SPI present.
#define RI2C_CAPS0_BRIDGE_SPI         0x08
//! Caps Byte 0 for RI2C_DEV_BRIDGE: DMX512 present.
#define RI2C_CAPS0_BRIDGE_DMX512      0x10
//! Caps Byte 0 for RI2C_DEV_BRIDGE: MIDI present.
#define RI2C_CAPS0_BRIDGE_MIDI        0x20
//! Caps Byte 0 for RI2C_DEV_BRIDGE: Wavefrom IO present.
#define RI2C_CAPS0_BRIDGE_WAVEFORM    0x40
//! Caps Byte 0 for RI2C_DEV_BRIDGE: Reserved bit.
#define RI2C_CAPS0_BRIDGE_RESERVED7   0x80

//! Type for storing IC slave addresses
typedef uint8_t ri2c_addr_t;

//! Type for device types
typedef enum {
 //! Most generic device. Supports bank 0
 RI2C_DEV_GENERIC            = 0x00,

// 1-63: RAF Defined types
 //! This is a bridge device. It converts between at least two diffrent communication channels. Subtypes are defined in ri2c_subtype_bridge_t.
 RI2C_DEV_BRIDGE             = 0x01,

//$ for i in `seq 64 127`; do v=`expr $i - 64`; printf " //! Vendor specific device type %i\n RI2C_DEV_VENDOR%.2i           = %#0.2x,\n" $v $v $i; done
 //! Vendor specific device type 0
 RI2C_DEV_VENDOR00           = 0x40,
 //! Vendor specific device type 1
 RI2C_DEV_VENDOR01           = 0x41,
 //! Vendor specific device type 2
 RI2C_DEV_VENDOR02           = 0x42,
 //! Vendor specific device type 3
 RI2C_DEV_VENDOR03           = 0x43,
 //! Vendor specific device type 4
 RI2C_DEV_VENDOR04           = 0x44,
 //! Vendor specific device type 5
 RI2C_DEV_VENDOR05           = 0x45,
 //! Vendor specific device type 6
 RI2C_DEV_VENDOR06           = 0x46,
 //! Vendor specific device type 7
 RI2C_DEV_VENDOR07           = 0x47,
 //! Vendor specific device type 8
 RI2C_DEV_VENDOR08           = 0x48,
 //! Vendor specific device type 9
 RI2C_DEV_VENDOR09           = 0x49,
 //! Vendor specific device type 10
 RI2C_DEV_VENDOR10           = 0x4a,
 //! Vendor specific device type 11
 RI2C_DEV_VENDOR11           = 0x4b,
 //! Vendor specific device type 12
 RI2C_DEV_VENDOR12           = 0x4c,
 //! Vendor specific device type 13
 RI2C_DEV_VENDOR13           = 0x4d,
 //! Vendor specific device type 14
 RI2C_DEV_VENDOR14           = 0x4e,
 //! Vendor specific device type 15
 RI2C_DEV_VENDOR15           = 0x4f,
 //! Vendor specific device type 16
 RI2C_DEV_VENDOR16           = 0x50,
 //! Vendor specific device type 17
 RI2C_DEV_VENDOR17           = 0x51,
 //! Vendor specific device type 18
 RI2C_DEV_VENDOR18           = 0x52,
 //! Vendor specific device type 19
 RI2C_DEV_VENDOR19           = 0x53,
 //! Vendor specific device type 20
 RI2C_DEV_VENDOR20           = 0x54,
 //! Vendor specific device type 21
 RI2C_DEV_VENDOR21           = 0x55,
 //! Vendor specific device type 22
 RI2C_DEV_VENDOR22           = 0x56,
 //! Vendor specific device type 23
 RI2C_DEV_VENDOR23           = 0x57,
 //! Vendor specific device type 24
 RI2C_DEV_VENDOR24           = 0x58,
 //! Vendor specific device type 25
 RI2C_DEV_VENDOR25           = 0x59,
 //! Vendor specific device type 26
 RI2C_DEV_VENDOR26           = 0x5a,
 //! Vendor specific device type 27
 RI2C_DEV_VENDOR27           = 0x5b,
 //! Vendor specific device type 28
 RI2C_DEV_VENDOR28           = 0x5c,
 //! Vendor specific device type 29
 RI2C_DEV_VENDOR29           = 0x5d,
 //! Vendor specific device type 30
 RI2C_DEV_VENDOR30           = 0x5e,
 //! Vendor specific device type 31
 RI2C_DEV_VENDOR31           = 0x5f,
 //! Vendor specific device type 32
 RI2C_DEV_VENDOR32           = 0x60,
 //! Vendor specific device type 33
 RI2C_DEV_VENDOR33           = 0x61,
 //! Vendor specific device type 34
 RI2C_DEV_VENDOR34           = 0x62,
 //! Vendor specific device type 35
 RI2C_DEV_VENDOR35           = 0x63,
 //! Vendor specific device type 36
 RI2C_DEV_VENDOR36           = 0x64,
 //! Vendor specific device type 37
 RI2C_DEV_VENDOR37           = 0x65,
 //! Vendor specific device type 38
 RI2C_DEV_VENDOR38           = 0x66,
 //! Vendor specific device type 39
 RI2C_DEV_VENDOR39           = 0x67,
 //! Vendor specific device type 40
 RI2C_DEV_VENDOR40           = 0x68,
 //! Vendor specific device type 41
 RI2C_DEV_VENDOR41           = 0x69,
 //! Vendor specific device type 42
 RI2C_DEV_VENDOR42           = 0x6a,
 //! Vendor specific device type 43
 RI2C_DEV_VENDOR43           = 0x6b,
 //! Vendor specific device type 44
 RI2C_DEV_VENDOR44           = 0x6c,
 //! Vendor specific device type 45
 RI2C_DEV_VENDOR45           = 0x6d,
 //! Vendor specific device type 46
 RI2C_DEV_VENDOR46           = 0x6e,
 //! Vendor specific device type 47
 RI2C_DEV_VENDOR47           = 0x6f,
 //! Vendor specific device type 48
 RI2C_DEV_VENDOR48           = 0x70,
 //! Vendor specific device type 49
 RI2C_DEV_VENDOR49           = 0x71,
 //! Vendor specific device type 50
 RI2C_DEV_VENDOR50           = 0x72,
 //! Vendor specific device type 51
 RI2C_DEV_VENDOR51           = 0x73,
 //! Vendor specific device type 52
 RI2C_DEV_VENDOR52           = 0x74,
 //! Vendor specific device type 53
 RI2C_DEV_VENDOR53           = 0x75,
 //! Vendor specific device type 54
 RI2C_DEV_VENDOR54           = 0x76,
 //! Vendor specific device type 55
 RI2C_DEV_VENDOR55           = 0x77,
 //! Vendor specific device type 56
 RI2C_DEV_VENDOR56           = 0x78,
 //! Vendor specific device type 57
 RI2C_DEV_VENDOR57           = 0x79,
 //! Vendor specific device type 58
 RI2C_DEV_VENDOR58           = 0x7a,
 //! Vendor specific device type 59
 RI2C_DEV_VENDOR59           = 0x7b,
 //! Vendor specific device type 60
 RI2C_DEV_VENDOR60           = 0x7c,
 //! Vendor specific device type 61
 RI2C_DEV_VENDOR61           = 0x7d,
 //! Vendor specific device type 62
 RI2C_DEV_VENDOR62           = 0x7e,
 //! Vendor specific device type 63
 RI2C_DEV_VENDOR63           = 0x7f
} ri2c_dev_t;

//! Subtype for devices of type RI2C_DEV_BRIDGE
typedef enum {
 //! Generic bridge device. Can be used as prent for vendor specific bridges.
 RI2C_SUBTYPE_BRIDGE_GENERIC            = 0x00,
 //! This is a media converter. It converts between two (or more) low level protocols and physical layers.
 RI2C_SUBTYPE_BRIDGE_CONVERTER          = 0x01
} ri2c_subtype_bridge_t;

//! Type for memory banks (commands)
typedef enum {
// 0-31: Generic
 //! Generic device information
 RI2C_BANK_DEVINFO           = 0x00,
 //! Generic control of the device
 RI2C_BANK_SYSCTL            = 0x01,
 //! General Purpose Digital Input/Output
 RI2C_BANK_GPDIO             = 0x02,
 //! General Purpose Analog Input/Output
 RI2C_BANK_GPAIO             = 0x03,
// 32-63: RAF Defined

// DISPLAY interface?
 //! DMX512 data
 RI2C_BANK_DMX512            = 0x3f,

// 64-95: RAF Defined Type/Sub-Type specific

//$ for i in `seq 64 95`; do v=`expr $i - 64`; printf " //! Assigned Type and Subtype specific bank %i\n RI2C_BANK_TYPEST%.2i          = %#0.2x,\n" $v $v $i; done
 //! Assigned Type and Subtype specific bank 0
 RI2C_BANK_TYPEST00          = 0x40,
 //! Assigned Type and Subtype specific bank 1
 RI2C_BANK_TYPEST01          = 0x41,
 //! Assigned Type and Subtype specific bank 2
 RI2C_BANK_TYPEST02          = 0x42,
 //! Assigned Type and Subtype specific bank 3
 RI2C_BANK_TYPEST03          = 0x43,
 //! Assigned Type and Subtype specific bank 4
 RI2C_BANK_TYPEST04          = 0x44,
 //! Assigned Type and Subtype specific bank 5
 RI2C_BANK_TYPEST05          = 0x45,
 //! Assigned Type and Subtype specific bank 6
 RI2C_BANK_TYPEST06          = 0x46,
 //! Assigned Type and Subtype specific bank 7
 RI2C_BANK_TYPEST07          = 0x47,
 //! Assigned Type and Subtype specific bank 8
 RI2C_BANK_TYPEST08          = 0x48,
 //! Assigned Type and Subtype specific bank 9
 RI2C_BANK_TYPEST09          = 0x49,
 //! Assigned Type and Subtype specific bank 10
 RI2C_BANK_TYPEST10          = 0x4a,
 //! Assigned Type and Subtype specific bank 11
 RI2C_BANK_TYPEST11          = 0x4b,
 //! Assigned Type and Subtype specific bank 12
 RI2C_BANK_TYPEST12          = 0x4c,
 //! Assigned Type and Subtype specific bank 13
 RI2C_BANK_TYPEST13          = 0x4d,
 //! Assigned Type and Subtype specific bank 14
 RI2C_BANK_TYPEST14          = 0x4e,
 //! Assigned Type and Subtype specific bank 15
 RI2C_BANK_TYPEST15          = 0x4f,
 //! Assigned Type and Subtype specific bank 16
 RI2C_BANK_TYPEST16          = 0x50,
 //! Assigned Type and Subtype specific bank 17
 RI2C_BANK_TYPEST17          = 0x51,
 //! Assigned Type and Subtype specific bank 18
 RI2C_BANK_TYPEST18          = 0x52,
 //! Assigned Type and Subtype specific bank 19
 RI2C_BANK_TYPEST19          = 0x53,
 //! Assigned Type and Subtype specific bank 20
 RI2C_BANK_TYPEST20          = 0x54,
 //! Assigned Type and Subtype specific bank 21
 RI2C_BANK_TYPEST21          = 0x55,
 //! Assigned Type and Subtype specific bank 22
 RI2C_BANK_TYPEST22          = 0x56,
 //! Assigned Type and Subtype specific bank 23
 RI2C_BANK_TYPEST23          = 0x57,
 //! Assigned Type and Subtype specific bank 24
 RI2C_BANK_TYPEST24          = 0x58,
 //! Assigned Type and Subtype specific bank 25
 RI2C_BANK_TYPEST25          = 0x59,
 //! Assigned Type and Subtype specific bank 26
 RI2C_BANK_TYPEST26          = 0x5a,
 //! Assigned Type and Subtype specific bank 27
 RI2C_BANK_TYPEST27          = 0x5b,
 //! Assigned Type and Subtype specific bank 28
 RI2C_BANK_TYPEST28          = 0x5c,
 //! Assigned Type and Subtype specific bank 29
 RI2C_BANK_TYPEST29          = 0x5d,
 //! Assigned Type and Subtype specific bank 30
 RI2C_BANK_TYPEST30          = 0x5e,
 //! Assigned Type and Subtype specific bank 31
 RI2C_BANK_TYPEST31          = 0x5f,

// 96-127: Vendor + Type/Sub-Type specific
//$ for i in `seq 96 127`; do v=`expr $i - 96`; printf " //! Vendor, Type and Subtype specific bank %i\n RI2C_BANK_VENDOR%.2i          = %#0.2x,\n" $v $v $i; done
 //! Vendor, Type and Subtype specific bank 0
 RI2C_BANK_VENDOR00          = 0x60,
 //! Vendor, Type and Subtype specific bank 1
 RI2C_BANK_VENDOR01          = 0x61,
 //! Vendor, Type and Subtype specific bank 2
 RI2C_BANK_VENDOR02          = 0x62,
 //! Vendor, Type and Subtype specific bank 3
 RI2C_BANK_VENDOR03          = 0x63,
 //! Vendor, Type and Subtype specific bank 4
 RI2C_BANK_VENDOR04          = 0x64,
 //! Vendor, Type and Subtype specific bank 5
 RI2C_BANK_VENDOR05          = 0x65,
 //! Vendor, Type and Subtype specific bank 6
 RI2C_BANK_VENDOR06          = 0x66,
 //! Vendor, Type and Subtype specific bank 7
 RI2C_BANK_VENDOR07          = 0x67,
 //! Vendor, Type and Subtype specific bank 8
 RI2C_BANK_VENDOR08          = 0x68,
 //! Vendor, Type and Subtype specific bank 9
 RI2C_BANK_VENDOR09          = 0x69,
 //! Vendor, Type and Subtype specific bank 10
 RI2C_BANK_VENDOR10          = 0x6a,
 //! Vendor, Type and Subtype specific bank 11
 RI2C_BANK_VENDOR11          = 0x6b,
 //! Vendor, Type and Subtype specific bank 12
 RI2C_BANK_VENDOR12          = 0x6c,
 //! Vendor, Type and Subtype specific bank 13
 RI2C_BANK_VENDOR13          = 0x6d,
 //! Vendor, Type and Subtype specific bank 14
 RI2C_BANK_VENDOR14          = 0x6e,
 //! Vendor, Type and Subtype specific bank 15
 RI2C_BANK_VENDOR15          = 0x6f,
 //! Vendor, Type and Subtype specific bank 16
 RI2C_BANK_VENDOR16          = 0x70,
 //! Vendor, Type and Subtype specific bank 17
 RI2C_BANK_VENDOR17          = 0x71,
 //! Vendor, Type and Subtype specific bank 18
 RI2C_BANK_VENDOR18          = 0x72,
 //! Vendor, Type and Subtype specific bank 19
 RI2C_BANK_VENDOR19          = 0x73,
 //! Vendor, Type and Subtype specific bank 20
 RI2C_BANK_VENDOR20          = 0x74,
 //! Vendor, Type and Subtype specific bank 21
 RI2C_BANK_VENDOR21          = 0x75,
 //! Vendor, Type and Subtype specific bank 22
 RI2C_BANK_VENDOR22          = 0x76,
 //! Vendor, Type and Subtype specific bank 23
 RI2C_BANK_VENDOR23          = 0x77,
 //! Vendor, Type and Subtype specific bank 24
 RI2C_BANK_VENDOR24          = 0x78,
 //! Vendor, Type and Subtype specific bank 25
 RI2C_BANK_VENDOR25          = 0x79,
 //! Vendor, Type and Subtype specific bank 26
 RI2C_BANK_VENDOR26          = 0x7a,
 //! Vendor, Type and Subtype specific bank 27
 RI2C_BANK_VENDOR27          = 0x7b,
 //! Vendor, Type and Subtype specific bank 28
 RI2C_BANK_VENDOR28          = 0x7c,
 //! Vendor, Type and Subtype specific bank 29
 RI2C_BANK_VENDOR29          = 0x7d,
 //! Vendor, Type and Subtype specific bank 30
 RI2C_BANK_VENDOR30          = 0x7e,
 //! Vendor, Type and Subtype specific bank 31
 RI2C_BANK_VENDOR31          = 0x7f
} ri2c_bank_t;

//! Type to store (in packed format) static information for the device info bank (bank 0). This is prefixed with status byte 1 and status byte 2
typedef struct {
 //! Vendor of this device. This is a assigned device vendor ID
 uint8_t vendor;
 //! Vendor specific type of device
 uint8_t type;
 //! Vendor specific subtype of device
 uint8_t subtype;
 //! Vendor specific revision of the device
 uint8_t revision;
 //! Parent device's vendor ID
 uint8_t parentvendor;
 //! Parent device's type ID
 uint8_t parenttype;
 //! Parent device's subtype ID
 uint8_t parentsubtype;
 //! Capabilities of the device (type and subtype depended)
 uint8_t caps[3];
 //! Sieral of the device
 ruuid_t serial;
} __RPACKED__ ri2c_devinfo_data_t;

#endif

//ll
