// { dg-do run { target c++11 } }
// { dg-options "-D__STDCPP_WANT_MATH_SPEC_FUNCS__ -ffp-contract=off" }
// { dg-additional-options "-ffloat-store" { target { m68*-*-* || ia32 } } }
//
// Copyright (C) 2016-2018 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

//  hyperg
//  Compare against values generated by the GNU Scientific Library.
//  The GSL can be found on the web: http://www.gnu.org/software/gsl/
#include <limits>
#include <tr1/cmath>
#if defined(__TEST_DEBUG)
#  include <iostream>
#  define VERIFY(A) \
  if (!(A)) \
    { \
      std::cout << "line " << __LINE__ \
	<< "  max_abs_frac = " << max_abs_frac \
	<< std::endl; \
    }
#else
#  include <testsuite_hooks.h>
#endif
#include <specfun_testcase.h>

// Test data for a=0.0000000000000000, b=0.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data001[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler001 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=0.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data002[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler002 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=0.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data003[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler003 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=0.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data004[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler004 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=0.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data005[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler005 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=0.50000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data006[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler006 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=0.50000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data007[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler007 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=0.50000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data008[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler008 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=0.50000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data009[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler009 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=0.50000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data010[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler010 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=1.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data011[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler011 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=1.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data012[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler012 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=1.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data013[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler013 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=1.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data014[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler014 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=1.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data015[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler015 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=2.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data016[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler016 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=2.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data017[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler017 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=2.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data018[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler018 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=2.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data019[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler019 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=2.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data020[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler020 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=5.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data021[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler021 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=5.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data022[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler022 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=5.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data023[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler023 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=5.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data024[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler024 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=5.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data025[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler025 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=10.000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data026[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler026 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=10.000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data027[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler027 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=10.000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data028[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler028 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=10.000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data029[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler029 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=10.000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data030[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler030 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=20.000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data031[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler031 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=20.000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data032[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler032 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=20.000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data033[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler033 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=20.000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data034[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler034 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, b=20.000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data035[19] =
{
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler035 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=0.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data036[19] =
{
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler036 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=0.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data037[19] =
{
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler037 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=0.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data038[19] =
{
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler038 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=0.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data039[19] =
{
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler039 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=0.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data040[19] =
{
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler040 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=0.50000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16 at index 18
// max(|f - f_GSL| / |f_GSL|): 3.7062685186203797e-16
// mean(f - f_GSL): 1.1686558153949016e-17
// variance(f - f_GSL): 1.0964410526798704e-32
// stddev(f - f_GSL): 1.0471108120346530e-16
const testcase_hyperg<double>
data041[19] =
{
  { 0.91383715388743736, 0.50000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.92151232618202372, 0.50000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.92955086110354845, 0.50000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.93798900119104855, 0.50000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.94686887307107392, 0.50000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.95623987262143295, 0.50000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.96616049387450120, 0.50000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.97670078782187519, 0.50000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.98794573712298384, 0.50000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0129947682256604, 0.50000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0270980168168973, 0.50000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0425304520063581, 0.50000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0595915916161471, 0.50000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0787052023767585, 0.50000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.1005053642285867, 0.50000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.1260196351148746, 0.50000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.1571341977338991, 0.50000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.1982111053717452, 0.50000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler041 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=0.50000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 3.3306690738754696e-16 at index 8
// max(|f - f_GSL| / |f_GSL|): 3.3511582377535958e-16
// mean(f - f_GSL): 4.0902953538821554e-17
// variance(f - f_GSL): 1.9241779613319129e-33
// stddev(f - f_GSL): 4.3865452936586813e-17
const testcase_hyperg<double>
data042[19] =
{
  { 0.95255425675562699, 0.50000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.95712841850078267, 0.50000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.96184734120034554, 0.50000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.96672141255196176, 0.50000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.97176228710138646, 0.50000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.97698311668286308, 0.50000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.98239883902556036, 0.50000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.98802654401961032, 0.50000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.99388594556732701, 0.50000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0063957328951061, 0.50000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0131053706824598, 0.50000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0201679332118803, 0.50000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0276315524377497, 0.50000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0355569942816882, 0.50000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0440233080381554, 0.50000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0531375808028993, 0.50000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0630536689840200, 0.50000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0740149570414563, 0.50000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler042 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=0.50000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 5.5511151231257827e-16 at index 7
// max(|f - f_GSL| / |f_GSL|): 5.5963253065363064e-16
// mean(f - f_GSL): 5.8432790769745078e-18
// variance(f - f_GSL): 2.0022663489405960e-36
// stddev(f - f_GSL): 1.4150146108576393e-18
const testcase_hyperg<double>
data043[19] =
{
  { 0.96694084713323880, 0.50000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.97024454918852632, 0.50000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.97362815600391439, 0.50000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.97709622064205104, 0.50000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.98065374770570635, 0.50000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.98430626119885523, 0.50000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.98805988669621037, 0.50000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.99192145185739655, 0.50000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.99589861079880937, 0.50000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0042354366729904, 0.50000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0086161755545404, 0.50000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0131552481403503, 0.50000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0178679218284707, 0.50000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0227723400312978, 0.50000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0278904483717863, 0.50000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0332494012993474, 0.50000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0388838453357794, 0.50000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0448400142331342, 0.50000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler043 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=0.50000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 3.3306690738754696e-16 at index 7
// max(|f - f_GSL| / |f_GSL|): 3.3511105824376917e-16
// mean(f - f_GSL): -1.7529837230923523e-17
// variance(f - f_GSL): 3.3658097325691423e-33
// stddev(f - f_GSL): 5.8015599045163211e-17
const testcase_hyperg<double>
data044[19] =
{
  { 0.97456073259047449, 0.50000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.97715689327833399, 0.50000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.97980416868943110, 0.50000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.98250498942832487, 0.50000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.98526199049760810, 0.50000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.98807803762902791, 0.50000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.99095625840920332, 0.50000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.99390007937387959, 0.50000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.99691327061866730, 0.50000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0031648997547440, 0.50000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0064131494767281, 0.50000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0097505810668461, 0.50000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0131838138968663, 0.50000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0167204326938339, 0.50000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0203692279382193, 0.50000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0241405318057402, 0.50000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0280467087844301, 0.50000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0321029179180026, 0.50000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler044 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=0.50000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 1.1102230246251565e-16 at index 7
// max(|f - f_GSL| / |f_GSL|): 1.1156911610791411e-16
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data045[19] =
{
  { 0.97930223035212138, 0.50000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.98144406855076427, 0.50000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.98362155940297280, 0.50000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.98583616201745783, 0.50000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.98808944235385032, 0.50000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.99038308530635433, 0.50000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.99271890872975732, 0.50000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.99509887982916734, 0.50000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.99752513445413604, 0.50000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0025260228440118, 0.50000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0051060015613384, 0.50000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0077430276253163, 0.50000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.0104405359789990, 0.50000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.0132023689128868, 0.50000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.0160328583559475, 0.50000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.0189369344885053, 0.50000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.0219202735809589, 0.50000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.0249895076611382, 0.50000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler045 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=1.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 8.8817841970012523e-16 at index 18
// max(|f - f_GSL| / |f_GSL|): 5.8452254859313207e-16
// mean(f - f_GSL): 8.1805907077643109e-17
// variance(f - f_GSL): 3.8131160349224712e-32
// stddev(f - f_GSL): 1.9527201629835421e-16
const testcase_hyperg<double>
data046[19] =
{
  { 0.84089972268671531, 0.50000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.85410196624968460, 0.50000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.86811566011579955, 0.50000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.88303688022450522, 0.50000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.89897948556635621, 0.50000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.91607978309961580, 0.50000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.93450283399425327, 0.50000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.95445115010332193, 0.50000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.97617696340303095, 0.50000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0263340389897240, 0.50000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0557280900008412, 0.50000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0889331564394962, 0.50000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.1270166537925830, 0.50000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.1715728752538095, 0.50000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.2251482265544145, 0.50000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.2922212642709543, 0.50000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.3819660112501042, 0.50000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.5194938532959121, 0.50000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler046 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=1.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 2.2204460492503131e-16 at index 17
// max(|f - f_GSL| / |f_GSL|): 1.9508457915403988e-16
// mean(f - f_GSL): 2.3373116307898031e-17
// variance(f - f_GSL): 2.3146198993753289e-33
// stddev(f - f_GSL): 4.8110496769159731e-17
const testcase_hyperg<double>
data047[19] =
{
  { 0.90992197313391454, 0.50000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.91822592662244484, 0.50000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.92687104566419554, 0.50000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.93588628166548848, 0.50000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.94530459215552909, 0.50000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.95516374875247434, 0.50000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.96550736800511816, 0.50000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.97638624595136270, 0.50000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.98786011482678993, 0.50000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0128914530682316, 0.50000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0266391040215350, 0.50000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0413732738729464, 0.50000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0572599536532992, 0.50000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0745166004060953, 0.50000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0934387388831386, 0.50000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.1144486980714641, 0.50000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.1381966011250106, 0.50000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.1658171625342397, 0.50000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler047 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=1.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16 at index 7
// max(|f - f_GSL| / |f_GSL|): 4.5130734546221216e-16
// mean(f - f_GSL): 4.6746232615796062e-17
// variance(f - f_GSL): 1.2814504633219814e-34
// stddev(f - f_GSL): 1.1320116886861114e-17
const testcase_hyperg<double>
data048[19] =
{
  { 0.93641908369732896, 0.50000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.94256349654111271, 0.50000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.94890138508461319, 0.50000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.95544578858430029, 0.50000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.96221121193620762, 0.50000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.96921386948293542, 0.50000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.97647198488394704, 0.50000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.98400616412578656, 0.50000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.99183986544963032, 0.50000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0085177124149158, 0.50000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0174294150407122, 0.50000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0267781897388850, 0.50000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0366157405967287, 0.50000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0470052068648839, 0.50000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0580253905513313, 0.50000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0697774741209765, 0.50000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0823965556448414, 0.50000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0960739512057103, 0.50000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler048 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=1.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 2.2204460492503131e-16 at index 7
// max(|f - f_GSL| / |f_GSL|): 2.2476491960642283e-16
// mean(f - f_GSL): -5.8432790769745078e-18
// variance(f - f_GSL): 2.0022663489405960e-36
// stddev(f - f_GSL): 1.4150146108576393e-18
const testcase_hyperg<double>
data049[19] =
{
  { 0.95069883346936235, 0.50000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.95559618047704131, 0.50000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.96061938755931664, 0.50000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.96577553912851333, 0.50000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.97107239473807716, 0.50000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.97651848528588481, 0.50000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.98212322830227128, 0.50000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.98789706736195781, 0.50000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.99385164237825074, 0.50000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0063568569383123, 0.50000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0129389344715818, 0.50000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0197653907773940, 0.50000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0268583912277143, 0.50000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0342438793937092, 0.50000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0419526514766855, 0.50000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0500219124976327, 0.50000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0584976491907043, 0.50000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0674385240268101, 0.50000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler049 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=1.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data050[19] =
{
  { 0.95968319138913905, 0.50000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.96376169072755802, 0.50000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.96792900082729372, 0.50000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.97218942798115737, 0.50000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.97654763592586835, 0.50000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.98100869054353890, 0.50000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.98557811238699278, 0.50000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.99026193885795544, 0.50000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.99506679842072221, 0.50000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0050696417919618, 0.50000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0102847452747090, 0.50000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0156554225057022, 0.50000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.0211930882963096, 0.50000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.0269107343740711, 0.50000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.0328232917216298, 0.50000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.0389481230247195, 0.50000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.0453057164134614, 0.50000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.0519207114461246, 0.50000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler050 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=2.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.8577584504832499e-16
// mean(f - f_GSL): 5.8432790769745078e-18
// variance(f - f_GSL): 1.1262748212790853e-32
// stddev(f - f_GSL): 1.0612609581432294e-16
const testcase_hyperg<double>
data051[19] =
{
  { 0.72547625011001160, 0.50000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.74535599249992990, 0.50000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.76696498884737041, 0.50000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.79056941504209477, 0.50000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.81649658092772603, 0.50000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.84515425472851669, 0.50000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.87705801930702931, 0.50000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.91287092917527690, 0.50000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.95346258924559224, 0.50000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0540925533894598, 0.50000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.1180339887498949, 0.50000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.1952286093343938, 0.50000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.2909944487358058, 0.50000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.4142135623730951, 0.50000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.5811388300841900, 0.50000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.8257418583505542, 0.50000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 2.2360679774997898, 0.50000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 3.1622776601683809, 0.50000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler051 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=2.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 6.6613381477509392e-16 at index 18
// max(|f - f_GSL| / |f_GSL|): 4.6340403913587147e-16
// mean(f - f_GSL): 7.5962628000668607e-17
// variance(f - f_GSL): 2.0425119025543020e-32
// stddev(f - f_GSL): 1.4291647569662155e-16
const testcase_hyperg<double>
data052[19] =
{
  { 0.83664260086443765, 0.50000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.85046584300227079, 0.50000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.86509574979651649, 0.50000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.88062082573041911, 0.50000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.89714464248521597, 0.50000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.91478946588967569, 0.50000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.93370105322348607, 0.50000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.95405511057700887, 0.50000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.97606616007978142, 0.50000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0261916902334731, 0.50000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0550723519434702, 0.50000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0872106588188091, 0.50000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.1233801699379022, 0.50000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.1646752981725688, 0.50000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.2127272514219511, 0.50000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.2701518651068637, 0.50000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.3416407864998725, 0.50000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.4374795179111106, 0.50000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler052 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=2.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 3.3306690738754696e-16 at index 8
// max(|f - f_GSL| / |f_GSL|): 3.3853500746952663e-16
// mean(f - f_GSL): 1.1686558153949016e-17
// variance(f - f_GSL): 2.5949371882270124e-33
// stddev(f - f_GSL): 5.0940525990875012e-17
const testcase_hyperg<double>
data053[19] =
{
  { 0.88195381730235822, 0.50000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.89265078469555081, 0.50000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.90382937908303673, 0.50000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.91553161389880600, 0.50000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.92780530349281509, 0.50000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.94070521140346020, 0.50000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.95429450630523349, 0.50000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.96864663325785849, 0.50000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.98384775588541795, 0.50000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0172258496884334, 0.50000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0356742479163461, 0.50000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0555293036908924, 0.50000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0770231491562379, 0.50000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.1004557416484888, 0.50000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.1262270515731978, 0.50000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.1548932919125088, 0.50000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.1872757758134724, 0.50000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.2247091713458949, 0.50000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler053 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=2.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 2.2204460492503131e-16 at index 17
// max(|f - f_GSL| / |f_GSL|): 1.9683492716399738e-16
// mean(f - f_GSL): 1.7529837230923523e-17
// variance(f - f_GSL): 2.4527762774522302e-33
// stddev(f - f_GSL): 4.9525511380017369e-17
const testcase_hyperg<double>
data054[19] =
{
  { 0.90716919697107279, 0.50000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.91592299407142508, 0.50000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.92500027075874192, 0.50000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.93442464185467122, 0.50000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.94422248683737076, 0.50000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.95442341810133347, 0.50000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.96506085725516355, 0.50000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.97617275213704069, 0.50000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.98780247986309799, 0.50000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0128233505813447, 0.50000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0263406246541855, 0.50000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0406326381700366, 0.50000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0557966239802845, 0.50000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0719515075786321, 0.50000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0892457392422055, 0.50000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.1078695188000958, 0.50000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.1280752258974340, 0.50000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.1502152002706476, 0.50000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler054 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=2.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 3.3306690738754696e-16 at index 8
// max(|f - f_GSL| / |f_GSL|): 3.3636359087105992e-16
// mean(f - f_GSL): 2.9216395384872539e-17
// variance(f - f_GSL): 2.1804680539963092e-33
// stddev(f - f_GSL): 4.6695482158302094e-17
const testcase_hyperg<double>
data055[19] =
{
  { 0.92336416053263082, 0.50000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.93078397248364542, 0.50000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.93843714333600259, 0.50000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.94633837784068098, 0.50000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.95450388104967876, 0.50000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.96295158125742752, 0.50000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.97170139827854329, 0.50000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.98077556918512687, 0.50000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.99019904777750845, 0.50000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0102104261941198, 0.50000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0208669540935695, 0.50000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0320118665407505, 0.50000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.0436944599504387, 0.50000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.0559728828278145, 0.50000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.0689166967761712, 0.50000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.0826105758119842, 0.50000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.0971599106346146, 0.50000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.1126998828023964, 0.50000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler055 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=5.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 4.5474735088646412e-13 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.5124797514980592e-15
// mean(f - f_GSL): 2.5336458077761468e-14
// variance(f - f_GSL): 1.0813211674051158e-26
// stddev(f - f_GSL): 1.0398659372270619e-13
const testcase_hyperg<double>
data056[19] =
{
  { 0.52275983209457544, 0.50000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.54700336898143009, 0.50000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.57468955512602038, 0.50000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.60665490543315048, 0.50000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.64403057859056190, 0.50000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.68838183648623719, 0.50000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.74193265039311118, 0.50000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.80794095908995300, 0.50000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.89135275749639320, 0.50000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.1469266219310688, 0.50000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.3552340708357493, 0.50000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.6690840478838305, 0.50000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 2.1815415453174500, 0.50000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 3.1156892546032235, 0.50000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 5.1109077417760416, 0.50000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 10.560352936466318, 0.50000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 33.541019662496815, 0.50000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 300.66343065819723, 0.50000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler056 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=5.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 8.8817841970012523e-15 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.3217255411112292e-15
// mean(f - f_GSL): 6.8950693108299193e-16
// variance(f - f_GSL): 3.9356627445430313e-30
// stddev(f - f_GSL): 1.9838504844224102e-15
const testcase_hyperg<double>
data057[19] =
{
  { 0.68252041951139286, 0.50000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.70394732624993395, 0.50000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.72748884971552052, 0.50000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.75351147371199667, 0.50000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.78247589005573737, 0.50000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.81497017420249795, 0.50000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.85175826875009608, 0.50000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.89385278481745867, 0.50000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.94262778709507411, 0.50000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0687327277420910, 0.50000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.1529725508983291, 0.50000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.2592587134058799, 0.50000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.3985773194637896, 0.50000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.5909902576697317, 0.50000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.8776023607249752, 0.50000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 2.3582499003694664, 0.50000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 3.3541019662496838, 0.50000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 6.7198400278578028, 0.50000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler057 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=5.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 2.6645352591003757e-15 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.2228264607471081e-15
// mean(f - f_GSL): 2.2788788400200583e-16
// variance(f - f_GSL): 3.4817209315093131e-31
// stddev(f - f_GSL): 5.9006109272763554e-16
const testcase_hyperg<double>
data058[19] =
{
  { 0.75755211927082600, 0.50000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.77603550233010965, 0.50000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.79596241913438504, 0.50000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.81753360792105212, 0.50000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.84099165409805532, 0.50000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.86663303852180906, 0.50000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.89482475828629915, 0.50000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.92602774279590350, 0.50000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.96083064727087386, 0.50000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0445570841313008, 0.50000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0959004638926033, 0.50000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.1560106261370562, 0.50000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.2278121770678148, 0.50000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.3158640214709998, 0.50000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.4278095344155000, 0.50000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.5778700502946617, 0.50000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.7972173289196469, 0.50000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 2.1789970569269732, 0.50000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler058 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=5.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 8.8817841970012523e-16 at index 18
// max(|f - f_GSL| / |f_GSL|): 5.6109827053892650e-16
// mean(f - f_GSL): 7.5962628000668607e-17
// variance(f - f_GSL): 3.8685788127881258e-32
// stddev(f - f_GSL): 1.9668703090921186e-16
const testcase_hyperg<double>
data059[19] =
{
  { 0.80270093579329460, 0.50000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.81884974572462765, 0.50000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.83605266330015260, 0.50000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.85443340762796027, 0.50000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.87413762182790711, 0.50000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.89533826626907298, 0.50000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.91824276674115313, 0.50000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.94310265050720576, 0.50000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.97022678857609712, 0.50000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0329098673199812, 0.50000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0695865684573389, 0.50000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.1108642103944570, 0.50000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.1578795055970506, 0.50000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.2122394794169442, 0.50000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.2763274721556934, 0.50000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.3539179650251021, 0.50000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.4515986118197148, 0.50000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.5829284571614224, 0.50000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler059 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=5.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16 at index 18
// max(|f - f_GSL| / |f_GSL|): 3.2099086385883890e-16
// mean(f - f_GSL): 5.8432790769745078e-17
// variance(f - f_GSL): 8.7218722159852367e-33
// stddev(f - f_GSL): 9.3390964316604188e-17
const testcase_hyperg<double>
data060[19] =
{
  { 0.83322694172301981, 0.50000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.84753931604765675, 0.50000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.86265784532195022, 0.50000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.87866479300707090, 0.50000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.89565516540263501, 0.50000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.91373946207610557, 0.50000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.93304721345881914, 0.50000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.95373159512905148, 0.50000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.97597554238828121, 0.50000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0260752851887982, 0.50000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0545371197996178, 0.50000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0858099017045830, 0.50000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.1204416568688709, 0.50000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.1591587835964847, 0.50000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.2029564720303347, 0.50000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.2532588722007874, 0.50000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.3122319926925459, 0.50000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.3834948587364102, 0.50000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler060 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=10.000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 1.4901161193847656e-08 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.8229127098647768e-15
// mean(f - f_GSL): 7.8543415046726153e-10
// variance(f - f_GSL): 1.1684633485497506e-17
// stddev(f - f_GSL): 3.4182793164832956e-09
const testcase_hyperg<double>
data061[19] =
{
  { 0.37727530159464628, 0.50000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.39816010922169059, 0.50000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.42283703041362447, 0.50000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.45255640448730527, 0.50000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.48919507154431119, 0.50000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.53569358917731902, 0.50000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.59689778897029577, 0.50000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.68128587569875765, 0.50000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.80478739308790359, 0.50000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.3408664196153621, 0.50000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 2.0175364359923882, 0.50000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 3.6011214553736646, 0.50000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 8.1799429939495489, 0.50000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 25.644834637536000, 0.50000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 123.13738891597615, 0.50000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1088.7122410321385, 0.50000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 27358.291704709951, 0.50000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 8174369.0266732639, 0.50000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler061 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=10.000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 2.0008883439004421e-11 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.5684473872214445e-15
// mean(f - f_GSL): 1.0626587329385841e-12
// variance(f - f_GSL): 2.1050090066796454e-23
// stddev(f - f_GSL): 4.5880377141863658e-12
const testcase_hyperg<double>
data062[19] =
{
  { 0.53905528308450823, 0.50000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.56235533974376162, 0.50000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.58887657983263575, 0.50000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.61941227047262937, 0.50000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.65504896640793864, 0.50000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.69731666644529977, 0.50000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.74844073299399116, 0.50000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.81178446800105830, 0.50000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.89266981277598045, 0.50000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.1497248473106778, 0.50000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.3729717112654578, 0.50000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.7374982340374392, 0.50000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 2.4134479340960602, 0.50000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 3.9191255240471192, 0.50000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 8.3316373077761270, 0.50000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 28.323020339843417, 0.50000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 225.84286572747891, 0.50000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 12757.127591286826, 0.50000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler062 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=10.000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 1.9895196601282805e-13 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.4567107859209851e-15
// mean(f - f_GSL): 1.1043797455481820e-14
// variance(f - f_GSL): 2.0706176432127926e-27
// stddev(f - f_GSL): 4.5504039855959963e-14
const testcase_hyperg<double>
data063[19] =
{
  { 0.62672622092226027, 0.50000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.64931010269769840, 0.50000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.67448067519076293, 0.50000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.70276306239803643, 0.50000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.73484179773087521, 0.50000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.77162761412743874, 0.50000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.81436116844816553, 0.50000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.86477994787944579, 0.50000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.92539820516603888, 0.50000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0945599448210315, 0.50000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.2190897395597269, 0.50000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.3916844336856475, 0.50000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.6484497630432020, 0.50000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 2.0717772717131155, 0.50000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 2.8893613630810924, 0.50000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 4.9459404075413573, 0.50000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 13.487394149998716, 0.50000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 136.57616044014080, 0.50000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler063 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=10.000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 1.2434497875801753e-14 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.3245081211977792e-15
// mean(f - f_GSL): 8.5311874523827817e-16
// variance(f - f_GSL): 7.8655509529357183e-30
// stddev(f - f_GSL): 2.8045589587198410e-15
const testcase_hyperg<double>
data064[19] =
{
  { 0.68421604440344319, 0.50000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.70548098055548925, 0.50000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.72884342311710337, 0.50000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.75466953437856232, 0.50000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.78342090924662589, 0.50000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.81568884278645115, 0.50000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.85224480241465261, 0.50000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.89411692571131685, 0.50000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.94270986892954811, 0.50000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0688682849120232, 0.50000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.1537004376097553, 0.50000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.2615455028370031, 0.50000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.4045541456153443, 0.50000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.6057216489444517, 0.50000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.9146603020550739, 0.50000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 2.4617931307620307, 0.50000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 3.7267799624996498, 0.50000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 9.3880118036248721, 0.50000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler064 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=10.000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.8577584504832499e-16
// mean(f - f_GSL): 5.8432790769745078e-18
// variance(f - f_GSL): 1.1262748212790853e-32
// stddev(f - f_GSL): 1.0612609581432294e-16
const testcase_hyperg<double>
data065[19] =
{
  { 0.72547625011001160, 0.50000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.74535599249992990, 0.50000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.76696498884737041, 0.50000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.79056941504209477, 0.50000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.81649658092772603, 0.50000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.84515425472851669, 0.50000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.87705801930702931, 0.50000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.91287092917527690, 0.50000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.95346258924559224, 0.50000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0540925533894598, 0.50000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.1180339887498949, 0.50000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.1952286093343938, 0.50000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.2909944487358058, 0.50000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.4142135623730951, 0.50000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.5811388300841900, 0.50000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.8257418583505542, 0.50000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 2.2360679774997898, 0.50000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 3.1622776601683809, 0.50000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler065 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=20.000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 48.000000000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.8556481344874416e-15
// mean(f - f_GSL): 2.5263190030329112
// variance(f - f_GSL): 121.26314075575490
// stddev(f - f_GSL): 11.011954447588080
const testcase_hyperg<double>
data066[19] =
{
  { 0.26690449940521549, 0.50000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.28252302866181833, 0.50000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.30123616141153836, 0.50000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.32421384687602633, 0.50000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.35334630811776774, 0.50000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.39191793127466995, 0.50000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.44620488618129212, 0.50000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.52980896919265719, 0.50000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.67754711477562324, 0.50000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.9567557771780317, 0.50000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 6.1816042148333272, 0.50000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 35.653088618561227, 0.50000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 377.51482843180133, 0.50000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 7645.8816551195359, 0.50000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 354791.74537980522, 0.50000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 57009889.966639392, 0.50000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 83771357024.863937, 0.50000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 25866972896377436., 0.50000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler066 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=20.000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 0.011718750000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.7519521419033478e-15
// mean(f - f_GSL): 0.00061678102606403001
// variance(f - f_GSL): 7.2278413174892008e-06
// stddev(f - f_GSL): 0.0026884644906506020
const testcase_hyperg<double>
data067[19] =
{
  { 0.40342659436153389, 0.50000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.42420571192034318, 0.50000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.44852768286073041, 0.50000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.47751245808592863, 0.50000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.51283632632707765, 0.50000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.55713468814894329, 0.50000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.61481320817757346, 0.50000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.69383483410097213, 0.50000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.81012002526006044, 0.50000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.3622225506603911, 0.50000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 2.2349513086109027, 0.50000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 5.1864917536761723, 0.50000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 21.020560423779497, 0.50000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 175.19649997100612, 0.50000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 3467.1587803688708, 0.50000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 225003.88683446089, 0.50000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 110837674.65652709, 0.50000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 6688966964170.9326, 0.50000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler067 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=20.000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 1.4305114746093750e-05 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.9261147266353426e-15
// mean(f - f_GSL): 7.5292535813082699e-07
// variance(f - f_GSL): 1.0770292922645316e-11
// stddev(f - f_GSL): 3.2818124447697064e-06
const testcase_hyperg<double>
data068[19] =
{
  { 0.48716309885816822, 0.50000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.50965859152542337, 0.50000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.53554809210658938, 0.50000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.56576689207507136, 0.50000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.60164849637133655, 0.50000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.64516711595404408, 0.50000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.69938278735493553, 0.50000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.76931621518401860, 0.50000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.86381808725530662, 0.50000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.2152051956815531, 0.50000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.6052546785425557, 0.50000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 2.4765586046012635, 0.50000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 5.1564492216997611, 0.50000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 18.446158392136365, 0.50000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 150.44577670123971, 0.50000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 3862.6317400116104, 0.50000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 632428.34833625401, 0.50000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 7426927663.3810987, 0.50000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler068 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=20.000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 4.0978193283081055e-08 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.7692881266931270e-15
// mean(f - f_GSL): 2.1571346930926438e-09
// variance(f - f_GSL): 8.8377830897836260e-17
// stddev(f - f_GSL): 9.4009484041683924e-09
const testcase_hyperg<double>
data069[19] =
{
  { 0.54703266209548373, 0.50000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.56997321774144960, 0.50000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.59603026159654982, 0.50000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.62596978851120511, 0.50000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.66084565876898915, 0.50000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.70215256667232862, 0.50000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.75208916592008568, 0.50000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.81403631111658625, 0.50000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.89348608489854597, 0.50000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.1517793185139173, 0.50000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.3878110313656606, 0.50000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.8061071794572381, 0.50000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 2.7148594517859612, 0.50000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 5.4529435709049361, 0.50000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 19.487310275377109, 0.50000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 191.69079165937592, 0.50000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 10218.543981792311, 0.50000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 23160836.646584522, 0.50000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler069 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, b=20.000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 2.9103830456733704e-10 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.6694673196526424e-15
// mean(f - f_GSL): 1.5333453804912193e-11
// variance(f - f_GSL): 4.4575621294589140e-21
// stddev(f - f_GSL): 6.6764976817631821e-11
const testcase_hyperg<double>
data070[19] =
{
  { 0.59292067298616025, 0.50000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.61572496720679892, 0.50000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.64135339122875590, 0.50000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.67043457419280461, 0.50000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.70380956268170969, 0.50000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.74263251901495264, 0.50000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.78853555445528289, 0.50000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.84391122775673755, 0.50000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.91242401018807373, 0.50000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0.50000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.1169059681274873, 0.50000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.2825928301302669, 0.50000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.5385937789924939, 0.50000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.9895771187893914, 0.50000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 2.9707335806970168, 0.50000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 6.0299506157180467, 0.50000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 24.259090336955669, 0.50000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 406.27267173257223, 0.50000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 174330.03997220617, 0.50000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler070 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=0.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data071[19] =
{
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler071 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=0.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data072[19] =
{
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler072 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=0.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data073[19] =
{
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler073 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=0.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data074[19] =
{
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler074 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=0.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data075[19] =
{
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler075 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=0.50000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 8.8817841970012523e-16 at index 18
// max(|f - f_GSL| / |f_GSL|): 5.8452254859313207e-16
// mean(f - f_GSL): 8.1805907077643109e-17
// variance(f - f_GSL): 3.8131160349224712e-32
// stddev(f - f_GSL): 1.9527201629835421e-16
const testcase_hyperg<double>
data076[19] =
{
  { 0.84089972268671531, 1.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.85410196624968460, 1.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.86811566011579955, 1.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.88303688022450522, 1.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.89897948556635621, 1.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.91607978309961580, 1.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.93450283399425327, 1.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.95445115010332193, 1.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.97617696340303095, 1.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0263340389897240, 1.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0557280900008412, 1.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0889331564394962, 1.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.1270166537925830, 1.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.1715728752538095, 1.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.2251482265544145, 1.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.2922212642709543, 1.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.3819660112501042, 1.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.5194938532959121, 1.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler076 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=0.50000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 2.2204460492503131e-16 at index 17
// max(|f - f_GSL| / |f_GSL|): 1.9508457915403988e-16
// mean(f - f_GSL): 2.3373116307898031e-17
// variance(f - f_GSL): 2.3146198993753289e-33
// stddev(f - f_GSL): 4.8110496769159731e-17
const testcase_hyperg<double>
data077[19] =
{
  { 0.90992197313391454, 1.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.91822592662244484, 1.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.92687104566419554, 1.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.93588628166548848, 1.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.94530459215552909, 1.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.95516374875247434, 1.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.96550736800511816, 1.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.97638624595136270, 1.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.98786011482678993, 1.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0128914530682316, 1.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0266391040215350, 1.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0413732738729464, 1.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0572599536532992, 1.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0745166004060953, 1.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0934387388831386, 1.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.1144486980714641, 1.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.1381966011250106, 1.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.1658171625342397, 1.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler077 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=0.50000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16 at index 7
// max(|f - f_GSL| / |f_GSL|): 4.5130734546221216e-16
// mean(f - f_GSL): 4.6746232615796062e-17
// variance(f - f_GSL): 1.2814504633219814e-34
// stddev(f - f_GSL): 1.1320116886861114e-17
const testcase_hyperg<double>
data078[19] =
{
  { 0.93641908369732896, 1.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.94256349654111271, 1.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.94890138508461319, 1.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.95544578858430029, 1.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.96221121193620762, 1.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.96921386948293542, 1.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.97647198488394704, 1.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.98400616412578656, 1.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.99183986544963032, 1.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0085177124149158, 1.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0174294150407122, 1.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0267781897388850, 1.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0366157405967287, 1.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0470052068648839, 1.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0580253905513313, 1.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0697774741209765, 1.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0823965556448414, 1.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0960739512057103, 1.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler078 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=0.50000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 2.2204460492503131e-16 at index 7
// max(|f - f_GSL| / |f_GSL|): 2.2476491960642283e-16
// mean(f - f_GSL): -5.8432790769745078e-18
// variance(f - f_GSL): 2.0022663489405960e-36
// stddev(f - f_GSL): 1.4150146108576393e-18
const testcase_hyperg<double>
data079[19] =
{
  { 0.95069883346936235, 1.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.95559618047704131, 1.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.96061938755931664, 1.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.96577553912851333, 1.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.97107239473807716, 1.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.97651848528588481, 1.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.98212322830227128, 1.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.98789706736195781, 1.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.99385164237825074, 1.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0063568569383123, 1.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0129389344715818, 1.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0197653907773940, 1.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0268583912277143, 1.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0342438793937092, 1.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0419526514766855, 1.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0500219124976327, 1.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0584976491907043, 1.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0674385240268101, 1.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler079 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=0.50000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data080[19] =
{
  { 0.95968319138913905, 1.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.96376169072755802, 1.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.96792900082729372, 1.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.97218942798115737, 1.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.97654763592586835, 1.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.98100869054353890, 1.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.98557811238699278, 1.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.99026193885795544, 1.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.99506679842072221, 1.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0050696417919618, 1.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0102847452747090, 1.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0156554225057022, 1.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.0211930882963096, 1.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.0269107343740711, 1.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.0328232917216298, 1.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.0389481230247195, 1.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.0453057164134614, 1.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.0519207114461246, 1.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler080 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=1.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 3.5527136788005009e-15 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.3886315518367350e-15
// mean(f - f_GSL): 2.6879083754082737e-16
// variance(f - f_GSL): 6.3240381271479359e-31
// stddev(f - f_GSL): 7.9523821130199324e-16
const testcase_hyperg<double>
data081[19] =
{
  { 0.71317098463599415, 1.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.73473333112764883, 1.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.75804035866024344, 1.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.78333938207622589, 1.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.81093021621632866, 1.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.84118059155303215, 1.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.87454754822497005, 1.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.91160778396977304, 1.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.95310179804324857, 1.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0536051565782629, 1.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.1157177565710485, 1.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.1889164797957747, 1.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.2770640594149769, 1.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.3862943611198899, 1.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.5271512197902593, 1.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.7199611490370503, 1.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 2.0117973905426232, 1.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 2.5584278811044925, 1.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler081 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=1.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16 at index 18
// max(|f - f_GSL| / |f_GSL|): 3.1924682001889760e-16
// mean(f - f_GSL): 6.4276069846719592e-17
// variance(f - f_GSL): 8.4595753242740185e-33
// stddev(f - f_GSL): 9.1975949705746545e-17
const testcase_hyperg<double>
data082[19] =
{
  { 0.83165649828125487, 1.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.84626246650116621, 1.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.86165287670267476, 1.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.87790681762615264, 1.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.89511583784087634, 1.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.91338673957393823, 1.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.93284521667332010, 1.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.95364066873549813, 1.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.97595268969924187, 1.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0260530485179122, 1.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0544523154103413, 1.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0856358366643180, 1.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.1201824010510930, 1.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.1588830833596719, 1.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.2028682930536780, 1.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.2538561433469468, 1.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.3147120107267418, 1.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.3910528844853491, 1.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler082 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=1.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16 at index 7
// max(|f - f_GSL| / |f_GSL|): 4.5856134910670077e-16
// mean(f - f_GSL): 5.2589511692770570e-17
// variance(f - f_GSL): 8.9881736403943358e-33
// stddev(f - f_GSL): 9.4805978927461832e-17
const testcase_hyperg<double>
data083[19] =
{
  { 0.87917686994924560, 1.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.89033956110358403, 1.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.90196195126098355, 1.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.91408080149514681, 1.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.92673756761314952, 1.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.93997926630123430, 1.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.95385955885019325, 1.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.96844012412988900, 1.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.98379242268046208, 1.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0171615499181177, 1.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0353950776091039, 1.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0548437030651112, 1.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0756840039415978, 1.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0981384722661196, 1.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.1224950318916129, 1.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.1491396357184527, 1.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.1786158344507012, 1.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.2117500593515478, 1.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler083 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=1.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 2.2204460492503131e-16 at index 17
// max(|f - f_GSL| / |f_GSL|): 1.9755522134245812e-16
// mean(f - f_GSL): 1.7529837230923523e-17
// variance(f - f_GSL): 1.8020397140465364e-35
// stddev(f - f_GSL): 4.2450438325729174e-18
const testcase_hyperg<double>
data084[19] =
{
  { 0.90538259348578420, 1.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.91444830598832061, 1.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.92381915945973991, 1.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.93351553488501793, 1.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.94356001859234861, 1.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.95397775039949628, 1.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.96479684710618008, 1.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.97604892281308531, 1.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.98776973540356938, 1.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0127864273812119, 1.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0261830717772533, 1.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0402531144740719, 1.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0550712790827002, 1.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0707271945059007, 1.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0873302420658923, 1.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.1050168587085545, 1.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.1239622188477687, 1.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.1444006183097781, 1.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler084 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=1.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 2.2204460492503131e-16 at index 18
// max(|f - f_GSL| / |f_GSL|): 2.0014207127505480e-16
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 2.8912726078702206e-33
// stddev(f - f_GSL): 5.3770555212590287e-17
const testcase_hyperg<double>
data085[19] =
{
  { 0.92211295632330392, 1.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.92975727737040625, 1.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.93761992348333489, 1.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.94571346180587790, 1.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.95405164371146900, 1.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.96264956879205987, 1.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.97152388013493107, 1.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.98069299877709348, 1.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.99017740778385854, 1.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0101865087004833, 1.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0207660479892111, 1.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0317718013185031, 1.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.0432419144892398, 1.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.0552206786504446, 1.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.0677601383233675, 1.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.0809223485579968, 1.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.0947826783002668, 1.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.1094349304493603, 1.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler085 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=2.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 1.7763568394002505e-15 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.9984014443252816e-16
// mean(f - f_GSL): 7.5962628000668607e-17
// variance(f - f_GSL): 1.6955391669463862e-31
// stddev(f - f_GSL): 4.1176925175957300e-16
const testcase_hyperg<double>
data086[19] =
{
  { 0.52631578947368429, 1.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.55555555555555558, 1.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.58823529411764708, 1.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.62500000000000000, 1.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.66666666666666663, 1.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.71428571428571430, 1.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.76923076923076938, 1.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.83333333333333337, 1.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.90909090909090906, 1.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.1111111111111112, 1.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.2500000000000002, 1.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.4285714285714286, 1.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.6666666666666670, 1.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 2.0000000000000000, 1.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 2.5000000000000009, 1.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 3.3333333333333348, 1.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 5.0000000000000009, 1.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 10.000000000000011, 1.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler086 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=2.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 2.6645352591003757e-15 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.2228571846595245e-15
// mean(f - f_GSL): 1.9282820954015878e-16
// variance(f - f_GSL): 3.5826351554959189e-31
// stddev(f - f_GSL): 5.9855118039278136e-16
const testcase_hyperg<double>
data087[19] =
{
  { 0.70351947549341554, 1.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.72637503722092756, 1.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.75099661564391240, 1.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.77761647796730871, 1.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.80651221621216473, 1.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.83801894346580275, 1.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.87254582050258456, 1.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.91059888544083678, 1.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.95281329145592386, 1.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0532154477379738, 1.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.1138692114741471, 1.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.1838976095305187, 1.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.2660586631630240, 1.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.3644676665613118, 1.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.4856585347316102, 1.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.6409590443536872, 1.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.8528798927325769, 1.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 2.1789423102929653, 1.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler087 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=2.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 8.8817841970012523e-16 at index 18
// max(|f - f_GSL| / |f_GSL|): 5.8050967180790176e-16
// mean(f - f_GSL): 5.8432790769745078e-17
// variance(f - f_GSL): 4.0373698660038179e-32
// stddev(f - f_GSL): 2.0093207474178476e-16
const testcase_hyperg<double>
data088[19] =
{
  { 0.78068027379106275, 1.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.79924541976981278, 1.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.81891305585650975, 1.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.83979799626213247, 1.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.86203315303160111, 1.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.88577352485361693, 1.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.91120135738402230, 1.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.93853291956703588, 1.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.96802755388922956, 1.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0348375559194773, 1.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0730246119544820, 1.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.1151788396279341, 1.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.1621066403893472, 1.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.2148922218710421, 1.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.2750496810838674, 1.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.3448048570872917, 1.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.4276833109859521, 1.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.5299976259379793, 1.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler088 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=2.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16 at index 18
// max(|f - f_GSL| / |f_GSL|): 3.4946054932156233e-16
// mean(f - f_GSL): 3.5059674461847047e-17
// variance(f - f_GSL): 9.8111051098089209e-33
// stddev(f - f_GSL): 9.9051022760034738e-17
const testcase_hyperg<double>
data089[19] =
{
  { 0.82510759951857615, 1.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.84072786892782070, 1.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.85710884896562356, 1.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.87431674418118244, 1.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.89242659229726995, 1.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.91152392685930339, 1.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.93170685950993570, 1.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.95308871926790661, 1.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.97580144325325802, 1.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0258682619030324, 1.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0536269616706000, 1.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0835447330793833, 1.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.1159538758396654, 1.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.1512736659291880, 1.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.1900463690116090, 1.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.2329961591622411, 1.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.2811334345669059, 1.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.3359629014132053, 1.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler089 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=2.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16 at index 7
// max(|f - f_GSL| / |f_GSL|): 4.6160879869309861e-16
// mean(f - f_GSL): -2.9216395384872539e-17
// variance(f - f_GSL): 3.7021904791911625e-33
// stddev(f - f_GSL): 6.0845628266878486e-17
const testcase_hyperg<double>
data090[19] =
{
  { 0.85426123653345876, 1.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.86774543390930414, 1.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.88178859537254239, 1.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.89643269097060951, 1.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.91172456687216819, 1.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.92771674975966134, 1.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.94446842993888669, 1.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.96204667481937678, 1.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.98052794339012128, 1.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0205643671068179, 1.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0423395201078882, 1.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0654651277885334, 1.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.0901078068101382, 1.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.1164691415928940, 1.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.1447972335326551, 1.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.1754040384534163, 1.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.2086928679893112, 1.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.2452055640510711, 1.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler090 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=5.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 4.0927261579781771e-12 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.4735287697491136e-15
// mean(f - f_GSL): 2.2385017815981644e-13
// variance(f - f_GSL): 8.7776489381819171e-25
// stddev(f - f_GSL): 9.3689107895111895e-13
const testcase_hyperg<double>
data091[19] =
{
  { 0.25646288779245086, 1.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.28273129096174376, 1.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.31438201170962982, 1.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.35308837890625017, 1.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.40123456790123452, 1.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.46230737192836352, 1.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.54156016946185348, 1.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.64718364197530875, 1.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.79246636158732342, 1.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.3103947568968148, 1.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.8017578125000016, 1.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 2.6374427321949185, 1.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 4.1975308641975335, 1.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 7.4999999999999964, 1.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 15.859375000000012, 1.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 43.734567901234662, 1.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 194.99999999999994, 1.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 2777.5000000000095, 1.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler091 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=5.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 4.2632564145606011e-14 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.3117712044801870e-15
// mean(f - f_GSL): 2.6879083754082736e-15
// variance(f - f_GSL): 9.3567700516642700e-29
// stddev(f - f_GSL): 9.6730398798228218e-15
const testcase_hyperg<double>
data092[19] =
{
  { 0.46398891966759009, 1.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.49382716049382724, 1.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.52768166089965407, 1.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.56640625000000000, 1.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.61111111111111094, 1.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.66326530612244916, 1.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.72485207100591709, 1.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.79861111111111094, 1.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.88842975206611552, 1.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.1419753086419753, 1.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.3281250000000000, 1.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.5816326530612239, 1.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.9444444444444458, 1.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 2.5000000000000000, 1.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 3.4374999999999996, 1.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 5.2777777777777786, 1.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 9.9999999999999947, 1.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 32.499999999999950, 1.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler092 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=5.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 6.2172489379008766e-15 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.2433022037532449e-15
// mean(f - f_GSL): 4.9083544246585873e-16
// variance(f - f_GSL): 1.9229766015225486e-30
// stddev(f - f_GSL): 1.3867143186404864e-15
const testcase_hyperg<double>
data093[19] =
{
  { 0.57476744883397490, 1.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.60302731682513966, 1.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.63425708719096374, 1.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.66895764182970430, 1.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.70775063063963473, 1.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.75141762103495946, 1.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.80095569442603320, 1.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.85765823887436754, 1.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.92323549576335540, 1.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0911622464839472, 1.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.2013226178607672, 1.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.3373332072682687, 1.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.5099074378209718, 1.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.7368822229245819, 1.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 2.0505871832661429, 1.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 2.5172389775867976, 1.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 3.3015631983556144, 1.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 5.0005935155044563, 1.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler093 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=5.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 3.1086244689504383e-15 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.1989697058841885e-15
// mean(f - f_GSL): 2.4541772123292936e-16
// variance(f - f_GSL): 4.8074415038063715e-31
// stddev(f - f_GSL): 6.9335715932024320e-16
const testcase_hyperg<double>
data094[19] =
{
  { 0.64582752605387983, 1.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.67184161997264191, 1.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.70012779922368040, 1.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.73100784656910278, 1.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.76486919089091066, 1.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.80218301124334590, 1.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.84352883533234391, 1.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.88962858902212572, 1.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.94139473468584123, 1.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0669812691939897, 1.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.1443996012177726, 1.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.2350966976721314, 1.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.3431264370409088, 1.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.4745266814162399, 1.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.6388137104840066, 1.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.8522074849776522, 1.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 2.1458016978417458, 1.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 2.5927464669826348, 1.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler094 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=5.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 1.3322676295501878e-15 at index 18
// max(|f - f_GSL| / |f_GSL|): 6.8275390424723874e-16
// mean(f - f_GSL): 1.0517902338554114e-16
// variance(f - f_GSL): 8.8299945988280290e-32
// stddev(f - f_GSL): 2.9715306828010425e-16
const testcase_hyperg<double>
data095[19] =
{
  { 0.69583236336670584, 1.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.71968920666899716, 1.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.74533885416044232, 1.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.77300145361503070, 1.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.80293630810919447, 1.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.83545132638592057, 1.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.87091544744412497, 1.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.90977522877919847, 1.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.95257738192069130, 1.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0528968282789379, 1.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.1123617169062123, 1.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.1798254572896132, 1.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.2572069000522701, 1.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.3471600884974377, 1.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.4535032279573519, 1.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.5820245752814950, 1.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.7421756366906538, 1.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.9513145531098235, 1.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler095 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=10.000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 2.0861625671386719e-07 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.6897916810721003e-15
// mean(f - f_GSL): 1.0989192059253727e-08
// variance(f - f_GSL): 2.2903477685061008e-15
// stddev(f - f_GSL): 4.7857577963224392e-08
const testcase_hyperg<double>
data096[19] =
{
  { 0.12307420104127866, 1.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.13818870041457434, 1.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.15739165631811705, 1.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.18249038606882081, 1.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.21644171225027795, 1.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.26433326159804149, 1.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.33544459430654527, 1.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.44788516696232511, 1.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.63989153514168373, 1.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.7568608796813312, 1.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 3.5836558871799102, 1.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 8.8077526749963226, 1.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 27.285841702089265, 1.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 113.55555555555557, 1.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 706.24023437500091, 1.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 8064.1687976652511, 1.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 271267.22222222196, 1.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 123456790.00000113, 1.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler096 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=10.000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 2.6193447411060333e-10 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.6039867544159698e-15
// mean(f - f_GSL): 1.3861192895235850e-11
// variance(f - f_GSL): 3.6088478524883243e-21
// stddev(f - f_GSL): 6.0073686856129647e-11
const testcase_hyperg<double>
data097[19] =
{
  { 0.28363728383055781, 1.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.30933003169808387, 1.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.33998437757128797, 1.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.37713553224291113, 1.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.42299736538419669, 1.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.48086597727600089, 1.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.55583495759293033, 1.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.65612850114039678, 1.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.79573668772968142, 1.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.3184712058058303, 1.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.8576958065941236, 1.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 2.8759509651764228, 1.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 5.1046225531822289, 1.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 11.095238095238095, 1.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 32.797154017857174, 1.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 158.01935680536548, 1.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1815.9523809523814, 1.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 163302.14285714392, 1.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler097 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=10.000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 2.0463630789890885e-12 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.5238873992471854e-15
// mean(f - f_GSL): 1.1029773585697082e-13
// variance(f - f_GSL): 2.1981059026132227e-25
// stddev(f - f_GSL): 4.6883962104468326e-13
const testcase_hyperg<double>
data098[19] =
{
  { 0.39006633302741811, 1.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.41898885698103278, 1.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.45245557983812590, 1.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.49160548618861627, 1.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.53798419230517991, 1.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.59373881442067322, 1.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.66193391357076092, 1.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.74708402736952118, 1.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.85609281019430605, 1.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.1974451135148187, 1.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.4820886036706358, 1.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.9201183180477521, 1.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 2.6569338297733367, 1.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 4.0634920634920650, 1.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 7.3102678571428568, 1.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 17.512574302697782, 1.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 74.206349206349131, 1.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1342.8571428571502, 1.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler098 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=10.000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 7.8159700933611020e-14 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.4210854715201975e-15
// mean(f - f_GSL): 4.6629367034256575e-15
// variance(f - f_GSL): 3.1677071819086927e-28
// stddev(f - f_GSL): 1.7798053775367387e-14
const testcase_hyperg<double>
data099[19] =
{
  { 0.46726928123633210, 1.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.49687547629934464, 1.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.53045208856322223, 1.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.56884765624999989, 1.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.61316872427983504, 1.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.66488500161969544, 1.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.72598998634501621, 1.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.79925411522633760, 1.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.88863845062192182, 1.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.1423563481176653, 1.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.3302951388888891, 1.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.5889212827988335, 1.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.9650205761316886, 1.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 2.5555555555555549, 1.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 3.5937500000000013, 1.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 5.7818930041152274, 1.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 12.222222222222220, 1.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 55.000000000000114, 1.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler099 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=10.000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 1.7763568394002505e-15 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.9984014443252816e-16
// mean(f - f_GSL): 7.5962628000668607e-17
// variance(f - f_GSL): 1.6955391669463862e-31
// stddev(f - f_GSL): 4.1176925175957300e-16
const testcase_hyperg<double>
data100[19] =
{
  { 0.52631578947368429, 1.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.55555555555555558, 1.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.58823529411764708, 1.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.62500000000000000, 1.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.66666666666666663, 1.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.71428571428571430, 1.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.76923076923076938, 1.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.83333333333333337, 1.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.90909090909090906, 1.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.1111111111111112, 1.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.2500000000000002, 1.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.4285714285714286, 1.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.6666666666666670, 1.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 2.0000000000000000, 1.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 2.5000000000000009, 1.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 3.3333333333333348, 1.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 5.0000000000000009, 1.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 10.000000000000011, 1.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler100 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=20.000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 1024.0000000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.7510399999999635e-15
// mean(f - f_GSL): 53.894788252704814
// variance(f - f_GSL): 55188.204676932175
// stddev(f - f_GSL): 234.92169903381034
const testcase_hyperg<double>
data101[19] =
{
  { 0.058479236576646311, 1.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.065788544763137821, 1.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.075184824937824482, 1.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.087707688693157121, 1.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.10521567442213345, 1.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.13135877960541509, 1.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.17423854066297137, 1.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.25492082527223520, 1.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.44025895219654843, 1.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 3.3698615820910360, 1.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 17.997089220808562, 1.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 153.73298291118951, 1.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 2159.1667587825768, 1.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 55188.105263157879, 1.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 3191209.3921857267, 1.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 646910975.29153574, 1.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 1254834626850.2659, 1.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 5.8479532163743910e+17, 1.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler101 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=20.000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 0.21875000000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.5452521874999694e-15
// mean(f - f_GSL): 0.011513220685868108
// variance(f - f_GSL): 0.0025185017633005862
// stddev(f - f_GSL): 0.050184676578618956
const testcase_hyperg<double>
data102[19] =
{
  { 0.15519511120894958, 1.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.17197165701692893, 1.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.19276847315207329, 1.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.21920107206179093, 1.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.25386158960390576, 1.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.30115970686600663, 1.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.36916408142057128, 1.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.47406175901569547, 1.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.65237908266239919, 1.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.8227213362622299, 1.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 4.3716358339791430, 1.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 15.670841312959222, 1.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 94.742651122760662, 1.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1081.7275541795671, 1.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 27809.787731465960, 1.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 2329811.1715181284, 1.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1537787532.6780224, 1.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 141562653507005.19, 1.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler102 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=20.000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 0.00024414062500000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.6763226855512285e-15
// mean(f - f_GSL): 1.2849899481406474e-05
// variance(f - f_GSL): 3.1370759089735494e-09
// stddev(f - f_GSL): 5.6009605506319623e-05
const testcase_hyperg<double>
data103[19] =
{
  { 0.23253645591196551, 1.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.25484220947068342, 1.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.28181987881113812, 1.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.31508211677735770, 1.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.35706285886959610, 1.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.41160053409238190, 1.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.48508083111181938, 1.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.58885194371375260, 1.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.74482241684585782, 1.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.4700356864367146, 1.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 2.4955144453055174, 1.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 5.3506594845833471, 1.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 16.618413752184267, 1.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 89.310629514963878, 1.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1029.3439900542960, 1.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 35659.847863372670, 1.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 8009309.6233230168, 1.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 145640590027.40201, 1.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler103 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=20.000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 7.1525573730468750e-07 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.7237966704607975e-15
// mean(f - f_GSL): 3.7648905700618082e-08
// variance(f - f_GSL): 2.6925522674362989e-14
// stddev(f - f_GSL): 1.6408998346749562e-07
const testcase_hyperg<double>
data104[19] =
{
  { 0.29614148314592509, 1.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.32176277356430805, 1.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.35217870475550511, 1.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.38885270445515113, 1.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.43389978380608418, 1.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.49048612522269414, 1.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.56355539635634599, 1.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.66123153239117671, 1.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.79773363961895416, 1.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.3245132157016595, 1.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.9065148749742094, 1.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 3.1328798652457452, 1.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 6.4172532944033636, 1.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 19.071683734222436, 1.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 104.41989641582512, 1.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1510.5743992324351, 1.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 115518.14360562043, 1.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 414930455.29174191, 1.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler104 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, b=20.000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 4.6566128730773926e-09 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.6665618165271877e-15
// mean(f - f_GSL): 2.4523176471958370e-10
// variance(f - f_GSL): 1.1411894517911952e-18
// stddev(f - f_GSL): 1.0682646918208967e-09
const testcase_hyperg<double>
data105[19] =
{
  { 0.34954259539177701, 1.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.37714038609235134, 1.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.40942091659748781, 1.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.44767109606846422, 1.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.49368984777532227, 1.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.55006638216982318, 1.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.62065830207408901, 1.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.71145554513583764, 1.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.83223839666914623, 1.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.2466748028187731, 1.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.6386752725021760, 1.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 2.3340068725479681, 1.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 3.7848108613132099, 1.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 7.6754638550304133, 1.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 23.344217312927277, 1.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 149.83491198246998, 1.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 3936.9253501916060, 1.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 2794143.5036480846, 1.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler105 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=0.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data106[19] =
{
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler106 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=0.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data107[19] =
{
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler107 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=0.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data108[19] =
{
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler108 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=0.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data109[19] =
{
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler109 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=0.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data110[19] =
{
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler110 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=0.50000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.8577584504832499e-16
// mean(f - f_GSL): 5.8432790769745078e-18
// variance(f - f_GSL): 1.1262748212790853e-32
// stddev(f - f_GSL): 1.0612609581432294e-16
const testcase_hyperg<double>
data111[19] =
{
  { 0.72547625011001160, 2.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.74535599249992990, 2.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.76696498884737041, 2.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.79056941504209477, 2.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.81649658092772603, 2.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.84515425472851669, 2.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.87705801930702931, 2.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.91287092917527690, 2.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.95346258924559224, 2.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0540925533894598, 2.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.1180339887498949, 2.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.1952286093343938, 2.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.2909944487358058, 2.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.4142135623730951, 2.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.5811388300841900, 2.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.8257418583505542, 2.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 2.2360679774997898, 2.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 3.1622776601683809, 2.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler111 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=0.50000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 6.6613381477509392e-16 at index 18
// max(|f - f_GSL| / |f_GSL|): 4.6340403913587147e-16
// mean(f - f_GSL): 7.5962628000668607e-17
// variance(f - f_GSL): 2.0425119025543020e-32
// stddev(f - f_GSL): 1.4291647569662155e-16
const testcase_hyperg<double>
data112[19] =
{
  { 0.83664260086443765, 2.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.85046584300227079, 2.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.86509574979651649, 2.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.88062082573041911, 2.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.89714464248521597, 2.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.91478946588967569, 2.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.93370105322348607, 2.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.95405511057700887, 2.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.97606616007978142, 2.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0261916902334731, 2.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0550723519434702, 2.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0872106588188091, 2.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.1233801699379022, 2.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.1646752981725688, 2.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.2127272514219511, 2.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.2701518651068637, 2.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.3416407864998725, 2.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.4374795179111106, 2.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler112 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=0.50000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 3.3306690738754696e-16 at index 8
// max(|f - f_GSL| / |f_GSL|): 3.3853500746952663e-16
// mean(f - f_GSL): 1.1686558153949016e-17
// variance(f - f_GSL): 2.5949371882270124e-33
// stddev(f - f_GSL): 5.0940525990875012e-17
const testcase_hyperg<double>
data113[19] =
{
  { 0.88195381730235822, 2.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.89265078469555081, 2.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.90382937908303673, 2.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.91553161389880600, 2.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.92780530349281509, 2.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.94070521140346020, 2.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.95429450630523349, 2.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.96864663325785849, 2.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.98384775588541795, 2.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0172258496884334, 2.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0356742479163461, 2.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0555293036908924, 2.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0770231491562379, 2.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.1004557416484888, 2.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.1262270515731978, 2.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.1548932919125088, 2.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.1872757758134724, 2.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.2247091713458949, 2.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler113 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=0.50000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 2.2204460492503131e-16 at index 17
// max(|f - f_GSL| / |f_GSL|): 1.9683492716399738e-16
// mean(f - f_GSL): 1.7529837230923523e-17
// variance(f - f_GSL): 2.4527762774522302e-33
// stddev(f - f_GSL): 4.9525511380017369e-17
const testcase_hyperg<double>
data114[19] =
{
  { 0.90716919697107279, 2.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.91592299407142508, 2.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.92500027075874192, 2.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.93442464185467122, 2.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.94422248683737076, 2.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.95442341810133347, 2.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.96506085725516355, 2.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.97617275213704069, 2.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.98780247986309799, 2.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0128233505813447, 2.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0263406246541855, 2.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0406326381700366, 2.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0557966239802845, 2.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0719515075786321, 2.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0892457392422055, 2.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.1078695188000958, 2.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.1280752258974340, 2.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.1502152002706476, 2.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler114 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=0.50000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 3.3306690738754696e-16 at index 8
// max(|f - f_GSL| / |f_GSL|): 3.3636359087105992e-16
// mean(f - f_GSL): 2.9216395384872539e-17
// variance(f - f_GSL): 2.1804680539963092e-33
// stddev(f - f_GSL): 4.6695482158302094e-17
const testcase_hyperg<double>
data115[19] =
{
  { 0.92336416053263082, 2.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.93078397248364542, 2.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.93843714333600259, 2.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.94633837784068098, 2.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.95450388104967876, 2.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.96295158125742752, 2.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.97170139827854329, 2.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.98077556918512687, 2.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.99019904777750845, 2.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0102104261941198, 2.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0208669540935695, 2.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0320118665407505, 2.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.0436944599504387, 2.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.0559728828278145, 2.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.0689166967761712, 2.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.0826105758119842, 2.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.0971599106346146, 2.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.1126998828023964, 2.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler115 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=1.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 1.7763568394002505e-15 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.9984014443252816e-16
// mean(f - f_GSL): 7.5962628000668607e-17
// variance(f - f_GSL): 1.6955391669463862e-31
// stddev(f - f_GSL): 4.1176925175957300e-16
const testcase_hyperg<double>
data116[19] =
{
  { 0.52631578947368429, 2.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.55555555555555558, 2.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.58823529411764708, 2.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.62500000000000000, 2.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.66666666666666663, 2.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.71428571428571430, 2.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.76923076923076938, 2.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.83333333333333337, 2.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.90909090909090906, 2.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.1111111111111112, 2.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.2500000000000002, 2.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.4285714285714286, 2.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.6666666666666670, 2.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 2.0000000000000000, 2.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 2.5000000000000009, 2.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 3.3333333333333348, 2.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 5.0000000000000009, 2.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 10.000000000000011, 2.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler116 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=1.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 2.6645352591003757e-15 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.2228571846595245e-15
// mean(f - f_GSL): 1.9282820954015878e-16
// variance(f - f_GSL): 3.5826351554959189e-31
// stddev(f - f_GSL): 5.9855118039278136e-16
const testcase_hyperg<double>
data117[19] =
{
  { 0.70351947549341554, 2.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.72637503722092756, 2.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.75099661564391240, 2.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.77761647796730871, 2.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.80651221621216473, 2.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.83801894346580275, 2.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.87254582050258456, 2.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.91059888544083678, 2.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.95281329145592386, 2.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0532154477379738, 2.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.1138692114741471, 2.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.1838976095305187, 2.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.2660586631630240, 2.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.3644676665613118, 2.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.4856585347316102, 2.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.6409590443536872, 2.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.8528798927325769, 2.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 2.1789423102929653, 2.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler117 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=1.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 8.8817841970012523e-16 at index 18
// max(|f - f_GSL| / |f_GSL|): 5.8050967180790176e-16
// mean(f - f_GSL): 5.8432790769745078e-17
// variance(f - f_GSL): 4.0373698660038179e-32
// stddev(f - f_GSL): 2.0093207474178476e-16
const testcase_hyperg<double>
data118[19] =
{
  { 0.78068027379106275, 2.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.79924541976981278, 2.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.81891305585650975, 2.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.83979799626213247, 2.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.86203315303160111, 2.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.88577352485361693, 2.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.91120135738402230, 2.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.93853291956703588, 2.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.96802755388922956, 2.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0348375559194773, 2.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0730246119544820, 2.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.1151788396279341, 2.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.1621066403893472, 2.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.2148922218710421, 2.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.2750496810838674, 2.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.3448048570872917, 2.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.4276833109859521, 2.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.5299976259379793, 2.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler118 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=1.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16 at index 18
// max(|f - f_GSL| / |f_GSL|): 3.4946054932156233e-16
// mean(f - f_GSL): 3.5059674461847047e-17
// variance(f - f_GSL): 9.8111051098089209e-33
// stddev(f - f_GSL): 9.9051022760034738e-17
const testcase_hyperg<double>
data119[19] =
{
  { 0.82510759951857615, 2.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.84072786892782070, 2.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.85710884896562356, 2.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.87431674418118244, 2.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.89242659229726995, 2.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.91152392685930339, 2.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.93170685950993570, 2.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.95308871926790661, 2.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.97580144325325802, 2.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0258682619030324, 2.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0536269616706000, 2.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0835447330793833, 2.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.1159538758396654, 2.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.1512736659291880, 2.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.1900463690116090, 2.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.2329961591622411, 2.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.2811334345669059, 2.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.3359629014132053, 2.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler119 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=1.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16 at index 7
// max(|f - f_GSL| / |f_GSL|): 4.6160879869309861e-16
// mean(f - f_GSL): -2.9216395384872539e-17
// variance(f - f_GSL): 3.7021904791911625e-33
// stddev(f - f_GSL): 6.0845628266878486e-17
const testcase_hyperg<double>
data120[19] =
{
  { 0.85426123653345876, 2.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.86774543390930414, 2.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.88178859537254239, 2.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.89643269097060951, 2.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.91172456687216819, 2.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.92771674975966134, 2.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.94446842993888669, 2.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.96204667481937678, 2.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.98052794339012128, 2.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0205643671068179, 2.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0423395201078882, 2.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0654651277885334, 2.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.0901078068101382, 2.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.1164691415928940, 2.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.1447972335326551, 2.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.1754040384534163, 2.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.2086928679893112, 2.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.2452055640510711, 2.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler120 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=2.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 4.2632564145606011e-14 at index 18
// max(|f - f_GSL| / |f_GSL|): 4.2632564145605916e-16
// mean(f - f_GSL): 2.3636063866361887e-15
// variance(f - f_GSL): 9.5093179694074762e-29
// stddev(f - f_GSL): 9.7515731907254209e-15
const testcase_hyperg<double>
data121[19] =
{
  { 0.27700831024930750, 2.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.30864197530864196, 2.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.34602076124567477, 2.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.39062500000000000, 2.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.44444444444444442, 2.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.51020408163265318, 2.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.59171597633136108, 2.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.69444444444444442, 2.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.82644628099173545, 2.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.2345679012345683, 2.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.5625000000000007, 2.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 2.0408163265306127, 2.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 2.7777777777777795, 2.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 4.0000000000000000, 2.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 6.2500000000000027, 2.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 11.111111111111125, 2.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 25.000000000000007, 2.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 100.00000000000023, 2.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler121 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=2.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 7.9936057773011271e-15 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.3252801810681345e-15
// mean(f - f_GSL): 6.3107414031324687e-16
// variance(f - f_GSL): 3.1787980555780903e-30
// stddev(f - f_GSL): 1.7829184096806254e-15
const testcase_hyperg<double>
data122[19] =
{
  { 0.50515448477320835, 2.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.53674994210078020, 2.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.57194655162437413, 2.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.61137322330312327, 2.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.65581297297972585, 2.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.70625323977290955, 2.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.76395739449542666, 2.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.83056871002513311, 2.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.90826553449323655, 2.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.1098784992198341, 2.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.2437942741831702, 2.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.4105343768544543, 2.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.6238435648986023, 2.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.9065970003160624, 2.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 2.3001951284393627, 2.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 2.8891774744673469, 2.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 3.8827206436045336, 2.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 6.0316345867773640, 2.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler122 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=2.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 3.1086244689504383e-15 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.2095468681839713e-15
// mean(f - f_GSL): 2.5126100030990384e-16
// variance(f - f_GSL): 4.7878393162502431e-31
// stddev(f - f_GSL): 6.9194214470938558e-16
const testcase_hyperg<double>
data123[19] =
{
  { 0.61824560969673270, 2.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.64645665839161026, 2.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.67712272792612116, 2.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.71058076074636822, 2.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.74723387423852838, 2.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.78756892188863170, 2.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.83218012557592669, 2.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.88180144818204143, 2.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.93735184459468934, 2.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0712594799044883, 2.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.1531330932162098, 2.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.2483404191094898, 2.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.3606934909972506, 2.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.4957544469027071, 2.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.6620777107871287, 2.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.8738132387064512, 2.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 2.1570670242247409, 2.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 2.5700735959225507, 2.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler123 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=2.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 1.3322676295501878e-15 at index 18
// max(|f - f_GSL| / |f_GSL|): 7.1401110547148366e-16
// mean(f - f_GSL): 1.0517902338554114e-16
// variance(f - f_GSL): 8.8299945988280290e-32
// stddev(f - f_GSL): 2.9715306828010425e-16
const testcase_hyperg<double>
data124[19] =
{
  { 0.68776713859043437, 2.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.71280582849489893, 2.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.73962983054724896, 2.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.76844343025262063, 2.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.79948476671182900, 2.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.83303347721461252, 2.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.86942060391338805, 2.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.90904161711581655, 2.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.95237381468647742, 2.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0526413941912305, 2.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.1112045278881502, 2.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.1768500306393046, 2.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.2510971588297890, 2.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.3359896747789315, 2.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.4343740183432725, 2.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.5504011881337365, 2.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.6905307012604318, 2.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.8658920279264428, 2.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler124 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=2.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 6.6613381477509392e-16 at index 18
// max(|f - f_GSL| / |f_GSL|): 4.1884541027166499e-16
// mean(f - f_GSL): 5.8432790769745078e-17
// variance(f - f_GSL): 2.1656512830141486e-32
// stddev(f - f_GSL): 1.4716151952919448e-16
const testcase_hyperg<double>
data125[19] =
{
  { 0.73530262886958797, 2.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.75768898977673649, 2.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.78143483544640080, 2.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.80667428603297209, 2.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.83356078772438313, 2.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.86227093001346156, 2.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.89300925500556971, 2.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.92601438873425990, 2.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.96156696230910810, 2.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0417127776179342, 2.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0871896789480930, 2.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.1370264514689949, 2.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.1919677804049158, 2.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.2529628761065934, 2.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.3212511796458866, 2.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.3985017309668506, 2.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.4870567523847895, 2.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.5904049523738044, 2.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler125 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=5.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 1.0186340659856796e-10 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.1641532182693482e-15
// mean(f - f_GSL): 5.5487040400966458e-12
// variance(f - f_GSL): 5.4399356990620132e-22
// stddev(f - f_GSL): 2.3323669734975269e-11
const testcase_hyperg<double>
data126[19] =
{
  { 0.040386107340619273, 2.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.052922149401344633, 2.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.070429627772374270, 2.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.095367431640624986, 2.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.13168724279835389, 2.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.18593443208187072, 2.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.26932907434290460, 2.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.40187757201646102, 2.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.62092132305915493, 2.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.6935087808430296, 2.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 3.0517578125000036, 2.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 5.9499018266198629, 2.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 12.860082304526767, 2.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 32.000000000000000, 2.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 97.656250000000114, 2.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 411.52263374485722, 2.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 3124.9999999999995, 2.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 100000.00000000055, 2.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler126 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=5.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 6.8212102632969618e-13 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.2402200478721734e-15
// mean(f - f_GSL): 3.8828589466495609e-14
// variance(f - f_GSL): 2.4267524775254640e-26
// stddev(f - f_GSL): 1.5578037352392837e-13
const testcase_hyperg<double>
data127[19] =
{
  { 0.21140107887447138, 2.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.24005486968449927, 2.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.27478119275391810, 2.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.31738281250000006, 2.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.37037037037037024, 2.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.43731778425655982, 2.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.52344105598543467, 2.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.63657407407407429, 2.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.78888054094665638, 2.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.3031550068587108, 2.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.7578125000000011, 2.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 2.4781341107871717, 2.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 3.7037037037037073, 2.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 5.9999999999999982, 2.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 10.937500000000005, 2.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 24.074074074074115, 2.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 74.999999999999957, 2.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 550.00000000000068, 2.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler127 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=5.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 4.9737991503207013e-14 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.6580642616864621e-15
// mean(f - f_GSL): 3.1670572597201835e-15
// variance(f - f_GSL): 1.2718576052442072e-28
// stddev(f - f_GSL): 1.1277666448535384e-14
const testcase_hyperg<double>
data128[19] =
{
  { 0.33250915203252129, 2.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.36566851047721943, 2.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.40414812182437959, 2.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.44916943268118498, 2.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.50233081077479547, 2.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.56575808728873322, 2.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.64233106844971455, 2.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.73603371116919514, 2.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.85251256240112439, 2.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.1909065696197674, 2.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.4447095285569318, 2.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.7935243137840653, 2.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 2.2937035820494467, 2.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 3.0524711083016687, 2.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 4.2976512669354259, 2.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 6.5977107563194739, 2.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 11.793747206577530, 2.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 29.997625937982132, 2.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler128 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=5.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 1.1546319456101628e-14 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.4852319937858925e-15
// mean(f - f_GSL): 8.5896202431525265e-16
// variance(f - f_GSL): 6.6980634833963886e-30
// stddev(f - f_GSL): 2.5880617232586221e-15
const testcase_hyperg<double>
data129[19] =
{
  { 0.42108197362250294, 2.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.45503172013983040, 2.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.49345609813624314, 2.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.53720880551221295, 2.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.58736431524847466, 2.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.64529222467897995, 2.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.71276337354393959, 2.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.79210466220795306, 2.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.88643063455510596, 2.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.1387832139040652, 2.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.3114025920844754, 2.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.5307655016768162, 2.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.8170727950333352, 2.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 2.2037865486700836, 2.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 2.7506766056439380, 2.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 3.5764534935716998, 2.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 4.9587762302155403, 2.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 7.7740847924166907, 2.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler129 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=5.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-15 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.0721199711322765e-15
// mean(f - f_GSL): 3.5059674461847049e-16
// variance(f - f_GSL): 9.8111051098089205e-31
// stddev(f - f_GSL): 9.9051022760034740e-16
const testcase_hyperg<double>
data130[19] =
{
  { 0.48860241312958436, 2.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.52193382517068487, 2.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.55902375003954219, 2.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.60049055150230324, 2.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.64709127927203469, 2.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.69976233335368998, 2.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.75967529501080988, 2.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.82831498895254407, 2.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.90759090169653933, 2.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.1088712278667465, 2.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.2387445478440855, 2.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.3959812720437546, 2.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.5897930661091169, 2.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.8340789380307454, 2.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 2.1509548085970764, 2.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 2.5782406951207526, 2.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 3.1877847194242737, 2.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 4.1421596631676918, 2.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler130 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=10.000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 2.2888183593750000e-05 at index 18
// max(|f - f_GSL| / |f_GSL|): 2.4795532226562509e-15
// mean(f - f_GSL): 1.2059140510950354e-06
// variance(f - f_GSL): 2.7568813079896666e-11
// stddev(f - f_GSL): 5.2506012112801583e-06
const testcase_hyperg<double>
data131[19] =
{
  { 0.0016310376661280216, 2.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.0028007538972582421, 2.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.0049603324681551939, 2.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.0090949470177292789, 2.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.017341529915832606, 2.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.034571613033607791, 2.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.072538150286405839, 2.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.16150558288984579, 2.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.38554328942953142, 2.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 2.8679719907924444, 2.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 9.3132257461548065, 2.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 35.401331746414378, 2.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 165.38171687920246, 2.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1024.0000000000000, 2.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 9536.7431640625218, 2.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 169350.87808430390, 2.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 9765624.9999999963, 2.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 10000000000.000111, 2.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler131 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=10.000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 1.4901161193847656e-08 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.4958811384436608e-15
// mean(f - f_GSL): 7.8582773037277017e-10
// variance(f - f_GSL): 1.1683981904064149e-17
// stddev(f - f_GSL): 3.4181840067591665e-09
const testcase_hyperg<double>
data132[19] =
{
  { 0.071191280690193537, 2.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.085646504654238384, 2.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.10478215656371109, 2.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.13074816337653578, 2.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.16701141666848118, 2.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.21939323375313963, 2.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.29813515331786639, 2.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.42225974638874397, 2.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.62942145962174878, 2.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.7218685262373197, 2.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 3.2855760483514738, 2.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 7.1616652508907093, 2.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 18.612326808485950, 2.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 61.476190476190474, 2.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 286.27580915178623, 2.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 2274.9441142102414, 2.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 47229.761904761865, 2.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 9961460.7142858077, 2.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler132 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=10.000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 8.7311491370201111e-11 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.5843951771650161e-15
// mean(f - f_GSL): 4.6467391338242840e-12
// variance(f - f_GSL): 4.0072766661644994e-22
// stddev(f - f_GSL): 2.0018183399510804e-11
const testcase_hyperg<double>
data133[19] =
{
  { 0.14747230019381058, 2.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.17073600100690609, 2.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.19982795745135354, 2.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.23681776864188053, 2.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.28475624360398011, 2.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.34827500743063161, 2.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.43464829159684687, 2.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.55576053438064787, 2.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.73195020913445530, 2.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.4310223867822929, 2.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 2.1742563399057566, 2.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 3.5769231236256043, 2.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 6.5620441134844469, 2.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 14.063492063492063, 2.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 38.085937500000036, 2.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 150.92973632068330, 2.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1212.3015873015852, 2.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 55107.142857143110, 2.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler133 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=10.000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 1.8189894035458565e-12 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.4848893090170230e-15
// mean(f - f_GSL): 1.0027066896088256e-13
// variance(f - f_GSL): 1.7322804840633983e-25
// stddev(f - f_GSL): 4.1620673757922257e-13
const testcase_hyperg<double>
data134[19] =
{
  { 0.21658059714090577, 2.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.24513539602702861, 2.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.27967018274845046, 2.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.32196044921875022, 2.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.37448559670781911, 2.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.44078856032208802, 2.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.52606701446027793, 2.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.63818158436213956, 2.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.78944971882612769, 2.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.3044251384443430, 2.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.7659505208333344, 2.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 2.5093710953769270, 2.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 3.8065843621399202, 2.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 6.3333333333333313, 2.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 12.109375000000004, 2.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 29.115226337448608, 2.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 108.33333333333330, 2.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1225.0000000000023, 2.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler134 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=10.000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 4.2632564145606011e-14 at index 18
// max(|f - f_GSL| / |f_GSL|): 4.2632564145605916e-16
// mean(f - f_GSL): 2.3636063866361887e-15
// variance(f - f_GSL): 9.5093179694074762e-29
// stddev(f - f_GSL): 9.7515731907254209e-15
const testcase_hyperg<double>
data135[19] =
{
  { 0.27700831024930750, 2.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.30864197530864196, 2.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.34602076124567477, 2.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.39062500000000000, 2.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.44444444444444442, 2.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.51020408163265318, 2.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.59171597633136108, 2.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.69444444444444442, 2.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.82644628099173545, 2.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.2345679012345683, 2.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.5625000000000007, 2.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 2.0408163265306127, 2.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 2.7777777777777795, 2.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 4.0000000000000000, 2.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 6.2500000000000027, 2.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 11.111111111111125, 2.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 25.000000000000007, 2.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 100.00000000000023, 2.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler135 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=20.000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 475136.00000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 5.4067200000000052e-15
// mean(f - f_GSL): 25007.185032091642
// variance(f - f_GSL): 11881799540.814577
// stddev(f - f_GSL): 109003.66755671379
const testcase_hyperg<double>
data136[19] =
{
  { 2.6602838683283435e-06, 2.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 7.8442223930072316e-06, 2.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 2.4604898194634598e-05, 2.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 8.2718061255302686e-05, 2.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.00030072865982171723, 2.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.0011951964277455204, 2.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.0052617832469731996, 2.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.026084053304588850, 2.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.14864362802414346, 2.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 8.2252633399699757, 2.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 86.736173798840738, 2.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1253.2542894196868, 2.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 27351.112277912678, 2.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1048576.0000000000, 2.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 90949470.177293226, 2.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 28679719907.924767, 2.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 95367431640624.906, 2.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000220e+20, 2.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler136 = 5.0000000000000039e-13;

// Test data for a=2.0000000000000000, b=20.000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 40.000000000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.8712609271522778e-15
// mean(f - f_GSL): 2.1052671749403089
// variance(f - f_GSL): 84.210508462254538
// stddev(f - f_GSL): 9.1766283820504881
const testcase_hyperg<double>
data137[19] =
{
  { 0.018828092583720632, 2.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.023381944060455365, 2.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.029789623984280887, 2.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.039191021482500567, 2.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.053727813036721528, 2.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.077762010061668857, 2.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.12110505620123323, 2.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.20870149809080582, 2.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.41429234328785763, 2.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 3.1308087404153113, 2.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 13.586180626453100, 2.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 87.117304082784415, 2.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 889.26474381243384, 2.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 16231.913312693494, 2.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 653537.51168945129, 2.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 87756230.793849647, 2.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 101493977171.74945, 2.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 21375960679557820., 2.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler137 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=20.000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 0.031250000000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.6379336164121759e-15
// mean(f - f_GSL): 0.0016447556893365942
// variance(f - f_GSL): 5.1397960874034849e-05
// stddev(f - f_GSL): 0.0071692371193896806
const testcase_hyperg<double>
data138[19] =
{
  { 0.049200410661854238, 2.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.059460876757152607, 2.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.073244762686653225, 2.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.092334626017932769, 2.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.11976760350696856, 2.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.16102414609169405, 2.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.22670456785796236, 2.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.33912903252727361, 2.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.55049794600858049, 2.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 2.1254722872032232, 2.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 5.6261213886736314, 2.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 20.137315891130996, 2.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 108.04381584643900, 2.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 992.41692466460245, 2.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 19055.363816004465, 2.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1105471.9504312191, 2.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 448521363.90608919, 2.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 19078917293639.652, 2.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler138 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=20.000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 8.3923339843750000e-05 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.8221514326726564e-15
// mean(f - f_GSL): 4.4172143495227617e-06
// variance(f - f_GSL): 3.7068906120670492e-10
// stddev(f - f_GSL): 1.9253287023433297e-05
const testcase_hyperg<double>
data139[19] =
{
  { 0.083753547015334884, 2.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.099238444687035743, 2.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.11938294012867748, 2.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.14622683905023329, 2.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.18303556733713028, 2.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.23527764069382415, 2.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.31261681740827069, 2.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.43327581880538862, 2.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.63445840637296680, 2.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.7438842395813297, 2.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 3.5070840938209331, 2.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 8.6573372006089713, 2.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 28.779342118408998, 2.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 147.50178613955714, 2.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1427.1686016136398, 2.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 36780.643714655955, 2.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 5313869.6058585485, 2.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 46057280607.383286, 2.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler139 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, b=20.000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 5.0663948059082031e-07 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.9925479281069681e-15
// mean(f - f_GSL): 2.6669880993704522e-08
// variance(f - f_GSL): 1.3509399735218820e-14
// stddev(f - f_GSL): 1.1622994336752823e-07
const testcase_hyperg<double>
data140[19] =
{
  { 0.11920045035073676, 2.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.13907946814302777, 2.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.16431439792559696, 2.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.19698796016986989, 2.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.24028510928790547, 2.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.29926031296483130, 2.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.38229327814229175, 2.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.50402047283093132, 2.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.69167261179586526, 2.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 2.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.5503152253394308, 2.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 2.6469548193635828, 2.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 5.1882631330566813, 2.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 12.476792759124546, 2.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 41.026391565091259, 2.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 220.92584715988204, 2.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 2677.0834450236389, 2.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 141774.31260689779, 2.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 254267148.83197621, 2.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler140 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=0.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data141[19] =
{
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler141 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=0.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data142[19] =
{
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler142 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=0.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data143[19] =
{
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler143 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=0.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data144[19] =
{
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler144 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=0.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data145[19] =
{
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler145 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=0.50000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 4.5474735088646412e-13 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.5124797514980592e-15
// mean(f - f_GSL): 2.5336458077761468e-14
// variance(f - f_GSL): 1.0813211674051158e-26
// stddev(f - f_GSL): 1.0398659372270619e-13
const testcase_hyperg<double>
data146[19] =
{
  { 0.52275983209457544, 5.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.54700336898143009, 5.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.57468955512602038, 5.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.60665490543315048, 5.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.64403057859056190, 5.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.68838183648623719, 5.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.74193265039311118, 5.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.80794095908995300, 5.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.89135275749639320, 5.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.1469266219310688, 5.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.3552340708357493, 5.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.6690840478838305, 5.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 2.1815415453174500, 5.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 3.1156892546032235, 5.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 5.1109077417760416, 5.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 10.560352936466318, 5.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 33.541019662496815, 5.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 300.66343065819723, 5.0000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler146 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=0.50000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 8.8817841970012523e-15 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.3217255411112292e-15
// mean(f - f_GSL): 6.8950693108299193e-16
// variance(f - f_GSL): 3.9356627445430313e-30
// stddev(f - f_GSL): 1.9838504844224102e-15
const testcase_hyperg<double>
data147[19] =
{
  { 0.68252041951139286, 5.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.70394732624993395, 5.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.72748884971552052, 5.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.75351147371199667, 5.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.78247589005573737, 5.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.81497017420249795, 5.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.85175826875009608, 5.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.89385278481745867, 5.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.94262778709507411, 5.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0687327277420910, 5.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.1529725508983291, 5.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.2592587134058799, 5.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.3985773194637896, 5.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.5909902576697317, 5.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.8776023607249752, 5.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 2.3582499003694664, 5.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 3.3541019662496838, 5.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 6.7198400278578028, 5.0000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler147 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=0.50000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 2.6645352591003757e-15 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.2228264607471081e-15
// mean(f - f_GSL): 2.2788788400200583e-16
// variance(f - f_GSL): 3.4817209315093131e-31
// stddev(f - f_GSL): 5.9006109272763554e-16
const testcase_hyperg<double>
data148[19] =
{
  { 0.75755211927082600, 5.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.77603550233010965, 5.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.79596241913438504, 5.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.81753360792105212, 5.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.84099165409805532, 5.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.86663303852180906, 5.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.89482475828629915, 5.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.92602774279590350, 5.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.96083064727087386, 5.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0445570841313008, 5.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0959004638926033, 5.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.1560106261370562, 5.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.2278121770678148, 5.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.3158640214709998, 5.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.4278095344155000, 5.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.5778700502946617, 5.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.7972173289196469, 5.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 2.1789970569269732, 5.0000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler148 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=0.50000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 8.8817841970012523e-16 at index 18
// max(|f - f_GSL| / |f_GSL|): 5.6109827053892650e-16
// mean(f - f_GSL): 7.5962628000668607e-17
// variance(f - f_GSL): 3.8685788127881258e-32
// stddev(f - f_GSL): 1.9668703090921186e-16
const testcase_hyperg<double>
data149[19] =
{
  { 0.80270093579329460, 5.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.81884974572462765, 5.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.83605266330015260, 5.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.85443340762796027, 5.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.87413762182790711, 5.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.89533826626907298, 5.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.91824276674115313, 5.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.94310265050720576, 5.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.97022678857609712, 5.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0329098673199812, 5.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0695865684573389, 5.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.1108642103944570, 5.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.1578795055970506, 5.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.2122394794169442, 5.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.2763274721556934, 5.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.3539179650251021, 5.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.4515986118197148, 5.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.5829284571614224, 5.0000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler149 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=0.50000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16 at index 18
// max(|f - f_GSL| / |f_GSL|): 3.2099086385883890e-16
// mean(f - f_GSL): 5.8432790769745078e-17
// variance(f - f_GSL): 8.7218722159852367e-33
// stddev(f - f_GSL): 9.3390964316604188e-17
const testcase_hyperg<double>
data150[19] =
{
  { 0.83322694172301981, 5.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.84753931604765675, 5.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.86265784532195022, 5.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.87866479300707090, 5.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.89565516540263501, 5.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.91373946207610557, 5.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.93304721345881914, 5.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.95373159512905148, 5.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.97597554238828121, 5.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0260752851887982, 5.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0545371197996178, 5.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0858099017045830, 5.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.1204416568688709, 5.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.1591587835964847, 5.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.2029564720303347, 5.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.2532588722007874, 5.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.3122319926925459, 5.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.3834948587364102, 5.0000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler150 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=1.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 4.0927261579781771e-12 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.4735287697491136e-15
// mean(f - f_GSL): 2.2385017815981644e-13
// variance(f - f_GSL): 8.7776489381819171e-25
// stddev(f - f_GSL): 9.3689107895111895e-13
const testcase_hyperg<double>
data151[19] =
{
  { 0.25646288779245086, 5.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.28273129096174376, 5.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.31438201170962982, 5.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.35308837890625017, 5.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.40123456790123452, 5.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.46230737192836352, 5.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.54156016946185348, 5.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.64718364197530875, 5.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.79246636158732342, 5.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.3103947568968148, 5.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.8017578125000016, 5.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 2.6374427321949185, 5.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 4.1975308641975335, 5.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 7.4999999999999964, 5.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 15.859375000000012, 5.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 43.734567901234662, 5.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 194.99999999999994, 5.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 2777.5000000000095, 5.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler151 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=1.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 4.2632564145606011e-14 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.3117712044801870e-15
// mean(f - f_GSL): 2.6879083754082736e-15
// variance(f - f_GSL): 9.3567700516642700e-29
// stddev(f - f_GSL): 9.6730398798228218e-15
const testcase_hyperg<double>
data152[19] =
{
  { 0.46398891966759009, 5.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.49382716049382724, 5.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.52768166089965407, 5.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.56640625000000000, 5.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.61111111111111094, 5.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.66326530612244916, 5.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.72485207100591709, 5.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.79861111111111094, 5.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.88842975206611552, 5.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.1419753086419753, 5.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.3281250000000000, 5.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.5816326530612239, 5.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.9444444444444458, 5.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 2.5000000000000000, 5.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 3.4374999999999996, 5.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 5.2777777777777786, 5.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 9.9999999999999947, 5.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 32.499999999999950, 5.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler152 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=1.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 6.2172489379008766e-15 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.2433022037532449e-15
// mean(f - f_GSL): 4.9083544246585873e-16
// variance(f - f_GSL): 1.9229766015225486e-30
// stddev(f - f_GSL): 1.3867143186404864e-15
const testcase_hyperg<double>
data153[19] =
{
  { 0.57476744883397490, 5.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.60302731682513966, 5.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.63425708719096374, 5.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.66895764182970430, 5.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.70775063063963473, 5.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.75141762103495946, 5.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.80095569442603320, 5.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.85765823887436754, 5.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.92323549576335540, 5.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0911622464839472, 5.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.2013226178607672, 5.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.3373332072682687, 5.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.5099074378209718, 5.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.7368822229245819, 5.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 2.0505871832661429, 5.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 2.5172389775867976, 5.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 3.3015631983556144, 5.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 5.0005935155044563, 5.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler153 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=1.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 3.1086244689504383e-15 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.1989697058841885e-15
// mean(f - f_GSL): 2.4541772123292936e-16
// variance(f - f_GSL): 4.8074415038063715e-31
// stddev(f - f_GSL): 6.9335715932024320e-16
const testcase_hyperg<double>
data154[19] =
{
  { 0.64582752605387983, 5.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.67184161997264191, 5.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.70012779922368040, 5.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.73100784656910278, 5.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.76486919089091066, 5.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.80218301124334590, 5.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.84352883533234391, 5.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.88962858902212572, 5.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.94139473468584123, 5.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0669812691939897, 5.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.1443996012177726, 5.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.2350966976721314, 5.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.3431264370409088, 5.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.4745266814162399, 5.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.6388137104840066, 5.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.8522074849776522, 5.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 2.1458016978417458, 5.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 2.5927464669826348, 5.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler154 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=1.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 1.3322676295501878e-15 at index 18
// max(|f - f_GSL| / |f_GSL|): 6.8275390424723874e-16
// mean(f - f_GSL): 1.0517902338554114e-16
// variance(f - f_GSL): 8.8299945988280290e-32
// stddev(f - f_GSL): 2.9715306828010425e-16
const testcase_hyperg<double>
data155[19] =
{
  { 0.69583236336670584, 5.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.71968920666899716, 5.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.74533885416044232, 5.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.77300145361503070, 5.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.80293630810919447, 5.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.83545132638592057, 5.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.87091544744412497, 5.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.90977522877919847, 5.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.95257738192069130, 5.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0528968282789379, 5.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.1123617169062123, 5.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.1798254572896132, 5.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.2572069000522701, 5.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.3471600884974377, 5.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.4535032279573519, 5.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.5820245752814950, 5.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.7421756366906538, 5.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.9513145531098235, 5.0000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler155 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=2.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 1.0186340659856796e-10 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.1641532182693482e-15
// mean(f - f_GSL): 5.5487040400966458e-12
// variance(f - f_GSL): 5.4399356990620132e-22
// stddev(f - f_GSL): 2.3323669734975269e-11
const testcase_hyperg<double>
data156[19] =
{
  { 0.040386107340619273, 5.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.052922149401344633, 5.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.070429627772374270, 5.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.095367431640624986, 5.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.13168724279835389, 5.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.18593443208187072, 5.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.26932907434290460, 5.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.40187757201646102, 5.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.62092132305915493, 5.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.6935087808430296, 5.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 3.0517578125000036, 5.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 5.9499018266198629, 5.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 12.860082304526767, 5.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 32.000000000000000, 5.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 97.656250000000114, 5.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 411.52263374485722, 5.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 3124.9999999999995, 5.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 100000.00000000055, 5.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler156 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=2.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 6.8212102632969618e-13 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.2402200478721734e-15
// mean(f - f_GSL): 3.8828589466495609e-14
// variance(f - f_GSL): 2.4267524775254640e-26
// stddev(f - f_GSL): 1.5578037352392837e-13
const testcase_hyperg<double>
data157[19] =
{
  { 0.21140107887447138, 5.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.24005486968449927, 5.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.27478119275391810, 5.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.31738281250000006, 5.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.37037037037037024, 5.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.43731778425655982, 5.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.52344105598543467, 5.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.63657407407407429, 5.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.78888054094665638, 5.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.3031550068587108, 5.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.7578125000000011, 5.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 2.4781341107871717, 5.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 3.7037037037037073, 5.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 5.9999999999999982, 5.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 10.937500000000005, 5.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 24.074074074074115, 5.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 74.999999999999957, 5.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 550.00000000000068, 5.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler157 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=2.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 4.9737991503207013e-14 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.6580642616864621e-15
// mean(f - f_GSL): 3.1670572597201835e-15
// variance(f - f_GSL): 1.2718576052442072e-28
// stddev(f - f_GSL): 1.1277666448535384e-14
const testcase_hyperg<double>
data158[19] =
{
  { 0.33250915203252129, 5.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.36566851047721943, 5.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.40414812182437959, 5.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.44916943268118498, 5.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.50233081077479547, 5.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.56575808728873322, 5.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.64233106844971455, 5.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.73603371116919514, 5.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.85251256240112439, 5.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.1909065696197674, 5.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.4447095285569318, 5.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.7935243137840653, 5.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 2.2937035820494467, 5.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 3.0524711083016687, 5.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 4.2976512669354259, 5.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 6.5977107563194739, 5.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 11.793747206577530, 5.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 29.997625937982132, 5.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler158 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=2.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 1.1546319456101628e-14 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.4852319937858925e-15
// mean(f - f_GSL): 8.5896202431525265e-16
// variance(f - f_GSL): 6.6980634833963886e-30
// stddev(f - f_GSL): 2.5880617232586221e-15
const testcase_hyperg<double>
data159[19] =
{
  { 0.42108197362250294, 5.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.45503172013983040, 5.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.49345609813624314, 5.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.53720880551221295, 5.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.58736431524847466, 5.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.64529222467897995, 5.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.71276337354393959, 5.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.79210466220795306, 5.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.88643063455510596, 5.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.1387832139040652, 5.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.3114025920844754, 5.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.5307655016768162, 5.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.8170727950333352, 5.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 2.2037865486700836, 5.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 2.7506766056439380, 5.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 3.5764534935716998, 5.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 4.9587762302155403, 5.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 7.7740847924166907, 5.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler159 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=2.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-15 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.0721199711322765e-15
// mean(f - f_GSL): 3.5059674461847049e-16
// variance(f - f_GSL): 9.8111051098089205e-31
// stddev(f - f_GSL): 9.9051022760034740e-16
const testcase_hyperg<double>
data160[19] =
{
  { 0.48860241312958436, 5.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.52193382517068487, 5.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.55902375003954219, 5.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.60049055150230324, 5.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.64709127927203469, 5.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.69976233335368998, 5.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.75967529501080988, 5.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.82831498895254407, 5.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.90759090169653933, 5.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.1088712278667465, 5.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.2387445478440855, 5.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.3959812720437546, 5.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.5897930661091169, 5.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.8340789380307454, 5.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 2.1509548085970764, 5.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 2.5782406951207526, 5.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 3.1877847194242737, 5.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 4.1421596631676918, 5.0000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler160 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=5.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 1.3113021850585938e-06 at index 18
// max(|f - f_GSL| / |f_GSL|): 2.9699111427019355e-14
// mean(f - f_GSL): 6.9091057386613658e-08
// variance(f - f_GSL): 9.0489756878178256e-14
// stddev(f - f_GSL): 3.0081515400354792e-07
const testcase_hyperg<double>
data161[19] =
{
  { -0.0047236848832209926, 5.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { -0.0073321496427104288, 5.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { -0.010977302557845620, 5.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { -0.015692785382270882, 5.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { -0.020728547477518663, 5.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { -0.022767481479412773, 5.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { -0.010634636868114097, 5.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.050699832580781923, 5.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.27045765367659280, 5.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 3.4387055868901171, 5.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 12.052059173584013, 5.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 45.565319600798020, 5.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 196.23532998018635, 5.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1032.0000000000002, 5.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 7376.0986328125073, 5.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 86964.639536656410, 5.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 2596875.0000000009, 5.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 766225000.00000668, 5.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler161 = 2.5000000000000015e-12;

// Test data for a=5.0000000000000000, b=5.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 1.8626451492309570e-09 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.5205266524334267e-15
// mean(f - f_GSL): 9.8838934113244577e-11
// variance(f - f_GSL): 1.8243591026317757e-19
// stddev(f - f_GSL): 4.2712516931594835e-10
const testcase_hyperg<double>
data162[19] =
{
  { 0.016473280625778776, 5.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.023520955289486591, 5.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.034179084066005165, 5.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.050663948059081955, 5.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.076817558299039870, 5.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.11952927776691663, 5.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.19163799520552807, 5.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.31815307784636504, 5.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.55036208180243285, 5.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.9287183337378946, 5.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 4.0054321289062544, 5.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 9.1373492337376394, 5.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 23.576817558299062, 5.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 71.999999999999972, 5.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 280.76171875000023, 5.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1611.7969821673578, 5.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 18749.999999999996, 5.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1225000.0000000061, 5.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler162 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=5.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 1.8189894035458565e-11 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.5011259042308243e-15
// mean(f - f_GSL): 9.8916196870839876e-13
// variance(f - f_GSL): 1.7350118793242040e-23
// stddev(f - f_GSL): 4.1653473796601937e-12
const testcase_hyperg<double>
data163[19] =
{
  { 0.067462409738203527, 5.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.084813629887172531, 5.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.10799223563666395, 5.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.13947766136095380, 5.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.18305927261494301, 5.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.24468431546783478, 5.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.33397274564972962, 5.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.46703323887436765, 5.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.67194346197695642, 5.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.5503148146900136, 5.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 2.5278200136941025, 5.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 4.3933515329658954, 5.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 8.3000308946111048, 5.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 17.570215556257921, 5.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 43.847462183266167, 5.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 141.86909082943893, 5.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 736.63489653168926, 5.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 12117.500593515540, 5.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler163 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=5.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 6.8212102632969618e-13 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.3038469641917422e-15
// mean(f - f_GSL): 3.9518096397578601e-14
// variance(f - f_GSL): 2.4215530819720675e-26
// stddev(f - f_GSL): 1.5561340179984714e-13
const testcase_hyperg<double>
data164[19] =
{
  { 0.12409443806004226, 5.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.14886910375100415, 5.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.18023328876836348, 5.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.22044046981094723, 5.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.27271160690708790, 5.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.34174821195025845, 5.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.43457788826160282, 5.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.56199385898404552, 5.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.74109892753745221, 5.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.3869229400096228, 5.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.9890168748121269, 5.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 2.9741205609307424, 5.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 4.6924751038237345, 5.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 7.9555939380658254, 5.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 14.933102063314404, 5.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 32.780461638447541, 5.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 94.848124287773530, 5.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 523.16034401517709, 5.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler164 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=5.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 9.9475983006414026e-14 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.3163001721303552e-15
// mean(f - f_GSL): 6.1880325425160040e-15
// variance(f - f_GSL): 5.1034009979425656e-28
// stddev(f - f_GSL): 2.2590708262342210e-14
const testcase_hyperg<double>
data165[19] =
{
  { 0.17885405888526873, 5.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.20861302518993391, 5.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.24504033307244946, 5.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.29007236051133489, 5.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.34635542859732737, 5.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.41756858504598410, 5.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.50892615622124393, 5.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.62798173270509761, 5.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.78595487360378424, 5.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.2972517637384813, 5.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.7224028197396399, 5.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 2.3527690438263305, 5.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 3.3305218060101147, 5.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 4.9383884076775466, 5.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 7.8007604680775229, 5.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 13.518663719271903, 5.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 27.285345906502567, 5.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 75.572415101502216, 5.0000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler165 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=10.000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 0.81250000000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.8182428501096257e-15
// mean(f - f_GSL): 0.042765168793266639
// variance(f - f_GSL): 0.034744884250260212
// stddev(f - f_GSL): 0.18639979680852714
const testcase_hyperg<double>
data166[19] =
{
  { 0.00063586451658060813, 5.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.0010334743461763829, 5.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.0015326246054669763, 5.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.0019007018181583513, 5.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.0012845577715431562, 5.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { -0.0027213806178060305, 5.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { -0.015121744574954044, 5.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { -0.036637840562974290, 5.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.019117849062621605, 5.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 9.8116901852350615, 5.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 84.255589172244427, 5.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 773.87517619421294, 5.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 8556.9725363054076, 5.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 129023.99999999996, 5.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 3174543.3807373112, 5.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 175133896.95814583, 5.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 43564453125.000061, 5.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 446860000000007.00, 5.0000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler166 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=10.000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 0.00039672851562500000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.6882064494680641e-15
// mean(f - f_GSL): 2.0884382210121993e-05
// variance(f - f_GSL): 8.2836958019297269e-09
// stddev(f - f_GSL): 9.1014810893226203e-05
const testcase_hyperg<double>
data167[19] =
{
  { -0.00030045430691814646, 5.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { -0.00031119487747322054, 5.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { -0.00014589213141656318, 5.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.00056843418860824636, 5.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.0028902549859721747, 5.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.0098776037238877245, 5.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.030689217428863859, 5.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.094211590019076558, 5.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.29791981455918370, 5.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 3.6646308771236793, 5.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 15.133991837501567, 5.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 73.331330046144089, 5.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 441.01791167787303, 5.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 3583.9999999999991, 5.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 45299.530029296984, 5.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1157231.0002427436, 5.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 107421875.00000016, 5.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 235000000000.00293, 5.0000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler167 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=10.000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 9.5367431640625000e-07 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.6314276114917587e-15
// mean(f - f_GSL): 5.0242811922592076e-08
// variance(f - f_GSL): 4.7862904884501567e-14
// stddev(f - f_GSL): 2.1877592391417655e-07
const testcase_hyperg<double>
data168[19] =
{
  { 0.0058530497315413248, 5.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.0088526869356855397, 5.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.013770987983442959, 5.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.022108932690960776, 5.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.036786236450921550, 5.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.063750669040426408, 5.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.11577228680714466, 5.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.22197573416125760, 5.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.45361312968415324, 5.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 2.4162889363082747, 5.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 6.5381564791240541, 5.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 20.415771011498428, 5.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 76.870682056629448, 5.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 373.58730158730162, 5.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 2626.2555803571477, 5.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 33060.960671081237, 5.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1203521.8253968258, 5.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 584564285.71428990, 5.0000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler168 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=10.000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 7.4505805969238281e-09 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.6196914341138665e-15
// mean(f - f_GSL): 3.9331532183208954e-10
// variance(f - f_GSL): 2.9206631793126476e-18
// stddev(f - f_GSL): 1.7089947862157589e-09
const testcase_hyperg<double>
data169[19] =
{
  { 0.020248990107069573, 5.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.027876687750502366, 5.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.039154648888447607, 5.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.056251883506774715, 5.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.082914189910074473, 5.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.12585357817786472, 5.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.19761423206224940, 5.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.32280443863359237, 5.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.55250024062839420, 5.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.9374297986599267, 5.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 4.0849049886067759, 5.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 9.5926988633258983, 5.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 25.958314281359588, 5.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 85.333333333333300, 5.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 372.31445312500028, 5.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 2545.3436976070780, 5.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 39583.333333333343, 5.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 4600000.0000000261, 5.0000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler169 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=10.000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 1.0186340659856796e-10 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.1641532182693482e-15
// mean(f - f_GSL): 5.5487040400966458e-12
// variance(f - f_GSL): 5.4399356990620132e-22
// stddev(f - f_GSL): 2.3323669734975269e-11
const testcase_hyperg<double>
data170[19] =
{
  { 0.040386107340619273, 5.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.052922149401344633, 5.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.070429627772374270, 5.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.095367431640624986, 5.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.13168724279835389, 5.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.18593443208187072, 5.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.26932907434290460, 5.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.40187757201646102, 5.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.62092132305915493, 5.0000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.6935087808430296, 5.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 3.0517578125000036, 5.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 5.9499018266198629, 5.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 12.860082304526767, 5.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 32.000000000000000, 5.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 97.656250000000114, 5.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 411.52263374485722, 5.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 3124.9999999999995, 5.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 100000.00000000055, 5.0000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler170 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=20.000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 60129542144.000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 2.0181355730232468e-15
// mean(f - f_GSL): 3164712852.2154636
// variance(f - f_GSL): 1.9029272767041847e+20
// stddev(f - f_GSL): 13794663014.021708
const testcase_hyperg<double>
data171[19] =
{
  { -1.8650300348790099e-05, 5.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { -3.6488008415371319e-05, 5.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { -6.4614776410961038e-05, 5.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { -8.4495207102246549e-05, 5.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 2.2276197023825424e-05, 5.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.00070736115111457809, 5.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.0027829732057272588, 5.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.0013283545664371644, 5.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { -0.041767631015048774, 5.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 61.311496556100003, 5.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 2397.4420539085872, 5.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 103687.60998586559, 5.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 6247196.6451069508, 5.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 656408576.00000000, 5.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 165334768098.54715, 5.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 175097125520819.91, 5.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 2.6818275451660257e+18, 5.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 2.9794600000000777e+25, 5.0000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler171 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=20.000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 9437184.0000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 2.0515617391303805e-15
// mean(f - f_GSL): 496693.97369064158
// variance(f - f_GSL): 4687391593519.1660
// stddev(f - f_GSL): 2165038.4739119918
const testcase_hyperg<double>
data172[19] =
{
  { -3.6403884516313627e-06, 5.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { -9.5873829246491408e-06, 5.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { -2.6052245147200097e-05, 5.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { -7.2378303598384501e-05, 5.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { -0.00020048577321417379, 5.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { -0.00051222704046234439, 5.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { -0.00080950511491888959, 5.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.0043473422174314250, 5.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.081078342558623853, 5.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 12.794854084397739, 5.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 195.15639104739174, 5.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 3938.7991953190131, 5.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 118521.48653762160, 5.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 6291455.9999999972, 5.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 773070496.50699198, 5.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 363276452167.04718, 5.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 2002716064453133.0, 5.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 4.6000000000001222e+21, 5.0000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler172 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=20.000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 5120.0000000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.7944916193878173e-15
// mean(f - f_GSL): 269.47388985302263
// variance(f - f_GSL): 1379705.1461701661
// stddev(f - f_GSL): 1174.6085076186730
const testcase_hyperg<double>
data173[19] =
{
  { 0.00014313323624053599, 5.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.00025426183473118769, 5.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.00048255612836437054, 5.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.00099096904674794185, 5.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.0022347805521915616, 5.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.0056271390060294354, 5.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.016109059519227351, 5.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.053453465775609076, 5.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.20995202901839263, 5.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 5.9534372167648799, 5.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 46.157632071206095, 5.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 494.32074431164915, 5.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 7989.5277611776519, 5.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 224179.55830753347, 5.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 13848144.485282511, 5.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 2948587692.8892150, 5.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 5940513286161.6602, 5.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 2.8531757655946394e+18, 5.0000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler173 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=20.000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 7.0000000000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.5351977183413728e-15
// mean(f - f_GSL): 0.36842306154970872
// variance(f - f_GSL): 2.5789458059294108
// stddev(f - f_GSL): 1.6059096506122039
const testcase_hyperg<double>
data174[19] =
{
  { 0.0012492049968744917, 5.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.0019931241968014200, 5.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.0033203386861410844, 5.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.0058191894509856774, 5.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.010830090368313864, 5.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.021653062305193541, 5.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.047180821280919195, 5.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.11405637279736212, 5.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.31275468794721017, 5.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 3.8598904658643969, 5.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 18.806301417906734, 5.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 122.77054465017432, 5.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1168.4762146809012, 5.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 18437.511788521082, 5.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 597441.79669264762, 5.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 59390411.369228527, 5.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 44681668993.361603, 5.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 4559673269683333.0, 5.0000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler174 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, b=20.000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 0.029296875000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.8717083246628342e-15
// mean(f - f_GSL): 0.0015419659355661440
// variance(f - f_GSL): 4.5173964710879197e-05
// stddev(f - f_GSL): 0.0067211579888348996
const testcase_hyperg<double>
data175[19] =
{
  { 0.0038867957051370739, 5.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.0058484892597364235, 5.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.0090987656053758189, 5.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.014714392537270657, 5.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.024900404542056772, 5.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.044460184663785055, 5.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.084638849196357113, 5.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.17409058241291026, 5.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.39357055823580767, 5.0000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 5.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 2.9410794636226596, 5.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 10.417226071414374, 5.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 46.930585873140835, 5.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 290.76717121814988, 5.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 2788.1641083374830, 5.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 50228.117718560752, 5.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 2433042.3476752895, 5.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 705345246.77141762, 5.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 15652478868617.246, 5.0000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler175 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=0.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data176[19] =
{
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler176 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=0.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data177[19] =
{
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler177 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=0.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data178[19] =
{
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler178 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=0.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data179[19] =
{
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler179 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=0.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data180[19] =
{
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler180 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=0.50000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 1.4901161193847656e-08 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.8229127098647768e-15
// mean(f - f_GSL): 7.8543415046726153e-10
// variance(f - f_GSL): 1.1684633485497506e-17
// stddev(f - f_GSL): 3.4182793164832956e-09
const testcase_hyperg<double>
data181[19] =
{
  { 0.37727530159464628, 10.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.39816010922169059, 10.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.42283703041362447, 10.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.45255640448730527, 10.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.48919507154431119, 10.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.53569358917731902, 10.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.59689778897029577, 10.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.68128587569875765, 10.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.80478739308790359, 10.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.3408664196153621, 10.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 2.0175364359923882, 10.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 3.6011214553736646, 10.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 8.1799429939495489, 10.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 25.644834637536000, 10.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 123.13738891597615, 10.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1088.7122410321385, 10.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 27358.291704709951, 10.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 8174369.0266732639, 10.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler181 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=0.50000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 2.0008883439004421e-11 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.5684473872214445e-15
// mean(f - f_GSL): 1.0626587329385841e-12
// variance(f - f_GSL): 2.1050090066796454e-23
// stddev(f - f_GSL): 4.5880377141863658e-12
const testcase_hyperg<double>
data182[19] =
{
  { 0.53905528308450823, 10.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.56235533974376162, 10.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.58887657983263575, 10.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.61941227047262937, 10.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.65504896640793864, 10.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.69731666644529977, 10.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.74844073299399116, 10.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.81178446800105830, 10.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.89266981277598045, 10.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.1497248473106778, 10.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.3729717112654578, 10.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.7374982340374392, 10.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 2.4134479340960602, 10.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 3.9191255240471192, 10.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 8.3316373077761270, 10.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 28.323020339843417, 10.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 225.84286572747891, 10.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 12757.127591286826, 10.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler182 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=0.50000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 1.9895196601282805e-13 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.4567107859209851e-15
// mean(f - f_GSL): 1.1043797455481820e-14
// variance(f - f_GSL): 2.0706176432127926e-27
// stddev(f - f_GSL): 4.5504039855959963e-14
const testcase_hyperg<double>
data183[19] =
{
  { 0.62672622092226027, 10.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.64931010269769840, 10.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.67448067519076293, 10.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.70276306239803643, 10.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.73484179773087521, 10.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.77162761412743874, 10.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.81436116844816553, 10.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.86477994787944579, 10.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.92539820516603888, 10.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0945599448210315, 10.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.2190897395597269, 10.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.3916844336856475, 10.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.6484497630432020, 10.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 2.0717772717131155, 10.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 2.8893613630810924, 10.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 4.9459404075413573, 10.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 13.487394149998716, 10.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 136.57616044014080, 10.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler183 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=0.50000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 1.2434497875801753e-14 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.3245081211977792e-15
// mean(f - f_GSL): 8.5311874523827817e-16
// variance(f - f_GSL): 7.8655509529357183e-30
// stddev(f - f_GSL): 2.8045589587198410e-15
const testcase_hyperg<double>
data184[19] =
{
  { 0.68421604440344319, 10.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.70548098055548925, 10.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.72884342311710337, 10.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.75466953437856232, 10.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.78342090924662589, 10.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.81568884278645115, 10.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.85224480241465261, 10.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.89411692571131685, 10.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.94270986892954811, 10.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0688682849120232, 10.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.1537004376097553, 10.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.2615455028370031, 10.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.4045541456153443, 10.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.6057216489444517, 10.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.9146603020550739, 10.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 2.4617931307620307, 10.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 3.7267799624996498, 10.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 9.3880118036248721, 10.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler184 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=0.50000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.8577584504832499e-16
// mean(f - f_GSL): 5.8432790769745078e-18
// variance(f - f_GSL): 1.1262748212790853e-32
// stddev(f - f_GSL): 1.0612609581432294e-16
const testcase_hyperg<double>
data185[19] =
{
  { 0.72547625011001160, 10.000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.74535599249992990, 10.000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.76696498884737041, 10.000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.79056941504209477, 10.000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.81649658092772603, 10.000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.84515425472851669, 10.000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.87705801930702931, 10.000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.91287092917527690, 10.000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.95346258924559224, 10.000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0540925533894598, 10.000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.1180339887498949, 10.000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.1952286093343938, 10.000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.2909944487358058, 10.000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.4142135623730951, 10.000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.5811388300841900, 10.000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.8257418583505542, 10.000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 2.2360679774997898, 10.000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 3.1622776601683809, 10.000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler185 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=1.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 2.0861625671386719e-07 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.6897916810721003e-15
// mean(f - f_GSL): 1.0989192059253727e-08
// variance(f - f_GSL): 2.2903477685061008e-15
// stddev(f - f_GSL): 4.7857577963224392e-08
const testcase_hyperg<double>
data186[19] =
{
  { 0.12307420104127866, 10.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.13818870041457434, 10.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.15739165631811705, 10.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.18249038606882081, 10.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.21644171225027795, 10.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.26433326159804149, 10.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.33544459430654527, 10.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.44788516696232511, 10.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.63989153514168373, 10.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.7568608796813312, 10.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 3.5836558871799102, 10.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 8.8077526749963226, 10.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 27.285841702089265, 10.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 113.55555555555557, 10.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 706.24023437500091, 10.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 8064.1687976652511, 10.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 271267.22222222196, 10.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 123456790.00000113, 10.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler186 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=1.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 2.6193447411060333e-10 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.6039867544159698e-15
// mean(f - f_GSL): 1.3861192895235850e-11
// variance(f - f_GSL): 3.6088478524883243e-21
// stddev(f - f_GSL): 6.0073686856129647e-11
const testcase_hyperg<double>
data187[19] =
{
  { 0.28363728383055781, 10.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.30933003169808387, 10.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.33998437757128797, 10.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.37713553224291113, 10.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.42299736538419669, 10.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.48086597727600089, 10.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.55583495759293033, 10.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.65612850114039678, 10.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.79573668772968142, 10.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.3184712058058303, 10.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.8576958065941236, 10.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 2.8759509651764228, 10.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 5.1046225531822289, 10.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 11.095238095238095, 10.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 32.797154017857174, 10.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 158.01935680536548, 10.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1815.9523809523814, 10.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 163302.14285714392, 10.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler187 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=1.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 2.0463630789890885e-12 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.5238873992471854e-15
// mean(f - f_GSL): 1.1029773585697082e-13
// variance(f - f_GSL): 2.1981059026132227e-25
// stddev(f - f_GSL): 4.6883962104468326e-13
const testcase_hyperg<double>
data188[19] =
{
  { 0.39006633302741811, 10.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.41898885698103278, 10.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.45245557983812590, 10.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.49160548618861627, 10.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.53798419230517991, 10.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.59373881442067322, 10.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.66193391357076092, 10.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.74708402736952118, 10.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.85609281019430605, 10.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.1974451135148187, 10.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.4820886036706358, 10.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.9201183180477521, 10.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 2.6569338297733367, 10.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 4.0634920634920650, 10.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 7.3102678571428568, 10.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 17.512574302697782, 10.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 74.206349206349131, 10.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1342.8571428571502, 10.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler188 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=1.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 7.8159700933611020e-14 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.4210854715201975e-15
// mean(f - f_GSL): 4.6629367034256575e-15
// variance(f - f_GSL): 3.1677071819086927e-28
// stddev(f - f_GSL): 1.7798053775367387e-14
const testcase_hyperg<double>
data189[19] =
{
  { 0.46726928123633210, 10.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.49687547629934464, 10.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.53045208856322223, 10.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.56884765624999989, 10.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.61316872427983504, 10.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.66488500161969544, 10.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.72598998634501621, 10.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.79925411522633760, 10.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.88863845062192182, 10.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.1423563481176653, 10.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.3302951388888891, 10.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.5889212827988335, 10.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.9650205761316886, 10.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 2.5555555555555549, 10.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 3.5937500000000013, 10.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 5.7818930041152274, 10.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 12.222222222222220, 10.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 55.000000000000114, 10.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler189 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=1.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 1.7763568394002505e-15 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.9984014443252816e-16
// mean(f - f_GSL): 7.5962628000668607e-17
// variance(f - f_GSL): 1.6955391669463862e-31
// stddev(f - f_GSL): 4.1176925175957300e-16
const testcase_hyperg<double>
data190[19] =
{
  { 0.52631578947368429, 10.000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.55555555555555558, 10.000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.58823529411764708, 10.000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.62500000000000000, 10.000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.66666666666666663, 10.000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.71428571428571430, 10.000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.76923076923076938, 10.000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.83333333333333337, 10.000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.90909090909090906, 10.000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.1111111111111112, 10.000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.2500000000000002, 10.000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.4285714285714286, 10.000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.6666666666666670, 10.000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 2.0000000000000000, 10.000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 2.5000000000000009, 10.000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 3.3333333333333348, 10.000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 5.0000000000000009, 10.000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 10.000000000000011, 10.000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler190 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=2.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 2.2888183593750000e-05 at index 18
// max(|f - f_GSL| / |f_GSL|): 2.4795532226562509e-15
// mean(f - f_GSL): 1.2059140510950354e-06
// variance(f - f_GSL): 2.7568813079896666e-11
// stddev(f - f_GSL): 5.2506012112801583e-06
const testcase_hyperg<double>
data191[19] =
{
  { 0.0016310376661280216, 10.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.0028007538972582421, 10.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.0049603324681551939, 10.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.0090949470177292789, 10.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.017341529915832606, 10.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.034571613033607791, 10.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.072538150286405839, 10.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.16150558288984579, 10.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.38554328942953142, 10.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 2.8679719907924444, 10.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 9.3132257461548065, 10.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 35.401331746414378, 10.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 165.38171687920246, 10.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1024.0000000000000, 10.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 9536.7431640625218, 10.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 169350.87808430390, 10.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 9765624.9999999963, 10.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 10000000000.000111, 10.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler191 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=2.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 1.4901161193847656e-08 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.4958811384436608e-15
// mean(f - f_GSL): 7.8582773037277017e-10
// variance(f - f_GSL): 1.1683981904064149e-17
// stddev(f - f_GSL): 3.4181840067591665e-09
const testcase_hyperg<double>
data192[19] =
{
  { 0.071191280690193537, 10.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.085646504654238384, 10.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.10478215656371109, 10.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.13074816337653578, 10.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.16701141666848118, 10.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.21939323375313963, 10.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.29813515331786639, 10.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.42225974638874397, 10.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.62942145962174878, 10.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.7218685262373197, 10.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 3.2855760483514738, 10.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 7.1616652508907093, 10.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 18.612326808485950, 10.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 61.476190476190474, 10.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 286.27580915178623, 10.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 2274.9441142102414, 10.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 47229.761904761865, 10.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 9961460.7142858077, 10.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler192 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=2.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 8.7311491370201111e-11 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.5843951771650161e-15
// mean(f - f_GSL): 4.6467391338242840e-12
// variance(f - f_GSL): 4.0072766661644994e-22
// stddev(f - f_GSL): 2.0018183399510804e-11
const testcase_hyperg<double>
data193[19] =
{
  { 0.14747230019381058, 10.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.17073600100690609, 10.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.19982795745135354, 10.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.23681776864188053, 10.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.28475624360398011, 10.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.34827500743063161, 10.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.43464829159684687, 10.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.55576053438064787, 10.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.73195020913445530, 10.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.4310223867822929, 10.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 2.1742563399057566, 10.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 3.5769231236256043, 10.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 6.5620441134844469, 10.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 14.063492063492063, 10.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 38.085937500000036, 10.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 150.92973632068330, 10.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1212.3015873015852, 10.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 55107.142857143110, 10.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler193 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=2.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 1.8189894035458565e-12 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.4848893090170230e-15
// mean(f - f_GSL): 1.0027066896088256e-13
// variance(f - f_GSL): 1.7322804840633983e-25
// stddev(f - f_GSL): 4.1620673757922257e-13
const testcase_hyperg<double>
data194[19] =
{
  { 0.21658059714090577, 10.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.24513539602702861, 10.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.27967018274845046, 10.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.32196044921875022, 10.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.37448559670781911, 10.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.44078856032208802, 10.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.52606701446027793, 10.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.63818158436213956, 10.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.78944971882612769, 10.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.3044251384443430, 10.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.7659505208333344, 10.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 2.5093710953769270, 10.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 3.8065843621399202, 10.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 6.3333333333333313, 10.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 12.109375000000004, 10.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 29.115226337448608, 10.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 108.33333333333330, 10.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1225.0000000000023, 10.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler194 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=2.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 4.2632564145606011e-14 at index 18
// max(|f - f_GSL| / |f_GSL|): 4.2632564145605916e-16
// mean(f - f_GSL): 2.3636063866361887e-15
// variance(f - f_GSL): 9.5093179694074762e-29
// stddev(f - f_GSL): 9.7515731907254209e-15
const testcase_hyperg<double>
data195[19] =
{
  { 0.27700831024930750, 10.000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.30864197530864196, 10.000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.34602076124567477, 10.000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.39062500000000000, 10.000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.44444444444444442, 10.000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.51020408163265318, 10.000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.59171597633136108, 10.000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.69444444444444442, 10.000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.82644628099173545, 10.000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.2345679012345683, 10.000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.5625000000000007, 10.000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 2.0408163265306127, 10.000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 2.7777777777777795, 10.000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 4.0000000000000000, 10.000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 6.2500000000000027, 10.000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 11.111111111111125, 10.000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 25.000000000000007, 10.000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 100.00000000000023, 10.000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler195 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=5.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 0.81250000000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.8182428501096257e-15
// mean(f - f_GSL): 0.042765168793266639
// variance(f - f_GSL): 0.034744884250260212
// stddev(f - f_GSL): 0.18639979680852714
const testcase_hyperg<double>
data196[19] =
{
  { 0.00063586451658060813, 10.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.0010334743461763829, 10.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.0015326246054669763, 10.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.0019007018181583513, 10.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.0012845577715431562, 10.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { -0.0027213806178060305, 10.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { -0.015121744574954044, 10.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { -0.036637840562974290, 10.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.019117849062621605, 10.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 9.8116901852350615, 10.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 84.255589172244427, 10.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 773.87517619421294, 10.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 8556.9725363054076, 10.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 129023.99999999996, 10.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 3174543.3807373112, 10.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 175133896.95814583, 10.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 43564453125.000061, 10.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 446860000000007.00, 10.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler196 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=5.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 0.00039672851562500000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.6882064494680641e-15
// mean(f - f_GSL): 2.0884382210121993e-05
// variance(f - f_GSL): 8.2836958019297269e-09
// stddev(f - f_GSL): 9.1014810893226203e-05
const testcase_hyperg<double>
data197[19] =
{
  { -0.00030045430691814646, 10.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { -0.00031119487747322054, 10.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { -0.00014589213141656318, 10.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.00056843418860824636, 10.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.0028902549859721747, 10.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.0098776037238877245, 10.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.030689217428863859, 10.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.094211590019076558, 10.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.29791981455918370, 10.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 3.6646308771236793, 10.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 15.133991837501567, 10.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 73.331330046144089, 10.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 441.01791167787303, 10.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 3583.9999999999991, 10.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 45299.530029296984, 10.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1157231.0002427436, 10.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 107421875.00000016, 10.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 235000000000.00293, 10.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler197 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=5.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 9.5367431640625000e-07 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.6314276114917587e-15
// mean(f - f_GSL): 5.0242811922592076e-08
// variance(f - f_GSL): 4.7862904884501567e-14
// stddev(f - f_GSL): 2.1877592391417655e-07
const testcase_hyperg<double>
data198[19] =
{
  { 0.0058530497315413248, 10.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.0088526869356855397, 10.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.013770987983442959, 10.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.022108932690960776, 10.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.036786236450921550, 10.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.063750669040426408, 10.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.11577228680714466, 10.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.22197573416125760, 10.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.45361312968415324, 10.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 2.4162889363082747, 10.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 6.5381564791240541, 10.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 20.415771011498428, 10.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 76.870682056629448, 10.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 373.58730158730162, 10.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 2626.2555803571477, 10.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 33060.960671081237, 10.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1203521.8253968258, 10.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 584564285.71428990, 10.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler198 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=5.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 7.4505805969238281e-09 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.6196914341138665e-15
// mean(f - f_GSL): 3.9331532183208954e-10
// variance(f - f_GSL): 2.9206631793126476e-18
// stddev(f - f_GSL): 1.7089947862157589e-09
const testcase_hyperg<double>
data199[19] =
{
  { 0.020248990107069573, 10.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.027876687750502366, 10.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.039154648888447607, 10.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.056251883506774715, 10.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.082914189910074473, 10.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.12585357817786472, 10.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.19761423206224940, 10.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.32280443863359237, 10.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.55250024062839420, 10.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.9374297986599267, 10.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 4.0849049886067759, 10.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 9.5926988633258983, 10.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 25.958314281359588, 10.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 85.333333333333300, 10.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 372.31445312500028, 10.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 2545.3436976070780, 10.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 39583.333333333343, 10.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 4600000.0000000261, 10.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler199 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=5.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 1.0186340659856796e-10 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.1641532182693482e-15
// mean(f - f_GSL): 5.5487040400966458e-12
// variance(f - f_GSL): 5.4399356990620132e-22
// stddev(f - f_GSL): 2.3323669734975269e-11
const testcase_hyperg<double>
data200[19] =
{
  { 0.040386107340619273, 10.000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.052922149401344633, 10.000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.070429627772374270, 10.000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.095367431640624986, 10.000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.13168724279835389, 10.000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.18593443208187072, 10.000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.26932907434290460, 10.000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.40187757201646102, 10.000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.62092132305915493, 10.000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.6935087808430296, 10.000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 3.0517578125000036, 10.000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 5.9499018266198629, 10.000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 12.860082304526767, 10.000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 32.000000000000000, 10.000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 97.656250000000114, 10.000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 411.52263374485722, 10.000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 3124.9999999999995, 10.000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 100000.00000000055, 10.000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler200 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=10.000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 3407872.0000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.8642431677285562e-15
// mean(f - f_GSL): 179361.84215676156
// variance(f - f_GSL): 611241601687.40417
// stddev(f - f_GSL): 781819.41756866348
const testcase_hyperg<double>
data201[19] =
{
  { 2.3388730079478156e-05, 10.000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { -2.3204970759764180e-05, 10.000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { -0.00016219730505521665, 10.000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { -0.00044366962360922366, 10.000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { -0.00071863577205453773, 10.000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 4.4378596544482927e-05, 10.000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.0044446568070621991, 10.000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.0071045155183571615, 10.000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { -0.049961558159890306, 10.000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 51.305449964107403, 10.000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1435.9545414461415, 10.000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 39657.913058984115, 10.000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 1346016.4468570619, 10.000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 68086556.444444403, 10.000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 6646235808.7301531, 10.000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1954852335479.9958, 10.000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 4573796225043418.0, 10.000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.8280190368900440e+21, 10.000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler201 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=10.000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 832.00000000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.7889121078953330e-15
// mean(f - f_GSL): 43.789679427686345
// variance(f - f_GSL): 36432.823085424323
// stddev(f - f_GSL): 190.87384075725075
const testcase_hyperg<double>
data202[19] =
{
  { 1.3504013648914116e-05, 10.000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 3.1753432098506483e-05, 10.000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 6.2032098207654132e-05, 10.000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 8.8747213942816339e-05, 10.000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0478094697613739e-05, 10.000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { -0.00055998751006022351, 10.000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { -0.0024718654966575221, 10.000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { -0.0027000264053620069, 10.000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.066515394406810743, 10.000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 11.579200866389527, 10.000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 137.50750548795330, 10.000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1901.3196072993419, 10.000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 34210.659507138007, 10.000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 920588.19047619053, 10.000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 45876220.933028772, 10.000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 6234608574.0964050, 10.000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 5445391090029.7783, 10.000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 4.6508713107143840e+17, 10.000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler202 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=10.000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 0.93750000000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.8742262123208804e-15
// mean(f - f_GSL): 0.049343110712039846
// variance(f - f_GSL): 0.046258118950011272
// stddev(f - f_GSL): 0.21507700702309224
const testcase_hyperg<double>
data203[19] =
{
  { -2.6846726901509877e-05, 10.000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { -4.7817237144298244e-05, 10.000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { -7.2908121941826117e-05, 10.000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { -6.0427853197636777e-05, 10.000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.00020559720946644960, 10.000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.0017056910683365867, 10.000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.0088037230970524228, 10.000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.041510819735141528, 10.000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.19754880805677244, 10.000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 5.6130947302779246, 10.000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 36.475357196722619, 10.000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 289.29483001400672, 10.000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 3010.8676549536667, 10.000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 45844.317460317419, 10.000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1221852.6431492427, 10.000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 79585968.928969592, 10.000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 26733475942.460335, 10.000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 500206428571437.38, 10.000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler203 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=10.000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 0.0024414062500000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.6580008488964090e-15
// mean(f - f_GSL): 0.00012850766473236850
// variance(f - f_GSL): 3.1370523903989881e-07
// stddev(f - f_GSL): 0.00056009395554665537
const testcase_hyperg<double>
data204[19] =
{
  { 0.00025866179054283083, 10.000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.00053402577739226583, 10.000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.0011390075227239291, 10.000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.0025224267119482941, 10.000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.0058340332124251458, 10.000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.014189256143045212, 10.000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.036590990011337789, 10.000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.10106560781146991, 10.000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.30278778538531392, 10.000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 3.7187249990350599, 10.000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 16.023275545901761, 10.000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 83.265377219882822, 10.000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 553.31413918844225, 10.000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 5148.4444444444416, 10.000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 78082.084655761908, 10.000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 2565874.8781353347, 10.000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 346137152.77777809, 10.000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1472500000000.0227, 10.000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler204 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=10.000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 2.2888183593750000e-05 at index 18
// max(|f - f_GSL| / |f_GSL|): 2.4795532226562509e-15
// mean(f - f_GSL): 1.2059140510950354e-06
// variance(f - f_GSL): 2.7568813079896666e-11
// stddev(f - f_GSL): 5.2506012112801583e-06
const testcase_hyperg<double>
data205[19] =
{
  { 0.0016310376661280216, 10.000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.0028007538972582421, 10.000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.0049603324681551939, 10.000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.0090949470177292789, 10.000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.017341529915832606, 10.000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.034571613033607791, 10.000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.072538150286405839, 10.000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.16150558288984579, 10.000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.38554328942953142, 10.000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 2.8679719907924444, 10.000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 9.3132257461548065, 10.000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 35.401331746414378, 10.000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 165.38171687920246, 10.000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1024.0000000000000, 10.000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 9536.7431640625218, 10.000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 169350.87808430390, 10.000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 9765624.9999999963, 10.000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 10000000000.000111, 10.000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler205 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=20.000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 2.5940733853654057e+18 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.8312596334404269e-15
// mean(f - f_GSL): 1.3653017829015250e+17
// variance(f - f_GSL): 4.1617051640949032e+35
// stddev(f - f_GSL): 6.4511279355589466e+17
const testcase_hyperg<double>
data206[19] =
{
  { -2.1776535312781759e-07, 10.000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { -2.9128833151630439e-06, 10.000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { -9.4755553429932710e-06, 10.000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { -1.2844297353852837e-05, 10.000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 3.6576965483549205e-05, 10.000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.00020847453890703339, 10.000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { -0.00022868510398194936, 10.000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { -0.0021855513841943421, 10.000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.014662111759334568, 10.000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 746.44776348798098, 10.000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 136080.48445225772, 10.000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 23094279.597826406, 10.000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 5315913395.5545979, 10.000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 2261935718399.9990, 10.000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 2669150854828235.0, 10.000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.7499363099366351e+19, 10.000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 2.8881518494606140e+24, 10.000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.4165513933662505e+33, 10.000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler206 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=20.000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 299067162755072.00 at index 18
// max(|f - f_GSL| / |f_GSL|): 2.1129345912023457e-15
// mean(f - f_GSL): 15740377042297.895
// variance(f - f_GSL): 4.7074334083472640e+27
// stddev(f - f_GSL): 68610738287437.656
const testcase_hyperg<double>
data207[19] =
{
  { 1.7149006966334498e-07, 10.000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 3.2399324906563845e-07, 10.000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.6015317699713284e-07, 10.000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { -2.0500917201273337e-06, 10.000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { -1.0175546788592665e-05, 10.000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { -1.1720101988188077e-05, 10.000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.00014199637113982382, 10.000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.00021263363640641769, 10.000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { -0.0072649256698439626, 10.000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 90.430293772869618, 10.000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 6248.1455940292872, 10.000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 501143.39852548984, 10.000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 58852027.356440276, 10.000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 12942923093.333330, 10.000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 7618073993853.6592, 10.000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 22630251562549772., 10.000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.3708372433980356e+21, 10.000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.4154113620000448e+29, 10.000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler207 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=20.000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 103079215104.00000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.8869870511941024e-15
// mean(f - f_GSL): 5425221928.4235201
// variance(f - f_GSL): 5.5922760890380314e+20
// stddev(f - f_GSL): 23647993760.651306
const testcase_hyperg<double>
data208[19] =
{
  { -1.6667473284194196e-08, 10.000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 8.6214843496406671e-08, 10.000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 5.7778331275185146e-07, 10.000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 2.1911400502042259e-06, 10.000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 4.7440049217199358e-06, 10.000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { -1.0564233314712615e-05, 10.000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { -0.00017990026051847404, 10.000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { -0.00027618146288724629, 10.000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.030606019577723666, 10.000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 27.832854169493341, 10.000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 874.00624088575910, 10.000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 36049.199340831554, 10.000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 2270967.7298625209, 10.000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 266979100.44444439, 10.000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 80311224337.493027, 10.000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 110111693103801.77, 10.000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 2.4838871426052618e+18, 10.000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 5.4626350000001618e+25, 10.000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler208 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=20.000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 100663296.00000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.9414329026036117e-15
// mean(f - f_GSL): 5298068.6316046715
// variance(f - f_GSL): 533321003794731.12
// stddev(f - f_GSL): 23093743.823701065
const testcase_hyperg<double>
data209[19] =
{
  { -1.5843795889906876e-07, 10.000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { -5.4877276002864784e-07, 10.000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { -1.7169507967699695e-06, 10.000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { -4.5236439749819329e-06, 10.000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { -5.5690492560381956e-06, 10.000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 5.6914115606653561e-05, 10.000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.00082507252097489250, 10.000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.0085739249288230429, 10.000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.088244357683754687, 10.000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 13.387208440156897, 10.000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 226.77895441155252, 10.000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 5281.5716482686785, 10.000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 189431.77762850633, 10.000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 12408149.333333332, 10.000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1966782292.5839682, 10.000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1274123112205.7700, 10.000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 10903676350911508., 10.000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 5.1850000000001411e+22, 10.000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler209 = 2.5000000000000020e-13;

// Test data for a=10.000000000000000, b=20.000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 475136.00000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 5.4067200000000052e-15
// mean(f - f_GSL): 25007.185032091642
// variance(f - f_GSL): 11881799540.814577
// stddev(f - f_GSL): 109003.66755671379
const testcase_hyperg<double>
data210[19] =
{
  { 2.6602838683283435e-06, 10.000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 7.8442223930072316e-06, 10.000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 2.4604898194634598e-05, 10.000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 8.2718061255302686e-05, 10.000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.00030072865982171723, 10.000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.0011951964277455204, 10.000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.0052617832469731996, 10.000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.026084053304588850, 10.000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.14864362802414346, 10.000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 10.000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 8.2252633399699757, 10.000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 86.736173798840738, 10.000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1253.2542894196868, 10.000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 27351.112277912678, 10.000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1048576.0000000000, 10.000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 90949470.177293226, 10.000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 28679719907.924767, 10.000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 95367431640624.906, 10.000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000220e+20, 10.000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler210 = 5.0000000000000039e-13;

// Test data for a=20.000000000000000, b=0.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data211[19] =
{
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler211 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=0.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data212[19] =
{
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler212 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=0.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data213[19] =
{
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler213 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=0.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data214[19] =
{
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler214 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=0.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_hyperg<double>
data215[19] =
{
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler215 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=0.50000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 48.000000000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.8556481344874416e-15
// mean(f - f_GSL): 2.5263190030329112
// variance(f - f_GSL): 121.26314075575490
// stddev(f - f_GSL): 11.011954447588080
const testcase_hyperg<double>
data216[19] =
{
  { 0.26690449940521549, 20.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.28252302866181833, 20.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.30123616141153836, 20.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.32421384687602633, 20.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.35334630811776774, 20.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.39191793127466995, 20.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.44620488618129212, 20.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.52980896919265719, 20.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.67754711477562324, 20.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.9567557771780317, 20.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 6.1816042148333272, 20.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 35.653088618561227, 20.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 377.51482843180133, 20.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 7645.8816551195359, 20.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 354791.74537980522, 20.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 57009889.966639392, 20.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 83771357024.863937, 20.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 25866972896377436., 20.000000000000000, 0.50000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler216 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=0.50000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 0.011718750000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.7519521419033478e-15
// mean(f - f_GSL): 0.00061678102606403001
// variance(f - f_GSL): 7.2278413174892008e-06
// stddev(f - f_GSL): 0.0026884644906506020
const testcase_hyperg<double>
data217[19] =
{
  { 0.40342659436153389, 20.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.42420571192034318, 20.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.44852768286073041, 20.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.47751245808592863, 20.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.51283632632707765, 20.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.55713468814894329, 20.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.61481320817757346, 20.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.69383483410097213, 20.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.81012002526006044, 20.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.3622225506603911, 20.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 2.2349513086109027, 20.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 5.1864917536761723, 20.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 21.020560423779497, 20.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 175.19649997100612, 20.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 3467.1587803688708, 20.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 225003.88683446089, 20.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 110837674.65652709, 20.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 6688966964170.9326, 20.000000000000000, 0.50000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler217 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=0.50000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 1.4305114746093750e-05 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.9261147266353426e-15
// mean(f - f_GSL): 7.5292535813082699e-07
// variance(f - f_GSL): 1.0770292922645316e-11
// stddev(f - f_GSL): 3.2818124447697064e-06
const testcase_hyperg<double>
data218[19] =
{
  { 0.48716309885816822, 20.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.50965859152542337, 20.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.53554809210658938, 20.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.56576689207507136, 20.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.60164849637133655, 20.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.64516711595404408, 20.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.69938278735493553, 20.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.76931621518401860, 20.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.86381808725530662, 20.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.2152051956815531, 20.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.6052546785425557, 20.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 2.4765586046012635, 20.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 5.1564492216997611, 20.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 18.446158392136365, 20.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 150.44577670123971, 20.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 3862.6317400116104, 20.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 632428.34833625401, 20.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 7426927663.3810987, 20.000000000000000, 0.50000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler218 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=0.50000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 4.0978193283081055e-08 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.7692881266931270e-15
// mean(f - f_GSL): 2.1571346930926438e-09
// variance(f - f_GSL): 8.8377830897836260e-17
// stddev(f - f_GSL): 9.4009484041683924e-09
const testcase_hyperg<double>
data219[19] =
{
  { 0.54703266209548373, 20.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.56997321774144960, 20.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.59603026159654982, 20.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.62596978851120511, 20.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.66084565876898915, 20.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.70215256667232862, 20.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.75208916592008568, 20.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.81403631111658625, 20.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.89348608489854597, 20.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.1517793185139173, 20.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.3878110313656606, 20.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 1.8061071794572381, 20.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 2.7148594517859612, 20.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 5.4529435709049361, 20.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 19.487310275377109, 20.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 191.69079165937592, 20.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 10218.543981792311, 20.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 23160836.646584522, 20.000000000000000, 0.50000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler219 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=0.50000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 2.9103830456733704e-10 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.6694673196526424e-15
// mean(f - f_GSL): 1.5333453804912193e-11
// variance(f - f_GSL): 4.4575621294589140e-21
// stddev(f - f_GSL): 6.6764976817631821e-11
const testcase_hyperg<double>
data220[19] =
{
  { 0.59292067298616025, 20.000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.61572496720679892, 20.000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.64135339122875590, 20.000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.67043457419280461, 20.000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.70380956268170969, 20.000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.74263251901495264, 20.000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.78853555445528289, 20.000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.84391122775673755, 20.000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.91242401018807373, 20.000000000000000, 0.50000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.1169059681274873, 20.000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.2825928301302669, 20.000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1.5385937789924939, 20.000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 1.9895771187893914, 20.000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 2.9707335806970168, 20.000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 6.0299506157180467, 20.000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 24.259090336955669, 20.000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 406.27267173257223, 20.000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 174330.03997220617, 20.000000000000000, 0.50000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler220 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=1.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 1024.0000000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.7510399999999635e-15
// mean(f - f_GSL): 53.894788252704814
// variance(f - f_GSL): 55188.204676932175
// stddev(f - f_GSL): 234.92169903381034
const testcase_hyperg<double>
data221[19] =
{
  { 0.058479236576646311, 20.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.065788544763137821, 20.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.075184824937824482, 20.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.087707688693157121, 20.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.10521567442213345, 20.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.13135877960541509, 20.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.17423854066297137, 20.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.25492082527223520, 20.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.44025895219654843, 20.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 3.3698615820910360, 20.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 17.997089220808562, 20.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 153.73298291118951, 20.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 2159.1667587825768, 20.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 55188.105263157879, 20.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 3191209.3921857267, 20.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 646910975.29153574, 20.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 1254834626850.2659, 20.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 5.8479532163743910e+17, 20.000000000000000, 1.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler221 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=1.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 0.21875000000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.5452521874999694e-15
// mean(f - f_GSL): 0.011513220685868108
// variance(f - f_GSL): 0.0025185017633005862
// stddev(f - f_GSL): 0.050184676578618956
const testcase_hyperg<double>
data222[19] =
{
  { 0.15519511120894958, 20.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.17197165701692893, 20.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.19276847315207329, 20.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.21920107206179093, 20.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.25386158960390576, 20.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.30115970686600663, 20.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.36916408142057128, 20.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.47406175901569547, 20.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.65237908266239919, 20.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.8227213362622299, 20.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 4.3716358339791430, 20.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 15.670841312959222, 20.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 94.742651122760662, 20.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 1081.7275541795671, 20.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 27809.787731465960, 20.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 2329811.1715181284, 20.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1537787532.6780224, 20.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 141562653507005.19, 20.000000000000000, 1.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler222 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=1.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 0.00024414062500000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.6763226855512285e-15
// mean(f - f_GSL): 1.2849899481406474e-05
// variance(f - f_GSL): 3.1370759089735494e-09
// stddev(f - f_GSL): 5.6009605506319623e-05
const testcase_hyperg<double>
data223[19] =
{
  { 0.23253645591196551, 20.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.25484220947068342, 20.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.28181987881113812, 20.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.31508211677735770, 20.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.35706285886959610, 20.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.41160053409238190, 20.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.48508083111181938, 20.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.58885194371375260, 20.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.74482241684585782, 20.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.4700356864367146, 20.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 2.4955144453055174, 20.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 5.3506594845833471, 20.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 16.618413752184267, 20.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 89.310629514963878, 20.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1029.3439900542960, 20.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 35659.847863372670, 20.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 8009309.6233230168, 20.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 145640590027.40201, 20.000000000000000, 1.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler223 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=1.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 7.1525573730468750e-07 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.7237966704607975e-15
// mean(f - f_GSL): 3.7648905700618082e-08
// variance(f - f_GSL): 2.6925522674362989e-14
// stddev(f - f_GSL): 1.6408998346749562e-07
const testcase_hyperg<double>
data224[19] =
{
  { 0.29614148314592509, 20.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.32176277356430805, 20.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.35217870475550511, 20.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.38885270445515113, 20.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.43389978380608418, 20.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.49048612522269414, 20.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.56355539635634599, 20.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.66123153239117671, 20.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.79773363961895416, 20.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.3245132157016595, 20.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 1.9065148749742094, 20.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 3.1328798652457452, 20.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 6.4172532944033636, 20.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 19.071683734222436, 20.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 104.41989641582512, 20.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1510.5743992324351, 20.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 115518.14360562043, 20.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 414930455.29174191, 20.000000000000000, 1.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler224 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=1.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 4.6566128730773926e-09 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.6665618165271877e-15
// mean(f - f_GSL): 2.4523176471958370e-10
// variance(f - f_GSL): 1.1411894517911952e-18
// stddev(f - f_GSL): 1.0682646918208967e-09
const testcase_hyperg<double>
data225[19] =
{
  { 0.34954259539177701, 20.000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.37714038609235134, 20.000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.40942091659748781, 20.000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.44767109606846422, 20.000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.49368984777532227, 20.000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.55006638216982318, 20.000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.62065830207408901, 20.000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.71145554513583764, 20.000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.83223839666914623, 20.000000000000000, 1.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.2466748028187731, 20.000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 1.6386752725021760, 20.000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 2.3340068725479681, 20.000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 3.7848108613132099, 20.000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 7.6754638550304133, 20.000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 23.344217312927277, 20.000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 149.83491198246998, 20.000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 3936.9253501916060, 20.000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 2794143.5036480846, 20.000000000000000, 1.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler225 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=2.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 475136.00000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 5.4067200000000052e-15
// mean(f - f_GSL): 25007.185032091642
// variance(f - f_GSL): 11881799540.814577
// stddev(f - f_GSL): 109003.66755671379
const testcase_hyperg<double>
data226[19] =
{
  { 2.6602838683283435e-06, 20.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 7.8442223930072316e-06, 20.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 2.4604898194634598e-05, 20.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { 8.2718061255302686e-05, 20.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.00030072865982171723, 20.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.0011951964277455204, 20.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.0052617832469731996, 20.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.026084053304588850, 20.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.14864362802414346, 20.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 8.2252633399699757, 20.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 86.736173798840738, 20.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 1253.2542894196868, 20.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 27351.112277912678, 20.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1048576.0000000000, 20.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 90949470.177293226, 20.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 28679719907.924767, 20.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 95367431640624.906, 20.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000220e+20, 20.000000000000000, 2.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler226 = 5.0000000000000039e-13;

// Test data for a=20.000000000000000, b=2.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 40.000000000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.8712609271522778e-15
// mean(f - f_GSL): 2.1052671749403089
// variance(f - f_GSL): 84.210508462254538
// stddev(f - f_GSL): 9.1766283820504881
const testcase_hyperg<double>
data227[19] =
{
  { 0.018828092583720632, 20.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.023381944060455365, 20.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.029789623984280887, 20.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.039191021482500567, 20.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.053727813036721528, 20.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.077762010061668857, 20.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.12110505620123323, 20.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.20870149809080582, 20.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.41429234328785763, 20.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 3.1308087404153113, 20.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 13.586180626453100, 20.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 87.117304082784415, 20.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 889.26474381243384, 20.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 16231.913312693494, 20.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 653537.51168945129, 20.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 87756230.793849647, 20.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 101493977171.74945, 20.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 21375960679557820., 20.000000000000000, 2.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler227 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=2.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 0.031250000000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.6379336164121759e-15
// mean(f - f_GSL): 0.0016447556893365942
// variance(f - f_GSL): 5.1397960874034849e-05
// stddev(f - f_GSL): 0.0071692371193896806
const testcase_hyperg<double>
data228[19] =
{
  { 0.049200410661854238, 20.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.059460876757152607, 20.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.073244762686653225, 20.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.092334626017932769, 20.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.11976760350696856, 20.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.16102414609169405, 20.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.22670456785796236, 20.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.33912903252727361, 20.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.55049794600858049, 20.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 2.1254722872032232, 20.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 5.6261213886736314, 20.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 20.137315891130996, 20.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 108.04381584643900, 20.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 992.41692466460245, 20.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 19055.363816004465, 20.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 1105471.9504312191, 20.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 448521363.90608919, 20.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 19078917293639.652, 20.000000000000000, 2.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler228 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=2.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 8.3923339843750000e-05 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.8221514326726564e-15
// mean(f - f_GSL): 4.4172143495227617e-06
// variance(f - f_GSL): 3.7068906120670492e-10
// stddev(f - f_GSL): 1.9253287023433297e-05
const testcase_hyperg<double>
data229[19] =
{
  { 0.083753547015334884, 20.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.099238444687035743, 20.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.11938294012867748, 20.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.14622683905023329, 20.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.18303556733713028, 20.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.23527764069382415, 20.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.31261681740827069, 20.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.43327581880538862, 20.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.63445840637296680, 20.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 1.7438842395813297, 20.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 3.5070840938209331, 20.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 8.6573372006089713, 20.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 28.779342118408998, 20.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 147.50178613955714, 20.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1427.1686016136398, 20.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 36780.643714655955, 20.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 5313869.6058585485, 20.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 46057280607.383286, 20.000000000000000, 2.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler229 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=2.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 5.0663948059082031e-07 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.9925479281069681e-15
// mean(f - f_GSL): 2.6669880993704522e-08
// variance(f - f_GSL): 1.3509399735218820e-14
// stddev(f - f_GSL): 1.1622994336752823e-07
const testcase_hyperg<double>
data230[19] =
{
  { 0.11920045035073676, 20.000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.13907946814302777, 20.000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.16431439792559696, 20.000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.19698796016986989, 20.000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.24028510928790547, 20.000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.29926031296483130, 20.000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.38229327814229175, 20.000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.50402047283093132, 20.000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.69167261179586526, 20.000000000000000, 2.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 1.5503152253394308, 20.000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 2.6469548193635828, 20.000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 5.1882631330566813, 20.000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 12.476792759124546, 20.000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 41.026391565091259, 20.000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 220.92584715988204, 20.000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 2677.0834450236389, 20.000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 141774.31260689779, 20.000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 254267148.83197621, 20.000000000000000, 2.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler230 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=5.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 60129542144.000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 2.0181355730232468e-15
// mean(f - f_GSL): 3164712852.2154636
// variance(f - f_GSL): 1.9029272767041847e+20
// stddev(f - f_GSL): 13794663014.021708
const testcase_hyperg<double>
data231[19] =
{
  { -1.8650300348790099e-05, 20.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { -3.6488008415371319e-05, 20.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { -6.4614776410961038e-05, 20.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { -8.4495207102246549e-05, 20.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 2.2276197023825424e-05, 20.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.00070736115111457809, 20.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.0027829732057272588, 20.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.0013283545664371644, 20.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { -0.041767631015048774, 20.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 61.311496556100003, 20.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 2397.4420539085872, 20.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 103687.60998586559, 20.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 6247196.6451069508, 20.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 656408576.00000000, 20.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 165334768098.54715, 20.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 175097125520819.91, 20.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 2.6818275451660257e+18, 20.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 2.9794600000000777e+25, 20.000000000000000, 5.0000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler231 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=5.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 9437184.0000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 2.0515617391303805e-15
// mean(f - f_GSL): 496693.97369064158
// variance(f - f_GSL): 4687391593519.1660
// stddev(f - f_GSL): 2165038.4739119918
const testcase_hyperg<double>
data232[19] =
{
  { -3.6403884516313627e-06, 20.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { -9.5873829246491408e-06, 20.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { -2.6052245147200097e-05, 20.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { -7.2378303598384501e-05, 20.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { -0.00020048577321417379, 20.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { -0.00051222704046234439, 20.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { -0.00080950511491888959, 20.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.0043473422174314250, 20.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.081078342558623853, 20.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 12.794854084397739, 20.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 195.15639104739174, 20.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 3938.7991953190131, 20.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 118521.48653762160, 20.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 6291455.9999999972, 20.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 773070496.50699198, 20.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 363276452167.04718, 20.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 2002716064453133.0, 20.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 4.6000000000001222e+21, 20.000000000000000, 5.0000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler232 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=5.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 5120.0000000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.7944916193878173e-15
// mean(f - f_GSL): 269.47388985302263
// variance(f - f_GSL): 1379705.1461701661
// stddev(f - f_GSL): 1174.6085076186730
const testcase_hyperg<double>
data233[19] =
{
  { 0.00014313323624053599, 20.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.00025426183473118769, 20.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.00048255612836437054, 20.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.00099096904674794185, 20.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.0022347805521915616, 20.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.0056271390060294354, 20.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.016109059519227351, 20.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.053453465775609076, 20.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.20995202901839263, 20.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 5.9534372167648799, 20.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 46.157632071206095, 20.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 494.32074431164915, 20.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 7989.5277611776519, 20.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 224179.55830753347, 20.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 13848144.485282511, 20.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 2948587692.8892150, 20.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 5940513286161.6602, 20.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 2.8531757655946394e+18, 20.000000000000000, 5.0000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler233 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=5.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 7.0000000000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.5351977183413728e-15
// mean(f - f_GSL): 0.36842306154970872
// variance(f - f_GSL): 2.5789458059294108
// stddev(f - f_GSL): 1.6059096506122039
const testcase_hyperg<double>
data234[19] =
{
  { 0.0012492049968744917, 20.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 0.0019931241968014200, 20.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 0.0033203386861410844, 20.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { 0.0058191894509856774, 20.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { 0.010830090368313864, 20.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.021653062305193541, 20.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.047180821280919195, 20.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.11405637279736212, 20.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.31275468794721017, 20.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 3.8598904658643969, 20.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 18.806301417906734, 20.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 122.77054465017432, 20.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1168.4762146809012, 20.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 18437.511788521082, 20.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 597441.79669264762, 20.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 59390411.369228527, 20.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 44681668993.361603, 20.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 4559673269683333.0, 20.000000000000000, 5.0000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler234 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=5.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 0.029296875000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.8717083246628342e-15
// mean(f - f_GSL): 0.0015419659355661440
// variance(f - f_GSL): 4.5173964710879197e-05
// stddev(f - f_GSL): 0.0067211579888348996
const testcase_hyperg<double>
data235[19] =
{
  { 0.0038867957051370739, 20.000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 0.0058484892597364235, 20.000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 0.0090987656053758189, 20.000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 0.014714392537270657, 20.000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.024900404542056772, 20.000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.044460184663785055, 20.000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.084638849196357113, 20.000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.17409058241291026, 20.000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.39357055823580767, 20.000000000000000, 5.0000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 2.9410794636226596, 20.000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 10.417226071414374, 20.000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 46.930585873140835, 20.000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 290.76717121814988, 20.000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 2788.1641083374830, 20.000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 50228.117718560752, 20.000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 2433042.3476752895, 20.000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 705345246.77141762, 20.000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 15652478868617.246, 20.000000000000000, 5.0000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler235 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=10.000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 2.5940733853654057e+18 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.8312596334404269e-15
// mean(f - f_GSL): 1.3653017829015250e+17
// variance(f - f_GSL): 4.1617051640949032e+35
// stddev(f - f_GSL): 6.4511279355589466e+17
const testcase_hyperg<double>
data236[19] =
{
  { -2.1776535312781759e-07, 20.000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { -2.9128833151630439e-06, 20.000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { -9.4755553429932710e-06, 20.000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { -1.2844297353852837e-05, 20.000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { 3.6576965483549205e-05, 20.000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 0.00020847453890703339, 20.000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { -0.00022868510398194936, 20.000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { -0.0021855513841943421, 20.000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.014662111759334568, 20.000000000000000, 10.000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 746.44776348798098, 20.000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 136080.48445225772, 20.000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 23094279.597826406, 20.000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 5315913395.5545979, 20.000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 2261935718399.9990, 20.000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 2669150854828235.0, 20.000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 1.7499363099366351e+19, 20.000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 2.8881518494606140e+24, 20.000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.4165513933662505e+33, 20.000000000000000, 10.000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler236 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=10.000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 299067162755072.00 at index 18
// max(|f - f_GSL| / |f_GSL|): 2.1129345912023457e-15
// mean(f - f_GSL): 15740377042297.895
// variance(f - f_GSL): 4.7074334083472640e+27
// stddev(f - f_GSL): 68610738287437.656
const testcase_hyperg<double>
data237[19] =
{
  { 1.7149006966334498e-07, 20.000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { 3.2399324906563845e-07, 20.000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.6015317699713284e-07, 20.000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { -2.0500917201273337e-06, 20.000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { -1.0175546788592665e-05, 20.000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { -1.1720101988188077e-05, 20.000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.00014199637113982382, 20.000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.00021263363640641769, 20.000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { -0.0072649256698439626, 20.000000000000000, 10.000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 90.430293772869618, 20.000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 6248.1455940292872, 20.000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 501143.39852548984, 20.000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 58852027.356440276, 20.000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 12942923093.333330, 20.000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 7618073993853.6592, 20.000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 22630251562549772., 20.000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.3708372433980356e+21, 20.000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.4154113620000448e+29, 20.000000000000000, 10.000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler237 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=10.000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 103079215104.00000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.8869870511941024e-15
// mean(f - f_GSL): 5425221928.4235201
// variance(f - f_GSL): 5.5922760890380314e+20
// stddev(f - f_GSL): 23647993760.651306
const testcase_hyperg<double>
data238[19] =
{
  { -1.6667473284194196e-08, 20.000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { 8.6214843496406671e-08, 20.000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { 5.7778331275185146e-07, 20.000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { 2.1911400502042259e-06, 20.000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 4.7440049217199358e-06, 20.000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { -1.0564233314712615e-05, 20.000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { -0.00017990026051847404, 20.000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { -0.00027618146288724629, 20.000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.030606019577723666, 20.000000000000000, 10.000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 27.832854169493341, 20.000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 874.00624088575910, 20.000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 36049.199340831554, 20.000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 2270967.7298625209, 20.000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 266979100.44444439, 20.000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 80311224337.493027, 20.000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 110111693103801.77, 20.000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 2.4838871426052618e+18, 20.000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 5.4626350000001618e+25, 20.000000000000000, 10.000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler238 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=10.000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 100663296.00000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.9414329026036117e-15
// mean(f - f_GSL): 5298068.6316046715
// variance(f - f_GSL): 533321003794731.12
// stddev(f - f_GSL): 23093743.823701065
const testcase_hyperg<double>
data239[19] =
{
  { -1.5843795889906876e-07, 20.000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { -5.4877276002864784e-07, 20.000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { -1.7169507967699695e-06, 20.000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { -4.5236439749819329e-06, 20.000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { -5.5690492560381956e-06, 20.000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 5.6914115606653561e-05, 20.000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 0.00082507252097489250, 20.000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.0085739249288230429, 20.000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.088244357683754687, 20.000000000000000, 10.000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 13.387208440156897, 20.000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 226.77895441155252, 20.000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 5281.5716482686785, 20.000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 189431.77762850633, 20.000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 12408149.333333332, 20.000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1966782292.5839682, 20.000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 1274123112205.7700, 20.000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 10903676350911508., 20.000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 5.1850000000001411e+22, 20.000000000000000, 10.000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler239 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=10.000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 475136.00000000000 at index 18
// max(|f - f_GSL| / |f_GSL|): 5.4067200000000052e-15
// mean(f - f_GSL): 25007.185032091642
// variance(f - f_GSL): 11881799540.814577
// stddev(f - f_GSL): 109003.66755671379
const testcase_hyperg<double>
data240[19] =
{
  { 2.6602838683283435e-06, 20.000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { 7.8442223930072316e-06, 20.000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 2.4604898194634598e-05, 20.000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 8.2718061255302686e-05, 20.000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 0.00030072865982171723, 20.000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { 0.0011951964277455204, 20.000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { 0.0052617832469731996, 20.000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.026084053304588850, 20.000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.14864362802414346, 20.000000000000000, 10.000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 8.2252633399699757, 20.000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 86.736173798840738, 20.000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 1253.2542894196868, 20.000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 27351.112277912678, 20.000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 1048576.0000000000, 20.000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 90949470.177293226, 20.000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 28679719907.924767, 20.000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 95367431640624.906, 20.000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.0000000000000220e+20, 20.000000000000000, 10.000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler240 = 5.0000000000000039e-13;

// Test data for a=20.000000000000000, b=20.000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 8.1129638414606682e+31 at index 18
// max(|f - f_GSL| / |f_GSL|): 2.1657042453579367e-15
// mean(f - f_GSL): 4.2699809691927378e+30
// variance(f - f_GSL): 3.3808552803188121e+96
// stddev(f - f_GSL): 1.8387102219541860e+48
const testcase_hyperg<double>
data241[19] =
{
  { 7.4612991227725660e-09, 20.000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.90000000000000002, 0.0 },
  { 1.1006588952366092e-07, 20.000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.80000000000000004, 0.0 },
  { 2.0126933732744113e-07, 20.000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.69999999999999996, 0.0 },
  { -1.0013775379571396e-06, 20.000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.59999999999999998, 0.0 },
  { -3.0371956856925611e-06, 20.000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.50000000000000000, 0.0 },
  { 2.2012669924829930e-05, 20.000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.39999999999999991, 0.0 },
  { -6.2415598025411788e-05, 20.000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.29999999999999993, 0.0 },
  { 0.00033551320394368590, 20.000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.19999999999999996, 0.0 },
  { -0.0062342152641436752, 20.000000000000000, 20.000000000000000, 
	  2.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.0000000000000000, 0.0 },
  { 34830.688900741610, 20.000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.10000000000000009, 0.0 },
  { 67626221.263031960, 20.000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.20000000000000018, 0.0 },
  { 102764604848.69762, 20.000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.30000000000000004, 0.0 },
  { 220278355222376.97, 20.000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.40000000000000013, 0.0 },
  { 1.0422324699794536e+18, 20.000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.9128731788368004e+22, 20.000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.60000000000000009, 0.0 },
  { 3.5234592919486348e+27, 20.000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.70000000000000018, 0.0 },
  { 5.0867023209025249e+34, 20.000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.80000000000000004, 0.0 },
  { 3.7461088506661713e+46, 20.000000000000000, 20.000000000000000, 
	  2.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler241 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=20.000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 4.3327901374988310e+27 at index 18
// max(|f - f_GSL| / |f_GSL|): 2.2075464057599215e-15
// mean(f - f_GSL): 2.2804158618486009e+26
// variance(f - f_GSL): 1.7798116217456159e+67
// stddev(f - f_GSL): 4.2187813663967183e+33
const testcase_hyperg<double>
data242[19] =
{
  { -1.5895901122487120e-09, 20.000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.90000000000000002, 0.0 },
  { -2.4403576191590296e-09, 20.000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.80000000000000004, 0.0 },
  { 1.1622915284663225e-08, 20.000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.69999999999999996, 0.0 },
  { 6.3899796223275262e-08, 20.000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.59999999999999998, 0.0 },
  { -1.3503608350984134e-07, 20.000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.50000000000000000, 0.0 },
  { -1.2198533624395468e-06, 20.000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.39999999999999991, 0.0 },
  { 9.9086618121819025e-06, 20.000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.29999999999999993, 0.0 },
  { -7.6797020080190715e-05, 20.000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.0013196405087170897, 20.000000000000000, 20.000000000000000, 
	  4.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.0000000000000000, 0.0 },
  { 2274.2044768143564, 20.000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.10000000000000009, 0.0 },
  { 1611640.1560475677, 20.000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.20000000000000018, 0.0 },
  { 1147063984.7359734, 20.000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.30000000000000004, 0.0 },
  { 1253162497163.8503, 20.000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.40000000000000013, 0.0 },
  { 3071321673390476.0, 20.000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.50000000000000000, 0.0 },
  { 2.8221123559124324e+19, 20.000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.60000000000000009, 0.0 },
  { 2.3658463807420230e+24, 20.000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.2596553731345468e+31, 20.000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.9627175792063675e+42, 20.000000000000000, 20.000000000000000, 
	  4.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler242 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=20.000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 7.5557863725914323e+23 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.9837376456389093e-15
// mean(f - f_GSL): 3.9767296698428338e+22
// variance(f - f_GSL): 4.6773832769218855e+49
// stddev(f - f_GSL): 6.8391397682178457e+24
const testcase_hyperg<double>
data243[19] =
{
  { 8.0159783892777232e-11, 20.000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.90000000000000002, 0.0 },
  { -6.4422705184649393e-10, 20.000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.80000000000000004, 0.0 },
  { -3.7526132950808576e-09, 20.000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.69999999999999996, 0.0 },
  { -1.7692034036274638e-09, 20.000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.59999999999999998, 0.0 },
  { 7.9304558764774354e-08, 20.000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.50000000000000000, 0.0 },
  { 5.9348070417710214e-08, 20.000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.39999999999999991, 0.0 },
  { -3.5827694518623355e-06, 20.000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.29999999999999993, 0.0 },
  { 4.4951490418031519e-05, 20.000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.19999999999999996, 0.0 },
  { -0.0013716249406309328, 20.000000000000000, 20.000000000000000, 
	  6.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.0000000000000000, 0.0 },
  { 415.32493304415505, 20.000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.10000000000000009, 0.0 },
  { 121300.42991518755, 20.000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.20000000000000018, 0.0 },
  { 42725673.833462097, 20.000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.30000000000000004, 0.0 },
  { 24588915328.262096, 20.000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.40000000000000013, 0.0 },
  { 31929082412503.652, 20.000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.50000000000000000, 0.0 },
  { 1.4934954443280477e+17, 20.000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.60000000000000009, 0.0 },
  { 5.7726220597697614e+21, 20.000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.70000000000000018, 0.0 },
  { 1.1454387824049374e+28, 20.000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.80000000000000004, 0.0 },
  { 3.8088637321584496e+38, 20.000000000000000, 20.000000000000000, 
	  6.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler243 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=20.000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 3.3204139332677193e+20 at index 18
// max(|f - f_GSL| / |f_GSL|): 1.9148846081414276e-15
// mean(f - f_GSL): 1.7475862807802462e+19
// variance(f - f_GSL): 6.4226791492038630e+39
// stddev(f - f_GSL): 8.0141619332303634e+19
const testcase_hyperg<double>
data244[19] =
{
  { 1.0699067880816065e-10, 20.000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.90000000000000002, 0.0 },
  { 5.4297771645951943e-10, 20.000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.80000000000000004, 0.0 },
  { 9.7625476382187751e-10, 20.000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.69999999999999996, 0.0 },
  { -6.7257763949908548e-09, 20.000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.59999999999999998, 0.0 },
  { -5.4634571496409877e-08, 20.000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.50000000000000000, 0.0 },
  { 1.4595644217972025e-07, 20.000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.39999999999999991, 0.0 },
  { 3.3515966496921257e-06, 20.000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.29999999999999993, 0.0 },
  { -6.5848086985738461e-05, 20.000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.19999999999999996, 0.0 },
  { 0.0034800171306214847, 20.000000000000000, 20.000000000000000, 
	  8.0000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.0000000000000000, 0.0 },
  { 130.93865856750304, 20.000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.10000000000000009, 0.0 },
  { 17850.203502975721, 20.000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.20000000000000018, 0.0 },
  { 3307058.5655149994, 20.000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.30000000000000004, 0.0 },
  { 1041065396.2302928, 20.000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.40000000000000013, 0.0 },
  { 735221357488.41736, 20.000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.50000000000000000, 0.0 },
  { 1785176805049585.2, 20.000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.60000000000000009, 0.0 },
  { 3.2302829930269979e+19, 20.000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.70000000000000018, 0.0 },
  { 2.4184909805178299e+25, 20.000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.80000000000000004, 0.0 },
  { 1.7340021007795807e+35, 20.000000000000000, 20.000000000000000, 
	  8.0000000000000000, 0.90000000000000013, 0.0 },
};
const double toler244 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, b=20.000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 3.4227357168015770e+17 at index 18
// max(|f - f_GSL| / |f_GSL|): 2.2509396750113666e-15
// mean(f - f_GSL): 18014398513897048.
// variance(f - f_GSL): 6.1659968607222131e+33
// stddev(f - f_GSL): 78523861728281120.
const testcase_hyperg<double>
data245[19] =
{
  { -1.7945360901577764e-10, 20.000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.90000000000000002, 0.0 },
  { -4.4440665776938741e-10, 20.000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.80000000000000004, 0.0 },
  { 6.6171615263373664e-10, 20.000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.69999999999999996, 0.0 },
  { 1.5453889374050929e-08, 20.000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.59999999999999998, 0.0 },
  { 7.5754083909301490e-08, 20.000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.50000000000000000, 0.0 },
  { -4.1113628650335901e-07, 20.000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.39999999999999991, 0.0 },
  { -9.5300704263777713e-06, 20.000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.29999999999999993, 0.0 },
  { 0.00016081533175773833, 20.000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.19999999999999996, 0.0 },
  { 0.017684650940379586, 20.000000000000000, 20.000000000000000, 
	  10.000000000000000, -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 20.000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.0000000000000000, 0.0 },
  { 57.562247312454403, 20.000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.10000000000000009, 0.0 },
  { 4124.4159820362947, 20.000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.20000000000000018, 0.0 },
  { 428774.21436196787, 20.000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.30000000000000004, 0.0 },
  { 76996819.900893494, 20.000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.40000000000000013, 0.0 },
  { 30473174828.943691, 20.000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.50000000000000000, 0.0 },
  { 39291970835753.094, 20.000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.60000000000000009, 0.0 },
  { 3.3890331048069786e+17, 20.000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.70000000000000018, 0.0 },
  { 9.7157373454594049e+22, 20.000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.80000000000000004, 0.0 },
  { 1.5205808288861820e+32, 20.000000000000000, 20.000000000000000, 
	  10.000000000000000, 0.90000000000000013, 0.0 },
};
const double toler245 = 2.5000000000000020e-13;

template<typename Ret, unsigned int Num>
  void
  test(const testcase_hyperg<Ret> (&data)[Num], Ret toler)
  {
    bool test __attribute__((unused)) = true;
    const Ret eps = std::numeric_limits<Ret>::epsilon();
    Ret max_abs_diff = -Ret(1);
    Ret max_abs_frac = -Ret(1);
    unsigned int num_datum = Num;
    for (unsigned int i = 0; i < num_datum; ++i)
      {
	const Ret f = std::tr1::hyperg(data[i].a, data[i].b,
		     data[i].c, data[i].x);
	const Ret f0 = data[i].f0;
	const Ret diff = f - f0;
	if (std::abs(diff) > max_abs_diff)
	  max_abs_diff = std::abs(diff);
	if (std::abs(f0) > Ret(10) * eps
	 && std::abs(f) > Ret(10) * eps)
	  {
	    const Ret frac = diff / f0;
	    if (std::abs(frac) > max_abs_frac)
	      max_abs_frac = std::abs(frac);
	  }
      }
    VERIFY(max_abs_frac < toler);
  }

int
main()
{
  test(data001, toler001);
  test(data002, toler002);
  test(data003, toler003);
  test(data004, toler004);
  test(data005, toler005);
  test(data006, toler006);
  test(data007, toler007);
  test(data008, toler008);
  test(data009, toler009);
  test(data010, toler010);
  test(data011, toler011);
  test(data012, toler012);
  test(data013, toler013);
  test(data014, toler014);
  test(data015, toler015);
  test(data016, toler016);
  test(data017, toler017);
  test(data018, toler018);
  test(data019, toler019);
  test(data020, toler020);
  test(data021, toler021);
  test(data022, toler022);
  test(data023, toler023);
  test(data024, toler024);
  test(data025, toler025);
  test(data026, toler026);
  test(data027, toler027);
  test(data028, toler028);
  test(data029, toler029);
  test(data030, toler030);
  test(data031, toler031);
  test(data032, toler032);
  test(data033, toler033);
  test(data034, toler034);
  test(data035, toler035);
  test(data036, toler036);
  test(data037, toler037);
  test(data038, toler038);
  test(data039, toler039);
  test(data040, toler040);
  test(data041, toler041);
  test(data042, toler042);
  test(data043, toler043);
  test(data044, toler044);
  test(data045, toler045);
  test(data046, toler046);
  test(data047, toler047);
  test(data048, toler048);
  test(data049, toler049);
  test(data050, toler050);
  test(data051, toler051);
  test(data052, toler052);
  test(data053, toler053);
  test(data054, toler054);
  test(data055, toler055);
  test(data056, toler056);
  test(data057, toler057);
  test(data058, toler058);
  test(data059, toler059);
  test(data060, toler060);
  test(data061, toler061);
  test(data062, toler062);
  test(data063, toler063);
  test(data064, toler064);
  test(data065, toler065);
  test(data066, toler066);
  test(data067, toler067);
  test(data068, toler068);
  test(data069, toler069);
  test(data070, toler070);
  test(data071, toler071);
  test(data072, toler072);
  test(data073, toler073);
  test(data074, toler074);
  test(data075, toler075);
  test(data076, toler076);
  test(data077, toler077);
  test(data078, toler078);
  test(data079, toler079);
  test(data080, toler080);
  test(data081, toler081);
  test(data082, toler082);
  test(data083, toler083);
  test(data084, toler084);
  test(data085, toler085);
  test(data086, toler086);
  test(data087, toler087);
  test(data088, toler088);
  test(data089, toler089);
  test(data090, toler090);
  test(data091, toler091);
  test(data092, toler092);
  test(data093, toler093);
  test(data094, toler094);
  test(data095, toler095);
  test(data096, toler096);
  test(data097, toler097);
  test(data098, toler098);
  test(data099, toler099);
  test(data100, toler100);
  test(data101, toler101);
  test(data102, toler102);
  test(data103, toler103);
  test(data104, toler104);
  test(data105, toler105);
  test(data106, toler106);
  test(data107, toler107);
  test(data108, toler108);
  test(data109, toler109);
  test(data110, toler110);
  test(data111, toler111);
  test(data112, toler112);
  test(data113, toler113);
  test(data114, toler114);
  test(data115, toler115);
  test(data116, toler116);
  test(data117, toler117);
  test(data118, toler118);
  test(data119, toler119);
  test(data120, toler120);
  test(data121, toler121);
  test(data122, toler122);
  test(data123, toler123);
  test(data124, toler124);
  test(data125, toler125);
  test(data126, toler126);
  test(data127, toler127);
  test(data128, toler128);
  test(data129, toler129);
  test(data130, toler130);
  test(data131, toler131);
  test(data132, toler132);
  test(data133, toler133);
  test(data134, toler134);
  test(data135, toler135);
  test(data136, toler136);
  test(data137, toler137);
  test(data138, toler138);
  test(data139, toler139);
  test(data140, toler140);
  test(data141, toler141);
  test(data142, toler142);
  test(data143, toler143);
  test(data144, toler144);
  test(data145, toler145);
  test(data146, toler146);
  test(data147, toler147);
  test(data148, toler148);
  test(data149, toler149);
  test(data150, toler150);
  test(data151, toler151);
  test(data152, toler152);
  test(data153, toler153);
  test(data154, toler154);
  test(data155, toler155);
  test(data156, toler156);
  test(data157, toler157);
  test(data158, toler158);
  test(data159, toler159);
  test(data160, toler160);
  test(data161, toler161);
  test(data162, toler162);
  test(data163, toler163);
  test(data164, toler164);
  test(data165, toler165);
  test(data166, toler166);
  test(data167, toler167);
  test(data168, toler168);
  test(data169, toler169);
  test(data170, toler170);
  test(data171, toler171);
  test(data172, toler172);
  test(data173, toler173);
  test(data174, toler174);
  test(data175, toler175);
  test(data176, toler176);
  test(data177, toler177);
  test(data178, toler178);
  test(data179, toler179);
  test(data180, toler180);
  test(data181, toler181);
  test(data182, toler182);
  test(data183, toler183);
  test(data184, toler184);
  test(data185, toler185);
  test(data186, toler186);
  test(data187, toler187);
  test(data188, toler188);
  test(data189, toler189);
  test(data190, toler190);
  test(data191, toler191);
  test(data192, toler192);
  test(data193, toler193);
  test(data194, toler194);
  test(data195, toler195);
  test(data196, toler196);
  test(data197, toler197);
  test(data198, toler198);
  test(data199, toler199);
  test(data200, toler200);
  test(data201, toler201);
  test(data202, toler202);
  test(data203, toler203);
  test(data204, toler204);
  test(data205, toler205);
  test(data206, toler206);
  test(data207, toler207);
  test(data208, toler208);
  test(data209, toler209);
  test(data210, toler210);
  test(data211, toler211);
  test(data212, toler212);
  test(data213, toler213);
  test(data214, toler214);
  test(data215, toler215);
  test(data216, toler216);
  test(data217, toler217);
  test(data218, toler218);
  test(data219, toler219);
  test(data220, toler220);
  test(data221, toler221);
  test(data222, toler222);
  test(data223, toler223);
  test(data224, toler224);
  test(data225, toler225);
  test(data226, toler226);
  test(data227, toler227);
  test(data228, toler228);
  test(data229, toler229);
  test(data230, toler230);
  test(data231, toler231);
  test(data232, toler232);
  test(data233, toler233);
  test(data234, toler234);
  test(data235, toler235);
  test(data236, toler236);
  test(data237, toler237);
  test(data238, toler238);
  test(data239, toler239);
  test(data240, toler240);
  test(data241, toler241);
  test(data242, toler242);
  test(data243, toler243);
  test(data244, toler244);
  test(data245, toler245);
  return 0;
}
