-----------------------------------------------------------------------------------
-- * Libs
-----------------------------------------------------------------------------------
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;

LIBRARY STD;
USE     STD.TEXTIO.ALL;
USE     STD.ENV.FINISH; -- use of vhdl-2008

-----------------------------------------------------------------------------------
-- * Entity
-----------------------------------------------------------------------------------
ENTITY i2c_tb IS
END i2c_tb;

-----------------------------------------------------------------------------------
-- * Architecture Begins
-----------------------------------------------------------------------------------
ARCHITECTURE str_tb OF i2c_tb IS
  -----------------------------------------------------------------------------------
  -- * Constants
  -----------------------------------------------------------------------------------
  constant C_CLK_PERIOD  : time := 20 ns; -- 50 Mhz

  constant C_A  : unsigned := to_unsigned(16#00#, 16); -- R/W
  constant C_B  : unsigned := to_unsigned(16#04#, 16); -- RO

  type regMap_tarr is array (natural range <>) of unsigned;
  constant C_REGISTERMAP : regMap_tarr := (
    0=>C_A,
    1=>C_B
  );

 -----------------------------------------------------------------------------------
  -- * Types
  -----------------------------------------------------------------------------------

  -----------------------------------------------------------------------------------
  -- * File
  -----------------------------------------------------------------------------------
  file fd_log : text;
  
  -----------------------------------------------------------------------------------
  -- * Components Declaration
  -----------------------------------------------------------------------------------

  -----------------------------------------------------------------------------------
  -- * Signals
  -----------------------------------------------------------------------------------
    -- ** Structure  (Interconnections)
    -----------------------------------------------------------------------------------

    -- ** Stimulus/Testbench Logic
    -----------------------------------------------------------------------------------
    signal s_clk          : std_logic := '1';
    signal s_rstn         : std_logic := '0';

  -----------------------------------------------------------------------------------
  -- * Procedures
  -----------------------------------------------------------------------------------

  -----------------------------------------------------------------------------------
  -- * Architecture Structure Testbench
  -----------------------------------------------------------------------------------
BEGIN
  -----------------------------------------------------------------------------------
  -- * Clock and Reset generation
  -----------------------------------------------------------------------------------
  clk_gen:
    s_clk <= not s_clk after C_CLK_PERIOD/2;

  rst_gen :
      s_rstn <=
      '1' after (1 us);

  -----------------------------------------------------------------------------------
  -- * Process
  -----------------------------------------------------------------------------------
    -- ** Stimulus
    -----------------------------------------------------------------------------------
    stimulus: process
    -- + Variables
    -- + Process begin
    begin

      wait until s_rstn='1';
      write(output, LF & " ===========================================" & LF
                       & " +--      Starting  Test      --+" & LF
                       & " ===========================================" & LF & LF);

      --=================================================================================

      wait until rising_edge(s_clk);  
       
      --=================================================================================
      
      write(output, LF & " +--  Test has finished sucessfully!!" & LF);
      write(output, LF & " ===========================================" & LF
                       & " +--      Starting  Test      --+" & LF
                       & " ===========================================" & LF & LF);
      finish;
    end process;

  -----------------------------------------------------------------------------------
  -- * Components Instatiation
  -----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- * Architecture Ends
-----------------------------------------------------------------------------------
END str_tb;
