//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcustomerlockbox

import (
	"encoding/json"
	"fmt"
)

// UnmarshalJSON implements the json.Unmarshaller interface for type LockboxRequestResponseProperties.
func (l *LockboxRequestResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessLevel":
			err = unpopulate(val, "AccessLevel", &l.AccessLevel)
			delete(rawMsg, key)
		case "createdDateTime":
			err = unpopulateTimeRFC3339(val, "CreatedDateTime", &l.CreatedDateTime)
			delete(rawMsg, key)
		case "duration":
			err = unpopulate(val, "Duration", &l.Duration)
			delete(rawMsg, key)
		case "expirationDateTime":
			err = unpopulateTimeRFC3339(val, "ExpirationDateTime", &l.ExpirationDateTime)
			delete(rawMsg, key)
		case "justification":
			err = unpopulate(val, "Justification", &l.Justification)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &l.RequestID)
			delete(rawMsg, key)
		case "resourceIds":
			err = unpopulate(val, "ResourceIDs", &l.ResourceIDs)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &l.ResourceType)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &l.Status)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &l.SubscriptionID)
			delete(rawMsg, key)
		case "supportCaseUrl":
			err = unpopulate(val, "SupportCaseURL", &l.SupportCaseURL)
			delete(rawMsg, key)
		case "supportRequest":
			err = unpopulate(val, "SupportRequest", &l.SupportRequest)
			delete(rawMsg, key)
		case "workitemsource":
			err = unpopulate(val, "Workitemsource", &l.Workitemsource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
