---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Use of GET request method with sensitive query strings (password)

## Description

The user's password was identified in the request URL. Passwords should never be sent in GET
requests as they maybe captured by proxy systems, stored in browser history, or stored in
log files. If an attacker were to get access to these logs or logging systems, they would
be able to gain access to the target account.

## Remediation

Passwords should never be sent in GET requests. When authenticating users or requesting users
reset their passwords, always use `POST` requests to transmit sensitive data.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 598.2 | true | 598 | Passive | Medium |

## Links

- [OWASP](https://owasp.org/www-community/vulnerabilities/Information_exposure_through_query_strings_in_url)
- [CWE](https://cwe.mitre.org/data/definitions/598.html)
