// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets the subscription target in Amazon DataZone.
func (c *Client) GetSubscriptionTarget(ctx context.Context, params *GetSubscriptionTargetInput, optFns ...func(*Options)) (*GetSubscriptionTargetOutput, error) {
	if params == nil {
		params = &GetSubscriptionTargetInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetSubscriptionTarget", params, optFns, c.addOperationGetSubscriptionTargetMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetSubscriptionTargetOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetSubscriptionTargetInput struct {

	// The ID of the Amazon DataZone domain in which the subscription target exists.
	//
	// This member is required.
	DomainIdentifier *string

	// The ID of the environment associated with the subscription target.
	//
	// This member is required.
	EnvironmentIdentifier *string

	// The ID of the subscription target.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

type GetSubscriptionTargetOutput struct {

	// The asset types associated with the subscription target.
	//
	// This member is required.
	ApplicableAssetTypes []string

	// The authorized principals of the subscription target.
	//
	// This member is required.
	AuthorizedPrincipals []string

	// The timestamp of when the subscription target was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon DataZone user who created the subscription target.
	//
	// This member is required.
	CreatedBy *string

	// The ID of the Amazon DataZone domain in which the subscription target exists.
	//
	// This member is required.
	DomainId *string

	// The ID of the environment associated with the subscription target.
	//
	// This member is required.
	EnvironmentId *string

	// The ID of the subscription target.
	//
	// This member is required.
	Id *string

	// The manage access role with which the subscription target was created.
	//
	// This member is required.
	ManageAccessRole *string

	// The name of the subscription target.
	//
	// This member is required.
	Name *string

	// The ID of the project associated with the subscription target.
	//
	// This member is required.
	ProjectId *string

	// The provider of the subscription target.
	//
	// This member is required.
	Provider *string

	// The configuration of teh subscription target.
	//
	// This member is required.
	SubscriptionTargetConfig []types.SubscriptionTargetForm

	// The type of the subscription target.
	//
	// This member is required.
	Type *string

	// The timestamp of when the subscription target was updated.
	UpdatedAt *time.Time

	// The Amazon DataZone user who updated the subscription target.
	UpdatedBy *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetSubscriptionTargetMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetSubscriptionTarget{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetSubscriptionTarget{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetSubscriptionTarget"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetSubscriptionTargetValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetSubscriptionTarget(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetSubscriptionTarget(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetSubscriptionTarget",
	}
}
