// DO NOT EDIT. This file was autogenerated by make.go.

// Copyright ©2013 The bíogo Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Package matrix provides a variety of alignment scoring matrices for sequence alignment.
package matrix

// All alignment scoring matrices are organised to allow direct lookup using alphabets
// defined in biogo/alphabet. Gap penalties are set to zero for all matrices and the I/L
// single letter amino acid code, "J", is included but not defined for all the protein
// scoring matrices.
var (
	// #
	// # This matrix was created by Todd Lowe   12/10/92
	// #
	// # Probabilities rounded to nearest integer
	// #
	// # Lowest score = -4, Highest score = 5
	// #
	//     A   T   G   C
	// A   5  -4  -4  -4
	// T  -4   5  -4  -4
	// G  -4  -4   5  -4
	// C  -4  -4  -4   5
	//
	NUC_4 = [][]int{
		/*       - A C G T */
		/* - */ {0, 0, 0, 0, 0},
		/* A */ {0, 5, -4, -4, -4},
		/* C */ {0, -4, 5, -4, -4},
		/* G */ {0, -4, -4, 5, -4},
		/* T */ {0, -4, -4, -4, 5},
	}

	// #
	// # This matrix was created by Todd Lowe   12/10/92
	// #
	// # Uses ambiguous nucleotide codes, probabilities rounded to
	// #  nearest integer
	// #
	// # Lowest score = -4, Highest score = 5
	// #
	//     A   T   G   C   S   W   R   Y   K   M   B   V   H   D   N
	// A   5  -4  -4  -4  -4   1   1  -4  -4   1  -4  -1  -1  -1  -2
	// T  -4   5  -4  -4  -4   1  -4   1   1  -4  -1  -4  -1  -1  -2
	// G  -4  -4   5  -4   1  -4   1  -4   1  -4  -1  -1  -4  -1  -2
	// C  -4  -4  -4   5   1  -4  -4   1  -4   1  -1  -1  -1  -4  -2
	// S  -4  -4   1   1  -1  -4  -2  -2  -2  -2  -1  -1  -3  -3  -1
	// W   1   1  -4  -4  -4  -1  -2  -2  -2  -2  -3  -3  -1  -1  -1
	// R   1  -4   1  -4  -2  -2  -1  -4  -2  -2  -3  -1  -3  -1  -1
	// Y  -4   1  -4   1  -2  -2  -4  -1  -2  -2  -1  -3  -1  -3  -1
	// K  -4   1   1  -4  -2  -2  -2  -2  -1  -4  -1  -3  -3  -1  -1
	// M   1  -4  -4   1  -2  -2  -2  -2  -4  -1  -3  -1  -1  -3  -1
	// B  -4  -1  -1  -1  -1  -3  -3  -1  -1  -3  -1  -2  -2  -2  -1
	// V  -1  -4  -1  -1  -1  -3  -1  -3  -3  -1  -2  -1  -2  -2  -1
	// H  -1  -1  -4  -1  -3  -1  -3  -1  -3  -1  -2  -2  -1  -2  -1
	// D  -1  -1  -1  -4  -3  -1  -1  -3  -1  -3  -2  -2  -2  -1  -1
	// N  -2  -2  -2  -2  -1  -1  -1  -1  -1  -1  -1  -1  -1  -1  -1
	//
	NUC_4_4 = [][]int{
		/*       - A C M G R S V T W Y H K D B N */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 5, -4, 1, -4, 1, -4, -1, -4, 1, -4, -1, -4, -1, -4, -2},
		/* C */ {0, -4, 5, 1, -4, -4, 1, -1, -4, -4, 1, -1, -4, -4, -1, -2},
		/* M */ {0, 1, 1, -1, -4, -2, -2, -1, -4, -2, -2, -1, -4, -3, -3, -1},
		/* G */ {0, -4, -4, -4, 5, 1, 1, -1, -4, -4, -4, -4, 1, -1, -1, -2},
		/* R */ {0, 1, -4, -2, 1, -1, -2, -1, -4, -2, -4, -3, -2, -1, -3, -1},
		/* S */ {0, -4, 1, -2, 1, -2, -1, -1, -4, -4, -2, -3, -2, -3, -1, -1},
		/* V */ {0, -1, -1, -1, -1, -1, -1, -1, -4, -3, -3, -2, -3, -2, -2, -1},
		/* T */ {0, -4, -4, -4, -4, -4, -4, -4, 5, 1, 1, -1, 1, -1, -1, -2},
		/* W */ {0, 1, -4, -2, -4, -2, -4, -3, 1, -1, -2, -1, -2, -1, -3, -1},
		/* Y */ {0, -4, 1, -2, -4, -4, -2, -3, 1, -2, -1, -1, -2, -3, -1, -1},
		/* H */ {0, -1, -1, -1, -4, -3, -3, -2, -1, -1, -1, -1, -3, -2, -2, -1},
		/* K */ {0, -4, -4, -4, 1, -2, -2, -3, 1, -2, -2, -3, -1, -1, -1, -1},
		/* D */ {0, -1, -4, -3, -1, -1, -3, -2, -1, -1, -3, -2, -1, -1, -2, -1},
		/* B */ {0, -4, -1, -3, -1, -3, -1, -2, -1, -3, -1, -2, -1, -2, -1, -1},
		/* N */ {0, -2, -2, -1, -2, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1},
	}

	// #Date: Wed, 18 Sep 91 17:36:51 EDT
	// #From: altschul@ray.nlm.nih.gov (Stephen Altschul)
	// #To: gish@ray.nlm.nih.gov
	// #Subject: Vanilla-flavored PAM-250
	// #
	// # substitution scores for B, Z, X, and * were obtained with "pam" version 1.0.5
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  2 -2  0  0 -2  0  0  1 -1 -1 -2 -1 -1 -4  1  1  1 -6 -3  0  0  0  0 -8
	// R -2  6  0 -1 -4  1 -1 -3  2 -2 -3  3  0 -4  0  0 -1  2 -4 -2 -1  0 -1 -8
	// N  0  0  2  2 -4  1  1  0  2 -2 -3  1 -2 -4 -1  1  0 -4 -2 -2  2  1  0 -8
	// D  0 -1  2  4 -5  2  3  1  1 -2 -4  0 -3 -6 -1  0  0 -7 -4 -2  3  3 -1 -8
	// C -2 -4 -4 -5 12 -5 -5 -3 -3 -2 -6 -5 -5 -4 -3  0 -2 -8  0 -2 -4 -5 -3 -8
	// Q  0  1  1  2 -5  4  2 -1  3 -2 -2  1 -1 -5  0 -1 -1 -5 -4 -2  1  3 -1 -8
	// E  0 -1  1  3 -5  2  4  0  1 -2 -3  0 -2 -5 -1  0  0 -7 -4 -2  3  3 -1 -8
	// G  1 -3  0  1 -3 -1  0  5 -2 -3 -4 -2 -3 -5 -1  1  0 -7 -5 -1  0  0 -1 -8
	// H -1  2  2  1 -3  3  1 -2  6 -2 -2  0 -2 -2  0 -1 -1 -3  0 -2  1  2 -1 -8
	// I -1 -2 -2 -2 -2 -2 -2 -3 -2  5  2 -2  2  1 -2 -1  0 -5 -1  4 -2 -2 -1 -8
	// L -2 -3 -3 -4 -6 -2 -3 -4 -2  2  6 -3  4  2 -3 -3 -2 -2 -1  2 -3 -3 -1 -8
	// K -1  3  1  0 -5  1  0 -2  0 -2 -3  5  0 -5 -1  0  0 -3 -4 -2  1  0 -1 -8
	// M -1  0 -2 -3 -5 -1 -2 -3 -2  2  4  0  6  0 -2 -2 -1 -4 -2  2 -2 -2 -1 -8
	// F -4 -4 -4 -6 -4 -5 -5 -5 -2  1  2 -5  0  9 -5 -3 -3  0  7 -1 -4 -5 -2 -8
	// P  1  0 -1 -1 -3  0 -1 -1  0 -2 -3 -1 -2 -5  6  1  0 -6 -5 -1 -1  0 -1 -8
	// S  1  0  1  0  0 -1  0  1 -1 -1 -3  0 -2 -3  1  2  1 -2 -3 -1  0  0  0 -8
	// T  1 -1  0  0 -2 -1  0  0 -1  0 -2  0 -1 -3  0  1  3 -5 -3  0  0 -1  0 -8
	// W -6  2 -4 -7 -8 -5 -7 -7 -3 -5 -2 -3 -4  0 -6 -2 -5 17  0 -6 -5 -6 -4 -8
	// Y -3 -4 -2 -4  0 -4 -4 -5  0 -1 -1 -4 -2  7 -5 -3 -3  0 10 -2 -3 -4 -2 -8
	// V  0 -2 -2 -2 -2 -2 -2 -1 -2  4  2 -2  2 -1 -1 -1  0 -6 -2  4 -2 -2 -1 -8
	// B  0 -1  2  3 -4  1  3  0  1 -2 -3  1 -2 -4 -1  0  0 -5 -3 -2  3  2 -1 -8
	// Z  0  0  1  3 -5  3  3  0  2 -2 -3  0 -2 -5  0  0 -1 -6 -4 -2  2  3 -1 -8
	// X  0 -1  0 -1 -3 -1 -1 -1 -1 -1 -1 -1 -1 -2 -1  0  0 -4 -2 -1 -1 -1 -1 -8
	// * -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8  1
	//
	DAYHOFF = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 2, 0, -2, 0, 0, -4, 1, -1, -1, 0, -1, -2, -1, 0, 1, 0, -2, 1, 1, 0, -6, 0, -3, 0, -8},
		/* B */ {0, 0, 3, -4, 3, 3, -4, 0, 1, -2, 0, 1, -3, -2, 2, -1, 1, -1, 0, 0, -2, -5, -1, -3, 2, -8},
		/* C */ {0, -2, -4, 12, -5, -5, -4, -3, -3, -2, 0, -5, -6, -5, -4, -3, -5, -4, 0, -2, -2, -8, -3, 0, -5, -8},
		/* D */ {0, 0, 3, -5, 4, 3, -6, 1, 1, -2, 0, 0, -4, -3, 2, -1, 2, -1, 0, 0, -2, -7, -1, -4, 3, -8},
		/* E */ {0, 0, 3, -5, 3, 4, -5, 0, 1, -2, 0, 0, -3, -2, 1, -1, 2, -1, 0, 0, -2, -7, -1, -4, 3, -8},
		/* F */ {0, -4, -4, -4, -6, -5, 9, -5, -2, 1, 0, -5, 2, 0, -4, -5, -5, -4, -3, -3, -1, 0, -2, 7, -5, -8},
		/* G */ {0, 1, 0, -3, 1, 0, -5, 5, -2, -3, 0, -2, -4, -3, 0, -1, -1, -3, 1, 0, -1, -7, -1, -5, 0, -8},
		/* H */ {0, -1, 1, -3, 1, 1, -2, -2, 6, -2, 0, 0, -2, -2, 2, 0, 3, 2, -1, -1, -2, -3, -1, 0, 2, -8},
		/* I */ {0, -1, -2, -2, -2, -2, 1, -3, -2, 5, 0, -2, 2, 2, -2, -2, -2, -2, -1, 0, 4, -5, -1, -1, -2, -8},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 1, -5, 0, 0, -5, -2, 0, -2, 0, 5, -3, 0, 1, -1, 1, 3, 0, 0, -2, -3, -1, -4, 0, -8},
		/* L */ {0, -2, -3, -6, -4, -3, 2, -4, -2, 2, 0, -3, 6, 4, -3, -3, -2, -3, -3, -2, 2, -2, -1, -1, -3, -8},
		/* M */ {0, -1, -2, -5, -3, -2, 0, -3, -2, 2, 0, 0, 4, 6, -2, -2, -1, 0, -2, -1, 2, -4, -1, -2, -2, -8},
		/* N */ {0, 0, 2, -4, 2, 1, -4, 0, 2, -2, 0, 1, -3, -2, 2, -1, 1, 0, 1, 0, -2, -4, 0, -2, 1, -8},
		/* P */ {0, 1, -1, -3, -1, -1, -5, -1, 0, -2, 0, -1, -3, -2, -1, 6, 0, 0, 1, 0, -1, -6, -1, -5, 0, -8},
		/* Q */ {0, 0, 1, -5, 2, 2, -5, -1, 3, -2, 0, 1, -2, -1, 1, 0, 4, 1, -1, -1, -2, -5, -1, -4, 3, -8},
		/* R */ {0, -2, -1, -4, -1, -1, -4, -3, 2, -2, 0, 3, -3, 0, 0, 0, 1, 6, 0, -1, -2, 2, -1, -4, 0, -8},
		/* S */ {0, 1, 0, 0, 0, 0, -3, 1, -1, -1, 0, 0, -3, -2, 1, 1, -1, 0, 2, 1, -1, -2, 0, -3, 0, -8},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 0, -1, 0, 0, 0, -2, -1, 0, 0, -1, -1, 1, 3, 0, -5, 0, -3, -1, -8},
		/* V */ {0, 0, -2, -2, -2, -2, -1, -1, -2, 4, 0, -2, 2, 2, -2, -1, -2, -2, -1, 0, 4, -6, -1, -2, -2, -8},
		/* W */ {0, -6, -5, -8, -7, -7, 0, -7, -3, -5, 0, -3, -2, -4, -4, -6, -5, 2, -2, -5, -6, 17, -4, 0, -6, -8},
		/* X */ {0, 0, -1, -3, -1, -1, -2, -1, -1, -1, 0, -1, -1, -1, 0, -1, -1, -1, 0, 0, -1, -4, -1, -2, -1, -8},
		/* Y */ {0, -3, -3, 0, -4, -4, 7, -5, 0, -1, 0, -4, -1, -2, -2, -5, -4, -4, -3, -3, -2, 0, -2, 10, -4, -8},
		/* Z */ {0, 0, 2, -5, 3, 3, -5, 0, 2, -2, 0, 0, -3, -2, 1, 0, 3, 0, 0, -1, -2, -6, -1, -4, 3, -8},
		/* * */ {0, -8, -8, -8, -8, -8, -8, -8, -8, -8, 0, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, 1},
	}

	// # PAM 250 matrix recommended by Gonnet, Cohen & Benner
	// # Science June 5, 1992.
	// # Values rounded to nearest integer
	//    C  S  T  P  A  G  N  D  E  Q  H  R  K  M  I  L  V  F  Y  W  X  *
	// C 12  0  0 -3  0 -2 -2 -3 -3 -2 -1 -2 -3 -1 -1 -2  0 -1  0 -1 -3 -8
	// S  0  2  2  0  1  0  1  0  0  0  0  0  0 -1 -2 -2 -1 -3 -2 -3  0 -8
	// T  0  2  2  0  1 -1  0  0  0  0  0  0  0 -1 -1 -1  0 -2 -2 -4  0 -8
	// P -3  0  0  8  0 -2 -1 -1  0  0 -1 -1 -1 -2 -3 -2 -2 -4 -3 -5 -1 -8
	// A  0  1  1  0  2  0  0  0  0  0 -1 -1  0 -1 -1 -1  0 -2 -2 -4  0 -8
	// G -2  0 -1 -2  0  7  0  0 -1 -1 -1 -1 -1 -4 -4 -4 -3 -5 -4 -4 -1 -8
	// N -2  1  0 -1  0  0  4  2  1  1  1  0  1 -2 -3 -3 -2 -3 -1 -4  0 -8
	// D -3  0  0 -1  0  0  2  5  3  1  0  0  0 -3 -4 -4 -3 -4 -3 -5 -1 -8
	// E -3  0  0  0  0 -1  1  3  4  2  0  0  1 -2 -3 -3 -2 -4 -3 -4 -1 -8
	// Q -2  0  0  0  0 -1  1  1  2  3  1  2  2 -1 -2 -2 -2 -3 -2 -3 -1 -8
	// H -1  0  0 -1 -1 -1  1  0  0  1  6  1  1 -1 -2 -2 -2  0  2 -1 -1 -8
	// R -2  0  0 -1 -1 -1  0  0  0  2  1  5  3 -2 -2 -2 -2 -3 -2 -2 -1 -8
	// K -3  0  0 -1  0 -1  1  0  1  2  1  3  3 -1 -2 -2 -2 -3 -2 -4 -1 -8
	// M -1 -1 -1 -2 -1 -4 -2 -3 -2 -1 -1 -2 -1  4  2  3  2  2  0 -1 -1 -8
	// I -1 -2 -1 -3 -1 -4 -3 -4 -3 -2 -2 -2 -2  2  4  3  3  1 -1 -2 -1 -8
	// L -2 -2 -1 -2 -1 -4 -3 -4 -3 -2 -2 -2 -2  3  3  4  2  2  0 -1 -1 -8
	// V  0 -1  0 -2  0 -3 -2 -3 -2 -2 -2 -2 -2  2  3  2  3  0 -1 -3 -1 -8
	// F -1 -3 -2 -4 -2 -5 -3 -4 -4 -3  0 -3 -3  2  1  2  0  7  5  4 -2 -8
	// Y  0 -2 -2 -3 -2 -4 -1 -3 -3 -2  2 -2 -2  0 -1  0 -1  5  8  4 -2 -8
	// W -1 -3 -4 -5 -4 -4 -4 -5 -4 -3 -1 -2 -4 -1 -2 -1 -3  4  4 14 -4 -8
	// X -3  0  0 -1  0 -1  0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -2 -2 -4 -1 -8
	// * -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8  1
	//
	GONNET = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 2, 0, 0, 0, 0, -2, 0, -1, -1, 0, 0, -1, -1, 0, 0, 0, -1, 1, 1, 0, -4, 0, -2, 0, -8},
		/* B */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* C */ {0, 0, 0, 12, -3, -3, -1, -2, -1, -1, 0, -3, -2, -1, -2, -3, -2, -2, 0, 0, 0, -1, -3, 0, 0, -8},
		/* D */ {0, 0, 0, -3, 5, 3, -4, 0, 0, -4, 0, 0, -4, -3, 2, -1, 1, 0, 0, 0, -3, -5, -1, -3, 0, -8},
		/* E */ {0, 0, 0, -3, 3, 4, -4, -1, 0, -3, 0, 1, -3, -2, 1, 0, 2, 0, 0, 0, -2, -4, -1, -3, 0, -8},
		/* F */ {0, -2, 0, -1, -4, -4, 7, -5, 0, 1, 0, -3, 2, 2, -3, -4, -3, -3, -3, -2, 0, 4, -2, 5, 0, -8},
		/* G */ {0, 0, 0, -2, 0, -1, -5, 7, -1, -4, 0, -1, -4, -4, 0, -2, -1, -1, 0, -1, -3, -4, -1, -4, 0, -8},
		/* H */ {0, -1, 0, -1, 0, 0, 0, -1, 6, -2, 0, 1, -2, -1, 1, -1, 1, 1, 0, 0, -2, -1, -1, 2, 0, -8},
		/* I */ {0, -1, 0, -1, -4, -3, 1, -4, -2, 4, 0, -2, 3, 2, -3, -3, -2, -2, -2, -1, 3, -2, -1, -1, 0, -8},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, 0, 0, -3, 0, 1, -3, -1, 1, -2, 0, 3, -2, -1, 1, -1, 2, 3, 0, 0, -2, -4, -1, -2, 0, -8},
		/* L */ {0, -1, 0, -2, -4, -3, 2, -4, -2, 3, 0, -2, 4, 3, -3, -2, -2, -2, -2, -1, 2, -1, -1, 0, 0, -8},
		/* M */ {0, -1, 0, -1, -3, -2, 2, -4, -1, 2, 0, -1, 3, 4, -2, -2, -1, -2, -1, -1, 2, -1, -1, 0, 0, -8},
		/* N */ {0, 0, 0, -2, 2, 1, -3, 0, 1, -3, 0, 1, -3, -2, 4, -1, 1, 0, 1, 0, -2, -4, 0, -1, 0, -8},
		/* P */ {0, 0, 0, -3, -1, 0, -4, -2, -1, -3, 0, -1, -2, -2, -1, 8, 0, -1, 0, 0, -2, -5, -1, -3, 0, -8},
		/* Q */ {0, 0, 0, -2, 1, 2, -3, -1, 1, -2, 0, 2, -2, -1, 1, 0, 3, 2, 0, 0, -2, -3, -1, -2, 0, -8},
		/* R */ {0, -1, 0, -2, 0, 0, -3, -1, 1, -2, 0, 3, -2, -2, 0, -1, 2, 5, 0, 0, -2, -2, -1, -2, 0, -8},
		/* S */ {0, 1, 0, 0, 0, 0, -3, 0, 0, -2, 0, 0, -2, -1, 1, 0, 0, 0, 2, 2, -1, -3, 0, -2, 0, -8},
		/* T */ {0, 1, 0, 0, 0, 0, -2, -1, 0, -1, 0, 0, -1, -1, 0, 0, 0, 0, 2, 2, 0, -4, 0, -2, 0, -8},
		/* V */ {0, 0, 0, 0, -3, -2, 0, -3, -2, 3, 0, -2, 2, 2, -2, -2, -2, -2, -1, 0, 3, -3, -1, -1, 0, -8},
		/* W */ {0, -4, 0, -1, -5, -4, 4, -4, -1, -2, 0, -4, -1, -1, -4, -5, -3, -2, -3, -4, -3, 14, -4, 4, 0, -8},
		/* X */ {0, 0, 0, -3, -1, -1, -2, -1, -1, -1, 0, -1, -1, -1, 0, -1, -1, -1, 0, 0, -1, -4, -1, -2, 0, -8},
		/* Y */ {0, -2, 0, 0, -3, -3, 5, -4, 2, -1, 0, -2, 0, 0, -1, -3, -2, -2, -2, -2, -1, 4, -2, 8, 0, -8},
		/* Z */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* * */ {0, -8, 0, -8, -8, -8, -8, -8, -8, -8, 0, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, 0, 1},
	}

	//   A  R  N  B  D  C  Q  Z  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  X  *
	// A  1 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000
	// R -10000  1 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000
	// N -10000 -10000  1 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000
	// B -10000 -10000 -10000  1 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000
	// D -10000 -10000 -10000 -10000  1 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000
	// C -10000 -10000 -10000 -10000 -10000  1 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000
	// Q -10000 -10000 -10000 -10000 -10000 -10000  1 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000
	// Z -10000 -10000 -10000 -10000 -10000 -10000 -10000  1 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000
	// E -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000  1 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000
	// G -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000  1 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000
	// H -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000  1 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000
	// I -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000  1 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000
	// L -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000  1 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000
	// K -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000  1 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000
	// M -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000  1 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000
	// F -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000  1 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000
	// P -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000  1 -10000 -10000 -10000 -10000 -10000 -10000 -10000
	// S -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000  1 -10000 -10000 -10000 -10000 -10000 -10000
	// T -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000  1 -10000 -10000 -10000 -10000 -10000
	// W -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000  1 -10000 -10000 -10000 -10000
	// Y -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000  1 -10000 -10000 -10000
	// V -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000  1 -10000 -10000
	// X -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000  0 -10000
	// * -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000 -10000  0
	//
	IDENTITY = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 1, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000},
		/* B */ {0, -10000, 1, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000},
		/* C */ {0, -10000, -10000, 1, -10000, -10000, -10000, -10000, -10000, -10000, 0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000},
		/* D */ {0, -10000, -10000, -10000, 1, -10000, -10000, -10000, -10000, -10000, 0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000},
		/* E */ {0, -10000, -10000, -10000, -10000, 1, -10000, -10000, -10000, -10000, 0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000},
		/* F */ {0, -10000, -10000, -10000, -10000, -10000, 1, -10000, -10000, -10000, 0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000},
		/* G */ {0, -10000, -10000, -10000, -10000, -10000, -10000, 1, -10000, -10000, 0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000},
		/* H */ {0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 1, -10000, 0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000},
		/* I */ {0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 1, 0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 0, 1, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000},
		/* L */ {0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 0, -10000, 1, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000},
		/* M */ {0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 0, -10000, -10000, 1, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000},
		/* N */ {0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 0, -10000, -10000, -10000, 1, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000},
		/* P */ {0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 0, -10000, -10000, -10000, -10000, 1, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000},
		/* Q */ {0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 0, -10000, -10000, -10000, -10000, -10000, 1, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000},
		/* R */ {0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 0, -10000, -10000, -10000, -10000, -10000, -10000, 1, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000},
		/* S */ {0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 1, -10000, -10000, -10000, -10000, -10000, -10000, -10000},
		/* T */ {0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 1, -10000, -10000, -10000, -10000, -10000, -10000},
		/* V */ {0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 1, -10000, -10000, -10000, -10000, -10000},
		/* W */ {0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 1, -10000, -10000, -10000, -10000},
		/* X */ {0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 0, -10000, -10000, -10000},
		/* Y */ {0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 1, -10000, -10000},
		/* Z */ {0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 1, -10000},
		/* * */ {0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 0, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, -10000, 0},
	}

	//    A  R  N  B  D  C  Q  Z  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  X  *
	// A  1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1
	// R -1  1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1
	// N -1 -1  1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1
	// B -1 -1 -1  1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1
	// D -1 -1 -1 -1  1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1
	// C -1 -1 -1 -1 -1  1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1
	// Q -1 -1 -1 -1 -1 -1  1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1
	// Z -1 -1 -1 -1 -1 -1 -1  1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1
	// E -1 -1 -1 -1 -1 -1 -1 -1  1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1
	// G -1 -1 -1 -1 -1 -1 -1 -1 -1  1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1
	// H -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1
	// I -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1
	// L -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1
	// K -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1
	// M -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  1 -1 -1 -1 -1 -1 -1 -1 -1 -1
	// F -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  1 -1 -1 -1 -1 -1 -1 -1 -1
	// P -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  1 -1 -1 -1 -1 -1 -1 -1
	// S -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  1 -1 -1 -1 -1 -1 -1
	// T -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  1 -1 -1 -1 -1 -1
	// W -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  1 -1 -1 -1 -1
	// Y -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  1 -1 -1 -1
	// V -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  1 -1 -1
	// X -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  0 -1
	// * -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  0
	//
	MATCH = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
		/* B */ {0, -1, 1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
		/* C */ {0, -1, -1, 1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
		/* D */ {0, -1, -1, -1, 1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
		/* E */ {0, -1, -1, -1, -1, 1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
		/* F */ {0, -1, -1, -1, -1, -1, 1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
		/* G */ {0, -1, -1, -1, -1, -1, -1, 1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
		/* H */ {0, -1, -1, -1, -1, -1, -1, -1, 1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
		/* I */ {0, -1, -1, -1, -1, -1, -1, -1, -1, 1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
		/* L */ {0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
		/* M */ {0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
		/* N */ {0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
		/* P */ {0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
		/* Q */ {0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
		/* R */ {0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, -1, -1, -1},
		/* S */ {0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, -1, -1},
		/* T */ {0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, -1},
		/* V */ {0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1},
		/* W */ {0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, -1},
		/* X */ {0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1},
		/* Y */ {0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, -1},
		/* Z */ {0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1},
		/* * */ {0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0},
	}

	// #  Matrix made by matblas from blosum100_3.iij
	// #  * column uses minimum score
	// #  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
	// #  Blocks Database = /data/blocks_5.0/blocks.dat
	// #  Cluster Percentage: >= 100
	// #  Entropy =   1.4516, Expected =  -1.0948
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  8 -3 -4 -5 -2 -2 -3 -1 -4 -4 -4 -2 -3 -5 -2  1 -1 -6 -5 -2 -4 -2 -2 -10
	// R -3 10 -2 -5 -8  0 -2 -6 -1 -7 -6  3 -4 -6 -5 -3 -3 -7 -5 -6 -4 -1 -3 -10
	// N -4 -2 11  1 -5 -1 -2 -2  0 -7 -7 -1 -5 -7 -5  0 -1 -8 -5 -7  5 -2 -3 -10
	// D -5 -5  1 10 -8 -2  2 -4 -3 -8 -8 -3 -8 -8 -5 -2 -4 -10 -7 -8  6  0 -4 -10
	// C -2 -8 -5 -8 14 -7 -9 -7 -8 -3 -5 -8 -4 -4 -8 -3 -3 -7 -6 -3 -7 -8 -5 -10
	// Q -2  0 -1 -2 -7 11  2 -5  1 -6 -5  2 -2 -6 -4 -2 -3 -5 -4 -5 -2  5 -2 -10
	// E -3 -2 -2  2 -9  2 10 -6 -2 -7 -7  0 -5 -8 -4 -2 -3 -8 -7 -5  0  7 -3 -10
	// G -1 -6 -2 -4 -7 -5 -6  9 -6 -9 -8 -5 -7 -8 -6 -2 -5 -7 -8 -8 -3 -5 -4 -10
	// H -4 -1  0 -3 -8  1 -2 -6 13 -7 -6 -3 -5 -4 -5 -3 -4 -5  1 -7 -2 -1 -4 -10
	// I -4 -7 -7 -8 -3 -6 -7 -9 -7  8  2 -6  1 -2 -7 -5 -3 -6 -4  4 -8 -7 -3 -10
	// L -4 -6 -7 -8 -5 -5 -7 -8 -6  2  8 -6  3  0 -7 -6 -4 -5 -4  0 -8 -6 -3 -10
	// K -2  3 -1 -3 -8  2  0 -5 -3 -6 -6 10 -4 -6 -3 -2 -3 -8 -5 -5 -2  0 -3 -10
	// M -3 -4 -5 -8 -4 -2 -5 -7 -5  1  3 -4 12 -1 -5 -4 -2 -4 -5  0 -7 -4 -3 -10
	// F -5 -6 -7 -8 -4 -6 -8 -8 -4 -2  0 -6 -1 11 -7 -5 -5  0  4 -3 -7 -7 -4 -10
	// P -2 -5 -5 -5 -8 -4 -4 -6 -5 -7 -7 -3 -5 -7 12 -3 -4 -8 -7 -6 -5 -4 -4 -10
	// S  1 -3  0 -2 -3 -2 -2 -2 -3 -5 -6 -2 -4 -5 -3  9  2 -7 -5 -4 -1 -2 -2 -10
	// T -1 -3 -1 -4 -3 -3 -3 -5 -4 -3 -4 -3 -2 -5 -4  2  9 -7 -5 -1 -2 -3 -2 -10
	// W -6 -7 -8 -10 -7 -5 -8 -7 -5 -6 -5 -8 -4  0 -8 -7 -7 17  2 -5 -9 -7 -6 -10
	// Y -5 -5 -5 -7 -6 -4 -7 -8  1 -4 -4 -5 -5  4 -7 -5 -5  2 12 -5 -6 -6 -4 -10
	// V -2 -6 -7 -8 -3 -5 -5 -8 -7  4  0 -5  0 -3 -6 -4 -1 -5 -5  8 -7 -5 -3 -10
	// B -4 -4  5  6 -7 -2  0 -3 -2 -8 -8 -2 -7 -7 -5 -1 -2 -9 -6 -7  6  0 -4 -10
	// Z -2 -1 -2  0 -8  5  7 -5 -1 -7 -6  0 -4 -7 -4 -2 -3 -7 -6 -5  0  6 -2 -10
	// X -2 -3 -3 -4 -5 -2 -3 -4 -4 -3 -3 -3 -3 -4 -4 -2 -2 -6 -4 -3 -4 -2 -3 -10
	// * -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10  1
	//
	BLOSUM100 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 8, -4, -2, -5, -3, -5, -1, -4, -4, 0, -2, -4, -3, -4, -2, -2, -3, 1, -1, -2, -6, -2, -5, -2, -10},
		/* B */ {0, -4, 6, -7, 6, 0, -7, -3, -2, -8, 0, -2, -8, -7, 5, -5, -2, -4, -1, -2, -7, -9, -4, -6, 0, -10},
		/* C */ {0, -2, -7, 14, -8, -9, -4, -7, -8, -3, 0, -8, -5, -4, -5, -8, -7, -8, -3, -3, -3, -7, -5, -6, -8, -10},
		/* D */ {0, -5, 6, -8, 10, 2, -8, -4, -3, -8, 0, -3, -8, -8, 1, -5, -2, -5, -2, -4, -8, -10, -4, -7, 0, -10},
		/* E */ {0, -3, 0, -9, 2, 10, -8, -6, -2, -7, 0, 0, -7, -5, -2, -4, 2, -2, -2, -3, -5, -8, -3, -7, 7, -10},
		/* F */ {0, -5, -7, -4, -8, -8, 11, -8, -4, -2, 0, -6, 0, -1, -7, -7, -6, -6, -5, -5, -3, 0, -4, 4, -7, -10},
		/* G */ {0, -1, -3, -7, -4, -6, -8, 9, -6, -9, 0, -5, -8, -7, -2, -6, -5, -6, -2, -5, -8, -7, -4, -8, -5, -10},
		/* H */ {0, -4, -2, -8, -3, -2, -4, -6, 13, -7, 0, -3, -6, -5, 0, -5, 1, -1, -3, -4, -7, -5, -4, 1, -1, -10},
		/* I */ {0, -4, -8, -3, -8, -7, -2, -9, -7, 8, 0, -6, 2, 1, -7, -7, -6, -7, -5, -3, 4, -6, -3, -4, -7, -10},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -2, -2, -8, -3, 0, -6, -5, -3, -6, 0, 10, -6, -4, -1, -3, 2, 3, -2, -3, -5, -8, -3, -5, 0, -10},
		/* L */ {0, -4, -8, -5, -8, -7, 0, -8, -6, 2, 0, -6, 8, 3, -7, -7, -5, -6, -6, -4, 0, -5, -3, -4, -6, -10},
		/* M */ {0, -3, -7, -4, -8, -5, -1, -7, -5, 1, 0, -4, 3, 12, -5, -5, -2, -4, -4, -2, 0, -4, -3, -5, -4, -10},
		/* N */ {0, -4, 5, -5, 1, -2, -7, -2, 0, -7, 0, -1, -7, -5, 11, -5, -1, -2, 0, -1, -7, -8, -3, -5, -2, -10},
		/* P */ {0, -2, -5, -8, -5, -4, -7, -6, -5, -7, 0, -3, -7, -5, -5, 12, -4, -5, -3, -4, -6, -8, -4, -7, -4, -10},
		/* Q */ {0, -2, -2, -7, -2, 2, -6, -5, 1, -6, 0, 2, -5, -2, -1, -4, 11, 0, -2, -3, -5, -5, -2, -4, 5, -10},
		/* R */ {0, -3, -4, -8, -5, -2, -6, -6, -1, -7, 0, 3, -6, -4, -2, -5, 0, 10, -3, -3, -6, -7, -3, -5, -1, -10},
		/* S */ {0, 1, -1, -3, -2, -2, -5, -2, -3, -5, 0, -2, -6, -4, 0, -3, -2, -3, 9, 2, -4, -7, -2, -5, -2, -10},
		/* T */ {0, -1, -2, -3, -4, -3, -5, -5, -4, -3, 0, -3, -4, -2, -1, -4, -3, -3, 2, 9, -1, -7, -2, -5, -3, -10},
		/* V */ {0, -2, -7, -3, -8, -5, -3, -8, -7, 4, 0, -5, 0, 0, -7, -6, -5, -6, -4, -1, 8, -5, -3, -5, -5, -10},
		/* W */ {0, -6, -9, -7, -10, -8, 0, -7, -5, -6, 0, -8, -5, -4, -8, -8, -5, -7, -7, -7, -5, 17, -6, 2, -7, -10},
		/* X */ {0, -2, -4, -5, -4, -3, -4, -4, -4, -3, 0, -3, -3, -3, -3, -4, -2, -3, -2, -2, -3, -6, -3, -4, -2, -10},
		/* Y */ {0, -5, -6, -6, -7, -7, 4, -8, 1, -4, 0, -5, -4, -5, -5, -7, -4, -5, -5, -5, -5, 2, -4, 12, -6, -10},
		/* Z */ {0, -2, 0, -8, 0, 7, -7, -5, -1, -7, 0, 0, -6, -4, -2, -4, 5, -1, -2, -3, -5, -7, -2, -6, 6, -10},
		/* * */ {0, -10, -10, -10, -10, -10, -10, -10, -10, -10, 0, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, 1},
	}

	// #  Matrix made by matblas from blosum30.iij
	// #  * column uses minimum score
	// #  BLOSUM Clustered Scoring Matrix in 1/5 Bit Units
	// #  Blocks Database = /data/blocks_5.0/blocks.dat
	// #  Cluster Percentage: >= 30
	// #  Entropy =   0.1424, Expected =  -0.1074
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  4 -1  0  0 -3  1  0  0 -2  0 -1  0  1 -2 -1  1  1 -5 -4  1  0  0  0 -7
	// R -1  8 -2 -1 -2  3 -1 -2 -1 -3 -2  1  0 -1 -1 -1 -3  0  0 -1 -2  0 -1 -7
	// N  0 -2  8  1 -1 -1 -1  0 -1  0 -2  0  0 -1 -3  0  1 -7 -4 -2  4 -1  0 -7
	// D  0 -1  1  9 -3 -1  1 -1 -2 -4 -1  0 -3 -5 -1  0 -1 -4 -1 -2  5  0 -1 -7
	// C -3 -2 -1 -3 17 -2  1 -4 -5 -2  0 -3 -2 -3 -3 -2 -2 -2 -6 -2 -2  0 -2 -7
	// Q  1  3 -1 -1 -2  8  2 -2  0 -2 -2  0 -1 -3  0 -1  0 -1 -1 -3 -1  4  0 -7
	// E  0 -1 -1  1  1  2  6 -2  0 -3 -1  2 -1 -4  1  0 -2 -1 -2 -3  0  5 -1 -7
	// G  0 -2  0 -1 -4 -2 -2  8 -3 -1 -2 -1 -2 -3 -1  0 -2  1 -3 -3  0 -2 -1 -7
	// H -2 -1 -1 -2 -5  0  0 -3 14 -2 -1 -2  2 -3  1 -1 -2 -5  0 -3 -2  0 -1 -7
	// I  0 -3  0 -4 -2 -2 -3 -1 -2  6  2 -2  1  0 -3 -1  0 -3 -1  4 -2 -3  0 -7
	// L -1 -2 -2 -1  0 -2 -1 -2 -1  2  4 -2  2  2 -3 -2  0 -2  3  1 -1 -1  0 -7
	// K  0  1  0  0 -3  0  2 -1 -2 -2 -2  4  2 -1  1  0 -1 -2 -1 -2  0  1  0 -7
	// M  1  0  0 -3 -2 -1 -1 -2  2  1  2  2  6 -2 -4 -2  0 -3 -1  0 -2 -1  0 -7
	// F -2 -1 -1 -5 -3 -3 -4 -3 -3  0  2 -1 -2 10 -4 -1 -2  1  3  1 -3 -4 -1 -7
	// P -1 -1 -3 -1 -3  0  1 -1  1 -3 -3  1 -4 -4 11 -1  0 -3 -2 -4 -2  0 -1 -7
	// S  1 -1  0  0 -2 -1  0  0 -1 -1 -2  0 -2 -1 -1  4  2 -3 -2 -1  0 -1  0 -7
	// T  1 -3  1 -1 -2  0 -2 -2 -2  0  0 -1  0 -2  0  2  5 -5 -1  1  0 -1  0 -7
	// W -5  0 -7 -4 -2 -1 -1  1 -5 -3 -2 -2 -3  1 -3 -3 -5 20  5 -3 -5 -1 -2 -7
	// Y -4  0 -4 -1 -6 -1 -2 -3  0 -1  3 -1 -1  3 -2 -2 -1  5  9  1 -3 -2 -1 -7
	// V  1 -1 -2 -2 -2 -3 -3 -3 -3  4  1 -2  0  1 -4 -1  1 -3  1  5 -2 -3  0 -7
	// B  0 -2  4  5 -2 -1  0  0 -2 -2 -1  0 -2 -3 -2  0  0 -5 -3 -2  5  0 -1 -7
	// Z  0  0 -1  0  0  4  5 -2  0 -3 -1  1 -1 -4  0 -1 -1 -1 -2 -3  0  4  0 -7
	// X  0 -1  0 -1 -2  0 -1 -1 -1  0  0  0  0 -1 -1  0  0 -2 -1  0 -1  0 -1 -7
	// * -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7  1
	//
	BLOSUM30 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 4, 0, -3, 0, 0, -2, 0, -2, 0, 0, 0, -1, 1, 0, -1, 1, -1, 1, 1, 1, -5, 0, -4, 0, -7},
		/* B */ {0, 0, 5, -2, 5, 0, -3, 0, -2, -2, 0, 0, -1, -2, 4, -2, -1, -2, 0, 0, -2, -5, -1, -3, 0, -7},
		/* C */ {0, -3, -2, 17, -3, 1, -3, -4, -5, -2, 0, -3, 0, -2, -1, -3, -2, -2, -2, -2, -2, -2, -2, -6, 0, -7},
		/* D */ {0, 0, 5, -3, 9, 1, -5, -1, -2, -4, 0, 0, -1, -3, 1, -1, -1, -1, 0, -1, -2, -4, -1, -1, 0, -7},
		/* E */ {0, 0, 0, 1, 1, 6, -4, -2, 0, -3, 0, 2, -1, -1, -1, 1, 2, -1, 0, -2, -3, -1, -1, -2, 5, -7},
		/* F */ {0, -2, -3, -3, -5, -4, 10, -3, -3, 0, 0, -1, 2, -2, -1, -4, -3, -1, -1, -2, 1, 1, -1, 3, -4, -7},
		/* G */ {0, 0, 0, -4, -1, -2, -3, 8, -3, -1, 0, -1, -2, -2, 0, -1, -2, -2, 0, -2, -3, 1, -1, -3, -2, -7},
		/* H */ {0, -2, -2, -5, -2, 0, -3, -3, 14, -2, 0, -2, -1, 2, -1, 1, 0, -1, -1, -2, -3, -5, -1, 0, 0, -7},
		/* I */ {0, 0, -2, -2, -4, -3, 0, -1, -2, 6, 0, -2, 2, 1, 0, -3, -2, -3, -1, 0, 4, -3, 0, -1, -3, -7},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, 0, 0, -3, 0, 2, -1, -1, -2, -2, 0, 4, -2, 2, 0, 1, 0, 1, 0, -1, -2, -2, 0, -1, 1, -7},
		/* L */ {0, -1, -1, 0, -1, -1, 2, -2, -1, 2, 0, -2, 4, 2, -2, -3, -2, -2, -2, 0, 1, -2, 0, 3, -1, -7},
		/* M */ {0, 1, -2, -2, -3, -1, -2, -2, 2, 1, 0, 2, 2, 6, 0, -4, -1, 0, -2, 0, 0, -3, 0, -1, -1, -7},
		/* N */ {0, 0, 4, -1, 1, -1, -1, 0, -1, 0, 0, 0, -2, 0, 8, -3, -1, -2, 0, 1, -2, -7, 0, -4, -1, -7},
		/* P */ {0, -1, -2, -3, -1, 1, -4, -1, 1, -3, 0, 1, -3, -4, -3, 11, 0, -1, -1, 0, -4, -3, -1, -2, 0, -7},
		/* Q */ {0, 1, -1, -2, -1, 2, -3, -2, 0, -2, 0, 0, -2, -1, -1, 0, 8, 3, -1, 0, -3, -1, 0, -1, 4, -7},
		/* R */ {0, -1, -2, -2, -1, -1, -1, -2, -1, -3, 0, 1, -2, 0, -2, -1, 3, 8, -1, -3, -1, 0, -1, 0, 0, -7},
		/* S */ {0, 1, 0, -2, 0, 0, -1, 0, -1, -1, 0, 0, -2, -2, 0, -1, -1, -1, 4, 2, -1, -3, 0, -2, -1, -7},
		/* T */ {0, 1, 0, -2, -1, -2, -2, -2, -2, 0, 0, -1, 0, 0, 1, 0, 0, -3, 2, 5, 1, -5, 0, -1, -1, -7},
		/* V */ {0, 1, -2, -2, -2, -3, 1, -3, -3, 4, 0, -2, 1, 0, -2, -4, -3, -1, -1, 1, 5, -3, 0, 1, -3, -7},
		/* W */ {0, -5, -5, -2, -4, -1, 1, 1, -5, -3, 0, -2, -2, -3, -7, -3, -1, 0, -3, -5, -3, 20, -2, 5, -1, -7},
		/* X */ {0, 0, -1, -2, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, -1, 0, -1, 0, 0, 0, -2, -1, -1, 0, -7},
		/* Y */ {0, -4, -3, -6, -1, -2, 3, -3, 0, -1, 0, -1, 3, -1, -4, -2, -1, 0, -2, -1, 1, 5, -1, 9, -2, -7},
		/* Z */ {0, 0, 0, 0, 0, 5, -4, -2, 0, -3, 0, 1, -1, -1, -1, 0, 4, 0, -1, -1, -3, -1, 0, -2, 4, -7},
		/* * */ {0, -7, -7, -7, -7, -7, -7, -7, -7, -7, 0, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, 1},
	}

	// #  Matrix made by matblas from blosum35.iij
	// #  * column uses minimum score
	// #  BLOSUM Clustered Scoring Matrix in 1/4 Bit Units
	// #  Blocks Database = /data/blocks_5.0/blocks.dat
	// #  Cluster Percentage: >= 35
	// #  Entropy =   0.2111, Expected =  -0.1550
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  5 -1 -1 -1 -2  0 -1  0 -2 -1 -2  0  0 -2 -2  1  0 -2 -1  0 -1 -1  0 -5
	// R -1  8 -1 -1 -3  2 -1 -2 -1 -3 -2  2  0 -1 -2 -1 -2  0  0 -1 -1  0 -1 -5
	// N -1 -1  7  1 -1  1 -1  1  1 -1 -2  0 -1 -1 -2  0  0 -2 -2 -2  4  0  0 -5
	// D -1 -1  1  8 -3 -1  2 -2  0 -3 -2 -1 -3 -3 -1 -1 -1 -3 -2 -2  5  1 -1 -5
	// C -2 -3 -1 -3 15 -3 -1 -3 -4 -4 -2 -2 -4 -4 -4 -3 -1 -5 -5 -2 -2 -2 -2 -5
	// Q  0  2  1 -1 -3  7  2 -2 -1 -2 -2  0 -1 -4  0  0  0 -1  0 -3  0  4 -1 -5
	// E -1 -1 -1  2 -1  2  6 -2 -1 -3 -1  1 -2 -3  0  0 -1 -1 -1 -2  0  5 -1 -5
	// G  0 -2  1 -2 -3 -2 -2  7 -2 -3 -3 -1 -1 -3 -2  1 -2 -1 -2 -3  0 -2 -1 -5
	// H -2 -1  1  0 -4 -1 -1 -2 12 -3 -2 -2  1 -3 -1 -1 -2 -4  0 -4  0 -1 -1 -5
	// I -1 -3 -1 -3 -4 -2 -3 -3 -3  5  2 -2  1  1 -1 -2 -1 -1  0  4 -2 -3  0 -5
	// L -2 -2 -2 -2 -2 -2 -1 -3 -2  2  5 -2  3  2 -3 -2  0  0  0  2 -2 -2  0 -5
	// K  0  2  0 -1 -2  0  1 -1 -2 -2 -2  5  0 -1  0  0  0  0 -1 -2  0  1  0 -5
	// M  0  0 -1 -3 -4 -1 -2 -1  1  1  3  0  6  0 -3 -1  0  1  0  1 -2 -2  0 -5
	// F -2 -1 -1 -3 -4 -4 -3 -3 -3  1  2 -1  0  8 -4 -1 -1  1  3  1 -2 -3 -1 -5
	// P -2 -2 -2 -1 -4  0  0 -2 -1 -1 -3  0 -3 -4 10 -2  0 -4 -3 -3 -1  0 -1 -5
	// S  1 -1  0 -1 -3  0  0  1 -1 -2 -2  0 -1 -1 -2  4  2 -2 -1 -1  0  0  0 -5
	// T  0 -2  0 -1 -1  0 -1 -2 -2 -1  0  0  0 -1  0  2  5 -2 -2  1 -1 -1  0 -5
	// W -2  0 -2 -3 -5 -1 -1 -1 -4 -1  0  0  1  1 -4 -2 -2 16  3 -2 -3 -1 -1 -5
	// Y -1  0 -2 -2 -5  0 -1 -2  0  0  0 -1  0  3 -3 -1 -2  3  8  0 -2 -1 -1 -5
	// V  0 -1 -2 -2 -2 -3 -2 -3 -4  4  2 -2  1  1 -3 -1  1 -2  0  5 -2 -2  0 -5
	// B -1 -1  4  5 -2  0  0  0  0 -2 -2  0 -2 -2 -1  0 -1 -3 -2 -2  5  0 -1 -5
	// Z -1  0  0  1 -2  4  5 -2 -1 -3 -2  1 -2 -3  0  0 -1 -1 -1 -2  0  4  0 -5
	// X  0 -1  0 -1 -2 -1 -1 -1 -1  0  0  0  0 -1 -1  0  0 -1 -1  0 -1  0 -1 -5
	// * -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5  1
	//
	BLOSUM35 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 5, -1, -2, -1, -1, -2, 0, -2, -1, 0, 0, -2, 0, -1, -2, 0, -1, 1, 0, 0, -2, 0, -1, -1, -5},
		/* B */ {0, -1, 5, -2, 5, 0, -2, 0, 0, -2, 0, 0, -2, -2, 4, -1, 0, -1, 0, -1, -2, -3, -1, -2, 0, -5},
		/* C */ {0, -2, -2, 15, -3, -1, -4, -3, -4, -4, 0, -2, -2, -4, -1, -4, -3, -3, -3, -1, -2, -5, -2, -5, -2, -5},
		/* D */ {0, -1, 5, -3, 8, 2, -3, -2, 0, -3, 0, -1, -2, -3, 1, -1, -1, -1, -1, -1, -2, -3, -1, -2, 1, -5},
		/* E */ {0, -1, 0, -1, 2, 6, -3, -2, -1, -3, 0, 1, -1, -2, -1, 0, 2, -1, 0, -1, -2, -1, -1, -1, 5, -5},
		/* F */ {0, -2, -2, -4, -3, -3, 8, -3, -3, 1, 0, -1, 2, 0, -1, -4, -4, -1, -1, -1, 1, 1, -1, 3, -3, -5},
		/* G */ {0, 0, 0, -3, -2, -2, -3, 7, -2, -3, 0, -1, -3, -1, 1, -2, -2, -2, 1, -2, -3, -1, -1, -2, -2, -5},
		/* H */ {0, -2, 0, -4, 0, -1, -3, -2, 12, -3, 0, -2, -2, 1, 1, -1, -1, -1, -1, -2, -4, -4, -1, 0, -1, -5},
		/* I */ {0, -1, -2, -4, -3, -3, 1, -3, -3, 5, 0, -2, 2, 1, -1, -1, -2, -3, -2, -1, 4, -1, 0, 0, -3, -5},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, 0, 0, -2, -1, 1, -1, -1, -2, -2, 0, 5, -2, 0, 0, 0, 0, 2, 0, 0, -2, 0, 0, -1, 1, -5},
		/* L */ {0, -2, -2, -2, -2, -1, 2, -3, -2, 2, 0, -2, 5, 3, -2, -3, -2, -2, -2, 0, 2, 0, 0, 0, -2, -5},
		/* M */ {0, 0, -2, -4, -3, -2, 0, -1, 1, 1, 0, 0, 3, 6, -1, -3, -1, 0, -1, 0, 1, 1, 0, 0, -2, -5},
		/* N */ {0, -1, 4, -1, 1, -1, -1, 1, 1, -1, 0, 0, -2, -1, 7, -2, 1, -1, 0, 0, -2, -2, 0, -2, 0, -5},
		/* P */ {0, -2, -1, -4, -1, 0, -4, -2, -1, -1, 0, 0, -3, -3, -2, 10, 0, -2, -2, 0, -3, -4, -1, -3, 0, -5},
		/* Q */ {0, 0, 0, -3, -1, 2, -4, -2, -1, -2, 0, 0, -2, -1, 1, 0, 7, 2, 0, 0, -3, -1, -1, 0, 4, -5},
		/* R */ {0, -1, -1, -3, -1, -1, -1, -2, -1, -3, 0, 2, -2, 0, -1, -2, 2, 8, -1, -2, -1, 0, -1, 0, 0, -5},
		/* S */ {0, 1, 0, -3, -1, 0, -1, 1, -1, -2, 0, 0, -2, -1, 0, -2, 0, -1, 4, 2, -1, -2, 0, -1, 0, -5},
		/* T */ {0, 0, -1, -1, -1, -1, -1, -2, -2, -1, 0, 0, 0, 0, 0, 0, 0, -2, 2, 5, 1, -2, 0, -2, -1, -5},
		/* V */ {0, 0, -2, -2, -2, -2, 1, -3, -4, 4, 0, -2, 2, 1, -2, -3, -3, -1, -1, 1, 5, -2, 0, 0, -2, -5},
		/* W */ {0, -2, -3, -5, -3, -1, 1, -1, -4, -1, 0, 0, 0, 1, -2, -4, -1, 0, -2, -2, -2, 16, -1, 3, -1, -5},
		/* X */ {0, 0, -1, -2, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, -1, 0, 0, 0, -1, -1, -1, 0, -5},
		/* Y */ {0, -1, -2, -5, -2, -1, 3, -2, 0, 0, 0, -1, 0, 0, -2, -3, 0, 0, -1, -2, 0, 3, -1, 8, -1, -5},
		/* Z */ {0, -1, 0, -2, 1, 5, -3, -2, -1, -3, 0, 1, -2, -2, 0, 0, 4, 0, 0, -1, -2, -1, 0, -1, 4, -5},
		/* * */ {0, -5, -5, -5, -5, -5, -5, -5, -5, -5, 0, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, 1},
	}

	// #  Matrix made by matblas from blosum40.iij
	// #  * column uses minimum score
	// #  BLOSUM Clustered Scoring Matrix in 1/4 Bit Units
	// #  Blocks Database = /data/blocks_5.0/blocks.dat
	// #  Cluster Percentage: >= 40
	// #  Entropy =   0.2851, Expected =  -0.2090
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  5 -2 -1 -1 -2  0 -1  1 -2 -1 -2 -1 -1 -3 -2  1  0 -3 -2  0 -1 -1  0 -6
	// R -2  9  0 -1 -3  2 -1 -3  0 -3 -2  3 -1 -2 -3 -1 -2 -2 -1 -2 -1  0 -1 -6
	// N -1  0  8  2 -2  1 -1  0  1 -2 -3  0 -2 -3 -2  1  0 -4 -2 -3  4  0 -1 -6
	// D -1 -1  2  9 -2 -1  2 -2  0 -4 -3  0 -3 -4 -2  0 -1 -5 -3 -3  6  1 -1 -6
	// C -2 -3 -2 -2 16 -4 -2 -3 -4 -4 -2 -3 -3 -2 -5 -1 -1 -6 -4 -2 -2 -3 -2 -6
	// Q  0  2  1 -1 -4  8  2 -2  0 -3 -2  1 -1 -4 -2  1 -1 -1 -1 -3  0  4 -1 -6
	// E -1 -1 -1  2 -2  2  7 -3  0 -4 -2  1 -2 -3  0  0 -1 -2 -2 -3  1  5 -1 -6
	// G  1 -3  0 -2 -3 -2 -3  8 -2 -4 -4 -2 -2 -3 -1  0 -2 -2 -3 -4 -1 -2 -1 -6
	// H -2  0  1  0 -4  0  0 -2 13 -3 -2 -1  1 -2 -2 -1 -2 -5  2 -4  0  0 -1 -6
	// I -1 -3 -2 -4 -4 -3 -4 -4 -3  6  2 -3  1  1 -2 -2 -1 -3  0  4 -3 -4 -1 -6
	// L -2 -2 -3 -3 -2 -2 -2 -4 -2  2  6 -2  3  2 -4 -3 -1 -1  0  2 -3 -2 -1 -6
	// K -1  3  0  0 -3  1  1 -2 -1 -3 -2  6 -1 -3 -1  0  0 -2 -1 -2  0  1 -1 -6
	// M -1 -1 -2 -3 -3 -1 -2 -2  1  1  3 -1  7  0 -2 -2 -1 -2  1  1 -3 -2  0 -6
	// F -3 -2 -3 -4 -2 -4 -3 -3 -2  1  2 -3  0  9 -4 -2 -1  1  4  0 -3 -4 -1 -6
	// P -2 -3 -2 -2 -5 -2  0 -1 -2 -2 -4 -1 -2 -4 11 -1  0 -4 -3 -3 -2 -1 -2 -6
	// S  1 -1  1  0 -1  1  0  0 -1 -2 -3  0 -2 -2 -1  5  2 -5 -2 -1  0  0  0 -6
	// T  0 -2  0 -1 -1 -1 -1 -2 -2 -1 -1  0 -1 -1  0  2  6 -4 -1  1  0 -1  0 -6
	// W -3 -2 -4 -5 -6 -1 -2 -2 -5 -3 -1 -2 -2  1 -4 -5 -4 19  3 -3 -4 -2 -2 -6
	// Y -2 -1 -2 -3 -4 -1 -2 -3  2  0  0 -1  1  4 -3 -2 -1  3  9 -1 -3 -2 -1 -6
	// V  0 -2 -3 -3 -2 -3 -3 -4 -4  4  2 -2  1  0 -3 -1  1 -3 -1  5 -3 -3 -1 -6
	// B -1 -1  4  6 -2  0  1 -1  0 -3 -3  0 -3 -3 -2  0  0 -4 -3 -3  5  2 -1 -6
	// Z -1  0  0  1 -3  4  5 -2  0 -4 -2  1 -2 -4 -1  0 -1 -2 -2 -3  2  5 -1 -6
	// X  0 -1 -1 -1 -2 -1 -1 -1 -1 -1 -1 -1  0 -1 -2  0  0 -2 -1 -1 -1 -1 -1 -6
	// * -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6  1
	//
	BLOSUM40 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 5, -1, -2, -1, -1, -3, 1, -2, -1, 0, -1, -2, -1, -1, -2, 0, -2, 1, 0, 0, -3, 0, -2, -1, -6},
		/* B */ {0, -1, 5, -2, 6, 1, -3, -1, 0, -3, 0, 0, -3, -3, 4, -2, 0, -1, 0, 0, -3, -4, -1, -3, 2, -6},
		/* C */ {0, -2, -2, 16, -2, -2, -2, -3, -4, -4, 0, -3, -2, -3, -2, -5, -4, -3, -1, -1, -2, -6, -2, -4, -3, -6},
		/* D */ {0, -1, 6, -2, 9, 2, -4, -2, 0, -4, 0, 0, -3, -3, 2, -2, -1, -1, 0, -1, -3, -5, -1, -3, 1, -6},
		/* E */ {0, -1, 1, -2, 2, 7, -3, -3, 0, -4, 0, 1, -2, -2, -1, 0, 2, -1, 0, -1, -3, -2, -1, -2, 5, -6},
		/* F */ {0, -3, -3, -2, -4, -3, 9, -3, -2, 1, 0, -3, 2, 0, -3, -4, -4, -2, -2, -1, 0, 1, -1, 4, -4, -6},
		/* G */ {0, 1, -1, -3, -2, -3, -3, 8, -2, -4, 0, -2, -4, -2, 0, -1, -2, -3, 0, -2, -4, -2, -1, -3, -2, -6},
		/* H */ {0, -2, 0, -4, 0, 0, -2, -2, 13, -3, 0, -1, -2, 1, 1, -2, 0, 0, -1, -2, -4, -5, -1, 2, 0, -6},
		/* I */ {0, -1, -3, -4, -4, -4, 1, -4, -3, 6, 0, -3, 2, 1, -2, -2, -3, -3, -2, -1, 4, -3, -1, 0, -4, -6},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 0, -3, 0, 1, -3, -2, -1, -3, 0, 6, -2, -1, 0, -1, 1, 3, 0, 0, -2, -2, -1, -1, 1, -6},
		/* L */ {0, -2, -3, -2, -3, -2, 2, -4, -2, 2, 0, -2, 6, 3, -3, -4, -2, -2, -3, -1, 2, -1, -1, 0, -2, -6},
		/* M */ {0, -1, -3, -3, -3, -2, 0, -2, 1, 1, 0, -1, 3, 7, -2, -2, -1, -1, -2, -1, 1, -2, 0, 1, -2, -6},
		/* N */ {0, -1, 4, -2, 2, -1, -3, 0, 1, -2, 0, 0, -3, -2, 8, -2, 1, 0, 1, 0, -3, -4, -1, -2, 0, -6},
		/* P */ {0, -2, -2, -5, -2, 0, -4, -1, -2, -2, 0, -1, -4, -2, -2, 11, -2, -3, -1, 0, -3, -4, -2, -3, -1, -6},
		/* Q */ {0, 0, 0, -4, -1, 2, -4, -2, 0, -3, 0, 1, -2, -1, 1, -2, 8, 2, 1, -1, -3, -1, -1, -1, 4, -6},
		/* R */ {0, -2, -1, -3, -1, -1, -2, -3, 0, -3, 0, 3, -2, -1, 0, -3, 2, 9, -1, -2, -2, -2, -1, -1, 0, -6},
		/* S */ {0, 1, 0, -1, 0, 0, -2, 0, -1, -2, 0, 0, -3, -2, 1, -1, 1, -1, 5, 2, -1, -5, 0, -2, 0, -6},
		/* T */ {0, 0, 0, -1, -1, -1, -1, -2, -2, -1, 0, 0, -1, -1, 0, 0, -1, -2, 2, 6, 1, -4, 0, -1, -1, -6},
		/* V */ {0, 0, -3, -2, -3, -3, 0, -4, -4, 4, 0, -2, 2, 1, -3, -3, -3, -2, -1, 1, 5, -3, -1, -1, -3, -6},
		/* W */ {0, -3, -4, -6, -5, -2, 1, -2, -5, -3, 0, -2, -1, -2, -4, -4, -1, -2, -5, -4, -3, 19, -2, 3, -2, -6},
		/* X */ {0, 0, -1, -2, -1, -1, -1, -1, -1, -1, 0, -1, -1, 0, -1, -2, -1, -1, 0, 0, -1, -2, -1, -1, -1, -6},
		/* Y */ {0, -2, -3, -4, -3, -2, 4, -3, 2, 0, 0, -1, 0, 1, -2, -3, -1, -1, -2, -1, -1, 3, -1, 9, -2, -6},
		/* Z */ {0, -1, 2, -3, 1, 5, -4, -2, 0, -4, 0, 1, -2, -2, 0, -1, 4, 0, 0, -1, -3, -2, -1, -2, 5, -6},
		/* * */ {0, -6, -6, -6, -6, -6, -6, -6, -6, -6, 0, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, 1},
	}

	// #  Matrix made by matblas from blosum45.iij
	// #  * column uses minimum score
	// #  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
	// #  Blocks Database = /data/blocks_5.0/blocks.dat
	// #  Cluster Percentage: >= 45
	// #  Entropy =   0.3795, Expected =  -0.2789
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  5 -2 -1 -2 -1 -1 -1  0 -2 -1 -1 -1 -1 -2 -1  1  0 -2 -2  0 -1 -1  0 -5
	// R -2  7  0 -1 -3  1  0 -2  0 -3 -2  3 -1 -2 -2 -1 -1 -2 -1 -2 -1  0 -1 -5
	// N -1  0  6  2 -2  0  0  0  1 -2 -3  0 -2 -2 -2  1  0 -4 -2 -3  4  0 -1 -5
	// D -2 -1  2  7 -3  0  2 -1  0 -4 -3  0 -3 -4 -1  0 -1 -4 -2 -3  5  1 -1 -5
	// C -1 -3 -2 -3 12 -3 -3 -3 -3 -3 -2 -3 -2 -2 -4 -1 -1 -5 -3 -1 -2 -3 -2 -5
	// Q -1  1  0  0 -3  6  2 -2  1 -2 -2  1  0 -4 -1  0 -1 -2 -1 -3  0  4 -1 -5
	// E -1  0  0  2 -3  2  6 -2  0 -3 -2  1 -2 -3  0  0 -1 -3 -2 -3  1  4 -1 -5
	// G  0 -2  0 -1 -3 -2 -2  7 -2 -4 -3 -2 -2 -3 -2  0 -2 -2 -3 -3 -1 -2 -1 -5
	// H -2  0  1  0 -3  1  0 -2 10 -3 -2 -1  0 -2 -2 -1 -2 -3  2 -3  0  0 -1 -5
	// I -1 -3 -2 -4 -3 -2 -3 -4 -3  5  2 -3  2  0 -2 -2 -1 -2  0  3 -3 -3 -1 -5
	// L -1 -2 -3 -3 -2 -2 -2 -3 -2  2  5 -3  2  1 -3 -3 -1 -2  0  1 -3 -2 -1 -5
	// K -1  3  0  0 -3  1  1 -2 -1 -3 -3  5 -1 -3 -1 -1 -1 -2 -1 -2  0  1 -1 -5
	// M -1 -1 -2 -3 -2  0 -2 -2  0  2  2 -1  6  0 -2 -2 -1 -2  0  1 -2 -1 -1 -5
	// F -2 -2 -2 -4 -2 -4 -3 -3 -2  0  1 -3  0  8 -3 -2 -1  1  3  0 -3 -3 -1 -5
	// P -1 -2 -2 -1 -4 -1  0 -2 -2 -2 -3 -1 -2 -3  9 -1 -1 -3 -3 -3 -2 -1 -1 -5
	// S  1 -1  1  0 -1  0  0  0 -1 -2 -3 -1 -2 -2 -1  4  2 -4 -2 -1  0  0  0 -5
	// T  0 -1  0 -1 -1 -1 -1 -2 -2 -1 -1 -1 -1 -1 -1  2  5 -3 -1  0  0 -1  0 -5
	// W -2 -2 -4 -4 -5 -2 -3 -2 -3 -2 -2 -2 -2  1 -3 -4 -3 15  3 -3 -4 -2 -2 -5
	// Y -2 -1 -2 -2 -3 -1 -2 -3  2  0  0 -1  0  3 -3 -2 -1  3  8 -1 -2 -2 -1 -5
	// V  0 -2 -3 -3 -1 -3 -3 -3 -3  3  1 -2  1  0 -3 -1  0 -3 -1  5 -3 -3 -1 -5
	// B -1 -1  4  5 -2  0  1 -1  0 -3 -3  0 -2 -3 -2  0  0 -4 -2 -3  4  2 -1 -5
	// Z -1  0  0  1 -3  4  4 -2  0 -3 -2  1 -1 -3 -1  0 -1 -2 -2 -3  2  4 -1 -5
	// X  0 -1 -1 -1 -2 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  0  0 -2 -1 -1 -1 -1 -1 -5
	// * -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5  1
	//
	BLOSUM45 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 5, -1, -1, -2, -1, -2, 0, -2, -1, 0, -1, -1, -1, -1, -1, -1, -2, 1, 0, 0, -2, 0, -2, -1, -5},
		/* B */ {0, -1, 4, -2, 5, 1, -3, -1, 0, -3, 0, 0, -3, -2, 4, -2, 0, -1, 0, 0, -3, -4, -1, -2, 2, -5},
		/* C */ {0, -1, -2, 12, -3, -3, -2, -3, -3, -3, 0, -3, -2, -2, -2, -4, -3, -3, -1, -1, -1, -5, -2, -3, -3, -5},
		/* D */ {0, -2, 5, -3, 7, 2, -4, -1, 0, -4, 0, 0, -3, -3, 2, -1, 0, -1, 0, -1, -3, -4, -1, -2, 1, -5},
		/* E */ {0, -1, 1, -3, 2, 6, -3, -2, 0, -3, 0, 1, -2, -2, 0, 0, 2, 0, 0, -1, -3, -3, -1, -2, 4, -5},
		/* F */ {0, -2, -3, -2, -4, -3, 8, -3, -2, 0, 0, -3, 1, 0, -2, -3, -4, -2, -2, -1, 0, 1, -1, 3, -3, -5},
		/* G */ {0, 0, -1, -3, -1, -2, -3, 7, -2, -4, 0, -2, -3, -2, 0, -2, -2, -2, 0, -2, -3, -2, -1, -3, -2, -5},
		/* H */ {0, -2, 0, -3, 0, 0, -2, -2, 10, -3, 0, -1, -2, 0, 1, -2, 1, 0, -1, -2, -3, -3, -1, 2, 0, -5},
		/* I */ {0, -1, -3, -3, -4, -3, 0, -4, -3, 5, 0, -3, 2, 2, -2, -2, -2, -3, -2, -1, 3, -2, -1, 0, -3, -5},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 0, -3, 0, 1, -3, -2, -1, -3, 0, 5, -3, -1, 0, -1, 1, 3, -1, -1, -2, -2, -1, -1, 1, -5},
		/* L */ {0, -1, -3, -2, -3, -2, 1, -3, -2, 2, 0, -3, 5, 2, -3, -3, -2, -2, -3, -1, 1, -2, -1, 0, -2, -5},
		/* M */ {0, -1, -2, -2, -3, -2, 0, -2, 0, 2, 0, -1, 2, 6, -2, -2, 0, -1, -2, -1, 1, -2, -1, 0, -1, -5},
		/* N */ {0, -1, 4, -2, 2, 0, -2, 0, 1, -2, 0, 0, -3, -2, 6, -2, 0, 0, 1, 0, -3, -4, -1, -2, 0, -5},
		/* P */ {0, -1, -2, -4, -1, 0, -3, -2, -2, -2, 0, -1, -3, -2, -2, 9, -1, -2, -1, -1, -3, -3, -1, -3, -1, -5},
		/* Q */ {0, -1, 0, -3, 0, 2, -4, -2, 1, -2, 0, 1, -2, 0, 0, -1, 6, 1, 0, -1, -3, -2, -1, -1, 4, -5},
		/* R */ {0, -2, -1, -3, -1, 0, -2, -2, 0, -3, 0, 3, -2, -1, 0, -2, 1, 7, -1, -1, -2, -2, -1, -1, 0, -5},
		/* S */ {0, 1, 0, -1, 0, 0, -2, 0, -1, -2, 0, -1, -3, -2, 1, -1, 0, -1, 4, 2, -1, -4, 0, -2, 0, -5},
		/* T */ {0, 0, 0, -1, -1, -1, -1, -2, -2, -1, 0, -1, -1, -1, 0, -1, -1, -1, 2, 5, 0, -3, 0, -1, -1, -5},
		/* V */ {0, 0, -3, -1, -3, -3, 0, -3, -3, 3, 0, -2, 1, 1, -3, -3, -3, -2, -1, 0, 5, -3, -1, -1, -3, -5},
		/* W */ {0, -2, -4, -5, -4, -3, 1, -2, -3, -2, 0, -2, -2, -2, -4, -3, -2, -2, -4, -3, -3, 15, -2, 3, -2, -5},
		/* X */ {0, 0, -1, -2, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, -1, -2, -1, -1, -1, -5},
		/* Y */ {0, -2, -2, -3, -2, -2, 3, -3, 2, 0, 0, -1, 0, 0, -2, -3, -1, -1, -2, -1, -1, 3, -1, 8, -2, -5},
		/* Z */ {0, -1, 2, -3, 1, 4, -3, -2, 0, -3, 0, 1, -2, -1, 0, -1, 4, 0, 0, -1, -3, -2, -1, -2, 4, -5},
		/* * */ {0, -5, -5, -5, -5, -5, -5, -5, -5, -5, 0, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, 1},
	}

	// #  Matrix made by matblas from blosum50.iij
	// #  * column uses minimum score
	// #  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
	// #  Blocks Database = /data/blocks_5.0/blocks.dat
	// #  Cluster Percentage: >= 50
	// #  Entropy =   0.4808, Expected =  -0.3573
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  5 -2 -1 -2 -1 -1 -1  0 -2 -1 -2 -1 -1 -3 -1  1  0 -3 -2  0 -2 -1 -1 -5
	// R -2  7 -1 -2 -4  1  0 -3  0 -4 -3  3 -2 -3 -3 -1 -1 -3 -1 -3 -1  0 -1 -5
	// N -1 -1  7  2 -2  0  0  0  1 -3 -4  0 -2 -4 -2  1  0 -4 -2 -3  4  0 -1 -5
	// D -2 -2  2  8 -4  0  2 -1 -1 -4 -4 -1 -4 -5 -1  0 -1 -5 -3 -4  5  1 -1 -5
	// C -1 -4 -2 -4 13 -3 -3 -3 -3 -2 -2 -3 -2 -2 -4 -1 -1 -5 -3 -1 -3 -3 -2 -5
	// Q -1  1  0  0 -3  7  2 -2  1 -3 -2  2  0 -4 -1  0 -1 -1 -1 -3  0  4 -1 -5
	// E -1  0  0  2 -3  2  6 -3  0 -4 -3  1 -2 -3 -1 -1 -1 -3 -2 -3  1  5 -1 -5
	// G  0 -3  0 -1 -3 -2 -3  8 -2 -4 -4 -2 -3 -4 -2  0 -2 -3 -3 -4 -1 -2 -2 -5
	// H -2  0  1 -1 -3  1  0 -2 10 -4 -3  0 -1 -1 -2 -1 -2 -3  2 -4  0  0 -1 -5
	// I -1 -4 -3 -4 -2 -3 -4 -4 -4  5  2 -3  2  0 -3 -3 -1 -3 -1  4 -4 -3 -1 -5
	// L -2 -3 -4 -4 -2 -2 -3 -4 -3  2  5 -3  3  1 -4 -3 -1 -2 -1  1 -4 -3 -1 -5
	// K -1  3  0 -1 -3  2  1 -2  0 -3 -3  6 -2 -4 -1  0 -1 -3 -2 -3  0  1 -1 -5
	// M -1 -2 -2 -4 -2  0 -2 -3 -1  2  3 -2  7  0 -3 -2 -1 -1  0  1 -3 -1 -1 -5
	// F -3 -3 -4 -5 -2 -4 -3 -4 -1  0  1 -4  0  8 -4 -3 -2  1  4 -1 -4 -4 -2 -5
	// P -1 -3 -2 -1 -4 -1 -1 -2 -2 -3 -4 -1 -3 -4 10 -1 -1 -4 -3 -3 -2 -1 -2 -5
	// S  1 -1  1  0 -1  0 -1  0 -1 -3 -3  0 -2 -3 -1  5  2 -4 -2 -2  0  0 -1 -5
	// T  0 -1  0 -1 -1 -1 -1 -2 -2 -1 -1 -1 -1 -2 -1  2  5 -3 -2  0  0 -1  0 -5
	// W -3 -3 -4 -5 -5 -1 -3 -3 -3 -3 -2 -3 -1  1 -4 -4 -3 15  2 -3 -5 -2 -3 -5
	// Y -2 -1 -2 -3 -3 -1 -2 -3  2 -1 -1 -2  0  4 -3 -2 -2  2  8 -1 -3 -2 -1 -5
	// V  0 -3 -3 -4 -1 -3 -3 -4 -4  4  1 -3  1 -1 -3 -2  0 -3 -1  5 -4 -3 -1 -5
	// B -2 -1  4  5 -3  0  1 -1  0 -4 -4  0 -3 -4 -2  0  0 -5 -3 -4  5  2 -1 -5
	// Z -1  0  0  1 -3  4  5 -2  0 -3 -3  1 -1 -4 -1  0 -1 -2 -2 -3  2  5 -1 -5
	// X -1 -1 -1 -1 -2 -1 -1 -2 -1 -1 -1 -1 -1 -2 -2 -1  0 -3 -1 -1 -1 -1 -1 -5
	// * -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5  1
	//
	BLOSUM50 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 5, -2, -1, -2, -1, -3, 0, -2, -1, 0, -1, -2, -1, -1, -1, -1, -2, 1, 0, 0, -3, -1, -2, -1, -5},
		/* B */ {0, -2, 5, -3, 5, 1, -4, -1, 0, -4, 0, 0, -4, -3, 4, -2, 0, -1, 0, 0, -4, -5, -1, -3, 2, -5},
		/* C */ {0, -1, -3, 13, -4, -3, -2, -3, -3, -2, 0, -3, -2, -2, -2, -4, -3, -4, -1, -1, -1, -5, -2, -3, -3, -5},
		/* D */ {0, -2, 5, -4, 8, 2, -5, -1, -1, -4, 0, -1, -4, -4, 2, -1, 0, -2, 0, -1, -4, -5, -1, -3, 1, -5},
		/* E */ {0, -1, 1, -3, 2, 6, -3, -3, 0, -4, 0, 1, -3, -2, 0, -1, 2, 0, -1, -1, -3, -3, -1, -2, 5, -5},
		/* F */ {0, -3, -4, -2, -5, -3, 8, -4, -1, 0, 0, -4, 1, 0, -4, -4, -4, -3, -3, -2, -1, 1, -2, 4, -4, -5},
		/* G */ {0, 0, -1, -3, -1, -3, -4, 8, -2, -4, 0, -2, -4, -3, 0, -2, -2, -3, 0, -2, -4, -3, -2, -3, -2, -5},
		/* H */ {0, -2, 0, -3, -1, 0, -1, -2, 10, -4, 0, 0, -3, -1, 1, -2, 1, 0, -1, -2, -4, -3, -1, 2, 0, -5},
		/* I */ {0, -1, -4, -2, -4, -4, 0, -4, -4, 5, 0, -3, 2, 2, -3, -3, -3, -4, -3, -1, 4, -3, -1, -1, -3, -5},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 0, -3, -1, 1, -4, -2, 0, -3, 0, 6, -3, -2, 0, -1, 2, 3, 0, -1, -3, -3, -1, -2, 1, -5},
		/* L */ {0, -2, -4, -2, -4, -3, 1, -4, -3, 2, 0, -3, 5, 3, -4, -4, -2, -3, -3, -1, 1, -2, -1, -1, -3, -5},
		/* M */ {0, -1, -3, -2, -4, -2, 0, -3, -1, 2, 0, -2, 3, 7, -2, -3, 0, -2, -2, -1, 1, -1, -1, 0, -1, -5},
		/* N */ {0, -1, 4, -2, 2, 0, -4, 0, 1, -3, 0, 0, -4, -2, 7, -2, 0, -1, 1, 0, -3, -4, -1, -2, 0, -5},
		/* P */ {0, -1, -2, -4, -1, -1, -4, -2, -2, -3, 0, -1, -4, -3, -2, 10, -1, -3, -1, -1, -3, -4, -2, -3, -1, -5},
		/* Q */ {0, -1, 0, -3, 0, 2, -4, -2, 1, -3, 0, 2, -2, 0, 0, -1, 7, 1, 0, -1, -3, -1, -1, -1, 4, -5},
		/* R */ {0, -2, -1, -4, -2, 0, -3, -3, 0, -4, 0, 3, -3, -2, -1, -3, 1, 7, -1, -1, -3, -3, -1, -1, 0, -5},
		/* S */ {0, 1, 0, -1, 0, -1, -3, 0, -1, -3, 0, 0, -3, -2, 1, -1, 0, -1, 5, 2, -2, -4, -1, -2, 0, -5},
		/* T */ {0, 0, 0, -1, -1, -1, -2, -2, -2, -1, 0, -1, -1, -1, 0, -1, -1, -1, 2, 5, 0, -3, 0, -2, -1, -5},
		/* V */ {0, 0, -4, -1, -4, -3, -1, -4, -4, 4, 0, -3, 1, 1, -3, -3, -3, -3, -2, 0, 5, -3, -1, -1, -3, -5},
		/* W */ {0, -3, -5, -5, -5, -3, 1, -3, -3, -3, 0, -3, -2, -1, -4, -4, -1, -3, -4, -3, -3, 15, -3, 2, -2, -5},
		/* X */ {0, -1, -1, -2, -1, -1, -2, -2, -1, -1, 0, -1, -1, -1, -1, -2, -1, -1, -1, 0, -1, -3, -1, -1, -1, -5},
		/* Y */ {0, -2, -3, -3, -3, -2, 4, -3, 2, -1, 0, -2, -1, 0, -2, -3, -1, -1, -2, -2, -1, 2, -1, 8, -2, -5},
		/* Z */ {0, -1, 2, -3, 1, 5, -4, -2, 0, -3, 0, 1, -3, -1, 0, -1, 4, 0, 0, -1, -3, -2, -1, -2, 5, -5},
		/* * */ {0, -5, -5, -5, -5, -5, -5, -5, -5, -5, 0, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, 1},
	}

	// #  Matrix made by matblas from blosum55.iij
	// #  * column uses minimum score
	// #  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
	// #  Blocks Database = /data/blocks_5.0/blocks.dat
	// #  Cluster Percentage: >= 55
	// #  Entropy =   0.5637, Expected =  -0.4179
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  5 -2 -2 -2  0 -1 -1  0 -2 -2 -2 -1 -1 -3 -1  2  0 -4 -2  0 -2 -1 -1 -5
	// R -2  8 -1 -2 -4  1  0 -3  0 -4 -3  3 -2 -3 -3 -1 -1 -3 -2 -3 -1  0 -1 -5
	// N -2 -1  8  2 -3  0  0  0  1 -4 -4  0 -3 -4 -2  1  0 -5 -2 -4  4  0 -1 -5
	// D -2 -2  2  8 -4  0  2 -2 -1 -4 -5 -1 -4 -5 -2  0 -1 -5 -3 -4  5  1 -2 -5
	// C  0 -4 -3 -4 13 -4 -4 -3 -4 -2 -2 -4 -2 -3 -3 -1 -1 -4 -3 -1 -4 -4 -2 -5
	// Q -1  1  0  0 -4  7  2 -2  1 -4 -3  2  0 -4 -1  0 -1 -2 -1 -3  0  4 -1 -5
	// E -1  0  0  2 -4  2  7 -3 -1 -4 -4  1 -3 -4 -1  0 -1 -3 -2 -3  1  5 -1 -5
	// G  0 -3  0 -2 -3 -2 -3  8 -2 -5 -5 -2 -3 -4 -3  0 -2 -3 -4 -4 -1 -3 -2 -5
	// H -2  0  1 -1 -4  1 -1 -2 11 -4 -3  0 -2 -1 -3 -1 -2 -3  2 -4  0  0 -1 -5
	// I -2 -4 -4 -4 -2 -4 -4 -5 -4  6  2 -4  2  0 -3 -3 -1 -3 -1  4 -4 -4 -1 -5
	// L -2 -3 -4 -5 -2 -3 -4 -5 -3  2  6 -3  3  1 -4 -3 -2 -3 -1  1 -4 -3 -1 -5
	// K -1  3  0 -1 -4  2  1 -2  0 -4 -3  6 -2 -4 -1  0 -1 -4 -2 -3  0  1 -1 -5
	// M -1 -2 -3 -4 -2  0 -3 -3 -2  2  3 -2  8  0 -3 -2 -1 -2 -1  1 -3 -2 -1 -5
	// F -3 -3 -4 -5 -3 -4 -4 -4 -1  0  1 -4  0  9 -5 -3 -3  2  4 -1 -5 -4 -2 -5
	// P -1 -3 -2 -2 -3 -1 -1 -3 -3 -3 -4 -1 -3 -5 10 -1 -1 -5 -4 -3 -2 -1 -2 -5
	// S  2 -1  1  0 -1  0  0  0 -1 -3 -3  0 -2 -3 -1  5  2 -4 -2 -2  0  0 -1 -5
	// T  0 -1  0 -1 -1 -1 -1 -2 -2 -1 -2 -1 -1 -3 -1  2  6 -3 -2  0 -1 -1 -1 -5
	// W -4 -3 -5 -5 -4 -2 -3 -3 -3 -3 -3 -4 -2  2 -5 -4 -3 15  3 -4 -5 -3 -3 -5
	// Y -2 -2 -2 -3 -3 -1 -2 -4  2 -1 -1 -2 -1  4 -4 -2 -2  3  9 -2 -3 -2 -1 -5
	// V  0 -3 -4 -4 -1 -3 -3 -4 -4  4  1 -3  1 -1 -3 -2  0 -4 -2  5 -4 -3 -1 -5
	// B -2 -1  4  5 -4  0  1 -1  0 -4 -4  0 -3 -5 -2  0 -1 -5 -3 -4  5  2 -1 -5
	// Z -1  0  0  1 -4  4  5 -3  0 -4 -3  1 -2 -4 -1  0 -1 -3 -2 -3  2  5 -1 -5
	// X -1 -1 -1 -2 -2 -1 -1 -2 -1 -1 -1 -1 -1 -2 -2 -1 -1 -3 -1 -1 -1 -1 -1 -5
	// * -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5  1
	//
	BLOSUM55 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 5, -2, 0, -2, -1, -3, 0, -2, -2, 0, -1, -2, -1, -2, -1, -1, -2, 2, 0, 0, -4, -1, -2, -1, -5},
		/* B */ {0, -2, 5, -4, 5, 1, -5, -1, 0, -4, 0, 0, -4, -3, 4, -2, 0, -1, 0, -1, -4, -5, -1, -3, 2, -5},
		/* C */ {0, 0, -4, 13, -4, -4, -3, -3, -4, -2, 0, -4, -2, -2, -3, -3, -4, -4, -1, -1, -1, -4, -2, -3, -4, -5},
		/* D */ {0, -2, 5, -4, 8, 2, -5, -2, -1, -4, 0, -1, -5, -4, 2, -2, 0, -2, 0, -1, -4, -5, -2, -3, 1, -5},
		/* E */ {0, -1, 1, -4, 2, 7, -4, -3, -1, -4, 0, 1, -4, -3, 0, -1, 2, 0, 0, -1, -3, -3, -1, -2, 5, -5},
		/* F */ {0, -3, -5, -3, -5, -4, 9, -4, -1, 0, 0, -4, 1, 0, -4, -5, -4, -3, -3, -3, -1, 2, -2, 4, -4, -5},
		/* G */ {0, 0, -1, -3, -2, -3, -4, 8, -2, -5, 0, -2, -5, -3, 0, -3, -2, -3, 0, -2, -4, -3, -2, -4, -3, -5},
		/* H */ {0, -2, 0, -4, -1, -1, -1, -2, 11, -4, 0, 0, -3, -2, 1, -3, 1, 0, -1, -2, -4, -3, -1, 2, 0, -5},
		/* I */ {0, -2, -4, -2, -4, -4, 0, -5, -4, 6, 0, -4, 2, 2, -4, -3, -4, -4, -3, -1, 4, -3, -1, -1, -4, -5},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 0, -4, -1, 1, -4, -2, 0, -4, 0, 6, -3, -2, 0, -1, 2, 3, 0, -1, -3, -4, -1, -2, 1, -5},
		/* L */ {0, -2, -4, -2, -5, -4, 1, -5, -3, 2, 0, -3, 6, 3, -4, -4, -3, -3, -3, -2, 1, -3, -1, -1, -3, -5},
		/* M */ {0, -1, -3, -2, -4, -3, 0, -3, -2, 2, 0, -2, 3, 8, -3, -3, 0, -2, -2, -1, 1, -2, -1, -1, -2, -5},
		/* N */ {0, -2, 4, -3, 2, 0, -4, 0, 1, -4, 0, 0, -4, -3, 8, -2, 0, -1, 1, 0, -4, -5, -1, -2, 0, -5},
		/* P */ {0, -1, -2, -3, -2, -1, -5, -3, -3, -3, 0, -1, -4, -3, -2, 10, -1, -3, -1, -1, -3, -5, -2, -4, -1, -5},
		/* Q */ {0, -1, 0, -4, 0, 2, -4, -2, 1, -4, 0, 2, -3, 0, 0, -1, 7, 1, 0, -1, -3, -2, -1, -1, 4, -5},
		/* R */ {0, -2, -1, -4, -2, 0, -3, -3, 0, -4, 0, 3, -3, -2, -1, -3, 1, 8, -1, -1, -3, -3, -1, -2, 0, -5},
		/* S */ {0, 2, 0, -1, 0, 0, -3, 0, -1, -3, 0, 0, -3, -2, 1, -1, 0, -1, 5, 2, -2, -4, -1, -2, 0, -5},
		/* T */ {0, 0, -1, -1, -1, -1, -3, -2, -2, -1, 0, -1, -2, -1, 0, -1, -1, -1, 2, 6, 0, -3, -1, -2, -1, -5},
		/* V */ {0, 0, -4, -1, -4, -3, -1, -4, -4, 4, 0, -3, 1, 1, -4, -3, -3, -3, -2, 0, 5, -4, -1, -2, -3, -5},
		/* W */ {0, -4, -5, -4, -5, -3, 2, -3, -3, -3, 0, -4, -3, -2, -5, -5, -2, -3, -4, -3, -4, 15, -3, 3, -3, -5},
		/* X */ {0, -1, -1, -2, -2, -1, -2, -2, -1, -1, 0, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -3, -1, -1, -1, -5},
		/* Y */ {0, -2, -3, -3, -3, -2, 4, -4, 2, -1, 0, -2, -1, -1, -2, -4, -1, -2, -2, -2, -2, 3, -1, 9, -2, -5},
		/* Z */ {0, -1, 2, -4, 1, 5, -4, -3, 0, -4, 0, 1, -3, -2, 0, -1, 4, 0, 0, -1, -3, -3, -1, -2, 5, -5},
		/* * */ {0, -5, -5, -5, -5, -5, -5, -5, -5, -5, 0, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, 1},
	}

	// #  Matrix made by matblas from blosum60.iij
	// #  * column uses minimum score
	// #  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	// #  Blocks Database = /data/blocks_5.0/blocks.dat
	// #  Cluster Percentage: >= 60
	// #  Entropy =   0.6603, Expected =  -0.4917
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  4 -1 -1 -2  0 -1 -1  0 -2 -1 -1 -1 -1 -2 -1  1  0 -3 -2  0 -2 -1  0 -4
	// R -1  5  0 -1 -3  1  0 -2  0 -3 -2  2 -1 -3 -2 -1 -1 -3 -2 -2 -1  0 -1 -4
	// N -1  0  6  1 -2  0  0  0  1 -3 -3  0 -2 -3 -2  1  0 -4 -2 -3  3  0 -1 -4
	// D -2 -1  1  6 -3  0  2 -1 -1 -3 -3 -1 -3 -3 -1  0 -1 -4 -3 -3  4  1 -1 -4
	// C  0 -3 -2 -3  9 -3 -3 -2 -3 -1 -1 -3 -1 -2 -3 -1 -1 -2 -2 -1 -3 -3 -2 -4
	// Q -1  1  0  0 -3  5  2 -2  1 -3 -2  1  0 -3 -1  0 -1 -2 -1 -2  0  3 -1 -4
	// E -1  0  0  2 -3  2  5 -2  0 -3 -3  1 -2 -3 -1  0 -1 -3 -2 -2  1  4 -1 -4
	// G  0 -2  0 -1 -2 -2 -2  6 -2 -3 -4 -1 -2 -3 -2  0 -2 -2 -3 -3 -1 -2 -1 -4
	// H -2  0  1 -1 -3  1  0 -2  7 -3 -3 -1 -1 -1 -2 -1 -2 -2  2 -3  0  0 -1 -4
	// I -1 -3 -3 -3 -1 -3 -3 -3 -3  4  2 -3  1  0 -3 -2 -1 -2 -1  3 -3 -3 -1 -4
	// L -1 -2 -3 -3 -1 -2 -3 -4 -3  2  4 -2  2  0 -3 -2 -1 -2 -1  1 -3 -2 -1 -4
	// K -1  2  0 -1 -3  1  1 -1 -1 -3 -2  4 -1 -3 -1  0 -1 -3 -2 -2  0  1 -1 -4
	// M -1 -1 -2 -3 -1  0 -2 -2 -1  1  2 -1  5  0 -2 -1 -1 -1 -1  1 -3 -1 -1 -4
	// F -2 -3 -3 -3 -2 -3 -3 -3 -1  0  0 -3  0  6 -4 -2 -2  1  3 -1 -3 -3 -1 -4
	// P -1 -2 -2 -1 -3 -1 -1 -2 -2 -3 -3 -1 -2 -4  7 -1 -1 -4 -3 -2 -2 -1 -2 -4
	// S  1 -1  1  0 -1  0  0  0 -1 -2 -2  0 -1 -2 -1  4  1 -3 -2 -2  0  0  0 -4
	// T  0 -1  0 -1 -1 -1 -1 -2 -2 -1 -1 -1 -1 -2 -1  1  4 -2 -2  0  0 -1  0 -4
	// W -3 -3 -4 -4 -2 -2 -3 -2 -2 -2 -2 -3 -1  1 -4 -3 -2 10  2 -3 -4 -2 -2 -4
	// Y -2 -2 -2 -3 -2 -1 -2 -3  2 -1 -1 -2 -1  3 -3 -2 -2  2  6 -1 -2 -2 -1 -4
	// V  0 -2 -3 -3 -1 -2 -2 -3 -3  3  1 -2  1 -1 -2 -2  0 -3 -1  4 -3 -2 -1 -4
	// B -2 -1  3  4 -3  0  1 -1  0 -3 -3  0 -3 -3 -2  0  0 -4 -2 -3  4  1 -1 -4
	// Z -1  0  0  1 -3  3  4 -2  0 -3 -2  1 -1 -3 -1  0 -1 -2 -2 -2  1  3 -1 -4
	// X  0 -1 -1 -1 -2 -1 -1 -1 -1 -1 -1 -1 -1 -1 -2  0  0 -2 -1 -1 -1 -1 -1 -4
	// * -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4  1
	//
	BLOSUM60 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 4, -2, 0, -2, -1, -2, 0, -2, -1, 0, -1, -1, -1, -1, -1, -1, -1, 1, 0, 0, -3, 0, -2, -1, -4},
		/* B */ {0, -2, 4, -3, 4, 1, -3, -1, 0, -3, 0, 0, -3, -3, 3, -2, 0, -1, 0, 0, -3, -4, -1, -2, 1, -4},
		/* C */ {0, 0, -3, 9, -3, -3, -2, -2, -3, -1, 0, -3, -1, -1, -2, -3, -3, -3, -1, -1, -1, -2, -2, -2, -3, -4},
		/* D */ {0, -2, 4, -3, 6, 2, -3, -1, -1, -3, 0, -1, -3, -3, 1, -1, 0, -1, 0, -1, -3, -4, -1, -3, 1, -4},
		/* E */ {0, -1, 1, -3, 2, 5, -3, -2, 0, -3, 0, 1, -3, -2, 0, -1, 2, 0, 0, -1, -2, -3, -1, -2, 4, -4},
		/* F */ {0, -2, -3, -2, -3, -3, 6, -3, -1, 0, 0, -3, 0, 0, -3, -4, -3, -3, -2, -2, -1, 1, -1, 3, -3, -4},
		/* G */ {0, 0, -1, -2, -1, -2, -3, 6, -2, -3, 0, -1, -4, -2, 0, -2, -2, -2, 0, -2, -3, -2, -1, -3, -2, -4},
		/* H */ {0, -2, 0, -3, -1, 0, -1, -2, 7, -3, 0, -1, -3, -1, 1, -2, 1, 0, -1, -2, -3, -2, -1, 2, 0, -4},
		/* I */ {0, -1, -3, -1, -3, -3, 0, -3, -3, 4, 0, -3, 2, 1, -3, -3, -3, -3, -2, -1, 3, -2, -1, -1, -3, -4},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 0, -3, -1, 1, -3, -1, -1, -3, 0, 4, -2, -1, 0, -1, 1, 2, 0, -1, -2, -3, -1, -2, 1, -4},
		/* L */ {0, -1, -3, -1, -3, -3, 0, -4, -3, 2, 0, -2, 4, 2, -3, -3, -2, -2, -2, -1, 1, -2, -1, -1, -2, -4},
		/* M */ {0, -1, -3, -1, -3, -2, 0, -2, -1, 1, 0, -1, 2, 5, -2, -2, 0, -1, -1, -1, 1, -1, -1, -1, -1, -4},
		/* N */ {0, -1, 3, -2, 1, 0, -3, 0, 1, -3, 0, 0, -3, -2, 6, -2, 0, 0, 1, 0, -3, -4, -1, -2, 0, -4},
		/* P */ {0, -1, -2, -3, -1, -1, -4, -2, -2, -3, 0, -1, -3, -2, -2, 7, -1, -2, -1, -1, -2, -4, -2, -3, -1, -4},
		/* Q */ {0, -1, 0, -3, 0, 2, -3, -2, 1, -3, 0, 1, -2, 0, 0, -1, 5, 1, 0, -1, -2, -2, -1, -1, 3, -4},
		/* R */ {0, -1, -1, -3, -1, 0, -3, -2, 0, -3, 0, 2, -2, -1, 0, -2, 1, 5, -1, -1, -2, -3, -1, -2, 0, -4},
		/* S */ {0, 1, 0, -1, 0, 0, -2, 0, -1, -2, 0, 0, -2, -1, 1, -1, 0, -1, 4, 1, -2, -3, 0, -2, 0, -4},
		/* T */ {0, 0, 0, -1, -1, -1, -2, -2, -2, -1, 0, -1, -1, -1, 0, -1, -1, -1, 1, 4, 0, -2, 0, -2, -1, -4},
		/* V */ {0, 0, -3, -1, -3, -2, -1, -3, -3, 3, 0, -2, 1, 1, -3, -2, -2, -2, -2, 0, 4, -3, -1, -1, -2, -4},
		/* W */ {0, -3, -4, -2, -4, -3, 1, -2, -2, -2, 0, -3, -2, -1, -4, -4, -2, -3, -3, -2, -3, 10, -2, 2, -2, -4},
		/* X */ {0, 0, -1, -2, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -2, -1, -1, 0, 0, -1, -2, -1, -1, -1, -4},
		/* Y */ {0, -2, -2, -2, -3, -2, 3, -3, 2, -1, 0, -2, -1, -1, -2, -3, -1, -2, -2, -2, -1, 2, -1, 6, -2, -4},
		/* Z */ {0, -1, 1, -3, 1, 4, -3, -2, 0, -3, 0, 1, -2, -1, 0, -1, 3, 0, 0, -1, -2, -2, -1, -2, 3, -4},
		/* * */ {0, -4, -4, -4, -4, -4, -4, -4, -4, -4, 0, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, 1},
	}

	// #  Matrix made by matblas from blosum62.iij
	// #  * column uses minimum score
	// #  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	// #  Blocks Database = /data/blocks_5.0/blocks.dat
	// #  Cluster Percentage: >= 62
	// #  Entropy =   0.6979, Expected =  -0.5209
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  4 -1 -2 -2  0 -1 -1  0 -2 -1 -1 -1 -1 -2 -1  1  0 -3 -2  0 -2 -1  0 -4
	// R -1  5  0 -2 -3  1  0 -2  0 -3 -2  2 -1 -3 -2 -1 -1 -3 -2 -3 -1  0 -1 -4
	// N -2  0  6  1 -3  0  0  0  1 -3 -3  0 -2 -3 -2  1  0 -4 -2 -3  3  0 -1 -4
	// D -2 -2  1  6 -3  0  2 -1 -1 -3 -4 -1 -3 -3 -1  0 -1 -4 -3 -3  4  1 -1 -4
	// C  0 -3 -3 -3  9 -3 -4 -3 -3 -1 -1 -3 -1 -2 -3 -1 -1 -2 -2 -1 -3 -3 -2 -4
	// Q -1  1  0  0 -3  5  2 -2  0 -3 -2  1  0 -3 -1  0 -1 -2 -1 -2  0  3 -1 -4
	// E -1  0  0  2 -4  2  5 -2  0 -3 -3  1 -2 -3 -1  0 -1 -3 -2 -2  1  4 -1 -4
	// G  0 -2  0 -1 -3 -2 -2  6 -2 -4 -4 -2 -3 -3 -2  0 -2 -2 -3 -3 -1 -2 -1 -4
	// H -2  0  1 -1 -3  0  0 -2  8 -3 -3 -1 -2 -1 -2 -1 -2 -2  2 -3  0  0 -1 -4
	// I -1 -3 -3 -3 -1 -3 -3 -4 -3  4  2 -3  1  0 -3 -2 -1 -3 -1  3 -3 -3 -1 -4
	// L -1 -2 -3 -4 -1 -2 -3 -4 -3  2  4 -2  2  0 -3 -2 -1 -2 -1  1 -4 -3 -1 -4
	// K -1  2  0 -1 -3  1  1 -2 -1 -3 -2  5 -1 -3 -1  0 -1 -3 -2 -2  0  1 -1 -4
	// M -1 -1 -2 -3 -1  0 -2 -3 -2  1  2 -1  5  0 -2 -1 -1 -1 -1  1 -3 -1 -1 -4
	// F -2 -3 -3 -3 -2 -3 -3 -3 -1  0  0 -3  0  6 -4 -2 -2  1  3 -1 -3 -3 -1 -4
	// P -1 -2 -2 -1 -3 -1 -1 -2 -2 -3 -3 -1 -2 -4  7 -1 -1 -4 -3 -2 -2 -1 -2 -4
	// S  1 -1  1  0 -1  0  0  0 -1 -2 -2  0 -1 -2 -1  4  1 -3 -2 -2  0  0  0 -4
	// T  0 -1  0 -1 -1 -1 -1 -2 -2 -1 -1 -1 -1 -2 -1  1  5 -2 -2  0 -1 -1  0 -4
	// W -3 -3 -4 -4 -2 -2 -3 -2 -2 -3 -2 -3 -1  1 -4 -3 -2 11  2 -3 -4 -3 -2 -4
	// Y -2 -2 -2 -3 -2 -1 -2 -3  2 -1 -1 -2 -1  3 -3 -2 -2  2  7 -1 -3 -2 -1 -4
	// V  0 -3 -3 -3 -1 -2 -2 -3 -3  3  1 -2  1 -1 -2 -2  0 -3 -1  4 -3 -2 -1 -4
	// B -2 -1  3  4 -3  0  1 -1  0 -3 -4  0 -3 -3 -2  0 -1 -4 -3 -3  4  1 -1 -4
	// Z -1  0  0  1 -3  3  4 -2  0 -3 -3  1 -1 -3 -1  0 -1 -3 -2 -2  1  4 -1 -4
	// X  0 -1 -1 -1 -2 -1 -1 -1 -1 -1 -1 -1 -1 -1 -2  0  0 -2 -1 -1 -1 -1 -1 -4
	// * -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4 -4  1
	//
	BLOSUM62 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 4, -2, 0, -2, -1, -2, 0, -2, -1, 0, -1, -1, -1, -2, -1, -1, -1, 1, 0, 0, -3, 0, -2, -1, -4},
		/* B */ {0, -2, 4, -3, 4, 1, -3, -1, 0, -3, 0, 0, -4, -3, 3, -2, 0, -1, 0, -1, -3, -4, -1, -3, 1, -4},
		/* C */ {0, 0, -3, 9, -3, -4, -2, -3, -3, -1, 0, -3, -1, -1, -3, -3, -3, -3, -1, -1, -1, -2, -2, -2, -3, -4},
		/* D */ {0, -2, 4, -3, 6, 2, -3, -1, -1, -3, 0, -1, -4, -3, 1, -1, 0, -2, 0, -1, -3, -4, -1, -3, 1, -4},
		/* E */ {0, -1, 1, -4, 2, 5, -3, -2, 0, -3, 0, 1, -3, -2, 0, -1, 2, 0, 0, -1, -2, -3, -1, -2, 4, -4},
		/* F */ {0, -2, -3, -2, -3, -3, 6, -3, -1, 0, 0, -3, 0, 0, -3, -4, -3, -3, -2, -2, -1, 1, -1, 3, -3, -4},
		/* G */ {0, 0, -1, -3, -1, -2, -3, 6, -2, -4, 0, -2, -4, -3, 0, -2, -2, -2, 0, -2, -3, -2, -1, -3, -2, -4},
		/* H */ {0, -2, 0, -3, -1, 0, -1, -2, 8, -3, 0, -1, -3, -2, 1, -2, 0, 0, -1, -2, -3, -2, -1, 2, 0, -4},
		/* I */ {0, -1, -3, -1, -3, -3, 0, -4, -3, 4, 0, -3, 2, 1, -3, -3, -3, -3, -2, -1, 3, -3, -1, -1, -3, -4},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 0, -3, -1, 1, -3, -2, -1, -3, 0, 5, -2, -1, 0, -1, 1, 2, 0, -1, -2, -3, -1, -2, 1, -4},
		/* L */ {0, -1, -4, -1, -4, -3, 0, -4, -3, 2, 0, -2, 4, 2, -3, -3, -2, -2, -2, -1, 1, -2, -1, -1, -3, -4},
		/* M */ {0, -1, -3, -1, -3, -2, 0, -3, -2, 1, 0, -1, 2, 5, -2, -2, 0, -1, -1, -1, 1, -1, -1, -1, -1, -4},
		/* N */ {0, -2, 3, -3, 1, 0, -3, 0, 1, -3, 0, 0, -3, -2, 6, -2, 0, 0, 1, 0, -3, -4, -1, -2, 0, -4},
		/* P */ {0, -1, -2, -3, -1, -1, -4, -2, -2, -3, 0, -1, -3, -2, -2, 7, -1, -2, -1, -1, -2, -4, -2, -3, -1, -4},
		/* Q */ {0, -1, 0, -3, 0, 2, -3, -2, 0, -3, 0, 1, -2, 0, 0, -1, 5, 1, 0, -1, -2, -2, -1, -1, 3, -4},
		/* R */ {0, -1, -1, -3, -2, 0, -3, -2, 0, -3, 0, 2, -2, -1, 0, -2, 1, 5, -1, -1, -3, -3, -1, -2, 0, -4},
		/* S */ {0, 1, 0, -1, 0, 0, -2, 0, -1, -2, 0, 0, -2, -1, 1, -1, 0, -1, 4, 1, -2, -3, 0, -2, 0, -4},
		/* T */ {0, 0, -1, -1, -1, -1, -2, -2, -2, -1, 0, -1, -1, -1, 0, -1, -1, -1, 1, 5, 0, -2, 0, -2, -1, -4},
		/* V */ {0, 0, -3, -1, -3, -2, -1, -3, -3, 3, 0, -2, 1, 1, -3, -2, -2, -3, -2, 0, 4, -3, -1, -1, -2, -4},
		/* W */ {0, -3, -4, -2, -4, -3, 1, -2, -2, -3, 0, -3, -2, -1, -4, -4, -2, -3, -3, -2, -3, 11, -2, 2, -3, -4},
		/* X */ {0, 0, -1, -2, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -2, -1, -1, 0, 0, -1, -2, -1, -1, -1, -4},
		/* Y */ {0, -2, -3, -2, -3, -2, 3, -3, 2, -1, 0, -2, -1, -1, -2, -3, -1, -2, -2, -2, -1, 2, -1, 7, -2, -4},
		/* Z */ {0, -1, 1, -3, 1, 4, -3, -2, 0, -3, 0, 1, -3, -1, 0, -1, 3, 0, 0, -1, -2, -3, -1, -2, 4, -4},
		/* * */ {0, -4, -4, -4, -4, -4, -4, -4, -4, -4, 0, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, 1},
	}

	// #  Matrix made by matblas from blosum65.iij
	// #  * column uses minimum score
	// #  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	// #  Blocks Database = /data/blocks_5.0/blocks.dat
	// #  Cluster Percentage: >= 65
	// #  Entropy =   0.7576, Expected =  -0.5675
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  4 -1 -2 -2  0 -1 -1  0 -2 -1 -2 -1 -1 -2 -1  1  0 -3 -2  0 -2 -1 -1 -5
	// R -1  6  0 -2 -4  1  0 -2  0 -3 -2  2 -2 -3 -2 -1 -1 -3 -2 -3 -1  0 -1 -5
	// N -2  0  6  1 -3  0  0 -1  1 -3 -4  0 -2 -3 -2  1  0 -4 -2 -3  3  0 -1 -5
	// D -2 -2  1  6 -4  0  2 -1 -1 -3 -4 -1 -3 -4 -2  0 -1 -5 -3 -3  4  1 -1 -5
	// C  0 -4 -3 -4  9 -3 -4 -3 -3 -1 -1 -3 -2 -2 -3 -1 -1 -2 -2 -1 -3 -4 -2 -5
	// Q -1  1  0  0 -3  6  2 -2  1 -3 -2  1  0 -3 -1  0 -1 -2 -2 -2  0  3 -1 -5
	// E -1  0  0  2 -4  2  5 -2  0 -3 -3  1 -2 -3 -1  0 -1 -3 -2 -3  1  4 -1 -5
	// G  0 -2 -1 -1 -3 -2 -2  6 -2 -4 -4 -2 -3 -3 -2  0 -2 -3 -3 -3 -1 -2 -2 -5
	// H -2  0  1 -1 -3  1  0 -2  8 -3 -3 -1 -2 -1 -2 -1 -2 -2  2 -3  0  0 -1 -5
	// I -1 -3 -3 -3 -1 -3 -3 -4 -3  4  2 -3  1  0 -3 -2 -1 -2 -1  3 -3 -3 -1 -5
	// L -2 -2 -4 -4 -1 -2 -3 -4 -3  2  4 -3  2  0 -3 -3 -1 -2 -1  1 -4 -3 -1 -5
	// K -1  2  0 -1 -3  1  1 -2 -1 -3 -3  5 -2 -3 -1  0 -1 -3 -2 -2  0  1 -1 -5
	// M -1 -2 -2 -3 -2  0 -2 -3 -2  1  2 -2  6  0 -3 -2 -1 -2 -1  1 -3 -2 -1 -5
	// F -2 -3 -3 -4 -2 -3 -3 -3 -1  0  0 -3  0  6 -4 -2 -2  1  3 -1 -3 -3 -2 -5
	// P -1 -2 -2 -2 -3 -1 -1 -2 -2 -3 -3 -1 -3 -4  8 -1 -1 -4 -3 -2 -2 -1 -2 -5
	// S  1 -1  1  0 -1  0  0  0 -1 -2 -3  0 -2 -2 -1  4  1 -3 -2 -2  0  0 -1 -5
	// T  0 -1  0 -1 -1 -1 -1 -2 -2 -1 -1 -1 -1 -2 -1  1  5 -3 -2  0 -1 -1 -1 -5
	// W -3 -3 -4 -5 -2 -2 -3 -3 -2 -2 -2 -3 -2  1 -4 -3 -3 10  2 -3 -4 -3 -2 -5
	// Y -2 -2 -2 -3 -2 -2 -2 -3  2 -1 -1 -2 -1  3 -3 -2 -2  2  7 -1 -3 -2 -1 -5
	// V  0 -3 -3 -3 -1 -2 -3 -3 -3  3  1 -2  1 -1 -2 -2  0 -3 -1  4 -3 -2 -1 -5
	// B -2 -1  3  4 -3  0  1 -1  0 -3 -4  0 -3 -3 -2  0 -1 -4 -3 -3  4  1 -1 -5
	// Z -1  0  0  1 -4  3  4 -2  0 -3 -3  1 -2 -3 -1  0 -1 -3 -2 -2  1  4 -1 -5
	// X -1 -1 -1 -1 -2 -1 -1 -2 -1 -1 -1 -1 -1 -2 -2 -1 -1 -2 -1 -1 -1 -1 -1 -5
	// * -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5  1
	//
	BLOSUM65 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 4, -2, 0, -2, -1, -2, 0, -2, -1, 0, -1, -2, -1, -2, -1, -1, -1, 1, 0, 0, -3, -1, -2, -1, -5},
		/* B */ {0, -2, 4, -3, 4, 1, -3, -1, 0, -3, 0, 0, -4, -3, 3, -2, 0, -1, 0, -1, -3, -4, -1, -3, 1, -5},
		/* C */ {0, 0, -3, 9, -4, -4, -2, -3, -3, -1, 0, -3, -1, -2, -3, -3, -3, -4, -1, -1, -1, -2, -2, -2, -4, -5},
		/* D */ {0, -2, 4, -4, 6, 2, -4, -1, -1, -3, 0, -1, -4, -3, 1, -2, 0, -2, 0, -1, -3, -5, -1, -3, 1, -5},
		/* E */ {0, -1, 1, -4, 2, 5, -3, -2, 0, -3, 0, 1, -3, -2, 0, -1, 2, 0, 0, -1, -3, -3, -1, -2, 4, -5},
		/* F */ {0, -2, -3, -2, -4, -3, 6, -3, -1, 0, 0, -3, 0, 0, -3, -4, -3, -3, -2, -2, -1, 1, -2, 3, -3, -5},
		/* G */ {0, 0, -1, -3, -1, -2, -3, 6, -2, -4, 0, -2, -4, -3, -1, -2, -2, -2, 0, -2, -3, -3, -2, -3, -2, -5},
		/* H */ {0, -2, 0, -3, -1, 0, -1, -2, 8, -3, 0, -1, -3, -2, 1, -2, 1, 0, -1, -2, -3, -2, -1, 2, 0, -5},
		/* I */ {0, -1, -3, -1, -3, -3, 0, -4, -3, 4, 0, -3, 2, 1, -3, -3, -3, -3, -2, -1, 3, -2, -1, -1, -3, -5},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 0, -3, -1, 1, -3, -2, -1, -3, 0, 5, -3, -2, 0, -1, 1, 2, 0, -1, -2, -3, -1, -2, 1, -5},
		/* L */ {0, -2, -4, -1, -4, -3, 0, -4, -3, 2, 0, -3, 4, 2, -4, -3, -2, -2, -3, -1, 1, -2, -1, -1, -3, -5},
		/* M */ {0, -1, -3, -2, -3, -2, 0, -3, -2, 1, 0, -2, 2, 6, -2, -3, 0, -2, -2, -1, 1, -2, -1, -1, -2, -5},
		/* N */ {0, -2, 3, -3, 1, 0, -3, -1, 1, -3, 0, 0, -4, -2, 6, -2, 0, 0, 1, 0, -3, -4, -1, -2, 0, -5},
		/* P */ {0, -1, -2, -3, -2, -1, -4, -2, -2, -3, 0, -1, -3, -3, -2, 8, -1, -2, -1, -1, -2, -4, -2, -3, -1, -5},
		/* Q */ {0, -1, 0, -3, 0, 2, -3, -2, 1, -3, 0, 1, -2, 0, 0, -1, 6, 1, 0, -1, -2, -2, -1, -2, 3, -5},
		/* R */ {0, -1, -1, -4, -2, 0, -3, -2, 0, -3, 0, 2, -2, -2, 0, -2, 1, 6, -1, -1, -3, -3, -1, -2, 0, -5},
		/* S */ {0, 1, 0, -1, 0, 0, -2, 0, -1, -2, 0, 0, -3, -2, 1, -1, 0, -1, 4, 1, -2, -3, -1, -2, 0, -5},
		/* T */ {0, 0, -1, -1, -1, -1, -2, -2, -2, -1, 0, -1, -1, -1, 0, -1, -1, -1, 1, 5, 0, -3, -1, -2, -1, -5},
		/* V */ {0, 0, -3, -1, -3, -3, -1, -3, -3, 3, 0, -2, 1, 1, -3, -2, -2, -3, -2, 0, 4, -3, -1, -1, -2, -5},
		/* W */ {0, -3, -4, -2, -5, -3, 1, -3, -2, -2, 0, -3, -2, -2, -4, -4, -2, -3, -3, -3, -3, 10, -2, 2, -3, -5},
		/* X */ {0, -1, -1, -2, -1, -1, -2, -2, -1, -1, 0, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -2, -1, -1, -1, -5},
		/* Y */ {0, -2, -3, -2, -3, -2, 3, -3, 2, -1, 0, -2, -1, -1, -2, -3, -2, -2, -2, -2, -1, 2, -1, 7, -2, -5},
		/* Z */ {0, -1, 1, -4, 1, 4, -3, -2, 0, -3, 0, 1, -3, -2, 0, -1, 3, 0, 0, -1, -2, -3, -1, -2, 4, -5},
		/* * */ {0, -5, -5, -5, -5, -5, -5, -5, -5, -5, 0, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, 1},
	}

	// #  Matrix made by matblas from blosum70.iij
	// #  * column uses minimum score
	// #  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	// #  Blocks Database = /data/blocks_5.0/blocks.dat
	// #  Cluster Percentage: >= 70
	// #  Entropy =   0.8391, Expected =  -0.6313
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  4 -2 -2 -2 -1 -1 -1  0 -2 -2 -2 -1 -1 -2 -1  1  0 -3 -2  0 -2 -1 -1 -5
	// R -2  6 -1 -2 -4  1  0 -3  0 -3 -3  2 -2 -3 -2 -1 -1 -3 -2 -3 -1  0 -1 -5
	// N -2 -1  6  1 -3  0  0 -1  0 -4 -4  0 -2 -3 -2  0  0 -4 -2 -3  3  0 -1 -5
	// D -2 -2  1  6 -4 -1  1 -2 -1 -4 -4 -1 -3 -4 -2  0 -1 -5 -4 -4  4  1 -2 -5
	// C -1 -4 -3 -4  9 -3 -4 -3 -4 -1 -2 -4 -2 -2 -3 -1 -1 -3 -3 -1 -4 -4 -2 -5
	// Q -1  1  0 -1 -3  6  2 -2  1 -3 -2  1  0 -3 -2  0 -1 -2 -2 -2  0  3 -1 -5
	// E -1  0  0  1 -4  2  5 -2  0 -4 -3  1 -2 -4 -1  0 -1 -4 -3 -3  1  4 -1 -5
	// G  0 -3 -1 -2 -3 -2 -2  6 -2 -4 -4 -2 -3 -4 -3 -1 -2 -3 -4 -4 -1 -2 -2 -5
	// H -2  0  0 -1 -4  1  0 -2  8 -4 -3 -1 -2 -1 -2 -1 -2 -2  2 -3 -1  0 -1 -5
	// I -2 -3 -4 -4 -1 -3 -4 -4 -4  4  2 -3  1  0 -3 -3 -1 -3 -1  3 -4 -3 -1 -5
	// L -2 -3 -4 -4 -2 -2 -3 -4 -3  2  4 -3  2  0 -3 -3 -2 -2 -1  1 -4 -3 -1 -5
	// K -1  2  0 -1 -4  1  1 -2 -1 -3 -3  5 -2 -3 -1  0 -1 -3 -2 -3 -1  1 -1 -5
	// M -1 -2 -2 -3 -2  0 -2 -3 -2  1  2 -2  6  0 -3 -2 -1 -2 -1  1 -3 -2 -1 -5
	// F -2 -3 -3 -4 -2 -3 -4 -4 -1  0  0 -3  0  6 -4 -3 -2  1  3 -1 -4 -4 -2 -5
	// P -1 -2 -2 -2 -3 -2 -1 -3 -2 -3 -3 -1 -3 -4  8 -1 -1 -4 -3 -3 -2 -1 -2 -5
	// S  1 -1  0  0 -1  0  0 -1 -1 -3 -3  0 -2 -3 -1  4  1 -3 -2 -2  0  0 -1 -5
	// T  0 -1  0 -1 -1 -1 -1 -2 -2 -1 -2 -1 -1 -2 -1  1  5 -3 -2  0 -1 -1 -1 -5
	// W -3 -3 -4 -5 -3 -2 -4 -3 -2 -3 -2 -3 -2  1 -4 -3 -3 11  2 -3 -4 -3 -3 -5
	// Y -2 -2 -2 -4 -3 -2 -3 -4  2 -1 -1 -2 -1  3 -3 -2 -2  2  7 -2 -3 -2 -2 -5
	// V  0 -3 -3 -4 -1 -2 -3 -4 -3  3  1 -3  1 -1 -3 -2  0 -3 -2  4 -3 -3 -1 -5
	// B -2 -1  3  4 -4  0  1 -1 -1 -4 -4 -1 -3 -4 -2  0 -1 -4 -3 -3  4  0 -1 -5
	// Z -1  0  0  1 -4  3  4 -2  0 -3 -3  1 -2 -4 -1  0 -1 -3 -2 -3  0  4 -1 -5
	// X -1 -1 -1 -2 -2 -1 -1 -2 -1 -1 -1 -1 -1 -2 -2 -1 -1 -3 -2 -1 -1 -1 -1 -5
	// * -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5  1
	//
	BLOSUM70 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 4, -2, -1, -2, -1, -2, 0, -2, -2, 0, -1, -2, -1, -2, -1, -1, -2, 1, 0, 0, -3, -1, -2, -1, -5},
		/* B */ {0, -2, 4, -4, 4, 1, -4, -1, -1, -4, 0, -1, -4, -3, 3, -2, 0, -1, 0, -1, -3, -4, -1, -3, 0, -5},
		/* C */ {0, -1, -4, 9, -4, -4, -2, -3, -4, -1, 0, -4, -2, -2, -3, -3, -3, -4, -1, -1, -1, -3, -2, -3, -4, -5},
		/* D */ {0, -2, 4, -4, 6, 1, -4, -2, -1, -4, 0, -1, -4, -3, 1, -2, -1, -2, 0, -1, -4, -5, -2, -4, 1, -5},
		/* E */ {0, -1, 1, -4, 1, 5, -4, -2, 0, -4, 0, 1, -3, -2, 0, -1, 2, 0, 0, -1, -3, -4, -1, -3, 4, -5},
		/* F */ {0, -2, -4, -2, -4, -4, 6, -4, -1, 0, 0, -3, 0, 0, -3, -4, -3, -3, -3, -2, -1, 1, -2, 3, -4, -5},
		/* G */ {0, 0, -1, -3, -2, -2, -4, 6, -2, -4, 0, -2, -4, -3, -1, -3, -2, -3, -1, -2, -4, -3, -2, -4, -2, -5},
		/* H */ {0, -2, -1, -4, -1, 0, -1, -2, 8, -4, 0, -1, -3, -2, 0, -2, 1, 0, -1, -2, -3, -2, -1, 2, 0, -5},
		/* I */ {0, -2, -4, -1, -4, -4, 0, -4, -4, 4, 0, -3, 2, 1, -4, -3, -3, -3, -3, -1, 3, -3, -1, -1, -3, -5},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, -1, -4, -1, 1, -3, -2, -1, -3, 0, 5, -3, -2, 0, -1, 1, 2, 0, -1, -3, -3, -1, -2, 1, -5},
		/* L */ {0, -2, -4, -2, -4, -3, 0, -4, -3, 2, 0, -3, 4, 2, -4, -3, -2, -3, -3, -2, 1, -2, -1, -1, -3, -5},
		/* M */ {0, -1, -3, -2, -3, -2, 0, -3, -2, 1, 0, -2, 2, 6, -2, -3, 0, -2, -2, -1, 1, -2, -1, -1, -2, -5},
		/* N */ {0, -2, 3, -3, 1, 0, -3, -1, 0, -4, 0, 0, -4, -2, 6, -2, 0, -1, 0, 0, -3, -4, -1, -2, 0, -5},
		/* P */ {0, -1, -2, -3, -2, -1, -4, -3, -2, -3, 0, -1, -3, -3, -2, 8, -2, -2, -1, -1, -3, -4, -2, -3, -1, -5},
		/* Q */ {0, -1, 0, -3, -1, 2, -3, -2, 1, -3, 0, 1, -2, 0, 0, -2, 6, 1, 0, -1, -2, -2, -1, -2, 3, -5},
		/* R */ {0, -2, -1, -4, -2, 0, -3, -3, 0, -3, 0, 2, -3, -2, -1, -2, 1, 6, -1, -1, -3, -3, -1, -2, 0, -5},
		/* S */ {0, 1, 0, -1, 0, 0, -3, -1, -1, -3, 0, 0, -3, -2, 0, -1, 0, -1, 4, 1, -2, -3, -1, -2, 0, -5},
		/* T */ {0, 0, -1, -1, -1, -1, -2, -2, -2, -1, 0, -1, -2, -1, 0, -1, -1, -1, 1, 5, 0, -3, -1, -2, -1, -5},
		/* V */ {0, 0, -3, -1, -4, -3, -1, -4, -3, 3, 0, -3, 1, 1, -3, -3, -2, -3, -2, 0, 4, -3, -1, -2, -3, -5},
		/* W */ {0, -3, -4, -3, -5, -4, 1, -3, -2, -3, 0, -3, -2, -2, -4, -4, -2, -3, -3, -3, -3, 11, -3, 2, -3, -5},
		/* X */ {0, -1, -1, -2, -2, -1, -2, -2, -1, -1, 0, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -3, -1, -2, -1, -5},
		/* Y */ {0, -2, -3, -3, -4, -3, 3, -4, 2, -1, 0, -2, -1, -1, -2, -3, -2, -2, -2, -2, -2, 2, -2, 7, -2, -5},
		/* Z */ {0, -1, 0, -4, 1, 4, -4, -2, 0, -3, 0, 1, -3, -2, 0, -1, 3, 0, 0, -1, -3, -3, -1, -2, 4, -5},
		/* * */ {0, -5, -5, -5, -5, -5, -5, -5, -5, -5, 0, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, 1},
	}

	// #  Matrix made by matblas from blosum75.iij
	// #  * column uses minimum score
	// #  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	// #  Blocks Database = /data/blocks_5.0/blocks.dat
	// #  Cluster Percentage: >= 75
	// #  Entropy =   0.9077, Expected =  -0.6845
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  4 -2 -2 -2 -1 -1 -1  0 -2 -2 -2 -1 -1 -3 -1  1  0 -3 -2  0 -2 -1 -1 -5
	// R -2  6 -1 -2 -4  1  0 -3  0 -3 -3  2 -2 -3 -2 -1 -1 -3 -2 -3 -1  0 -1 -5
	// N -2 -1  6  1 -3  0 -1 -1  0 -4 -4  0 -3 -4 -3  0  0 -4 -3 -3  3  0 -1 -5
	// D -2 -2  1  6 -4 -1  1 -2 -1 -4 -4 -1 -4 -4 -2 -1 -1 -5 -4 -4  4  1 -2 -5
	// C -1 -4 -3 -4  9 -3 -5 -3 -4 -1 -2 -4 -2 -2 -4 -1 -1 -3 -3 -1 -4 -4 -2 -5
	// Q -1  1  0 -1 -3  6  2 -2  1 -3 -3  1  0 -4 -2  0 -1 -2 -2 -2  0  3 -1 -5
	// E -1  0 -1  1 -5  2  5 -3  0 -4 -4  1 -2 -4 -1  0 -1 -4 -3 -3  1  4 -1 -5
	// G  0 -3 -1 -2 -3 -2 -3  6 -2 -5 -4 -2 -3 -4 -3 -1 -2 -3 -4 -4 -1 -2 -2 -5
	// H -2  0  0 -1 -4  1  0 -2  8 -4 -3 -1 -2 -2 -2 -1 -2 -2  2 -4 -1  0 -1 -5
	// I -2 -3 -4 -4 -1 -3 -4 -5 -4  4  1 -3  1  0 -3 -3 -1 -3 -2  3 -4 -4 -2 -5
	// L -2 -3 -4 -4 -2 -3 -4 -4 -3  1  4 -3  2  0 -3 -3 -2 -2 -1  1 -4 -3 -1 -5
	// K -1  2  0 -1 -4  1  1 -2 -1 -3 -3  5 -2 -4 -1  0 -1 -4 -2 -3 -1  1 -1 -5
	// M -1 -2 -3 -4 -2  0 -2 -3 -2  1  2 -2  6  0 -3 -2 -1 -2 -2  1 -3 -2 -1 -5
	// F -3 -3 -4 -4 -2 -4 -4 -4 -2  0  0 -4  0  6 -4 -3 -2  1  3 -1 -4 -4 -2 -5
	// P -1 -2 -3 -2 -4 -2 -1 -3 -2 -3 -3 -1 -3 -4  8 -1 -1 -5 -4 -3 -2 -2 -2 -5
	// S  1 -1  0 -1 -1  0  0 -1 -1 -3 -3  0 -2 -3 -1  5  1 -3 -2 -2  0  0 -1 -5
	// T  0 -1  0 -1 -1 -1 -1 -2 -2 -1 -2 -1 -1 -2 -1  1  5 -3 -2  0 -1 -1 -1 -5
	// W -3 -3 -4 -5 -3 -2 -4 -3 -2 -3 -2 -4 -2  1 -5 -3 -3 11  2 -3 -5 -3 -3 -5
	// Y -2 -2 -3 -4 -3 -2 -3 -4  2 -2 -1 -2 -2  3 -4 -2 -2  2  7 -2 -3 -3 -2 -5
	// V  0 -3 -3 -4 -1 -2 -3 -4 -4  3  1 -3  1 -1 -3 -2  0 -3 -2  4 -4 -3 -1 -5
	// B -2 -1  3  4 -4  0  1 -1 -1 -4 -4 -1 -3 -4 -2  0 -1 -5 -3 -4  4  0 -2 -5
	// Z -1  0  0  1 -4  3  4 -2  0 -4 -3  1 -2 -4 -2  0 -1 -3 -3 -3  0  4 -1 -5
	// X -1 -1 -1 -2 -2 -1 -1 -2 -1 -2 -1 -1 -1 -2 -2 -1 -1 -3 -2 -1 -2 -1 -1 -5
	// * -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5  1
	//
	BLOSUM75 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 4, -2, -1, -2, -1, -3, 0, -2, -2, 0, -1, -2, -1, -2, -1, -1, -2, 1, 0, 0, -3, -1, -2, -1, -5},
		/* B */ {0, -2, 4, -4, 4, 1, -4, -1, -1, -4, 0, -1, -4, -3, 3, -2, 0, -1, 0, -1, -4, -5, -2, -3, 0, -5},
		/* C */ {0, -1, -4, 9, -4, -5, -2, -3, -4, -1, 0, -4, -2, -2, -3, -4, -3, -4, -1, -1, -1, -3, -2, -3, -4, -5},
		/* D */ {0, -2, 4, -4, 6, 1, -4, -2, -1, -4, 0, -1, -4, -4, 1, -2, -1, -2, -1, -1, -4, -5, -2, -4, 1, -5},
		/* E */ {0, -1, 1, -5, 1, 5, -4, -3, 0, -4, 0, 1, -4, -2, -1, -1, 2, 0, 0, -1, -3, -4, -1, -3, 4, -5},
		/* F */ {0, -3, -4, -2, -4, -4, 6, -4, -2, 0, 0, -4, 0, 0, -4, -4, -4, -3, -3, -2, -1, 1, -2, 3, -4, -5},
		/* G */ {0, 0, -1, -3, -2, -3, -4, 6, -2, -5, 0, -2, -4, -3, -1, -3, -2, -3, -1, -2, -4, -3, -2, -4, -2, -5},
		/* H */ {0, -2, -1, -4, -1, 0, -2, -2, 8, -4, 0, -1, -3, -2, 0, -2, 1, 0, -1, -2, -4, -2, -1, 2, 0, -5},
		/* I */ {0, -2, -4, -1, -4, -4, 0, -5, -4, 4, 0, -3, 1, 1, -4, -3, -3, -3, -3, -1, 3, -3, -2, -2, -4, -5},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, -1, -4, -1, 1, -4, -2, -1, -3, 0, 5, -3, -2, 0, -1, 1, 2, 0, -1, -3, -4, -1, -2, 1, -5},
		/* L */ {0, -2, -4, -2, -4, -4, 0, -4, -3, 1, 0, -3, 4, 2, -4, -3, -3, -3, -3, -2, 1, -2, -1, -1, -3, -5},
		/* M */ {0, -1, -3, -2, -4, -2, 0, -3, -2, 1, 0, -2, 2, 6, -3, -3, 0, -2, -2, -1, 1, -2, -1, -2, -2, -5},
		/* N */ {0, -2, 3, -3, 1, -1, -4, -1, 0, -4, 0, 0, -4, -3, 6, -3, 0, -1, 0, 0, -3, -4, -1, -3, 0, -5},
		/* P */ {0, -1, -2, -4, -2, -1, -4, -3, -2, -3, 0, -1, -3, -3, -3, 8, -2, -2, -1, -1, -3, -5, -2, -4, -2, -5},
		/* Q */ {0, -1, 0, -3, -1, 2, -4, -2, 1, -3, 0, 1, -3, 0, 0, -2, 6, 1, 0, -1, -2, -2, -1, -2, 3, -5},
		/* R */ {0, -2, -1, -4, -2, 0, -3, -3, 0, -3, 0, 2, -3, -2, -1, -2, 1, 6, -1, -1, -3, -3, -1, -2, 0, -5},
		/* S */ {0, 1, 0, -1, -1, 0, -3, -1, -1, -3, 0, 0, -3, -2, 0, -1, 0, -1, 5, 1, -2, -3, -1, -2, 0, -5},
		/* T */ {0, 0, -1, -1, -1, -1, -2, -2, -2, -1, 0, -1, -2, -1, 0, -1, -1, -1, 1, 5, 0, -3, -1, -2, -1, -5},
		/* V */ {0, 0, -4, -1, -4, -3, -1, -4, -4, 3, 0, -3, 1, 1, -3, -3, -2, -3, -2, 0, 4, -3, -1, -2, -3, -5},
		/* W */ {0, -3, -5, -3, -5, -4, 1, -3, -2, -3, 0, -4, -2, -2, -4, -5, -2, -3, -3, -3, -3, 11, -3, 2, -3, -5},
		/* X */ {0, -1, -2, -2, -2, -1, -2, -2, -1, -2, 0, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -3, -1, -2, -1, -5},
		/* Y */ {0, -2, -3, -3, -4, -3, 3, -4, 2, -2, 0, -2, -1, -2, -3, -4, -2, -2, -2, -2, -2, 2, -2, 7, -3, -5},
		/* Z */ {0, -1, 0, -4, 1, 4, -4, -2, 0, -4, 0, 1, -3, -2, 0, -2, 3, 0, 0, -1, -3, -3, -1, -3, 4, -5},
		/* * */ {0, -5, -5, -5, -5, -5, -5, -5, -5, -5, 0, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, 1},
	}

	// #  Matrix made by matblas from blosum80_3.iij
	// #  * column uses minimum score
	// #  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
	// #  Blocks Database = /data/blocks_5.0/blocks.dat
	// #  Cluster Percentage: >= 80
	// #  Entropy =   0.9868, Expected =  -0.7442
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  7 -3 -3 -3 -1 -2 -2  0 -3 -3 -3 -1 -2 -4 -1  2  0 -5 -4 -1 -3 -2 -1 -8
	// R -3  9 -1 -3 -6  1 -1 -4  0 -5 -4  3 -3 -5 -3 -2 -2 -5 -4 -4 -2  0 -2 -8
	// N -3 -1  9  2 -5  0 -1 -1  1 -6 -6  0 -4 -6 -4  1  0 -7 -4 -5  5 -1 -2 -8
	// D -3 -3  2 10 -7 -1  2 -3 -2 -7 -7 -2 -6 -6 -3 -1 -2 -8 -6 -6  6  1 -3 -8
	// C -1 -6 -5 -7 13 -5 -7 -6 -7 -2 -3 -6 -3 -4 -6 -2 -2 -5 -5 -2 -6 -7 -4 -8
	// Q -2  1  0 -1 -5  9  3 -4  1 -5 -4  2 -1 -5 -3 -1 -1 -4 -3 -4 -1  5 -2 -8
	// E -2 -1 -1  2 -7  3  8 -4  0 -6 -6  1 -4 -6 -2 -1 -2 -6 -5 -4  1  6 -2 -8
	// G  0 -4 -1 -3 -6 -4 -4  9 -4 -7 -7 -3 -5 -6 -5 -1 -3 -6 -6 -6 -2 -4 -3 -8
	// H -3  0  1 -2 -7  1  0 -4 12 -6 -5 -1 -4 -2 -4 -2 -3 -4  3 -5 -1  0 -2 -8
	// I -3 -5 -6 -7 -2 -5 -6 -7 -6  7  2 -5  2 -1 -5 -4 -2 -5 -3  4 -6 -6 -2 -8
	// L -3 -4 -6 -7 -3 -4 -6 -7 -5  2  6 -4  3  0 -5 -4 -3 -4 -2  1 -7 -5 -2 -8
	// K -1  3  0 -2 -6  2  1 -3 -1 -5 -4  8 -3 -5 -2 -1 -1 -6 -4 -4 -1  1 -2 -8
	// M -2 -3 -4 -6 -3 -1 -4 -5 -4  2  3 -3  9  0 -4 -3 -1 -3 -3  1 -5 -3 -2 -8
	// F -4 -5 -6 -6 -4 -5 -6 -6 -2 -1  0 -5  0 10 -6 -4 -4  0  4 -2 -6 -6 -3 -8
	// P -1 -3 -4 -3 -6 -3 -2 -5 -4 -5 -5 -2 -4 -6 12 -2 -3 -7 -6 -4 -4 -2 -3 -8
	// S  2 -2  1 -1 -2 -1 -1 -1 -2 -4 -4 -1 -3 -4 -2  7  2 -6 -3 -3  0 -1 -1 -8
	// T  0 -2  0 -2 -2 -1 -2 -3 -3 -2 -3 -1 -1 -4 -3  2  8 -5 -3  0 -1 -2 -1 -8
	// W -5 -5 -7 -8 -5 -4 -6 -6 -4 -5 -4 -6 -3  0 -7 -6 -5 16  3 -5 -8 -5 -5 -8
	// Y -4 -4 -4 -6 -5 -3 -5 -6  3 -3 -2 -4 -3  4 -6 -3 -3  3 11 -3 -5 -4 -3 -8
	// V -1 -4 -5 -6 -2 -4 -4 -6 -5  4  1 -4  1 -2 -4 -3  0 -5 -3  7 -6 -4 -2 -8
	// B -3 -2  5  6 -6 -1  1 -2 -1 -6 -7 -1 -5 -6 -4  0 -1 -8 -5 -6  6  0 -3 -8
	// Z -2  0 -1  1 -7  5  6 -4  0 -6 -5  1 -3 -6 -2 -1 -2 -5 -4 -4  0  6 -1 -8
	// X -1 -2 -2 -3 -4 -2 -2 -3 -2 -2 -2 -2 -2 -3 -3 -1 -1 -5 -3 -2 -3 -1 -2 -8
	// * -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8  1
	//
	BLOSUM80 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 7, -3, -1, -3, -2, -4, 0, -3, -3, 0, -1, -3, -2, -3, -1, -2, -3, 2, 0, -1, -5, -1, -4, -2, -8},
		/* B */ {0, -3, 6, -6, 6, 1, -6, -2, -1, -6, 0, -1, -7, -5, 5, -4, -1, -2, 0, -1, -6, -8, -3, -5, 0, -8},
		/* C */ {0, -1, -6, 13, -7, -7, -4, -6, -7, -2, 0, -6, -3, -3, -5, -6, -5, -6, -2, -2, -2, -5, -4, -5, -7, -8},
		/* D */ {0, -3, 6, -7, 10, 2, -6, -3, -2, -7, 0, -2, -7, -6, 2, -3, -1, -3, -1, -2, -6, -8, -3, -6, 1, -8},
		/* E */ {0, -2, 1, -7, 2, 8, -6, -4, 0, -6, 0, 1, -6, -4, -1, -2, 3, -1, -1, -2, -4, -6, -2, -5, 6, -8},
		/* F */ {0, -4, -6, -4, -6, -6, 10, -6, -2, -1, 0, -5, 0, 0, -6, -6, -5, -5, -4, -4, -2, 0, -3, 4, -6, -8},
		/* G */ {0, 0, -2, -6, -3, -4, -6, 9, -4, -7, 0, -3, -7, -5, -1, -5, -4, -4, -1, -3, -6, -6, -3, -6, -4, -8},
		/* H */ {0, -3, -1, -7, -2, 0, -2, -4, 12, -6, 0, -1, -5, -4, 1, -4, 1, 0, -2, -3, -5, -4, -2, 3, 0, -8},
		/* I */ {0, -3, -6, -2, -7, -6, -1, -7, -6, 7, 0, -5, 2, 2, -6, -5, -5, -5, -4, -2, 4, -5, -2, -3, -6, -8},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, -1, -6, -2, 1, -5, -3, -1, -5, 0, 8, -4, -3, 0, -2, 2, 3, -1, -1, -4, -6, -2, -4, 1, -8},
		/* L */ {0, -3, -7, -3, -7, -6, 0, -7, -5, 2, 0, -4, 6, 3, -6, -5, -4, -4, -4, -3, 1, -4, -2, -2, -5, -8},
		/* M */ {0, -2, -5, -3, -6, -4, 0, -5, -4, 2, 0, -3, 3, 9, -4, -4, -1, -3, -3, -1, 1, -3, -2, -3, -3, -8},
		/* N */ {0, -3, 5, -5, 2, -1, -6, -1, 1, -6, 0, 0, -6, -4, 9, -4, 0, -1, 1, 0, -5, -7, -2, -4, -1, -8},
		/* P */ {0, -1, -4, -6, -3, -2, -6, -5, -4, -5, 0, -2, -5, -4, -4, 12, -3, -3, -2, -3, -4, -7, -3, -6, -2, -8},
		/* Q */ {0, -2, -1, -5, -1, 3, -5, -4, 1, -5, 0, 2, -4, -1, 0, -3, 9, 1, -1, -1, -4, -4, -2, -3, 5, -8},
		/* R */ {0, -3, -2, -6, -3, -1, -5, -4, 0, -5, 0, 3, -4, -3, -1, -3, 1, 9, -2, -2, -4, -5, -2, -4, 0, -8},
		/* S */ {0, 2, 0, -2, -1, -1, -4, -1, -2, -4, 0, -1, -4, -3, 1, -2, -1, -2, 7, 2, -3, -6, -1, -3, -1, -8},
		/* T */ {0, 0, -1, -2, -2, -2, -4, -3, -3, -2, 0, -1, -3, -1, 0, -3, -1, -2, 2, 8, 0, -5, -1, -3, -2, -8},
		/* V */ {0, -1, -6, -2, -6, -4, -2, -6, -5, 4, 0, -4, 1, 1, -5, -4, -4, -4, -3, 0, 7, -5, -2, -3, -4, -8},
		/* W */ {0, -5, -8, -5, -8, -6, 0, -6, -4, -5, 0, -6, -4, -3, -7, -7, -4, -5, -6, -5, -5, 16, -5, 3, -5, -8},
		/* X */ {0, -1, -3, -4, -3, -2, -3, -3, -2, -2, 0, -2, -2, -2, -2, -3, -2, -2, -1, -1, -2, -5, -2, -3, -1, -8},
		/* Y */ {0, -4, -5, -5, -6, -5, 4, -6, 3, -3, 0, -4, -2, -3, -4, -6, -3, -4, -3, -3, -3, 3, -3, 11, -4, -8},
		/* Z */ {0, -2, 0, -7, 1, 6, -6, -4, 0, -6, 0, 1, -5, -3, -1, -2, 5, 0, -1, -2, -4, -5, -1, -4, 6, -8},
		/* * */ {0, -8, -8, -8, -8, -8, -8, -8, -8, -8, 0, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, 1},
	}

	// #  Matrix made by matblas from blosum85.iij
	// #  * column uses minimum score
	// #  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	// #  Blocks Database = /data/blocks_5.0/blocks.dat
	// #  Cluster Percentage: >= 85
	// #  Entropy =   1.0805, Expected =  -0.8153
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  5 -2 -2 -2 -1 -1 -1  0 -2 -2 -2 -1 -2 -3 -1  1  0 -3 -3 -1 -2 -1 -1 -6
	// R -2  6 -1 -2 -4  1 -1 -3  0 -4 -3  2 -2 -4 -2 -1 -2 -4 -3 -3 -2  0 -2 -6
	// N -2 -1  7  1 -4  0 -1 -1  0 -4 -4  0 -3 -4 -3  0  0 -5 -3 -4  4 -1 -2 -6
	// D -2 -2  1  7 -5 -1  1 -2 -2 -5 -5 -1 -4 -4 -2 -1 -2 -6 -4 -4  4  1 -2 -6
	// C -1 -4 -4 -5  9 -4 -5 -4 -5 -2 -2 -4 -2 -3 -4 -2 -2 -4 -3 -1 -4 -5 -3 -6
	// Q -1  1  0 -1 -4  6  2 -3  1 -4 -3  1  0 -4 -2 -1 -1 -3 -2 -3 -1  4 -1 -6
	// E -1 -1 -1  1 -5  2  6 -3 -1 -4 -4  0 -3 -4 -2 -1 -1 -4 -4 -3  0  4 -1 -6
	// G  0 -3 -1 -2 -4 -3 -3  6 -3 -5 -5 -2 -4 -4 -3 -1 -2 -4 -5 -4 -1 -3 -2 -6
	// H -2  0  0 -2 -5  1 -1 -3  8 -4 -3 -1 -3 -2 -3 -1 -2 -3  2 -4 -1  0 -2 -6
	// I -2 -4 -4 -5 -2 -4 -4 -5 -4  5  1 -3  1 -1 -4 -3 -1 -3 -2  3 -5 -4 -2 -6
	// L -2 -3 -4 -5 -2 -3 -4 -5 -3  1  4 -3  2  0 -4 -3 -2 -3 -2  0 -5 -4 -2 -6
	// K -1  2  0 -1 -4  1  0 -2 -1 -3 -3  6 -2 -4 -2 -1 -1 -5 -3 -3 -1  1 -1 -6
	// M -2 -2 -3 -4 -2  0 -3 -4 -3  1  2 -2  7 -1 -3 -2 -1 -2 -2  0 -4 -2 -1 -6
	// F -3 -4 -4 -4 -3 -4 -4 -4 -2 -1  0 -4 -1  7 -4 -3 -3  0  3 -1 -4 -4 -2 -6
	// P -1 -2 -3 -2 -4 -2 -2 -3 -3 -4 -4 -2 -3 -4  8 -1 -2 -5 -4 -3 -3 -2 -2 -6
	// S  1 -1  0 -1 -2 -1 -1 -1 -1 -3 -3 -1 -2 -3 -1  5  1 -4 -2 -2  0 -1 -1 -6
	// T  0 -2  0 -2 -2 -1 -1 -2 -2 -1 -2 -1 -1 -3 -2  1  5 -4 -2  0 -1 -1 -1 -6
	// W -3 -4 -5 -6 -4 -3 -4 -4 -3 -3 -3 -5 -2  0 -5 -4 -4 11  2 -3 -5 -4 -3 -6
	// Y -3 -3 -3 -4 -3 -2 -4 -5  2 -2 -2 -3 -2  3 -4 -2 -2  2  7 -2 -4 -3 -2 -6
	// V -1 -3 -4 -4 -1 -3 -3 -4 -4  3  0 -3  0 -1 -3 -2  0 -3 -2  5 -4 -3 -1 -6
	// B -2 -2  4  4 -4 -1  0 -1 -1 -5 -5 -1 -4 -4 -3  0 -1 -5 -4 -4  4  0 -2 -6
	// Z -1  0 -1  1 -5  4  4 -3  0 -4 -4  1 -2 -4 -2 -1 -1 -4 -3 -3  0  4 -1 -6
	// X -1 -2 -2 -2 -3 -1 -1 -2 -2 -2 -2 -1 -1 -2 -2 -1 -1 -3 -2 -1 -2 -1 -2 -6
	// * -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6  1
	//
	BLOSUM85 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 5, -2, -1, -2, -1, -3, 0, -2, -2, 0, -1, -2, -2, -2, -1, -1, -2, 1, 0, -1, -3, -1, -3, -1, -6},
		/* B */ {0, -2, 4, -4, 4, 0, -4, -1, -1, -5, 0, -1, -5, -4, 4, -3, -1, -2, 0, -1, -4, -5, -2, -4, 0, -6},
		/* C */ {0, -1, -4, 9, -5, -5, -3, -4, -5, -2, 0, -4, -2, -2, -4, -4, -4, -4, -2, -2, -1, -4, -3, -3, -5, -6},
		/* D */ {0, -2, 4, -5, 7, 1, -4, -2, -2, -5, 0, -1, -5, -4, 1, -2, -1, -2, -1, -2, -4, -6, -2, -4, 1, -6},
		/* E */ {0, -1, 0, -5, 1, 6, -4, -3, -1, -4, 0, 0, -4, -3, -1, -2, 2, -1, -1, -1, -3, -4, -1, -4, 4, -6},
		/* F */ {0, -3, -4, -3, -4, -4, 7, -4, -2, -1, 0, -4, 0, -1, -4, -4, -4, -4, -3, -3, -1, 0, -2, 3, -4, -6},
		/* G */ {0, 0, -1, -4, -2, -3, -4, 6, -3, -5, 0, -2, -5, -4, -1, -3, -3, -3, -1, -2, -4, -4, -2, -5, -3, -6},
		/* H */ {0, -2, -1, -5, -2, -1, -2, -3, 8, -4, 0, -1, -3, -3, 0, -3, 1, 0, -1, -2, -4, -3, -2, 2, 0, -6},
		/* I */ {0, -2, -5, -2, -5, -4, -1, -5, -4, 5, 0, -3, 1, 1, -4, -4, -4, -4, -3, -1, 3, -3, -2, -2, -4, -6},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, -1, -4, -1, 0, -4, -2, -1, -3, 0, 6, -3, -2, 0, -2, 1, 2, -1, -1, -3, -5, -1, -3, 1, -6},
		/* L */ {0, -2, -5, -2, -5, -4, 0, -5, -3, 1, 0, -3, 4, 2, -4, -4, -3, -3, -3, -2, 0, -3, -2, -2, -4, -6},
		/* M */ {0, -2, -4, -2, -4, -3, -1, -4, -3, 1, 0, -2, 2, 7, -3, -3, 0, -2, -2, -1, 0, -2, -1, -2, -2, -6},
		/* N */ {0, -2, 4, -4, 1, -1, -4, -1, 0, -4, 0, 0, -4, -3, 7, -3, 0, -1, 0, 0, -4, -5, -2, -3, -1, -6},
		/* P */ {0, -1, -3, -4, -2, -2, -4, -3, -3, -4, 0, -2, -4, -3, -3, 8, -2, -2, -1, -2, -3, -5, -2, -4, -2, -6},
		/* Q */ {0, -1, -1, -4, -1, 2, -4, -3, 1, -4, 0, 1, -3, 0, 0, -2, 6, 1, -1, -1, -3, -3, -1, -2, 4, -6},
		/* R */ {0, -2, -2, -4, -2, -1, -4, -3, 0, -4, 0, 2, -3, -2, -1, -2, 1, 6, -1, -2, -3, -4, -2, -3, 0, -6},
		/* S */ {0, 1, 0, -2, -1, -1, -3, -1, -1, -3, 0, -1, -3, -2, 0, -1, -1, -1, 5, 1, -2, -4, -1, -2, -1, -6},
		/* T */ {0, 0, -1, -2, -2, -1, -3, -2, -2, -1, 0, -1, -2, -1, 0, -2, -1, -2, 1, 5, 0, -4, -1, -2, -1, -6},
		/* V */ {0, -1, -4, -1, -4, -3, -1, -4, -4, 3, 0, -3, 0, 0, -4, -3, -3, -3, -2, 0, 5, -3, -1, -2, -3, -6},
		/* W */ {0, -3, -5, -4, -6, -4, 0, -4, -3, -3, 0, -5, -3, -2, -5, -5, -3, -4, -4, -4, -3, 11, -3, 2, -4, -6},
		/* X */ {0, -1, -2, -3, -2, -1, -2, -2, -2, -2, 0, -1, -2, -1, -2, -2, -1, -2, -1, -1, -1, -3, -2, -2, -1, -6},
		/* Y */ {0, -3, -4, -3, -4, -4, 3, -5, 2, -2, 0, -3, -2, -2, -3, -4, -2, -3, -2, -2, -2, 2, -2, 7, -3, -6},
		/* Z */ {0, -1, 0, -5, 1, 4, -4, -3, 0, -4, 0, 1, -4, -2, -1, -2, 4, 0, -1, -1, -3, -4, -1, -3, 4, -6},
		/* * */ {0, -6, -6, -6, -6, -6, -6, -6, -6, -6, 0, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, 1},
	}

	// #  Matrix made by matblas from blosum90.iij
	// #  * column uses minimum score
	// #  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	// #  Blocks Database = /data/blocks_5.0/blocks.dat
	// #  Cluster Percentage: >= 90
	// #  Entropy =   1.1806, Expected =  -0.8887
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  5 -2 -2 -3 -1 -1 -1  0 -2 -2 -2 -1 -2 -3 -1  1  0 -4 -3 -1 -2 -1 -1 -6
	// R -2  6 -1 -3 -5  1 -1 -3  0 -4 -3  2 -2 -4 -3 -1 -2 -4 -3 -3 -2  0 -2 -6
	// N -2 -1  7  1 -4  0 -1 -1  0 -4 -4  0 -3 -4 -3  0  0 -5 -3 -4  4 -1 -2 -6
	// D -3 -3  1  7 -5 -1  1 -2 -2 -5 -5 -1 -4 -5 -3 -1 -2 -6 -4 -5  4  0 -2 -6
	// C -1 -5 -4 -5  9 -4 -6 -4 -5 -2 -2 -4 -2 -3 -4 -2 -2 -4 -4 -2 -4 -5 -3 -6
	// Q -1  1  0 -1 -4  7  2 -3  1 -4 -3  1  0 -4 -2 -1 -1 -3 -3 -3 -1  4 -1 -6
	// E -1 -1 -1  1 -6  2  6 -3 -1 -4 -4  0 -3 -5 -2 -1 -1 -5 -4 -3  0  4 -2 -6
	// G  0 -3 -1 -2 -4 -3 -3  6 -3 -5 -5 -2 -4 -5 -3 -1 -3 -4 -5 -5 -2 -3 -2 -6
	// H -2  0  0 -2 -5  1 -1 -3  8 -4 -4 -1 -3 -2 -3 -2 -2 -3  1 -4 -1  0 -2 -6
	// I -2 -4 -4 -5 -2 -4 -4 -5 -4  5  1 -4  1 -1 -4 -3 -1 -4 -2  3 -5 -4 -2 -6
	// L -2 -3 -4 -5 -2 -3 -4 -5 -4  1  5 -3  2  0 -4 -3 -2 -3 -2  0 -5 -4 -2 -6
	// K -1  2  0 -1 -4  1  0 -2 -1 -4 -3  6 -2 -4 -2 -1 -1 -5 -3 -3 -1  1 -1 -6
	// M -2 -2 -3 -4 -2  0 -3 -4 -3  1  2 -2  7 -1 -3 -2 -1 -2 -2  0 -4 -2 -1 -6
	// F -3 -4 -4 -5 -3 -4 -5 -5 -2 -1  0 -4 -1  7 -4 -3 -3  0  3 -2 -4 -4 -2 -6
	// P -1 -3 -3 -3 -4 -2 -2 -3 -3 -4 -4 -2 -3 -4  8 -2 -2 -5 -4 -3 -3 -2 -2 -6
	// S  1 -1  0 -1 -2 -1 -1 -1 -2 -3 -3 -1 -2 -3 -2  5  1 -4 -3 -2  0 -1 -1 -6
	// T  0 -2  0 -2 -2 -1 -1 -3 -2 -1 -2 -1 -1 -3 -2  1  6 -4 -2 -1 -1 -1 -1 -6
	// W -4 -4 -5 -6 -4 -3 -5 -4 -3 -4 -3 -5 -2  0 -5 -4 -4 11  2 -3 -6 -4 -3 -6
	// Y -3 -3 -3 -4 -4 -3 -4 -5  1 -2 -2 -3 -2  3 -4 -3 -2  2  8 -3 -4 -3 -2 -6
	// V -1 -3 -4 -5 -2 -3 -3 -5 -4  3  0 -3  0 -2 -3 -2 -1 -3 -3  5 -4 -3 -2 -6
	// B -2 -2  4  4 -4 -1  0 -2 -1 -5 -5 -1 -4 -4 -3  0 -1 -6 -4 -4  4  0 -2 -6
	// Z -1  0 -1  0 -5  4  4 -3  0 -4 -4  1 -2 -4 -2 -1 -1 -4 -3 -3  0  4 -1 -6
	// X -1 -2 -2 -2 -3 -1 -2 -2 -2 -2 -2 -1 -1 -2 -2 -1 -1 -3 -2 -2 -2 -1 -2 -6
	// * -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6 -6  1
	//
	BLOSUM90 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 5, -2, -1, -3, -1, -3, 0, -2, -2, 0, -1, -2, -2, -2, -1, -1, -2, 1, 0, -1, -4, -1, -3, -1, -6},
		/* B */ {0, -2, 4, -4, 4, 0, -4, -2, -1, -5, 0, -1, -5, -4, 4, -3, -1, -2, 0, -1, -4, -6, -2, -4, 0, -6},
		/* C */ {0, -1, -4, 9, -5, -6, -3, -4, -5, -2, 0, -4, -2, -2, -4, -4, -4, -5, -2, -2, -2, -4, -3, -4, -5, -6},
		/* D */ {0, -3, 4, -5, 7, 1, -5, -2, -2, -5, 0, -1, -5, -4, 1, -3, -1, -3, -1, -2, -5, -6, -2, -4, 0, -6},
		/* E */ {0, -1, 0, -6, 1, 6, -5, -3, -1, -4, 0, 0, -4, -3, -1, -2, 2, -1, -1, -1, -3, -5, -2, -4, 4, -6},
		/* F */ {0, -3, -4, -3, -5, -5, 7, -5, -2, -1, 0, -4, 0, -1, -4, -4, -4, -4, -3, -3, -2, 0, -2, 3, -4, -6},
		/* G */ {0, 0, -2, -4, -2, -3, -5, 6, -3, -5, 0, -2, -5, -4, -1, -3, -3, -3, -1, -3, -5, -4, -2, -5, -3, -6},
		/* H */ {0, -2, -1, -5, -2, -1, -2, -3, 8, -4, 0, -1, -4, -3, 0, -3, 1, 0, -2, -2, -4, -3, -2, 1, 0, -6},
		/* I */ {0, -2, -5, -2, -5, -4, -1, -5, -4, 5, 0, -4, 1, 1, -4, -4, -4, -4, -3, -1, 3, -4, -2, -2, -4, -6},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, -1, -4, -1, 0, -4, -2, -1, -4, 0, 6, -3, -2, 0, -2, 1, 2, -1, -1, -3, -5, -1, -3, 1, -6},
		/* L */ {0, -2, -5, -2, -5, -4, 0, -5, -4, 1, 0, -3, 5, 2, -4, -4, -3, -3, -3, -2, 0, -3, -2, -2, -4, -6},
		/* M */ {0, -2, -4, -2, -4, -3, -1, -4, -3, 1, 0, -2, 2, 7, -3, -3, 0, -2, -2, -1, 0, -2, -1, -2, -2, -6},
		/* N */ {0, -2, 4, -4, 1, -1, -4, -1, 0, -4, 0, 0, -4, -3, 7, -3, 0, -1, 0, 0, -4, -5, -2, -3, -1, -6},
		/* P */ {0, -1, -3, -4, -3, -2, -4, -3, -3, -4, 0, -2, -4, -3, -3, 8, -2, -3, -2, -2, -3, -5, -2, -4, -2, -6},
		/* Q */ {0, -1, -1, -4, -1, 2, -4, -3, 1, -4, 0, 1, -3, 0, 0, -2, 7, 1, -1, -1, -3, -3, -1, -3, 4, -6},
		/* R */ {0, -2, -2, -5, -3, -1, -4, -3, 0, -4, 0, 2, -3, -2, -1, -3, 1, 6, -1, -2, -3, -4, -2, -3, 0, -6},
		/* S */ {0, 1, 0, -2, -1, -1, -3, -1, -2, -3, 0, -1, -3, -2, 0, -2, -1, -1, 5, 1, -2, -4, -1, -3, -1, -6},
		/* T */ {0, 0, -1, -2, -2, -1, -3, -3, -2, -1, 0, -1, -2, -1, 0, -2, -1, -2, 1, 6, -1, -4, -1, -2, -1, -6},
		/* V */ {0, -1, -4, -2, -5, -3, -2, -5, -4, 3, 0, -3, 0, 0, -4, -3, -3, -3, -2, -1, 5, -3, -2, -3, -3, -6},
		/* W */ {0, -4, -6, -4, -6, -5, 0, -4, -3, -4, 0, -5, -3, -2, -5, -5, -3, -4, -4, -4, -3, 11, -3, 2, -4, -6},
		/* X */ {0, -1, -2, -3, -2, -2, -2, -2, -2, -2, 0, -1, -2, -1, -2, -2, -1, -2, -1, -1, -2, -3, -2, -2, -1, -6},
		/* Y */ {0, -3, -4, -4, -4, -4, 3, -5, 1, -2, 0, -3, -2, -2, -3, -4, -3, -3, -3, -2, -3, 2, -2, 8, -3, -6},
		/* Z */ {0, -1, 0, -5, 0, 4, -4, -3, 0, -4, 0, 1, -4, -2, -1, -2, 4, 0, -1, -1, -3, -4, -1, -3, 4, -6},
		/* * */ {0, -6, -6, -6, -6, -6, -6, -6, -6, -6, 0, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, 1},
	}

	// #  Matrix made by matblas from blosumn.iij
	// #  * column uses minimum score
	// #  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	// #  Blocks Database = /data/blocks_5.0/blocks.dat
	// #  Cluster Percentage: >= -2
	// #  Entropy =   1.5172, Expected =  -1.1484
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  6 -2 -2 -3 -2 -1 -2 -1 -3 -3 -3 -2 -2 -4 -1  1 -1 -4 -4 -1 -3 -2 -1 -7
	// R -2  7 -1 -3 -6  0 -2 -4 -1 -5 -4  2 -3 -4 -3 -2 -2 -5 -4 -4 -2 -1 -2 -7
	// N -2 -1  7  1 -4 -1 -1 -2  0 -5 -5 -1 -4 -5 -4  0 -1 -6 -4 -4  4 -1 -2 -7
	// D -3 -3  1  7 -6 -2  1 -3 -2 -6 -6 -2 -5 -5 -3 -2 -2 -7 -5 -5  4  0 -3 -7
	// C -2 -6 -4 -6  9 -5 -7 -5 -6 -2 -3 -5 -3 -3 -5 -2 -2 -5 -4 -2 -5 -6 -4 -7
	// Q -1  0 -1 -2 -5  7  1 -4  0 -4 -3  1 -1 -4 -2 -1 -2 -4 -3 -4 -1  4 -2 -7
	// E -2 -2 -1  1 -7  1  6 -4 -1 -5 -5  0 -4 -5 -3 -1 -2 -5 -4 -4  0  5 -2 -7
	// G -1 -4 -2 -3 -5 -4 -4  6 -4 -6 -6 -3 -5 -5 -4 -1 -3 -5 -6 -5 -2 -4 -3 -7
	// H -3 -1  0 -2 -6  0 -1 -4  9 -5 -4 -2 -3 -3 -4 -2 -3 -4  1 -5 -1 -1 -3 -7
	// I -3 -5 -5 -6 -2 -4 -5 -6 -5  6  1 -4  1 -1 -5 -4 -2 -4 -3  2 -5 -5 -2 -7
	// L -3 -4 -5 -6 -3 -3 -5 -6 -4  1  5 -4  2  0 -5 -4 -3 -4 -3  0 -5 -4 -2 -7
	// K -2  2 -1 -2 -5  1  0 -3 -2 -4 -4  6 -2 -4 -2 -1 -2 -6 -4 -4 -1  0 -2 -7
	// M -2 -3 -4 -5 -3 -1 -4 -5 -3  1  2 -2  8 -1 -4 -3 -2 -2 -3  0 -5 -3 -2 -7
	// F -4 -4 -5 -5 -3 -4 -5 -5 -3 -1  0 -4 -1  7 -5 -4 -3  0  3 -2 -5 -5 -3 -7
	// P -1 -3 -4 -3 -5 -2 -3 -4 -4 -5 -5 -2 -4 -5  8 -2 -3 -5 -5 -4 -4 -3 -3 -7
	// S  1 -2  0 -2 -2 -1 -1 -1 -2 -4 -4 -1 -3 -4 -2  6  1 -4 -3 -3 -1 -1 -1 -7
	// T -1 -2 -1 -2 -2 -2 -2 -3 -3 -2 -3 -2 -2 -3 -3  1  6 -5 -3 -1 -2 -2 -1 -7
	// W -4 -5 -6 -7 -5 -4 -5 -5 -4 -4 -4 -6 -2  0 -5 -4 -5 11  1 -3 -6 -4 -4 -7
	// Y -4 -4 -4 -5 -4 -3 -4 -6  1 -3 -3 -4 -3  3 -5 -3 -3  1  8 -3 -4 -4 -3 -7
	// V -1 -4 -4 -5 -2 -4 -4 -5 -5  2  0 -4  0 -2 -4 -3 -1 -3 -3  5 -5 -4 -2 -7
	// B -3 -2  4  4 -5 -1  0 -2 -1 -5 -5 -1 -5 -5 -4 -1 -2 -6 -4 -5  4  1 -2 -7
	// Z -2 -1 -1  0 -6  4  5 -4 -1 -5 -4  0 -3 -5 -3 -1 -2 -4 -4 -4  1  4 -2 -7
	// X -1 -2 -2 -3 -4 -2 -2 -3 -3 -2 -2 -2 -2 -3 -3 -1 -1 -4 -3 -2 -2 -2 -2 -7
	// * -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7  1
	//
	BLOSUMN = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 6, -3, -2, -3, -2, -4, -1, -3, -3, 0, -2, -3, -2, -2, -1, -1, -2, 1, -1, -1, -4, -1, -4, -2, -7},
		/* B */ {0, -3, 4, -5, 4, 0, -5, -2, -1, -5, 0, -1, -5, -5, 4, -4, -1, -2, -1, -2, -5, -6, -2, -4, 1, -7},
		/* C */ {0, -2, -5, 9, -6, -7, -3, -5, -6, -2, 0, -5, -3, -3, -4, -5, -5, -6, -2, -2, -2, -5, -4, -4, -6, -7},
		/* D */ {0, -3, 4, -6, 7, 1, -5, -3, -2, -6, 0, -2, -6, -5, 1, -3, -2, -3, -2, -2, -5, -7, -3, -5, 0, -7},
		/* E */ {0, -2, 0, -7, 1, 6, -5, -4, -1, -5, 0, 0, -5, -4, -1, -3, 1, -2, -1, -2, -4, -5, -2, -4, 5, -7},
		/* F */ {0, -4, -5, -3, -5, -5, 7, -5, -3, -1, 0, -4, 0, -1, -5, -5, -4, -4, -4, -3, -2, 0, -3, 3, -5, -7},
		/* G */ {0, -1, -2, -5, -3, -4, -5, 6, -4, -6, 0, -3, -6, -5, -2, -4, -4, -4, -1, -3, -5, -5, -3, -6, -4, -7},
		/* H */ {0, -3, -1, -6, -2, -1, -3, -4, 9, -5, 0, -2, -4, -3, 0, -4, 0, -1, -2, -3, -5, -4, -3, 1, -1, -7},
		/* I */ {0, -3, -5, -2, -6, -5, -1, -6, -5, 6, 0, -4, 1, 1, -5, -5, -4, -5, -4, -2, 2, -4, -2, -3, -5, -7},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -2, -1, -5, -2, 0, -4, -3, -2, -4, 0, 6, -4, -2, -1, -2, 1, 2, -1, -2, -4, -6, -2, -4, 0, -7},
		/* L */ {0, -3, -5, -3, -6, -5, 0, -6, -4, 1, 0, -4, 5, 2, -5, -5, -3, -4, -4, -3, 0, -4, -2, -3, -4, -7},
		/* M */ {0, -2, -5, -3, -5, -4, -1, -5, -3, 1, 0, -2, 2, 8, -4, -4, -1, -3, -3, -2, 0, -2, -2, -3, -3, -7},
		/* N */ {0, -2, 4, -4, 1, -1, -5, -2, 0, -5, 0, -1, -5, -4, 7, -4, -1, -1, 0, -1, -4, -6, -2, -4, -1, -7},
		/* P */ {0, -1, -4, -5, -3, -3, -5, -4, -4, -5, 0, -2, -5, -4, -4, 8, -2, -3, -2, -3, -4, -5, -3, -5, -3, -7},
		/* Q */ {0, -1, -1, -5, -2, 1, -4, -4, 0, -4, 0, 1, -3, -1, -1, -2, 7, 0, -1, -2, -4, -4, -2, -3, 4, -7},
		/* R */ {0, -2, -2, -6, -3, -2, -4, -4, -1, -5, 0, 2, -4, -3, -1, -3, 0, 7, -2, -2, -4, -5, -2, -4, -1, -7},
		/* S */ {0, 1, -1, -2, -2, -1, -4, -1, -2, -4, 0, -1, -4, -3, 0, -2, -1, -2, 6, 1, -3, -4, -1, -3, -1, -7},
		/* T */ {0, -1, -2, -2, -2, -2, -3, -3, -3, -2, 0, -2, -3, -2, -1, -3, -2, -2, 1, 6, -1, -5, -1, -3, -2, -7},
		/* V */ {0, -1, -5, -2, -5, -4, -2, -5, -5, 2, 0, -4, 0, 0, -4, -4, -4, -4, -3, -1, 5, -3, -2, -3, -4, -7},
		/* W */ {0, -4, -6, -5, -7, -5, 0, -5, -4, -4, 0, -6, -4, -2, -6, -5, -4, -5, -4, -5, -3, 11, -4, 1, -4, -7},
		/* X */ {0, -1, -2, -4, -3, -2, -3, -3, -3, -2, 0, -2, -2, -2, -2, -3, -2, -2, -1, -1, -2, -4, -2, -3, -2, -7},
		/* Y */ {0, -4, -4, -4, -5, -4, 3, -6, 1, -3, 0, -4, -3, -3, -4, -5, -3, -4, -3, -3, -3, 1, -3, 8, -4, -7},
		/* Z */ {0, -2, 1, -6, 0, 5, -5, -4, -1, -5, 0, 0, -4, -3, -1, -3, 4, -1, -1, -2, -4, -4, -2, -4, 4, -7},
		/* * */ {0, -7, -7, -7, -7, -7, -7, -7, -7, -7, 0, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 10 substitution matrix, scale = ln(2)/2 = 0.346574
	// #
	// # Expected score = -8.27, Entropy = 3.43 bits
	// #
	// # Lowest score = -23, Highest score = 13
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A   7 -10  -7  -6 -10  -7  -5  -4 -11  -8  -9 -10  -8 -12  -4  -3  -3 -20 -11  -5  -6  -6  -6 -23
	// R -10   9  -9 -17 -11  -4 -15 -13  -4  -8 -12  -2  -7 -12  -7  -6 -10  -5 -14 -11 -11  -7  -9 -23
	// N  -7  -9   9  -1 -17  -7  -5  -6  -2  -8 -10  -4 -15 -12  -9  -2  -5 -11  -7 -12   7  -6  -6 -23
	// D  -6 -17  -1   8 -21  -6   0  -6  -7 -11 -19  -8 -17 -21 -12  -7  -8 -21 -17 -11   7  -1  -9 -23
	// C -10 -11 -17 -21  10 -20 -20 -13 -10  -9 -21 -20 -20 -19 -11  -6 -11 -22  -7  -9 -18 -20 -13 -23
	// Q  -7  -4  -7  -6 -20   9  -1 -10  -2 -11  -8  -6  -7 -19  -6  -8  -9 -19 -18 -10  -6   7  -8 -23
	// E  -5 -15  -5   0 -20  -1   8  -7  -9  -8 -13  -7 -10 -20  -9  -7  -9 -23 -11 -10  -1   7  -8 -23
	// G  -4 -13  -6  -6 -13 -10  -7   7 -13 -17 -14 -10 -12 -12 -10  -4 -10 -21 -20  -9  -6  -8  -8 -23
	// H -11  -4  -2  -7 -10  -2  -9 -13  10 -13  -9 -10 -17  -9  -7  -9 -11 -10  -6  -9  -4  -4  -8 -23
	// I  -8  -8  -8 -11  -9 -11  -8 -17 -13   9  -4  -9  -3  -5 -12 -10  -5 -20  -9  -1  -9  -9  -8 -23
	// L  -9 -12 -10 -19 -21  -8 -13 -14  -9  -4   7 -11  -2  -5 -10 -12 -10  -9 -10  -5 -12 -10  -9 -23
	// K -10  -2  -4  -8 -20  -6  -7 -10 -10  -9 -11   7  -4 -20 -10  -7  -6 -18 -12 -13  -5  -6  -8 -23
	// M  -8  -7 -15 -17 -20  -7 -10 -12 -17  -3  -2  -4  12  -7 -11  -8  -7 -19 -17  -4 -16  -8  -9 -23
	// F -12 -12 -12 -21 -19 -19 -20 -12  -9  -5  -5 -20  -7   9 -13  -9 -12  -7  -1 -12 -14 -20 -12 -23
	// P  -4  -7  -9 -12 -11  -6  -9 -10  -7 -12 -10 -10 -11 -13   8  -4  -7 -20 -20  -9 -10  -7  -8 -23
	// S  -3  -6  -2  -7  -6  -8  -7  -4  -9 -10 -12  -7  -8  -9  -4   7  -2  -8 -10 -10  -4  -8  -6 -23
	// T  -3 -10  -5  -8 -11  -9  -9 -10 -11  -5 -10  -6  -7 -12  -7  -2   8 -19  -9  -6  -6  -9  -7 -23
	// W -20  -5 -11 -21 -22 -19 -23 -21 -10 -20  -9 -18 -19  -7 -20  -8 -19  13  -8 -22 -13 -21 -16 -23
	// Y -11 -14  -7 -17  -7 -18 -11 -20  -6  -9 -10 -12 -17  -1 -20 -10  -9  -8  10 -10  -9 -13 -11 -23
	// V  -5 -11 -12 -11  -9 -10 -10  -9  -9  -1  -5 -13  -4 -12  -9 -10  -6 -22 -10   8 -11 -10  -8 -23
	// B  -6 -11   7   7 -18  -6  -1  -6  -4  -9 -12  -5 -16 -14 -10  -4  -6 -13  -9 -11   7  -3  -8 -23
	// Z  -6  -7  -6  -1 -20   7   7  -8  -4  -9 -10  -6  -8 -20  -7  -8  -9 -21 -13 -10  -3   7  -8 -23
	// X  -6  -9  -6  -9 -13  -8  -8  -8  -8  -8  -9  -8  -9 -12  -8  -6  -7 -16 -11  -8  -8  -8  -8 -23
	// * -23 -23 -23 -23 -23 -23 -23 -23 -23 -23 -23 -23 -23 -23 -23 -23 -23 -23 -23 -23 -23 -23 -23   1
	//
	PAM10 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 7, -6, -10, -6, -5, -12, -4, -11, -8, 0, -10, -9, -8, -7, -4, -7, -10, -3, -3, -5, -20, -6, -11, -6, -23},
		/* B */ {0, -6, 7, -18, 7, -1, -14, -6, -4, -9, 0, -5, -12, -16, 7, -10, -6, -11, -4, -6, -11, -13, -8, -9, -3, -23},
		/* C */ {0, -10, -18, 10, -21, -20, -19, -13, -10, -9, 0, -20, -21, -20, -17, -11, -20, -11, -6, -11, -9, -22, -13, -7, -20, -23},
		/* D */ {0, -6, 7, -21, 8, 0, -21, -6, -7, -11, 0, -8, -19, -17, -1, -12, -6, -17, -7, -8, -11, -21, -9, -17, -1, -23},
		/* E */ {0, -5, -1, -20, 0, 8, -20, -7, -9, -8, 0, -7, -13, -10, -5, -9, -1, -15, -7, -9, -10, -23, -8, -11, 7, -23},
		/* F */ {0, -12, -14, -19, -21, -20, 9, -12, -9, -5, 0, -20, -5, -7, -12, -13, -19, -12, -9, -12, -12, -7, -12, -1, -20, -23},
		/* G */ {0, -4, -6, -13, -6, -7, -12, 7, -13, -17, 0, -10, -14, -12, -6, -10, -10, -13, -4, -10, -9, -21, -8, -20, -8, -23},
		/* H */ {0, -11, -4, -10, -7, -9, -9, -13, 10, -13, 0, -10, -9, -17, -2, -7, -2, -4, -9, -11, -9, -10, -8, -6, -4, -23},
		/* I */ {0, -8, -9, -9, -11, -8, -5, -17, -13, 9, 0, -9, -4, -3, -8, -12, -11, -8, -10, -5, -1, -20, -8, -9, -9, -23},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -10, -5, -20, -8, -7, -20, -10, -10, -9, 0, 7, -11, -4, -4, -10, -6, -2, -7, -6, -13, -18, -8, -12, -6, -23},
		/* L */ {0, -9, -12, -21, -19, -13, -5, -14, -9, -4, 0, -11, 7, -2, -10, -10, -8, -12, -12, -10, -5, -9, -9, -10, -10, -23},
		/* M */ {0, -8, -16, -20, -17, -10, -7, -12, -17, -3, 0, -4, -2, 12, -15, -11, -7, -7, -8, -7, -4, -19, -9, -17, -8, -23},
		/* N */ {0, -7, 7, -17, -1, -5, -12, -6, -2, -8, 0, -4, -10, -15, 9, -9, -7, -9, -2, -5, -12, -11, -6, -7, -6, -23},
		/* P */ {0, -4, -10, -11, -12, -9, -13, -10, -7, -12, 0, -10, -10, -11, -9, 8, -6, -7, -4, -7, -9, -20, -8, -20, -7, -23},
		/* Q */ {0, -7, -6, -20, -6, -1, -19, -10, -2, -11, 0, -6, -8, -7, -7, -6, 9, -4, -8, -9, -10, -19, -8, -18, 7, -23},
		/* R */ {0, -10, -11, -11, -17, -15, -12, -13, -4, -8, 0, -2, -12, -7, -9, -7, -4, 9, -6, -10, -11, -5, -9, -14, -7, -23},
		/* S */ {0, -3, -4, -6, -7, -7, -9, -4, -9, -10, 0, -7, -12, -8, -2, -4, -8, -6, 7, -2, -10, -8, -6, -10, -8, -23},
		/* T */ {0, -3, -6, -11, -8, -9, -12, -10, -11, -5, 0, -6, -10, -7, -5, -7, -9, -10, -2, 8, -6, -19, -7, -9, -9, -23},
		/* V */ {0, -5, -11, -9, -11, -10, -12, -9, -9, -1, 0, -13, -5, -4, -12, -9, -10, -11, -10, -6, 8, -22, -8, -10, -10, -23},
		/* W */ {0, -20, -13, -22, -21, -23, -7, -21, -10, -20, 0, -18, -9, -19, -11, -20, -19, -5, -8, -19, -22, 13, -16, -8, -21, -23},
		/* X */ {0, -6, -8, -13, -9, -8, -12, -8, -8, -8, 0, -8, -9, -9, -6, -8, -8, -9, -6, -7, -8, -16, -8, -11, -8, -23},
		/* Y */ {0, -11, -9, -7, -17, -11, -1, -20, -6, -9, 0, -12, -10, -17, -7, -20, -18, -14, -10, -9, -10, -8, -11, 10, -13, -23},
		/* Z */ {0, -6, -3, -20, -1, 7, -20, -8, -4, -9, 0, -6, -10, -8, -6, -7, 7, -7, -8, -9, -10, -21, -8, -13, 7, -23},
		/* * */ {0, -23, -23, -23, -23, -23, -23, -23, -23, -23, 0, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 100 substitution matrix, scale = ln(2)/2 = 0.346574
	// #
	// # Expected score = -1.99, Entropy = 1.18 bits
	// #
	// # Lowest score = -9, Highest score = 12
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  4 -3 -1 -1 -3 -2  0  1 -3 -2 -3 -3 -2 -5  1  1  1 -7 -4  0 -1 -1 -1 -9
	// R -3  7 -2 -4 -5  1 -3 -5  1 -3 -5  2 -1 -6 -1 -1 -3  1 -6 -4 -3 -1 -2 -9
	// N -1 -2  5  3 -5 -1  1 -1  2 -3 -4  1 -4 -5 -2  1  0 -5 -2 -3  4  0 -1 -9
	// D -1 -4  3  5 -7  0  4 -1 -1 -4 -6 -1 -5 -8 -3 -1 -2 -9 -6 -4  4  3 -2 -9
	// C -3 -5 -5 -7  9 -8 -8 -5 -4 -3 -8 -8 -7 -7 -4 -1 -4 -9 -1 -3 -6 -8 -5 -9
	// Q -2  1 -1  0 -8  6  2 -3  3 -4 -2  0 -2 -7 -1 -2 -2 -7 -6 -3  0  5 -2 -9
	// E  0 -3  1  4 -8  2  5 -1 -1 -3 -5 -1 -4 -8 -2 -1 -2 -9 -5 -3  3  4 -2 -9
	// G  1 -5 -1 -1 -5 -3 -1  5 -4 -5 -6 -3 -4 -6 -2  0 -2 -9 -7 -3 -1 -2 -2 -9
	// H -3  1  2 -1 -4  3 -1 -4  7 -4 -3 -2 -4 -3 -1 -2 -3 -4 -1 -3  1  1 -2 -9
	// I -2 -3 -3 -4 -3 -4 -3 -5 -4  6  1 -3  1  0 -4 -3  0 -7 -3  3 -3 -3 -2 -9
	// L -3 -5 -4 -6 -8 -2 -5 -6 -3  1  6 -4  3  0 -4 -4 -3 -3 -3  0 -5 -4 -3 -9
	// K -3  2  1 -1 -8  0 -1 -3 -2 -3 -4  5  0 -7 -3 -1 -1 -6 -6 -4  0 -1 -2 -9
	// M -2 -1 -4 -5 -7 -2 -4 -4 -4  1  3  0  9 -1 -4 -3 -1 -6 -5  1 -4 -2 -2 -9
	// F -5 -6 -5 -8 -7 -7 -8 -6 -3  0  0 -7 -1  8 -6 -4 -5 -1  4 -3 -6 -7 -4 -9
	// P  1 -1 -2 -3 -4 -1 -2 -2 -1 -4 -4 -3 -4 -6  7  0 -1 -7 -7 -3 -3 -1 -2 -9
	// S  1 -1  1 -1 -1 -2 -1  0 -2 -3 -4 -1 -3 -4  0  4  2 -3 -4 -2  0 -2 -1 -9
	// T  1 -3  0 -2 -4 -2 -2 -2 -3  0 -3 -1 -1 -5 -1  2  5 -7 -4  0 -1 -2 -1 -9
	// W -7  1 -5 -9 -9 -7 -9 -9 -4 -7 -3 -6 -6 -1 -7 -3 -7 12 -2 -9 -6 -8 -6 -9
	// Y -4 -6 -2 -6 -1 -6 -5 -7 -1 -3 -3 -6 -5  4 -7 -4 -4 -2  9 -4 -4 -6 -4 -9
	// V  0 -4 -3 -4 -3 -3 -3 -3 -3  3  0 -4  1 -3 -3 -2  0 -9 -4  5 -4 -3 -2 -9
	// B -1 -3  4  4 -6  0  3 -1  1 -3 -5  0 -4 -6 -3  0 -1 -6 -4 -4  4  2 -2 -9
	// Z -1 -1  0  3 -8  5  4 -2  1 -3 -4 -1 -2 -7 -1 -2 -2 -8 -6 -3  2  5 -2 -9
	// X -1 -2 -1 -2 -5 -2 -2 -2 -2 -2 -3 -2 -2 -4 -2 -1 -1 -6 -4 -2 -2 -2 -2 -9
	// * -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9  1
	//
	PAM100 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 4, -1, -3, -1, 0, -5, 1, -3, -2, 0, -3, -3, -2, -1, 1, -2, -3, 1, 1, 0, -7, -1, -4, -1, -9},
		/* B */ {0, -1, 4, -6, 4, 3, -6, -1, 1, -3, 0, 0, -5, -4, 4, -3, 0, -3, 0, -1, -4, -6, -2, -4, 2, -9},
		/* C */ {0, -3, -6, 9, -7, -8, -7, -5, -4, -3, 0, -8, -8, -7, -5, -4, -8, -5, -1, -4, -3, -9, -5, -1, -8, -9},
		/* D */ {0, -1, 4, -7, 5, 4, -8, -1, -1, -4, 0, -1, -6, -5, 3, -3, 0, -4, -1, -2, -4, -9, -2, -6, 3, -9},
		/* E */ {0, 0, 3, -8, 4, 5, -8, -1, -1, -3, 0, -1, -5, -4, 1, -2, 2, -3, -1, -2, -3, -9, -2, -5, 4, -9},
		/* F */ {0, -5, -6, -7, -8, -8, 8, -6, -3, 0, 0, -7, 0, -1, -5, -6, -7, -6, -4, -5, -3, -1, -4, 4, -7, -9},
		/* G */ {0, 1, -1, -5, -1, -1, -6, 5, -4, -5, 0, -3, -6, -4, -1, -2, -3, -5, 0, -2, -3, -9, -2, -7, -2, -9},
		/* H */ {0, -3, 1, -4, -1, -1, -3, -4, 7, -4, 0, -2, -3, -4, 2, -1, 3, 1, -2, -3, -3, -4, -2, -1, 1, -9},
		/* I */ {0, -2, -3, -3, -4, -3, 0, -5, -4, 6, 0, -3, 1, 1, -3, -4, -4, -3, -3, 0, 3, -7, -2, -3, -3, -9},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -3, 0, -8, -1, -1, -7, -3, -2, -3, 0, 5, -4, 0, 1, -3, 0, 2, -1, -1, -4, -6, -2, -6, -1, -9},
		/* L */ {0, -3, -5, -8, -6, -5, 0, -6, -3, 1, 0, -4, 6, 3, -4, -4, -2, -5, -4, -3, 0, -3, -3, -3, -4, -9},
		/* M */ {0, -2, -4, -7, -5, -4, -1, -4, -4, 1, 0, 0, 3, 9, -4, -4, -2, -1, -3, -1, 1, -6, -2, -5, -2, -9},
		/* N */ {0, -1, 4, -5, 3, 1, -5, -1, 2, -3, 0, 1, -4, -4, 5, -2, -1, -2, 1, 0, -3, -5, -1, -2, 0, -9},
		/* P */ {0, 1, -3, -4, -3, -2, -6, -2, -1, -4, 0, -3, -4, -4, -2, 7, -1, -1, 0, -1, -3, -7, -2, -7, -1, -9},
		/* Q */ {0, -2, 0, -8, 0, 2, -7, -3, 3, -4, 0, 0, -2, -2, -1, -1, 6, 1, -2, -2, -3, -7, -2, -6, 5, -9},
		/* R */ {0, -3, -3, -5, -4, -3, -6, -5, 1, -3, 0, 2, -5, -1, -2, -1, 1, 7, -1, -3, -4, 1, -2, -6, -1, -9},
		/* S */ {0, 1, 0, -1, -1, -1, -4, 0, -2, -3, 0, -1, -4, -3, 1, 0, -2, -1, 4, 2, -2, -3, -1, -4, -2, -9},
		/* T */ {0, 1, -1, -4, -2, -2, -5, -2, -3, 0, 0, -1, -3, -1, 0, -1, -2, -3, 2, 5, 0, -7, -1, -4, -2, -9},
		/* V */ {0, 0, -4, -3, -4, -3, -3, -3, -3, 3, 0, -4, 0, 1, -3, -3, -3, -4, -2, 0, 5, -9, -2, -4, -3, -9},
		/* W */ {0, -7, -6, -9, -9, -9, -1, -9, -4, -7, 0, -6, -3, -6, -5, -7, -7, 1, -3, -7, -9, 12, -6, -2, -8, -9},
		/* X */ {0, -1, -2, -5, -2, -2, -4, -2, -2, -2, 0, -2, -3, -2, -1, -2, -2, -2, -1, -1, -2, -6, -2, -4, -2, -9},
		/* Y */ {0, -4, -4, -1, -6, -5, 4, -7, -1, -3, 0, -6, -3, -5, -2, -7, -6, -6, -4, -4, -4, -2, -4, 9, -6, -9},
		/* Z */ {0, -1, 2, -8, 3, 4, -7, -2, 1, -3, 0, -1, -4, -2, 0, -1, 5, -1, -2, -2, -3, -8, -2, -6, 5, -9},
		/* * */ {0, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 110 substitution matrix, scale = ln(2)/2 = 0.346574
	// #
	// # Expected score = -1.81, Entropy = 1.07 bits
	// #
	// # Lowest score = -9, Highest score = 12
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  3 -3 -1 -1 -3 -1  0  1 -3 -1 -3 -3 -2 -4  1  1  1 -7 -4  0 -1 -1 -1 -9
	// R -3  7 -1 -4 -4  1 -3 -4  1 -3 -4  2 -1 -5 -1 -1 -2  1 -5 -4 -2 -1 -2 -9
	// N -1 -1  4  2 -5  0  1  0  2 -2 -4  1 -3 -4 -2  1  0 -5 -2 -3  3  0 -1 -9
	// D -1 -4  2  5 -7  1  4  0  0 -3 -6 -1 -5 -7 -3 -1 -1 -8 -5 -4  4  3 -2 -9
	// C -3 -4 -5 -7  9 -7 -7 -5 -4 -3 -8 -7 -7 -6 -4 -1 -3 -9 -1 -3 -6 -7 -4 -9
	// Q -1  1  0  1 -7  6  2 -3  3 -3 -2  0 -1 -6  0 -2 -2 -6 -6 -3  0  4 -1 -9
	// E  0 -3  1  4 -7  2  5 -1 -1 -3 -5 -1 -3 -7 -2 -1 -2 -9 -5 -3  3  4 -2 -9
	// G  1 -4  0  0 -5 -3 -1  5 -4 -4 -6 -3 -4 -5 -2  0 -2 -8 -7 -2  0 -2 -2 -9
	// H -3  1  2  0 -4  3 -1 -4  7 -4 -3 -2 -4 -3 -1 -2 -3 -4 -1 -3  1  1 -2 -9
	// I -1 -3 -2 -3 -3 -3 -3 -4 -4  6  1 -3  1  0 -4 -3  0 -7 -2  3 -3 -3 -2 -9
	// L -3 -4 -4 -6 -8 -2 -5 -6 -3  1  6 -4  3  0 -4 -4 -3 -3 -3  1 -5 -3 -2 -9
	// K -3  2  1 -1 -7  0 -1 -3 -2 -3 -4  5  0 -7 -3 -1 -1 -5 -5 -4  0 -1 -2 -9
	// M -2 -1 -3 -5 -7 -1 -3 -4 -4  1  3  0  8 -1 -4 -2 -1 -6 -5  1 -4 -2 -2 -9
	// F -4 -5 -4 -7 -6 -6 -7 -5 -3  0  0 -7 -1  8 -6 -4 -4 -1  4 -3 -6 -7 -4 -9
	// P  1 -1 -2 -3 -4  0 -2 -2 -1 -4 -4 -3 -4 -6  6  0 -1 -7 -7 -2 -2 -1 -2 -9
	// S  1 -1  1 -1 -1 -2 -1  0 -2 -3 -4 -1 -2 -4  0  3  2 -3 -3 -2  0 -1 -1 -9
	// T  1 -2  0 -1 -3 -2 -2 -2 -3  0 -3 -1 -1 -4 -1  2  5 -6 -3  0 -1 -2 -1 -9
	// W -7  1 -5 -8 -9 -6 -9 -8 -4 -7 -3 -5 -6 -1 -7 -3 -6 12 -2 -8 -6 -7 -5 -9
	// Y -4 -5 -2 -5 -1 -6 -5 -7 -1 -2 -3 -5 -5  4 -7 -3 -3 -2  8 -4 -3 -5 -3 -9
	// V  0 -4 -3 -4 -3 -3 -3 -2 -3  3  1 -4  1 -3 -2 -2  0 -8 -4  5 -3 -3 -2 -9
	// B -1 -2  3  4 -6  0  3  0  1 -3 -5  0 -4 -6 -2  0 -1 -6 -3 -3  4  2 -1 -9
	// Z -1 -1  0  3 -7  4  4 -2  1 -3 -3 -1 -2 -7 -1 -1 -2 -7 -5 -3  2  4 -2 -9
	// X -1 -2 -1 -2 -4 -1 -2 -2 -2 -2 -2 -2 -2 -4 -2 -1 -1 -5 -3 -2 -1 -2 -2 -9
	// * -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9  1
	//
	PAM110 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 3, -1, -3, -1, 0, -4, 1, -3, -1, 0, -3, -3, -2, -1, 1, -1, -3, 1, 1, 0, -7, -1, -4, -1, -9},
		/* B */ {0, -1, 4, -6, 4, 3, -6, 0, 1, -3, 0, 0, -5, -4, 3, -2, 0, -2, 0, -1, -3, -6, -1, -3, 2, -9},
		/* C */ {0, -3, -6, 9, -7, -7, -6, -5, -4, -3, 0, -7, -8, -7, -5, -4, -7, -4, -1, -3, -3, -9, -4, -1, -7, -9},
		/* D */ {0, -1, 4, -7, 5, 4, -7, 0, 0, -3, 0, -1, -6, -5, 2, -3, 1, -4, -1, -1, -4, -8, -2, -5, 3, -9},
		/* E */ {0, 0, 3, -7, 4, 5, -7, -1, -1, -3, 0, -1, -5, -3, 1, -2, 2, -3, -1, -2, -3, -9, -2, -5, 4, -9},
		/* F */ {0, -4, -6, -6, -7, -7, 8, -5, -3, 0, 0, -7, 0, -1, -4, -6, -6, -5, -4, -4, -3, -1, -4, 4, -7, -9},
		/* G */ {0, 1, 0, -5, 0, -1, -5, 5, -4, -4, 0, -3, -6, -4, 0, -2, -3, -4, 0, -2, -2, -8, -2, -7, -2, -9},
		/* H */ {0, -3, 1, -4, 0, -1, -3, -4, 7, -4, 0, -2, -3, -4, 2, -1, 3, 1, -2, -3, -3, -4, -2, -1, 1, -9},
		/* I */ {0, -1, -3, -3, -3, -3, 0, -4, -4, 6, 0, -3, 1, 1, -2, -4, -3, -3, -3, 0, 3, -7, -2, -2, -3, -9},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -3, 0, -7, -1, -1, -7, -3, -2, -3, 0, 5, -4, 0, 1, -3, 0, 2, -1, -1, -4, -5, -2, -5, -1, -9},
		/* L */ {0, -3, -5, -8, -6, -5, 0, -6, -3, 1, 0, -4, 6, 3, -4, -4, -2, -4, -4, -3, 1, -3, -2, -3, -3, -9},
		/* M */ {0, -2, -4, -7, -5, -3, -1, -4, -4, 1, 0, 0, 3, 8, -3, -4, -1, -1, -2, -1, 1, -6, -2, -5, -2, -9},
		/* N */ {0, -1, 3, -5, 2, 1, -4, 0, 2, -2, 0, 1, -4, -3, 4, -2, 0, -1, 1, 0, -3, -5, -1, -2, 0, -9},
		/* P */ {0, 1, -2, -4, -3, -2, -6, -2, -1, -4, 0, -3, -4, -4, -2, 6, 0, -1, 0, -1, -2, -7, -2, -7, -1, -9},
		/* Q */ {0, -1, 0, -7, 1, 2, -6, -3, 3, -3, 0, 0, -2, -1, 0, 0, 6, 1, -2, -2, -3, -6, -1, -6, 4, -9},
		/* R */ {0, -3, -2, -4, -4, -3, -5, -4, 1, -3, 0, 2, -4, -1, -1, -1, 1, 7, -1, -2, -4, 1, -2, -5, -1, -9},
		/* S */ {0, 1, 0, -1, -1, -1, -4, 0, -2, -3, 0, -1, -4, -2, 1, 0, -2, -1, 3, 2, -2, -3, -1, -3, -1, -9},
		/* T */ {0, 1, -1, -3, -1, -2, -4, -2, -3, 0, 0, -1, -3, -1, 0, -1, -2, -2, 2, 5, 0, -6, -1, -3, -2, -9},
		/* V */ {0, 0, -3, -3, -4, -3, -3, -2, -3, 3, 0, -4, 1, 1, -3, -2, -3, -4, -2, 0, 5, -8, -2, -4, -3, -9},
		/* W */ {0, -7, -6, -9, -8, -9, -1, -8, -4, -7, 0, -5, -3, -6, -5, -7, -6, 1, -3, -6, -8, 12, -5, -2, -7, -9},
		/* X */ {0, -1, -1, -4, -2, -2, -4, -2, -2, -2, 0, -2, -2, -2, -1, -2, -1, -2, -1, -1, -2, -5, -2, -3, -2, -9},
		/* Y */ {0, -4, -3, -1, -5, -5, 4, -7, -1, -2, 0, -5, -3, -5, -2, -7, -6, -5, -3, -3, -4, -2, -3, 8, -5, -9},
		/* Z */ {0, -1, 2, -7, 3, 4, -7, -2, 1, -3, 0, -1, -3, -2, 0, -1, 4, -1, -1, -2, -3, -7, -2, -5, 4, -9},
		/* * */ {0, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 120 substitution matrix, scale = ln(2)/2 = 0.346574
	// #
	// # Expected score = -1.64, Entropy = 0.979 bits
	// #
	// # Lowest score = -8, Highest score = 12
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  3 -3 -1  0 -3 -1  0  1 -3 -1 -3 -2 -2 -4  1  1  1 -7 -4  0  0 -1 -1 -8
	// R -3  6 -1 -3 -4  1 -3 -4  1 -2 -4  2 -1 -5 -1 -1 -2  1 -5 -3 -2 -1 -2 -8
	// N -1 -1  4  2 -5  0  1  0  2 -2 -4  1 -3 -4 -2  1  0 -4 -2 -3  3  0 -1 -8
	// D  0 -3  2  5 -7  1  3  0  0 -3 -5 -1 -4 -7 -3  0 -1 -8 -5 -3  4  3 -2 -8
	// C -3 -4 -5 -7  9 -7 -7 -4 -4 -3 -7 -7 -6 -6 -4  0 -3 -8 -1 -3 -6 -7 -4 -8
	// Q -1  1  0  1 -7  6  2 -3  3 -3 -2  0 -1 -6  0 -2 -2 -6 -5 -3  0  4 -1 -8
	// E  0 -3  1  3 -7  2  5 -1 -1 -3 -4 -1 -3 -7 -2 -1 -2 -8 -5 -3  3  4 -1 -8
	// G  1 -4  0  0 -4 -3 -1  5 -4 -4 -5 -3 -4 -5 -2  1 -1 -8 -6 -2  0 -2 -2 -8
	// H -3  1  2  0 -4  3 -1 -4  7 -4 -3 -2 -4 -3 -1 -2 -3 -3 -1 -3  1  1 -2 -8
	// I -1 -2 -2 -3 -3 -3 -3 -4 -4  6  1 -3  1  0 -3 -2  0 -6 -2  3 -3 -3 -1 -8
	// L -3 -4 -4 -5 -7 -2 -4 -5 -3  1  5 -4  3  0 -3 -4 -3 -3 -2  1 -4 -3 -2 -8
	// K -2  2  1 -1 -7  0 -1 -3 -2 -3 -4  5  0 -7 -2 -1 -1 -5 -5 -4  0 -1 -2 -8
	// M -2 -1 -3 -4 -6 -1 -3 -4 -4  1  3  0  8 -1 -3 -2 -1 -6 -4  1 -4 -2 -2 -8
	// F -4 -5 -4 -7 -6 -6 -7 -5 -3  0  0 -7 -1  8 -5 -3 -4 -1  4 -3 -5 -6 -3 -8
	// P  1 -1 -2 -3 -4  0 -2 -2 -1 -3 -3 -2 -3 -5  6  1 -1 -7 -6 -2 -2 -1 -2 -8
	// S  1 -1  1  0  0 -2 -1  1 -2 -2 -4 -1 -2 -3  1  3  2 -2 -3 -2  0 -1 -1 -8
	// T  1 -2  0 -1 -3 -2 -2 -1 -3  0 -3 -1 -1 -4 -1  2  4 -6 -3  0  0 -2 -1 -8
	// W -7  1 -4 -8 -8 -6 -8 -8 -3 -6 -3 -5 -6 -1 -7 -2 -6 12 -2 -8 -6 -7 -5 -8
	// Y -4 -5 -2 -5 -1 -5 -5 -6 -1 -2 -2 -5 -4  4 -6 -3 -3 -2  8 -3 -3 -5 -3 -8
	// V  0 -3 -3 -3 -3 -3 -3 -2 -3  3  1 -4  1 -3 -2 -2  0 -8 -3  5 -3 -3 -1 -8
	// B  0 -2  3  4 -6  0  3  0  1 -3 -4  0 -4 -5 -2  0  0 -6 -3 -3  4  2 -1 -8
	// Z -1 -1  0  3 -7  4  4 -2  1 -3 -3 -1 -2 -6 -1 -1 -2 -7 -5 -3  2  4 -1 -8
	// X -1 -2 -1 -2 -4 -1 -1 -2 -2 -1 -2 -2 -2 -3 -2 -1 -1 -5 -3 -1 -1 -1 -2 -8
	// * -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8  1
	//
	PAM120 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 3, 0, -3, 0, 0, -4, 1, -3, -1, 0, -2, -3, -2, -1, 1, -1, -3, 1, 1, 0, -7, -1, -4, -1, -8},
		/* B */ {0, 0, 4, -6, 4, 3, -5, 0, 1, -3, 0, 0, -4, -4, 3, -2, 0, -2, 0, 0, -3, -6, -1, -3, 2, -8},
		/* C */ {0, -3, -6, 9, -7, -7, -6, -4, -4, -3, 0, -7, -7, -6, -5, -4, -7, -4, 0, -3, -3, -8, -4, -1, -7, -8},
		/* D */ {0, 0, 4, -7, 5, 3, -7, 0, 0, -3, 0, -1, -5, -4, 2, -3, 1, -3, 0, -1, -3, -8, -2, -5, 3, -8},
		/* E */ {0, 0, 3, -7, 3, 5, -7, -1, -1, -3, 0, -1, -4, -3, 1, -2, 2, -3, -1, -2, -3, -8, -1, -5, 4, -8},
		/* F */ {0, -4, -5, -6, -7, -7, 8, -5, -3, 0, 0, -7, 0, -1, -4, -5, -6, -5, -3, -4, -3, -1, -3, 4, -6, -8},
		/* G */ {0, 1, 0, -4, 0, -1, -5, 5, -4, -4, 0, -3, -5, -4, 0, -2, -3, -4, 1, -1, -2, -8, -2, -6, -2, -8},
		/* H */ {0, -3, 1, -4, 0, -1, -3, -4, 7, -4, 0, -2, -3, -4, 2, -1, 3, 1, -2, -3, -3, -3, -2, -1, 1, -8},
		/* I */ {0, -1, -3, -3, -3, -3, 0, -4, -4, 6, 0, -3, 1, 1, -2, -3, -3, -2, -2, 0, 3, -6, -1, -2, -3, -8},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -2, 0, -7, -1, -1, -7, -3, -2, -3, 0, 5, -4, 0, 1, -2, 0, 2, -1, -1, -4, -5, -2, -5, -1, -8},
		/* L */ {0, -3, -4, -7, -5, -4, 0, -5, -3, 1, 0, -4, 5, 3, -4, -3, -2, -4, -4, -3, 1, -3, -2, -2, -3, -8},
		/* M */ {0, -2, -4, -6, -4, -3, -1, -4, -4, 1, 0, 0, 3, 8, -3, -3, -1, -1, -2, -1, 1, -6, -2, -4, -2, -8},
		/* N */ {0, -1, 3, -5, 2, 1, -4, 0, 2, -2, 0, 1, -4, -3, 4, -2, 0, -1, 1, 0, -3, -4, -1, -2, 0, -8},
		/* P */ {0, 1, -2, -4, -3, -2, -5, -2, -1, -3, 0, -2, -3, -3, -2, 6, 0, -1, 1, -1, -2, -7, -2, -6, -1, -8},
		/* Q */ {0, -1, 0, -7, 1, 2, -6, -3, 3, -3, 0, 0, -2, -1, 0, 0, 6, 1, -2, -2, -3, -6, -1, -5, 4, -8},
		/* R */ {0, -3, -2, -4, -3, -3, -5, -4, 1, -2, 0, 2, -4, -1, -1, -1, 1, 6, -1, -2, -3, 1, -2, -5, -1, -8},
		/* S */ {0, 1, 0, 0, 0, -1, -3, 1, -2, -2, 0, -1, -4, -2, 1, 1, -2, -1, 3, 2, -2, -2, -1, -3, -1, -8},
		/* T */ {0, 1, 0, -3, -1, -2, -4, -1, -3, 0, 0, -1, -3, -1, 0, -1, -2, -2, 2, 4, 0, -6, -1, -3, -2, -8},
		/* V */ {0, 0, -3, -3, -3, -3, -3, -2, -3, 3, 0, -4, 1, 1, -3, -2, -3, -3, -2, 0, 5, -8, -1, -3, -3, -8},
		/* W */ {0, -7, -6, -8, -8, -8, -1, -8, -3, -6, 0, -5, -3, -6, -4, -7, -6, 1, -2, -6, -8, 12, -5, -2, -7, -8},
		/* X */ {0, -1, -1, -4, -2, -1, -3, -2, -2, -1, 0, -2, -2, -2, -1, -2, -1, -2, -1, -1, -1, -5, -2, -3, -1, -8},
		/* Y */ {0, -4, -3, -1, -5, -5, 4, -6, -1, -2, 0, -5, -2, -4, -2, -6, -5, -5, -3, -3, -3, -2, -3, 8, -5, -8},
		/* Z */ {0, -1, 2, -7, 3, 4, -6, -2, 1, -3, 0, -1, -3, -2, 0, -1, 4, -1, -1, -2, -3, -7, -1, -5, 4, -8},
		/* * */ {0, -8, -8, -8, -8, -8, -8, -8, -8, -8, 0, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 120 substitution matrix, scale = 0.0693200
	// #
	// # Expected score = -8.22, Entropy = 0.979 bits
	// #
	// # Lowest score = -42, Highest score = 62
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A  16 -14  -3  -2 -14  -6  -1   3 -13  -6 -14 -12  -9 -21   3   6   6 -33 -20   0  -2  -3  -4 -42
	// R -14  32  -6 -16 -20   3 -14 -20   4 -12 -20  12  -5 -25  -4  -4 -10   4 -26 -17 -11  -4  -9 -42
	// N  -3  -6  20  12 -23  -1   4  -2   8 -12 -18   4 -15 -21  -8   5   1 -22 -10 -15  16   2  -4 -42
	// D  -2 -16  12  25 -33   4  17  -2  -2 -16 -27  -5 -21 -35 -13  -2  -6 -39 -26 -17  20  13  -8 -42
	// C -14 -20 -23 -33  44 -33 -33 -22 -20 -14 -37 -34 -32 -29 -18  -2 -16 -42  -4 -13 -28 -33 -20 -42
	// Q  -6   3  -1   4 -33  28  12 -13  13 -16 -11   0  -7 -30  -2  -8  -9 -30 -26 -14   2  21  -6 -42
	// E  -1 -14   4  17 -33  12  24  -4  -3 -13 -22  -5 -15 -34  -9  -5  -8 -42 -24 -13  13  20  -7 -42
	// G   3 -20  -2  -2 -22 -13  -4  25 -18 -20 -26 -15 -19 -26  -9   3  -7 -39 -32 -11  -2  -8  -9 -42
	// H -13   4   8  -2 -20  13  -3 -18  35 -19 -13  -8 -19 -13  -5  -9 -13 -17  -3 -15   4   6  -8 -42
	// I  -6 -12 -12 -16 -14 -16 -13 -20 -19  28   6 -13   7   1 -17 -12  -1 -32 -11  17 -14 -14  -7 -42
	// L -14 -20 -18 -27 -37 -11 -22 -26 -13   6  27 -19  13   2 -17 -19 -13 -13 -12   3 -22 -16 -11 -42
	// K -12  12   4  -5 -34   0  -5 -15  -8 -13 -19  25   2 -33 -12  -4  -3 -24 -25 -19   0  -3  -8 -42
	// M  -9  -5 -15 -21 -32  -7 -15 -19 -19   7  13   2  40  -4 -16 -11  -6 -28 -21   5 -18 -11  -8 -42
	// F -21 -25 -21 -35 -29 -30 -34 -26 -13   1   2 -33  -4  38 -26 -17 -20  -5  22 -13 -27 -32 -17 -42
	// P   3  -4  -8 -13 -18  -2  -9  -9  -5 -17 -17 -12 -16 -26  31   3  -3 -33 -31 -11 -11  -5  -8 -42
	// S   6  -4   5  -2  -2  -8  -5   3  -9 -12 -19  -4 -11 -17   3  16   8 -12 -16 -10   1  -6  -3 -42
	// T   6 -10   1  -6 -16  -9  -8  -7 -13  -1 -13  -3  -6 -20  -3   8  21 -30 -16  -1  -2  -9  -4 -42
	// W -33   4 -22 -39 -42 -30 -42 -39 -17 -32 -13 -24 -28  -5 -33 -12 -30  62  -8 -38 -29 -35 -25 -42
	// Y -20 -26 -10 -26  -4 -26 -24 -32  -3 -11 -12 -25 -21  22 -31 -16 -16  -8  42 -17 -16 -25 -16 -42
	// V   0 -17 -15 -17 -13 -14 -13 -11 -15  17   3 -19   5 -13 -11 -10  -1 -38 -17  25 -16 -14  -7 -42
	// B  -2 -11  16  20 -28   2  13  -2   4 -14 -22   0 -18 -27 -11   1  -2 -29 -16 -16  18   9  -6 -42
	// Z  -3  -4   2  13 -33  21  20  -8   6 -14 -16  -3 -11 -32  -5  -6  -9 -35 -25 -14   9  21  -7 -42
	// X  -4  -9  -4  -8 -20  -6  -7  -9  -8  -7 -11  -8  -8 -17  -8  -3  -4 -25 -16  -7  -6  -7  -8 -42
	// * -42 -42 -42 -42 -42 -42 -42 -42 -42 -42 -42 -42 -42 -42 -42 -42 -42 -42 -42 -42 -42 -42 -42   1
	//
	PAM120_cdi = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 16, -2, -14, -2, -1, -21, 3, -13, -6, 0, -12, -14, -9, -3, 3, -6, -14, 6, 6, 0, -33, -4, -20, -3, -42},
		/* B */ {0, -2, 18, -28, 20, 13, -27, -2, 4, -14, 0, 0, -22, -18, 16, -11, 2, -11, 1, -2, -16, -29, -6, -16, 9, -42},
		/* C */ {0, -14, -28, 44, -33, -33, -29, -22, -20, -14, 0, -34, -37, -32, -23, -18, -33, -20, -2, -16, -13, -42, -20, -4, -33, -42},
		/* D */ {0, -2, 20, -33, 25, 17, -35, -2, -2, -16, 0, -5, -27, -21, 12, -13, 4, -16, -2, -6, -17, -39, -8, -26, 13, -42},
		/* E */ {0, -1, 13, -33, 17, 24, -34, -4, -3, -13, 0, -5, -22, -15, 4, -9, 12, -14, -5, -8, -13, -42, -7, -24, 20, -42},
		/* F */ {0, -21, -27, -29, -35, -34, 38, -26, -13, 1, 0, -33, 2, -4, -21, -26, -30, -25, -17, -20, -13, -5, -17, 22, -32, -42},
		/* G */ {0, 3, -2, -22, -2, -4, -26, 25, -18, -20, 0, -15, -26, -19, -2, -9, -13, -20, 3, -7, -11, -39, -9, -32, -8, -42},
		/* H */ {0, -13, 4, -20, -2, -3, -13, -18, 35, -19, 0, -8, -13, -19, 8, -5, 13, 4, -9, -13, -15, -17, -8, -3, 6, -42},
		/* I */ {0, -6, -14, -14, -16, -13, 1, -20, -19, 28, 0, -13, 6, 7, -12, -17, -16, -12, -12, -1, 17, -32, -7, -11, -14, -42},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -12, 0, -34, -5, -5, -33, -15, -8, -13, 0, 25, -19, 2, 4, -12, 0, 12, -4, -3, -19, -24, -8, -25, -3, -42},
		/* L */ {0, -14, -22, -37, -27, -22, 2, -26, -13, 6, 0, -19, 27, 13, -18, -17, -11, -20, -19, -13, 3, -13, -11, -12, -16, -42},
		/* M */ {0, -9, -18, -32, -21, -15, -4, -19, -19, 7, 0, 2, 13, 40, -15, -16, -7, -5, -11, -6, 5, -28, -8, -21, -11, -42},
		/* N */ {0, -3, 16, -23, 12, 4, -21, -2, 8, -12, 0, 4, -18, -15, 20, -8, -1, -6, 5, 1, -15, -22, -4, -10, 2, -42},
		/* P */ {0, 3, -11, -18, -13, -9, -26, -9, -5, -17, 0, -12, -17, -16, -8, 31, -2, -4, 3, -3, -11, -33, -8, -31, -5, -42},
		/* Q */ {0, -6, 2, -33, 4, 12, -30, -13, 13, -16, 0, 0, -11, -7, -1, -2, 28, 3, -8, -9, -14, -30, -6, -26, 21, -42},
		/* R */ {0, -14, -11, -20, -16, -14, -25, -20, 4, -12, 0, 12, -20, -5, -6, -4, 3, 32, -4, -10, -17, 4, -9, -26, -4, -42},
		/* S */ {0, 6, 1, -2, -2, -5, -17, 3, -9, -12, 0, -4, -19, -11, 5, 3, -8, -4, 16, 8, -10, -12, -3, -16, -6, -42},
		/* T */ {0, 6, -2, -16, -6, -8, -20, -7, -13, -1, 0, -3, -13, -6, 1, -3, -9, -10, 8, 21, -1, -30, -4, -16, -9, -42},
		/* V */ {0, 0, -16, -13, -17, -13, -13, -11, -15, 17, 0, -19, 3, 5, -15, -11, -14, -17, -10, -1, 25, -38, -7, -17, -14, -42},
		/* W */ {0, -33, -29, -42, -39, -42, -5, -39, -17, -32, 0, -24, -13, -28, -22, -33, -30, 4, -12, -30, -38, 62, -25, -8, -35, -42},
		/* X */ {0, -4, -6, -20, -8, -7, -17, -9, -8, -7, 0, -8, -11, -8, -4, -8, -6, -9, -3, -4, -7, -25, -8, -16, -7, -42},
		/* Y */ {0, -20, -16, -4, -26, -24, 22, -32, -3, -11, 0, -25, -12, -21, -10, -31, -26, -26, -16, -16, -17, -8, -16, 42, -25, -42},
		/* Z */ {0, -3, 9, -33, 13, 20, -32, -8, 6, -14, 0, -3, -16, -11, 2, -5, 21, -4, -6, -9, -14, -35, -7, -25, 21, -42},
		/* * */ {0, -42, -42, -42, -42, -42, -42, -42, -42, -42, 0, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 130 substitution matrix, scale = ln(2)/2 = 0.346574
	// #
	// # Expected score = -1.48, Entropy = 0.895 bits
	// #
	// # Lowest score = -8, Highest score = 12
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  3 -3  0  0 -3 -1  0  1 -2 -1 -3 -2 -2 -4  1  1  1 -6 -4  0  0  0 -1 -8
	// R -3  6 -1 -3 -4  1 -3 -4  1 -2 -4  2 -1 -5 -1 -1 -2  1 -5 -3 -2 -1 -2 -8
	// N  0 -1  4  2 -4  0  1  0  2 -2 -3  1 -3 -4 -1  1  0 -4 -2 -3  3  0 -1 -8
	// D  0 -3  2  5 -6  1  3  0  0 -3 -5 -1 -4 -7 -2  0 -1 -7 -5 -3  4  3 -1 -8
	// C -3 -4 -4 -6  9 -6 -6 -4 -4 -3 -7 -6 -6 -5 -3  0 -3 -8 -1 -2 -5 -6 -4 -8
	// Q -1  1  0  1 -6  5  2 -2  3 -3 -2  0 -1 -6  0 -1 -2 -6 -5 -3  0  4 -1 -8
	// E  0 -3  1  3 -6  2  5 -1  0 -2 -4 -1 -3 -6 -2 -1 -1 -8 -5 -3  2  4 -1 -8
	// G  1 -4  0  0 -4 -2 -1  5 -3 -4 -5 -3 -4 -5 -2  1 -1 -7 -6 -2  0 -1 -2 -8
	// H -2  1  2  0 -4  3  0 -3  7 -3 -3 -1 -3 -2 -1 -2 -2 -3  0 -3  1  1 -1 -8
	// I -1 -2 -2 -3 -3 -3 -2 -4 -3  5  1 -2  2  0 -3 -2  0 -6 -2  3 -3 -3 -1 -8
	// L -3 -4 -3 -5 -7 -2 -4 -5 -3  1  5 -4  3  1 -3 -4 -2 -2 -2  1 -4 -3 -2 -8
	// K -2  2  1 -1 -6  0 -1 -3 -1 -2 -4  5  0 -6 -2 -1  0 -5 -5 -4  0  0 -1 -8
	// M -2 -1 -3 -4 -6 -1 -3 -4 -3  2  3  0  8 -1 -3 -2 -1 -5 -4  1 -3 -2 -1 -8
	// F -4 -5 -4 -7 -5 -6 -6 -5 -2  0  1 -6 -1  7 -5 -3 -4 -1  4 -2 -5 -6 -3 -8
	// P  1 -1 -1 -2 -3  0 -2 -2 -1 -3 -3 -2 -3 -5  6  1 -1 -6 -6 -2 -2 -1 -1 -8
	// S  1 -1  1  0  0 -1 -1  1 -2 -2 -4 -1 -2 -3  1  3  2 -2 -3 -2  0 -1 -1 -8
	// T  1 -2  0 -1 -3 -2 -1 -1 -2  0 -2  0 -1 -4 -1  2  4 -6 -3  0  0 -2 -1 -8
	// W -6  1 -4 -7 -8 -6 -8 -7 -3 -6 -2 -5 -5 -1 -6 -2 -6 12 -1 -7 -5 -7 -5 -8
	// Y -4 -5 -2 -5 -1 -5 -5 -6  0 -2 -2 -5 -4  4 -6 -3 -3 -1  8 -3 -3 -5 -3 -8
	// V  0 -3 -3 -3 -2 -3 -3 -2 -3  3  1 -4  1 -2 -2 -2  0 -7 -3  5 -3 -3 -1 -8
	// B  0 -2  3  4 -5  0  2  0  1 -3 -4  0 -3 -5 -2  0  0 -5 -3 -3  3  2 -1 -8
	// Z  0 -1  0  3 -6  4  4 -1  1 -3 -3  0 -2 -6 -1 -1 -2 -7 -5 -3  2  4 -1 -8
	// X -1 -2 -1 -1 -4 -1 -1 -2 -1 -1 -2 -1 -1 -3 -1 -1 -1 -5 -3 -1 -1 -1 -1 -8
	// * -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8  1
	//
	PAM130 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 3, 0, -3, 0, 0, -4, 1, -2, -1, 0, -2, -3, -2, 0, 1, -1, -3, 1, 1, 0, -6, -1, -4, 0, -8},
		/* B */ {0, 0, 3, -5, 4, 2, -5, 0, 1, -3, 0, 0, -4, -3, 3, -2, 0, -2, 0, 0, -3, -5, -1, -3, 2, -8},
		/* C */ {0, -3, -5, 9, -6, -6, -5, -4, -4, -3, 0, -6, -7, -6, -4, -3, -6, -4, 0, -3, -2, -8, -4, -1, -6, -8},
		/* D */ {0, 0, 4, -6, 5, 3, -7, 0, 0, -3, 0, -1, -5, -4, 2, -2, 1, -3, 0, -1, -3, -7, -1, -5, 3, -8},
		/* E */ {0, 0, 2, -6, 3, 5, -6, -1, 0, -2, 0, -1, -4, -3, 1, -2, 2, -3, -1, -1, -3, -8, -1, -5, 4, -8},
		/* F */ {0, -4, -5, -5, -7, -6, 7, -5, -2, 0, 0, -6, 1, -1, -4, -5, -6, -5, -3, -4, -2, -1, -3, 4, -6, -8},
		/* G */ {0, 1, 0, -4, 0, -1, -5, 5, -3, -4, 0, -3, -5, -4, 0, -2, -2, -4, 1, -1, -2, -7, -2, -6, -1, -8},
		/* H */ {0, -2, 1, -4, 0, 0, -2, -3, 7, -3, 0, -1, -3, -3, 2, -1, 3, 1, -2, -2, -3, -3, -1, 0, 1, -8},
		/* I */ {0, -1, -3, -3, -3, -2, 0, -4, -3, 5, 0, -2, 1, 2, -2, -3, -3, -2, -2, 0, 3, -6, -1, -2, -3, -8},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -2, 0, -6, -1, -1, -6, -3, -1, -2, 0, 5, -4, 0, 1, -2, 0, 2, -1, 0, -4, -5, -1, -5, 0, -8},
		/* L */ {0, -3, -4, -7, -5, -4, 1, -5, -3, 1, 0, -4, 5, 3, -3, -3, -2, -4, -4, -2, 1, -2, -2, -2, -3, -8},
		/* M */ {0, -2, -3, -6, -4, -3, -1, -4, -3, 2, 0, 0, 3, 8, -3, -3, -1, -1, -2, -1, 1, -5, -1, -4, -2, -8},
		/* N */ {0, 0, 3, -4, 2, 1, -4, 0, 2, -2, 0, 1, -3, -3, 4, -1, 0, -1, 1, 0, -3, -4, -1, -2, 0, -8},
		/* P */ {0, 1, -2, -3, -2, -2, -5, -2, -1, -3, 0, -2, -3, -3, -1, 6, 0, -1, 1, -1, -2, -6, -1, -6, -1, -8},
		/* Q */ {0, -1, 0, -6, 1, 2, -6, -2, 3, -3, 0, 0, -2, -1, 0, 0, 5, 1, -1, -2, -3, -6, -1, -5, 4, -8},
		/* R */ {0, -3, -2, -4, -3, -3, -5, -4, 1, -2, 0, 2, -4, -1, -1, -1, 1, 6, -1, -2, -3, 1, -2, -5, -1, -8},
		/* S */ {0, 1, 0, 0, 0, -1, -3, 1, -2, -2, 0, -1, -4, -2, 1, 1, -1, -1, 3, 2, -2, -2, -1, -3, -1, -8},
		/* T */ {0, 1, 0, -3, -1, -1, -4, -1, -2, 0, 0, 0, -2, -1, 0, -1, -2, -2, 2, 4, 0, -6, -1, -3, -2, -8},
		/* V */ {0, 0, -3, -2, -3, -3, -2, -2, -3, 3, 0, -4, 1, 1, -3, -2, -3, -3, -2, 0, 5, -7, -1, -3, -3, -8},
		/* W */ {0, -6, -5, -8, -7, -8, -1, -7, -3, -6, 0, -5, -2, -5, -4, -6, -6, 1, -2, -6, -7, 12, -5, -1, -7, -8},
		/* X */ {0, -1, -1, -4, -1, -1, -3, -2, -1, -1, 0, -1, -2, -1, -1, -1, -1, -2, -1, -1, -1, -5, -1, -3, -1, -8},
		/* Y */ {0, -4, -3, -1, -5, -5, 4, -6, 0, -2, 0, -5, -2, -4, -2, -6, -5, -5, -3, -3, -3, -1, -3, 8, -5, -8},
		/* Z */ {0, 0, 2, -6, 3, 4, -6, -1, 1, -3, 0, 0, -3, -2, 0, -1, 4, -1, -1, -2, -3, -7, -1, -5, 4, -8},
		/* * */ {0, -8, -8, -8, -8, -8, -8, -8, -8, -8, 0, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 140 substitution matrix, scale = ln(2)/2 = 0.346574
	// #
	// # Expected score = -1.35, Entropy = 0.820 bits
	// #
	// # Lowest score = -8, Highest score = 12
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  3 -2  0  0 -2 -1  0  1 -2 -1 -2 -2 -2 -4  1  1  1 -6 -4  0  0  0 -1 -8
	// R -2  6 -1 -3 -4  1 -2 -4  1 -2 -4  3 -1 -5 -1 -1 -2  1 -5 -3 -2 -1 -1 -8
	// N  0 -1  3  2 -4  0  1  0  2 -2 -3  1 -2 -4 -1  1  0 -4 -2 -2  3  1 -1 -8
	// D  0 -3  2  4 -6  1  3  0  0 -3 -5 -1 -4 -6 -2  0 -1 -7 -5 -3  4  3 -1 -8
	// C -2 -4 -4 -6  9 -6 -6 -4 -4 -3 -7 -6 -6 -5 -3  0 -3 -8 -1 -2 -5 -6 -4 -8
	// Q -1  1  0  1 -6  5  2 -2  3 -3 -2  0 -1 -5  0 -1 -2 -5 -5 -2  1  4 -1 -8
	// E  0 -2  1  3 -6  2  4 -1  0 -2 -4 -1 -3 -6 -1 -1 -1 -8 -4 -2  2  4 -1 -8
	// G  1 -4  0  0 -4 -2 -1  5 -3 -4 -5 -3 -3 -5 -1  1 -1 -7 -6 -2  0 -1 -1 -8
	// H -2  1  2  0 -4  3  0 -3  6 -3 -2 -1 -3 -2 -1 -1 -2 -3  0 -3  1  1 -1 -8
	// I -1 -2 -2 -3 -3 -3 -2 -4 -3  5  1 -2  2  0 -3 -2  0 -6 -2  3 -2 -2 -1 -8
	// L -2 -4 -3 -5 -7 -2 -4 -5 -2  1  5 -3  3  1 -3 -3 -2 -2 -2  1 -4 -3 -2 -8
	// K -2  3  1 -1 -6  0 -1 -3 -1 -2 -3  5  0 -6 -2 -1  0 -4 -5 -3  0  0 -1 -8
	// M -2 -1 -2 -4 -6 -1 -3 -3 -3  2  3  0  7 -1 -3 -2 -1 -5 -4  1 -3 -2 -1 -8
	// F -4 -5 -4 -6 -5 -5 -6 -5 -2  0  1 -6 -1  7 -5 -3 -4 -1  4 -2 -5 -6 -3 -8
	// P  1 -1 -1 -2 -3  0 -1 -1 -1 -3 -3 -2 -3 -5  6  1  0 -6 -6 -2 -2 -1 -1 -8
	// S  1 -1  1  0  0 -1 -1  1 -1 -2 -3 -1 -2 -3  1  3  2 -2 -3 -2  0 -1  0 -8
	// T  1 -2  0 -1 -3 -2 -1 -1 -2  0 -2  0 -1 -4  0  2  4 -5 -3  0  0 -1 -1 -8
	// W -6  1 -4 -7 -8 -5 -8 -7 -3 -6 -2 -4 -5 -1 -6 -2 -5 12 -1 -7 -5 -6 -5 -8
	// Y -4 -5 -2 -5 -1 -5 -4 -6  0 -2 -2 -5 -4  4 -6 -3 -3 -1  8 -3 -3 -4 -3 -8
	// V  0 -3 -2 -3 -2 -2 -2 -2 -3  3  1 -3  1 -2 -2 -2  0 -7 -3  5 -3 -2 -1 -8
	// B  0 -2  3  4 -5  1  2  0  1 -2 -4  0 -3 -5 -2  0  0 -5 -3 -3  3  2 -1 -8
	// Z  0 -1  1  3 -6  4  4 -1  1 -2 -3  0 -2 -6 -1 -1 -1 -6 -4 -2  2  4 -1 -8
	// X -1 -1 -1 -1 -4 -1 -1 -1 -1 -1 -2 -1 -1 -3 -1  0 -1 -5 -3 -1 -1 -1 -1 -8
	// * -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8  1
	//
	PAM140 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 3, 0, -2, 0, 0, -4, 1, -2, -1, 0, -2, -2, -2, 0, 1, -1, -2, 1, 1, 0, -6, -1, -4, 0, -8},
		/* B */ {0, 0, 3, -5, 4, 2, -5, 0, 1, -2, 0, 0, -4, -3, 3, -2, 1, -2, 0, 0, -3, -5, -1, -3, 2, -8},
		/* C */ {0, -2, -5, 9, -6, -6, -5, -4, -4, -3, 0, -6, -7, -6, -4, -3, -6, -4, 0, -3, -2, -8, -4, -1, -6, -8},
		/* D */ {0, 0, 4, -6, 4, 3, -6, 0, 0, -3, 0, -1, -5, -4, 2, -2, 1, -3, 0, -1, -3, -7, -1, -5, 3, -8},
		/* E */ {0, 0, 2, -6, 3, 4, -6, -1, 0, -2, 0, -1, -4, -3, 1, -1, 2, -2, -1, -1, -2, -8, -1, -4, 4, -8},
		/* F */ {0, -4, -5, -5, -6, -6, 7, -5, -2, 0, 0, -6, 1, -1, -4, -5, -5, -5, -3, -4, -2, -1, -3, 4, -6, -8},
		/* G */ {0, 1, 0, -4, 0, -1, -5, 5, -3, -4, 0, -3, -5, -3, 0, -1, -2, -4, 1, -1, -2, -7, -1, -6, -1, -8},
		/* H */ {0, -2, 1, -4, 0, 0, -2, -3, 6, -3, 0, -1, -2, -3, 2, -1, 3, 1, -1, -2, -3, -3, -1, 0, 1, -8},
		/* I */ {0, -1, -2, -3, -3, -2, 0, -4, -3, 5, 0, -2, 1, 2, -2, -3, -3, -2, -2, 0, 3, -6, -1, -2, -2, -8},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -2, 0, -6, -1, -1, -6, -3, -1, -2, 0, 5, -3, 0, 1, -2, 0, 3, -1, 0, -3, -4, -1, -5, 0, -8},
		/* L */ {0, -2, -4, -7, -5, -4, 1, -5, -2, 1, 0, -3, 5, 3, -3, -3, -2, -4, -3, -2, 1, -2, -2, -2, -3, -8},
		/* M */ {0, -2, -3, -6, -4, -3, -1, -3, -3, 2, 0, 0, 3, 7, -2, -3, -1, -1, -2, -1, 1, -5, -1, -4, -2, -8},
		/* N */ {0, 0, 3, -4, 2, 1, -4, 0, 2, -2, 0, 1, -3, -2, 3, -1, 0, -1, 1, 0, -2, -4, -1, -2, 1, -8},
		/* P */ {0, 1, -2, -3, -2, -1, -5, -1, -1, -3, 0, -2, -3, -3, -1, 6, 0, -1, 1, 0, -2, -6, -1, -6, -1, -8},
		/* Q */ {0, -1, 1, -6, 1, 2, -5, -2, 3, -3, 0, 0, -2, -1, 0, 0, 5, 1, -1, -2, -2, -5, -1, -5, 4, -8},
		/* R */ {0, -2, -2, -4, -3, -2, -5, -4, 1, -2, 0, 3, -4, -1, -1, -1, 1, 6, -1, -2, -3, 1, -1, -5, -1, -8},
		/* S */ {0, 1, 0, 0, 0, -1, -3, 1, -1, -2, 0, -1, -3, -2, 1, 1, -1, -1, 3, 2, -2, -2, 0, -3, -1, -8},
		/* T */ {0, 1, 0, -3, -1, -1, -4, -1, -2, 0, 0, 0, -2, -1, 0, 0, -2, -2, 2, 4, 0, -5, -1, -3, -1, -8},
		/* V */ {0, 0, -3, -2, -3, -2, -2, -2, -3, 3, 0, -3, 1, 1, -2, -2, -2, -3, -2, 0, 5, -7, -1, -3, -2, -8},
		/* W */ {0, -6, -5, -8, -7, -8, -1, -7, -3, -6, 0, -4, -2, -5, -4, -6, -5, 1, -2, -5, -7, 12, -5, -1, -6, -8},
		/* X */ {0, -1, -1, -4, -1, -1, -3, -1, -1, -1, 0, -1, -2, -1, -1, -1, -1, -1, 0, -1, -1, -5, -1, -3, -1, -8},
		/* Y */ {0, -4, -3, -1, -5, -4, 4, -6, 0, -2, 0, -5, -2, -4, -2, -6, -5, -5, -3, -3, -3, -1, -3, 8, -4, -8},
		/* Z */ {0, 0, 2, -6, 3, 4, -6, -1, 1, -2, 0, 0, -3, -2, 1, -1, 4, -1, -1, -1, -2, -6, -1, -4, 4, -8},
		/* * */ {0, -8, -8, -8, -8, -8, -8, -8, -8, -8, 0, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 150 substitution matrix, scale = ln(2)/2 = 0.346574
	// #
	// # Expected score = -1.25, Entropy = 0.754 bits
	// #
	// # Lowest score = -7, Highest score = 12
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  3 -2  0  0 -2 -1  0  1 -2 -1 -2 -2 -1 -4  1  1  1 -6 -3  0  0  0 -1 -7
	// R -2  6 -1 -2 -4  1 -2 -3  1 -2 -3  3 -1 -4 -1 -1 -2  1 -4 -3 -2  0 -1 -7
	// N  0 -1  3  2 -4  0  1  0  2 -2 -3  1 -2 -4 -1  1  0 -4 -2 -2  3  1 -1 -7
	// D  0 -2  2  4 -6  1  3  0  0 -3 -5 -1 -3 -6 -2  0 -1 -7 -4 -3  3  2 -1 -7
	// C -2 -4 -4 -6  9 -6 -6 -4 -3 -2 -6 -6 -5 -5 -3  0 -3 -7  0 -2 -5 -6 -3 -7
	// Q -1  1  0  1 -6  5  2 -2  3 -3 -2  0 -1 -5  0 -1 -1 -5 -4 -2  1  4 -1 -7
	// E  0 -2  1  3 -6  2  4 -1  0 -2 -4 -1 -2 -6 -1 -1 -1 -7 -4 -2  2  4 -1 -7
	// G  1 -3  0  0 -4 -2 -1  4 -3 -3 -4 -2 -3 -5 -1  1 -1 -7 -5 -2  0 -1 -1 -7
	// H -2  1  2  0 -3  3  0 -3  6 -3 -2 -1 -3 -2 -1 -1 -2 -3  0 -3  1  1 -1 -7
	// I -1 -2 -2 -3 -2 -3 -2 -3 -3  5  1 -2  2  0 -3 -2  0 -5 -2  3 -2 -2 -1 -7
	// L -2 -3 -3 -5 -6 -2 -4 -4 -2  1  5 -3  3  1 -3 -3 -2 -2 -2  1 -4 -3 -2 -7
	// K -2  3  1 -1 -6  0 -1 -2 -1 -2 -3  4  0 -6 -2 -1  0 -4 -4 -3  0  0 -1 -7
	// M -1 -1 -2 -3 -5 -1 -2 -3 -3  2  3  0  7 -1 -3 -2 -1 -5 -3  1 -3 -2 -1 -7
	// F -4 -4 -4 -6 -5 -5 -6 -5 -2  0  1 -6 -1  7 -5 -3 -3 -1  5 -2 -5 -5 -3 -7
	// P  1 -1 -1 -2 -3  0 -1 -1 -1 -3 -3 -2 -3 -5  6  1  0 -6 -5 -2 -2 -1 -1 -7
	// S  1 -1  1  0  0 -1 -1  1 -1 -2 -3 -1 -2 -3  1  2  1 -2 -3 -1  0 -1  0 -7
	// T  1 -2  0 -1 -3 -1 -1 -1 -2  0 -2  0 -1 -3  0  1  4 -5 -3  0  0 -1 -1 -7
	// W -6  1 -4 -7 -7 -5 -7 -7 -3 -5 -2 -4 -5 -1 -6 -2 -5 12 -1 -6 -5 -6 -4 -7
	// Y -3 -4 -2 -4  0 -4 -4 -5  0 -2 -2 -4 -3  5 -5 -3 -3 -1  8 -3 -3 -4 -3 -7
	// V  0 -3 -2 -3 -2 -2 -2 -2 -3  3  1 -3  1 -2 -2 -1  0 -6 -3  4 -2 -2 -1 -7
	// B  0 -2  3  3 -5  1  2  0  1 -2 -4  0 -3 -5 -2  0  0 -5 -3 -2  3  2 -1 -7
	// Z  0  0  1  2 -6  4  4 -1  1 -2 -3  0 -2 -5 -1 -1 -1 -6 -4 -2  2  4 -1 -7
	// X -1 -1 -1 -1 -3 -1 -1 -1 -1 -1 -2 -1 -1 -3 -1  0 -1 -4 -3 -1 -1 -1 -1 -7
	// * -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7  1
	//
	PAM150 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 3, 0, -2, 0, 0, -4, 1, -2, -1, 0, -2, -2, -1, 0, 1, -1, -2, 1, 1, 0, -6, -1, -3, 0, -7},
		/* B */ {0, 0, 3, -5, 3, 2, -5, 0, 1, -2, 0, 0, -4, -3, 3, -2, 1, -2, 0, 0, -2, -5, -1, -3, 2, -7},
		/* C */ {0, -2, -5, 9, -6, -6, -5, -4, -3, -2, 0, -6, -6, -5, -4, -3, -6, -4, 0, -3, -2, -7, -3, 0, -6, -7},
		/* D */ {0, 0, 3, -6, 4, 3, -6, 0, 0, -3, 0, -1, -5, -3, 2, -2, 1, -2, 0, -1, -3, -7, -1, -4, 2, -7},
		/* E */ {0, 0, 2, -6, 3, 4, -6, -1, 0, -2, 0, -1, -4, -2, 1, -1, 2, -2, -1, -1, -2, -7, -1, -4, 4, -7},
		/* F */ {0, -4, -5, -5, -6, -6, 7, -5, -2, 0, 0, -6, 1, -1, -4, -5, -5, -4, -3, -3, -2, -1, -3, 5, -5, -7},
		/* G */ {0, 1, 0, -4, 0, -1, -5, 4, -3, -3, 0, -2, -4, -3, 0, -1, -2, -3, 1, -1, -2, -7, -1, -5, -1, -7},
		/* H */ {0, -2, 1, -3, 0, 0, -2, -3, 6, -3, 0, -1, -2, -3, 2, -1, 3, 1, -1, -2, -3, -3, -1, 0, 1, -7},
		/* I */ {0, -1, -2, -2, -3, -2, 0, -3, -3, 5, 0, -2, 1, 2, -2, -3, -3, -2, -2, 0, 3, -5, -1, -2, -2, -7},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -2, 0, -6, -1, -1, -6, -2, -1, -2, 0, 4, -3, 0, 1, -2, 0, 3, -1, 0, -3, -4, -1, -4, 0, -7},
		/* L */ {0, -2, -4, -6, -5, -4, 1, -4, -2, 1, 0, -3, 5, 3, -3, -3, -2, -3, -3, -2, 1, -2, -2, -2, -3, -7},
		/* M */ {0, -1, -3, -5, -3, -2, -1, -3, -3, 2, 0, 0, 3, 7, -2, -3, -1, -1, -2, -1, 1, -5, -1, -3, -2, -7},
		/* N */ {0, 0, 3, -4, 2, 1, -4, 0, 2, -2, 0, 1, -3, -2, 3, -1, 0, -1, 1, 0, -2, -4, -1, -2, 1, -7},
		/* P */ {0, 1, -2, -3, -2, -1, -5, -1, -1, -3, 0, -2, -3, -3, -1, 6, 0, -1, 1, 0, -2, -6, -1, -5, -1, -7},
		/* Q */ {0, -1, 1, -6, 1, 2, -5, -2, 3, -3, 0, 0, -2, -1, 0, 0, 5, 1, -1, -1, -2, -5, -1, -4, 4, -7},
		/* R */ {0, -2, -2, -4, -2, -2, -4, -3, 1, -2, 0, 3, -3, -1, -1, -1, 1, 6, -1, -2, -3, 1, -1, -4, 0, -7},
		/* S */ {0, 1, 0, 0, 0, -1, -3, 1, -1, -2, 0, -1, -3, -2, 1, 1, -1, -1, 2, 1, -1, -2, 0, -3, -1, -7},
		/* T */ {0, 1, 0, -3, -1, -1, -3, -1, -2, 0, 0, 0, -2, -1, 0, 0, -1, -2, 1, 4, 0, -5, -1, -3, -1, -7},
		/* V */ {0, 0, -2, -2, -3, -2, -2, -2, -3, 3, 0, -3, 1, 1, -2, -2, -2, -3, -1, 0, 4, -6, -1, -3, -2, -7},
		/* W */ {0, -6, -5, -7, -7, -7, -1, -7, -3, -5, 0, -4, -2, -5, -4, -6, -5, 1, -2, -5, -6, 12, -4, -1, -6, -7},
		/* X */ {0, -1, -1, -3, -1, -1, -3, -1, -1, -1, 0, -1, -2, -1, -1, -1, -1, -1, 0, -1, -1, -4, -1, -3, -1, -7},
		/* Y */ {0, -3, -3, 0, -4, -4, 5, -5, 0, -2, 0, -4, -2, -3, -2, -5, -4, -4, -3, -3, -3, -1, -3, 8, -4, -7},
		/* Z */ {0, 0, 2, -6, 2, 4, -5, -1, 1, -2, 0, 0, -3, -2, 1, -1, 4, 0, -1, -1, -2, -6, -1, -4, 4, -7},
		/* * */ {0, -7, -7, -7, -7, -7, -7, -7, -7, -7, 0, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 160 substitution matrix, scale = ln(2)/2 = 0.346574
	// #
	// # Expected score = -1.14, Entropy = 0.694 bits
	// #
	// # Lowest score = -7, Highest score = 12
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  2 -2  0  0 -2 -1  0  1 -2 -1 -2 -2 -1 -3  1  1  1 -5 -3  0  0  0  0 -7
	// R -2  6 -1 -2 -3  1 -2 -3  1 -2 -3  3 -1 -4 -1 -1 -1  1 -4 -3 -1  0 -1 -7
	// N  0 -1  3  2 -4  0  1  0  2 -2 -3  1 -2 -3 -1  1  0 -4 -2 -2  2  1  0 -7
	// D  0 -2  2  4 -5  1  3  0  0 -3 -4  0 -3 -6 -2  0 -1 -6 -4 -3  3  2 -1 -7
	// C -2 -3 -4 -5  9 -5 -5 -3 -3 -2 -6 -5 -5 -5 -3  0 -2 -7  0 -2 -4 -5 -3 -7
	// Q -1  1  0  1 -5  5  2 -2  2 -2 -2  0 -1 -5  0 -1 -1 -5 -4 -2  1  3 -1 -7
	// E  0 -2  1  3 -5  2  4  0  0 -2 -3 -1 -2 -5 -1  0 -1 -7 -4 -2  2  3 -1 -7
	// G  1 -3  0  0 -3 -2  0  4 -3 -3 -4 -2 -3 -4 -1  1 -1 -7 -5 -2  0 -1 -1 -7
	// H -2  1  2  0 -3  2  0 -3  6 -3 -2 -1 -3 -2 -1 -1 -2 -3  0 -2  1  1 -1 -7
	// I -1 -2 -2 -3 -2 -2 -2 -3 -3  5  2 -2  2  0 -2 -2  0 -5 -2  3 -2 -2 -1 -7
	// L -2 -3 -3 -4 -6 -2 -3 -4 -2  2  5 -3  3  1 -3 -3 -2 -2 -2  1 -4 -3 -2 -7
	// K -2  3  1  0 -5  0 -1 -2 -1 -2 -3  4  0 -5 -2 -1  0 -4 -4 -3  0  0 -1 -7
	// M -1 -1 -2 -3 -5 -1 -2 -3 -3  2  3  0  7  0 -2 -2 -1 -4 -3  1 -3 -2 -1 -7
	// F -3 -4 -3 -6 -5 -5 -5 -4 -2  0  1 -5  0  7 -4 -3 -3 -1  5 -2 -4 -5 -3 -7
	// P  1 -1 -1 -2 -3  0 -1 -1 -1 -2 -3 -2 -2 -4  5  1  0 -5 -5 -2 -1 -1 -1 -7
	// S  1 -1  1  0  0 -1  0  1 -1 -2 -3 -1 -2 -3  1  2  1 -2 -3 -1  0 -1  0 -7
	// T  1 -1  0 -1 -2 -1 -1 -1 -2  0 -2  0 -1 -3  0  1  3 -5 -3  0  0 -1  0 -7
	// W -5  1 -4 -6 -7 -5 -7 -7 -3 -5 -2 -4 -4 -1 -5 -2 -5 12 -1 -6 -5 -6 -4 -7
	// Y -3 -4 -2 -4  0 -4 -4 -5  0 -2 -2 -4 -3  5 -5 -3 -3 -1  8 -3 -3 -4 -3 -7
	// V  0 -3 -2 -3 -2 -2 -2 -2 -2  3  1 -3  1 -2 -2 -1  0 -6 -3  4 -2 -2 -1 -7
	// B  0 -1  2  3 -4  1  2  0  1 -2 -4  0 -3 -4 -1  0  0 -5 -3 -2  3  2 -1 -7
	// Z  0  0  1  2 -5  3  3 -1  1 -2 -3  0 -2 -5 -1 -1 -1 -6 -4 -2  2  3 -1 -7
	// X  0 -1  0 -1 -3 -1 -1 -1 -1 -1 -2 -1 -1 -3 -1  0  0 -4 -3 -1 -1 -1 -1 -7
	// * -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7  1
	//
	PAM160 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 2, 0, -2, 0, 0, -3, 1, -2, -1, 0, -2, -2, -1, 0, 1, -1, -2, 1, 1, 0, -5, 0, -3, 0, -7},
		/* B */ {0, 0, 3, -4, 3, 2, -4, 0, 1, -2, 0, 0, -4, -3, 2, -1, 1, -1, 0, 0, -2, -5, -1, -3, 2, -7},
		/* C */ {0, -2, -4, 9, -5, -5, -5, -3, -3, -2, 0, -5, -6, -5, -4, -3, -5, -3, 0, -2, -2, -7, -3, 0, -5, -7},
		/* D */ {0, 0, 3, -5, 4, 3, -6, 0, 0, -3, 0, 0, -4, -3, 2, -2, 1, -2, 0, -1, -3, -6, -1, -4, 2, -7},
		/* E */ {0, 0, 2, -5, 3, 4, -5, 0, 0, -2, 0, -1, -3, -2, 1, -1, 2, -2, 0, -1, -2, -7, -1, -4, 3, -7},
		/* F */ {0, -3, -4, -5, -6, -5, 7, -4, -2, 0, 0, -5, 1, 0, -3, -4, -5, -4, -3, -3, -2, -1, -3, 5, -5, -7},
		/* G */ {0, 1, 0, -3, 0, 0, -4, 4, -3, -3, 0, -2, -4, -3, 0, -1, -2, -3, 1, -1, -2, -7, -1, -5, -1, -7},
		/* H */ {0, -2, 1, -3, 0, 0, -2, -3, 6, -3, 0, -1, -2, -3, 2, -1, 2, 1, -1, -2, -2, -3, -1, 0, 1, -7},
		/* I */ {0, -1, -2, -2, -3, -2, 0, -3, -3, 5, 0, -2, 2, 2, -2, -2, -2, -2, -2, 0, 3, -5, -1, -2, -2, -7},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -2, 0, -5, 0, -1, -5, -2, -1, -2, 0, 4, -3, 0, 1, -2, 0, 3, -1, 0, -3, -4, -1, -4, 0, -7},
		/* L */ {0, -2, -4, -6, -4, -3, 1, -4, -2, 2, 0, -3, 5, 3, -3, -3, -2, -3, -3, -2, 1, -2, -2, -2, -3, -7},
		/* M */ {0, -1, -3, -5, -3, -2, 0, -3, -3, 2, 0, 0, 3, 7, -2, -2, -1, -1, -2, -1, 1, -4, -1, -3, -2, -7},
		/* N */ {0, 0, 2, -4, 2, 1, -3, 0, 2, -2, 0, 1, -3, -2, 3, -1, 0, -1, 1, 0, -2, -4, 0, -2, 1, -7},
		/* P */ {0, 1, -1, -3, -2, -1, -4, -1, -1, -2, 0, -2, -3, -2, -1, 5, 0, -1, 1, 0, -2, -5, -1, -5, -1, -7},
		/* Q */ {0, -1, 1, -5, 1, 2, -5, -2, 2, -2, 0, 0, -2, -1, 0, 0, 5, 1, -1, -1, -2, -5, -1, -4, 3, -7},
		/* R */ {0, -2, -1, -3, -2, -2, -4, -3, 1, -2, 0, 3, -3, -1, -1, -1, 1, 6, -1, -1, -3, 1, -1, -4, 0, -7},
		/* S */ {0, 1, 0, 0, 0, 0, -3, 1, -1, -2, 0, -1, -3, -2, 1, 1, -1, -1, 2, 1, -1, -2, 0, -3, -1, -7},
		/* T */ {0, 1, 0, -2, -1, -1, -3, -1, -2, 0, 0, 0, -2, -1, 0, 0, -1, -1, 1, 3, 0, -5, 0, -3, -1, -7},
		/* V */ {0, 0, -2, -2, -3, -2, -2, -2, -2, 3, 0, -3, 1, 1, -2, -2, -2, -3, -1, 0, 4, -6, -1, -3, -2, -7},
		/* W */ {0, -5, -5, -7, -6, -7, -1, -7, -3, -5, 0, -4, -2, -4, -4, -5, -5, 1, -2, -5, -6, 12, -4, -1, -6, -7},
		/* X */ {0, 0, -1, -3, -1, -1, -3, -1, -1, -1, 0, -1, -2, -1, 0, -1, -1, -1, 0, 0, -1, -4, -1, -3, -1, -7},
		/* Y */ {0, -3, -3, 0, -4, -4, 5, -5, 0, -2, 0, -4, -2, -3, -2, -5, -4, -4, -3, -3, -3, -1, -3, 8, -4, -7},
		/* Z */ {0, 0, 2, -5, 2, 3, -5, -1, 1, -2, 0, 0, -3, -2, 1, -1, 3, 0, -1, -1, -2, -6, -1, -4, 3, -7},
		/* * */ {0, -7, -7, -7, -7, -7, -7, -7, -7, -7, 0, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 160 substitution matrix, scale = 0.0693200
	// #
	// # Expected score = -5.73, Entropy = 0.694 bits
	// #
	// # Lowest score = -35, Highest score = 60
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A  12 -10  -1  -1 -11  -4   0   4  -9  -4 -10  -8  -7 -17   4   5   6 -27 -17   0  -1  -1  -2 -35
	// R -10  28  -3 -11 -17   4  -9 -15   5 -10 -16  13  -3 -21  -3  -3  -7   6 -21 -14  -7  -2  -6 -35
	// N  -1  -3  14  10 -18   1   5   0   8  -9 -15   4 -11 -17  -5   4   2 -19  -9 -11  12   3  -2 -35
	// D  -1 -11  10  20 -26   5  16   0   1 -13 -21  -2 -15 -28  -8  -1  -3 -32 -21 -13  16  12  -5 -35
	// C -11 -17 -18 -26  43 -27 -27 -17 -16 -11 -30 -27 -26 -23 -15  -1 -12 -35  -2 -10 -22 -27 -16 -35
	// Q  -4   4   1   5 -27  23  11  -9  12 -12  -8   1  -5 -24   0  -5  -6 -24 -21 -11   3  17  -4 -35
	// E   0  -9   5  16 -27  11  20  -2   0 -10 -17  -3 -12 -27  -6  -2  -5 -34 -20 -10  12  17  -5 -35
	// G   4 -15   0   0 -17  -9  -2  22 -13 -15 -21 -11 -15 -22  -6   3  -3 -33 -26  -8   0  -5  -6 -35
	// H  -9   5   8   1 -16  12   0 -13  30 -14 -11  -4 -14 -10  -3  -6  -9 -14  -1 -12   4   7  -5 -35
	// I  -4 -10  -9 -13 -11 -12 -10 -15 -14  23   8 -10   8   2 -12  -9   0 -26  -8  16 -11 -11  -5 -35
	// L -10 -16 -15 -21 -30  -8 -17 -21 -11   8  25 -15  14   4 -13 -15 -10 -10  -8   5 -18 -13  -8 -35
	// K  -8  13   4  -2 -27   1  -3 -11  -4 -10 -15  22   2 -26  -8  -3  -1 -19 -21 -14   1  -1  -6 -35
	// M  -7  -3 -11 -15 -26  -5 -12 -15 -14   8  14   2  34  -2 -12  -9  -4 -22 -16   6 -13  -8  -5 -35
	// F -17 -21 -17 -28 -23 -24 -27 -22 -10   2   4 -26  -2  35 -22 -15 -16  -3  23  -9 -22 -26 -13 -35
	// P   4  -3  -5  -8 -15   0  -6  -6  -3 -12 -13  -8 -12 -22  27   3  -1 -27 -25  -8  -7  -3  -5 -35
	// S   5  -3   4  -1  -1  -5  -2   3  -6  -9 -15  -3  -9 -15   3  11   7 -11 -13  -7   2  -4  -2 -35
	// T   6  -7   2  -3 -12  -6  -5  -3  -9   0 -10  -1  -4 -16  -1   7  16 -25 -13   0  -1  -6  -2 -35
	// W -27   6 -19 -32 -35 -24 -34 -33 -14 -26 -10 -19 -22  -3 -27 -11 -25  60  -5 -31 -24 -29 -20 -35
	// Y -17 -21  -9 -21  -2 -21 -20 -26  -1  -8  -8 -21 -16  23 -25 -13 -13  -5  39 -14 -14 -20 -13 -35
	// V   0 -14 -11 -13 -10 -11 -10  -8 -12  16   5 -14   6  -9  -8  -7   0 -31 -14  21 -12 -10  -5 -35
	// B  -1  -7  12  16 -22   3  12   0   4 -11 -18   1 -13 -22  -7   2  -1 -24 -14 -12  15   9  -4 -35
	// Z  -1  -2   3  12 -27  17  17  -5   7 -11 -13  -1  -8 -26  -3  -4  -6 -29 -20 -10   9  17  -4 -35
	// X  -2  -6  -2  -5 -16  -4  -5  -6  -5  -5  -8  -6  -5 -13  -5  -2  -2 -20 -13  -5  -4  -4  -6 -35
	// * -35 -35 -35 -35 -35 -35 -35 -35 -35 -35 -35 -35 -35 -35 -35 -35 -35 -35 -35 -35 -35 -35 -35   1
	//
	PAM160_cdi = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 12, -1, -11, -1, 0, -17, 4, -9, -4, 0, -8, -10, -7, -1, 4, -4, -10, 5, 6, 0, -27, -2, -17, -1, -35},
		/* B */ {0, -1, 15, -22, 16, 12, -22, 0, 4, -11, 0, 1, -18, -13, 12, -7, 3, -7, 2, -1, -12, -24, -4, -14, 9, -35},
		/* C */ {0, -11, -22, 43, -26, -27, -23, -17, -16, -11, 0, -27, -30, -26, -18, -15, -27, -17, -1, -12, -10, -35, -16, -2, -27, -35},
		/* D */ {0, -1, 16, -26, 20, 16, -28, 0, 1, -13, 0, -2, -21, -15, 10, -8, 5, -11, -1, -3, -13, -32, -5, -21, 12, -35},
		/* E */ {0, 0, 12, -27, 16, 20, -27, -2, 0, -10, 0, -3, -17, -12, 5, -6, 11, -9, -2, -5, -10, -34, -5, -20, 17, -35},
		/* F */ {0, -17, -22, -23, -28, -27, 35, -22, -10, 2, 0, -26, 4, -2, -17, -22, -24, -21, -15, -16, -9, -3, -13, 23, -26, -35},
		/* G */ {0, 4, 0, -17, 0, -2, -22, 22, -13, -15, 0, -11, -21, -15, 0, -6, -9, -15, 3, -3, -8, -33, -6, -26, -5, -35},
		/* H */ {0, -9, 4, -16, 1, 0, -10, -13, 30, -14, 0, -4, -11, -14, 8, -3, 12, 5, -6, -9, -12, -14, -5, -1, 7, -35},
		/* I */ {0, -4, -11, -11, -13, -10, 2, -15, -14, 23, 0, -10, 8, 8, -9, -12, -12, -10, -9, 0, 16, -26, -5, -8, -11, -35},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -8, 1, -27, -2, -3, -26, -11, -4, -10, 0, 22, -15, 2, 4, -8, 1, 13, -3, -1, -14, -19, -6, -21, -1, -35},
		/* L */ {0, -10, -18, -30, -21, -17, 4, -21, -11, 8, 0, -15, 25, 14, -15, -13, -8, -16, -15, -10, 5, -10, -8, -8, -13, -35},
		/* M */ {0, -7, -13, -26, -15, -12, -2, -15, -14, 8, 0, 2, 14, 34, -11, -12, -5, -3, -9, -4, 6, -22, -5, -16, -8, -35},
		/* N */ {0, -1, 12, -18, 10, 5, -17, 0, 8, -9, 0, 4, -15, -11, 14, -5, 1, -3, 4, 2, -11, -19, -2, -9, 3, -35},
		/* P */ {0, 4, -7, -15, -8, -6, -22, -6, -3, -12, 0, -8, -13, -12, -5, 27, 0, -3, 3, -1, -8, -27, -5, -25, -3, -35},
		/* Q */ {0, -4, 3, -27, 5, 11, -24, -9, 12, -12, 0, 1, -8, -5, 1, 0, 23, 4, -5, -6, -11, -24, -4, -21, 17, -35},
		/* R */ {0, -10, -7, -17, -11, -9, -21, -15, 5, -10, 0, 13, -16, -3, -3, -3, 4, 28, -3, -7, -14, 6, -6, -21, -2, -35},
		/* S */ {0, 5, 2, -1, -1, -2, -15, 3, -6, -9, 0, -3, -15, -9, 4, 3, -5, -3, 11, 7, -7, -11, -2, -13, -4, -35},
		/* T */ {0, 6, -1, -12, -3, -5, -16, -3, -9, 0, 0, -1, -10, -4, 2, -1, -6, -7, 7, 16, 0, -25, -2, -13, -6, -35},
		/* V */ {0, 0, -12, -10, -13, -10, -9, -8, -12, 16, 0, -14, 5, 6, -11, -8, -11, -14, -7, 0, 21, -31, -5, -14, -10, -35},
		/* W */ {0, -27, -24, -35, -32, -34, -3, -33, -14, -26, 0, -19, -10, -22, -19, -27, -24, 6, -11, -25, -31, 60, -20, -5, -29, -35},
		/* X */ {0, -2, -4, -16, -5, -5, -13, -6, -5, -5, 0, -6, -8, -5, -2, -5, -4, -6, -2, -2, -5, -20, -6, -13, -4, -35},
		/* Y */ {0, -17, -14, -2, -21, -20, 23, -26, -1, -8, 0, -21, -8, -16, -9, -25, -21, -21, -13, -13, -14, -5, -13, 39, -20, -35},
		/* Z */ {0, -1, 9, -27, 12, 17, -26, -5, 7, -11, 0, -1, -13, -8, 3, -3, 17, -2, -4, -6, -10, -29, -4, -20, 17, -35},
		/* * */ {0, -35, -35, -35, -35, -35, -35, -35, -35, -35, 0, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 170 substitution matrix, scale = ln(2)/3 = 0.231049
	// #
	// # Expected score = -1.57, Entropy = 0.640 bits
	// #
	// # Lowest score = -10, Highest score = 18
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A   3  -3   0   0  -3  -1   0   1  -3  -1  -3  -2  -2  -5   1   2   2  -8  -5   0   0   0  -1 -10
	// R  -3   8  -1  -3  -5   1  -2  -4   2  -3  -4   4  -1  -6  -1  -1  -2   2  -6  -4  -2   0  -2 -10
	// N   0  -1   4   3  -5   0   2   0   2  -3  -4   1  -3  -5  -1   1   0  -5  -3  -3   3   1  -1 -10
	// D   0  -3   3   6  -7   2   5   0   0  -4  -6  -1  -4  -8  -2   0  -1  -9  -6  -4   5   4  -1 -10
	// C  -3  -5  -5  -7  13  -8  -8  -5  -5  -3  -9  -8  -7  -6  -4   0  -3 -10   0  -3  -6  -8  -4 -10
	// Q  -1   1   0   2  -8   6   3  -2   4  -3  -2   0  -1  -7   0  -1  -2  -7  -6  -3   1   5  -1 -10
	// E   0  -2   2   5  -8   3   6   0   0  -3  -5  -1  -3  -8  -1  -1  -1 -10  -6  -3   3   5  -1 -10
	// G   1  -4   0   0  -5  -2   0   6  -4  -4  -6  -3  -4  -6  -2   1  -1  -9  -7  -2   0  -1  -2 -10
	// H  -3   2   2   0  -5   4   0  -4   9  -4  -3  -1  -4  -3  -1  -2  -2  -4   0  -3   1   2  -1 -10
	// I  -1  -3  -3  -4  -3  -3  -3  -4  -4   7   2  -3   2   1  -3  -2   0  -7  -2   5  -3  -3  -1 -10
	// L  -3  -4  -4  -6  -9  -2  -5  -6  -3   2   7  -4   4   1  -4  -4  -3  -3  -2   2  -5  -4  -2 -10
	// K  -2   4   1  -1  -8   0  -1  -3  -1  -3  -4   6   1  -8  -2  -1   0  -5  -6  -4   0   0  -2 -10
	// M  -2  -1  -3  -4  -7  -1  -3  -4  -4   2   4   1  10   0  -3  -2  -1  -6  -4   2  -4  -2  -1 -10
	// F  -5  -6  -5  -8  -6  -7  -8  -6  -3   1   1  -8   0  10  -6  -4  -5  -1   7  -2  -6  -7  -4 -10
	// P   1  -1  -1  -2  -4   0  -1  -2  -1  -3  -4  -2  -3  -6   8   1   0  -8  -7  -2  -2  -1  -1 -10
	// S   2  -1   1   0   0  -1  -1   1  -2  -2  -4  -1  -2  -4   1   3   2  -3  -4  -2   1  -1   0 -10
	// T   2  -2   0  -1  -3  -2  -1  -1  -2   0  -3   0  -1  -5   0   2   5  -7  -4   0   0  -1  -1 -10
	// W  -8   2  -5  -9 -10  -7 -10  -9  -4  -7  -3  -5  -6  -1  -8  -3  -7  18  -1  -9  -7  -8  -6 -10
	// Y  -5  -6  -3  -6   0  -6  -6  -7   0  -2  -2  -6  -4   7  -7  -4  -4  -1  12  -4  -4  -6  -4 -10
	// V   0  -4  -3  -4  -3  -3  -3  -2  -3   5   2  -4   2  -2  -2  -2   0  -9  -4   6  -3  -3  -1 -10
	// B   0  -2   3   5  -6   1   3   0   1  -3  -5   0  -4  -6  -2   1   0  -7  -4  -3   4   3  -1 -10
	// Z   0   0   1   4  -8   5   5  -1   2  -3  -4   0  -2  -7  -1  -1  -1  -8  -6  -3   3   5  -1 -10
	// X  -1  -2  -1  -1  -4  -1  -1  -2  -1  -1  -2  -2  -1  -4  -1   0  -1  -6  -4  -1  -1  -1  -2 -10
	// * -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10   1
	//
	PAM170 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 3, 0, -3, 0, 0, -5, 1, -3, -1, 0, -2, -3, -2, 0, 1, -1, -3, 2, 2, 0, -8, -1, -5, 0, -10},
		/* B */ {0, 0, 4, -6, 5, 3, -6, 0, 1, -3, 0, 0, -5, -4, 3, -2, 1, -2, 1, 0, -3, -7, -1, -4, 3, -10},
		/* C */ {0, -3, -6, 13, -7, -8, -6, -5, -5, -3, 0, -8, -9, -7, -5, -4, -8, -5, 0, -3, -3, -10, -4, 0, -8, -10},
		/* D */ {0, 0, 5, -7, 6, 5, -8, 0, 0, -4, 0, -1, -6, -4, 3, -2, 2, -3, 0, -1, -4, -9, -1, -6, 4, -10},
		/* E */ {0, 0, 3, -8, 5, 6, -8, 0, 0, -3, 0, -1, -5, -3, 2, -1, 3, -2, -1, -1, -3, -10, -1, -6, 5, -10},
		/* F */ {0, -5, -6, -6, -8, -8, 10, -6, -3, 1, 0, -8, 1, 0, -5, -6, -7, -6, -4, -5, -2, -1, -4, 7, -7, -10},
		/* G */ {0, 1, 0, -5, 0, 0, -6, 6, -4, -4, 0, -3, -6, -4, 0, -2, -2, -4, 1, -1, -2, -9, -2, -7, -1, -10},
		/* H */ {0, -3, 1, -5, 0, 0, -3, -4, 9, -4, 0, -1, -3, -4, 2, -1, 4, 2, -2, -2, -3, -4, -1, 0, 2, -10},
		/* I */ {0, -1, -3, -3, -4, -3, 1, -4, -4, 7, 0, -3, 2, 2, -3, -3, -3, -3, -2, 0, 5, -7, -1, -2, -3, -10},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -2, 0, -8, -1, -1, -8, -3, -1, -3, 0, 6, -4, 1, 1, -2, 0, 4, -1, 0, -4, -5, -2, -6, 0, -10},
		/* L */ {0, -3, -5, -9, -6, -5, 1, -6, -3, 2, 0, -4, 7, 4, -4, -4, -2, -4, -4, -3, 2, -3, -2, -2, -4, -10},
		/* M */ {0, -2, -4, -7, -4, -3, 0, -4, -4, 2, 0, 1, 4, 10, -3, -3, -1, -1, -2, -1, 2, -6, -1, -4, -2, -10},
		/* N */ {0, 0, 3, -5, 3, 2, -5, 0, 2, -3, 0, 1, -4, -3, 4, -1, 0, -1, 1, 0, -3, -5, -1, -3, 1, -10},
		/* P */ {0, 1, -2, -4, -2, -1, -6, -2, -1, -3, 0, -2, -4, -3, -1, 8, 0, -1, 1, 0, -2, -8, -1, -7, -1, -10},
		/* Q */ {0, -1, 1, -8, 2, 3, -7, -2, 4, -3, 0, 0, -2, -1, 0, 0, 6, 1, -1, -2, -3, -7, -1, -6, 5, -10},
		/* R */ {0, -3, -2, -5, -3, -2, -6, -4, 2, -3, 0, 4, -4, -1, -1, -1, 1, 8, -1, -2, -4, 2, -2, -6, 0, -10},
		/* S */ {0, 2, 1, 0, 0, -1, -4, 1, -2, -2, 0, -1, -4, -2, 1, 1, -1, -1, 3, 2, -2, -3, 0, -4, -1, -10},
		/* T */ {0, 2, 0, -3, -1, -1, -5, -1, -2, 0, 0, 0, -3, -1, 0, 0, -2, -2, 2, 5, 0, -7, -1, -4, -1, -10},
		/* V */ {0, 0, -3, -3, -4, -3, -2, -2, -3, 5, 0, -4, 2, 2, -3, -2, -3, -4, -2, 0, 6, -9, -1, -4, -3, -10},
		/* W */ {0, -8, -7, -10, -9, -10, -1, -9, -4, -7, 0, -5, -3, -6, -5, -8, -7, 2, -3, -7, -9, 18, -6, -1, -8, -10},
		/* X */ {0, -1, -1, -4, -1, -1, -4, -2, -1, -1, 0, -2, -2, -1, -1, -1, -1, -2, 0, -1, -1, -6, -2, -4, -1, -10},
		/* Y */ {0, -5, -4, 0, -6, -6, 7, -7, 0, -2, 0, -6, -2, -4, -3, -7, -6, -6, -4, -4, -4, -1, -4, 12, -6, -10},
		/* Z */ {0, 0, 3, -8, 4, 5, -7, -1, 2, -3, 0, 0, -4, -2, 1, -1, 5, 0, -1, -1, -3, -8, -1, -6, 5, -10},
		/* * */ {0, -10, -10, -10, -10, -10, -10, -10, -10, -10, 0, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 180 substitution matrix, scale = ln(2)/3 = 0.231049
	// #
	// # Expected score = -1.51, Entropy = 0.591 bits
	// #
	// # Lowest score = -10, Highest score = 18
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A   3  -3   0   0  -3  -1   0   1  -2  -1  -3  -2  -2  -5   1   1   2  -8  -5   0   0   0  -1 -10
	// R  -3   8  -1  -3  -5   1  -2  -4   2  -3  -4   4  -1  -6  -1  -1  -2   2  -6  -4  -2   0  -2 -10
	// N   0  -1   4   3  -5   0   2   0   2  -3  -4   1  -3  -5  -1   1   0  -5  -2  -3   3   1  -1 -10
	// D   0  -3   3   5  -7   2   4   0   0  -3  -6   0  -4  -8  -2   0  -1  -9  -6  -3   4   3  -1 -10
	// C  -3  -5  -5  -7  13  -7  -7  -5  -4  -3  -8  -7  -7  -6  -4   0  -3 -10   0  -3  -6  -7  -4 -10
	// Q  -1   1   0   2  -7   6   3  -2   4  -3  -2   0  -1  -6   0  -1  -2  -6  -6  -3   1   5  -1 -10
	// E   0  -2   2   4  -7   3   5   0   0  -3  -5  -1  -3  -7  -1  -1  -1  -9  -6  -3   3   5  -1 -10
	// G   1  -4   0   0  -5  -2   0   6  -3  -4  -6  -3  -4  -6  -1   1  -1  -9  -7  -2   0  -1  -2 -10
	// H  -2   2   2   0  -4   4   0  -3   8  -4  -3  -1  -3  -3  -1  -2  -2  -4   0  -3   1   2  -1 -10
	// I  -1  -3  -3  -3  -3  -3  -3  -4  -4   6   2  -3   2   1  -3  -2   0  -7  -2   5  -3  -3  -1 -10
	// L  -3  -4  -4  -6  -8  -2  -5  -6  -3   2   7  -4   4   1  -4  -4  -3  -3  -2   2  -5  -3  -2 -10
	// K  -2   4   1   0  -7   0  -1  -3  -1  -3  -4   6   1  -7  -2  -1   0  -5  -6  -4   0   0  -1 -10
	// M  -2  -1  -3  -4  -7  -1  -3  -4  -3   2   4   1   9   0  -3  -2  -1  -6  -4   2  -3  -2  -1 -10
	// F  -5  -6  -5  -8  -6  -6  -7  -6  -3   1   1  -7   0  10  -6  -4  -4   0   7  -2  -6  -7  -3 -10
	// P   1  -1  -1  -2  -4   0  -1  -1  -1  -3  -4  -2  -3  -6   8   1   0  -7  -7  -2  -2  -1  -1 -10
	// S   1  -1   1   0   0  -1  -1   1  -2  -2  -4  -1  -2  -4   1   3   2  -3  -4  -2   1  -1   0 -10
	// T   2  -2   0  -1  -3  -2  -1  -1  -2   0  -3   0  -1  -4   0   2   4  -7  -4   0   0  -1  -1 -10
	// W  -8   2  -5  -9 -10  -6  -9  -9  -4  -7  -3  -5  -6   0  -7  -3  -7  18  -1  -8  -7  -8  -6 -10
	// Y  -5  -6  -2  -6   0  -6  -6  -7   0  -2  -2  -6  -4   7  -7  -4  -4  -1  11  -4  -4  -6  -3 -10
	// V   0  -4  -3  -3  -3  -3  -3  -2  -3   5   2  -4   2  -2  -2  -2   0  -8  -4   6  -3  -3  -1 -10
	// B   0  -2   3   4  -6   1   3   0   1  -3  -5   0  -3  -6  -2   1   0  -7  -4  -3   4   3  -1 -10
	// Z   0   0   1   3  -7   5   5  -1   2  -3  -3   0  -2  -7  -1  -1  -1  -8  -6  -3   3   5  -1 -10
	// X  -1  -2  -1  -1  -4  -1  -1  -2  -1  -1  -2  -1  -1  -3  -1   0  -1  -6  -3  -1  -1  -1  -1 -10
	// * -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10   1
	//
	PAM180 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 3, 0, -3, 0, 0, -5, 1, -2, -1, 0, -2, -3, -2, 0, 1, -1, -3, 1, 2, 0, -8, -1, -5, 0, -10},
		/* B */ {0, 0, 4, -6, 4, 3, -6, 0, 1, -3, 0, 0, -5, -3, 3, -2, 1, -2, 1, 0, -3, -7, -1, -4, 3, -10},
		/* C */ {0, -3, -6, 13, -7, -7, -6, -5, -4, -3, 0, -7, -8, -7, -5, -4, -7, -5, 0, -3, -3, -10, -4, 0, -7, -10},
		/* D */ {0, 0, 4, -7, 5, 4, -8, 0, 0, -3, 0, 0, -6, -4, 3, -2, 2, -3, 0, -1, -3, -9, -1, -6, 3, -10},
		/* E */ {0, 0, 3, -7, 4, 5, -7, 0, 0, -3, 0, -1, -5, -3, 2, -1, 3, -2, -1, -1, -3, -9, -1, -6, 5, -10},
		/* F */ {0, -5, -6, -6, -8, -7, 10, -6, -3, 1, 0, -7, 1, 0, -5, -6, -6, -6, -4, -4, -2, 0, -3, 7, -7, -10},
		/* G */ {0, 1, 0, -5, 0, 0, -6, 6, -3, -4, 0, -3, -6, -4, 0, -1, -2, -4, 1, -1, -2, -9, -2, -7, -1, -10},
		/* H */ {0, -2, 1, -4, 0, 0, -3, -3, 8, -4, 0, -1, -3, -3, 2, -1, 4, 2, -2, -2, -3, -4, -1, 0, 2, -10},
		/* I */ {0, -1, -3, -3, -3, -3, 1, -4, -4, 6, 0, -3, 2, 2, -3, -3, -3, -3, -2, 0, 5, -7, -1, -2, -3, -10},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -2, 0, -7, 0, -1, -7, -3, -1, -3, 0, 6, -4, 1, 1, -2, 0, 4, -1, 0, -4, -5, -1, -6, 0, -10},
		/* L */ {0, -3, -5, -8, -6, -5, 1, -6, -3, 2, 0, -4, 7, 4, -4, -4, -2, -4, -4, -3, 2, -3, -2, -2, -3, -10},
		/* M */ {0, -2, -3, -7, -4, -3, 0, -4, -3, 2, 0, 1, 4, 9, -3, -3, -1, -1, -2, -1, 2, -6, -1, -4, -2, -10},
		/* N */ {0, 0, 3, -5, 3, 2, -5, 0, 2, -3, 0, 1, -4, -3, 4, -1, 0, -1, 1, 0, -3, -5, -1, -2, 1, -10},
		/* P */ {0, 1, -2, -4, -2, -1, -6, -1, -1, -3, 0, -2, -4, -3, -1, 8, 0, -1, 1, 0, -2, -7, -1, -7, -1, -10},
		/* Q */ {0, -1, 1, -7, 2, 3, -6, -2, 4, -3, 0, 0, -2, -1, 0, 0, 6, 1, -1, -2, -3, -6, -1, -6, 5, -10},
		/* R */ {0, -3, -2, -5, -3, -2, -6, -4, 2, -3, 0, 4, -4, -1, -1, -1, 1, 8, -1, -2, -4, 2, -2, -6, 0, -10},
		/* S */ {0, 1, 1, 0, 0, -1, -4, 1, -2, -2, 0, -1, -4, -2, 1, 1, -1, -1, 3, 2, -2, -3, 0, -4, -1, -10},
		/* T */ {0, 2, 0, -3, -1, -1, -4, -1, -2, 0, 0, 0, -3, -1, 0, 0, -2, -2, 2, 4, 0, -7, -1, -4, -1, -10},
		/* V */ {0, 0, -3, -3, -3, -3, -2, -2, -3, 5, 0, -4, 2, 2, -3, -2, -3, -4, -2, 0, 6, -8, -1, -4, -3, -10},
		/* W */ {0, -8, -7, -10, -9, -9, 0, -9, -4, -7, 0, -5, -3, -6, -5, -7, -6, 2, -3, -7, -8, 18, -6, -1, -8, -10},
		/* X */ {0, -1, -1, -4, -1, -1, -3, -2, -1, -1, 0, -1, -2, -1, -1, -1, -1, -2, 0, -1, -1, -6, -1, -3, -1, -10},
		/* Y */ {0, -5, -4, 0, -6, -6, 7, -7, 0, -2, 0, -6, -2, -4, -2, -7, -6, -6, -4, -4, -4, -1, -3, 11, -6, -10},
		/* Z */ {0, 0, 3, -7, 3, 5, -7, -1, 2, -3, 0, 0, -3, -2, 1, -1, 5, 0, -1, -1, -3, -8, -1, -6, 5, -10},
		/* * */ {0, -10, -10, -10, -10, -10, -10, -10, -10, -10, 0, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 190 substitution matrix, scale = ln(2)/3 = 0.231049
	// #
	// # Expected score = -1.35, Entropy = 0.547 bits
	// #
	// # Lowest score = -9, Highest score = 18
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  3 -2  0  0 -3 -1  0  1 -2 -1 -3 -2 -2 -5  1  1  2 -7 -4  0  0  0  0 -9
	// R -2  8 -1 -2 -5  1 -2 -4  2 -3 -4  4 -1 -6  0 -1 -2  2 -5 -3 -1  0 -1 -9
	// N  0 -1  3  3 -5  1  2  0  2 -2 -4  1 -3 -4 -1  1  0 -5 -2 -3  3  1 -1 -9
	// D  0 -2  3  5 -7  2  4  0  0 -3 -5  0 -4 -7 -2  0 -1 -8 -5 -3  4  3 -1 -9
	// C -3 -5 -5 -7 13 -7 -7 -4 -4 -3 -8 -7 -7 -6 -4  0 -3 -9  0 -3 -6 -7 -4 -9
	// Q -1  1  1  2 -7  6  3 -2  3 -3 -2  1 -1 -6  0 -1 -1 -6 -5 -3  1  4 -1 -9
	// E  0 -2  2  4 -7  3  5  0  0 -3 -4 -1 -3 -7 -1  0 -1 -9 -5 -3  3  4 -1 -9
	// G  1 -4  0  0 -4 -2  0  6 -3 -4 -5 -3 -4 -6 -1  1 -1 -9 -7 -2  0 -1 -1 -9
	// H -2  2  2  0 -4  3  0 -3  8 -3 -3 -1 -3 -2 -1 -1 -2 -3  0 -3  1  2 -1 -9
	// I -1 -3 -2 -3 -3 -3 -3 -4 -3  6  2 -3  2  1 -3 -2  0 -7 -2  4 -3 -3 -1 -9
	// L -3 -4 -4 -5 -8 -2 -4 -5 -3  2  7 -4  4  2 -3 -4 -2 -3 -2  2 -5 -3 -2 -9
	// K -2  4  1  0 -7  1 -1 -3 -1 -3 -4  6  1 -7 -2  0  0 -5 -6 -3  0  0 -1 -9
	// M -2 -1 -3 -4 -7 -1 -3 -4 -3  2  4  1  9  0 -3 -2 -1 -6 -4  2 -3 -2 -1 -9
	// F -5 -6 -4 -7 -6 -6 -7 -6 -2  1  2 -7  0 10 -6 -4 -4  0  7 -2 -6 -7 -3 -9
	// P  1  0 -1 -2 -4  0 -1 -1 -1 -3 -3 -2 -3 -6  7  1  0 -7 -6 -2 -1 -1 -1 -9
	// S  1 -1  1  0  0 -1  0  1 -1 -2 -4  0 -2 -4  1  3  2 -3 -4 -2  1 -1  0 -9
	// T  2 -2  0 -1 -3 -1 -1 -1 -2  0 -2  0 -1 -4  0  2  4 -6 -3  0  0 -1  0 -9
	// W -7  2 -5 -8 -9 -6 -9 -9 -3 -7 -3 -5 -6  0 -7 -3 -6 18 -1 -8 -6 -7 -5 -9
	// Y -4 -5 -2 -5  0 -5 -5 -7  0 -2 -2 -6 -4  7 -6 -4 -3 -1 11 -3 -4 -5 -3 -9
	// V  0 -3 -3 -3 -3 -3 -3 -2 -3  4  2 -3  2 -2 -2 -2  0 -8 -3  6 -3 -3 -1 -9
	// B  0 -1  3  4 -6  1  3  0  1 -3 -5  0 -3 -6 -1  1  0 -6 -4 -3  4  2 -1 -9
	// Z  0  0  1  3 -7  4  4 -1  2 -3 -3  0 -2 -7 -1 -1 -1 -7 -5 -3  2  4 -1 -9
	// X  0 -1 -1 -1 -4 -1 -1 -1 -1 -1 -2 -1 -1 -3 -1  0  0 -5 -3 -1 -1 -1 -1 -9
	// * -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9  1
	//
	PAM190 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 3, 0, -3, 0, 0, -5, 1, -2, -1, 0, -2, -3, -2, 0, 1, -1, -2, 1, 2, 0, -7, 0, -4, 0, -9},
		/* B */ {0, 0, 4, -6, 4, 3, -6, 0, 1, -3, 0, 0, -5, -3, 3, -1, 1, -1, 1, 0, -3, -6, -1, -4, 2, -9},
		/* C */ {0, -3, -6, 13, -7, -7, -6, -4, -4, -3, 0, -7, -8, -7, -5, -4, -7, -5, 0, -3, -3, -9, -4, 0, -7, -9},
		/* D */ {0, 0, 4, -7, 5, 4, -7, 0, 0, -3, 0, 0, -5, -4, 3, -2, 2, -2, 0, -1, -3, -8, -1, -5, 3, -9},
		/* E */ {0, 0, 3, -7, 4, 5, -7, 0, 0, -3, 0, -1, -4, -3, 2, -1, 3, -2, 0, -1, -3, -9, -1, -5, 4, -9},
		/* F */ {0, -5, -6, -6, -7, -7, 10, -6, -2, 1, 0, -7, 2, 0, -4, -6, -6, -6, -4, -4, -2, 0, -3, 7, -7, -9},
		/* G */ {0, 1, 0, -4, 0, 0, -6, 6, -3, -4, 0, -3, -5, -4, 0, -1, -2, -4, 1, -1, -2, -9, -1, -7, -1, -9},
		/* H */ {0, -2, 1, -4, 0, 0, -2, -3, 8, -3, 0, -1, -3, -3, 2, -1, 3, 2, -1, -2, -3, -3, -1, 0, 2, -9},
		/* I */ {0, -1, -3, -3, -3, -3, 1, -4, -3, 6, 0, -3, 2, 2, -2, -3, -3, -3, -2, 0, 4, -7, -1, -2, -3, -9},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -2, 0, -7, 0, -1, -7, -3, -1, -3, 0, 6, -4, 1, 1, -2, 1, 4, 0, 0, -3, -5, -1, -6, 0, -9},
		/* L */ {0, -3, -5, -8, -5, -4, 2, -5, -3, 2, 0, -4, 7, 4, -4, -3, -2, -4, -4, -2, 2, -3, -2, -2, -3, -9},
		/* M */ {0, -2, -3, -7, -4, -3, 0, -4, -3, 2, 0, 1, 4, 9, -3, -3, -1, -1, -2, -1, 2, -6, -1, -4, -2, -9},
		/* N */ {0, 0, 3, -5, 3, 2, -4, 0, 2, -2, 0, 1, -4, -3, 3, -1, 1, -1, 1, 0, -3, -5, -1, -2, 1, -9},
		/* P */ {0, 1, -1, -4, -2, -1, -6, -1, -1, -3, 0, -2, -3, -3, -1, 7, 0, 0, 1, 0, -2, -7, -1, -6, -1, -9},
		/* Q */ {0, -1, 1, -7, 2, 3, -6, -2, 3, -3, 0, 1, -2, -1, 1, 0, 6, 1, -1, -1, -3, -6, -1, -5, 4, -9},
		/* R */ {0, -2, -1, -5, -2, -2, -6, -4, 2, -3, 0, 4, -4, -1, -1, 0, 1, 8, -1, -2, -3, 2, -1, -5, 0, -9},
		/* S */ {0, 1, 1, 0, 0, 0, -4, 1, -1, -2, 0, 0, -4, -2, 1, 1, -1, -1, 3, 2, -2, -3, 0, -4, -1, -9},
		/* T */ {0, 2, 0, -3, -1, -1, -4, -1, -2, 0, 0, 0, -2, -1, 0, 0, -1, -2, 2, 4, 0, -6, 0, -3, -1, -9},
		/* V */ {0, 0, -3, -3, -3, -3, -2, -2, -3, 4, 0, -3, 2, 2, -3, -2, -3, -3, -2, 0, 6, -8, -1, -3, -3, -9},
		/* W */ {0, -7, -6, -9, -8, -9, 0, -9, -3, -7, 0, -5, -3, -6, -5, -7, -6, 2, -3, -6, -8, 18, -5, -1, -7, -9},
		/* X */ {0, 0, -1, -4, -1, -1, -3, -1, -1, -1, 0, -1, -2, -1, -1, -1, -1, -1, 0, 0, -1, -5, -1, -3, -1, -9},
		/* Y */ {0, -4, -4, 0, -5, -5, 7, -7, 0, -2, 0, -6, -2, -4, -2, -6, -5, -5, -4, -3, -3, -1, -3, 11, -5, -9},
		/* Z */ {0, 0, 2, -7, 3, 4, -7, -1, 2, -3, 0, 0, -3, -2, 1, -1, 4, 0, -1, -1, -3, -7, -1, -5, 4, -9},
		/* * */ {0, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 20 substitution matrix, scale = ln(2)/2 = 0.346574
	// #
	// # Expected score = -6.18, Entropy = 2.95 bits
	// #
	// # Lowest score = -19, Highest score = 13
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A   6  -8  -5  -4  -8  -5  -3  -3  -8  -6  -7  -8  -6  -9  -2  -1  -1 -16  -9  -3  -5  -4  -4 -19
	// R  -8   9  -7 -12  -9  -2 -11 -11  -3  -6 -10  -1  -5 -10  -5  -4  -8  -3 -11  -9  -9  -5  -7 -19
	// N  -5  -7   8   1 -13  -5  -3  -4  -1  -6  -8  -2 -11 -10  -7  -1  -3  -9  -5  -9   6  -4  -4 -19
	// D  -4 -12   1   8 -16  -4   2  -4  -5  -9 -15  -6 -13 -17  -9  -5  -6 -17 -13  -9   6   0  -7 -19
	// C  -8  -9 -13 -16  10 -16 -16 -11  -8  -7 -17 -16 -16 -15  -9  -4  -9 -18  -5  -7 -14 -16 -11 -19
	// Q  -5  -2  -5  -4 -16   9   0  -8   0  -9  -6  -4  -5 -15  -4  -6  -7 -15 -14  -8  -4   7  -6 -19
	// E  -3 -11  -3   2 -16   0   8  -5  -6  -6 -10  -5  -8 -16  -7  -5  -7 -19  -9  -8   0   6  -6 -19
	// G  -3 -11  -4  -4 -11  -8  -5   7 -10 -13 -12  -8 -10 -10  -7  -3  -7 -17 -16  -7  -4  -6  -6 -19
	// H  -8  -3  -1  -5  -8   0  -6 -10   9 -11  -7  -8 -13  -7  -5  -7  -8  -8  -4  -7  -2  -2  -6 -19
	// I  -6  -6  -6  -9  -7  -9  -6 -13 -11   9  -2  -7  -2  -3 -10  -8  -3 -16  -7   1  -7  -7  -6 -19
	// L  -7 -10  -8 -15 -17  -6 -10 -12  -7  -2   7  -9   0  -4  -8  -9  -8  -7  -8  -3 -10  -8  -7 -19
	// K  -8  -1  -2  -6 -16  -4  -5  -8  -8  -7  -9   7  -3 -16  -8  -5  -4 -14 -10 -10  -3  -5  -6 -19
	// M  -6  -5 -11 -13 -16  -5  -8 -10 -13  -2   0  -3  11  -5  -9  -6  -5 -15 -13  -2 -12  -6  -6 -19
	// F  -9 -10 -10 -17 -15 -15 -16 -10  -7  -3  -4 -16  -5   9 -11  -7 -10  -6   1  -9 -12 -16  -9 -19
	// P  -2  -5  -7  -9  -9  -4  -7  -7  -5 -10  -8  -8  -9 -11   8  -3  -5 -16 -16  -7  -8  -5  -6 -19
	// S  -1  -4  -1  -5  -4  -6  -5  -3  -7  -8  -9  -5  -6  -7  -3   7   0  -6  -8  -8  -2  -6  -4 -19
	// T  -1  -8  -3  -6  -9  -7  -7  -7  -8  -3  -8  -4  -5 -10  -5   0   7 -15  -7  -4  -4  -7  -5 -19
	// W -16  -3  -9 -17 -18 -15 -19 -17  -8 -16  -7 -14 -15  -6 -16  -6 -15  13  -6 -18 -11 -17 -13 -19
	// Y  -9 -11  -5 -13  -5 -14  -9 -16  -4  -7  -8 -10 -13   1 -16  -8  -7  -6  10  -8  -7 -11  -9 -19
	// V  -3  -9  -9  -9  -7  -8  -8  -7  -7   1  -3 -10  -2  -9  -7  -8  -4 -18  -8   7  -9  -8  -6 -19
	// B  -5  -9   6   6 -14  -4   0  -4  -2  -7 -10  -3 -12 -12  -8  -2  -4 -11  -7  -9   6  -1  -6 -19
	// Z  -4  -5  -4   0 -16   7   6  -6  -2  -7  -8  -5  -6 -16  -5  -6  -7 -17 -11  -8  -1   6  -6 -19
	// X  -4  -7  -4  -7 -11  -6  -6  -6  -6  -6  -7  -6  -6  -9  -6  -4  -5 -13  -9  -6  -6  -6  -6 -19
	// * -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19 -19   1
	//
	PAM20 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 6, -5, -8, -4, -3, -9, -3, -8, -6, 0, -8, -7, -6, -5, -2, -5, -8, -1, -1, -3, -16, -4, -9, -4, -19},
		/* B */ {0, -5, 6, -14, 6, 0, -12, -4, -2, -7, 0, -3, -10, -12, 6, -8, -4, -9, -2, -4, -9, -11, -6, -7, -1, -19},
		/* C */ {0, -8, -14, 10, -16, -16, -15, -11, -8, -7, 0, -16, -17, -16, -13, -9, -16, -9, -4, -9, -7, -18, -11, -5, -16, -19},
		/* D */ {0, -4, 6, -16, 8, 2, -17, -4, -5, -9, 0, -6, -15, -13, 1, -9, -4, -12, -5, -6, -9, -17, -7, -13, 0, -19},
		/* E */ {0, -3, 0, -16, 2, 8, -16, -5, -6, -6, 0, -5, -10, -8, -3, -7, 0, -11, -5, -7, -8, -19, -6, -9, 6, -19},
		/* F */ {0, -9, -12, -15, -17, -16, 9, -10, -7, -3, 0, -16, -4, -5, -10, -11, -15, -10, -7, -10, -9, -6, -9, 1, -16, -19},
		/* G */ {0, -3, -4, -11, -4, -5, -10, 7, -10, -13, 0, -8, -12, -10, -4, -7, -8, -11, -3, -7, -7, -17, -6, -16, -6, -19},
		/* H */ {0, -8, -2, -8, -5, -6, -7, -10, 9, -11, 0, -8, -7, -13, -1, -5, 0, -3, -7, -8, -7, -8, -6, -4, -2, -19},
		/* I */ {0, -6, -7, -7, -9, -6, -3, -13, -11, 9, 0, -7, -2, -2, -6, -10, -9, -6, -8, -3, 1, -16, -6, -7, -7, -19},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -8, -3, -16, -6, -5, -16, -8, -8, -7, 0, 7, -9, -3, -2, -8, -4, -1, -5, -4, -10, -14, -6, -10, -5, -19},
		/* L */ {0, -7, -10, -17, -15, -10, -4, -12, -7, -2, 0, -9, 7, 0, -8, -8, -6, -10, -9, -8, -3, -7, -7, -8, -8, -19},
		/* M */ {0, -6, -12, -16, -13, -8, -5, -10, -13, -2, 0, -3, 0, 11, -11, -9, -5, -5, -6, -5, -2, -15, -6, -13, -6, -19},
		/* N */ {0, -5, 6, -13, 1, -3, -10, -4, -1, -6, 0, -2, -8, -11, 8, -7, -5, -7, -1, -3, -9, -9, -4, -5, -4, -19},
		/* P */ {0, -2, -8, -9, -9, -7, -11, -7, -5, -10, 0, -8, -8, -9, -7, 8, -4, -5, -3, -5, -7, -16, -6, -16, -5, -19},
		/* Q */ {0, -5, -4, -16, -4, 0, -15, -8, 0, -9, 0, -4, -6, -5, -5, -4, 9, -2, -6, -7, -8, -15, -6, -14, 7, -19},
		/* R */ {0, -8, -9, -9, -12, -11, -10, -11, -3, -6, 0, -1, -10, -5, -7, -5, -2, 9, -4, -8, -9, -3, -7, -11, -5, -19},
		/* S */ {0, -1, -2, -4, -5, -5, -7, -3, -7, -8, 0, -5, -9, -6, -1, -3, -6, -4, 7, 0, -8, -6, -4, -8, -6, -19},
		/* T */ {0, -1, -4, -9, -6, -7, -10, -7, -8, -3, 0, -4, -8, -5, -3, -5, -7, -8, 0, 7, -4, -15, -5, -7, -7, -19},
		/* V */ {0, -3, -9, -7, -9, -8, -9, -7, -7, 1, 0, -10, -3, -2, -9, -7, -8, -9, -8, -4, 7, -18, -6, -8, -8, -19},
		/* W */ {0, -16, -11, -18, -17, -19, -6, -17, -8, -16, 0, -14, -7, -15, -9, -16, -15, -3, -6, -15, -18, 13, -13, -6, -17, -19},
		/* X */ {0, -4, -6, -11, -7, -6, -9, -6, -6, -6, 0, -6, -7, -6, -4, -6, -6, -7, -4, -5, -6, -13, -6, -9, -6, -19},
		/* Y */ {0, -9, -7, -5, -13, -9, 1, -16, -4, -7, 0, -10, -8, -13, -5, -16, -14, -11, -8, -7, -8, -6, -9, 10, -11, -19},
		/* Z */ {0, -4, -1, -16, 0, 6, -16, -6, -2, -7, 0, -5, -8, -6, -4, -5, 7, -5, -6, -7, -8, -17, -6, -11, 6, -19},
		/* * */ {0, -19, -19, -19, -19, -19, -19, -19, -19, -19, 0, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 200 substitution matrix, scale = ln(2)/3 = 0.231049
	// #
	// # Expected score = -1.23, Entropy = 0.507 bits
	// #
	// # Lowest score = -9, Highest score = 18
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  3 -2  0  0 -3 -1  0  1 -2 -1 -2 -2 -2 -4  1  1  1 -7 -4  0  0  0  0 -9
	// R -2  7  0 -2 -4  1 -2 -4  2 -2 -4  4 -1 -5  0 -1 -1  2 -5 -3 -1  0 -1 -9
	// N  0  0  3  3 -5  1  2  0  2 -2 -4  1 -2 -4 -1  1  0 -5 -2 -2  3  1  0 -9
	// D  0 -2  3  5 -6  2  4  0  0 -3 -5  0 -4 -7 -2  0  0 -8 -5 -3  4  3 -1 -9
	// C -3 -4 -5 -6 12 -7 -7 -4 -4 -3 -7 -7 -6 -6 -4  0 -3 -9  0 -2 -5 -7 -4 -9
	// Q -1  1  1  2 -7  5  3 -2  3 -3 -2  1 -1 -6  0 -1 -1 -6 -5 -3  1  4 -1 -9
	// E  0 -2  2  4 -7  3  5  0  0 -3 -4  0 -3 -7 -1  0 -1 -9 -5 -2  3  4 -1 -9
	// G  1 -4  0  0 -4 -2  0  6 -3 -3 -5 -2 -4 -6 -1  1  0 -8 -6 -2  0 -1 -1 -9
	// H -2  2  2  0 -4  3  0 -3  8 -3 -3 -1 -3 -2 -1 -1 -2 -3  0 -3  1  2 -1 -9
	// I -1 -2 -2 -3 -3 -3 -3 -3 -3  6  2 -2  2  1 -3 -2  0 -6 -2  4 -3 -3 -1 -9
	// L -2 -4 -4 -5 -7 -2 -4 -5 -3  2  7 -4  4  2 -3 -4 -2 -2 -2  2 -4 -3 -2 -9
	// K -2  4  1  0 -7  1  0 -2 -1 -2 -4  6  1 -7 -2  0  0 -4 -5 -3  0  0 -1 -9
	// M -2 -1 -2 -4 -6 -1 -3 -4 -3  2  4  1  8  0 -3 -2 -1 -5 -3  2 -3 -2 -1 -9
	// F -4 -5 -4 -7 -6 -6 -7 -6 -2  1  2 -7  0 10 -6 -4 -4  0  7 -2 -6 -6 -3 -9
	// P  1  0 -1 -2 -4  0 -1 -1 -1 -3 -3 -2 -3 -6  7  1  0 -7 -6 -2 -1 -1 -1 -9
	// S  1 -1  1  0  0 -1  0  1 -1 -2 -4  0 -2 -4  1  2  2 -3 -3 -1  1 -1  0 -9
	// T  1 -1  0  0 -3 -1 -1  0 -2  0 -2  0 -1 -4  0  2  4 -6 -3  0  0 -1  0 -9
	// W -7  2 -5 -8 -9 -6 -9 -8 -3 -6 -2 -4 -5  0 -7 -3 -6 18 -1 -8 -6 -7 -5 -9
	// Y -4 -5 -2 -5  0 -5 -5 -6  0 -2 -2 -5 -3  7 -6 -3 -3 -1 11 -3 -4 -5 -3 -9
	// V  0 -3 -2 -3 -2 -3 -2 -2 -3  4  2 -3  2 -2 -2 -1  0 -8 -3  5 -3 -2 -1 -9
	// B  0 -1  3  4 -5  1  3  0  1 -3 -4  0 -3 -6 -1  1  0 -6 -4 -3  3  2 -1 -9
	// Z  0  0  1  3 -7  4  4 -1  2 -3 -3  0 -2 -6 -1 -1 -1 -7 -5 -2  2  4 -1 -9
	// X  0 -1  0 -1 -4 -1 -1 -1 -1 -1 -2 -1 -1 -3 -1  0  0 -5 -3 -1 -1 -1 -1 -9
	// * -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9  1
	//
	PAM200 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 3, 0, -3, 0, 0, -4, 1, -2, -1, 0, -2, -2, -2, 0, 1, -1, -2, 1, 1, 0, -7, 0, -4, 0, -9},
		/* B */ {0, 0, 3, -5, 4, 3, -6, 0, 1, -3, 0, 0, -4, -3, 3, -1, 1, -1, 1, 0, -3, -6, -1, -4, 2, -9},
		/* C */ {0, -3, -5, 12, -6, -7, -6, -4, -4, -3, 0, -7, -7, -6, -5, -4, -7, -4, 0, -3, -2, -9, -4, 0, -7, -9},
		/* D */ {0, 0, 4, -6, 5, 4, -7, 0, 0, -3, 0, 0, -5, -4, 3, -2, 2, -2, 0, 0, -3, -8, -1, -5, 3, -9},
		/* E */ {0, 0, 3, -7, 4, 5, -7, 0, 0, -3, 0, 0, -4, -3, 2, -1, 3, -2, 0, -1, -2, -9, -1, -5, 4, -9},
		/* F */ {0, -4, -6, -6, -7, -7, 10, -6, -2, 1, 0, -7, 2, 0, -4, -6, -6, -5, -4, -4, -2, 0, -3, 7, -6, -9},
		/* G */ {0, 1, 0, -4, 0, 0, -6, 6, -3, -3, 0, -2, -5, -4, 0, -1, -2, -4, 1, 0, -2, -8, -1, -6, -1, -9},
		/* H */ {0, -2, 1, -4, 0, 0, -2, -3, 8, -3, 0, -1, -3, -3, 2, -1, 3, 2, -1, -2, -3, -3, -1, 0, 2, -9},
		/* I */ {0, -1, -3, -3, -3, -3, 1, -3, -3, 6, 0, -2, 2, 2, -2, -3, -3, -2, -2, 0, 4, -6, -1, -2, -3, -9},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -2, 0, -7, 0, 0, -7, -2, -1, -2, 0, 6, -4, 1, 1, -2, 1, 4, 0, 0, -3, -4, -1, -5, 0, -9},
		/* L */ {0, -2, -4, -7, -5, -4, 2, -5, -3, 2, 0, -4, 7, 4, -4, -3, -2, -4, -4, -2, 2, -2, -2, -2, -3, -9},
		/* M */ {0, -2, -3, -6, -4, -3, 0, -4, -3, 2, 0, 1, 4, 8, -2, -3, -1, -1, -2, -1, 2, -5, -1, -3, -2, -9},
		/* N */ {0, 0, 3, -5, 3, 2, -4, 0, 2, -2, 0, 1, -4, -2, 3, -1, 1, 0, 1, 0, -2, -5, 0, -2, 1, -9},
		/* P */ {0, 1, -1, -4, -2, -1, -6, -1, -1, -3, 0, -2, -3, -3, -1, 7, 0, 0, 1, 0, -2, -7, -1, -6, -1, -9},
		/* Q */ {0, -1, 1, -7, 2, 3, -6, -2, 3, -3, 0, 1, -2, -1, 1, 0, 5, 1, -1, -1, -3, -6, -1, -5, 4, -9},
		/* R */ {0, -2, -1, -4, -2, -2, -5, -4, 2, -2, 0, 4, -4, -1, 0, 0, 1, 7, -1, -1, -3, 2, -1, -5, 0, -9},
		/* S */ {0, 1, 1, 0, 0, 0, -4, 1, -1, -2, 0, 0, -4, -2, 1, 1, -1, -1, 2, 2, -1, -3, 0, -3, -1, -9},
		/* T */ {0, 1, 0, -3, 0, -1, -4, 0, -2, 0, 0, 0, -2, -1, 0, 0, -1, -1, 2, 4, 0, -6, 0, -3, -1, -9},
		/* V */ {0, 0, -3, -2, -3, -2, -2, -2, -3, 4, 0, -3, 2, 2, -2, -2, -3, -3, -1, 0, 5, -8, -1, -3, -2, -9},
		/* W */ {0, -7, -6, -9, -8, -9, 0, -8, -3, -6, 0, -4, -2, -5, -5, -7, -6, 2, -3, -6, -8, 18, -5, -1, -7, -9},
		/* X */ {0, 0, -1, -4, -1, -1, -3, -1, -1, -1, 0, -1, -2, -1, 0, -1, -1, -1, 0, 0, -1, -5, -1, -3, -1, -9},
		/* Y */ {0, -4, -4, 0, -5, -5, 7, -6, 0, -2, 0, -5, -2, -3, -2, -6, -5, -5, -3, -3, -3, -1, -3, 11, -5, -9},
		/* Z */ {0, 0, 2, -7, 3, 4, -6, -1, 2, -3, 0, 0, -3, -2, 1, -1, 4, 0, -1, -1, -2, -7, -1, -5, 4, -9},
		/* * */ {0, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 200 substitution matrix, scale = 0.0693200
	// #
	// # Expected score = -4.12, Entropy = 0.507 bits
	// #
	// # Lowest score = -30, Highest score = 59
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A   9  -7   0   0  -9  -3   1   4  -7  -3  -8  -6  -5 -14   4   5   5 -23 -14   1   0  -1  -1 -30
	// R  -7  24  -1  -7 -15   4  -6 -12   5  -8 -13  12  -2 -18  -1  -2  -5   7 -17 -11  -4  -1  -4 -30
	// N   0  -1  10   9 -15   2   5   1   7  -8 -12   4  -8 -14  -3   3   2 -16  -8  -8   9   4  -2 -30
	// D   0  -7   9  16 -21   6  14   1   2 -10 -17  -1 -12 -23  -5   0  -2 -27 -17 -10  13  11  -4 -30
	// C  -9 -15 -15 -21  41 -22 -22 -14 -14  -9 -25 -22 -22 -18 -12  -1 -10 -30   0  -8 -18 -22 -13 -30
	// Q  -3   4   2   6 -22  18  10  -6  11  -9  -7   2  -4 -19   0  -3  -4 -20 -17  -8   4  14  -3 -30
	// E   1  -6   5  14 -22  10  16   0   1  -9 -14  -1  -9 -22  -4  -1  -3 -28 -17  -8  10  14  -3 -30
	// G   4 -12   1   1 -14  -6   0  19 -10 -12 -17  -8 -12 -19  -3   4  -1 -28 -22  -6   1  -3  -4 -30
	// H  -7   5   7   2 -14  11   1 -10  26 -11  -9  -2 -10  -8  -2  -4  -6 -11  -1 -10   4   7  -3 -30
	// I  -3  -8  -8 -10  -9  -9  -9 -12 -11  19   8  -8   8   3  -9  -6   0 -21  -5  14  -9  -9  -3 -30
	// L  -8 -13 -12 -17 -25  -7 -14 -17  -9   8  22 -12  13   5 -11 -12  -8  -8  -5   6 -15 -11  -6 -30
	// K  -6  12   4  -1 -22   2  -1  -8  -2  -8 -12  19   2 -22  -6  -1  -1 -15 -18 -11   1   0  -4 -30
	// M  -5  -2  -8 -12 -22  -4  -9 -12 -10   8  13   2  28  -1  -9  -7  -3 -18 -12   6 -10  -7  -3 -30
	// F -14 -18 -14 -23 -18 -19 -22 -19  -8   3   5 -22  -1  33 -18 -13 -13  -1  23  -6 -18 -21 -10 -30
	// P   4  -1  -3  -5 -12   0  -4  -3  -2  -9 -11  -6  -9 -18  23   3   0 -23 -20  -6  -4  -2  -3 -30
	// S   5  -2   3   0  -1  -3  -1   4  -4  -6 -12  -1  -7 -13   3   8   6  -9 -11  -5   2  -2  -1 -30
	// T   5  -5   2  -2 -10  -4  -3  -1  -6   0  -8  -1  -3 -13   0   6  12 -21 -11   1   0  -3  -1 -30
	// W -23   7 -16 -27 -30 -20 -28 -28 -11 -21  -8 -15 -18  -1 -23  -9 -21  59  -2 -26 -21 -24 -17 -30
	// Y -14 -17  -8 -17   0 -17 -17 -22  -1  -5  -5 -18 -12  23 -20 -11 -11  -2  37 -11 -12 -17 -10 -30
	// V   1 -11  -8 -10  -8  -8  -8  -6 -10  14   6 -11   6  -6  -6  -5   1 -26 -11  18  -9  -8  -3 -30
	// B   0  -4   9  13 -18   4  10   1   4  -9 -15   1 -10 -18  -4   2   0 -21 -12  -9  12   8  -3 -30
	// Z  -1  -1   4  11 -22  14  14  -3   7  -9 -11   0  -7 -21  -2  -2  -3 -24 -17  -8   8  14  -3 -30
	// X  -1  -4  -2  -4 -13  -3  -3  -4  -3  -3  -6  -4  -3 -10  -3  -1  -1 -17 -10  -3  -3  -3  -4 -30
	// * -30 -30 -30 -30 -30 -30 -30 -30 -30 -30 -30 -30 -30 -30 -30 -30 -30 -30 -30 -30 -30 -30 -30   1
	//
	PAM200_cdi = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 9, 0, -9, 0, 1, -14, 4, -7, -3, 0, -6, -8, -5, 0, 4, -3, -7, 5, 5, 1, -23, -1, -14, -1, -30},
		/* B */ {0, 0, 12, -18, 13, 10, -18, 1, 4, -9, 0, 1, -15, -10, 9, -4, 4, -4, 2, 0, -9, -21, -3, -12, 8, -30},
		/* C */ {0, -9, -18, 41, -21, -22, -18, -14, -14, -9, 0, -22, -25, -22, -15, -12, -22, -15, -1, -10, -8, -30, -13, 0, -22, -30},
		/* D */ {0, 0, 13, -21, 16, 14, -23, 1, 2, -10, 0, -1, -17, -12, 9, -5, 6, -7, 0, -2, -10, -27, -4, -17, 11, -30},
		/* E */ {0, 1, 10, -22, 14, 16, -22, 0, 1, -9, 0, -1, -14, -9, 5, -4, 10, -6, -1, -3, -8, -28, -3, -17, 14, -30},
		/* F */ {0, -14, -18, -18, -23, -22, 33, -19, -8, 3, 0, -22, 5, -1, -14, -18, -19, -18, -13, -13, -6, -1, -10, 23, -21, -30},
		/* G */ {0, 4, 1, -14, 1, 0, -19, 19, -10, -12, 0, -8, -17, -12, 1, -3, -6, -12, 4, -1, -6, -28, -4, -22, -3, -30},
		/* H */ {0, -7, 4, -14, 2, 1, -8, -10, 26, -11, 0, -2, -9, -10, 7, -2, 11, 5, -4, -6, -10, -11, -3, -1, 7, -30},
		/* I */ {0, -3, -9, -9, -10, -9, 3, -12, -11, 19, 0, -8, 8, 8, -8, -9, -9, -8, -6, 0, 14, -21, -3, -5, -9, -30},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -6, 1, -22, -1, -1, -22, -8, -2, -8, 0, 19, -12, 2, 4, -6, 2, 12, -1, -1, -11, -15, -4, -18, 0, -30},
		/* L */ {0, -8, -15, -25, -17, -14, 5, -17, -9, 8, 0, -12, 22, 13, -12, -11, -7, -13, -12, -8, 6, -8, -6, -5, -11, -30},
		/* M */ {0, -5, -10, -22, -12, -9, -1, -12, -10, 8, 0, 2, 13, 28, -8, -9, -4, -2, -7, -3, 6, -18, -3, -12, -7, -30},
		/* N */ {0, 0, 9, -15, 9, 5, -14, 1, 7, -8, 0, 4, -12, -8, 10, -3, 2, -1, 3, 2, -8, -16, -2, -8, 4, -30},
		/* P */ {0, 4, -4, -12, -5, -4, -18, -3, -2, -9, 0, -6, -11, -9, -3, 23, 0, -1, 3, 0, -6, -23, -3, -20, -2, -30},
		/* Q */ {0, -3, 4, -22, 6, 10, -19, -6, 11, -9, 0, 2, -7, -4, 2, 0, 18, 4, -3, -4, -8, -20, -3, -17, 14, -30},
		/* R */ {0, -7, -4, -15, -7, -6, -18, -12, 5, -8, 0, 12, -13, -2, -1, -1, 4, 24, -2, -5, -11, 7, -4, -17, -1, -30},
		/* S */ {0, 5, 2, -1, 0, -1, -13, 4, -4, -6, 0, -1, -12, -7, 3, 3, -3, -2, 8, 6, -5, -9, -1, -11, -2, -30},
		/* T */ {0, 5, 0, -10, -2, -3, -13, -1, -6, 0, 0, -1, -8, -3, 2, 0, -4, -5, 6, 12, 1, -21, -1, -11, -3, -30},
		/* V */ {0, 1, -9, -8, -10, -8, -6, -6, -10, 14, 0, -11, 6, 6, -8, -6, -8, -11, -5, 1, 18, -26, -3, -11, -8, -30},
		/* W */ {0, -23, -21, -30, -27, -28, -1, -28, -11, -21, 0, -15, -8, -18, -16, -23, -20, 7, -9, -21, -26, 59, -17, -2, -24, -30},
		/* X */ {0, -1, -3, -13, -4, -3, -10, -4, -3, -3, 0, -4, -6, -3, -2, -3, -3, -4, -1, -1, -3, -17, -4, -10, -3, -30},
		/* Y */ {0, -14, -12, 0, -17, -17, 23, -22, -1, -5, 0, -18, -5, -12, -8, -20, -17, -17, -11, -11, -11, -2, -10, 37, -17, -30},
		/* Z */ {0, -1, 8, -22, 11, 14, -21, -3, 7, -9, 0, 0, -11, -7, 4, -2, 14, -1, -2, -3, -8, -24, -3, -17, 14, -30},
		/* * */ {0, -30, -30, -30, -30, -30, -30, -30, -30, -30, 0, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 210 substitution matrix, scale = ln(2)/3 = 0.231049
	// #
	// # Expected score = -1.12, Entropy = 0.470 bits
	// #
	// # Lowest score = -9, Highest score = 18
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  2 -2  0  0 -2 -1  0  1 -2 -1 -2 -2 -1 -4  1  1  1 -7 -4  0  0  0  0 -9
	// R -2  7  0 -2 -4  1 -2 -3  2 -2 -4  4 -1 -5  0  0 -1  2 -5 -3 -1  0 -1 -9
	// N  0  0  3  2 -4  1  2  0  2 -2 -3  1 -2 -4 -1  1  0 -5 -2 -2  3  1  0 -9
	// D  0 -2  2  5 -6  2  4  0  1 -3 -5  0 -3 -7 -1  0  0 -8 -5 -3  4  3 -1 -9
	// C -2 -4 -4 -6 12 -6 -6 -4 -4 -3 -7 -6 -6 -5 -3  0 -3 -9  0 -2 -5 -6 -4 -9
	// Q -1  1  1  2 -6  5  3 -2  3 -3 -2  1 -1 -6  0 -1 -1 -6 -5 -2  1  4 -1 -9
	// E  0 -2  2  4 -6  3  5  0  0 -2 -4  0 -3 -6 -1  0 -1 -8 -5 -2  3  4 -1 -9
	// G  1 -3  0  0 -4 -2  0  5 -3 -3 -5 -2 -3 -5 -1  1  0 -8 -6 -2  0 -1 -1 -9
	// H -2  2  2  1 -4  3  0 -3  8 -3 -2  0 -3 -2  0 -1 -2 -3  0 -3  1  2 -1 -9
	// I -1 -2 -2 -3 -3 -3 -2 -3 -3  5  2 -2  2  1 -3 -2  0 -6 -1  4 -3 -3 -1 -9
	// L -2 -4 -3 -5 -7 -2 -4 -5 -2  2  7 -3  4  2 -3 -3 -2 -2 -1  2 -4 -3 -2 -9
	// K -2  4  1  0 -6  1  0 -2  0 -2 -3  5  1 -6 -2  0  0 -4 -5 -3  0  0 -1 -9
	// M -1 -1 -2 -3 -6 -1 -3 -3 -3  2  4  1  8  0 -3 -2 -1 -5 -3  2 -3 -2 -1 -9
	// F -4 -5 -4 -7 -5 -6 -6 -5 -2  1  2 -6  0 10 -5 -4 -4  0  7 -2 -5 -6 -3 -9
	// P  1  0 -1 -1 -3  0 -1 -1  0 -3 -3 -2 -3 -5  7  1  0 -7 -6 -2 -1  0 -1 -9
	// S  1  0  1  0  0 -1  0  1 -1 -2 -3  0 -2 -4  1  2  2 -3 -3 -1  1  0  0 -9
	// T  1 -1  0  0 -3 -1 -1  0 -2  0 -2  0 -1 -4  0  2  3 -6 -3  0  0 -1  0 -9
	// W -7  2 -5 -8 -9 -6 -8 -8 -3 -6 -2 -4 -5  0 -7 -3 -6 18 -1 -7 -6 -7 -5 -9
	// Y -4 -5 -2 -5  0 -5 -5 -6  0 -1 -1 -5 -3  7 -6 -3 -3 -1 11 -3 -4 -5 -3 -9
	// V  0 -3 -2 -3 -2 -2 -2 -2 -3  4  2 -3  2 -2 -2 -1  0 -7 -3  5 -2 -2 -1 -9
	// B  0 -1  3  4 -5  1  3  0  1 -3 -4  0 -3 -5 -1  1  0 -6 -4 -2  3  2 -1 -9
	// Z  0  0  1  3 -6  4  4 -1  2 -3 -3  0 -2 -6  0  0 -1 -7 -5 -2  2  4 -1 -9
	// X  0 -1  0 -1 -4 -1 -1 -1 -1 -1 -2 -1 -1 -3 -1  0  0 -5 -3 -1 -1 -1 -1 -9
	// * -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9  1
	//
	PAM210 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 2, 0, -2, 0, 0, -4, 1, -2, -1, 0, -2, -2, -1, 0, 1, -1, -2, 1, 1, 0, -7, 0, -4, 0, -9},
		/* B */ {0, 0, 3, -5, 4, 3, -5, 0, 1, -3, 0, 0, -4, -3, 3, -1, 1, -1, 1, 0, -2, -6, -1, -4, 2, -9},
		/* C */ {0, -2, -5, 12, -6, -6, -5, -4, -4, -3, 0, -6, -7, -6, -4, -3, -6, -4, 0, -3, -2, -9, -4, 0, -6, -9},
		/* D */ {0, 0, 4, -6, 5, 4, -7, 0, 1, -3, 0, 0, -5, -3, 2, -1, 2, -2, 0, 0, -3, -8, -1, -5, 3, -9},
		/* E */ {0, 0, 3, -6, 4, 5, -6, 0, 0, -2, 0, 0, -4, -3, 2, -1, 3, -2, 0, -1, -2, -8, -1, -5, 4, -9},
		/* F */ {0, -4, -5, -5, -7, -6, 10, -5, -2, 1, 0, -6, 2, 0, -4, -5, -6, -5, -4, -4, -2, 0, -3, 7, -6, -9},
		/* G */ {0, 1, 0, -4, 0, 0, -5, 5, -3, -3, 0, -2, -5, -3, 0, -1, -2, -3, 1, 0, -2, -8, -1, -6, -1, -9},
		/* H */ {0, -2, 1, -4, 1, 0, -2, -3, 8, -3, 0, 0, -2, -3, 2, 0, 3, 2, -1, -2, -3, -3, -1, 0, 2, -9},
		/* I */ {0, -1, -3, -3, -3, -2, 1, -3, -3, 5, 0, -2, 2, 2, -2, -3, -3, -2, -2, 0, 4, -6, -1, -1, -3, -9},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -2, 0, -6, 0, 0, -6, -2, 0, -2, 0, 5, -3, 1, 1, -2, 1, 4, 0, 0, -3, -4, -1, -5, 0, -9},
		/* L */ {0, -2, -4, -7, -5, -4, 2, -5, -2, 2, 0, -3, 7, 4, -3, -3, -2, -4, -3, -2, 2, -2, -2, -1, -3, -9},
		/* M */ {0, -1, -3, -6, -3, -3, 0, -3, -3, 2, 0, 1, 4, 8, -2, -3, -1, -1, -2, -1, 2, -5, -1, -3, -2, -9},
		/* N */ {0, 0, 3, -4, 2, 2, -4, 0, 2, -2, 0, 1, -3, -2, 3, -1, 1, 0, 1, 0, -2, -5, 0, -2, 1, -9},
		/* P */ {0, 1, -1, -3, -1, -1, -5, -1, 0, -3, 0, -2, -3, -3, -1, 7, 0, 0, 1, 0, -2, -7, -1, -6, 0, -9},
		/* Q */ {0, -1, 1, -6, 2, 3, -6, -2, 3, -3, 0, 1, -2, -1, 1, 0, 5, 1, -1, -1, -2, -6, -1, -5, 4, -9},
		/* R */ {0, -2, -1, -4, -2, -2, -5, -3, 2, -2, 0, 4, -4, -1, 0, 0, 1, 7, 0, -1, -3, 2, -1, -5, 0, -9},
		/* S */ {0, 1, 1, 0, 0, 0, -4, 1, -1, -2, 0, 0, -3, -2, 1, 1, -1, 0, 2, 2, -1, -3, 0, -3, 0, -9},
		/* T */ {0, 1, 0, -3, 0, -1, -4, 0, -2, 0, 0, 0, -2, -1, 0, 0, -1, -1, 2, 3, 0, -6, 0, -3, -1, -9},
		/* V */ {0, 0, -2, -2, -3, -2, -2, -2, -3, 4, 0, -3, 2, 2, -2, -2, -2, -3, -1, 0, 5, -7, -1, -3, -2, -9},
		/* W */ {0, -7, -6, -9, -8, -8, 0, -8, -3, -6, 0, -4, -2, -5, -5, -7, -6, 2, -3, -6, -7, 18, -5, -1, -7, -9},
		/* X */ {0, 0, -1, -4, -1, -1, -3, -1, -1, -1, 0, -1, -2, -1, 0, -1, -1, -1, 0, 0, -1, -5, -1, -3, -1, -9},
		/* Y */ {0, -4, -4, 0, -5, -5, 7, -6, 0, -1, 0, -5, -1, -3, -2, -6, -5, -5, -3, -3, -3, -1, -3, 11, -5, -9},
		/* Z */ {0, 0, 2, -6, 3, 4, -6, -1, 2, -3, 0, 0, -3, -2, 1, 0, 4, 0, 0, -1, -2, -7, -1, -5, 4, -9},
		/* * */ {0, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 220 substitution matrix, scale = ln(2)/3 = 0.231049
	// #
	// # Expected score = -1.06, Entropy = 0.437 bits
	// #
	// # Lowest score = -8, Highest score = 17
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  2 -2  0  0 -2 -1  0  1 -2 -1 -2 -1 -1 -4  1  1  1 -6 -4  0  0  0  0 -8
	// R -2  7  0 -2 -4  1 -1 -3  2 -2 -3  4 -1 -5  0  0 -1  2 -5 -3 -1  0 -1 -8
	// N  0  0  3  2 -4  1  2  0  2 -2 -3  1 -2 -4 -1  1  0 -4 -2 -2  2  1  0 -8
	// D  0 -2  2  4 -6  2  4  0  1 -3 -5  0 -3 -6 -1  0  0 -8 -5 -3  4  3 -1 -8
	// C -2 -4 -4 -6 12 -6 -6 -4 -4 -3 -7 -6 -6 -5 -3  0 -3 -8  0 -2 -5 -6 -3 -8
	// Q -1  1  1  2 -6  5  3 -2  3 -2 -2  1 -1 -5  0 -1 -1 -5 -5 -2  1  4 -1 -8
	// E  0 -1  2  4 -6  3  4  0  1 -2 -4  0 -2 -6 -1  0 -1 -8 -5 -2  3  4 -1 -8
	// G  1 -3  0  0 -4 -2  0  5 -3 -3 -5 -2 -3 -5 -1  1  0 -8 -6 -2  0 -1 -1 -8
	// H -2  2  2  1 -4  3  1 -3  7 -3 -2  0 -3 -2  0 -1 -2 -3  0 -3  1  2 -1 -8
	// I -1 -2 -2 -3 -3 -2 -2 -3 -3  5  2 -2  2  1 -2 -2  0 -6 -1  4 -2 -2 -1 -8
	// L -2 -3 -3 -5 -7 -2 -4 -5 -2  2  6 -3  4  2 -3 -3 -2 -2 -1  2 -4 -3 -2 -8
	// K -1  4  1  0 -6  1  0 -2  0 -2 -3  5  1 -6 -1  0  0 -4 -5 -3  0  0 -1 -8
	// M -1 -1 -2 -3 -6 -1 -2 -3 -3  2  4  1  8  0 -2 -2 -1 -5 -3  2 -3 -2 -1 -8
	// F -4 -5 -4 -6 -5 -5 -6 -5 -2  1  2 -6  0 10 -5 -4 -4  0  7 -2 -5 -6 -3 -8
	// P  1  0 -1 -1 -3  0 -1 -1  0 -2 -3 -1 -2 -5  7  1  0 -6 -6 -1 -1  0 -1 -8
	// S  1  0  1  0  0 -1  0  1 -1 -2 -3  0 -2 -4  1  2  2 -3 -3 -1  0  0  0 -8
	// T  1 -1  0  0 -3 -1 -1  0 -2  0 -2  0 -1 -4  0  2  3 -6 -3  0  0 -1  0 -8
	// W -6  2 -4 -8 -8 -5 -8 -8 -3 -6 -2 -4 -5  0 -6 -3 -6 17  0 -7 -6 -7 -5 -8
	// Y -4 -5 -2 -5  0 -5 -5 -6  0 -1 -1 -5 -3  7 -6 -3 -3  0 11 -3 -3 -5 -3 -8
	// V  0 -3 -2 -3 -2 -2 -2 -2 -3  4  2 -3  2 -2 -1 -1  0 -7 -3  5 -2 -2 -1 -8
	// B  0 -1  2  4 -5  1  3  0  1 -2 -4  0 -3 -5 -1  0  0 -6 -3 -2  3  2 -1 -8
	// Z  0  0  1  3 -6  4  4 -1  2 -2 -3  0 -2 -6  0  0 -1 -7 -5 -2  2  4 -1 -8
	// X  0 -1  0 -1 -3 -1 -1 -1 -1 -1 -2 -1 -1 -3 -1  0  0 -5 -3 -1 -1 -1 -1 -8
	// * -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8  1
	//
	PAM220 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 2, 0, -2, 0, 0, -4, 1, -2, -1, 0, -1, -2, -1, 0, 1, -1, -2, 1, 1, 0, -6, 0, -4, 0, -8},
		/* B */ {0, 0, 3, -5, 4, 3, -5, 0, 1, -2, 0, 0, -4, -3, 2, -1, 1, -1, 0, 0, -2, -6, -1, -3, 2, -8},
		/* C */ {0, -2, -5, 12, -6, -6, -5, -4, -4, -3, 0, -6, -7, -6, -4, -3, -6, -4, 0, -3, -2, -8, -3, 0, -6, -8},
		/* D */ {0, 0, 4, -6, 4, 4, -6, 0, 1, -3, 0, 0, -5, -3, 2, -1, 2, -2, 0, 0, -3, -8, -1, -5, 3, -8},
		/* E */ {0, 0, 3, -6, 4, 4, -6, 0, 1, -2, 0, 0, -4, -2, 2, -1, 3, -1, 0, -1, -2, -8, -1, -5, 4, -8},
		/* F */ {0, -4, -5, -5, -6, -6, 10, -5, -2, 1, 0, -6, 2, 0, -4, -5, -5, -5, -4, -4, -2, 0, -3, 7, -6, -8},
		/* G */ {0, 1, 0, -4, 0, 0, -5, 5, -3, -3, 0, -2, -5, -3, 0, -1, -2, -3, 1, 0, -2, -8, -1, -6, -1, -8},
		/* H */ {0, -2, 1, -4, 1, 1, -2, -3, 7, -3, 0, 0, -2, -3, 2, 0, 3, 2, -1, -2, -3, -3, -1, 0, 2, -8},
		/* I */ {0, -1, -2, -3, -3, -2, 1, -3, -3, 5, 0, -2, 2, 2, -2, -2, -2, -2, -2, 0, 4, -6, -1, -1, -2, -8},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 0, -6, 0, 0, -6, -2, 0, -2, 0, 5, -3, 1, 1, -1, 1, 4, 0, 0, -3, -4, -1, -5, 0, -8},
		/* L */ {0, -2, -4, -7, -5, -4, 2, -5, -2, 2, 0, -3, 6, 4, -3, -3, -2, -3, -3, -2, 2, -2, -2, -1, -3, -8},
		/* M */ {0, -1, -3, -6, -3, -2, 0, -3, -3, 2, 0, 1, 4, 8, -2, -2, -1, -1, -2, -1, 2, -5, -1, -3, -2, -8},
		/* N */ {0, 0, 2, -4, 2, 2, -4, 0, 2, -2, 0, 1, -3, -2, 3, -1, 1, 0, 1, 0, -2, -4, 0, -2, 1, -8},
		/* P */ {0, 1, -1, -3, -1, -1, -5, -1, 0, -2, 0, -1, -3, -2, -1, 7, 0, 0, 1, 0, -1, -6, -1, -6, 0, -8},
		/* Q */ {0, -1, 1, -6, 2, 3, -5, -2, 3, -2, 0, 1, -2, -1, 1, 0, 5, 1, -1, -1, -2, -5, -1, -5, 4, -8},
		/* R */ {0, -2, -1, -4, -2, -1, -5, -3, 2, -2, 0, 4, -3, -1, 0, 0, 1, 7, 0, -1, -3, 2, -1, -5, 0, -8},
		/* S */ {0, 1, 0, 0, 0, 0, -4, 1, -1, -2, 0, 0, -3, -2, 1, 1, -1, 0, 2, 2, -1, -3, 0, -3, 0, -8},
		/* T */ {0, 1, 0, -3, 0, -1, -4, 0, -2, 0, 0, 0, -2, -1, 0, 0, -1, -1, 2, 3, 0, -6, 0, -3, -1, -8},
		/* V */ {0, 0, -2, -2, -3, -2, -2, -2, -3, 4, 0, -3, 2, 2, -2, -1, -2, -3, -1, 0, 5, -7, -1, -3, -2, -8},
		/* W */ {0, -6, -6, -8, -8, -8, 0, -8, -3, -6, 0, -4, -2, -5, -4, -6, -5, 2, -3, -6, -7, 17, -5, 0, -7, -8},
		/* X */ {0, 0, -1, -3, -1, -1, -3, -1, -1, -1, 0, -1, -2, -1, 0, -1, -1, -1, 0, 0, -1, -5, -1, -3, -1, -8},
		/* Y */ {0, -4, -3, 0, -5, -5, 7, -6, 0, -1, 0, -5, -1, -3, -2, -6, -5, -5, -3, -3, -3, 0, -3, 11, -5, -8},
		/* Z */ {0, 0, 2, -6, 3, 4, -6, -1, 2, -2, 0, 0, -3, -2, 1, 0, 4, 0, 0, -1, -2, -7, -1, -5, 4, -8},
		/* * */ {0, -8, -8, -8, -8, -8, -8, -8, -8, -8, 0, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 230 substitution matrix, scale = ln(2)/3 = 0.231049
	// #
	// # Expected score = -0.991, Entropy = 0.407 bits
	// #
	// # Lowest score = -8, Highest score = 17
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  2 -2  0  0 -2 -1  0  1 -2 -1 -2 -1 -1 -4  1  1  1 -6 -4  0  0  0  0 -8
	// R -2  7  0 -2 -4  1 -1 -3  2 -2 -3  4 -1 -5  0  0 -1  2 -5 -3 -1  0 -1 -8
	// N  0  0  2  2 -4  1  1  0  2 -2 -3  1 -2 -4 -1  1  0 -4 -2 -2  2  1  0 -8
	// D  0 -2  2  4 -6  2  4  1  1 -3 -4  0 -3 -6 -1  0  0 -7 -5 -2  3  3 -1 -8
	// C -2 -4 -4 -6 12 -6 -6 -4 -4 -2 -7 -6 -6 -5 -3  0 -2 -8  0 -2 -5 -6 -3 -8
	// Q -1  1  1  2 -6  5  3 -1  3 -2 -2  1 -1 -5  0 -1 -1 -5 -4 -2  1  4 -1 -8
	// E  0 -1  1  4 -6  3  4  0  1 -2 -4  0 -2 -6 -1  0 -1 -8 -5 -2  3  4 -1 -8
	// G  1 -3  0  1 -4 -1  0  5 -2 -3 -4 -2 -3 -5 -1  1  0 -7 -6 -2  0 -1 -1 -8
	// H -2  2  2  1 -4  3  1 -2  7 -3 -2  0 -2 -2  0 -1 -2 -3  0 -2  1  2 -1 -8
	// I -1 -2 -2 -3 -2 -2 -2 -3 -3  5  2 -2  2  1 -2 -2  0 -6 -1  4 -2 -2 -1 -8
	// L -2 -3 -3 -4 -7 -2 -4 -4 -2  2  6 -3  4  2 -3 -3 -2 -2 -1  2 -4 -3 -2 -8
	// K -1  4  1  0 -6  1  0 -2  0 -2 -3  5  0 -6 -1  0  0 -4 -5 -3  1  0 -1 -8
	// M -1 -1 -2 -3 -6 -1 -2 -3 -2  2  4  0  7  0 -2 -2 -1 -5 -3  2 -2 -2 -1 -8
	// F -4 -5 -4 -6 -5 -5 -6 -5 -2  1  2 -6  0  9 -5 -3 -3  0  7 -1 -5 -6 -3 -8
	// P  1  0 -1 -1 -3  0 -1 -1  0 -2 -3 -1 -2 -5  6  1  0 -6 -5 -1 -1  0 -1 -8
	// S  1  0  1  0  0 -1  0  1 -1 -2 -3  0 -2 -3  1  2  2 -3 -3 -1  0  0  0 -8
	// T  1 -1  0  0 -2 -1 -1  0 -2  0 -2  0 -1 -3  0  2  3 -6 -3  0  0 -1  0 -8
	// W -6  2 -4 -7 -8 -5 -8 -7 -3 -6 -2 -4 -5  0 -6 -3 -6 17  0 -7 -6 -6 -4 -8
	// Y -4 -5 -2 -5  0 -4 -5 -6  0 -1 -1 -5 -3  7 -5 -3 -3  0 10 -3 -3 -5 -3 -8
	// V  0 -3 -2 -2 -2 -2 -2 -2 -2  4  2 -3  2 -1 -1 -1  0 -7 -3  5 -2 -2 -1 -8
	// B  0 -1  2  3 -5  1  3  0  1 -2 -4  1 -2 -5 -1  0  0 -6 -3 -2  3  2 -1 -8
	// Z  0  0  1  3 -6  4  4 -1  2 -2 -3  0 -2 -6  0  0 -1 -6 -5 -2  2  4 -1 -8
	// X  0 -1  0 -1 -3 -1 -1 -1 -1 -1 -2 -1 -1 -3 -1  0  0 -4 -3 -1 -1 -1 -1 -8
	// * -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8  1
	//
	PAM230 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 2, 0, -2, 0, 0, -4, 1, -2, -1, 0, -1, -2, -1, 0, 1, -1, -2, 1, 1, 0, -6, 0, -4, 0, -8},
		/* B */ {0, 0, 3, -5, 3, 3, -5, 0, 1, -2, 0, 1, -4, -2, 2, -1, 1, -1, 0, 0, -2, -6, -1, -3, 2, -8},
		/* C */ {0, -2, -5, 12, -6, -6, -5, -4, -4, -2, 0, -6, -7, -6, -4, -3, -6, -4, 0, -2, -2, -8, -3, 0, -6, -8},
		/* D */ {0, 0, 3, -6, 4, 4, -6, 1, 1, -3, 0, 0, -4, -3, 2, -1, 2, -2, 0, 0, -2, -7, -1, -5, 3, -8},
		/* E */ {0, 0, 3, -6, 4, 4, -6, 0, 1, -2, 0, 0, -4, -2, 1, -1, 3, -1, 0, -1, -2, -8, -1, -5, 4, -8},
		/* F */ {0, -4, -5, -5, -6, -6, 9, -5, -2, 1, 0, -6, 2, 0, -4, -5, -5, -5, -3, -3, -1, 0, -3, 7, -6, -8},
		/* G */ {0, 1, 0, -4, 1, 0, -5, 5, -2, -3, 0, -2, -4, -3, 0, -1, -1, -3, 1, 0, -2, -7, -1, -6, -1, -8},
		/* H */ {0, -2, 1, -4, 1, 1, -2, -2, 7, -3, 0, 0, -2, -2, 2, 0, 3, 2, -1, -2, -2, -3, -1, 0, 2, -8},
		/* I */ {0, -1, -2, -2, -3, -2, 1, -3, -3, 5, 0, -2, 2, 2, -2, -2, -2, -2, -2, 0, 4, -6, -1, -1, -2, -8},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 1, -6, 0, 0, -6, -2, 0, -2, 0, 5, -3, 0, 1, -1, 1, 4, 0, 0, -3, -4, -1, -5, 0, -8},
		/* L */ {0, -2, -4, -7, -4, -4, 2, -4, -2, 2, 0, -3, 6, 4, -3, -3, -2, -3, -3, -2, 2, -2, -2, -1, -3, -8},
		/* M */ {0, -1, -2, -6, -3, -2, 0, -3, -2, 2, 0, 0, 4, 7, -2, -2, -1, -1, -2, -1, 2, -5, -1, -3, -2, -8},
		/* N */ {0, 0, 2, -4, 2, 1, -4, 0, 2, -2, 0, 1, -3, -2, 2, -1, 1, 0, 1, 0, -2, -4, 0, -2, 1, -8},
		/* P */ {0, 1, -1, -3, -1, -1, -5, -1, 0, -2, 0, -1, -3, -2, -1, 6, 0, 0, 1, 0, -1, -6, -1, -5, 0, -8},
		/* Q */ {0, -1, 1, -6, 2, 3, -5, -1, 3, -2, 0, 1, -2, -1, 1, 0, 5, 1, -1, -1, -2, -5, -1, -4, 4, -8},
		/* R */ {0, -2, -1, -4, -2, -1, -5, -3, 2, -2, 0, 4, -3, -1, 0, 0, 1, 7, 0, -1, -3, 2, -1, -5, 0, -8},
		/* S */ {0, 1, 0, 0, 0, 0, -3, 1, -1, -2, 0, 0, -3, -2, 1, 1, -1, 0, 2, 2, -1, -3, 0, -3, 0, -8},
		/* T */ {0, 1, 0, -2, 0, -1, -3, 0, -2, 0, 0, 0, -2, -1, 0, 0, -1, -1, 2, 3, 0, -6, 0, -3, -1, -8},
		/* V */ {0, 0, -2, -2, -2, -2, -1, -2, -2, 4, 0, -3, 2, 2, -2, -1, -2, -3, -1, 0, 5, -7, -1, -3, -2, -8},
		/* W */ {0, -6, -6, -8, -7, -8, 0, -7, -3, -6, 0, -4, -2, -5, -4, -6, -5, 2, -3, -6, -7, 17, -4, 0, -6, -8},
		/* X */ {0, 0, -1, -3, -1, -1, -3, -1, -1, -1, 0, -1, -2, -1, 0, -1, -1, -1, 0, 0, -1, -4, -1, -3, -1, -8},
		/* Y */ {0, -4, -3, 0, -5, -5, 7, -6, 0, -1, 0, -5, -1, -3, -2, -5, -4, -5, -3, -3, -3, 0, -3, 10, -5, -8},
		/* Z */ {0, 0, 2, -6, 3, 4, -6, -1, 2, -2, 0, 0, -3, -2, 1, 0, 4, 0, 0, -1, -2, -6, -1, -5, 4, -8},
		/* * */ {0, -8, -8, -8, -8, -8, -8, -8, -8, -8, 0, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 240 substitution matrix, scale = ln(2)/3 = 0.231049
	// #
	// # Expected score = -0.923, Entropy = 0.379 bits
	// #
	// # Lowest score = -8, Highest score = 17
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  2 -2  0  0 -2  0  0  1 -1 -1 -2 -1 -1 -4  1  1  1 -6 -4  0  0  0  0 -8
	// R -2  6  0 -1 -4  1 -1 -3  2 -2 -3  3  0 -5  0  0 -1  2 -4 -3 -1  0 -1 -8
	// N  0  0  2  2 -4  1  1  0  2 -2 -3  1 -2 -4 -1  1  0 -4 -2 -2  2  1  0 -8
	// D  0 -1  2  4 -5  2  4  1  1 -2 -4  0 -3 -6 -1  0  0 -7 -4 -2  3  3 -1 -8
	// C -2 -4 -4 -5 12 -6 -6 -4 -4 -2 -6 -6 -5 -5 -3  0 -2 -8  0 -2 -5 -6 -3 -8
	// Q  0  1  1  2 -6  4  3 -1  3 -2 -2  1 -1 -5  0 -1 -1 -5 -4 -2  1  3 -1 -8
	// E  0 -1  1  4 -6  3  4  0  1 -2 -3  0 -2 -6 -1  0  0 -7 -4 -2  3  3 -1 -8
	// G  1 -3  0  1 -4 -1  0  5 -2 -3 -4 -2 -3 -5 -1  1  0 -7 -5 -1  0  0 -1 -8
	// H -1  2  2  1 -4  3  1 -2  7 -3 -2  0 -2 -2  0 -1 -1 -3  0 -2  1  2 -1 -8
	// I -1 -2 -2 -2 -2 -2 -2 -3 -3  5  2 -2  2  1 -2 -1  0 -5 -1  4 -2 -2 -1 -8
	// L -2 -3 -3 -4 -6 -2 -3 -4 -2  2  6 -3  4  2 -3 -3 -2 -2 -1  2 -4 -3 -1 -8
	// K -1  3  1  0 -6  1  0 -2  0 -2 -3  5  0 -5 -1  0  0 -4 -5 -3  1  0 -1 -8
	// M -1  0 -2 -3 -5 -1 -2 -3 -2  2  4  0  7  0 -2 -2 -1 -4 -3  2 -2 -2 -1 -8
	// F -4 -5 -4 -6 -5 -5 -6 -5 -2  1  2 -5  0  9 -5 -3 -3  0  7 -1 -5 -5 -2 -8
	// P  1  0 -1 -1 -3  0 -1 -1  0 -2 -3 -1 -2 -5  6  1  0 -6 -5 -1 -1  0 -1 -8
	// S  1  0  1  0  0 -1  0  1 -1 -1 -3  0 -2 -3  1  2  1 -3 -3 -1  0  0  0 -8
	// T  1 -1  0  0 -2 -1  0  0 -1  0 -2  0 -1 -3  0  1  3 -5 -3  0  0 -1  0 -8
	// W -6  2 -4 -7 -8 -5 -7 -7 -3 -5 -2 -4 -4  0 -6 -3 -5 17  0 -6 -5 -6 -4 -8
	// Y -4 -4 -2 -4  0 -4 -4 -5  0 -1 -1 -5 -3  7 -5 -3 -3  0 10 -3 -3 -4 -2 -8
	// V  0 -3 -2 -2 -2 -2 -2 -1 -2  4  2 -3  2 -1 -1 -1  0 -6 -3  4 -2 -2 -1 -8
	// B  0 -1  2  3 -5  1  3  0  1 -2 -4  1 -2 -5 -1  0  0 -5 -3 -2  3  2 -1 -8
	// Z  0  0  1  3 -6  3  3  0  2 -2 -3  0 -2 -5  0  0 -1 -6 -4 -2  2  3 -1 -8
	// X  0 -1  0 -1 -3 -1 -1 -1 -1 -1 -1 -1 -1 -2 -1  0  0 -4 -2 -1 -1 -1 -1 -8
	// * -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8  1
	//
	PAM240 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 2, 0, -2, 0, 0, -4, 1, -1, -1, 0, -1, -2, -1, 0, 1, 0, -2, 1, 1, 0, -6, 0, -4, 0, -8},
		/* B */ {0, 0, 3, -5, 3, 3, -5, 0, 1, -2, 0, 1, -4, -2, 2, -1, 1, -1, 0, 0, -2, -5, -1, -3, 2, -8},
		/* C */ {0, -2, -5, 12, -5, -6, -5, -4, -4, -2, 0, -6, -6, -5, -4, -3, -6, -4, 0, -2, -2, -8, -3, 0, -6, -8},
		/* D */ {0, 0, 3, -5, 4, 4, -6, 1, 1, -2, 0, 0, -4, -3, 2, -1, 2, -1, 0, 0, -2, -7, -1, -4, 3, -8},
		/* E */ {0, 0, 3, -6, 4, 4, -6, 0, 1, -2, 0, 0, -3, -2, 1, -1, 3, -1, 0, 0, -2, -7, -1, -4, 3, -8},
		/* F */ {0, -4, -5, -5, -6, -6, 9, -5, -2, 1, 0, -5, 2, 0, -4, -5, -5, -5, -3, -3, -1, 0, -2, 7, -5, -8},
		/* G */ {0, 1, 0, -4, 1, 0, -5, 5, -2, -3, 0, -2, -4, -3, 0, -1, -1, -3, 1, 0, -1, -7, -1, -5, 0, -8},
		/* H */ {0, -1, 1, -4, 1, 1, -2, -2, 7, -3, 0, 0, -2, -2, 2, 0, 3, 2, -1, -1, -2, -3, -1, 0, 2, -8},
		/* I */ {0, -1, -2, -2, -2, -2, 1, -3, -3, 5, 0, -2, 2, 2, -2, -2, -2, -2, -1, 0, 4, -5, -1, -1, -2, -8},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 1, -6, 0, 0, -5, -2, 0, -2, 0, 5, -3, 0, 1, -1, 1, 3, 0, 0, -3, -4, -1, -5, 0, -8},
		/* L */ {0, -2, -4, -6, -4, -3, 2, -4, -2, 2, 0, -3, 6, 4, -3, -3, -2, -3, -3, -2, 2, -2, -1, -1, -3, -8},
		/* M */ {0, -1, -2, -5, -3, -2, 0, -3, -2, 2, 0, 0, 4, 7, -2, -2, -1, 0, -2, -1, 2, -4, -1, -3, -2, -8},
		/* N */ {0, 0, 2, -4, 2, 1, -4, 0, 2, -2, 0, 1, -3, -2, 2, -1, 1, 0, 1, 0, -2, -4, 0, -2, 1, -8},
		/* P */ {0, 1, -1, -3, -1, -1, -5, -1, 0, -2, 0, -1, -3, -2, -1, 6, 0, 0, 1, 0, -1, -6, -1, -5, 0, -8},
		/* Q */ {0, 0, 1, -6, 2, 3, -5, -1, 3, -2, 0, 1, -2, -1, 1, 0, 4, 1, -1, -1, -2, -5, -1, -4, 3, -8},
		/* R */ {0, -2, -1, -4, -1, -1, -5, -3, 2, -2, 0, 3, -3, 0, 0, 0, 1, 6, 0, -1, -3, 2, -1, -4, 0, -8},
		/* S */ {0, 1, 0, 0, 0, 0, -3, 1, -1, -1, 0, 0, -3, -2, 1, 1, -1, 0, 2, 1, -1, -3, 0, -3, 0, -8},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 0, -1, 0, 0, 0, -2, -1, 0, 0, -1, -1, 1, 3, 0, -5, 0, -3, -1, -8},
		/* V */ {0, 0, -2, -2, -2, -2, -1, -1, -2, 4, 0, -3, 2, 2, -2, -1, -2, -3, -1, 0, 4, -6, -1, -3, -2, -8},
		/* W */ {0, -6, -5, -8, -7, -7, 0, -7, -3, -5, 0, -4, -2, -4, -4, -6, -5, 2, -3, -5, -6, 17, -4, 0, -6, -8},
		/* X */ {0, 0, -1, -3, -1, -1, -2, -1, -1, -1, 0, -1, -1, -1, 0, -1, -1, -1, 0, 0, -1, -4, -1, -2, -1, -8},
		/* Y */ {0, -4, -3, 0, -4, -4, 7, -5, 0, -1, 0, -5, -1, -3, -2, -5, -4, -4, -3, -3, -3, 0, -2, 10, -4, -8},
		/* Z */ {0, 0, 2, -6, 3, 3, -5, 0, 2, -2, 0, 0, -3, -2, 1, 0, 3, 0, 0, -1, -2, -6, -1, -4, 3, -8},
		/* * */ {0, -8, -8, -8, -8, -8, -8, -8, -8, -8, 0, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 250 substitution matrix, scale = ln(2)/3 = 0.231049
	// #
	// # Expected score = -0.844, Entropy = 0.354 bits
	// #
	// # Lowest score = -8, Highest score = 17
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  2 -2  0  0 -2  0  0  1 -1 -1 -2 -1 -1 -3  1  1  1 -6 -3  0  0  0  0 -8
	// R -2  6  0 -1 -4  1 -1 -3  2 -2 -3  3  0 -4  0  0 -1  2 -4 -2 -1  0 -1 -8
	// N  0  0  2  2 -4  1  1  0  2 -2 -3  1 -2 -3  0  1  0 -4 -2 -2  2  1  0 -8
	// D  0 -1  2  4 -5  2  3  1  1 -2 -4  0 -3 -6 -1  0  0 -7 -4 -2  3  3 -1 -8
	// C -2 -4 -4 -5 12 -5 -5 -3 -3 -2 -6 -5 -5 -4 -3  0 -2 -8  0 -2 -4 -5 -3 -8
	// Q  0  1  1  2 -5  4  2 -1  3 -2 -2  1 -1 -5  0 -1 -1 -5 -4 -2  1  3 -1 -8
	// E  0 -1  1  3 -5  2  4  0  1 -2 -3  0 -2 -5 -1  0  0 -7 -4 -2  3  3 -1 -8
	// G  1 -3  0  1 -3 -1  0  5 -2 -3 -4 -2 -3 -5  0  1  0 -7 -5 -1  0  0 -1 -8
	// H -1  2  2  1 -3  3  1 -2  6 -2 -2  0 -2 -2  0 -1 -1 -3  0 -2  1  2 -1 -8
	// I -1 -2 -2 -2 -2 -2 -2 -3 -2  5  2 -2  2  1 -2 -1  0 -5 -1  4 -2 -2 -1 -8
	// L -2 -3 -3 -4 -6 -2 -3 -4 -2  2  6 -3  4  2 -3 -3 -2 -2 -1  2 -3 -3 -1 -8
	// K -1  3  1  0 -5  1  0 -2  0 -2 -3  5  0 -5 -1  0  0 -3 -4 -2  1  0 -1 -8
	// M -1  0 -2 -3 -5 -1 -2 -3 -2  2  4  0  6  0 -2 -2 -1 -4 -2  2 -2 -2 -1 -8
	// F -3 -4 -3 -6 -4 -5 -5 -5 -2  1  2 -5  0  9 -5 -3 -3  0  7 -1 -4 -5 -2 -8
	// P  1  0  0 -1 -3  0 -1  0  0 -2 -3 -1 -2 -5  6  1  0 -6 -5 -1 -1  0 -1 -8
	// S  1  0  1  0  0 -1  0  1 -1 -1 -3  0 -2 -3  1  2  1 -2 -3 -1  0  0  0 -8
	// T  1 -1  0  0 -2 -1  0  0 -1  0 -2  0 -1 -3  0  1  3 -5 -3  0  0 -1  0 -8
	// W -6  2 -4 -7 -8 -5 -7 -7 -3 -5 -2 -3 -4  0 -6 -2 -5 17  0 -6 -5 -6 -4 -8
	// Y -3 -4 -2 -4  0 -4 -4 -5  0 -1 -1 -4 -2  7 -5 -3 -3  0 10 -2 -3 -4 -2 -8
	// V  0 -2 -2 -2 -2 -2 -2 -1 -2  4  2 -2  2 -1 -1 -1  0 -6 -2  4 -2 -2 -1 -8
	// B  0 -1  2  3 -4  1  3  0  1 -2 -3  1 -2 -4 -1  0  0 -5 -3 -2  3  2 -1 -8
	// Z  0  0  1  3 -5  3  3  0  2 -2 -3  0 -2 -5  0  0 -1 -6 -4 -2  2  3 -1 -8
	// X  0 -1  0 -1 -3 -1 -1 -1 -1 -1 -1 -1 -1 -2 -1  0  0 -4 -2 -1 -1 -1 -1 -8
	// * -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8  1
	//
	PAM250 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 2, 0, -2, 0, 0, -3, 1, -1, -1, 0, -1, -2, -1, 0, 1, 0, -2, 1, 1, 0, -6, 0, -3, 0, -8},
		/* B */ {0, 0, 3, -4, 3, 3, -4, 0, 1, -2, 0, 1, -3, -2, 2, -1, 1, -1, 0, 0, -2, -5, -1, -3, 2, -8},
		/* C */ {0, -2, -4, 12, -5, -5, -4, -3, -3, -2, 0, -5, -6, -5, -4, -3, -5, -4, 0, -2, -2, -8, -3, 0, -5, -8},
		/* D */ {0, 0, 3, -5, 4, 3, -6, 1, 1, -2, 0, 0, -4, -3, 2, -1, 2, -1, 0, 0, -2, -7, -1, -4, 3, -8},
		/* E */ {0, 0, 3, -5, 3, 4, -5, 0, 1, -2, 0, 0, -3, -2, 1, -1, 2, -1, 0, 0, -2, -7, -1, -4, 3, -8},
		/* F */ {0, -3, -4, -4, -6, -5, 9, -5, -2, 1, 0, -5, 2, 0, -3, -5, -5, -4, -3, -3, -1, 0, -2, 7, -5, -8},
		/* G */ {0, 1, 0, -3, 1, 0, -5, 5, -2, -3, 0, -2, -4, -3, 0, 0, -1, -3, 1, 0, -1, -7, -1, -5, 0, -8},
		/* H */ {0, -1, 1, -3, 1, 1, -2, -2, 6, -2, 0, 0, -2, -2, 2, 0, 3, 2, -1, -1, -2, -3, -1, 0, 2, -8},
		/* I */ {0, -1, -2, -2, -2, -2, 1, -3, -2, 5, 0, -2, 2, 2, -2, -2, -2, -2, -1, 0, 4, -5, -1, -1, -2, -8},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 1, -5, 0, 0, -5, -2, 0, -2, 0, 5, -3, 0, 1, -1, 1, 3, 0, 0, -2, -3, -1, -4, 0, -8},
		/* L */ {0, -2, -3, -6, -4, -3, 2, -4, -2, 2, 0, -3, 6, 4, -3, -3, -2, -3, -3, -2, 2, -2, -1, -1, -3, -8},
		/* M */ {0, -1, -2, -5, -3, -2, 0, -3, -2, 2, 0, 0, 4, 6, -2, -2, -1, 0, -2, -1, 2, -4, -1, -2, -2, -8},
		/* N */ {0, 0, 2, -4, 2, 1, -3, 0, 2, -2, 0, 1, -3, -2, 2, 0, 1, 0, 1, 0, -2, -4, 0, -2, 1, -8},
		/* P */ {0, 1, -1, -3, -1, -1, -5, 0, 0, -2, 0, -1, -3, -2, 0, 6, 0, 0, 1, 0, -1, -6, -1, -5, 0, -8},
		/* Q */ {0, 0, 1, -5, 2, 2, -5, -1, 3, -2, 0, 1, -2, -1, 1, 0, 4, 1, -1, -1, -2, -5, -1, -4, 3, -8},
		/* R */ {0, -2, -1, -4, -1, -1, -4, -3, 2, -2, 0, 3, -3, 0, 0, 0, 1, 6, 0, -1, -2, 2, -1, -4, 0, -8},
		/* S */ {0, 1, 0, 0, 0, 0, -3, 1, -1, -1, 0, 0, -3, -2, 1, 1, -1, 0, 2, 1, -1, -2, 0, -3, 0, -8},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 0, -1, 0, 0, 0, -2, -1, 0, 0, -1, -1, 1, 3, 0, -5, 0, -3, -1, -8},
		/* V */ {0, 0, -2, -2, -2, -2, -1, -1, -2, 4, 0, -2, 2, 2, -2, -1, -2, -2, -1, 0, 4, -6, -1, -2, -2, -8},
		/* W */ {0, -6, -5, -8, -7, -7, 0, -7, -3, -5, 0, -3, -2, -4, -4, -6, -5, 2, -2, -5, -6, 17, -4, 0, -6, -8},
		/* X */ {0, 0, -1, -3, -1, -1, -2, -1, -1, -1, 0, -1, -1, -1, 0, -1, -1, -1, 0, 0, -1, -4, -1, -2, -1, -8},
		/* Y */ {0, -3, -3, 0, -4, -4, 7, -5, 0, -1, 0, -4, -1, -2, -2, -5, -4, -4, -3, -3, -2, 0, -2, 10, -4, -8},
		/* Z */ {0, 0, 2, -5, 3, 3, -5, 0, 2, -2, 0, 0, -3, -2, 1, 0, 3, 0, 0, -1, -2, -6, -1, -4, 3, -8},
		/* * */ {0, -8, -8, -8, -8, -8, -8, -8, -8, -8, 0, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 250 substitution matrix, scale = 0.0693200
	// #
	// # Expected score = -2.81, Entropy = 0.354 bits
	// #
	// # Lowest score = -26, Highest score = 57
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A   6  -5   1   1  -7  -1   1   4  -4  -2  -6  -4  -4 -12   4   4   4 -19 -12   1   1   0  -1 -26
	// R  -5  20   0  -4 -12   4  -4  -8   5  -7 -10  11  -1 -15  -1  -1  -3   7 -14  -8  -2   0  -3 -26
	// N   1   0   7   7 -12   3   5   1   5  -6 -10   3  -6 -12  -2   2   1 -13  -7  -6   7   4  -1 -26
	// D   1  -4   7  13 -17   5  11   2   2  -8 -13   0  -9 -19  -3   1   0 -22 -14  -7  10   9  -2 -26
	// C  -7 -12 -12 -17  40 -18 -18 -11 -11  -8 -20 -18 -17 -14  -9   0  -7 -26   1  -6 -15 -18 -10 -26
	// Q  -1   4   3   5 -18  13   8  -4  10  -7  -6   2  -3 -15   1  -2  -3 -16 -13  -6   4  11  -2 -26
	// E   1  -4   5  11 -18   8  13   1   2  -7 -11   0  -7 -18  -2   0  -1 -23 -14  -6   9  11  -2 -26
	// G   4  -8   1   2 -11  -4   1  16  -7  -8 -13  -6  -9 -16  -2   4   0 -23 -17  -4   2  -1  -3 -26
	// H  -4   5   5   2 -11  10   2  -7  22  -8  -7   0  -7  -6  -1  -3  -4  -9   0  -7   4   6  -2 -26
	// I  -2  -7  -6  -8  -8  -7  -7  -8  -8  15   8  -6   7   3  -7  -5   0 -17  -3  12  -7  -7  -2 -26
	// L  -6 -10 -10 -13 -20  -6 -11 -13  -7   8  20  -9  12   6  -8  -9  -6  -6  -3   6 -11  -9  -4 -26
	// K  -4  11   3   0 -18   2   0  -6   0  -6  -9  15   1 -17  -4  -1   0 -12 -15  -8   2   1  -3 -26
	// M  -4  -1  -6  -9 -17  -3  -7  -9  -7   7  12   1  21   1  -7  -5  -2 -14  -8   6  -7  -5  -2 -26
	// F -12 -15 -12 -19 -14 -15 -18 -16  -6   3   6 -17   1  30 -15 -11 -10   1  23  -4 -15 -17  -8 -26
	// P   4  -1  -2  -3  -9   1  -2  -2  -1  -7  -8  -4  -7 -15  19   3   1 -19 -16  -4  -2  -1  -2 -26
	// S   4  -1   2   1   0  -2   0   4  -3  -5  -9  -1  -5 -11   3   5   4  -8  -9  -3   2  -1  -1 -26
	// T   4  -3   1   0  -7  -3  -1   0  -4   0  -6   0  -2 -10   1   4   9 -17  -9   1   0  -2  -1 -26
	// W -19   7 -13 -22 -26 -16 -23 -23  -9 -17  -6 -12 -14   1 -19  -8 -17  57   0 -21 -18 -19 -13 -26
	// Y -12 -14  -7 -14   1 -13 -14 -17   0  -3  -3 -15  -8  23 -16  -9  -9   0  34  -8 -10 -14  -8 -26
	// V   1  -8  -6  -7  -6  -6  -6  -4  -7  12   6  -8   6  -4  -4  -3   1 -21  -8  14  -6  -6  -2 -26
	// B   1  -2   7  10 -15   4   9   2   4  -7 -11   2  -7 -15  -2   2   0 -18 -10  -6   9   7  -2 -26
	// Z   0   0   4   9 -18  11  11  -1   6  -7  -9   1  -5 -17  -1  -1  -2 -19 -14  -6   7  11  -2 -26
	// X  -1  -3  -1  -2 -10  -2  -2  -3  -2  -2  -4  -3  -2  -8  -2  -1  -1 -13  -8  -2  -2  -2  -3 -26
	// * -26 -26 -26 -26 -26 -26 -26 -26 -26 -26 -26 -26 -26 -26 -26 -26 -26 -26 -26 -26 -26 -26 -26   1
	//
	PAM250_cdi = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 6, 1, -7, 1, 1, -12, 4, -4, -2, 0, -4, -6, -4, 1, 4, -1, -5, 4, 4, 1, -19, -1, -12, 0, -26},
		/* B */ {0, 1, 9, -15, 10, 9, -15, 2, 4, -7, 0, 2, -11, -7, 7, -2, 4, -2, 2, 0, -6, -18, -2, -10, 7, -26},
		/* C */ {0, -7, -15, 40, -17, -18, -14, -11, -11, -8, 0, -18, -20, -17, -12, -9, -18, -12, 0, -7, -6, -26, -10, 1, -18, -26},
		/* D */ {0, 1, 10, -17, 13, 11, -19, 2, 2, -8, 0, 0, -13, -9, 7, -3, 5, -4, 1, 0, -7, -22, -2, -14, 9, -26},
		/* E */ {0, 1, 9, -18, 11, 13, -18, 1, 2, -7, 0, 0, -11, -7, 5, -2, 8, -4, 0, -1, -6, -23, -2, -14, 11, -26},
		/* F */ {0, -12, -15, -14, -19, -18, 30, -16, -6, 3, 0, -17, 6, 1, -12, -15, -15, -15, -11, -10, -4, 1, -8, 23, -17, -26},
		/* G */ {0, 4, 2, -11, 2, 1, -16, 16, -7, -8, 0, -6, -13, -9, 1, -2, -4, -8, 4, 0, -4, -23, -3, -17, -1, -26},
		/* H */ {0, -4, 4, -11, 2, 2, -6, -7, 22, -8, 0, 0, -7, -7, 5, -1, 10, 5, -3, -4, -7, -9, -2, 0, 6, -26},
		/* I */ {0, -2, -7, -8, -8, -7, 3, -8, -8, 15, 0, -6, 8, 7, -6, -7, -7, -7, -5, 0, 12, -17, -2, -3, -7, -26},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -4, 2, -18, 0, 0, -17, -6, 0, -6, 0, 15, -9, 1, 3, -4, 2, 11, -1, 0, -8, -12, -3, -15, 1, -26},
		/* L */ {0, -6, -11, -20, -13, -11, 6, -13, -7, 8, 0, -9, 20, 12, -10, -8, -6, -10, -9, -6, 6, -6, -4, -3, -9, -26},
		/* M */ {0, -4, -7, -17, -9, -7, 1, -9, -7, 7, 0, 1, 12, 21, -6, -7, -3, -1, -5, -2, 6, -14, -2, -8, -5, -26},
		/* N */ {0, 1, 7, -12, 7, 5, -12, 1, 5, -6, 0, 3, -10, -6, 7, -2, 3, 0, 2, 1, -6, -13, -1, -7, 4, -26},
		/* P */ {0, 4, -2, -9, -3, -2, -15, -2, -1, -7, 0, -4, -8, -7, -2, 19, 1, -1, 3, 1, -4, -19, -2, -16, -1, -26},
		/* Q */ {0, -1, 4, -18, 5, 8, -15, -4, 10, -7, 0, 2, -6, -3, 3, 1, 13, 4, -2, -3, -6, -16, -2, -13, 11, -26},
		/* R */ {0, -5, -2, -12, -4, -4, -15, -8, 5, -7, 0, 11, -10, -1, 0, -1, 4, 20, -1, -3, -8, 7, -3, -14, 0, -26},
		/* S */ {0, 4, 2, 0, 1, 0, -11, 4, -3, -5, 0, -1, -9, -5, 2, 3, -2, -1, 5, 4, -3, -8, -1, -9, -1, -26},
		/* T */ {0, 4, 0, -7, 0, -1, -10, 0, -4, 0, 0, 0, -6, -2, 1, 1, -3, -3, 4, 9, 1, -17, -1, -9, -2, -26},
		/* V */ {0, 1, -6, -6, -7, -6, -4, -4, -7, 12, 0, -8, 6, 6, -6, -4, -6, -8, -3, 1, 14, -21, -2, -8, -6, -26},
		/* W */ {0, -19, -18, -26, -22, -23, 1, -23, -9, -17, 0, -12, -6, -14, -13, -19, -16, 7, -8, -17, -21, 57, -13, 0, -19, -26},
		/* X */ {0, -1, -2, -10, -2, -2, -8, -3, -2, -2, 0, -3, -4, -2, -1, -2, -2, -3, -1, -1, -2, -13, -3, -8, -2, -26},
		/* Y */ {0, -12, -10, 1, -14, -14, 23, -17, 0, -3, 0, -15, -3, -8, -7, -16, -13, -14, -9, -9, -8, 0, -8, 34, -14, -26},
		/* Z */ {0, 0, 7, -18, 9, 11, -17, -1, 6, -7, 0, 1, -9, -5, 4, -1, 11, 0, -1, -2, -6, -19, -2, -14, 11, -26},
		/* * */ {0, -26, -26, -26, -26, -26, -26, -26, -26, -26, 0, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 260 substitution matrix, scale = ln(2)/3 = 0.231049
	// #
	// # Expected score = -0.794, Entropy = 0.330 bits
	// #
	// # Lowest score = -7, Highest score = 17
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  2 -1  0  0 -2  0  0  1 -1  0 -2 -1 -1 -3  1  1  1 -6 -3  0  0  0  0 -7
	// R -1  6  0 -1 -4  1 -1 -2  2 -2 -3  3  0 -4  0  0 -1  2 -4 -2 -1  0 -1 -7
	// N  0  0  2  2 -3  1  1  0  2 -2 -3  1 -2 -3  0  1  0 -4 -2 -2  2  1  0 -7
	// D  0 -1  2  4 -5  2  3  1  1 -2 -4  0 -2 -5 -1  0  0 -6 -4 -2  3  3 -1 -7
	// C -2 -4 -3 -5 12 -5 -5 -3 -3 -2 -6 -5 -5 -4 -3  0 -2 -7  0 -2 -4 -5 -3 -7
	// Q  0  1  1  2 -5  4  2 -1  3 -2 -2  1 -1 -4  0  0 -1 -5 -4 -2  1  3  0 -7
	// E  0 -1  1  3 -5  2  4  0  1 -2 -3  0 -2 -5  0  0  0 -7 -4 -2  3  3 -1 -7
	// G  1 -2  0  1 -3 -1  0  5 -2 -2 -4 -2 -3 -5  0  1  0 -7 -5 -1  1  0 -1 -7
	// H -1  2  2  1 -3  3  1 -2  6 -2 -2  0 -2 -2  0 -1 -1 -3  0 -2  1  2 -1 -7
	// I  0 -2 -2 -2 -2 -2 -2 -2 -2  4  2 -2  2  1 -2 -1  0 -5 -1  4 -2 -2 -1 -7
	// L -2 -3 -3 -4 -6 -2 -3 -4 -2  2  6 -3  4  2 -2 -3 -2 -2 -1  2 -3 -2 -1 -7
	// K -1  3  1  0 -5  1  0 -2  0 -2 -3  4  0 -5 -1  0  0 -3 -4 -2  1  0 -1 -7
	// M -1  0 -2 -2 -5 -1 -2 -3 -2  2  4  0  6  0 -2 -1 -1 -4 -2  2 -2 -2 -1 -7
	// F -3 -4 -3 -5 -4 -4 -5 -5 -2  1  2 -5  0  9 -4 -3 -3  0  7 -1 -4 -5 -2 -7
	// P  1  0  0 -1 -3  0  0  0  0 -2 -2 -1 -2 -4  6  1  0 -5 -5 -1 -1  0 -1 -7
	// S  1  0  1  0  0  0  0  1 -1 -1 -3  0 -1 -3  1  1  1 -2 -3 -1  0  0  0 -7
	// T  1 -1  0  0 -2 -1  0  0 -1  0 -2  0 -1 -3  0  1  2 -5 -3  0  0  0  0 -7
	// W -6  2 -4 -6 -7 -5 -7 -7 -3 -5 -2 -3 -4  0 -5 -2 -5 17  0 -6 -5 -6 -4 -7
	// Y -3 -4 -2 -4  0 -4 -4 -5  0 -1 -1 -4 -2  7 -5 -3 -3  0 10 -2 -3 -4 -2 -7
	// V  0 -2 -2 -2 -2 -2 -2 -1 -2  4  2 -2  2 -1 -1 -1  0 -6 -2  4 -2 -2 -1 -7
	// B  0 -1  2  3 -4  1  3  1  1 -2 -3  1 -2 -4 -1  0  0 -5 -3 -2  3  2  0 -7
	// Z  0  0  1  3 -5  3  3  0  2 -2 -2  0 -2 -5  0  0  0 -6 -4 -2  2  3 -1 -7
	// X  0 -1  0 -1 -3  0 -1 -1 -1 -1 -1 -1 -1 -2 -1  0  0 -4 -2 -1  0 -1 -1 -7
	// * -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7 -7  1
	//
	PAM260 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 2, 0, -2, 0, 0, -3, 1, -1, 0, 0, -1, -2, -1, 0, 1, 0, -1, 1, 1, 0, -6, 0, -3, 0, -7},
		/* B */ {0, 0, 3, -4, 3, 3, -4, 1, 1, -2, 0, 1, -3, -2, 2, -1, 1, -1, 0, 0, -2, -5, 0, -3, 2, -7},
		/* C */ {0, -2, -4, 12, -5, -5, -4, -3, -3, -2, 0, -5, -6, -5, -3, -3, -5, -4, 0, -2, -2, -7, -3, 0, -5, -7},
		/* D */ {0, 0, 3, -5, 4, 3, -5, 1, 1, -2, 0, 0, -4, -2, 2, -1, 2, -1, 0, 0, -2, -6, -1, -4, 3, -7},
		/* E */ {0, 0, 3, -5, 3, 4, -5, 0, 1, -2, 0, 0, -3, -2, 1, 0, 2, -1, 0, 0, -2, -7, -1, -4, 3, -7},
		/* F */ {0, -3, -4, -4, -5, -5, 9, -5, -2, 1, 0, -5, 2, 0, -3, -4, -4, -4, -3, -3, -1, 0, -2, 7, -5, -7},
		/* G */ {0, 1, 1, -3, 1, 0, -5, 5, -2, -2, 0, -2, -4, -3, 0, 0, -1, -2, 1, 0, -1, -7, -1, -5, 0, -7},
		/* H */ {0, -1, 1, -3, 1, 1, -2, -2, 6, -2, 0, 0, -2, -2, 2, 0, 3, 2, -1, -1, -2, -3, -1, 0, 2, -7},
		/* I */ {0, 0, -2, -2, -2, -2, 1, -2, -2, 4, 0, -2, 2, 2, -2, -2, -2, -2, -1, 0, 4, -5, -1, -1, -2, -7},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 1, -5, 0, 0, -5, -2, 0, -2, 0, 4, -3, 0, 1, -1, 1, 3, 0, 0, -2, -3, -1, -4, 0, -7},
		/* L */ {0, -2, -3, -6, -4, -3, 2, -4, -2, 2, 0, -3, 6, 4, -3, -2, -2, -3, -3, -2, 2, -2, -1, -1, -2, -7},
		/* M */ {0, -1, -2, -5, -2, -2, 0, -3, -2, 2, 0, 0, 4, 6, -2, -2, -1, 0, -1, -1, 2, -4, -1, -2, -2, -7},
		/* N */ {0, 0, 2, -3, 2, 1, -3, 0, 2, -2, 0, 1, -3, -2, 2, 0, 1, 0, 1, 0, -2, -4, 0, -2, 1, -7},
		/* P */ {0, 1, -1, -3, -1, 0, -4, 0, 0, -2, 0, -1, -2, -2, 0, 6, 0, 0, 1, 0, -1, -5, -1, -5, 0, -7},
		/* Q */ {0, 0, 1, -5, 2, 2, -4, -1, 3, -2, 0, 1, -2, -1, 1, 0, 4, 1, 0, -1, -2, -5, 0, -4, 3, -7},
		/* R */ {0, -1, -1, -4, -1, -1, -4, -2, 2, -2, 0, 3, -3, 0, 0, 0, 1, 6, 0, -1, -2, 2, -1, -4, 0, -7},
		/* S */ {0, 1, 0, 0, 0, 0, -3, 1, -1, -1, 0, 0, -3, -1, 1, 1, 0, 0, 1, 1, -1, -2, 0, -3, 0, -7},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 0, -1, 0, 0, 0, -2, -1, 0, 0, -1, -1, 1, 2, 0, -5, 0, -3, 0, -7},
		/* V */ {0, 0, -2, -2, -2, -2, -1, -1, -2, 4, 0, -2, 2, 2, -2, -1, -2, -2, -1, 0, 4, -6, -1, -2, -2, -7},
		/* W */ {0, -6, -5, -7, -6, -7, 0, -7, -3, -5, 0, -3, -2, -4, -4, -5, -5, 2, -2, -5, -6, 17, -4, 0, -6, -7},
		/* X */ {0, 0, 0, -3, -1, -1, -2, -1, -1, -1, 0, -1, -1, -1, 0, -1, 0, -1, 0, 0, -1, -4, -1, -2, -1, -7},
		/* Y */ {0, -3, -3, 0, -4, -4, 7, -5, 0, -1, 0, -4, -1, -2, -2, -5, -4, -4, -3, -3, -2, 0, -2, 10, -4, -7},
		/* Z */ {0, 0, 2, -5, 3, 3, -5, 0, 2, -2, 0, 0, -2, -2, 1, 0, 3, 0, 0, 0, -2, -6, -1, -4, 3, -7},
		/* * */ {0, -7, -7, -7, -7, -7, -7, -7, -7, -7, 0, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 270 substitution matrix, scale = ln(2)/4 = 0.173287
	// #
	// # Expected score = -0.969, Entropy = 0.309 bits
	// #
	// # Lowest score = -10, Highest score = 23
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A   2  -2   0   0  -2   0   0   2  -2  -1  -2  -1  -1  -4   1   1   1  -7  -4   0   0   0   0 -10
	// R  -2   8   0  -1  -5   2  -1  -3   2  -2  -4   4  -1  -5   0   0  -1   3  -5  -3  -1   0  -1 -10
	// N   0   0   2   2  -4   1   2   1   2  -2  -3   1  -2  -4   0   1   1  -5  -3  -2   2   2   0 -10
	// D   0  -1   2   5  -6   2   4   1   1  -3  -5   0  -3  -7  -1   0   0  -8  -5  -3   4   3  -1 -10
	// C  -2  -5  -4  -6  16  -7  -6  -4  -4  -3  -7  -7  -6  -5  -3   0  -3 -10   1  -2  -5  -7  -4 -10
	// Q   0   2   1   2  -7   5   3  -1   4  -2  -2   1  -1  -6   0  -1  -1  -6  -5  -2   2   4  -1 -10
	// E   0  -1   2   4  -6   3   5   0   1  -2  -4   0  -3  -7  -1   0   0  -9  -5  -2   3   4  -1 -10
	// G   2  -3   1   1  -4  -1   0   6  -2  -3  -5  -2  -3  -6   0   1   0  -9  -6  -2   1   0  -1 -10
	// H  -2   2   2   1  -4   4   1  -2   8  -3  -3   0  -3  -2   0  -1  -1  -3   0  -3   1   2  -1 -10
	// I  -1  -2  -2  -3  -3  -2  -2  -3  -3   5   3  -2   3   1  -2  -2   0  -6  -1   5  -3  -2  -1 -10
	// L  -2  -4  -3  -5  -7  -2  -4  -5  -3   3   8  -3   5   2  -3  -3  -2  -2  -1   2  -4  -3  -2 -10
	// K  -1   4   1   0  -7   1   0  -2   0  -2  -3   6   0  -6  -1   0   0  -4  -5  -3   1   0  -1 -10
	// M  -1  -1  -2  -3  -6  -1  -3  -3  -3   3   5   0   8   0  -2  -2  -1  -5  -3   2  -3  -2  -1 -10
	// F  -4  -5  -4  -7  -5  -6  -7  -6  -2   1   2  -6   0  12  -6  -4  -4   1   9  -1  -6  -6  -3 -10
	// P   1   0   0  -1  -3   0  -1   0   0  -2  -3  -1  -2  -6   7   1   0  -7  -6  -1  -1   0  -1 -10
	// S   1   0   1   0   0  -1   0   1  -1  -2  -3   0  -2  -4   1   2   2  -3  -4  -1   1   0   0 -10
	// T   1  -1   1   0  -3  -1   0   0  -1   0  -2   0  -1  -4   0   2   3  -6  -3   0   0  -1   0 -10
	// W  -7   3  -5  -8 -10  -6  -9  -9  -3  -6  -2  -4  -5   1  -7  -3  -6  23   0  -8  -7  -7  -5 -10
	// Y  -4  -5  -3  -5   1  -5  -5  -6   0  -1  -1  -5  -3   9  -6  -4  -3   0  13  -3  -4  -5  -3 -10
	// V   0  -3  -2  -3  -2  -2  -2  -2  -3   5   2  -3   2  -1  -1  -1   0  -8  -3   5  -2  -2  -1 -10
	// B   0  -1   2   4  -5   2   3   1   1  -3  -4   1  -3  -6  -1   1   0  -7  -4  -2   3   3  -1 -10
	// Z   0   0   2   3  -7   4   4   0   2  -2  -3   0  -2  -6   0   0  -1  -7  -5  -2   3   4  -1 -10
	// X   0  -1   0  -1  -4  -1  -1  -1  -1  -1  -2  -1  -1  -3  -1   0   0  -5  -3  -1  -1  -1  -1 -10
	// * -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10   1
	//
	PAM270 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 2, 0, -2, 0, 0, -4, 2, -2, -1, 0, -1, -2, -1, 0, 1, 0, -2, 1, 1, 0, -7, 0, -4, 0, -10},
		/* B */ {0, 0, 3, -5, 4, 3, -6, 1, 1, -3, 0, 1, -4, -3, 2, -1, 2, -1, 1, 0, -2, -7, -1, -4, 3, -10},
		/* C */ {0, -2, -5, 16, -6, -6, -5, -4, -4, -3, 0, -7, -7, -6, -4, -3, -7, -5, 0, -3, -2, -10, -4, 1, -7, -10},
		/* D */ {0, 0, 4, -6, 5, 4, -7, 1, 1, -3, 0, 0, -5, -3, 2, -1, 2, -1, 0, 0, -3, -8, -1, -5, 3, -10},
		/* E */ {0, 0, 3, -6, 4, 5, -7, 0, 1, -2, 0, 0, -4, -3, 2, -1, 3, -1, 0, 0, -2, -9, -1, -5, 4, -10},
		/* F */ {0, -4, -6, -5, -7, -7, 12, -6, -2, 1, 0, -6, 2, 0, -4, -6, -6, -5, -4, -4, -1, 1, -3, 9, -6, -10},
		/* G */ {0, 2, 1, -4, 1, 0, -6, 6, -2, -3, 0, -2, -5, -3, 1, 0, -1, -3, 1, 0, -2, -9, -1, -6, 0, -10},
		/* H */ {0, -2, 1, -4, 1, 1, -2, -2, 8, -3, 0, 0, -3, -3, 2, 0, 4, 2, -1, -1, -3, -3, -1, 0, 2, -10},
		/* I */ {0, -1, -3, -3, -3, -2, 1, -3, -3, 5, 0, -2, 3, 3, -2, -2, -2, -2, -2, 0, 5, -6, -1, -1, -2, -10},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 1, -7, 0, 0, -6, -2, 0, -2, 0, 6, -3, 0, 1, -1, 1, 4, 0, 0, -3, -4, -1, -5, 0, -10},
		/* L */ {0, -2, -4, -7, -5, -4, 2, -5, -3, 3, 0, -3, 8, 5, -3, -3, -2, -4, -3, -2, 2, -2, -2, -1, -3, -10},
		/* M */ {0, -1, -3, -6, -3, -3, 0, -3, -3, 3, 0, 0, 5, 8, -2, -2, -1, -1, -2, -1, 2, -5, -1, -3, -2, -10},
		/* N */ {0, 0, 2, -4, 2, 2, -4, 1, 2, -2, 0, 1, -3, -2, 2, 0, 1, 0, 1, 1, -2, -5, 0, -3, 2, -10},
		/* P */ {0, 1, -1, -3, -1, -1, -6, 0, 0, -2, 0, -1, -3, -2, 0, 7, 0, 0, 1, 0, -1, -7, -1, -6, 0, -10},
		/* Q */ {0, 0, 2, -7, 2, 3, -6, -1, 4, -2, 0, 1, -2, -1, 1, 0, 5, 2, -1, -1, -2, -6, -1, -5, 4, -10},
		/* R */ {0, -2, -1, -5, -1, -1, -5, -3, 2, -2, 0, 4, -4, -1, 0, 0, 2, 8, 0, -1, -3, 3, -1, -5, 0, -10},
		/* S */ {0, 1, 1, 0, 0, 0, -4, 1, -1, -2, 0, 0, -3, -2, 1, 1, -1, 0, 2, 2, -1, -3, 0, -4, 0, -10},
		/* T */ {0, 1, 0, -3, 0, 0, -4, 0, -1, 0, 0, 0, -2, -1, 1, 0, -1, -1, 2, 3, 0, -6, 0, -3, -1, -10},
		/* V */ {0, 0, -2, -2, -3, -2, -1, -2, -3, 5, 0, -3, 2, 2, -2, -1, -2, -3, -1, 0, 5, -8, -1, -3, -2, -10},
		/* W */ {0, -7, -7, -10, -8, -9, 1, -9, -3, -6, 0, -4, -2, -5, -5, -7, -6, 3, -3, -6, -8, 23, -5, 0, -7, -10},
		/* X */ {0, 0, -1, -4, -1, -1, -3, -1, -1, -1, 0, -1, -2, -1, 0, -1, -1, -1, 0, 0, -1, -5, -1, -3, -1, -10},
		/* Y */ {0, -4, -4, 1, -5, -5, 9, -6, 0, -1, 0, -5, -1, -3, -3, -6, -5, -5, -4, -3, -3, 0, -3, 13, -5, -10},
		/* Z */ {0, 0, 3, -7, 3, 4, -6, 0, 2, -2, 0, 0, -3, -2, 2, 0, 4, 0, 0, -1, -2, -7, -1, -5, 4, -10},
		/* * */ {0, -10, -10, -10, -10, -10, -10, -10, -10, -10, 0, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 280 substitution matrix, scale = ln(2)/4 = 0.173287
	// #
	// # Expected score = -0.916, Entropy = 0.289 bits
	// #
	// # Lowest score = -9, Highest score = 22
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  2 -2  0  0 -2  0  0  2 -1 -1 -2 -1 -1 -4  1  1  1 -7 -4  0  0  0  0 -9
	// R -2  7  0 -1 -4  2 -1 -3  2 -2 -3  4  0 -5  0  0 -1  3 -5 -3 -1  0 -1 -9
	// N  0  0  2  2 -4  1  2  1  2 -2 -3  1 -2 -4  0  1  1 -5 -3 -2  2  1  0 -9
	// D  0 -1  2  4 -6  2  4  1  1 -3 -5  0 -3 -7 -1  0  0 -8 -5 -2  4  3 -1 -9
	// C -2 -4 -4 -6 15 -6 -6 -4 -4 -3 -7 -6 -6 -5 -3  0 -3 -9  1 -2 -5 -6 -3 -9
	// Q  0  2  1  2 -6  4  3 -1  3 -2 -2  1 -1 -5  0  0 -1 -6 -5 -2  2  4 -1 -9
	// E  0 -1  2  4 -6  3  4  0  1 -2 -4  0 -2 -6  0  0  0 -8 -5 -2  3  4 -1 -9
	// G  2 -3  1  1 -4 -1  0  6 -2 -3 -5 -2 -3 -6  0  1  0 -8 -6 -1  1  0 -1 -9
	// H -1  2  2  1 -4  3  1 -2  8 -3 -2  0 -2 -2  0 -1 -1 -3  0 -3  1  2 -1 -9
	// I -1 -2 -2 -3 -3 -2 -2 -3 -3  5  3 -2  3  1 -2 -2  0 -6 -1  4 -2 -2 -1 -9
	// L -2 -3 -3 -5 -7 -2 -4 -5 -2  3  7 -3  5  2 -3 -3 -2 -2 -1  2 -4 -3 -1 -9
	// K -1  4  1  0 -6  1  0 -2  0 -2 -3  6  0 -6 -1  0  0 -4 -5 -3  1  1 -1 -9
	// M -1  0 -2 -3 -6 -1 -2 -3 -2  3  5  0  7  0 -2 -2 -1 -5 -3  2 -2 -2 -1 -9
	// F -4 -5 -4 -7 -5 -5 -6 -6 -2  1  2 -6  0 11 -5 -4 -4  1  9 -1 -5 -6 -3 -9
	// P  1  0  0 -1 -3  0  0  0  0 -2 -3 -1 -2 -5  7  1  1 -7 -6 -1 -1  0 -1 -9
	// S  1  0  1  0  0  0  0  1 -1 -2 -3  0 -2 -4  1  2  1 -3 -3 -1  1  0  0 -9
	// T  1 -1  1  0 -3 -1  0  0 -1  0 -2  0 -1 -4  1  1  3 -6 -3  0  0  0  0 -9
	// W -7  3 -5 -8 -9 -6 -8 -8 -3 -6 -2 -4 -5  1 -7 -3 -6 22  0 -7 -6 -7 -5 -9
	// Y -4 -5 -3 -5  1 -5 -5 -6  0 -1 -1 -5 -3  9 -6 -3 -3  0 13 -3 -4 -5 -3 -9
	// V  0 -3 -2 -2 -2 -2 -2 -1 -3  4  2 -3  2 -1 -1 -1  0 -7 -3  5 -2 -2 -1 -9
	// B  0 -1  2  4 -5  2  3  1  1 -2 -4  1 -2 -5 -1  1  0 -6 -4 -2  3  2 -1 -9
	// Z  0  0  1  3 -6  4  4  0  2 -2 -3  1 -2 -6  0  0  0 -7 -5 -2  2  4 -1 -9
	// X  0 -1  0 -1 -3 -1 -1 -1 -1 -1 -1 -1 -1 -3 -1  0  0 -5 -3 -1 -1 -1 -1 -9
	// * -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9  1
	//
	PAM280 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 2, 0, -2, 0, 0, -4, 2, -1, -1, 0, -1, -2, -1, 0, 1, 0, -2, 1, 1, 0, -7, 0, -4, 0, -9},
		/* B */ {0, 0, 3, -5, 4, 3, -5, 1, 1, -2, 0, 1, -4, -2, 2, -1, 2, -1, 1, 0, -2, -6, -1, -4, 2, -9},
		/* C */ {0, -2, -5, 15, -6, -6, -5, -4, -4, -3, 0, -6, -7, -6, -4, -3, -6, -4, 0, -3, -2, -9, -3, 1, -6, -9},
		/* D */ {0, 0, 4, -6, 4, 4, -7, 1, 1, -3, 0, 0, -5, -3, 2, -1, 2, -1, 0, 0, -2, -8, -1, -5, 3, -9},
		/* E */ {0, 0, 3, -6, 4, 4, -6, 0, 1, -2, 0, 0, -4, -2, 2, 0, 3, -1, 0, 0, -2, -8, -1, -5, 4, -9},
		/* F */ {0, -4, -5, -5, -7, -6, 11, -6, -2, 1, 0, -6, 2, 0, -4, -5, -5, -5, -4, -4, -1, 1, -3, 9, -6, -9},
		/* G */ {0, 2, 1, -4, 1, 0, -6, 6, -2, -3, 0, -2, -5, -3, 1, 0, -1, -3, 1, 0, -1, -8, -1, -6, 0, -9},
		/* H */ {0, -1, 1, -4, 1, 1, -2, -2, 8, -3, 0, 0, -2, -2, 2, 0, 3, 2, -1, -1, -3, -3, -1, 0, 2, -9},
		/* I */ {0, -1, -2, -3, -3, -2, 1, -3, -3, 5, 0, -2, 3, 3, -2, -2, -2, -2, -2, 0, 4, -6, -1, -1, -2, -9},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 1, -6, 0, 0, -6, -2, 0, -2, 0, 6, -3, 0, 1, -1, 1, 4, 0, 0, -3, -4, -1, -5, 1, -9},
		/* L */ {0, -2, -4, -7, -5, -4, 2, -5, -2, 3, 0, -3, 7, 5, -3, -3, -2, -3, -3, -2, 2, -2, -1, -1, -3, -9},
		/* M */ {0, -1, -2, -6, -3, -2, 0, -3, -2, 3, 0, 0, 5, 7, -2, -2, -1, 0, -2, -1, 2, -5, -1, -3, -2, -9},
		/* N */ {0, 0, 2, -4, 2, 2, -4, 1, 2, -2, 0, 1, -3, -2, 2, 0, 1, 0, 1, 1, -2, -5, 0, -3, 1, -9},
		/* P */ {0, 1, -1, -3, -1, 0, -5, 0, 0, -2, 0, -1, -3, -2, 0, 7, 0, 0, 1, 1, -1, -7, -1, -6, 0, -9},
		/* Q */ {0, 0, 2, -6, 2, 3, -5, -1, 3, -2, 0, 1, -2, -1, 1, 0, 4, 2, 0, -1, -2, -6, -1, -5, 4, -9},
		/* R */ {0, -2, -1, -4, -1, -1, -5, -3, 2, -2, 0, 4, -3, 0, 0, 0, 2, 7, 0, -1, -3, 3, -1, -5, 0, -9},
		/* S */ {0, 1, 1, 0, 0, 0, -4, 1, -1, -2, 0, 0, -3, -2, 1, 1, 0, 0, 2, 1, -1, -3, 0, -3, 0, -9},
		/* T */ {0, 1, 0, -3, 0, 0, -4, 0, -1, 0, 0, 0, -2, -1, 1, 1, -1, -1, 1, 3, 0, -6, 0, -3, 0, -9},
		/* V */ {0, 0, -2, -2, -2, -2, -1, -1, -3, 4, 0, -3, 2, 2, -2, -1, -2, -3, -1, 0, 5, -7, -1, -3, -2, -9},
		/* W */ {0, -7, -6, -9, -8, -8, 1, -8, -3, -6, 0, -4, -2, -5, -5, -7, -6, 3, -3, -6, -7, 22, -5, 0, -7, -9},
		/* X */ {0, 0, -1, -3, -1, -1, -3, -1, -1, -1, 0, -1, -1, -1, 0, -1, -1, -1, 0, 0, -1, -5, -1, -3, -1, -9},
		/* Y */ {0, -4, -4, 1, -5, -5, 9, -6, 0, -1, 0, -5, -1, -3, -3, -6, -5, -5, -3, -3, -3, 0, -3, 13, -5, -9},
		/* Z */ {0, 0, 2, -6, 3, 4, -6, 0, 2, -2, 0, 1, -3, -2, 1, 0, 4, 0, 0, 0, -2, -7, -1, -5, 4, -9},
		/* * */ {0, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 290 substitution matrix, scale = ln(2)/4 = 0.173287
	// #
	// # Expected score = -0.877, Entropy = 0.271 bits
	// #
	// # Lowest score = -9, Highest score = 22
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  2 -2  0  0 -2  0  0  2 -1 -1 -2 -1 -1 -4  1  1  1 -7 -4  0  0  0  0 -9
	// R -2  7  0 -1 -4  2 -1 -3  2 -2 -3  4  0 -5  0  0 -1  3 -5 -3  0  0 -1 -9
	// N  0  0  2  2 -4  1  2  1  2 -2 -3  1 -2 -4  0  1  1 -5 -3 -2  2  1  0 -9
	// D  0 -1  2  4 -6  2  4  1  1 -3 -4  0 -3 -6 -1  0  0 -8 -5 -2  3  3 -1 -9
	// C -2 -4 -4 -6 15 -6 -6 -4 -4 -3 -7 -6 -6 -5 -3  0 -2 -9  1 -2 -5 -6 -3 -9
	// Q  0  2  1  2 -6  4  3 -1  3 -2 -2  1 -1 -5  0  0 -1 -5 -5 -2  2  3  0 -9
	// E  0 -1  2  4 -6  3  4  0  1 -2 -4  0 -2 -6  0  0  0 -8 -5 -2  3  4 -1 -9
	// G  2 -3  1  1 -4 -1  0  5 -2 -3 -4 -2 -3 -6  0  1  0 -8 -6 -1  1  0 -1 -9
	// H -1  2  2  1 -4  3  1 -2  7 -3 -2  0 -2 -2  0 -1 -1 -3  0 -2  1  2 -1 -9
	// I -1 -2 -2 -3 -3 -2 -2 -3 -3  5  3 -2  3  1 -2 -1  0 -6 -1  4 -2 -2 -1 -9
	// L -2 -3 -3 -4 -7 -2 -4 -4 -2  3  7 -3  5  3 -3 -3 -2 -2 -1  2 -4 -3 -1 -9
	// K -1  4  1  0 -6  1  0 -2  0 -2 -3  5  0 -6 -1  0  0 -4 -5 -3  1  1 -1 -9
	// M -1  0 -2 -3 -6 -1 -2 -3 -2  3  5  0  7  0 -2 -2 -1 -5 -2  2 -2 -2 -1 -9
	// F -4 -5 -4 -6 -5 -5 -6 -6 -2  1  3 -6  0 11 -5 -4 -3  1  9 -1 -5 -6 -3 -9
	// P  1  0  0 -1 -3  0  0  0  0 -2 -3 -1 -2 -5  7  1  1 -6 -6 -1 -1  0 -1 -9
	// S  1  0  1  0  0  0  0  1 -1 -1 -3  0 -2 -4  1  2  1 -3 -3 -1  1  0  0 -9
	// T  1 -1  1  0 -2 -1  0  0 -1  0 -2  0 -1 -3  1  1  3 -6 -3  0  0  0  0 -9
	// W -7  3 -5 -8 -9 -5 -8 -8 -3 -6 -2 -4 -5  1 -6 -3 -6 22  0 -7 -6 -7 -5 -9
	// Y -4 -5 -3 -5  1 -5 -5 -6  0 -1 -1 -5 -2  9 -6 -3 -3  0 13 -3 -4 -5 -2 -9
	// V  0 -3 -2 -2 -2 -2 -2 -1 -2  4  2 -3  2 -1 -1 -1  0 -7 -3  5 -2 -2 -1 -9
	// B  0  0  2  3 -5  2  3  1  1 -2 -4  1 -2 -5 -1  1  0 -6 -4 -2  3  2  0 -9
	// Z  0  0  1  3 -6  3  4  0  2 -2 -3  1 -2 -6  0  0  0 -7 -5 -2  2  4 -1 -9
	// X  0 -1  0 -1 -3  0 -1 -1 -1 -1 -1 -1 -1 -3 -1  0  0 -5 -2 -1  0 -1 -1 -9
	// * -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9  1
	//
	PAM290 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 2, 0, -2, 0, 0, -4, 2, -1, -1, 0, -1, -2, -1, 0, 1, 0, -2, 1, 1, 0, -7, 0, -4, 0, -9},
		/* B */ {0, 0, 3, -5, 3, 3, -5, 1, 1, -2, 0, 1, -4, -2, 2, -1, 2, 0, 1, 0, -2, -6, 0, -4, 2, -9},
		/* C */ {0, -2, -5, 15, -6, -6, -5, -4, -4, -3, 0, -6, -7, -6, -4, -3, -6, -4, 0, -2, -2, -9, -3, 1, -6, -9},
		/* D */ {0, 0, 3, -6, 4, 4, -6, 1, 1, -3, 0, 0, -4, -3, 2, -1, 2, -1, 0, 0, -2, -8, -1, -5, 3, -9},
		/* E */ {0, 0, 3, -6, 4, 4, -6, 0, 1, -2, 0, 0, -4, -2, 2, 0, 3, -1, 0, 0, -2, -8, -1, -5, 4, -9},
		/* F */ {0, -4, -5, -5, -6, -6, 11, -6, -2, 1, 0, -6, 3, 0, -4, -5, -5, -5, -4, -3, -1, 1, -3, 9, -6, -9},
		/* G */ {0, 2, 1, -4, 1, 0, -6, 5, -2, -3, 0, -2, -4, -3, 1, 0, -1, -3, 1, 0, -1, -8, -1, -6, 0, -9},
		/* H */ {0, -1, 1, -4, 1, 1, -2, -2, 7, -3, 0, 0, -2, -2, 2, 0, 3, 2, -1, -1, -2, -3, -1, 0, 2, -9},
		/* I */ {0, -1, -2, -3, -3, -2, 1, -3, -3, 5, 0, -2, 3, 3, -2, -2, -2, -2, -1, 0, 4, -6, -1, -1, -2, -9},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 1, -6, 0, 0, -6, -2, 0, -2, 0, 5, -3, 0, 1, -1, 1, 4, 0, 0, -3, -4, -1, -5, 1, -9},
		/* L */ {0, -2, -4, -7, -4, -4, 3, -4, -2, 3, 0, -3, 7, 5, -3, -3, -2, -3, -3, -2, 2, -2, -1, -1, -3, -9},
		/* M */ {0, -1, -2, -6, -3, -2, 0, -3, -2, 3, 0, 0, 5, 7, -2, -2, -1, 0, -2, -1, 2, -5, -1, -2, -2, -9},
		/* N */ {0, 0, 2, -4, 2, 2, -4, 1, 2, -2, 0, 1, -3, -2, 2, 0, 1, 0, 1, 1, -2, -5, 0, -3, 1, -9},
		/* P */ {0, 1, -1, -3, -1, 0, -5, 0, 0, -2, 0, -1, -3, -2, 0, 7, 0, 0, 1, 1, -1, -6, -1, -6, 0, -9},
		/* Q */ {0, 0, 2, -6, 2, 3, -5, -1, 3, -2, 0, 1, -2, -1, 1, 0, 4, 2, 0, -1, -2, -5, 0, -5, 3, -9},
		/* R */ {0, -2, 0, -4, -1, -1, -5, -3, 2, -2, 0, 4, -3, 0, 0, 0, 2, 7, 0, -1, -3, 3, -1, -5, 0, -9},
		/* S */ {0, 1, 1, 0, 0, 0, -4, 1, -1, -1, 0, 0, -3, -2, 1, 1, 0, 0, 2, 1, -1, -3, 0, -3, 0, -9},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 0, -1, 0, 0, 0, -2, -1, 1, 1, -1, -1, 1, 3, 0, -6, 0, -3, 0, -9},
		/* V */ {0, 0, -2, -2, -2, -2, -1, -1, -2, 4, 0, -3, 2, 2, -2, -1, -2, -3, -1, 0, 5, -7, -1, -3, -2, -9},
		/* W */ {0, -7, -6, -9, -8, -8, 1, -8, -3, -6, 0, -4, -2, -5, -5, -6, -5, 3, -3, -6, -7, 22, -5, 0, -7, -9},
		/* X */ {0, 0, 0, -3, -1, -1, -3, -1, -1, -1, 0, -1, -1, -1, 0, -1, 0, -1, 0, 0, -1, -5, -1, -2, -1, -9},
		/* Y */ {0, -4, -4, 1, -5, -5, 9, -6, 0, -1, 0, -5, -1, -2, -3, -6, -5, -5, -3, -3, -3, 0, -2, 13, -5, -9},
		/* Z */ {0, 0, 2, -6, 3, 4, -6, 0, 2, -2, 0, 1, -3, -2, 1, 0, 3, 0, 0, 0, -2, -7, -1, -5, 4, -9},
		/* * */ {0, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 30 substitution matrix, scale = ln(2)/2 = 0.346574
	// #
	// # Expected score = -5.06, Entropy = 2.57 bits
	// #
	// # Lowest score = -17, Highest score = 13
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A   6  -7  -4  -3  -6  -4  -2  -2  -7  -5  -6  -7  -5  -8  -2   0  -1 -13  -8  -2  -3  -3  -3 -17
	// R  -7   8  -6 -10  -8  -2  -9  -9  -2  -5  -8   0  -4  -9  -4  -3  -6  -2 -10  -8  -7  -4  -6 -17
	// N  -4  -6   8   2 -11  -3  -2  -3   0  -5  -7  -1  -9  -9  -6   0  -2  -8  -4  -8   6  -3  -3 -17
	// D  -3 -10   2   8 -14  -2   2  -3  -4  -7 -12  -4 -11 -15  -8  -4  -5 -15 -11  -8   6   1  -5 -17
	// C  -6  -8 -11 -14  10 -14 -14  -9  -7  -6 -15 -14 -13 -13  -8  -3  -8 -15  -4  -6 -12 -14  -9 -17
	// Q  -4  -2  -3  -2 -14   8   1  -7   1  -8  -5  -3  -4 -13  -3  -5  -5 -13 -12  -7  -3   6  -5 -17
	// E  -2  -9  -2   2 -14   1   8  -4  -5  -5  -9  -4  -7 -14  -5  -4  -6 -17  -8  -6   1   6  -5 -17
	// G  -2  -9  -3  -3  -9  -7  -4   6  -9 -11 -10  -7  -8  -9  -6  -2  -6 -15 -14  -5  -3  -5  -5 -17
	// H  -7  -2   0  -4  -7   1  -5  -9   9  -9  -6  -6 -10  -6  -4  -6  -7  -7  -3  -6  -1  -1  -5 -17
	// I  -5  -5  -5  -7  -6  -8  -5 -11  -9   8  -1  -6  -1  -2  -8  -7  -2 -14  -6   2  -6  -6  -5 -17
	// L  -6  -8  -7 -12 -15  -5  -9 -10  -6  -1   7  -8   1  -3  -7  -8  -7  -6  -7  -2  -9  -7  -6 -17
	// K  -7   0  -1  -4 -14  -3  -4  -7  -6  -6  -8   7  -2 -14  -6  -4  -3 -12  -9  -9  -2  -4  -5 -17
	// M  -5  -4  -9 -11 -13  -4  -7  -8 -10  -1   1  -2  11  -4  -8  -5  -4 -13 -11  -1 -10  -5  -5 -17
	// F  -8  -9  -9 -15 -13 -13 -14  -9  -6  -2  -3 -14  -4   9 -10  -6  -9  -4   2  -8 -10 -13  -8 -17
	// P  -2  -4  -6  -8  -8  -3  -5  -6  -4  -8  -7  -6  -8 -10   8  -2  -4 -14 -13  -6  -7  -4  -5 -17
	// S   0  -3   0  -4  -3  -5  -4  -2  -6  -7  -8  -4  -5  -6  -2   6   0  -5  -7  -6  -1  -5  -3 -17
	// T  -1  -6  -2  -5  -8  -5  -6  -6  -7  -2  -7  -3  -4  -9  -4   0   7 -13  -6  -3  -3  -6  -4 -17
	// W -13  -2  -8 -15 -15 -13 -17 -15  -7 -14  -6 -12 -13  -4 -14  -5 -13  13  -5 -15 -10 -14 -11 -17
	// Y  -8 -10  -4 -11  -4 -12  -8 -14  -3  -6  -7  -9 -11   2 -13  -7  -6  -5  10  -7  -6  -9  -7 -17
	// V  -2  -8  -8  -8  -6  -7  -6  -5  -6   2  -2  -9  -1  -8  -6  -6  -3 -15  -7   7  -8  -6  -5 -17
	// B  -3  -7   6   6 -12  -3   1  -3  -1  -6  -9  -2 -10 -10  -7  -1  -3 -10  -6  -8   6   0  -5 -17
	// Z  -3  -4  -3   1 -14   6   6  -5  -1  -6  -7  -4  -5 -13  -4  -5  -6 -14  -9  -6   0   6  -5 -17
	// X  -3  -6  -3  -5  -9  -5  -5  -5  -5  -5  -6  -5  -5  -8  -5  -3  -4 -11  -7  -5  -5  -5  -5 -17
	// * -17 -17 -17 -17 -17 -17 -17 -17 -17 -17 -17 -17 -17 -17 -17 -17 -17 -17 -17 -17 -17 -17 -17   1
	//
	PAM30 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 6, -3, -6, -3, -2, -8, -2, -7, -5, 0, -7, -6, -5, -4, -2, -4, -7, 0, -1, -2, -13, -3, -8, -3, -17},
		/* B */ {0, -3, 6, -12, 6, 1, -10, -3, -1, -6, 0, -2, -9, -10, 6, -7, -3, -7, -1, -3, -8, -10, -5, -6, 0, -17},
		/* C */ {0, -6, -12, 10, -14, -14, -13, -9, -7, -6, 0, -14, -15, -13, -11, -8, -14, -8, -3, -8, -6, -15, -9, -4, -14, -17},
		/* D */ {0, -3, 6, -14, 8, 2, -15, -3, -4, -7, 0, -4, -12, -11, 2, -8, -2, -10, -4, -5, -8, -15, -5, -11, 1, -17},
		/* E */ {0, -2, 1, -14, 2, 8, -14, -4, -5, -5, 0, -4, -9, -7, -2, -5, 1, -9, -4, -6, -6, -17, -5, -8, 6, -17},
		/* F */ {0, -8, -10, -13, -15, -14, 9, -9, -6, -2, 0, -14, -3, -4, -9, -10, -13, -9, -6, -9, -8, -4, -8, 2, -13, -17},
		/* G */ {0, -2, -3, -9, -3, -4, -9, 6, -9, -11, 0, -7, -10, -8, -3, -6, -7, -9, -2, -6, -5, -15, -5, -14, -5, -17},
		/* H */ {0, -7, -1, -7, -4, -5, -6, -9, 9, -9, 0, -6, -6, -10, 0, -4, 1, -2, -6, -7, -6, -7, -5, -3, -1, -17},
		/* I */ {0, -5, -6, -6, -7, -5, -2, -11, -9, 8, 0, -6, -1, -1, -5, -8, -8, -5, -7, -2, 2, -14, -5, -6, -6, -17},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -7, -2, -14, -4, -4, -14, -7, -6, -6, 0, 7, -8, -2, -1, -6, -3, 0, -4, -3, -9, -12, -5, -9, -4, -17},
		/* L */ {0, -6, -9, -15, -12, -9, -3, -10, -6, -1, 0, -8, 7, 1, -7, -7, -5, -8, -8, -7, -2, -6, -6, -7, -7, -17},
		/* M */ {0, -5, -10, -13, -11, -7, -4, -8, -10, -1, 0, -2, 1, 11, -9, -8, -4, -4, -5, -4, -1, -13, -5, -11, -5, -17},
		/* N */ {0, -4, 6, -11, 2, -2, -9, -3, 0, -5, 0, -1, -7, -9, 8, -6, -3, -6, 0, -2, -8, -8, -3, -4, -3, -17},
		/* P */ {0, -2, -7, -8, -8, -5, -10, -6, -4, -8, 0, -6, -7, -8, -6, 8, -3, -4, -2, -4, -6, -14, -5, -13, -4, -17},
		/* Q */ {0, -4, -3, -14, -2, 1, -13, -7, 1, -8, 0, -3, -5, -4, -3, -3, 8, -2, -5, -5, -7, -13, -5, -12, 6, -17},
		/* R */ {0, -7, -7, -8, -10, -9, -9, -9, -2, -5, 0, 0, -8, -4, -6, -4, -2, 8, -3, -6, -8, -2, -6, -10, -4, -17},
		/* S */ {0, 0, -1, -3, -4, -4, -6, -2, -6, -7, 0, -4, -8, -5, 0, -2, -5, -3, 6, 0, -6, -5, -3, -7, -5, -17},
		/* T */ {0, -1, -3, -8, -5, -6, -9, -6, -7, -2, 0, -3, -7, -4, -2, -4, -5, -6, 0, 7, -3, -13, -4, -6, -6, -17},
		/* V */ {0, -2, -8, -6, -8, -6, -8, -5, -6, 2, 0, -9, -2, -1, -8, -6, -7, -8, -6, -3, 7, -15, -5, -7, -6, -17},
		/* W */ {0, -13, -10, -15, -15, -17, -4, -15, -7, -14, 0, -12, -6, -13, -8, -14, -13, -2, -5, -13, -15, 13, -11, -5, -14, -17},
		/* X */ {0, -3, -5, -9, -5, -5, -8, -5, -5, -5, 0, -5, -6, -5, -3, -5, -5, -6, -3, -4, -5, -11, -5, -7, -5, -17},
		/* Y */ {0, -8, -6, -4, -11, -8, 2, -14, -3, -6, 0, -9, -7, -11, -4, -13, -12, -10, -7, -6, -7, -5, -7, 10, -9, -17},
		/* Z */ {0, -3, 0, -14, 1, 6, -13, -5, -1, -6, 0, -4, -7, -5, -3, -4, 6, -4, -5, -6, -6, -14, -5, -9, 6, -17},
		/* * */ {0, -17, -17, -17, -17, -17, -17, -17, -17, -17, 0, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 300 substitution matrix, scale = ln(2)/4 = 0.173287
	// #
	// # Expected score = -0.835, Entropy = 0.254 bits
	// #
	// # Lowest score = -9, Highest score = 22
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  2 -1  0  0 -2  0  0  2 -1  0 -2 -1 -1 -4  1  1  1 -6 -4  0  0  0  0 -9
	// R -1  7  0 -1 -4  2 -1 -2  2 -2 -3  4  0 -5  0  0 -1  3 -5 -3  0  0 -1 -9
	// N  0  0  2  2 -4  1  2  1  2 -2 -3  1 -2 -4  0  1  0 -5 -2 -2  2  1  0 -9
	// D  0 -1  2  4 -6  2  4  1  1 -2 -4  0 -3 -6 -1  0  0 -7 -5 -2  3  3 -1 -9
	// C -2 -4 -4 -6 15 -6 -6 -4 -4 -3 -7 -6 -6 -5 -3  0 -2 -9  1 -2 -5 -6 -3 -9
	// Q  0  2  1  2 -6  4  3 -1  3 -2 -2  1 -1 -5  0  0 -1 -5 -4 -2  2  3  0 -9
	// E  0 -1  2  4 -6  3  4  0  1 -2 -4  0 -2 -6  0  0  0 -8 -5 -2  3  3 -1 -9
	// G  2 -2  1  1 -4 -1  0  5 -2 -3 -4 -2 -3 -5  0  1  0 -8 -6 -1  1  0 -1 -9
	// H -1  2  2  1 -4  3  1 -2  7 -2 -2  0 -2 -2  0 -1 -1 -3  0 -2  1  2  0 -9
	// I  0 -2 -2 -2 -3 -2 -2 -3 -2  5  3 -2  3  1 -2 -1  0 -6 -1  4 -2 -2 -1 -9
	// L -2 -3 -3 -4 -7 -2 -4 -4 -2  3  7 -3  4  3 -3 -3 -2 -2  0  2 -4 -3 -1 -9
	// K -1  4  1  0 -6  1  0 -2  0 -2 -3  5  0 -6 -1  0  0 -4 -5 -2  1  1 -1 -9
	// M -1  0 -2 -3 -6 -1 -2 -3 -2  3  4  0  6  1 -2 -2 -1 -5 -2  2 -2 -2 -1 -9
	// F -4 -5 -4 -6 -5 -5 -6 -5 -2  1  3 -6  1 11 -5 -4 -3  1  9 -1 -5 -5 -2 -9
	// P  1  0  0 -1 -3  0  0  0  0 -2 -3 -1 -2 -5  6  1  1 -6 -5 -1  0  0 -1 -9
	// S  1  0  1  0  0  0  0  1 -1 -1 -3  0 -2 -4  1  1  1 -3 -3 -1  1  0  0 -9
	// T  1 -1  0  0 -2 -1  0  0 -1  0 -2  0 -1 -3  1  1  2 -6 -3  0  0  0  0 -9
	// W -6  3 -5 -7 -9 -5 -8 -8 -3 -6 -2 -4 -5  1 -6 -3 -6 22  0 -7 -6 -6 -4 -9
	// Y -4 -5 -2 -5  1 -4 -5 -6  0 -1  0 -5 -2  9 -5 -3 -3  0 12 -3 -4 -5 -2 -9
	// V  0 -3 -2 -2 -2 -2 -2 -1 -2  4  2 -2  2 -1 -1 -1  0 -7 -3  5 -2 -2  0 -9
	// B  0  0  2  3 -5  2  3  1  1 -2 -4  1 -2 -5  0  1  0 -6 -4 -2  3  2  0 -9
	// Z  0  0  1  3 -6  3  3  0  2 -2 -3  1 -2 -5  0  0  0 -6 -5 -2  2  3 -1 -9
	// X  0 -1  0 -1 -3  0 -1 -1  0 -1 -1 -1 -1 -2 -1  0  0 -4 -2  0  0 -1 -1 -9
	// * -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9  1
	//
	PAM300 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 2, 0, -2, 0, 0, -4, 2, -1, 0, 0, -1, -2, -1, 0, 1, 0, -1, 1, 1, 0, -6, 0, -4, 0, -9},
		/* B */ {0, 0, 3, -5, 3, 3, -5, 1, 1, -2, 0, 1, -4, -2, 2, 0, 2, 0, 1, 0, -2, -6, 0, -4, 2, -9},
		/* C */ {0, -2, -5, 15, -6, -6, -5, -4, -4, -3, 0, -6, -7, -6, -4, -3, -6, -4, 0, -2, -2, -9, -3, 1, -6, -9},
		/* D */ {0, 0, 3, -6, 4, 4, -6, 1, 1, -2, 0, 0, -4, -3, 2, -1, 2, -1, 0, 0, -2, -7, -1, -5, 3, -9},
		/* E */ {0, 0, 3, -6, 4, 4, -6, 0, 1, -2, 0, 0, -4, -2, 2, 0, 3, -1, 0, 0, -2, -8, -1, -5, 3, -9},
		/* F */ {0, -4, -5, -5, -6, -6, 11, -5, -2, 1, 0, -6, 3, 1, -4, -5, -5, -5, -4, -3, -1, 1, -2, 9, -5, -9},
		/* G */ {0, 2, 1, -4, 1, 0, -5, 5, -2, -3, 0, -2, -4, -3, 1, 0, -1, -2, 1, 0, -1, -8, -1, -6, 0, -9},
		/* H */ {0, -1, 1, -4, 1, 1, -2, -2, 7, -2, 0, 0, -2, -2, 2, 0, 3, 2, -1, -1, -2, -3, 0, 0, 2, -9},
		/* I */ {0, 0, -2, -3, -2, -2, 1, -3, -2, 5, 0, -2, 3, 3, -2, -2, -2, -2, -1, 0, 4, -6, -1, -1, -2, -9},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 1, -6, 0, 0, -6, -2, 0, -2, 0, 5, -3, 0, 1, -1, 1, 4, 0, 0, -2, -4, -1, -5, 1, -9},
		/* L */ {0, -2, -4, -7, -4, -4, 3, -4, -2, 3, 0, -3, 7, 4, -3, -3, -2, -3, -3, -2, 2, -2, -1, 0, -3, -9},
		/* M */ {0, -1, -2, -6, -3, -2, 1, -3, -2, 3, 0, 0, 4, 6, -2, -2, -1, 0, -2, -1, 2, -5, -1, -2, -2, -9},
		/* N */ {0, 0, 2, -4, 2, 2, -4, 1, 2, -2, 0, 1, -3, -2, 2, 0, 1, 0, 1, 0, -2, -5, 0, -2, 1, -9},
		/* P */ {0, 1, 0, -3, -1, 0, -5, 0, 0, -2, 0, -1, -3, -2, 0, 6, 0, 0, 1, 1, -1, -6, -1, -5, 0, -9},
		/* Q */ {0, 0, 2, -6, 2, 3, -5, -1, 3, -2, 0, 1, -2, -1, 1, 0, 4, 2, 0, -1, -2, -5, 0, -4, 3, -9},
		/* R */ {0, -1, 0, -4, -1, -1, -5, -2, 2, -2, 0, 4, -3, 0, 0, 0, 2, 7, 0, -1, -3, 3, -1, -5, 0, -9},
		/* S */ {0, 1, 1, 0, 0, 0, -4, 1, -1, -1, 0, 0, -3, -2, 1, 1, 0, 0, 1, 1, -1, -3, 0, -3, 0, -9},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 0, -1, 0, 0, 0, -2, -1, 0, 1, -1, -1, 1, 2, 0, -6, 0, -3, 0, -9},
		/* V */ {0, 0, -2, -2, -2, -2, -1, -1, -2, 4, 0, -2, 2, 2, -2, -1, -2, -3, -1, 0, 5, -7, 0, -3, -2, -9},
		/* W */ {0, -6, -6, -9, -7, -8, 1, -8, -3, -6, 0, -4, -2, -5, -5, -6, -5, 3, -3, -6, -7, 22, -4, 0, -6, -9},
		/* X */ {0, 0, 0, -3, -1, -1, -2, -1, 0, -1, 0, -1, -1, -1, 0, -1, 0, -1, 0, 0, 0, -4, -1, -2, -1, -9},
		/* Y */ {0, -4, -4, 1, -5, -5, 9, -6, 0, -1, 0, -5, 0, -2, -2, -5, -4, -5, -3, -3, -3, 0, -2, 12, -5, -9},
		/* Z */ {0, 0, 2, -6, 3, 3, -5, 0, 2, -2, 0, 1, -3, -2, 1, 0, 3, 0, 0, 0, -2, -6, -1, -5, 3, -9},
		/* * */ {0, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 310 substitution matrix, scale = ln(2)/4 = 0.173287
	// #
	// # Expected score = -0.779, Entropy = 0.238 bits
	// #
	// # Lowest score = -9, Highest score = 22
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  2 -1  0  0 -2  0  0  1 -1  0 -2 -1 -1 -4  1  1  1 -6 -4  0  0  0  0 -9
	// R -1  6  0 -1 -4  1 -1 -2  2 -2 -3  4  0 -5  0  0 -1  3 -4 -2  0  0 -1 -9
	// N  0  0  2  2 -4  1  2  1  2 -2 -3  1 -2 -4  0  1  0 -4 -2 -2  2  1  0 -9
	// D  0 -1  2  4 -5  2  4  1  1 -2 -4  0 -2 -6 -1  0  0 -7 -5 -2  3  3 -1 -9
	// C -2 -4 -4 -5 15 -6 -6 -3 -4 -2 -6 -6 -6 -4 -3  0 -2 -9  1 -2 -5 -6 -3 -9
	// Q  0  1  1  2 -6  4  3 -1  3 -2 -2  1 -1 -5  0  0 -1 -5 -4 -2  2  3  0 -9
	// E  0 -1  2  4 -6  3  4  1  1 -2 -3  0 -2 -6  0  0  0 -7 -5 -2  3  3 -1 -9
	// G  1 -2  1  1 -3 -1  1  5 -2 -2 -4 -1 -3 -5  0  1  0 -8 -6 -1  1  0 -1 -9
	// H -1  2  2  1 -4  3  1 -2  7 -2 -2  0 -2 -2  0 -1 -1 -3  0 -2  1  2  0 -9
	// I  0 -2 -2 -2 -2 -2 -2 -2 -2  4  3 -2  3  1 -2 -1  0 -5 -1  4 -2 -2 -1 -9
	// L -2 -3 -3 -4 -6 -2 -3 -4 -2  3  7 -3  4  3 -3 -3 -2 -2  0  2 -3 -3 -1 -9
	// K -1  4  1  0 -6  1  0 -1  0 -2 -3  5  0 -5 -1  0  0 -3 -5 -2  1  1 -1 -9
	// M -1  0 -2 -2 -6 -1 -2 -3 -2  3  4  0  6  1 -2 -2 -1 -4 -2  2 -2 -2 -1 -9
	// F -4 -5 -4 -6 -4 -5 -6 -5 -2  1  3 -5  1 11 -5 -4 -3  1  9 -1 -5 -5 -2 -9
	// P  1  0  0 -1 -3  0  0  0  0 -2 -3 -1 -2 -5  6  1  1 -6 -5 -1  0  0  0 -9
	// S  1  0  1  0  0  0  0  1 -1 -1 -3  0 -2 -4  1  1  1 -3 -3 -1  1  0  0 -9
	// T  1 -1  0  0 -2 -1  0  0 -1  0 -2  0 -1 -3  1  1  2 -6 -3  0  0  0  0 -9
	// W -6  3 -4 -7 -9 -5 -7 -8 -3 -5 -2 -3 -4  1 -6 -3 -6 22  0 -7 -6 -6 -4 -9
	// Y -4 -4 -2 -5  1 -4 -5 -6  0 -1  0 -5 -2  9 -5 -3 -3  0 12 -2 -4 -4 -2 -9
	// V  0 -2 -2 -2 -2 -2 -2 -1 -2  4  2 -2  2 -1 -1 -1  0 -7 -2  4 -2 -2  0 -9
	// B  0  0  2  3 -5  2  3  1  1 -2 -3  1 -2 -5  0  1  0 -6 -4 -2  3  2  0 -9
	// Z  0  0  1  3 -6  3  3  0  2 -2 -3  1 -2 -5  0  0  0 -6 -4 -2  2  3  0 -9
	// X  0 -1  0 -1 -3  0 -1 -1  0 -1 -1 -1 -1 -2  0  0  0 -4 -2  0  0  0 -1 -9
	// * -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9  1
	//
	PAM310 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 2, 0, -2, 0, 0, -4, 1, -1, 0, 0, -1, -2, -1, 0, 1, 0, -1, 1, 1, 0, -6, 0, -4, 0, -9},
		/* B */ {0, 0, 3, -5, 3, 3, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -2, -6, 0, -4, 2, -9},
		/* C */ {0, -2, -5, 15, -5, -6, -4, -3, -4, -2, 0, -6, -6, -6, -4, -3, -6, -4, 0, -2, -2, -9, -3, 1, -6, -9},
		/* D */ {0, 0, 3, -5, 4, 4, -6, 1, 1, -2, 0, 0, -4, -2, 2, -1, 2, -1, 0, 0, -2, -7, -1, -5, 3, -9},
		/* E */ {0, 0, 3, -6, 4, 4, -6, 1, 1, -2, 0, 0, -3, -2, 2, 0, 3, -1, 0, 0, -2, -7, -1, -5, 3, -9},
		/* F */ {0, -4, -5, -4, -6, -6, 11, -5, -2, 1, 0, -5, 3, 1, -4, -5, -5, -5, -4, -3, -1, 1, -2, 9, -5, -9},
		/* G */ {0, 1, 1, -3, 1, 1, -5, 5, -2, -2, 0, -1, -4, -3, 1, 0, -1, -2, 1, 0, -1, -8, -1, -6, 0, -9},
		/* H */ {0, -1, 1, -4, 1, 1, -2, -2, 7, -2, 0, 0, -2, -2, 2, 0, 3, 2, -1, -1, -2, -3, 0, 0, 2, -9},
		/* I */ {0, 0, -2, -2, -2, -2, 1, -2, -2, 4, 0, -2, 3, 3, -2, -2, -2, -2, -1, 0, 4, -5, -1, -1, -2, -9},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 1, -6, 0, 0, -5, -1, 0, -2, 0, 5, -3, 0, 1, -1, 1, 4, 0, 0, -2, -3, -1, -5, 1, -9},
		/* L */ {0, -2, -3, -6, -4, -3, 3, -4, -2, 3, 0, -3, 7, 4, -3, -3, -2, -3, -3, -2, 2, -2, -1, 0, -3, -9},
		/* M */ {0, -1, -2, -6, -2, -2, 1, -3, -2, 3, 0, 0, 4, 6, -2, -2, -1, 0, -2, -1, 2, -4, -1, -2, -2, -9},
		/* N */ {0, 0, 2, -4, 2, 2, -4, 1, 2, -2, 0, 1, -3, -2, 2, 0, 1, 0, 1, 0, -2, -4, 0, -2, 1, -9},
		/* P */ {0, 1, 0, -3, -1, 0, -5, 0, 0, -2, 0, -1, -3, -2, 0, 6, 0, 0, 1, 1, -1, -6, 0, -5, 0, -9},
		/* Q */ {0, 0, 2, -6, 2, 3, -5, -1, 3, -2, 0, 1, -2, -1, 1, 0, 4, 1, 0, -1, -2, -5, 0, -4, 3, -9},
		/* R */ {0, -1, 0, -4, -1, -1, -5, -2, 2, -2, 0, 4, -3, 0, 0, 0, 1, 6, 0, -1, -2, 3, -1, -4, 0, -9},
		/* S */ {0, 1, 1, 0, 0, 0, -4, 1, -1, -1, 0, 0, -3, -2, 1, 1, 0, 0, 1, 1, -1, -3, 0, -3, 0, -9},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 0, -1, 0, 0, 0, -2, -1, 0, 1, -1, -1, 1, 2, 0, -6, 0, -3, 0, -9},
		/* V */ {0, 0, -2, -2, -2, -2, -1, -1, -2, 4, 0, -2, 2, 2, -2, -1, -2, -2, -1, 0, 4, -7, 0, -2, -2, -9},
		/* W */ {0, -6, -6, -9, -7, -7, 1, -8, -3, -5, 0, -3, -2, -4, -4, -6, -5, 3, -3, -6, -7, 22, -4, 0, -6, -9},
		/* X */ {0, 0, 0, -3, -1, -1, -2, -1, 0, -1, 0, -1, -1, -1, 0, 0, 0, -1, 0, 0, 0, -4, -1, -2, 0, -9},
		/* Y */ {0, -4, -4, 1, -5, -5, 9, -6, 0, -1, 0, -5, 0, -2, -2, -5, -4, -4, -3, -3, -2, 0, -2, 12, -4, -9},
		/* Z */ {0, 0, 2, -6, 3, 3, -5, 0, 2, -2, 0, 1, -3, -2, 1, 0, 3, 0, 0, 0, -2, -6, 0, -4, 3, -9},
		/* * */ {0, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 320 substitution matrix, scale = ln(2)/4 = 0.173287
	// #
	// # Expected score = -0.741, Entropy = 0.224 bits
	// #
	// # Lowest score = -8, Highest score = 22
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  1 -1  0  1 -2  0  0  1 -1  0 -2 -1 -1 -4  1  1  1 -6 -4  0  0  0  0 -8
	// R -1  6  0 -1 -4  1 -1 -2  2 -2 -3  4  0 -5  0  0 -1  3 -4 -2  0  0 -1 -8
	// N  0  0  2  2 -4  1  2  1  2 -2 -3  1 -2 -4  0  1  0 -4 -2 -2  2  1  0 -8
	// D  1 -1  2  4 -5  2  3  1  1 -2 -4  0 -2 -6  0  0  0 -7 -5 -2  3  3 -1 -8
	// C -2 -4 -4 -5 15 -5 -5 -3 -4 -2 -6 -6 -5 -4 -3  0 -2 -8  1 -2 -4 -5 -3 -8
	// Q  0  1  1  2 -5  4  2 -1  3 -2 -2  1 -1 -5  0  0  0 -5 -4 -2  2  3  0 -8
	// E  0 -1  2  3 -5  2  4  1  1 -2 -3  0 -2 -5  0  0  0 -7 -5 -2  3  3  0 -8
	// G  1 -2  1  1 -3 -1  1  5 -2 -2 -4 -1 -3 -5  0  1  0 -7 -5 -1  1  0 -1 -8
	// H -1  2  2  1 -4  3  1 -2  6 -2 -2  0 -2 -2  0 -1 -1 -3  0 -2  1  2  0 -8
	// I  0 -2 -2 -2 -2 -2 -2 -2 -2  4  3 -2  2  1 -2 -1  0 -5 -1  4 -2 -2  0 -8
	// L -2 -3 -3 -4 -6 -2 -3 -4 -2  3  7 -3  4  3 -2 -3 -2 -2  0  2 -3 -3 -1 -8
	// K -1  4  1  0 -6  1  0 -1  0 -2 -3  5  0 -5 -1  0  0 -3 -5 -2  1  1 -1 -8
	// M -1  0 -2 -2 -5 -1 -2 -3 -2  2  4  0  6  1 -2 -1 -1 -4 -2  2 -2 -2  0 -8
	// F -4 -5 -4 -6 -4 -5 -5 -5 -2  1  3 -5  1 11 -5 -3 -3  1  9 -1 -5 -5 -2 -8
	// P  1  0  0  0 -3  0  0  0  0 -2 -2 -1 -2 -5  6  1  1 -6 -5 -1  0  0  0 -8
	// S  1  0  1  0  0  0  0  1 -1 -1 -3  0 -1 -3  1  1  1 -3 -3 -1  1  0  0 -8
	// T  1 -1  0  0 -2  0  0  0 -1  0 -2  0 -1 -3  1  1  2 -5 -3  0  0  0  0 -8
	// W -6  3 -4 -7 -8 -5 -7 -7 -3 -5 -2 -3 -4  1 -6 -3 -5 22  1 -6 -6 -6 -4 -8
	// Y -4 -4 -2 -5  1 -4 -5 -5  0 -1  0 -5 -2  9 -5 -3 -3  1 12 -2 -3 -4 -2 -8
	// V  0 -2 -2 -2 -2 -2 -2 -1 -2  4  2 -2  2 -1 -1 -1  0 -6 -2  4 -2 -2  0 -8
	// B  0  0  2  3 -4  2  3  1  1 -2 -3  1 -2 -5  0  1  0 -6 -3 -2  2  2  0 -8
	// Z  0  0  1  3 -5  3  3  0  2 -2 -3  1 -2 -5  0  0  0 -6 -4 -2  2  3  0 -8
	// X  0 -1  0 -1 -3  0  0 -1  0  0 -1 -1  0 -2  0  0  0 -4 -2  0  0  0 -1 -8
	// * -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8  1
	//
	PAM320 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 1, 0, -2, 1, 0, -4, 1, -1, 0, 0, -1, -2, -1, 0, 1, 0, -1, 1, 1, 0, -6, 0, -4, 0, -8},
		/* B */ {0, 0, 2, -4, 3, 3, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -2, -6, 0, -3, 2, -8},
		/* C */ {0, -2, -4, 15, -5, -5, -4, -3, -4, -2, 0, -6, -6, -5, -4, -3, -5, -4, 0, -2, -2, -8, -3, 1, -5, -8},
		/* D */ {0, 1, 3, -5, 4, 3, -6, 1, 1, -2, 0, 0, -4, -2, 2, 0, 2, -1, 0, 0, -2, -7, -1, -5, 3, -8},
		/* E */ {0, 0, 3, -5, 3, 4, -5, 1, 1, -2, 0, 0, -3, -2, 2, 0, 2, -1, 0, 0, -2, -7, 0, -5, 3, -8},
		/* F */ {0, -4, -5, -4, -6, -5, 11, -5, -2, 1, 0, -5, 3, 1, -4, -5, -5, -5, -3, -3, -1, 1, -2, 9, -5, -8},
		/* G */ {0, 1, 1, -3, 1, 1, -5, 5, -2, -2, 0, -1, -4, -3, 1, 0, -1, -2, 1, 0, -1, -7, -1, -5, 0, -8},
		/* H */ {0, -1, 1, -4, 1, 1, -2, -2, 6, -2, 0, 0, -2, -2, 2, 0, 3, 2, -1, -1, -2, -3, 0, 0, 2, -8},
		/* I */ {0, 0, -2, -2, -2, -2, 1, -2, -2, 4, 0, -2, 3, 2, -2, -2, -2, -2, -1, 0, 4, -5, 0, -1, -2, -8},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 1, -6, 0, 0, -5, -1, 0, -2, 0, 5, -3, 0, 1, -1, 1, 4, 0, 0, -2, -3, -1, -5, 1, -8},
		/* L */ {0, -2, -3, -6, -4, -3, 3, -4, -2, 3, 0, -3, 7, 4, -3, -2, -2, -3, -3, -2, 2, -2, -1, 0, -3, -8},
		/* M */ {0, -1, -2, -5, -2, -2, 1, -3, -2, 2, 0, 0, 4, 6, -2, -2, -1, 0, -1, -1, 2, -4, 0, -2, -2, -8},
		/* N */ {0, 0, 2, -4, 2, 2, -4, 1, 2, -2, 0, 1, -3, -2, 2, 0, 1, 0, 1, 0, -2, -4, 0, -2, 1, -8},
		/* P */ {0, 1, 0, -3, 0, 0, -5, 0, 0, -2, 0, -1, -2, -2, 0, 6, 0, 0, 1, 1, -1, -6, 0, -5, 0, -8},
		/* Q */ {0, 0, 2, -5, 2, 2, -5, -1, 3, -2, 0, 1, -2, -1, 1, 0, 4, 1, 0, 0, -2, -5, 0, -4, 3, -8},
		/* R */ {0, -1, 0, -4, -1, -1, -5, -2, 2, -2, 0, 4, -3, 0, 0, 0, 1, 6, 0, -1, -2, 3, -1, -4, 0, -8},
		/* S */ {0, 1, 1, 0, 0, 0, -3, 1, -1, -1, 0, 0, -3, -1, 1, 1, 0, 0, 1, 1, -1, -3, 0, -3, 0, -8},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 0, -1, 0, 0, 0, -2, -1, 0, 1, 0, -1, 1, 2, 0, -5, 0, -3, 0, -8},
		/* V */ {0, 0, -2, -2, -2, -2, -1, -1, -2, 4, 0, -2, 2, 2, -2, -1, -2, -2, -1, 0, 4, -6, 0, -2, -2, -8},
		/* W */ {0, -6, -6, -8, -7, -7, 1, -7, -3, -5, 0, -3, -2, -4, -4, -6, -5, 3, -3, -5, -6, 22, -4, 1, -6, -8},
		/* X */ {0, 0, 0, -3, -1, 0, -2, -1, 0, 0, 0, -1, -1, 0, 0, 0, 0, -1, 0, 0, 0, -4, -1, -2, 0, -8},
		/* Y */ {0, -4, -3, 1, -5, -5, 9, -5, 0, -1, 0, -5, 0, -2, -2, -5, -4, -4, -3, -3, -2, 1, -2, 12, -4, -8},
		/* Z */ {0, 0, 2, -5, 3, 3, -5, 0, 2, -2, 0, 1, -3, -2, 1, 0, 3, 0, 0, 0, -2, -6, 0, -4, 3, -8},
		/* * */ {0, -8, -8, -8, -8, -8, -8, -8, -8, -8, 0, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 330 substitution matrix, scale = ln(2)/4 = 0.173287
	// #
	// # Expected score = -0.693, Entropy = 0.210 bits
	// #
	// # Lowest score = -8, Highest score = 22
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  1 -1  0  1 -2  0  0  1 -1  0 -2 -1 -1 -3  1  1  1 -6 -3  0  0  0  0 -8
	// R -1  6  0 -1 -4  1 -1 -2  2 -2 -3  4  0 -4  0  0 -1  3 -4 -2  0  0 -1 -8
	// N  0  0  2  2 -4  1  2  1  1 -2 -3  1 -1 -3  0  1  0 -4 -2 -1  2  1  0 -8
	// D  1 -1  2  3 -5  2  3  1  1 -2 -4  0 -2 -5  0  0  0 -7 -4 -2  3  3  0 -8
	// C -2 -4 -4 -5 15 -5 -5 -3 -3 -2 -6 -5 -5 -4 -3  0 -2 -8  1 -2 -4 -5 -3 -8
	// Q  0  1  1  2 -5  3  2 -1  3 -2 -2  1 -1 -4  0  0  0 -5 -4 -2  1  3  0 -8
	// E  0 -1  2  3 -5  2  3  1  1 -2 -3  0 -2 -5  0  0  0 -7 -4 -2  2  3  0 -8
	// G  1 -2  1  1 -3 -1  1  5 -2 -2 -4 -1 -2 -5  0  1  0 -7 -5 -1  1  0 -1 -8
	// H -1  2  1  1 -3  3  1 -2  6 -2 -2  0 -2 -2  0 -1 -1 -3  0 -2  1  2  0 -8
	// I  0 -2 -2 -2 -2 -2 -2 -2 -2  4  3 -2  2  1 -2 -1  0 -5  0  4 -2 -2  0 -8
	// L -2 -3 -3 -4 -6 -2 -3 -4 -2  3  6 -3  4  3 -2 -3 -1 -2  0  2 -3 -2 -1 -8
	// K -1  4  1  0 -5  1  0 -1  0 -2 -3  5  0 -5 -1  0  0 -3 -4 -2  1  1 -1 -8
	// M -1  0 -1 -2 -5 -1 -2 -2 -2  2  4  0  5  1 -2 -1  0 -4 -2  2 -2 -1  0 -8
	// F -3 -4 -3 -5 -4 -4 -5 -5 -2  1  3 -5  1 10 -5 -3 -3  1  9 -1 -4 -5 -2 -8
	// P  1  0  0  0 -3  0  0  0  0 -2 -2 -1 -2 -5  6  1  1 -6 -5 -1  0  0  0 -8
	// S  1  0  1  0  0  0  0  1 -1 -1 -3  0 -1 -3  1  1  1 -3 -3 -1  1  0  0 -8
	// T  1 -1  0  0 -2  0  0  0 -1  0 -1  0  0 -3  1  1  2 -5 -3  0  0  0  0 -8
	// W -6  3 -4 -7 -8 -5 -7 -7 -3 -5 -2 -3 -4  1 -6 -3 -5 22  1 -6 -5 -6 -4 -8
	// Y -3 -4 -2 -4  1 -4 -4 -5  0  0  0 -4 -2  9 -5 -3 -3  1 12 -2 -3 -4 -2 -8
	// V  0 -2 -1 -2 -2 -2 -2 -1 -2  4  2 -2  2 -1 -1 -1  0 -6 -2  4 -2 -2  0 -8
	// B  0  0  2  3 -4  1  2  1  1 -2 -3  1 -2 -4  0  1  0 -5 -3 -2  2  2  0 -8
	// Z  0  0  1  3 -5  3  3  0  2 -2 -2  1 -1 -5  0  0  0 -6 -4 -2  2  3  0 -8
	// X  0 -1  0  0 -3  0  0 -1  0  0 -1 -1  0 -2  0  0  0 -4 -2  0  0  0 -1 -8
	// * -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8  1
	//
	PAM330 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 1, 0, -2, 1, 0, -3, 1, -1, 0, 0, -1, -2, -1, 0, 1, 0, -1, 1, 1, 0, -6, 0, -3, 0, -8},
		/* B */ {0, 0, 2, -4, 3, 2, -4, 1, 1, -2, 0, 1, -3, -2, 2, 0, 1, 0, 1, 0, -2, -5, 0, -3, 2, -8},
		/* C */ {0, -2, -4, 15, -5, -5, -4, -3, -3, -2, 0, -5, -6, -5, -4, -3, -5, -4, 0, -2, -2, -8, -3, 1, -5, -8},
		/* D */ {0, 1, 3, -5, 3, 3, -5, 1, 1, -2, 0, 0, -4, -2, 2, 0, 2, -1, 0, 0, -2, -7, 0, -4, 3, -8},
		/* E */ {0, 0, 2, -5, 3, 3, -5, 1, 1, -2, 0, 0, -3, -2, 2, 0, 2, -1, 0, 0, -2, -7, 0, -4, 3, -8},
		/* F */ {0, -3, -4, -4, -5, -5, 10, -5, -2, 1, 0, -5, 3, 1, -3, -5, -4, -4, -3, -3, -1, 1, -2, 9, -5, -8},
		/* G */ {0, 1, 1, -3, 1, 1, -5, 5, -2, -2, 0, -1, -4, -2, 1, 0, -1, -2, 1, 0, -1, -7, -1, -5, 0, -8},
		/* H */ {0, -1, 1, -3, 1, 1, -2, -2, 6, -2, 0, 0, -2, -2, 1, 0, 3, 2, -1, -1, -2, -3, 0, 0, 2, -8},
		/* I */ {0, 0, -2, -2, -2, -2, 1, -2, -2, 4, 0, -2, 3, 2, -2, -2, -2, -2, -1, 0, 4, -5, 0, 0, -2, -8},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 1, -5, 0, 0, -5, -1, 0, -2, 0, 5, -3, 0, 1, -1, 1, 4, 0, 0, -2, -3, -1, -4, 1, -8},
		/* L */ {0, -2, -3, -6, -4, -3, 3, -4, -2, 3, 0, -3, 6, 4, -3, -2, -2, -3, -3, -1, 2, -2, -1, 0, -2, -8},
		/* M */ {0, -1, -2, -5, -2, -2, 1, -2, -2, 2, 0, 0, 4, 5, -1, -2, -1, 0, -1, 0, 2, -4, 0, -2, -1, -8},
		/* N */ {0, 0, 2, -4, 2, 2, -3, 1, 1, -2, 0, 1, -3, -1, 2, 0, 1, 0, 1, 0, -1, -4, 0, -2, 1, -8},
		/* P */ {0, 1, 0, -3, 0, 0, -5, 0, 0, -2, 0, -1, -2, -2, 0, 6, 0, 0, 1, 1, -1, -6, 0, -5, 0, -8},
		/* Q */ {0, 0, 1, -5, 2, 2, -4, -1, 3, -2, 0, 1, -2, -1, 1, 0, 3, 1, 0, 0, -2, -5, 0, -4, 3, -8},
		/* R */ {0, -1, 0, -4, -1, -1, -4, -2, 2, -2, 0, 4, -3, 0, 0, 0, 1, 6, 0, -1, -2, 3, -1, -4, 0, -8},
		/* S */ {0, 1, 1, 0, 0, 0, -3, 1, -1, -1, 0, 0, -3, -1, 1, 1, 0, 0, 1, 1, -1, -3, 0, -3, 0, -8},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 0, -1, 0, 0, 0, -1, 0, 0, 1, 0, -1, 1, 2, 0, -5, 0, -3, 0, -8},
		/* V */ {0, 0, -2, -2, -2, -2, -1, -1, -2, 4, 0, -2, 2, 2, -1, -1, -2, -2, -1, 0, 4, -6, 0, -2, -2, -8},
		/* W */ {0, -6, -5, -8, -7, -7, 1, -7, -3, -5, 0, -3, -2, -4, -4, -6, -5, 3, -3, -5, -6, 22, -4, 1, -6, -8},
		/* X */ {0, 0, 0, -3, 0, 0, -2, -1, 0, 0, 0, -1, -1, 0, 0, 0, 0, -1, 0, 0, 0, -4, -1, -2, 0, -8},
		/* Y */ {0, -3, -3, 1, -4, -4, 9, -5, 0, 0, 0, -4, 0, -2, -2, -5, -4, -4, -3, -3, -2, 1, -2, 12, -4, -8},
		/* Z */ {0, 0, 2, -5, 3, 3, -5, 0, 2, -2, 0, 1, -2, -1, 1, 0, 3, 0, 0, 0, -2, -6, 0, -4, 3, -8},
		/* * */ {0, -8, -8, -8, -8, -8, -8, -8, -8, -8, 0, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 340 substitution matrix, scale = ln(2)/4 = 0.173287
	// #
	// # Expected score = -0.680, Entropy = 0.198 bits
	// #
	// # Lowest score = -8, Highest score = 22
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  1 -1  0  1 -2  0  0  1 -1  0 -2 -1 -1 -3  1  1  1 -6 -3  0  0  0  0 -8
	// R -1  6  0 -1 -4  1  0 -2  2 -2 -3  4  0 -4  0  0  0  3 -4 -2  0  0 -1 -8
	// N  0  0  1  2 -3  1  1  1  1 -2 -3  1 -1 -3  0  1  0 -4 -2 -1  2  1  0 -8
	// D  1 -1  2  3 -5  2  3  1  1 -2 -4  0 -2 -5  0  0  0 -7 -4 -2  3  3  0 -8
	// C -2 -4 -3 -5 15 -5 -5 -3 -3 -2 -6 -5 -5 -4 -3  0 -2 -8  1 -2 -4 -5 -3 -8
	// Q  0  1  1  2 -5  3  2 -1  3 -2 -2  1 -1 -4  0  0  0 -5 -4 -2  1  3  0 -8
	// E  0  0  1  3 -5  2  3  1  1 -2 -3  0 -2 -5  0  0  0 -7 -4 -1  2  3  0 -8
	// G  1 -2  1  1 -3 -1  1  4 -2 -2 -4 -1 -2 -5  0  1  0 -7 -5 -1  1  0 -1 -8
	// H -1  2  1  1 -3  3  1 -2  6 -2 -2  0 -2 -2  0  0 -1 -2  0 -2  1  2  0 -8
	// I  0 -2 -2 -2 -2 -2 -2 -2 -2  4  3 -2  2  1 -2 -1  0 -5  0  3 -2 -2  0 -8
	// L -2 -3 -3 -4 -6 -2 -3 -4 -2  3  6 -3  4  3 -2 -2 -1 -2  0  2 -3 -2 -1 -8
	// K -1  4  1  0 -5  1  0 -1  0 -2 -3  4  0 -5 -1  0  0 -3 -4 -2  1  1  0 -8
	// M -1  0 -1 -2 -5 -1 -2 -2 -2  2  4  0  5  1 -2 -1  0 -4 -2  2 -2 -1  0 -8
	// F -3 -4 -3 -5 -4 -4 -5 -5 -2  1  3 -5  1 10 -4 -3 -3  1  9 -1 -4 -5 -2 -8
	// P  1  0  0  0 -3  0  0  0  0 -2 -2 -1 -2 -4  5  1  1 -5 -5 -1  0  0  0 -8
	// S  1  0  1  0  0  0  0  1  0 -1 -2  0 -1 -3  1  1  1 -3 -3 -1  1  0  0 -8
	// T  1  0  0  0 -2  0  0  0 -1  0 -1  0  0 -3  1  1  2 -5 -3  0  0  0  0 -8
	// W -6  3 -4 -7 -8 -5 -7 -7 -2 -5 -2 -3 -4  1 -5 -3 -5 22  1 -6 -5 -6 -4 -8
	// Y -3 -4 -2 -4  1 -4 -4 -5  0  0  0 -4 -2  9 -5 -3 -3  1 12 -2 -3 -4 -2 -8
	// V  0 -2 -1 -2 -2 -2 -1 -1 -2  3  2 -2  2 -1 -1 -1  0 -6 -2  4 -2 -2  0 -8
	// B  0  0  2  3 -4  1  2  1  1 -2 -3  1 -2 -4  0  1  0 -5 -3 -2  2  2  0 -8
	// Z  0  0  1  3 -5  3  3  0  2 -2 -2  1 -1 -5  0  0  0 -6 -4 -2  2  3  0 -8
	// X  0 -1  0  0 -3  0  0 -1  0  0 -1  0  0 -2  0  0  0 -4 -2  0  0  0 -1 -8
	// * -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8  1
	//
	PAM340 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 1, 0, -2, 1, 0, -3, 1, -1, 0, 0, -1, -2, -1, 0, 1, 0, -1, 1, 1, 0, -6, 0, -3, 0, -8},
		/* B */ {0, 0, 2, -4, 3, 2, -4, 1, 1, -2, 0, 1, -3, -2, 2, 0, 1, 0, 1, 0, -2, -5, 0, -3, 2, -8},
		/* C */ {0, -2, -4, 15, -5, -5, -4, -3, -3, -2, 0, -5, -6, -5, -3, -3, -5, -4, 0, -2, -2, -8, -3, 1, -5, -8},
		/* D */ {0, 1, 3, -5, 3, 3, -5, 1, 1, -2, 0, 0, -4, -2, 2, 0, 2, -1, 0, 0, -2, -7, 0, -4, 3, -8},
		/* E */ {0, 0, 2, -5, 3, 3, -5, 1, 1, -2, 0, 0, -3, -2, 1, 0, 2, 0, 0, 0, -1, -7, 0, -4, 3, -8},
		/* F */ {0, -3, -4, -4, -5, -5, 10, -5, -2, 1, 0, -5, 3, 1, -3, -4, -4, -4, -3, -3, -1, 1, -2, 9, -5, -8},
		/* G */ {0, 1, 1, -3, 1, 1, -5, 4, -2, -2, 0, -1, -4, -2, 1, 0, -1, -2, 1, 0, -1, -7, -1, -5, 0, -8},
		/* H */ {0, -1, 1, -3, 1, 1, -2, -2, 6, -2, 0, 0, -2, -2, 1, 0, 3, 2, 0, -1, -2, -2, 0, 0, 2, -8},
		/* I */ {0, 0, -2, -2, -2, -2, 1, -2, -2, 4, 0, -2, 3, 2, -2, -2, -2, -2, -1, 0, 3, -5, 0, 0, -2, -8},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 1, -5, 0, 0, -5, -1, 0, -2, 0, 4, -3, 0, 1, -1, 1, 4, 0, 0, -2, -3, 0, -4, 1, -8},
		/* L */ {0, -2, -3, -6, -4, -3, 3, -4, -2, 3, 0, -3, 6, 4, -3, -2, -2, -3, -2, -1, 2, -2, -1, 0, -2, -8},
		/* M */ {0, -1, -2, -5, -2, -2, 1, -2, -2, 2, 0, 0, 4, 5, -1, -2, -1, 0, -1, 0, 2, -4, 0, -2, -1, -8},
		/* N */ {0, 0, 2, -3, 2, 1, -3, 1, 1, -2, 0, 1, -3, -1, 1, 0, 1, 0, 1, 0, -1, -4, 0, -2, 1, -8},
		/* P */ {0, 1, 0, -3, 0, 0, -4, 0, 0, -2, 0, -1, -2, -2, 0, 5, 0, 0, 1, 1, -1, -5, 0, -5, 0, -8},
		/* Q */ {0, 0, 1, -5, 2, 2, -4, -1, 3, -2, 0, 1, -2, -1, 1, 0, 3, 1, 0, 0, -2, -5, 0, -4, 3, -8},
		/* R */ {0, -1, 0, -4, -1, 0, -4, -2, 2, -2, 0, 4, -3, 0, 0, 0, 1, 6, 0, 0, -2, 3, -1, -4, 0, -8},
		/* S */ {0, 1, 1, 0, 0, 0, -3, 1, 0, -1, 0, 0, -2, -1, 1, 1, 0, 0, 1, 1, -1, -3, 0, -3, 0, -8},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 0, -1, 0, 0, 0, -1, 0, 0, 1, 0, 0, 1, 2, 0, -5, 0, -3, 0, -8},
		/* V */ {0, 0, -2, -2, -2, -1, -1, -1, -2, 3, 0, -2, 2, 2, -1, -1, -2, -2, -1, 0, 4, -6, 0, -2, -2, -8},
		/* W */ {0, -6, -5, -8, -7, -7, 1, -7, -2, -5, 0, -3, -2, -4, -4, -5, -5, 3, -3, -5, -6, 22, -4, 1, -6, -8},
		/* X */ {0, 0, 0, -3, 0, 0, -2, -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, 0, 0, -4, -1, -2, 0, -8},
		/* Y */ {0, -3, -3, 1, -4, -4, 9, -5, 0, 0, 0, -4, 0, -2, -2, -5, -4, -4, -3, -3, -2, 1, -2, 12, -4, -8},
		/* Z */ {0, 0, 2, -5, 3, 3, -5, 0, 2, -2, 0, 1, -2, -1, 1, 0, 3, 0, 0, 0, -2, -6, 0, -4, 3, -8},
		/* * */ {0, -8, -8, -8, -8, -8, -8, -8, -8, -8, 0, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 350 substitution matrix, scale = ln(2)/5 = 0.138629
	// #
	// # Expected score = -0.701, Entropy = 0.186 bits
	// #
	// # Lowest score = -10, Highest score = 27
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A   2  -1   0   1  -2   0   1   2  -1   0  -2  -1  -1  -4   1   1   1  -7  -4   0   1   0   0 -10
	// R  -1   7   1  -1  -4   2   0  -2   2  -2  -3   4   0  -5   0   0  -1   4  -5  -3   0   1  -1 -10
	// N   0   1   2   2  -4   1   2   1   2  -2  -3   1  -2  -4   0   1   1  -5  -3  -2   2   2   0 -10
	// D   1  -1   2   4  -6   2   4   1   1  -2  -4   1  -3  -6   0   1   0  -8  -5  -2   3   3  -1 -10
	// C  -2  -4  -4  -6  18  -6  -6  -4  -4  -3  -7  -6  -6  -5  -3   0  -2 -10   1  -2  -5  -6  -3 -10
	// Q   0   2   1   2  -6   4   3  -1   3  -2  -2   1  -1  -5   1   0   0  -5  -5  -2   2   3   0 -10
	// E   1   0   2   4  -6   3   4   1   1  -2  -4   0  -2  -6   0   0   0  -8  -5  -2   3   3   0 -10
	// G   2  -2   1   1  -4  -1   1   5  -2  -2  -4  -1  -3  -6   0   1   1  -8  -6  -1   1   0  -1 -10
	// H  -1   2   2   1  -4   3   1  -2   7  -2  -2   1  -2  -2   0  -1  -1  -3   0  -2   1   2   0 -10
	// I   0  -2  -2  -2  -3  -2  -2  -2  -2   5   4  -2   3   2  -2  -1   0  -6   0   4  -2  -2   0 -10
	// L  -2  -3  -3  -4  -7  -2  -4  -4  -2   4   8  -3   5   3  -3  -3  -2  -2   0   3  -4  -3  -1 -10
	// K  -1   4   1   1  -6   1   0  -1   1  -2  -3   5   0  -6  -1   0   0  -4  -5  -2   1   1  -1 -10
	// M  -1   0  -2  -3  -6  -1  -2  -3  -2   3   5   0   6   1  -2  -2  -1  -5  -2   2  -2  -2   0 -10
	// F  -4  -5  -4  -6  -5  -5  -6  -6  -2   2   3  -6   1  13  -5  -4  -3   1  11  -1  -5  -6  -2 -10
	// P   1   0   0   0  -3   1   0   0   0  -2  -3  -1  -2  -5   6   1   1  -7  -6  -1   0   0   0 -10
	// S   1   0   1   1   0   0   0   1  -1  -1  -3   0  -2  -4   1   1   1  -3  -3  -1   1   0   0 -10
	// T   1  -1   1   0  -2   0   0   1  -1   0  -2   0  -1  -3   1   1   2  -6  -3   0   0   0   0 -10
	// W  -7   4  -5  -8 -10  -5  -8  -8  -3  -6  -2  -4  -5   1  -7  -3  -6  27   1  -7  -6  -7  -5 -10
	// Y  -4  -5  -3  -5   1  -5  -5  -6   0   0   0  -5  -2  11  -6  -3  -3   1  14  -2  -4  -5  -2 -10
	// V   0  -3  -2  -2  -2  -2  -2  -1  -2   4   3  -2   2  -1  -1  -1   0  -7  -2   5  -2  -2   0 -10
	// B   1   0   2   3  -5   2   3   1   1  -2  -4   1  -2  -5   0   1   0  -6  -4  -2   3   2   0 -10
	// Z   0   1   2   3  -6   3   3   0   2  -2  -3   1  -2  -6   0   0   0  -7  -5  -2   2   3   0 -10
	// X   0  -1   0  -1  -3   0   0  -1   0   0  -1  -1   0  -2   0   0   0  -5  -2   0   0   0  -1 -10
	// * -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10   1
	//
	PAM350 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 2, 1, -2, 1, 1, -4, 2, -1, 0, 0, -1, -2, -1, 0, 1, 0, -1, 1, 1, 0, -7, 0, -4, 0, -10},
		/* B */ {0, 1, 3, -5, 3, 3, -5, 1, 1, -2, 0, 1, -4, -2, 2, 0, 2, 0, 1, 0, -2, -6, 0, -4, 2, -10},
		/* C */ {0, -2, -5, 18, -6, -6, -5, -4, -4, -3, 0, -6, -7, -6, -4, -3, -6, -4, 0, -2, -2, -10, -3, 1, -6, -10},
		/* D */ {0, 1, 3, -6, 4, 4, -6, 1, 1, -2, 0, 1, -4, -3, 2, 0, 2, -1, 1, 0, -2, -8, -1, -5, 3, -10},
		/* E */ {0, 1, 3, -6, 4, 4, -6, 1, 1, -2, 0, 0, -4, -2, 2, 0, 3, 0, 0, 0, -2, -8, 0, -5, 3, -10},
		/* F */ {0, -4, -5, -5, -6, -6, 13, -6, -2, 2, 0, -6, 3, 1, -4, -5, -5, -5, -4, -3, -1, 1, -2, 11, -6, -10},
		/* G */ {0, 2, 1, -4, 1, 1, -6, 5, -2, -2, 0, -1, -4, -3, 1, 0, -1, -2, 1, 1, -1, -8, -1, -6, 0, -10},
		/* H */ {0, -1, 1, -4, 1, 1, -2, -2, 7, -2, 0, 1, -2, -2, 2, 0, 3, 2, -1, -1, -2, -3, 0, 0, 2, -10},
		/* I */ {0, 0, -2, -3, -2, -2, 2, -2, -2, 5, 0, -2, 4, 3, -2, -2, -2, -2, -1, 0, 4, -6, 0, 0, -2, -10},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 1, -6, 1, 0, -6, -1, 1, -2, 0, 5, -3, 0, 1, -1, 1, 4, 0, 0, -2, -4, -1, -5, 1, -10},
		/* L */ {0, -2, -4, -7, -4, -4, 3, -4, -2, 4, 0, -3, 8, 5, -3, -3, -2, -3, -3, -2, 3, -2, -1, 0, -3, -10},
		/* M */ {0, -1, -2, -6, -3, -2, 1, -3, -2, 3, 0, 0, 5, 6, -2, -2, -1, 0, -2, -1, 2, -5, 0, -2, -2, -10},
		/* N */ {0, 0, 2, -4, 2, 2, -4, 1, 2, -2, 0, 1, -3, -2, 2, 0, 1, 1, 1, 1, -2, -5, 0, -3, 2, -10},
		/* P */ {0, 1, 0, -3, 0, 0, -5, 0, 0, -2, 0, -1, -3, -2, 0, 6, 1, 0, 1, 1, -1, -7, 0, -6, 0, -10},
		/* Q */ {0, 0, 2, -6, 2, 3, -5, -1, 3, -2, 0, 1, -2, -1, 1, 1, 4, 2, 0, 0, -2, -5, 0, -5, 3, -10},
		/* R */ {0, -1, 0, -4, -1, 0, -5, -2, 2, -2, 0, 4, -3, 0, 1, 0, 2, 7, 0, -1, -3, 4, -1, -5, 1, -10},
		/* S */ {0, 1, 1, 0, 1, 0, -4, 1, -1, -1, 0, 0, -3, -2, 1, 1, 0, 0, 1, 1, -1, -3, 0, -3, 0, -10},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 1, -1, 0, 0, 0, -2, -1, 1, 1, 0, -1, 1, 2, 0, -6, 0, -3, 0, -10},
		/* V */ {0, 0, -2, -2, -2, -2, -1, -1, -2, 4, 0, -2, 3, 2, -2, -1, -2, -3, -1, 0, 5, -7, 0, -2, -2, -10},
		/* W */ {0, -7, -6, -10, -8, -8, 1, -8, -3, -6, 0, -4, -2, -5, -5, -7, -5, 4, -3, -6, -7, 27, -5, 1, -7, -10},
		/* X */ {0, 0, 0, -3, -1, 0, -2, -1, 0, 0, 0, -1, -1, 0, 0, 0, 0, -1, 0, 0, 0, -5, -1, -2, 0, -10},
		/* Y */ {0, -4, -4, 1, -5, -5, 11, -6, 0, 0, 0, -5, 0, -2, -3, -6, -5, -5, -3, -3, -2, 1, -2, 14, -5, -10},
		/* Z */ {0, 0, 2, -6, 3, 3, -6, 0, 2, -2, 0, 1, -3, -2, 2, 0, 3, 1, 0, 0, -2, -7, 0, -5, 3, -10},
		/* * */ {0, -10, -10, -10, -10, -10, -10, -10, -10, -10, 0, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 360 substitution matrix, scale = ln(2)/5 = 0.138629
	// #
	// # Expected score = -0.697, Entropy = 0.175 bits
	// #
	// # Lowest score = -9, Highest score = 27
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  1 -1  0  1 -2  0  1  2 -1  0 -2 -1 -1 -4  1  1  1 -7 -4  0  1  0  0 -9
	// R -1  6  1 -1 -4  2  0 -2  2 -2 -3  4  0 -5  0  0  0  4 -5 -2  0  1 -1 -9
	// N  0  1  2  2 -4  1  2  1  2 -2 -3  1 -2 -4  0  1  1 -5 -3 -2  2  2  0 -9
	// D  1 -1  2  4 -6  2  4  1  1 -2 -4  1 -2 -6  0  1  0 -8 -5 -2  3  3  0 -9
	// C -2 -4 -4 -6 18 -6 -6 -4 -4 -3 -7 -6 -6 -4 -3  0 -2 -9  1 -2 -5 -6 -3 -9
	// Q  0  2  1  2 -6  3  3 -1  3 -2 -2  1 -1 -5  1  0  0 -5 -4 -2  2  3  0 -9
	// E  1  0  2  4 -6  3  4  1  1 -2 -3  0 -2 -6  0  0  0 -8 -5 -2  3  3  0 -9
	// G  2 -2  1  1 -4 -1  1  5 -2 -2 -4 -1 -3 -6  0  1  1 -8 -6 -1  1  0 -1 -9
	// H -1  2  2  1 -4  3  1 -2  7 -2 -2  1 -2 -2  0  0 -1 -3  0 -2  1  2  0 -9
	// I  0 -2 -2 -2 -3 -2 -2 -2 -2  4  3 -2  3  2 -2 -1  0 -6  0  4 -2 -2  0 -9
	// L -2 -3 -3 -4 -7 -2 -3 -4 -2  3  7 -3  5  3 -3 -3 -2 -2  0  3 -4 -3 -1 -9
	// K -1  4  1  1 -6  1  0 -1  1 -2 -3  5  0 -6 -1  0  0 -4 -5 -2  1  1 -1 -9
	// M -1  0 -2 -2 -6 -1 -2 -3 -2  3  5  0  6  1 -2 -2 -1 -4 -2  2 -2 -2  0 -9
	// F -4 -5 -4 -6 -4 -5 -6 -6 -2  2  3 -6  1 12 -5 -4 -3  2 11 -1 -5 -5 -2 -9
	// P  1  0  0  0 -3  1  0  0  0 -2 -3 -1 -2 -5  6  1  1 -6 -5 -1  0  0  0 -9
	// S  1  0  1  1  0  0  0  1  0 -1 -3  0 -2 -4  1  1  1 -3 -3 -1  1  0  0 -9
	// T  1  0  1  0 -2  0  0  1 -1  0 -2  0 -1 -3  1  1  2 -6 -3  0  0  0  0 -9
	// W -7  4 -5 -8 -9 -5 -8 -8 -3 -6 -2 -4 -4  2 -6 -3 -6 27  1 -7 -6 -7 -4 -9
	// Y -4 -5 -3 -5  1 -4 -5 -6  0  0  0 -5 -2 11 -5 -3 -3  1 14 -2 -4 -5 -2 -9
	// V  0 -2 -2 -2 -2 -2 -2 -1 -2  4  3 -2  2 -1 -1 -1  0 -7 -2  4 -2 -2  0 -9
	// B  1  0  2  3 -5  2  3  1  1 -2 -4  1 -2 -5  0  1  0 -6 -4 -2  2  2  0 -9
	// Z  0  1  2  3 -6  3  3  0  2 -2 -3  1 -2 -5  0  0  0 -7 -5 -2  2  3  0 -9
	// X  0 -1  0  0 -3  0  0 -1  0  0 -1 -1  0 -2  0  0  0 -4 -2  0  0  0 -1 -9
	// * -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9  1
	//
	PAM360 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 1, 1, -2, 1, 1, -4, 2, -1, 0, 0, -1, -2, -1, 0, 1, 0, -1, 1, 1, 0, -7, 0, -4, 0, -9},
		/* B */ {0, 1, 2, -5, 3, 3, -5, 1, 1, -2, 0, 1, -4, -2, 2, 0, 2, 0, 1, 0, -2, -6, 0, -4, 2, -9},
		/* C */ {0, -2, -5, 18, -6, -6, -4, -4, -4, -3, 0, -6, -7, -6, -4, -3, -6, -4, 0, -2, -2, -9, -3, 1, -6, -9},
		/* D */ {0, 1, 3, -6, 4, 4, -6, 1, 1, -2, 0, 1, -4, -2, 2, 0, 2, -1, 1, 0, -2, -8, 0, -5, 3, -9},
		/* E */ {0, 1, 3, -6, 4, 4, -6, 1, 1, -2, 0, 0, -3, -2, 2, 0, 3, 0, 0, 0, -2, -8, 0, -5, 3, -9},
		/* F */ {0, -4, -5, -4, -6, -6, 12, -6, -2, 2, 0, -6, 3, 1, -4, -5, -5, -5, -4, -3, -1, 2, -2, 11, -5, -9},
		/* G */ {0, 2, 1, -4, 1, 1, -6, 5, -2, -2, 0, -1, -4, -3, 1, 0, -1, -2, 1, 1, -1, -8, -1, -6, 0, -9},
		/* H */ {0, -1, 1, -4, 1, 1, -2, -2, 7, -2, 0, 1, -2, -2, 2, 0, 3, 2, 0, -1, -2, -3, 0, 0, 2, -9},
		/* I */ {0, 0, -2, -3, -2, -2, 2, -2, -2, 4, 0, -2, 3, 3, -2, -2, -2, -2, -1, 0, 4, -6, 0, 0, -2, -9},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 1, -6, 1, 0, -6, -1, 1, -2, 0, 5, -3, 0, 1, -1, 1, 4, 0, 0, -2, -4, -1, -5, 1, -9},
		/* L */ {0, -2, -4, -7, -4, -3, 3, -4, -2, 3, 0, -3, 7, 5, -3, -3, -2, -3, -3, -2, 3, -2, -1, 0, -3, -9},
		/* M */ {0, -1, -2, -6, -2, -2, 1, -3, -2, 3, 0, 0, 5, 6, -2, -2, -1, 0, -2, -1, 2, -4, 0, -2, -2, -9},
		/* N */ {0, 0, 2, -4, 2, 2, -4, 1, 2, -2, 0, 1, -3, -2, 2, 0, 1, 1, 1, 1, -2, -5, 0, -3, 2, -9},
		/* P */ {0, 1, 0, -3, 0, 0, -5, 0, 0, -2, 0, -1, -3, -2, 0, 6, 1, 0, 1, 1, -1, -6, 0, -5, 0, -9},
		/* Q */ {0, 0, 2, -6, 2, 3, -5, -1, 3, -2, 0, 1, -2, -1, 1, 1, 3, 2, 0, 0, -2, -5, 0, -4, 3, -9},
		/* R */ {0, -1, 0, -4, -1, 0, -5, -2, 2, -2, 0, 4, -3, 0, 1, 0, 2, 6, 0, 0, -2, 4, -1, -5, 1, -9},
		/* S */ {0, 1, 1, 0, 1, 0, -4, 1, 0, -1, 0, 0, -3, -2, 1, 1, 0, 0, 1, 1, -1, -3, 0, -3, 0, -9},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 1, -1, 0, 0, 0, -2, -1, 1, 1, 0, 0, 1, 2, 0, -6, 0, -3, 0, -9},
		/* V */ {0, 0, -2, -2, -2, -2, -1, -1, -2, 4, 0, -2, 3, 2, -2, -1, -2, -2, -1, 0, 4, -7, 0, -2, -2, -9},
		/* W */ {0, -7, -6, -9, -8, -8, 2, -8, -3, -6, 0, -4, -2, -4, -5, -6, -5, 4, -3, -6, -7, 27, -4, 1, -7, -9},
		/* X */ {0, 0, 0, -3, 0, 0, -2, -1, 0, 0, 0, -1, -1, 0, 0, 0, 0, -1, 0, 0, 0, -4, -1, -2, 0, -9},
		/* Y */ {0, -4, -4, 1, -5, -5, 11, -6, 0, 0, 0, -5, 0, -2, -3, -5, -4, -5, -3, -3, -2, 1, -2, 14, -5, -9},
		/* Z */ {0, 0, 2, -6, 3, 3, -5, 0, 2, -2, 0, 1, -3, -2, 2, 0, 3, 1, 0, 0, -2, -7, 0, -5, 3, -9},
		/* * */ {0, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 370 substitution matrix, scale = ln(2)/5 = 0.138629
	// #
	// # Expected score = -0.649, Entropy = 0.165 bits
	// #
	// # Lowest score = -9, Highest score = 27
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  1 -1  0  1 -2  0  1  2 -1  0 -2 -1 -1 -4  1  1  1 -7 -4  0  1  0  0 -9
	// R -1  6  1  0 -4  2  0 -2  2 -2 -3  4  0 -5  0  0  0  3 -4 -2  0  1 -1 -9
	// N  0  1  2  2 -4  1  2  1  2 -2 -3  1 -2 -4  0  1  0 -5 -3 -1  2  1  0 -9
	// D  1  0  2  4 -5  2  3  1  1 -2 -4  1 -2 -6  0  1  0 -7 -5 -2  3  3  0 -9
	// C -2 -4 -4 -5 18 -6 -6 -3 -4 -2 -6 -6 -6 -4 -3  0 -2 -9  1 -2 -5 -6 -3 -9
	// Q  0  2  1  2 -6  3  2 -1  3 -2 -2  1 -1 -5  1  0  0 -5 -4 -2  2  3  0 -9
	// E  1  0  2  3 -6  2  3  1  1 -2 -3  1 -2 -6  0  0  0 -8 -5 -2  3  3  0 -9
	// G  2 -2  1  1 -3 -1  1  5 -2 -2 -4 -1 -3 -5  0  1  1 -8 -6 -1  1  0 -1 -9
	// H -1  2  2  1 -4  3  1 -2  6 -2 -2  1 -2 -2  0  0 -1 -3  0 -2  1  2  0 -9
	// I  0 -2 -2 -2 -2 -2 -2 -2 -2  4  3 -2  3  2 -2 -1  0 -5  0  4 -2 -2  0 -9
	// L -2 -3 -3 -4 -6 -2 -3 -4 -2  3  7 -3  5  3 -3 -3 -1 -2  0  3 -3 -3 -1 -9
	// K -1  4  1  1 -6  1  1 -1  1 -2 -3  5  0 -6 -1  0  0 -3 -5 -2  1  1  0 -9
	// M -1  0 -2 -2 -6 -1 -2 -3 -2  3  5  0  5  1 -2 -1  0 -4 -2  2 -2 -2  0 -9
	// F -4 -5 -4 -6 -4 -5 -6 -5 -2  2  3 -6  1 12 -5 -4 -3  2 11  0 -5 -5 -2 -9
	// P  1  0  0  0 -3  1  0  0  0 -2 -3 -1 -2 -5  6  1  1 -6 -5 -1  0  0  0 -9
	// S  1  0  1  1  0  0  0  1  0 -1 -3  0 -1 -4  1  1  1 -3 -3 -1  1  0  0 -9
	// T  1  0  0  0 -2  0  0  1 -1  0 -1  0  0 -3  1  1  2 -6 -3  0  0  0  0 -9
	// W -7  3 -5 -7 -9 -5 -8 -8 -3 -5 -2 -3 -4  2 -6 -3 -6 27  1 -7 -6 -6 -4 -9
	// Y -4 -4 -3 -5  1 -4 -5 -6  0  0  0 -5 -2 11 -5 -3 -3  1 14 -2 -4 -5 -2 -9
	// V  0 -2 -1 -2 -2 -2 -2 -1 -2  4  3 -2  2  0 -1 -1  0 -7 -2  4 -2 -2  0 -9
	// B  1  0  2  3 -5  2  3  1  1 -2 -3  1 -2 -5  0  1  0 -6 -4 -2  2  2  0 -9
	// Z  0  1  1  3 -6  3  3  0  2 -2 -3  1 -2 -5  0  0  0 -6 -5 -2  2  3  0 -9
	// X  0 -1  0  0 -3  0  0 -1  0  0 -1  0  0 -2  0  0  0 -4 -2  0  0  0 -1 -9
	// * -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9  1
	//
	PAM370 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 1, 1, -2, 1, 1, -4, 2, -1, 0, 0, -1, -2, -1, 0, 1, 0, -1, 1, 1, 0, -7, 0, -4, 0, -9},
		/* B */ {0, 1, 2, -5, 3, 3, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -2, -6, 0, -4, 2, -9},
		/* C */ {0, -2, -5, 18, -5, -6, -4, -3, -4, -2, 0, -6, -6, -6, -4, -3, -6, -4, 0, -2, -2, -9, -3, 1, -6, -9},
		/* D */ {0, 1, 3, -5, 4, 3, -6, 1, 1, -2, 0, 1, -4, -2, 2, 0, 2, 0, 1, 0, -2, -7, 0, -5, 3, -9},
		/* E */ {0, 1, 3, -6, 3, 3, -6, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 0, 0, -2, -8, 0, -5, 3, -9},
		/* F */ {0, -4, -5, -4, -6, -6, 12, -5, -2, 2, 0, -6, 3, 1, -4, -5, -5, -5, -4, -3, 0, 2, -2, 11, -5, -9},
		/* G */ {0, 2, 1, -3, 1, 1, -5, 5, -2, -2, 0, -1, -4, -3, 1, 0, -1, -2, 1, 1, -1, -8, -1, -6, 0, -9},
		/* H */ {0, -1, 1, -4, 1, 1, -2, -2, 6, -2, 0, 1, -2, -2, 2, 0, 3, 2, 0, -1, -2, -3, 0, 0, 2, -9},
		/* I */ {0, 0, -2, -2, -2, -2, 2, -2, -2, 4, 0, -2, 3, 3, -2, -2, -2, -2, -1, 0, 4, -5, 0, 0, -2, -9},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 1, -6, 1, 1, -6, -1, 1, -2, 0, 5, -3, 0, 1, -1, 1, 4, 0, 0, -2, -3, 0, -5, 1, -9},
		/* L */ {0, -2, -3, -6, -4, -3, 3, -4, -2, 3, 0, -3, 7, 5, -3, -3, -2, -3, -3, -1, 3, -2, -1, 0, -3, -9},
		/* M */ {0, -1, -2, -6, -2, -2, 1, -3, -2, 3, 0, 0, 5, 5, -2, -2, -1, 0, -1, 0, 2, -4, 0, -2, -2, -9},
		/* N */ {0, 0, 2, -4, 2, 2, -4, 1, 2, -2, 0, 1, -3, -2, 2, 0, 1, 1, 1, 0, -1, -5, 0, -3, 1, -9},
		/* P */ {0, 1, 0, -3, 0, 0, -5, 0, 0, -2, 0, -1, -3, -2, 0, 6, 1, 0, 1, 1, -1, -6, 0, -5, 0, -9},
		/* Q */ {0, 0, 2, -6, 2, 2, -5, -1, 3, -2, 0, 1, -2, -1, 1, 1, 3, 2, 0, 0, -2, -5, 0, -4, 3, -9},
		/* R */ {0, -1, 0, -4, 0, 0, -5, -2, 2, -2, 0, 4, -3, 0, 1, 0, 2, 6, 0, 0, -2, 3, -1, -4, 1, -9},
		/* S */ {0, 1, 1, 0, 1, 0, -4, 1, 0, -1, 0, 0, -3, -1, 1, 1, 0, 0, 1, 1, -1, -3, 0, -3, 0, -9},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 1, -1, 0, 0, 0, -1, 0, 0, 1, 0, 0, 1, 2, 0, -6, 0, -3, 0, -9},
		/* V */ {0, 0, -2, -2, -2, -2, 0, -1, -2, 4, 0, -2, 3, 2, -1, -1, -2, -2, -1, 0, 4, -7, 0, -2, -2, -9},
		/* W */ {0, -7, -6, -9, -7, -8, 2, -8, -3, -5, 0, -3, -2, -4, -5, -6, -5, 3, -3, -6, -7, 27, -4, 1, -6, -9},
		/* X */ {0, 0, 0, -3, 0, 0, -2, -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, 0, 0, -4, -1, -2, 0, -9},
		/* Y */ {0, -4, -4, 1, -5, -5, 11, -6, 0, 0, 0, -5, 0, -2, -3, -5, -4, -4, -3, -3, -2, 1, -2, 14, -5, -9},
		/* Z */ {0, 0, 2, -6, 3, 3, -5, 0, 2, -2, 0, 1, -3, -2, 1, 0, 3, 1, 0, 0, -2, -6, 0, -5, 3, -9},
		/* * */ {0, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 380 substitution matrix, scale = ln(2)/5 = 0.138629
	// #
	// # Expected score = -0.612, Entropy = 0.156 bits
	// #
	// # Lowest score = -9, Highest score = 26
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  1 -1  0  1 -2  0  1  2 -1  0 -2 -1 -1 -4  1  1  1 -6 -4  0  1  0  0 -9
	// R -1  6  1  0 -4  2  0 -2  2 -2 -3  4  0 -5  0  0  0  3 -4 -2  0  1  0 -9
	// N  0  1  1  2 -4  1  2  1  1 -2 -3  1 -1 -4  0  1  0 -5 -3 -1  2  1  0 -9
	// D  1  0  2  3 -5  2  3  1  1 -2 -4  1 -2 -6  0  1  0 -7 -5 -2  3  3  0 -9
	// C -2 -4 -4 -5 17 -5 -5 -3 -4 -2 -6 -6 -5 -4 -3  0 -2 -9  1 -2 -4 -5 -3 -9
	// Q  0  2  1  2 -5  3  2 -1  3 -2 -2  1 -1 -5  1  0  0 -5 -4 -2  2  3  0 -9
	// E  1  0  2  3 -5  2  3  1  1 -2 -3  1 -2 -5  0  0  0 -7 -5 -2  3  3  0 -9
	// G  2 -2  1  1 -3 -1  1  5 -1 -2 -4 -1 -2 -5  0  1  1 -8 -5 -1  1  0  0 -9
	// H -1  2  1  1 -4  3  1 -1  6 -2 -2  1 -2 -2  0  0 -1 -3  0 -2  1  2  0 -9
	// I  0 -2 -2 -2 -2 -2 -2 -2 -2  4  3 -2  3  2 -2 -1  0 -5  0  4 -2 -2  0 -9
	// L -2 -3 -3 -4 -6 -2 -3 -4 -2  3  7 -3  4  3 -2 -3 -1 -2  0  3 -3 -3 -1 -9
	// K -1  4  1  1 -6  1  1 -1  1 -2 -3  5  0 -5  0  0  0 -3 -5 -2  1  1  0 -9
	// M -1  0 -1 -2 -5 -1 -2 -2 -2  3  4  0  5  1 -2 -1  0 -4 -2  2 -2 -1  0 -9
	// F -4 -5 -4 -6 -4 -5 -5 -5 -2  2  3 -5  1 12 -5 -4 -3  2 10  0 -5 -5 -2 -9
	// P  1  0  0  0 -3  1  0  0  0 -2 -2  0 -2 -5  5  1  1 -6 -5 -1  0  0  0 -9
	// S  1  0  1  1  0  0  0  1  0 -1 -3  0 -1 -4  1  1  1 -3 -3 -1  1  0  0 -9
	// T  1  0  0  0 -2  0  0  1 -1  0 -1  0  0 -3  1  1  2 -6 -3  0  0  0  0 -9
	// W -6  3 -5 -7 -9 -5 -7 -8 -3 -5 -2 -3 -4  2 -6 -3 -6 26  1 -6 -6 -6 -4 -9
	// Y -4 -4 -3 -5  1 -4 -5 -5  0  0  0 -5 -2 10 -5 -3 -3  1 13 -2 -4 -4 -2 -9
	// V  0 -2 -1 -2 -2 -2 -2 -1 -2  4  3 -2  2  0 -1 -1  0 -6 -2  4 -2 -2  0 -9
	// B  1  0  2  3 -4  2  3  1  1 -2 -3  1 -2 -5  0  1  0 -6 -4 -2  2  2  0 -9
	// Z  0  1  1  3 -5  3  3  0  2 -2 -3  1 -1 -5  0  0  0 -6 -4 -2  2  3  0 -9
	// X  0  0  0  0 -3  0  0  0  0  0 -1  0  0 -2  0  0  0 -4 -2  0  0  0 -1 -9
	// * -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9  1
	//
	PAM380 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 1, 1, -2, 1, 1, -4, 2, -1, 0, 0, -1, -2, -1, 0, 1, 0, -1, 1, 1, 0, -6, 0, -4, 0, -9},
		/* B */ {0, 1, 2, -4, 3, 3, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -2, -6, 0, -4, 2, -9},
		/* C */ {0, -2, -4, 17, -5, -5, -4, -3, -4, -2, 0, -6, -6, -5, -4, -3, -5, -4, 0, -2, -2, -9, -3, 1, -5, -9},
		/* D */ {0, 1, 3, -5, 3, 3, -6, 1, 1, -2, 0, 1, -4, -2, 2, 0, 2, 0, 1, 0, -2, -7, 0, -5, 3, -9},
		/* E */ {0, 1, 3, -5, 3, 3, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 0, 0, -2, -7, 0, -5, 3, -9},
		/* F */ {0, -4, -5, -4, -6, -5, 12, -5, -2, 2, 0, -5, 3, 1, -4, -5, -5, -5, -4, -3, 0, 2, -2, 10, -5, -9},
		/* G */ {0, 2, 1, -3, 1, 1, -5, 5, -1, -2, 0, -1, -4, -2, 1, 0, -1, -2, 1, 1, -1, -8, 0, -5, 0, -9},
		/* H */ {0, -1, 1, -4, 1, 1, -2, -1, 6, -2, 0, 1, -2, -2, 1, 0, 3, 2, 0, -1, -2, -3, 0, 0, 2, -9},
		/* I */ {0, 0, -2, -2, -2, -2, 2, -2, -2, 4, 0, -2, 3, 3, -2, -2, -2, -2, -1, 0, 4, -5, 0, 0, -2, -9},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 1, -6, 1, 1, -5, -1, 1, -2, 0, 5, -3, 0, 1, 0, 1, 4, 0, 0, -2, -3, 0, -5, 1, -9},
		/* L */ {0, -2, -3, -6, -4, -3, 3, -4, -2, 3, 0, -3, 7, 4, -3, -2, -2, -3, -3, -1, 3, -2, -1, 0, -3, -9},
		/* M */ {0, -1, -2, -5, -2, -2, 1, -2, -2, 3, 0, 0, 4, 5, -1, -2, -1, 0, -1, 0, 2, -4, 0, -2, -1, -9},
		/* N */ {0, 0, 2, -4, 2, 2, -4, 1, 1, -2, 0, 1, -3, -1, 1, 0, 1, 1, 1, 0, -1, -5, 0, -3, 1, -9},
		/* P */ {0, 1, 0, -3, 0, 0, -5, 0, 0, -2, 0, 0, -2, -2, 0, 5, 1, 0, 1, 1, -1, -6, 0, -5, 0, -9},
		/* Q */ {0, 0, 2, -5, 2, 2, -5, -1, 3, -2, 0, 1, -2, -1, 1, 1, 3, 2, 0, 0, -2, -5, 0, -4, 3, -9},
		/* R */ {0, -1, 0, -4, 0, 0, -5, -2, 2, -2, 0, 4, -3, 0, 1, 0, 2, 6, 0, 0, -2, 3, 0, -4, 1, -9},
		/* S */ {0, 1, 1, 0, 1, 0, -4, 1, 0, -1, 0, 0, -3, -1, 1, 1, 0, 0, 1, 1, -1, -3, 0, -3, 0, -9},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 1, -1, 0, 0, 0, -1, 0, 0, 1, 0, 0, 1, 2, 0, -6, 0, -3, 0, -9},
		/* V */ {0, 0, -2, -2, -2, -2, 0, -1, -2, 4, 0, -2, 3, 2, -1, -1, -2, -2, -1, 0, 4, -6, 0, -2, -2, -9},
		/* W */ {0, -6, -6, -9, -7, -7, 2, -8, -3, -5, 0, -3, -2, -4, -5, -6, -5, 3, -3, -6, -6, 26, -4, 1, -6, -9},
		/* X */ {0, 0, 0, -3, 0, 0, -2, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -4, -1, -2, 0, -9},
		/* Y */ {0, -4, -4, 1, -5, -5, 10, -5, 0, 0, 0, -5, 0, -2, -3, -5, -4, -4, -3, -3, -2, 1, -2, 13, -4, -9},
		/* Z */ {0, 0, 2, -5, 3, 3, -5, 0, 2, -2, 0, 1, -3, -1, 1, 0, 3, 1, 0, 0, -2, -6, 0, -4, 3, -9},
		/* * */ {0, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 390 substitution matrix, scale = ln(2)/5 = 0.138629
	// #
	// # Expected score = -0.581, Entropy = 0.147 bits
	// #
	// # Lowest score = -9, Highest score = 26
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  1 -1  0  1 -2  0  1  1 -1  0 -2 -1 -1 -3  1  1  1 -6 -4  0  1  0  0 -9
	// R -1  6  1  0 -4  1  0 -2  2 -2 -3  4  0 -5  0  0  0  3 -4 -2  0  1  0 -9
	// N  0  1  1  2 -4  1  2  1  1 -2 -3  1 -1 -4  0  1  0 -4 -3 -1  2  1  0 -9
	// D  1  0  2  3 -5  2  3  1  1 -2 -4  1 -2 -5  0  1  0 -7 -5 -2  3  3  0 -9
	// C -2 -4 -4 -5 17 -5 -5 -3 -4 -2 -6 -5 -5 -4 -3  0 -2 -9  1 -2 -4 -5 -3 -9
	// Q  0  1  1  2 -5  3  2  0  3 -2 -2  1 -1 -4  0  0  0 -5 -4 -1  2  3  0 -9
	// E  1  0  2  3 -5  2  3  1  1 -2 -3  1 -2 -5  0  0  0 -7 -5 -1  2  3  0 -9
	// G  1 -2  1  1 -3  0  1  5 -1 -2 -4 -1 -2 -5  0  1  1 -7 -5 -1  1  0  0 -9
	// H -1  2  1  1 -4  3  1 -1  6 -2 -2  1 -2 -2  0  0 -1 -3  0 -2  1  2  0 -9
	// I  0 -2 -2 -2 -2 -2 -2 -2 -2  4  3 -2  3  2 -1 -1  0 -5  0  4 -2 -2  0 -9
	// L -2 -3 -3 -4 -6 -2 -3 -4 -2  3  7 -3  4  3 -2 -2 -1 -2  0  3 -3 -2 -1 -9
	// K -1  4  1  1 -5  1  1 -1  1 -2 -3  4  0 -5  0  0  0 -3 -5 -2  1  1  0 -9
	// M -1  0 -1 -2 -5 -1 -2 -2 -2  3  4  0  5  1 -2 -1  0 -4 -1  2 -2 -1  0 -9
	// F -3 -5 -4 -5 -4 -4 -5 -5 -2  2  3 -5  1 12 -5 -3 -3  2 10  0 -5 -5 -2 -9
	// P  1  0  0  0 -3  0  0  0  0 -1 -2  0 -2 -5  5  1  1 -6 -5 -1  0  0  0 -9
	// S  1  0  1  1  0  0  0  1  0 -1 -2  0 -1 -3  1  1  1 -3 -3 -1  1  0  0 -9
	// T  1  0  0  0 -2  0  0  1 -1  0 -1  0  0 -3  1  1  1 -5 -3  0  0  0  0 -9
	// W -6  3 -4 -7 -9 -5 -7 -7 -3 -5 -2 -3 -4  2 -6 -3 -5 26  1 -6 -6 -6 -4 -9
	// Y -4 -4 -3 -5  1 -4 -5 -5  0  0  0 -5 -1 10 -5 -3 -3  1 13 -2 -4 -4 -2 -9
	// V  0 -2 -1 -2 -2 -1 -1 -1 -2  4  3 -2  2  0 -1 -1  0 -6 -2  4 -2 -1  0 -9
	// B  1  0  2  3 -4  2  2  1  1 -2 -3  1 -2 -5  0  1  0 -6 -4 -2  2  2  0 -9
	// Z  0  1  1  3 -5  3  3  0  2 -2 -2  1 -1 -5  0  0  0 -6 -4 -1  2  3  0 -9
	// X  0  0  0  0 -3  0  0  0  0  0 -1  0  0 -2  0  0  0 -4 -2  0  0  0 -1 -9
	// * -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9  1
	//
	PAM390 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 1, 1, -2, 1, 1, -3, 1, -1, 0, 0, -1, -2, -1, 0, 1, 0, -1, 1, 1, 0, -6, 0, -4, 0, -9},
		/* B */ {0, 1, 2, -4, 3, 2, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -2, -6, 0, -4, 2, -9},
		/* C */ {0, -2, -4, 17, -5, -5, -4, -3, -4, -2, 0, -5, -6, -5, -4, -3, -5, -4, 0, -2, -2, -9, -3, 1, -5, -9},
		/* D */ {0, 1, 3, -5, 3, 3, -5, 1, 1, -2, 0, 1, -4, -2, 2, 0, 2, 0, 1, 0, -2, -7, 0, -5, 3, -9},
		/* E */ {0, 1, 2, -5, 3, 3, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 0, 0, -1, -7, 0, -5, 3, -9},
		/* F */ {0, -3, -5, -4, -5, -5, 12, -5, -2, 2, 0, -5, 3, 1, -4, -5, -4, -5, -3, -3, 0, 2, -2, 10, -5, -9},
		/* G */ {0, 1, 1, -3, 1, 1, -5, 5, -1, -2, 0, -1, -4, -2, 1, 0, 0, -2, 1, 1, -1, -7, 0, -5, 0, -9},
		/* H */ {0, -1, 1, -4, 1, 1, -2, -1, 6, -2, 0, 1, -2, -2, 1, 0, 3, 2, 0, -1, -2, -3, 0, 0, 2, -9},
		/* I */ {0, 0, -2, -2, -2, -2, 2, -2, -2, 4, 0, -2, 3, 3, -2, -1, -2, -2, -1, 0, 4, -5, 0, 0, -2, -9},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 1, -5, 1, 1, -5, -1, 1, -2, 0, 4, -3, 0, 1, 0, 1, 4, 0, 0, -2, -3, 0, -5, 1, -9},
		/* L */ {0, -2, -3, -6, -4, -3, 3, -4, -2, 3, 0, -3, 7, 4, -3, -2, -2, -3, -2, -1, 3, -2, -1, 0, -2, -9},
		/* M */ {0, -1, -2, -5, -2, -2, 1, -2, -2, 3, 0, 0, 4, 5, -1, -2, -1, 0, -1, 0, 2, -4, 0, -1, -1, -9},
		/* N */ {0, 0, 2, -4, 2, 2, -4, 1, 1, -2, 0, 1, -3, -1, 1, 0, 1, 1, 1, 0, -1, -4, 0, -3, 1, -9},
		/* P */ {0, 1, 0, -3, 0, 0, -5, 0, 0, -1, 0, 0, -2, -2, 0, 5, 0, 0, 1, 1, -1, -6, 0, -5, 0, -9},
		/* Q */ {0, 0, 2, -5, 2, 2, -4, 0, 3, -2, 0, 1, -2, -1, 1, 0, 3, 1, 0, 0, -1, -5, 0, -4, 3, -9},
		/* R */ {0, -1, 0, -4, 0, 0, -5, -2, 2, -2, 0, 4, -3, 0, 1, 0, 1, 6, 0, 0, -2, 3, 0, -4, 1, -9},
		/* S */ {0, 1, 1, 0, 1, 0, -3, 1, 0, -1, 0, 0, -2, -1, 1, 1, 0, 0, 1, 1, -1, -3, 0, -3, 0, -9},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 1, -1, 0, 0, 0, -1, 0, 0, 1, 0, 0, 1, 1, 0, -5, 0, -3, 0, -9},
		/* V */ {0, 0, -2, -2, -2, -1, 0, -1, -2, 4, 0, -2, 3, 2, -1, -1, -1, -2, -1, 0, 4, -6, 0, -2, -1, -9},
		/* W */ {0, -6, -6, -9, -7, -7, 2, -7, -3, -5, 0, -3, -2, -4, -4, -6, -5, 3, -3, -5, -6, 26, -4, 1, -6, -9},
		/* X */ {0, 0, 0, -3, 0, 0, -2, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -4, -1, -2, 0, -9},
		/* Y */ {0, -4, -4, 1, -5, -5, 10, -5, 0, 0, 0, -5, 0, -1, -3, -5, -4, -4, -3, -3, -2, 1, -2, 13, -4, -9},
		/* Z */ {0, 0, 2, -5, 3, 3, -5, 0, 2, -2, 0, 1, -2, -1, 1, 0, 3, 1, 0, 0, -1, -6, 0, -4, 3, -9},
		/* * */ {0, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 40 substitution matrix, scale = ln(2)/2 = 0.346574
	// #
	// # Expected score = -4.27, Entropy = 2.26 bits
	// #
	// # Lowest score = -15, Highest score = 13
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A   6  -6  -3  -3  -6  -3  -2  -1  -6  -4  -5  -6  -4  -7  -1   0   0 -12  -7  -2  -3  -2  -3 -15
	// R  -6   8  -5  -9  -7  -1  -8  -8  -1  -5  -8   1  -3  -8  -3  -2  -5  -1  -9  -7  -6  -3  -5 -15
	// N  -3  -5   7   2  -9  -3  -1  -2   1  -4  -6   0  -7  -8  -5   0  -1  -7  -4  -7   6  -2  -3 -15
	// D  -3  -9   2   7 -12  -2   3  -3  -3  -6 -11  -4  -9 -13  -7  -3  -4 -13 -10  -7   6   2  -5 -15
	// C  -6  -7  -9 -12   9 -12 -12  -8  -7  -5 -13 -12 -12 -11  -7  -2  -7 -14  -3  -5 -11 -12  -8 -15
	// Q  -3  -1  -3  -2 -12   8   2  -6   1  -7  -4  -2  -3 -11  -2  -4  -5 -11 -10  -6  -2   6  -4 -15
	// E  -2  -8  -1   3 -12   2   7  -3  -4  -5  -8  -4  -6 -12  -5  -4  -5 -15  -8  -6   2   6  -4 -15
	// G  -1  -8  -2  -3  -8  -6  -3   6  -8  -9  -9  -6  -7  -8  -5  -1  -5 -13 -12  -5  -2  -4  -4 -15
	// H  -6  -1   1  -3  -7   1  -4  -8   9  -8  -5  -5  -9  -5  -3  -5  -6  -6  -3  -6  -1   0  -4 -15
	// I  -4  -5  -4  -6  -5  -7  -5  -9  -8   8  -1  -5   0  -2  -7  -6  -2 -12  -5   2  -5  -5  -4 -15
	// L  -5  -8  -6 -11 -13  -4  -8  -9  -5  -1   7  -7   1  -2  -6  -7  -6  -5  -6  -2  -8  -6  -5 -15
	// K  -6   1   0  -4 -12  -2  -4  -6  -5  -5  -7   6  -1 -12  -6  -3  -2 -10  -8  -8  -2  -3  -4 -15
	// M  -4  -3  -7  -9 -12  -3  -6  -7  -9   0   1  -1  11  -3  -7  -5  -3 -11 -10  -1  -8  -4  -4 -15
	// F  -7  -8  -8 -13 -11 -11 -12  -8  -5  -2  -2 -12  -3   9  -9  -6  -8  -4   2  -7  -9 -12  -7 -15
	// P  -1  -3  -5  -7  -7  -2  -5  -5  -3  -7  -6  -6  -7  -9   8  -1  -3 -12 -12  -5  -6  -3  -4 -15
	// S   0  -2   0  -3  -2  -4  -4  -1  -5  -6  -7  -3  -5  -6  -1   6   1  -4  -6  -5  -1  -4  -2 -15
	// T   0  -5  -1  -4  -7  -5  -5  -5  -6  -2  -6  -2  -3  -8  -3   1   7 -11  -6  -2  -2  -5  -3 -15
	// W -12  -1  -7 -13 -14 -11 -15 -13  -6 -12  -5 -10 -11  -4 -12  -4 -11  13  -4 -14  -9 -13  -9 -15
	// Y  -7  -9  -4 -10  -3 -10  -8 -12  -3  -5  -6  -8 -10   2 -12  -6  -6  -4  10  -6  -6  -8  -7 -15
	// V  -2  -7  -7  -7  -5  -6  -6  -5  -6   2  -2  -8  -1  -7  -5  -5  -2 -14  -6   7  -7  -6  -4 -15
	// B  -3  -6   6   6 -11  -2   2  -2  -1  -5  -8  -2  -8  -9  -6  -1  -2  -9  -6  -7   6   1  -4 -15
	// Z  -2  -3  -2   2 -12   6   6  -4   0  -5  -6  -3  -4 -12  -3  -4  -5 -13  -8  -6   1   6  -4 -15
	// X  -3  -5  -3  -5  -8  -4  -4  -4  -4  -4  -5  -4  -4  -7  -4  -2  -3  -9  -7  -4  -4  -4  -4 -15
	// * -15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15 -15   1
	//
	PAM40 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 6, -3, -6, -3, -2, -7, -1, -6, -4, 0, -6, -5, -4, -3, -1, -3, -6, 0, 0, -2, -12, -3, -7, -2, -15},
		/* B */ {0, -3, 6, -11, 6, 2, -9, -2, -1, -5, 0, -2, -8, -8, 6, -6, -2, -6, -1, -2, -7, -9, -4, -6, 1, -15},
		/* C */ {0, -6, -11, 9, -12, -12, -11, -8, -7, -5, 0, -12, -13, -12, -9, -7, -12, -7, -2, -7, -5, -14, -8, -3, -12, -15},
		/* D */ {0, -3, 6, -12, 7, 3, -13, -3, -3, -6, 0, -4, -11, -9, 2, -7, -2, -9, -3, -4, -7, -13, -5, -10, 2, -15},
		/* E */ {0, -2, 2, -12, 3, 7, -12, -3, -4, -5, 0, -4, -8, -6, -1, -5, 2, -8, -4, -5, -6, -15, -4, -8, 6, -15},
		/* F */ {0, -7, -9, -11, -13, -12, 9, -8, -5, -2, 0, -12, -2, -3, -8, -9, -11, -8, -6, -8, -7, -4, -7, 2, -12, -15},
		/* G */ {0, -1, -2, -8, -3, -3, -8, 6, -8, -9, 0, -6, -9, -7, -2, -5, -6, -8, -1, -5, -5, -13, -4, -12, -4, -15},
		/* H */ {0, -6, -1, -7, -3, -4, -5, -8, 9, -8, 0, -5, -5, -9, 1, -3, 1, -1, -5, -6, -6, -6, -4, -3, 0, -15},
		/* I */ {0, -4, -5, -5, -6, -5, -2, -9, -8, 8, 0, -5, -1, 0, -4, -7, -7, -5, -6, -2, 2, -12, -4, -5, -5, -15},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -6, -2, -12, -4, -4, -12, -6, -5, -5, 0, 6, -7, -1, 0, -6, -2, 1, -3, -2, -8, -10, -4, -8, -3, -15},
		/* L */ {0, -5, -8, -13, -11, -8, -2, -9, -5, -1, 0, -7, 7, 1, -6, -6, -4, -8, -7, -6, -2, -5, -5, -6, -6, -15},
		/* M */ {0, -4, -8, -12, -9, -6, -3, -7, -9, 0, 0, -1, 1, 11, -7, -7, -3, -3, -5, -3, -1, -11, -4, -10, -4, -15},
		/* N */ {0, -3, 6, -9, 2, -1, -8, -2, 1, -4, 0, 0, -6, -7, 7, -5, -3, -5, 0, -1, -7, -7, -3, -4, -2, -15},
		/* P */ {0, -1, -6, -7, -7, -5, -9, -5, -3, -7, 0, -6, -6, -7, -5, 8, -2, -3, -1, -3, -5, -12, -4, -12, -3, -15},
		/* Q */ {0, -3, -2, -12, -2, 2, -11, -6, 1, -7, 0, -2, -4, -3, -3, -2, 8, -1, -4, -5, -6, -11, -4, -10, 6, -15},
		/* R */ {0, -6, -6, -7, -9, -8, -8, -8, -1, -5, 0, 1, -8, -3, -5, -3, -1, 8, -2, -5, -7, -1, -5, -9, -3, -15},
		/* S */ {0, 0, -1, -2, -3, -4, -6, -1, -5, -6, 0, -3, -7, -5, 0, -1, -4, -2, 6, 1, -5, -4, -2, -6, -4, -15},
		/* T */ {0, 0, -2, -7, -4, -5, -8, -5, -6, -2, 0, -2, -6, -3, -1, -3, -5, -5, 1, 7, -2, -11, -3, -6, -5, -15},
		/* V */ {0, -2, -7, -5, -7, -6, -7, -5, -6, 2, 0, -8, -2, -1, -7, -5, -6, -7, -5, -2, 7, -14, -4, -6, -6, -15},
		/* W */ {0, -12, -9, -14, -13, -15, -4, -13, -6, -12, 0, -10, -5, -11, -7, -12, -11, -1, -4, -11, -14, 13, -9, -4, -13, -15},
		/* X */ {0, -3, -4, -8, -5, -4, -7, -4, -4, -4, 0, -4, -5, -4, -3, -4, -4, -5, -2, -3, -4, -9, -4, -7, -4, -15},
		/* Y */ {0, -7, -6, -3, -10, -8, 2, -12, -3, -5, 0, -8, -6, -10, -4, -12, -10, -9, -6, -6, -6, -4, -7, 10, -8, -15},
		/* Z */ {0, -2, 1, -12, 2, 6, -12, -4, 0, -5, 0, -3, -6, -4, -2, -3, 6, -3, -4, -5, -6, -13, -4, -8, 6, -15},
		/* * */ {0, -15, -15, -15, -15, -15, -15, -15, -15, -15, 0, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 400 substitution matrix, scale = ln(2)/5 = 0.138629
	// #
	// # Expected score = -0.521, Entropy = 0.139 bits
	// #
	// # Lowest score = -8, Highest score = 26
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  1 -1  0  1 -2  0  1  1 -1  0 -2 -1 -1 -3  1  1  1 -6 -3  0  1  0  0 -8
	// R -1  5  1  0 -4  1  0 -2  2 -2 -3  4  0 -4  0  0  0  3 -4 -2  0  1  0 -8
	// N  0  1  1  2 -3  1  2  1  1 -1 -3  1 -1 -3  0  1  0 -4 -3 -1  2  1  0 -8
	// D  1  0  2  3 -5  2  3  1  1 -2 -3  1 -2 -5  0  1  0 -7 -4 -2  2  2  0 -8
	// C -2 -4 -3 -5 17 -5 -5 -3 -3 -2 -6 -5 -5 -4 -2  0 -2 -8  1 -2 -4 -5 -3 -8
	// Q  0  1  1  2 -5  3  2  0  3 -2 -2  1 -1 -4  0  0  0 -5 -4 -1  2  2  0 -8
	// E  1  0  2  3 -5  2  3  1  1 -2 -3  1 -2 -5  0  0  0 -7 -4 -1  2  3  0 -8
	// G  1 -2  1  1 -3  0  1  4 -1 -2 -3 -1 -2 -5  0  1  1 -7 -5 -1  1  0  0 -8
	// H -1  2  1  1 -3  3  1 -1  5 -2 -2  1 -1 -2  0  0 -1 -2  0 -2  1  2  0 -8
	// I  0 -2 -1 -2 -2 -2 -2 -2 -2  4  3 -2  2  2 -1 -1  0 -5  0  3 -2 -2  0 -8
	// L -2 -3 -3 -3 -6 -2 -3 -3 -2  3  7 -2  4  3 -2 -2 -1 -2  0  3 -3 -2 -1 -8
	// K -1  4  1  1 -5  1  1 -1  1 -2 -2  4  0 -5  0  0  0 -3 -4 -2  1  1  0 -8
	// M -1  0 -1 -2 -5 -1 -2 -2 -1  2  4  0  5  1 -1 -1  0 -4 -1  2 -2 -1  0 -8
	// F -3 -4 -3 -5 -4 -4 -5 -5 -2  2  3 -5  1 11 -4 -3 -3  2 10  0 -4 -5 -2 -8
	// P  1  0  0  0 -2  0  0  0  0 -1 -2  0 -1 -4  5  1  1 -6 -5 -1  0  0  0 -8
	// S  1  0  1  1  0  0  0  1  0 -1 -2  0 -1 -3  1  1  1 -3 -3 -1  1  0  0 -8
	// T  1  0  0  0 -2  0  0  1 -1  0 -1  0  0 -3  1  1  1 -5 -3  0  0  0  0 -8
	// W -6  3 -4 -7 -8 -5 -7 -7 -2 -5 -2 -3 -4  2 -6 -3 -5 26  1 -6 -5 -6 -4 -8
	// Y -3 -4 -3 -4  1 -4 -4 -5  0  0  0 -4 -1 10 -5 -3 -3  1 13 -2 -3 -4 -2 -8
	// V  0 -2 -1 -2 -2 -1 -1 -1 -2  3  3 -2  2  0 -1 -1  0 -6 -2  4 -1 -1  0 -8
	// B  1  0  2  2 -4  2  2  1  1 -2 -3  1 -2 -4  0  1  0 -5 -3 -1  2  2  0 -8
	// Z  0  1  1  2 -5  2  3  0  2 -2 -2  1 -1 -5  0  0  0 -6 -4 -1  2  3  0 -8
	// X  0  0  0  0 -3  0  0  0  0  0 -1  0  0 -2  0  0  0 -4 -2  0  0  0 -1 -8
	// * -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8  1
	//
	PAM400 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 1, 1, -2, 1, 1, -3, 1, -1, 0, 0, -1, -2, -1, 0, 1, 0, -1, 1, 1, 0, -6, 0, -3, 0, -8},
		/* B */ {0, 1, 2, -4, 2, 2, -4, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -1, -5, 0, -3, 2, -8},
		/* C */ {0, -2, -4, 17, -5, -5, -4, -3, -3, -2, 0, -5, -6, -5, -3, -2, -5, -4, 0, -2, -2, -8, -3, 1, -5, -8},
		/* D */ {0, 1, 2, -5, 3, 3, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -2, -7, 0, -4, 2, -8},
		/* E */ {0, 1, 2, -5, 3, 3, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 0, 0, -1, -7, 0, -4, 3, -8},
		/* F */ {0, -3, -4, -4, -5, -5, 11, -5, -2, 2, 0, -5, 3, 1, -3, -4, -4, -4, -3, -3, 0, 2, -2, 10, -5, -8},
		/* G */ {0, 1, 1, -3, 1, 1, -5, 4, -1, -2, 0, -1, -3, -2, 1, 0, 0, -2, 1, 1, -1, -7, 0, -5, 0, -8},
		/* H */ {0, -1, 1, -3, 1, 1, -2, -1, 5, -2, 0, 1, -2, -1, 1, 0, 3, 2, 0, -1, -2, -2, 0, 0, 2, -8},
		/* I */ {0, 0, -2, -2, -2, -2, 2, -2, -2, 4, 0, -2, 3, 2, -1, -1, -2, -2, -1, 0, 3, -5, 0, 0, -2, -8},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 1, -5, 1, 1, -5, -1, 1, -2, 0, 4, -2, 0, 1, 0, 1, 4, 0, 0, -2, -3, 0, -4, 1, -8},
		/* L */ {0, -2, -3, -6, -3, -3, 3, -3, -2, 3, 0, -2, 7, 4, -3, -2, -2, -3, -2, -1, 3, -2, -1, 0, -2, -8},
		/* M */ {0, -1, -2, -5, -2, -2, 1, -2, -1, 2, 0, 0, 4, 5, -1, -1, -1, 0, -1, 0, 2, -4, 0, -1, -1, -8},
		/* N */ {0, 0, 2, -3, 2, 2, -3, 1, 1, -1, 0, 1, -3, -1, 1, 0, 1, 1, 1, 0, -1, -4, 0, -3, 1, -8},
		/* P */ {0, 1, 0, -2, 0, 0, -4, 0, 0, -1, 0, 0, -2, -1, 0, 5, 0, 0, 1, 1, -1, -6, 0, -5, 0, -8},
		/* Q */ {0, 0, 2, -5, 2, 2, -4, 0, 3, -2, 0, 1, -2, -1, 1, 0, 3, 1, 0, 0, -1, -5, 0, -4, 2, -8},
		/* R */ {0, -1, 0, -4, 0, 0, -4, -2, 2, -2, 0, 4, -3, 0, 1, 0, 1, 5, 0, 0, -2, 3, 0, -4, 1, -8},
		/* S */ {0, 1, 1, 0, 1, 0, -3, 1, 0, -1, 0, 0, -2, -1, 1, 1, 0, 0, 1, 1, -1, -3, 0, -3, 0, -8},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 1, -1, 0, 0, 0, -1, 0, 0, 1, 0, 0, 1, 1, 0, -5, 0, -3, 0, -8},
		/* V */ {0, 0, -1, -2, -2, -1, 0, -1, -2, 3, 0, -2, 3, 2, -1, -1, -1, -2, -1, 0, 4, -6, 0, -2, -1, -8},
		/* W */ {0, -6, -5, -8, -7, -7, 2, -7, -2, -5, 0, -3, -2, -4, -4, -6, -5, 3, -3, -5, -6, 26, -4, 1, -6, -8},
		/* X */ {0, 0, 0, -3, 0, 0, -2, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -4, -1, -2, 0, -8},
		/* Y */ {0, -3, -3, 1, -4, -4, 10, -5, 0, 0, 0, -4, 0, -1, -3, -5, -4, -4, -3, -3, -2, 1, -2, 13, -4, -8},
		/* Z */ {0, 0, 2, -5, 2, 3, -5, 0, 2, -2, 0, 1, -2, -1, 1, 0, 2, 1, 0, 0, -1, -6, 0, -4, 3, -8},
		/* * */ {0, -8, -8, -8, -8, -8, -8, -8, -8, -8, 0, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 40 substitution matrix, scale = 0.0693200
	// #
	// # Expected score = -21.3, Entropy = 2.26 bits
	// #
	// # Lowest score = -74, Highest score = 64
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A  28 -30 -14 -13 -28 -17  -8  -5 -31 -19 -27 -29 -20 -37  -4   1   0 -59 -34  -8 -14 -12 -13 -74
	// R -30  41 -23 -43 -35  -5 -38 -41  -4 -23 -38   5 -17 -42 -15 -12 -27  -6 -45 -33 -30 -15 -23 -74
	// N -14 -23  36  10 -47 -14  -7 -12   4 -22 -31  -2 -37 -38 -24   2  -6 -36 -19 -33  28 -10 -14 -74
	// D -13 -43  10  37 -62  -8  15 -13 -15 -32 -54 -18 -47 -64 -33 -14 -19 -67 -49 -35  29   8 -23 -74
	// C -28 -35 -47 -62  47 -61 -62 -41 -33 -27 -66 -62 -59 -56 -35 -11 -34 -70 -16 -25 -53 -62 -39 -74
	// Q -17  -5 -14  -8 -61  40   8 -30   7 -33 -21 -10 -16 -57 -11 -22 -23 -56 -51 -29 -10  30 -19 -74
	// E  -8 -38  -7  15 -62   8  36 -17 -20 -24 -41 -18 -30 -62 -23 -18 -25 -74 -38 -28   8  29 -20 -74
	// G  -5 -41 -12 -13 -41 -30 -17  31 -38 -46 -47 -31 -37 -41 -26  -5 -24 -67 -60 -24 -12 -21 -22 -74
	// H -31  -4   4 -15 -33   7 -20 -38  44 -39 -26 -25 -44 -25 -17 -25 -31 -32 -13 -28  -3  -2 -21 -74
	// I -19 -23 -22 -32 -27 -33 -24 -46 -39  40  -3 -26   0  -8 -37 -29  -9 -60 -26  12 -26 -27 -20 -74
	// L -27 -38 -31 -54 -66 -21 -41 -47 -26  -3  33 -36   6  -9 -31 -36 -29 -26 -29  -8 -39 -29 -26 -74
	// K -29   5  -2 -18 -62 -10 -18 -31 -25 -26 -36  32  -5 -61 -28 -16 -12 -51 -42 -39  -9 -14 -22 -74
	// M -20 -17 -37 -47 -59 -16 -30 -37 -44   0   6  -5  54 -16 -35 -23 -16 -55 -48  -3 -41 -22 -21 -74
	// F -37 -42 -38 -64 -56 -57 -62 -41 -25  -8  -9 -61 -16  43 -44 -28 -38 -18  12 -33 -47 -60 -34 -74
	// P  -4 -15 -24 -33 -35 -11 -23 -26 -17 -37 -31 -28 -35 -44  39  -5 -17 -60 -59 -24 -28 -16 -21 -74
	// S   1 -12   2 -14 -11 -22 -18  -5 -25 -29 -36 -16 -23 -28  -5  30   4 -22 -30 -26  -5 -19 -12 -74
	// T   0 -27  -6 -19 -34 -23 -25 -24 -31  -9 -29 -12 -16 -38 -17   4  34 -56 -28 -10 -12 -24 -15 -74
	// W -59  -6 -36 -67 -70 -56 -74 -67 -32 -60 -26 -51 -55 -18 -60 -22 -56  64 -21 -68 -45 -63 -47 -74
	// Y -34 -45 -19 -49 -16 -51 -38 -60 -13 -26 -29 -42 -48  12 -59 -30 -28 -21  48 -32 -28 -42 -33 -74
	// V  -8 -33 -33 -35 -25 -29 -28 -24 -28  12  -8 -39  -3 -33 -24 -26 -10 -68 -32  34 -34 -28 -19 -74
	// B -14 -30  28  29 -53 -10   8 -12  -3 -26 -39  -9 -41 -47 -28  -5 -12 -45 -28 -34  29   3 -19 -74
	// Z -12 -15 -10   8 -62  30  29 -21  -2 -27 -29 -14 -22 -60 -16 -19 -24 -63 -42 -28   3  30 -20 -74
	// X -13 -23 -14 -23 -39 -19 -20 -22 -21 -20 -26 -22 -21 -34 -21 -12 -15 -47 -33 -19 -19 -20 -21 -74
	// * -74 -74 -74 -74 -74 -74 -74 -74 -74 -74 -74 -74 -74 -74 -74 -74 -74 -74 -74 -74 -74 -74 -74   1
	//
	PAM40_cdi = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 28, -14, -28, -13, -8, -37, -5, -31, -19, 0, -29, -27, -20, -14, -4, -17, -30, 1, 0, -8, -59, -13, -34, -12, -74},
		/* B */ {0, -14, 29, -53, 29, 8, -47, -12, -3, -26, 0, -9, -39, -41, 28, -28, -10, -30, -5, -12, -34, -45, -19, -28, 3, -74},
		/* C */ {0, -28, -53, 47, -62, -62, -56, -41, -33, -27, 0, -62, -66, -59, -47, -35, -61, -35, -11, -34, -25, -70, -39, -16, -62, -74},
		/* D */ {0, -13, 29, -62, 37, 15, -64, -13, -15, -32, 0, -18, -54, -47, 10, -33, -8, -43, -14, -19, -35, -67, -23, -49, 8, -74},
		/* E */ {0, -8, 8, -62, 15, 36, -62, -17, -20, -24, 0, -18, -41, -30, -7, -23, 8, -38, -18, -25, -28, -74, -20, -38, 29, -74},
		/* F */ {0, -37, -47, -56, -64, -62, 43, -41, -25, -8, 0, -61, -9, -16, -38, -44, -57, -42, -28, -38, -33, -18, -34, 12, -60, -74},
		/* G */ {0, -5, -12, -41, -13, -17, -41, 31, -38, -46, 0, -31, -47, -37, -12, -26, -30, -41, -5, -24, -24, -67, -22, -60, -21, -74},
		/* H */ {0, -31, -3, -33, -15, -20, -25, -38, 44, -39, 0, -25, -26, -44, 4, -17, 7, -4, -25, -31, -28, -32, -21, -13, -2, -74},
		/* I */ {0, -19, -26, -27, -32, -24, -8, -46, -39, 40, 0, -26, -3, 0, -22, -37, -33, -23, -29, -9, 12, -60, -20, -26, -27, -74},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -29, -9, -62, -18, -18, -61, -31, -25, -26, 0, 32, -36, -5, -2, -28, -10, 5, -16, -12, -39, -51, -22, -42, -14, -74},
		/* L */ {0, -27, -39, -66, -54, -41, -9, -47, -26, -3, 0, -36, 33, 6, -31, -31, -21, -38, -36, -29, -8, -26, -26, -29, -29, -74},
		/* M */ {0, -20, -41, -59, -47, -30, -16, -37, -44, 0, 0, -5, 6, 54, -37, -35, -16, -17, -23, -16, -3, -55, -21, -48, -22, -74},
		/* N */ {0, -14, 28, -47, 10, -7, -38, -12, 4, -22, 0, -2, -31, -37, 36, -24, -14, -23, 2, -6, -33, -36, -14, -19, -10, -74},
		/* P */ {0, -4, -28, -35, -33, -23, -44, -26, -17, -37, 0, -28, -31, -35, -24, 39, -11, -15, -5, -17, -24, -60, -21, -59, -16, -74},
		/* Q */ {0, -17, -10, -61, -8, 8, -57, -30, 7, -33, 0, -10, -21, -16, -14, -11, 40, -5, -22, -23, -29, -56, -19, -51, 30, -74},
		/* R */ {0, -30, -30, -35, -43, -38, -42, -41, -4, -23, 0, 5, -38, -17, -23, -15, -5, 41, -12, -27, -33, -6, -23, -45, -15, -74},
		/* S */ {0, 1, -5, -11, -14, -18, -28, -5, -25, -29, 0, -16, -36, -23, 2, -5, -22, -12, 30, 4, -26, -22, -12, -30, -19, -74},
		/* T */ {0, 0, -12, -34, -19, -25, -38, -24, -31, -9, 0, -12, -29, -16, -6, -17, -23, -27, 4, 34, -10, -56, -15, -28, -24, -74},
		/* V */ {0, -8, -34, -25, -35, -28, -33, -24, -28, 12, 0, -39, -8, -3, -33, -24, -29, -33, -26, -10, 34, -68, -19, -32, -28, -74},
		/* W */ {0, -59, -45, -70, -67, -74, -18, -67, -32, -60, 0, -51, -26, -55, -36, -60, -56, -6, -22, -56, -68, 64, -47, -21, -63, -74},
		/* X */ {0, -13, -19, -39, -23, -20, -34, -22, -21, -20, 0, -22, -26, -21, -14, -21, -19, -23, -12, -15, -19, -47, -21, -33, -20, -74},
		/* Y */ {0, -34, -28, -16, -49, -38, 12, -60, -13, -26, 0, -42, -29, -48, -19, -59, -51, -45, -30, -28, -32, -21, -33, 48, -42, -74},
		/* Z */ {0, -12, 3, -62, 8, 29, -60, -21, -2, -27, 0, -14, -29, -22, -10, -16, 30, -15, -19, -24, -28, -63, -20, -42, 30, -74},
		/* * */ {0, -74, -74, -74, -74, -74, -74, -74, -74, -74, 0, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, -74, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 410 substitution matrix, scale = ln(2)/6 = 0.115525
	// #
	// # Expected score = -0.617, Entropy = 0.131 bits
	// #
	// # Lowest score = -10, Highest score = 31
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A   1  -1   0   1  -2   0   1   2  -1   0  -2  -1  -1  -4   1   1   1  -7  -4   0   1   0   0 -10
	// R  -1   6   1   0  -4   2   0  -2   2  -2  -3   4   0  -5   0   0   0   4  -5  -2   0   1   0 -10
	// N   0   1   1   2  -4   1   2   1   1  -2  -3   1  -2  -4   0   1   1  -5  -3  -1   2   2   0 -10
	// D   1   0   2   3  -6   2   3   1   1  -2  -4   1  -2  -6   0   1   0  -8  -5  -2   3   3   0 -10
	// C  -2  -4  -4  -6  20  -6  -6  -4  -4  -3  -7  -6  -6  -4  -3   0  -2 -10   1  -2  -5  -6  -3 -10
	// Q   0   2   1   2  -6   3   2   0   3  -2  -2   1  -1  -5   1   0   0  -5  -4  -2   2   3   0 -10
	// E   1   0   2   3  -6   2   3   1   1  -2  -3   1  -2  -6   0   1   0  -8  -5  -2   3   3   0 -10
	// G   2  -2   1   1  -4   0   1   5  -1  -2  -4  -1  -3  -6   0   1   1  -8  -6  -1   1   0   0 -10
	// H  -1   2   1   1  -4   3   1  -1   6  -2  -2   1  -2  -2   0   0  -1  -3   0  -2   1   2   0 -10
	// I   0  -2  -2  -2  -3  -2  -2  -2  -2   4   4  -2   3   2  -2  -1   0  -6   0   4  -2  -2   0 -10
	// L  -2  -3  -3  -4  -7  -2  -3  -4  -2   4   8  -3   5   4  -3  -3  -1  -2   1   3  -3  -3  -1 -10
	// K  -1   4   1   1  -6   1   1  -1   1  -2  -3   5   0  -6   0   0   0  -3  -5  -2   1   1   0 -10
	// M  -1   0  -2  -2  -6  -1  -2  -3  -2   3   5   0   5   1  -2  -1   0  -4  -2   2  -2  -2   0 -10
	// F  -4  -5  -4  -6  -4  -5  -6  -6  -2   2   4  -6   1  14  -5  -4  -3   2  12   0  -5  -5  -2 -10
	// P   1   0   0   0  -3   1   0   0   0  -2  -3   0  -2  -5   6   1   1  -7  -5  -1   0   0   0 -10
	// S   1   0   1   1   0   0   1   1   0  -1  -3   0  -1  -4   1   1   1  -3  -3  -1   1   0   0 -10
	// T   1   0   1   0  -2   0   0   1  -1   0  -1   0   0  -3   1   1   2  -6  -3   0   0   0   0 -10
	// W  -7   4  -5  -8 -10  -5  -8  -8  -3  -6  -2  -3  -4   2  -7  -3  -6  31   2  -7  -6  -7  -4 -10
	// Y  -4  -5  -3  -5   1  -4  -5  -6   0   0   1  -5  -2  12  -5  -3  -3   2  15  -2  -4  -5  -2 -10
	// V   0  -2  -1  -2  -2  -2  -2  -1  -2   4   3  -2   2   0  -1  -1   0  -7  -2   4  -2  -2   0 -10
	// B   1   0   2   3  -5   2   3   1   1  -2  -3   1  -2  -5   0   1   0  -6  -4  -2   2   2   0 -10
	// Z   0   1   2   3  -6   3   3   0   2  -2  -3   1  -2  -5   0   0   0  -7  -5  -2   2   3   0 -10
	// X   0   0   0   0  -3   0   0   0   0   0  -1   0   0  -2   0   0   0  -4  -2   0   0   0  -1 -10
	// * -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10   1
	//
	PAM410 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 1, 1, -2, 1, 1, -4, 2, -1, 0, 0, -1, -2, -1, 0, 1, 0, -1, 1, 1, 0, -7, 0, -4, 0, -10},
		/* B */ {0, 1, 2, -5, 3, 3, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -2, -6, 0, -4, 2, -10},
		/* C */ {0, -2, -5, 20, -6, -6, -4, -4, -4, -3, 0, -6, -7, -6, -4, -3, -6, -4, 0, -2, -2, -10, -3, 1, -6, -10},
		/* D */ {0, 1, 3, -6, 3, 3, -6, 1, 1, -2, 0, 1, -4, -2, 2, 0, 2, 0, 1, 0, -2, -8, 0, -5, 3, -10},
		/* E */ {0, 1, 3, -6, 3, 3, -6, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -2, -8, 0, -5, 3, -10},
		/* F */ {0, -4, -5, -4, -6, -6, 14, -6, -2, 2, 0, -6, 4, 1, -4, -5, -5, -5, -4, -3, 0, 2, -2, 12, -5, -10},
		/* G */ {0, 2, 1, -4, 1, 1, -6, 5, -1, -2, 0, -1, -4, -3, 1, 0, 0, -2, 1, 1, -1, -8, 0, -6, 0, -10},
		/* H */ {0, -1, 1, -4, 1, 1, -2, -1, 6, -2, 0, 1, -2, -2, 1, 0, 3, 2, 0, -1, -2, -3, 0, 0, 2, -10},
		/* I */ {0, 0, -2, -3, -2, -2, 2, -2, -2, 4, 0, -2, 4, 3, -2, -2, -2, -2, -1, 0, 4, -6, 0, 0, -2, -10},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -1, 1, -6, 1, 1, -6, -1, 1, -2, 0, 5, -3, 0, 1, 0, 1, 4, 0, 0, -2, -3, 0, -5, 1, -10},
		/* L */ {0, -2, -3, -7, -4, -3, 4, -4, -2, 4, 0, -3, 8, 5, -3, -3, -2, -3, -3, -1, 3, -2, -1, 1, -3, -10},
		/* M */ {0, -1, -2, -6, -2, -2, 1, -3, -2, 3, 0, 0, 5, 5, -2, -2, -1, 0, -1, 0, 2, -4, 0, -2, -2, -10},
		/* N */ {0, 0, 2, -4, 2, 2, -4, 1, 1, -2, 0, 1, -3, -2, 1, 0, 1, 1, 1, 1, -1, -5, 0, -3, 2, -10},
		/* P */ {0, 1, 0, -3, 0, 0, -5, 0, 0, -2, 0, 0, -3, -2, 0, 6, 1, 0, 1, 1, -1, -7, 0, -5, 0, -10},
		/* Q */ {0, 0, 2, -6, 2, 2, -5, 0, 3, -2, 0, 1, -2, -1, 1, 1, 3, 2, 0, 0, -2, -5, 0, -4, 3, -10},
		/* R */ {0, -1, 0, -4, 0, 0, -5, -2, 2, -2, 0, 4, -3, 0, 1, 0, 2, 6, 0, 0, -2, 4, 0, -5, 1, -10},
		/* S */ {0, 1, 1, 0, 1, 1, -4, 1, 0, -1, 0, 0, -3, -1, 1, 1, 0, 0, 1, 1, -1, -3, 0, -3, 0, -10},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 1, -1, 0, 0, 0, -1, 0, 1, 1, 0, 0, 1, 2, 0, -6, 0, -3, 0, -10},
		/* V */ {0, 0, -2, -2, -2, -2, 0, -1, -2, 4, 0, -2, 3, 2, -1, -1, -2, -2, -1, 0, 4, -7, 0, -2, -2, -10},
		/* W */ {0, -7, -6, -10, -8, -8, 2, -8, -3, -6, 0, -3, -2, -4, -5, -7, -5, 4, -3, -6, -7, 31, -4, 2, -7, -10},
		/* X */ {0, 0, 0, -3, 0, 0, -2, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -4, -1, -2, 0, -10},
		/* Y */ {0, -4, -4, 1, -5, -5, 12, -6, 0, 0, 0, -5, 1, -2, -3, -5, -4, -5, -3, -3, -2, 2, -2, 15, -5, -10},
		/* Z */ {0, 0, 2, -6, 3, 3, -5, 0, 2, -2, 0, 1, -3, -2, 2, 0, 3, 1, 0, 0, -2, -7, 0, -5, 3, -10},
		/* * */ {0, -10, -10, -10, -10, -10, -10, -10, -10, -10, 0, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 420 substitution matrix, scale = ln(2)/6 = 0.115525
	// #
	// # Expected score = -0.599, Entropy = 0.124 bits
	// #
	// # Lowest score = -10, Highest score = 31
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A   1  -1   0   1  -2   0   1   2  -1   0  -2   0  -1  -4   1   1   1  -7  -4   0   1   0   0 -10
	// R  -1   6   1   0  -4   2   0  -2   2  -2  -3   4   0  -5   0   0   0   4  -5  -2   0   1   0 -10
	// N   0   1   1   2  -4   1   2   1   1  -2  -3   1  -1  -4   0   1   0  -5  -3  -1   2   2   0 -10
	// D   1   0   2   3  -5   2   3   1   1  -2  -4   1  -2  -6   0   1   0  -8  -5  -2   3   3   0 -10
	// C  -2  -4  -4  -5  20  -6  -6  -3  -4  -3  -7  -6  -6  -4  -3   0  -2 -10   1  -2  -5  -6  -3 -10
	// Q   0   2   1   2  -6   3   2   0   3  -2  -2   1  -1  -5   1   0   0  -5  -4  -2   2   3   0 -10
	// E   1   0   2   3  -6   2   3   1   1  -2  -3   1  -2  -6   0   1   0  -8  -5  -2   3   3   0 -10
	// G   2  -2   1   1  -3   0   1   5  -1  -2  -4  -1  -2  -6   0   1   1  -8  -6  -1   1   0   0 -10
	// H  -1   2   1   1  -4   3   1  -1   6  -2  -2   1  -2  -2   0   0  -1  -3   0  -2   1   2   0 -10
	// I   0  -2  -2  -2  -3  -2  -2  -2  -2   4   4  -2   3   2  -2  -1   0  -6   0   4  -2  -2   0 -10
	// L  -2  -3  -3  -4  -7  -2  -3  -4  -2   4   7  -3   5   4  -2  -3  -1  -2   1   3  -3  -3  -1 -10
	// K   0   4   1   1  -6   1   1  -1   1  -2  -3   5   0  -6   0   0   0  -3  -5  -2   1   1   0 -10
	// M  -1   0  -1  -2  -6  -1  -2  -2  -2   3   5   0   5   1  -2  -1   0  -4  -1   2  -2  -1   0 -10
	// F  -4  -5  -4  -6  -4  -5  -6  -6  -2   2   4  -6   1  13  -5  -4  -3   2  12   0  -5  -5  -2 -10
	// P   1   0   0   0  -3   1   0   0   0  -2  -2   0  -2  -5   5   1   1  -6  -5  -1   0   0   0 -10
	// S   1   0   1   1   0   0   1   1   0  -1  -3   0  -1  -4   1   1   1  -3  -3  -1   1   0   0 -10
	// T   1   0   0   0  -2   0   0   1  -1   0  -1   0   0  -3   1   1   1  -6  -3   0   0   0   0 -10
	// W  -7   4  -5  -8 -10  -5  -8  -8  -3  -6  -2  -3  -4   2  -6  -3  -6  31   2  -7  -6  -7  -4 -10
	// Y  -4  -5  -3  -5   1  -4  -5  -6   0   0   1  -5  -1  12  -5  -3  -3   2  15  -2  -4  -5  -2 -10
	// V   0  -2  -1  -2  -2  -2  -2  -1  -2   4   3  -2   2   0  -1  -1   0  -7  -2   4  -2  -2   0 -10
	// B   1   0   2   3  -5   2   3   1   1  -2  -3   1  -2  -5   0   1   0  -6  -4  -2   2   2   0 -10
	// Z   0   1   2   3  -6   3   3   0   2  -2  -3   1  -1  -5   0   0   0  -7  -5  -2   2   3   0 -10
	// X   0   0   0   0  -3   0   0   0   0   0  -1   0   0  -2   0   0   0  -4  -2   0   0   0  -1 -10
	// * -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10   1
	//
	PAM420 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 1, 1, -2, 1, 1, -4, 2, -1, 0, 0, 0, -2, -1, 0, 1, 0, -1, 1, 1, 0, -7, 0, -4, 0, -10},
		/* B */ {0, 1, 2, -5, 3, 3, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -2, -6, 0, -4, 2, -10},
		/* C */ {0, -2, -5, 20, -5, -6, -4, -3, -4, -3, 0, -6, -7, -6, -4, -3, -6, -4, 0, -2, -2, -10, -3, 1, -6, -10},
		/* D */ {0, 1, 3, -5, 3, 3, -6, 1, 1, -2, 0, 1, -4, -2, 2, 0, 2, 0, 1, 0, -2, -8, 0, -5, 3, -10},
		/* E */ {0, 1, 3, -6, 3, 3, -6, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -2, -8, 0, -5, 3, -10},
		/* F */ {0, -4, -5, -4, -6, -6, 13, -6, -2, 2, 0, -6, 4, 1, -4, -5, -5, -5, -4, -3, 0, 2, -2, 12, -5, -10},
		/* G */ {0, 2, 1, -3, 1, 1, -6, 5, -1, -2, 0, -1, -4, -2, 1, 0, 0, -2, 1, 1, -1, -8, 0, -6, 0, -10},
		/* H */ {0, -1, 1, -4, 1, 1, -2, -1, 6, -2, 0, 1, -2, -2, 1, 0, 3, 2, 0, -1, -2, -3, 0, 0, 2, -10},
		/* I */ {0, 0, -2, -3, -2, -2, 2, -2, -2, 4, 0, -2, 4, 3, -2, -2, -2, -2, -1, 0, 4, -6, 0, 0, -2, -10},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, 0, 1, -6, 1, 1, -6, -1, 1, -2, 0, 5, -3, 0, 1, 0, 1, 4, 0, 0, -2, -3, 0, -5, 1, -10},
		/* L */ {0, -2, -3, -7, -4, -3, 4, -4, -2, 4, 0, -3, 7, 5, -3, -2, -2, -3, -3, -1, 3, -2, -1, 1, -3, -10},
		/* M */ {0, -1, -2, -6, -2, -2, 1, -2, -2, 3, 0, 0, 5, 5, -1, -2, -1, 0, -1, 0, 2, -4, 0, -1, -1, -10},
		/* N */ {0, 0, 2, -4, 2, 2, -4, 1, 1, -2, 0, 1, -3, -1, 1, 0, 1, 1, 1, 0, -1, -5, 0, -3, 2, -10},
		/* P */ {0, 1, 0, -3, 0, 0, -5, 0, 0, -2, 0, 0, -2, -2, 0, 5, 1, 0, 1, 1, -1, -6, 0, -5, 0, -10},
		/* Q */ {0, 0, 2, -6, 2, 2, -5, 0, 3, -2, 0, 1, -2, -1, 1, 1, 3, 2, 0, 0, -2, -5, 0, -4, 3, -10},
		/* R */ {0, -1, 0, -4, 0, 0, -5, -2, 2, -2, 0, 4, -3, 0, 1, 0, 2, 6, 0, 0, -2, 4, 0, -5, 1, -10},
		/* S */ {0, 1, 1, 0, 1, 1, -4, 1, 0, -1, 0, 0, -3, -1, 1, 1, 0, 0, 1, 1, -1, -3, 0, -3, 0, -10},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 1, -1, 0, 0, 0, -1, 0, 0, 1, 0, 0, 1, 1, 0, -6, 0, -3, 0, -10},
		/* V */ {0, 0, -2, -2, -2, -2, 0, -1, -2, 4, 0, -2, 3, 2, -1, -1, -2, -2, -1, 0, 4, -7, 0, -2, -2, -10},
		/* W */ {0, -7, -6, -10, -8, -8, 2, -8, -3, -6, 0, -3, -2, -4, -5, -6, -5, 4, -3, -6, -7, 31, -4, 2, -7, -10},
		/* X */ {0, 0, 0, -3, 0, 0, -2, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -4, -1, -2, 0, -10},
		/* Y */ {0, -4, -4, 1, -5, -5, 12, -6, 0, 0, 0, -5, 1, -1, -3, -5, -4, -5, -3, -3, -2, 2, -2, 15, -5, -10},
		/* Z */ {0, 0, 2, -6, 3, 3, -5, 0, 2, -2, 0, 1, -3, -1, 2, 0, 3, 1, 0, 0, -2, -7, 0, -5, 3, -10},
		/* * */ {0, -10, -10, -10, -10, -10, -10, -10, -10, -10, 0, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 430 substitution matrix, scale = ln(2)/6 = 0.115525
	// #
	// # Expected score = -0.543, Entropy = 0.117 bits
	// #
	// # Lowest score = -9, Highest score = 31
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  1 -1  0  1 -2  0  1  2 -1  0 -2  0 -1 -4  1  1  1 -7 -4  0  1  0  0 -9
	// R -1  6  1  0 -4  2  0 -2  2 -2 -3  4  0 -5  0  0  0  4 -4 -2  0  1  0 -9
	// N  0  1  1  2 -4  1  2  1  1 -2 -3  1 -1 -4  0  1  0 -5 -3 -1  2  1  0 -9
	// D  1  0  2  3 -5  2  3  1  1 -2 -4  1 -2 -6  0  1  0 -7 -5 -2  3  3  0 -9
	// C -2 -4 -4 -5 20 -6 -5 -3 -4 -2 -6 -6 -5 -4 -3  0 -2 -9  1 -2 -4 -5 -3 -9
	// Q  0  2  1  2 -6  3  2  0  3 -2 -2  1 -1 -5  1  0  0 -5 -4 -1  2  3  0 -9
	// E  1  0  2  3 -5  2  3  1  1 -2 -3  1 -2 -6  0  1  0 -8 -5 -1  2  3  0 -9
	// G  2 -2  1  1 -3  0  1  5 -1 -2 -4 -1 -2 -5  0  1  1 -8 -5 -1  1  0  0 -9
	// H -1  2  1  1 -4  3  1 -1  5 -2 -2  1 -1 -2  0  0 -1 -3  0 -2  1  2  0 -9
	// I  0 -2 -2 -2 -2 -2 -2 -2 -2  4  4 -2  3  2 -1 -1  0 -5  0  4 -2 -2  0 -9
	// L -2 -3 -3 -4 -6 -2 -3 -4 -2  4  7 -3  5  4 -2 -2 -1 -2  1  3 -3 -3 -1 -9
	// K  0  4  1  1 -6  1  1 -1  1 -2 -3  4  0 -5  0  0  0 -3 -5 -2  1  1  0 -9
	// M -1  0 -1 -2 -5 -1 -2 -2 -1  3  5  0  5  1 -2 -1  0 -4 -1  2 -2 -1  0 -9
	// F -4 -5 -4 -6 -4 -5 -6 -5 -2  2  4 -5  1 13 -5 -4 -3  2 12  0 -5 -5 -2 -9
	// P  1  0  0  0 -3  1  0  0  0 -1 -2  0 -2 -5  5  1  1 -6 -5 -1  0  0  0 -9
	// S  1  0  1  1  0  0  1  1  0 -1 -2  0 -1 -4  1  1  1 -3 -3 -1  1  0  0 -9
	// T  1  0  0  0 -2  0  0  1 -1  0 -1  0  0 -3  1  1  1 -6 -3  0  0  0  0 -9
	// W -7  4 -5 -7 -9 -5 -8 -8 -3 -5 -2 -3 -4  2 -6 -3 -6 31  2 -7 -6 -6 -4 -9
	// Y -4 -4 -3 -5  1 -4 -5 -5  0  0  1 -5 -1 12 -5 -3 -3  2 15 -2 -4 -5 -2 -9
	// V  0 -2 -1 -2 -2 -1 -1 -1 -2  4  3 -2  2  0 -1 -1  0 -7 -2  4 -1 -1  0 -9
	// B  1  0  2  3 -4  2  2  1  1 -2 -3  1 -2 -5  0  1  0 -6 -4 -1  2  2  0 -9
	// Z  0  1  1  3 -5  3  3  0  2 -2 -3  1 -1 -5  0  0  0 -6 -5 -1  2  3  0 -9
	// X  0  0  0  0 -3  0  0  0  0  0 -1  0  0 -2  0  0  0 -4 -2  0  0  0 -1 -9
	// * -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9  1
	//
	PAM430 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 1, 1, -2, 1, 1, -4, 2, -1, 0, 0, 0, -2, -1, 0, 1, 0, -1, 1, 1, 0, -7, 0, -4, 0, -9},
		/* B */ {0, 1, 2, -4, 3, 2, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -1, -6, 0, -4, 2, -9},
		/* C */ {0, -2, -4, 20, -5, -5, -4, -3, -4, -2, 0, -6, -6, -5, -4, -3, -6, -4, 0, -2, -2, -9, -3, 1, -5, -9},
		/* D */ {0, 1, 3, -5, 3, 3, -6, 1, 1, -2, 0, 1, -4, -2, 2, 0, 2, 0, 1, 0, -2, -7, 0, -5, 3, -9},
		/* E */ {0, 1, 2, -5, 3, 3, -6, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -1, -8, 0, -5, 3, -9},
		/* F */ {0, -4, -5, -4, -6, -6, 13, -5, -2, 2, 0, -5, 4, 1, -4, -5, -5, -5, -4, -3, 0, 2, -2, 12, -5, -9},
		/* G */ {0, 2, 1, -3, 1, 1, -5, 5, -1, -2, 0, -1, -4, -2, 1, 0, 0, -2, 1, 1, -1, -8, 0, -5, 0, -9},
		/* H */ {0, -1, 1, -4, 1, 1, -2, -1, 5, -2, 0, 1, -2, -1, 1, 0, 3, 2, 0, -1, -2, -3, 0, 0, 2, -9},
		/* I */ {0, 0, -2, -2, -2, -2, 2, -2, -2, 4, 0, -2, 4, 3, -2, -1, -2, -2, -1, 0, 4, -5, 0, 0, -2, -9},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, 0, 1, -6, 1, 1, -5, -1, 1, -2, 0, 4, -3, 0, 1, 0, 1, 4, 0, 0, -2, -3, 0, -5, 1, -9},
		/* L */ {0, -2, -3, -6, -4, -3, 4, -4, -2, 4, 0, -3, 7, 5, -3, -2, -2, -3, -2, -1, 3, -2, -1, 1, -3, -9},
		/* M */ {0, -1, -2, -5, -2, -2, 1, -2, -1, 3, 0, 0, 5, 5, -1, -2, -1, 0, -1, 0, 2, -4, 0, -1, -1, -9},
		/* N */ {0, 0, 2, -4, 2, 2, -4, 1, 1, -2, 0, 1, -3, -1, 1, 0, 1, 1, 1, 0, -1, -5, 0, -3, 1, -9},
		/* P */ {0, 1, 0, -3, 0, 0, -5, 0, 0, -1, 0, 0, -2, -2, 0, 5, 1, 0, 1, 1, -1, -6, 0, -5, 0, -9},
		/* Q */ {0, 0, 2, -6, 2, 2, -5, 0, 3, -2, 0, 1, -2, -1, 1, 1, 3, 2, 0, 0, -1, -5, 0, -4, 3, -9},
		/* R */ {0, -1, 0, -4, 0, 0, -5, -2, 2, -2, 0, 4, -3, 0, 1, 0, 2, 6, 0, 0, -2, 4, 0, -4, 1, -9},
		/* S */ {0, 1, 1, 0, 1, 1, -4, 1, 0, -1, 0, 0, -2, -1, 1, 1, 0, 0, 1, 1, -1, -3, 0, -3, 0, -9},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 1, -1, 0, 0, 0, -1, 0, 0, 1, 0, 0, 1, 1, 0, -6, 0, -3, 0, -9},
		/* V */ {0, 0, -1, -2, -2, -1, 0, -1, -2, 4, 0, -2, 3, 2, -1, -1, -1, -2, -1, 0, 4, -7, 0, -2, -1, -9},
		/* W */ {0, -7, -6, -9, -7, -8, 2, -8, -3, -5, 0, -3, -2, -4, -5, -6, -5, 4, -3, -6, -7, 31, -4, 2, -6, -9},
		/* X */ {0, 0, 0, -3, 0, 0, -2, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -4, -1, -2, 0, -9},
		/* Y */ {0, -4, -4, 1, -5, -5, 12, -5, 0, 0, 0, -5, 1, -1, -3, -5, -4, -4, -3, -3, -2, 2, -2, 15, -5, -9},
		/* Z */ {0, 0, 2, -5, 3, 3, -5, 0, 2, -2, 0, 1, -3, -1, 1, 0, 3, 1, 0, 0, -1, -6, 0, -5, 3, -9},
		/* * */ {0, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 440 substitution matrix, scale = ln(2)/6 = 0.115525
	// #
	// # Expected score = -0.529, Entropy = 0.111 bits
	// #
	// # Lowest score = -9, Highest score = 30
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  1 -1  0  1 -2  0  1  2 -1  0 -2  0 -1 -4  1  1  1 -6 -4  0  1  0  0 -9
	// R -1  5  1  0 -4  2  0 -2  2 -2 -3  4  0 -5  0  0  0  4 -4 -2  0  1  0 -9
	// N  0  1  1  2 -4  1  2  1  1 -2 -3  1 -1 -4  0  1  0 -5 -3 -1  2  1  0 -9
	// D  1  0  2  3 -5  2  3  1  1 -2 -3  1 -2 -6  0  1  0 -7 -5 -2  2  2  0 -9
	// C -2 -4 -4 -5 20 -5 -5 -3 -4 -2 -6 -5 -5 -4 -3  0 -2 -9  1 -2 -4 -5 -3 -9
	// Q  0  2  1  2 -5  3  2  0  3 -2 -2  1 -1 -4  1  0  0 -5 -4 -1  2  2  0 -9
	// E  1  0  2  3 -5  2  3  1  1 -2 -3  1 -2 -5  0  1  0 -7 -5 -1  2  3  0 -9
	// G  2 -2  1  1 -3  0  1  4 -1 -2 -4 -1 -2 -5  0  1  1 -8 -5 -1  1  0  0 -9
	// H -1  2  1  1 -4  3  1 -1  5 -2 -2  1 -1 -2  0  0 -1 -3  0 -2  1  2  0 -9
	// I  0 -2 -2 -2 -2 -2 -2 -2 -2  4  4 -2  3  2 -1 -1  0 -5  0  3 -2 -2  0 -9
	// L -2 -3 -3 -3 -6 -2 -3 -4 -2  4  7 -3  5  4 -2 -2 -1 -2  1  3 -3 -2 -1 -9
	// K  0  4  1  1 -5  1  1 -1  1 -2 -3  4  0 -5  0  0  0 -3 -5 -2  1  1  0 -9
	// M -1  0 -1 -2 -5 -1 -2 -2 -1  3  5  0  4  1 -1 -1  0 -4 -1  2 -2 -1  0 -9
	// F -4 -5 -4 -6 -4 -4 -5 -5 -2  2  4 -5  1 13 -5 -4 -3  2 12  0 -5 -5 -2 -9
	// P  1  0  0  0 -3  1  0  0  0 -1 -2  0 -1 -5  5  1  1 -6 -5 -1  0  0  0 -9
	// S  1  0  1  1  0  0  1  1  0 -1 -2  0 -1 -4  1  1  1 -3 -3 -1  1  0  0 -9
	// T  1  0  0  0 -2  0  0  1 -1  0 -1  0  0 -3  1  1  1 -6 -3  0  0  0  0 -9
	// W -6  4 -5 -7 -9 -5 -7 -8 -3 -5 -2 -3 -4  2 -6 -3 -6 30  2 -6 -6 -6 -4 -9
	// Y -4 -4 -3 -5  1 -4 -5 -5  0  0  1 -5 -1 12 -5 -3 -3  2 15 -2 -4 -4 -2 -9
	// V  0 -2 -1 -2 -2 -1 -1 -1 -2  3  3 -2  2  0 -1 -1  0 -6 -2  4 -1 -1  0 -9
	// B  1  0  2  2 -4  2  2  1  1 -2 -3  1 -2 -5  0  1  0 -6 -4 -1  2  2  0 -9
	// Z  0  1  1  2 -5  2  3  0  2 -2 -2  1 -1 -5  0  0  0 -6 -4 -1  2  3  0 -9
	// X  0  0  0  0 -3  0  0  0  0  0 -1  0  0 -2  0  0  0 -4 -2  0  0  0 -1 -9
	// * -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9  1
	//
	PAM440 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 1, 1, -2, 1, 1, -4, 2, -1, 0, 0, 0, -2, -1, 0, 1, 0, -1, 1, 1, 0, -6, 0, -4, 0, -9},
		/* B */ {0, 1, 2, -4, 2, 2, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -1, -6, 0, -4, 2, -9},
		/* C */ {0, -2, -4, 20, -5, -5, -4, -3, -4, -2, 0, -5, -6, -5, -4, -3, -5, -4, 0, -2, -2, -9, -3, 1, -5, -9},
		/* D */ {0, 1, 2, -5, 3, 3, -6, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -2, -7, 0, -5, 2, -9},
		/* E */ {0, 1, 2, -5, 3, 3, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -1, -7, 0, -5, 3, -9},
		/* F */ {0, -4, -5, -4, -6, -5, 13, -5, -2, 2, 0, -5, 4, 1, -4, -5, -4, -5, -4, -3, 0, 2, -2, 12, -5, -9},
		/* G */ {0, 2, 1, -3, 1, 1, -5, 4, -1, -2, 0, -1, -4, -2, 1, 0, 0, -2, 1, 1, -1, -8, 0, -5, 0, -9},
		/* H */ {0, -1, 1, -4, 1, 1, -2, -1, 5, -2, 0, 1, -2, -1, 1, 0, 3, 2, 0, -1, -2, -3, 0, 0, 2, -9},
		/* I */ {0, 0, -2, -2, -2, -2, 2, -2, -2, 4, 0, -2, 4, 3, -2, -1, -2, -2, -1, 0, 3, -5, 0, 0, -2, -9},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, 0, 1, -5, 1, 1, -5, -1, 1, -2, 0, 4, -3, 0, 1, 0, 1, 4, 0, 0, -2, -3, 0, -5, 1, -9},
		/* L */ {0, -2, -3, -6, -3, -3, 4, -4, -2, 4, 0, -3, 7, 5, -3, -2, -2, -3, -2, -1, 3, -2, -1, 1, -2, -9},
		/* M */ {0, -1, -2, -5, -2, -2, 1, -2, -1, 3, 0, 0, 5, 4, -1, -1, -1, 0, -1, 0, 2, -4, 0, -1, -1, -9},
		/* N */ {0, 0, 2, -4, 2, 2, -4, 1, 1, -2, 0, 1, -3, -1, 1, 0, 1, 1, 1, 0, -1, -5, 0, -3, 1, -9},
		/* P */ {0, 1, 0, -3, 0, 0, -5, 0, 0, -1, 0, 0, -2, -1, 0, 5, 1, 0, 1, 1, -1, -6, 0, -5, 0, -9},
		/* Q */ {0, 0, 2, -5, 2, 2, -4, 0, 3, -2, 0, 1, -2, -1, 1, 1, 3, 2, 0, 0, -1, -5, 0, -4, 2, -9},
		/* R */ {0, -1, 0, -4, 0, 0, -5, -2, 2, -2, 0, 4, -3, 0, 1, 0, 2, 5, 0, 0, -2, 4, 0, -4, 1, -9},
		/* S */ {0, 1, 1, 0, 1, 1, -4, 1, 0, -1, 0, 0, -2, -1, 1, 1, 0, 0, 1, 1, -1, -3, 0, -3, 0, -9},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 1, -1, 0, 0, 0, -1, 0, 0, 1, 0, 0, 1, 1, 0, -6, 0, -3, 0, -9},
		/* V */ {0, 0, -1, -2, -2, -1, 0, -1, -2, 3, 0, -2, 3, 2, -1, -1, -1, -2, -1, 0, 4, -6, 0, -2, -1, -9},
		/* W */ {0, -6, -6, -9, -7, -7, 2, -8, -3, -5, 0, -3, -2, -4, -5, -6, -5, 4, -3, -6, -6, 30, -4, 2, -6, -9},
		/* X */ {0, 0, 0, -3, 0, 0, -2, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -4, -1, -2, 0, -9},
		/* Y */ {0, -4, -4, 1, -5, -5, 12, -5, 0, 0, 0, -5, 1, -1, -3, -5, -4, -4, -3, -3, -2, 2, -2, 15, -4, -9},
		/* Z */ {0, 0, 2, -5, 2, 3, -5, 0, 2, -2, 0, 1, -2, -1, 1, 0, 2, 1, 0, 0, -1, -6, 0, -4, 3, -9},
		/* * */ {0, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 450 substitution matrix, scale = ln(2)/6 = 0.115525
	// #
	// # Expected score = -0.476, Entropy = 0.105 bits
	// #
	// # Lowest score = -9, Highest score = 30
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  1 -1  0  1 -2  0  1  1 -1  0 -2  0 -1 -3  1  1  1 -6 -4  0  1  0  0 -9
	// R -1  5  1  0 -4  2  0 -1  2 -2 -3  4  0 -4  0  0  0  4 -4 -2  0  1  0 -9
	// N  0  1  1  2 -4  1  2  1  1 -1 -2  1 -1 -4  0  1  0 -4 -3 -1  1  1  0 -9
	// D  1  0  2  3 -5  2  3  1  1 -2 -3  1 -2 -5  0  1  0 -7 -5 -1  2  2  0 -9
	// C -2 -4 -4 -5 20 -5 -5 -3 -4 -2 -6 -5 -5 -4 -2  0 -2 -9  1 -2 -4 -5 -2 -9
	// Q  0  2  1  2 -5  3  2  0  3 -1 -2  1 -1 -4  1  0  0 -5 -4 -1  2  2  0 -9
	// E  1  0  2  3 -5  2  3  1  1 -2 -3  1 -2 -5  0  1  0 -7 -5 -1  2  3  0 -9
	// G  1 -1  1  1 -3  0  1  4 -1 -2 -3 -1 -2 -5  0  1  1 -8 -5 -1  1  0  0 -9
	// H -1  2  1  1 -4  3  1 -1  5 -2 -2  1 -1 -2  0  0 -1 -2  0 -2  1  2  0 -9
	// I  0 -2 -1 -2 -2 -1 -2 -2 -2  4  3 -2  3  2 -1 -1  0 -5  0  3 -2 -2  0 -9
	// L -2 -3 -2 -3 -6 -2 -3 -3 -2  3  7 -2  4  4 -2 -2 -1 -1  1  3 -3 -2 -1 -9
	// K  0  4  1  1 -5  1  1 -1  1 -2 -2  4  0 -5  0  0  0 -3 -5 -2  1  1  0 -9
	// M -1  0 -1 -2 -5 -1 -2 -2 -1  3  4  0  4  1 -1 -1  0 -4 -1  2 -2 -1  0 -9
	// F -3 -4 -4 -5 -4 -4 -5 -5 -2  2  4 -5  1 13 -5 -3 -3  2 12  0 -4 -5 -2 -9
	// P  1  0  0  0 -2  1  0  0  0 -1 -2  0 -1 -5  5  1  1 -6 -5 -1  0  0  0 -9
	// S  1  0  1  1  0  0  1  1  0 -1 -2  0 -1 -3  1  1  1 -3 -3 -1  1  0  0 -9
	// T  1  0  0  0 -2  0  0  1 -1  0 -1  0  0 -3  1  1  1 -5 -3  0  0  0  0 -9
	// W -6  4 -4 -7 -9 -5 -7 -8 -2 -5 -1 -3 -4  2 -6 -3 -5 30  2 -6 -6 -6 -4 -9
	// Y -4 -4 -3 -5  1 -4 -5 -5  0  0  1 -5 -1 12 -5 -3 -3  2 14 -2 -4 -4 -2 -9
	// V  0 -2 -1 -1 -2 -1 -1 -1 -2  3  3 -2  2  0 -1 -1  0 -6 -2  3 -1 -1  0 -9
	// B  1  0  1  2 -4  2  2  1  1 -2 -3  1 -2 -4  0  1  0 -6 -4 -1  2  2  0 -9
	// Z  0  1  1  2 -5  2  3  0  2 -2 -2  1 -1 -5  0  0  0 -6 -4 -1  2  2  0 -9
	// X  0  0  0  0 -2  0  0  0  0  0 -1  0  0 -2  0  0  0 -4 -2  0  0  0  0 -9
	// * -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9  1
	//
	PAM450 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 1, 1, -2, 1, 1, -3, 1, -1, 0, 0, 0, -2, -1, 0, 1, 0, -1, 1, 1, 0, -6, 0, -4, 0, -9},
		/* B */ {0, 1, 2, -4, 2, 2, -4, 1, 1, -2, 0, 1, -3, -2, 1, 0, 2, 0, 1, 0, -1, -6, 0, -4, 2, -9},
		/* C */ {0, -2, -4, 20, -5, -5, -4, -3, -4, -2, 0, -5, -6, -5, -4, -2, -5, -4, 0, -2, -2, -9, -2, 1, -5, -9},
		/* D */ {0, 1, 2, -5, 3, 3, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -1, -7, 0, -5, 2, -9},
		/* E */ {0, 1, 2, -5, 3, 3, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -1, -7, 0, -5, 3, -9},
		/* F */ {0, -3, -4, -4, -5, -5, 13, -5, -2, 2, 0, -5, 4, 1, -4, -5, -4, -4, -3, -3, 0, 2, -2, 12, -5, -9},
		/* G */ {0, 1, 1, -3, 1, 1, -5, 4, -1, -2, 0, -1, -3, -2, 1, 0, 0, -1, 1, 1, -1, -8, 0, -5, 0, -9},
		/* H */ {0, -1, 1, -4, 1, 1, -2, -1, 5, -2, 0, 1, -2, -1, 1, 0, 3, 2, 0, -1, -2, -2, 0, 0, 2, -9},
		/* I */ {0, 0, -2, -2, -2, -2, 2, -2, -2, 4, 0, -2, 3, 3, -1, -1, -1, -2, -1, 0, 3, -5, 0, 0, -2, -9},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, 0, 1, -5, 1, 1, -5, -1, 1, -2, 0, 4, -2, 0, 1, 0, 1, 4, 0, 0, -2, -3, 0, -5, 1, -9},
		/* L */ {0, -2, -3, -6, -3, -3, 4, -3, -2, 3, 0, -2, 7, 4, -2, -2, -2, -3, -2, -1, 3, -1, -1, 1, -2, -9},
		/* M */ {0, -1, -2, -5, -2, -2, 1, -2, -1, 3, 0, 0, 4, 4, -1, -1, -1, 0, -1, 0, 2, -4, 0, -1, -1, -9},
		/* N */ {0, 0, 1, -4, 2, 2, -4, 1, 1, -1, 0, 1, -2, -1, 1, 0, 1, 1, 1, 0, -1, -4, 0, -3, 1, -9},
		/* P */ {0, 1, 0, -2, 0, 0, -5, 0, 0, -1, 0, 0, -2, -1, 0, 5, 1, 0, 1, 1, -1, -6, 0, -5, 0, -9},
		/* Q */ {0, 0, 2, -5, 2, 2, -4, 0, 3, -1, 0, 1, -2, -1, 1, 1, 3, 2, 0, 0, -1, -5, 0, -4, 2, -9},
		/* R */ {0, -1, 0, -4, 0, 0, -4, -1, 2, -2, 0, 4, -3, 0, 1, 0, 2, 5, 0, 0, -2, 4, 0, -4, 1, -9},
		/* S */ {0, 1, 1, 0, 1, 1, -3, 1, 0, -1, 0, 0, -2, -1, 1, 1, 0, 0, 1, 1, -1, -3, 0, -3, 0, -9},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 1, -1, 0, 0, 0, -1, 0, 0, 1, 0, 0, 1, 1, 0, -5, 0, -3, 0, -9},
		/* V */ {0, 0, -1, -2, -1, -1, 0, -1, -2, 3, 0, -2, 3, 2, -1, -1, -1, -2, -1, 0, 3, -6, 0, -2, -1, -9},
		/* W */ {0, -6, -6, -9, -7, -7, 2, -8, -2, -5, 0, -3, -1, -4, -4, -6, -5, 4, -3, -5, -6, 30, -4, 2, -6, -9},
		/* X */ {0, 0, 0, -2, 0, 0, -2, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -4, 0, -2, 0, -9},
		/* Y */ {0, -4, -4, 1, -5, -5, 12, -5, 0, 0, 0, -5, 1, -1, -3, -5, -4, -4, -3, -3, -2, 2, -2, 14, -4, -9},
		/* Z */ {0, 0, 2, -5, 2, 3, -5, 0, 2, -2, 0, 1, -2, -1, 1, 0, 2, 1, 0, 0, -1, -6, 0, -4, 2, -9},
		/* * */ {0, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 460 substitution matrix, scale = ln(2)/6 = 0.115525
	// #
	// # Expected score = -0.429, Entropy = 0.0994 bits
	// #
	// # Lowest score = -9, Highest score = 30
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  1 -1  0  1 -2  0  1  1  0  0 -1  0 -1 -3  1  1  1 -6 -3  0  1  0  0 -9
	// R -1  5  1  0 -4  1  0 -1  2 -2 -2  4  0 -4  0  0  0  4 -4 -2  0  1  0 -9
	// N  0  1  1  2 -3  1  1  1  1 -1 -2  1 -1 -3  0  1  0 -4 -3 -1  1  1  0 -9
	// D  1  0  2  3 -5  2  3  1  1 -2 -3  1 -2 -5  0  1  0 -7 -4 -1  2  2  0 -9
	// C -2 -4 -3 -5 19 -5 -5 -3 -3 -2 -6 -5 -5 -3 -2  0 -2 -9  2 -2 -4 -5 -2 -9
	// Q  0  1  1  2 -5  2  2  0  2 -1 -2  1 -1 -4  1  0  0 -5 -4 -1  1  2  0 -9
	// E  1  0  1  3 -5  2  3  1  1 -2 -3  1 -2 -5  0  1  0 -7 -4 -1  2  2  0 -9
	// G  1 -1  1  1 -3  0  1  4 -1 -2 -3 -1 -2 -5  1  1  1 -7 -5 -1  1  0  0 -9
	// H  0  2  1  1 -3  2  1 -1  5 -2 -2  1 -1 -2  0  0  0 -2  0 -2  1  2  0 -9
	// I  0 -2 -1 -2 -2 -1 -2 -2 -2  3  3 -2  2  2 -1 -1  0 -5  0  3 -2 -2  0 -9
	// L -1 -2 -2 -3 -6 -2 -3 -3 -2  3  7 -2  4  3 -2 -2 -1 -1  1  3 -3 -2 -1 -9
	// K  0  4  1  1 -5  1  1 -1  1 -2 -2  4  0 -5  0  0  0 -3 -4 -2  1  1  0 -9
	// M -1  0 -1 -2 -5 -1 -2 -2 -1  2  4  0  4  1 -1 -1  0 -4 -1  2 -2 -1  0 -9
	// F -3 -4 -3 -5 -3 -4 -5 -5 -2  2  3 -5  1 12 -4 -3 -3  2 11  0 -4 -5 -2 -9
	// P  1  0  0  0 -2  1  0  1  0 -1 -2  0 -1 -4  4  1  1 -6 -5 -1  0  0  0 -9
	// S  1  0  1  1  0  0  1  1  0 -1 -2  0 -1 -3  1  1  1 -3 -3 -1  1  0  0 -9
	// T  1  0  0  0 -2  0  0  1  0  0 -1  0  0 -3  1  1  1 -5 -3  0  0  0  0 -9
	// W -6  4 -4 -7 -9 -5 -7 -7 -2 -5 -1 -3 -4  2 -6 -3 -5 30  2 -6 -6 -6 -4 -9
	// Y -3 -4 -3 -4  2 -4 -4 -5  0  0  1 -4 -1 11 -5 -3 -3  2 14 -2 -4 -4 -2 -9
	// V  0 -2 -1 -1 -2 -1 -1 -1 -2  3  3 -2  2  0 -1 -1  0 -6 -2  3 -1 -1  0 -9
	// B  1  0  1  2 -4  1  2  1  1 -2 -3  1 -2 -4  0  1  0 -6 -4 -1  2  2  0 -9
	// Z  0  1  1  2 -5  2  2  0  2 -2 -2  1 -1 -5  0  0  0 -6 -4 -1  2  2  0 -9
	// X  0  0  0  0 -2  0  0  0  0  0 -1  0  0 -2  0  0  0 -4 -2  0  0  0  0 -9
	// * -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9  1
	//
	PAM460 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 1, 1, -2, 1, 1, -3, 1, 0, 0, 0, 0, -1, -1, 0, 1, 0, -1, 1, 1, 0, -6, 0, -3, 0, -9},
		/* B */ {0, 1, 2, -4, 2, 2, -4, 1, 1, -2, 0, 1, -3, -2, 1, 0, 1, 0, 1, 0, -1, -6, 0, -4, 2, -9},
		/* C */ {0, -2, -4, 19, -5, -5, -3, -3, -3, -2, 0, -5, -6, -5, -3, -2, -5, -4, 0, -2, -2, -9, -2, 2, -5, -9},
		/* D */ {0, 1, 2, -5, 3, 3, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -1, -7, 0, -4, 2, -9},
		/* E */ {0, 1, 2, -5, 3, 3, -5, 1, 1, -2, 0, 1, -3, -2, 1, 0, 2, 0, 1, 0, -1, -7, 0, -4, 2, -9},
		/* F */ {0, -3, -4, -3, -5, -5, 12, -5, -2, 2, 0, -5, 3, 1, -3, -4, -4, -4, -3, -3, 0, 2, -2, 11, -5, -9},
		/* G */ {0, 1, 1, -3, 1, 1, -5, 4, -1, -2, 0, -1, -3, -2, 1, 1, 0, -1, 1, 1, -1, -7, 0, -5, 0, -9},
		/* H */ {0, 0, 1, -3, 1, 1, -2, -1, 5, -2, 0, 1, -2, -1, 1, 0, 2, 2, 0, 0, -2, -2, 0, 0, 2, -9},
		/* I */ {0, 0, -2, -2, -2, -2, 2, -2, -2, 3, 0, -2, 3, 2, -1, -1, -1, -2, -1, 0, 3, -5, 0, 0, -2, -9},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, 0, 1, -5, 1, 1, -5, -1, 1, -2, 0, 4, -2, 0, 1, 0, 1, 4, 0, 0, -2, -3, 0, -4, 1, -9},
		/* L */ {0, -1, -3, -6, -3, -3, 3, -3, -2, 3, 0, -2, 7, 4, -2, -2, -2, -2, -2, -1, 3, -1, -1, 1, -2, -9},
		/* M */ {0, -1, -2, -5, -2, -2, 1, -2, -1, 2, 0, 0, 4, 4, -1, -1, -1, 0, -1, 0, 2, -4, 0, -1, -1, -9},
		/* N */ {0, 0, 1, -3, 2, 1, -3, 1, 1, -1, 0, 1, -2, -1, 1, 0, 1, 1, 1, 0, -1, -4, 0, -3, 1, -9},
		/* P */ {0, 1, 0, -2, 0, 0, -4, 1, 0, -1, 0, 0, -2, -1, 0, 4, 1, 0, 1, 1, -1, -6, 0, -5, 0, -9},
		/* Q */ {0, 0, 1, -5, 2, 2, -4, 0, 2, -1, 0, 1, -2, -1, 1, 1, 2, 1, 0, 0, -1, -5, 0, -4, 2, -9},
		/* R */ {0, -1, 0, -4, 0, 0, -4, -1, 2, -2, 0, 4, -2, 0, 1, 0, 1, 5, 0, 0, -2, 4, 0, -4, 1, -9},
		/* S */ {0, 1, 1, 0, 1, 1, -3, 1, 0, -1, 0, 0, -2, -1, 1, 1, 0, 0, 1, 1, -1, -3, 0, -3, 0, -9},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 1, 0, 0, 0, 0, -1, 0, 0, 1, 0, 0, 1, 1, 0, -5, 0, -3, 0, -9},
		/* V */ {0, 0, -1, -2, -1, -1, 0, -1, -2, 3, 0, -2, 3, 2, -1, -1, -1, -2, -1, 0, 3, -6, 0, -2, -1, -9},
		/* W */ {0, -6, -6, -9, -7, -7, 2, -7, -2, -5, 0, -3, -1, -4, -4, -6, -5, 4, -3, -5, -6, 30, -4, 2, -6, -9},
		/* X */ {0, 0, 0, -2, 0, 0, -2, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -4, 0, -2, 0, -9},
		/* Y */ {0, -3, -4, 2, -4, -4, 11, -5, 0, 0, 0, -4, 1, -1, -3, -5, -4, -4, -3, -3, -2, 2, -2, 14, -4, -9},
		/* Z */ {0, 0, 2, -5, 2, 2, -5, 0, 2, -2, 0, 1, -2, -1, 1, 0, 2, 1, 0, 0, -1, -6, 0, -4, 2, -9},
		/* * */ {0, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 470 substitution matrix, scale = ln(2)/7 = 0.0990210
	// #
	// # Expected score = -0.520, Entropy = 0.0942 bits
	// #
	// # Lowest score = -10, Highest score = 35
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A   1  -1   1   1  -2   0   1   2  -1   0  -2   0  -1  -4   1   1   1  -7  -4   0   1   0   0 -10
	// R  -1   6   1   0  -4   2   0  -1   2  -2  -3   4   0  -5   0   0   0   4  -5  -2   0   1   0 -10
	// N   1   1   1   2  -4   1   2   1   1  -2  -3   1  -1  -4   0   1   0  -5  -3  -1   2   1   0 -10
	// D   1   0   2   3  -5   2   3   1   1  -2  -4   1  -2  -6   0   1   0  -8  -5  -2   3   3   0 -10
	// C  -2  -4  -4  -5  22  -6  -5  -3  -4  -2  -6  -6  -6  -4  -3   0  -2 -10   2  -2  -5  -6  -3 -10
	// Q   0   2   1   2  -6   3   2   0   3  -2  -2   1  -1  -5   1   0   0  -5  -4  -1   2   2   0 -10
	// E   1   0   2   3  -5   2   3   1   1  -2  -3   1  -2  -6   0   1   0  -8  -5  -1   2   3   0 -10
	// G   2  -1   1   1  -3   0   1   5  -1  -2  -4  -1  -2  -6   1   1   1  -8  -6  -1   1   1   0 -10
	// H  -1   2   1   1  -4   3   1  -1   5  -2  -2   1  -1  -2   0   0   0  -3   0  -2   1   2   0 -10
	// I   0  -2  -2  -2  -2  -2  -2  -2  -2   4   4  -2   3   2  -1  -1   0  -5   0   3  -2  -2   0 -10
	// L  -2  -3  -3  -4  -6  -2  -3  -4  -2   4   8  -3   5   4  -2  -2  -1  -2   1   3  -3  -3  -1 -10
	// K   0   4   1   1  -6   1   1  -1   1  -2  -3   4   0  -5   0   0   0  -3  -5  -2   1   1   0 -10
	// M  -1   0  -1  -2  -6  -1  -2  -2  -1   3   5   0   4   1  -1  -1   0  -4  -1   2  -2  -1   0 -10
	// F  -4  -5  -4  -6  -4  -5  -6  -6  -2   2   4  -5   1  14  -5  -4  -3   3  13   0  -5  -5  -2 -10
	// P   1   0   0   0  -3   1   0   1   0  -1  -2   0  -1  -5   5   1   1  -6  -5  -1   0   1   0 -10
	// S   1   0   1   1   0   0   1   1   0  -1  -2   0  -1  -4   1   1   1  -4  -3  -1   1   0   0 -10
	// T   1   0   0   0  -2   0   0   1   0   0  -1   0   0  -3   1   1   1  -6  -3   0   0   0   0 -10
	// W  -7   4  -5  -8 -10  -5  -8  -8  -3  -5  -2  -3  -4   3  -6  -4  -6  35   2  -7  -6  -7  -4 -10
	// Y  -4  -5  -3  -5   2  -4  -5  -6   0   0   1  -5  -1  13  -5  -3  -3   2  16  -2  -4  -5  -2 -10
	// V   0  -2  -1  -2  -2  -1  -1  -1  -2   3   3  -2   2   0  -1  -1   0  -7  -2   4  -1  -1   0 -10
	// B   1   0   2   3  -5   2   2   1   1  -2  -3   1  -2  -5   0   1   0  -6  -4  -1   2   2   0 -10
	// Z   0   1   1   3  -6   2   3   1   2  -2  -3   1  -1  -5   1   0   0  -7  -5  -1   2   3   0 -10
	// X   0   0   0   0  -3   0   0   0   0   0  -1   0   0  -2   0   0   0  -4  -2   0   0   0   0 -10
	// * -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10   1
	//
	PAM470 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 1, 1, -2, 1, 1, -4, 2, -1, 0, 0, 0, -2, -1, 1, 1, 0, -1, 1, 1, 0, -7, 0, -4, 0, -10},
		/* B */ {0, 1, 2, -5, 3, 2, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -1, -6, 0, -4, 2, -10},
		/* C */ {0, -2, -5, 22, -5, -5, -4, -3, -4, -2, 0, -6, -6, -6, -4, -3, -6, -4, 0, -2, -2, -10, -3, 2, -6, -10},
		/* D */ {0, 1, 3, -5, 3, 3, -6, 1, 1, -2, 0, 1, -4, -2, 2, 0, 2, 0, 1, 0, -2, -8, 0, -5, 3, -10},
		/* E */ {0, 1, 2, -5, 3, 3, -6, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -1, -8, 0, -5, 3, -10},
		/* F */ {0, -4, -5, -4, -6, -6, 14, -6, -2, 2, 0, -5, 4, 1, -4, -5, -5, -5, -4, -3, 0, 3, -2, 13, -5, -10},
		/* G */ {0, 2, 1, -3, 1, 1, -6, 5, -1, -2, 0, -1, -4, -2, 1, 1, 0, -1, 1, 1, -1, -8, 0, -6, 1, -10},
		/* H */ {0, -1, 1, -4, 1, 1, -2, -1, 5, -2, 0, 1, -2, -1, 1, 0, 3, 2, 0, 0, -2, -3, 0, 0, 2, -10},
		/* I */ {0, 0, -2, -2, -2, -2, 2, -2, -2, 4, 0, -2, 4, 3, -2, -1, -2, -2, -1, 0, 3, -5, 0, 0, -2, -10},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, 0, 1, -6, 1, 1, -5, -1, 1, -2, 0, 4, -3, 0, 1, 0, 1, 4, 0, 0, -2, -3, 0, -5, 1, -10},
		/* L */ {0, -2, -3, -6, -4, -3, 4, -4, -2, 4, 0, -3, 8, 5, -3, -2, -2, -3, -2, -1, 3, -2, -1, 1, -3, -10},
		/* M */ {0, -1, -2, -6, -2, -2, 1, -2, -1, 3, 0, 0, 5, 4, -1, -1, -1, 0, -1, 0, 2, -4, 0, -1, -1, -10},
		/* N */ {0, 1, 2, -4, 2, 2, -4, 1, 1, -2, 0, 1, -3, -1, 1, 0, 1, 1, 1, 0, -1, -5, 0, -3, 1, -10},
		/* P */ {0, 1, 0, -3, 0, 0, -5, 1, 0, -1, 0, 0, -2, -1, 0, 5, 1, 0, 1, 1, -1, -6, 0, -5, 1, -10},
		/* Q */ {0, 0, 2, -6, 2, 2, -5, 0, 3, -2, 0, 1, -2, -1, 1, 1, 3, 2, 0, 0, -1, -5, 0, -4, 2, -10},
		/* R */ {0, -1, 0, -4, 0, 0, -5, -1, 2, -2, 0, 4, -3, 0, 1, 0, 2, 6, 0, 0, -2, 4, 0, -5, 1, -10},
		/* S */ {0, 1, 1, 0, 1, 1, -4, 1, 0, -1, 0, 0, -2, -1, 1, 1, 0, 0, 1, 1, -1, -4, 0, -3, 0, -10},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 1, 0, 0, 0, 0, -1, 0, 0, 1, 0, 0, 1, 1, 0, -6, 0, -3, 0, -10},
		/* V */ {0, 0, -1, -2, -2, -1, 0, -1, -2, 3, 0, -2, 3, 2, -1, -1, -1, -2, -1, 0, 4, -7, 0, -2, -1, -10},
		/* W */ {0, -7, -6, -10, -8, -8, 3, -8, -3, -5, 0, -3, -2, -4, -5, -6, -5, 4, -4, -6, -7, 35, -4, 2, -7, -10},
		/* X */ {0, 0, 0, -3, 0, 0, -2, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -4, 0, -2, 0, -10},
		/* Y */ {0, -4, -4, 2, -5, -5, 13, -6, 0, 0, 0, -5, 1, -1, -3, -5, -4, -5, -3, -3, -2, 2, -2, 16, -5, -10},
		/* Z */ {0, 0, 2, -6, 3, 3, -5, 1, 2, -2, 0, 1, -3, -1, 1, 1, 2, 1, 0, 0, -1, -7, 0, -5, 3, -10},
		/* * */ {0, -10, -10, -10, -10, -10, -10, -10, -10, -10, 0, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 480 substitution matrix, scale = ln(2)/7 = 0.0990210
	// #
	// # Expected score = -0.494, Entropy = 0.0893 bits
	// #
	// # Lowest score = -10, Highest score = 35
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A   1  -1   1   1  -2   0   1   2   0   0  -2   0  -1  -4   1   1   1  -7  -4   0   1   0   0 -10
	// R  -1   5   1   0  -4   2   0  -1   2  -2  -3   4   0  -5   0   0   0   4  -4  -2   0   1   0 -10
	// N   1   1   1   2  -4   1   2   1   1  -1  -3   1  -1  -4   0   1   0  -5  -3  -1   2   1   0 -10
	// D   1   0   2   3  -5   2   3   1   1  -2  -3   1  -2  -6   0   1   0  -7  -5  -1   2   2   0 -10
	// C  -2  -4  -4  -5  22  -5  -5  -3  -4  -2  -6  -6  -5  -4  -3   0  -2 -10   2  -2  -4  -5  -3 -10
	// Q   0   2   1   2  -5   3   2   0   3  -2  -2   1  -1  -5   1   0   0  -5  -4  -1   2   2   0 -10
	// E   1   0   2   3  -5   2   3   1   1  -2  -3   1  -2  -5   0   1   0  -8  -5  -1   2   3   0 -10
	// G   2  -1   1   1  -3   0   1   4  -1  -2  -4  -1  -2  -5   1   1   1  -8  -5  -1   1   1   0 -10
	// H   0   2   1   1  -4   3   1  -1   5  -2  -2   1  -1  -2   0   0   0  -3   0  -2   1   2   0 -10
	// I   0  -2  -1  -2  -2  -2  -2  -2  -2   4   4  -2   3   2  -1  -1   0  -5   0   3  -2  -2   0 -10
	// L  -2  -3  -3  -3  -6  -2  -3  -4  -2   4   7  -3   5   4  -2  -2  -1  -2   1   3  -3  -3  -1 -10
	// K   0   4   1   1  -6   1   1  -1   1  -2  -3   4   0  -5   0   0   0  -3  -5  -2   1   1   0 -10
	// M  -1   0  -1  -2  -5  -1  -2  -2  -1   3   5   0   4   1  -1  -1   0  -4  -1   2  -2  -1   0 -10
	// F  -4  -5  -4  -6  -4  -5  -5  -5  -2   2   4  -5   1  14  -5  -4  -3   3  13   0  -5  -5  -2 -10
	// P   1   0   0   0  -3   1   0   1   0  -1  -2   0  -1  -5   5   1   1  -6  -5  -1   0   1   0 -10
	// S   1   0   1   1   0   0   1   1   0  -1  -2   0  -1  -4   1   1   1  -3  -3  -1   1   0   0 -10
	// T   1   0   0   0  -2   0   0   1   0   0  -1   0   0  -3   1   1   1  -6  -3   0   0   0   0 -10
	// W  -7   4  -5  -7 -10  -5  -8  -8  -3  -5  -2  -3  -4   3  -6  -3  -6  35   2  -7  -6  -6  -4 -10
	// Y  -4  -4  -3  -5   2  -4  -5  -5   0   0   1  -5  -1  13  -5  -3  -3   2  16  -2  -4  -5  -2 -10
	// V   0  -2  -1  -1  -2  -1  -1  -1  -2   3   3  -2   2   0  -1  -1   0  -7  -2   3  -1  -1   0 -10
	// B   1   0   2   2  -4   2   2   1   1  -2  -3   1  -2  -5   0   1   0  -6  -4  -1   2   2   0 -10
	// Z   0   1   1   2  -5   2   3   1   2  -2  -3   1  -1  -5   1   0   0  -6  -5  -1   2   2   0 -10
	// X   0   0   0   0  -3   0   0   0   0   0  -1   0   0  -2   0   0   0  -4  -2   0   0   0   0 -10
	// * -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10   1
	//
	PAM480 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 1, 1, -2, 1, 1, -4, 2, 0, 0, 0, 0, -2, -1, 1, 1, 0, -1, 1, 1, 0, -7, 0, -4, 0, -10},
		/* B */ {0, 1, 2, -4, 2, 2, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -1, -6, 0, -4, 2, -10},
		/* C */ {0, -2, -4, 22, -5, -5, -4, -3, -4, -2, 0, -6, -6, -5, -4, -3, -5, -4, 0, -2, -2, -10, -3, 2, -5, -10},
		/* D */ {0, 1, 2, -5, 3, 3, -6, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -1, -7, 0, -5, 2, -10},
		/* E */ {0, 1, 2, -5, 3, 3, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -1, -8, 0, -5, 3, -10},
		/* F */ {0, -4, -5, -4, -6, -5, 14, -5, -2, 2, 0, -5, 4, 1, -4, -5, -5, -5, -4, -3, 0, 3, -2, 13, -5, -10},
		/* G */ {0, 2, 1, -3, 1, 1, -5, 4, -1, -2, 0, -1, -4, -2, 1, 1, 0, -1, 1, 1, -1, -8, 0, -5, 1, -10},
		/* H */ {0, 0, 1, -4, 1, 1, -2, -1, 5, -2, 0, 1, -2, -1, 1, 0, 3, 2, 0, 0, -2, -3, 0, 0, 2, -10},
		/* I */ {0, 0, -2, -2, -2, -2, 2, -2, -2, 4, 0, -2, 4, 3, -1, -1, -2, -2, -1, 0, 3, -5, 0, 0, -2, -10},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, 0, 1, -6, 1, 1, -5, -1, 1, -2, 0, 4, -3, 0, 1, 0, 1, 4, 0, 0, -2, -3, 0, -5, 1, -10},
		/* L */ {0, -2, -3, -6, -3, -3, 4, -4, -2, 4, 0, -3, 7, 5, -3, -2, -2, -3, -2, -1, 3, -2, -1, 1, -3, -10},
		/* M */ {0, -1, -2, -5, -2, -2, 1, -2, -1, 3, 0, 0, 5, 4, -1, -1, -1, 0, -1, 0, 2, -4, 0, -1, -1, -10},
		/* N */ {0, 1, 2, -4, 2, 2, -4, 1, 1, -1, 0, 1, -3, -1, 1, 0, 1, 1, 1, 0, -1, -5, 0, -3, 1, -10},
		/* P */ {0, 1, 0, -3, 0, 0, -5, 1, 0, -1, 0, 0, -2, -1, 0, 5, 1, 0, 1, 1, -1, -6, 0, -5, 1, -10},
		/* Q */ {0, 0, 2, -5, 2, 2, -5, 0, 3, -2, 0, 1, -2, -1, 1, 1, 3, 2, 0, 0, -1, -5, 0, -4, 2, -10},
		/* R */ {0, -1, 0, -4, 0, 0, -5, -1, 2, -2, 0, 4, -3, 0, 1, 0, 2, 5, 0, 0, -2, 4, 0, -4, 1, -10},
		/* S */ {0, 1, 1, 0, 1, 1, -4, 1, 0, -1, 0, 0, -2, -1, 1, 1, 0, 0, 1, 1, -1, -3, 0, -3, 0, -10},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 1, 0, 0, 0, 0, -1, 0, 0, 1, 0, 0, 1, 1, 0, -6, 0, -3, 0, -10},
		/* V */ {0, 0, -1, -2, -1, -1, 0, -1, -2, 3, 0, -2, 3, 2, -1, -1, -1, -2, -1, 0, 3, -7, 0, -2, -1, -10},
		/* W */ {0, -7, -6, -10, -7, -8, 3, -8, -3, -5, 0, -3, -2, -4, -5, -6, -5, 4, -3, -6, -7, 35, -4, 2, -6, -10},
		/* X */ {0, 0, 0, -3, 0, 0, -2, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -4, 0, -2, 0, -10},
		/* Y */ {0, -4, -4, 2, -5, -5, 13, -5, 0, 0, 0, -5, 1, -1, -3, -5, -4, -4, -3, -3, -2, 2, -2, 16, -5, -10},
		/* Z */ {0, 0, 2, -5, 2, 3, -5, 1, 2, -2, 0, 1, -3, -1, 1, 1, 2, 1, 0, 0, -1, -6, 0, -5, 2, -10},
		/* * */ {0, -10, -10, -10, -10, -10, -10, -10, -10, -10, 0, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 490 substitution matrix, scale = ln(2)/7 = 0.0990210
	// #
	// # Expected score = -0.431, Entropy = 0.0847 bits
	// #
	// # Lowest score = -9, Highest score = 34
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  1 -1  0  1 -2  0  1  2  0  0 -1  0 -1 -3  1  1  1 -6 -4  0  1  0  0 -9
	// R -1  5  1  0 -4  2  0 -1  2 -2 -3  4  0 -5  0  0  0  4 -4 -2  0  1  0 -9
	// N  0  1  1  2 -4  1  2  1  1 -1 -2  1 -1 -4  0  1  0 -5 -3 -1  1  1  0 -9
	// D  1  0  2  3 -5  2  3  1  1 -2 -3  1 -2 -5  0  1  0 -7 -5 -1  2  2  0 -9
	// C -2 -4 -4 -5 22 -5 -5 -3 -4 -2 -6 -5 -5 -4 -3  0 -2 -9  2 -2 -4 -5 -2 -9
	// Q  0  2  1  2 -5  2  2  0  2 -1 -2  1 -1 -4  1  0  0 -5 -4 -1  2  2  0 -9
	// E  1  0  2  3 -5  2  3  1  1 -2 -3  1 -2 -5  0  1  0 -7 -5 -1  2  2  0 -9
	// G  2 -1  1  1 -3  0  1  4 -1 -2 -3 -1 -2 -5  1  1  1 -8 -5 -1  1  1  0 -9
	// H  0  2  1  1 -4  2  1 -1  5 -2 -2  1 -1 -2  0  0  0 -3  0 -2  1  2  0 -9
	// I  0 -2 -1 -2 -2 -1 -2 -2 -2  3  4 -2  3  2 -1 -1  0 -5  0  3 -2 -2  0 -9
	// L -1 -3 -2 -3 -6 -2 -3 -3 -2  4  7 -2  5  4 -2 -2 -1 -1  1  3 -3 -2 -1 -9
	// K  0  4  1  1 -5  1  1 -1  1 -2 -2  4  0 -5  0  0  0 -3 -5 -2  1  1  0 -9
	// M -1  0 -1 -2 -5 -1 -2 -2 -1  3  5  0  4  1 -1 -1  0 -4 -1  2 -2 -1  0 -9
	// F -3 -5 -4 -5 -4 -4 -5 -5 -2  2  4 -5  1 14 -5 -4 -3  3 13  0 -5 -5 -2 -9
	// P  1  0  0  0 -3  1  0  1  0 -1 -2  0 -1 -5  4  1  1 -6 -5 -1  0  1  0 -9
	// S  1  0  1  1  0  0  1  1  0 -1 -2  0 -1 -4  1  1  1 -3 -3 -1  1  0  0 -9
	// T  1  0  0  0 -2  0  0  1  0  0 -1  0  0 -3  1  1  1 -6 -3  0  0  0  0 -9
	// W -6  4 -5 -7 -9 -5 -7 -8 -3 -5 -1 -3 -4  3 -6 -3 -6 34  2 -6 -6 -6 -4 -9
	// Y -4 -4 -3 -5  2 -4 -5 -5  0  0  1 -5 -1 13 -5 -3 -3  2 15 -2 -4 -4 -2 -9
	// V  0 -2 -1 -1 -2 -1 -1 -1 -2  3  3 -2  2  0 -1 -1  0 -6 -2  3 -1 -1  0 -9
	// B  1  0  1  2 -4  2  2  1  1 -2 -3  1 -2 -5  0  1  0 -6 -4 -1  2  2  0 -9
	// Z  0  1  1  2 -5  2  2  1  2 -2 -2  1 -1 -5  1  0  0 -6 -4 -1  2  2  0 -9
	// X  0  0  0  0 -2  0  0  0  0  0 -1  0  0 -2  0  0  0 -4 -2  0  0  0  0 -9
	// * -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9  1
	//
	PAM490 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 1, 1, -2, 1, 1, -3, 2, 0, 0, 0, 0, -1, -1, 0, 1, 0, -1, 1, 1, 0, -6, 0, -4, 0, -9},
		/* B */ {0, 1, 2, -4, 2, 2, -5, 1, 1, -2, 0, 1, -3, -2, 1, 0, 2, 0, 1, 0, -1, -6, 0, -4, 2, -9},
		/* C */ {0, -2, -4, 22, -5, -5, -4, -3, -4, -2, 0, -5, -6, -5, -4, -3, -5, -4, 0, -2, -2, -9, -2, 2, -5, -9},
		/* D */ {0, 1, 2, -5, 3, 3, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -1, -7, 0, -5, 2, -9},
		/* E */ {0, 1, 2, -5, 3, 3, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -1, -7, 0, -5, 2, -9},
		/* F */ {0, -3, -5, -4, -5, -5, 14, -5, -2, 2, 0, -5, 4, 1, -4, -5, -4, -5, -4, -3, 0, 3, -2, 13, -5, -9},
		/* G */ {0, 2, 1, -3, 1, 1, -5, 4, -1, -2, 0, -1, -3, -2, 1, 1, 0, -1, 1, 1, -1, -8, 0, -5, 1, -9},
		/* H */ {0, 0, 1, -4, 1, 1, -2, -1, 5, -2, 0, 1, -2, -1, 1, 0, 2, 2, 0, 0, -2, -3, 0, 0, 2, -9},
		/* I */ {0, 0, -2, -2, -2, -2, 2, -2, -2, 3, 0, -2, 4, 3, -1, -1, -1, -2, -1, 0, 3, -5, 0, 0, -2, -9},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, 0, 1, -5, 1, 1, -5, -1, 1, -2, 0, 4, -2, 0, 1, 0, 1, 4, 0, 0, -2, -3, 0, -5, 1, -9},
		/* L */ {0, -1, -3, -6, -3, -3, 4, -3, -2, 4, 0, -2, 7, 5, -2, -2, -2, -3, -2, -1, 3, -1, -1, 1, -2, -9},
		/* M */ {0, -1, -2, -5, -2, -2, 1, -2, -1, 3, 0, 0, 5, 4, -1, -1, -1, 0, -1, 0, 2, -4, 0, -1, -1, -9},
		/* N */ {0, 0, 1, -4, 2, 2, -4, 1, 1, -1, 0, 1, -2, -1, 1, 0, 1, 1, 1, 0, -1, -5, 0, -3, 1, -9},
		/* P */ {0, 1, 0, -3, 0, 0, -5, 1, 0, -1, 0, 0, -2, -1, 0, 4, 1, 0, 1, 1, -1, -6, 0, -5, 1, -9},
		/* Q */ {0, 0, 2, -5, 2, 2, -4, 0, 2, -1, 0, 1, -2, -1, 1, 1, 2, 2, 0, 0, -1, -5, 0, -4, 2, -9},
		/* R */ {0, -1, 0, -4, 0, 0, -5, -1, 2, -2, 0, 4, -3, 0, 1, 0, 2, 5, 0, 0, -2, 4, 0, -4, 1, -9},
		/* S */ {0, 1, 1, 0, 1, 1, -4, 1, 0, -1, 0, 0, -2, -1, 1, 1, 0, 0, 1, 1, -1, -3, 0, -3, 0, -9},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 1, 0, 0, 0, 0, -1, 0, 0, 1, 0, 0, 1, 1, 0, -6, 0, -3, 0, -9},
		/* V */ {0, 0, -1, -2, -1, -1, 0, -1, -2, 3, 0, -2, 3, 2, -1, -1, -1, -2, -1, 0, 3, -6, 0, -2, -1, -9},
		/* W */ {0, -6, -6, -9, -7, -7, 3, -8, -3, -5, 0, -3, -1, -4, -5, -6, -5, 4, -3, -6, -6, 34, -4, 2, -6, -9},
		/* X */ {0, 0, 0, -2, 0, 0, -2, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -4, 0, -2, 0, -9},
		/* Y */ {0, -4, -4, 2, -5, -5, 13, -5, 0, 0, 0, -5, 1, -1, -3, -5, -4, -4, -3, -3, -2, 2, -2, 15, -4, -9},
		/* Z */ {0, 0, 2, -5, 2, 2, -5, 1, 2, -2, 0, 1, -2, -1, 1, 1, 2, 1, 0, 0, -1, -6, 0, -4, 2, -9},
		/* * */ {0, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 50 substitution matrix, scale = ln(2)/2 = 0.346574
	// #
	// # Expected score = -3.70, Entropy = 2.00 bits
	// #
	// # Lowest score = -13, Highest score = 13
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A   5  -5  -2  -2  -5  -3  -1  -1  -5  -3  -5  -5  -4  -7   0   0   0 -11  -6  -1  -2  -2  -2 -13
	// R  -5   8  -4  -7  -6   0  -7  -7   0  -4  -7   1  -3  -8  -3  -2  -5  -1  -8  -6  -5  -2  -4 -13
	// N  -2  -4   7   2  -8  -2  -1  -2   1  -4  -6   0  -6  -7  -4   1  -1  -7  -3  -6   5  -1  -2 -13
	// D  -2  -7   2   7 -11  -1   3  -2  -2  -6 -10  -3  -8 -12  -6  -2  -3 -12  -9  -6   6   2  -4 -13
	// C  -5  -6  -8 -11   9 -11 -11  -7  -6  -5 -12 -11 -11 -10  -6  -2  -6 -13  -3  -5  -9 -11  -7 -13
	// Q  -3   0  -2  -1 -11   8   2  -5   2  -6  -4  -2  -3 -10  -2  -4  -4 -10  -9  -5  -2   6  -3 -13
	// E  -1  -7  -1   3 -11   2   7  -3  -3  -4  -7  -3  -5 -11  -4  -3  -4 -13  -7  -5   2   6  -3 -13
	// G  -1  -7  -2  -2  -7  -5  -3   6  -7  -8  -9  -6  -7  -8  -4  -1  -4 -12 -11  -4  -2  -4  -4 -13
	// H  -5   0   1  -2  -6   2  -3  -7   9  -7  -5  -4  -8  -5  -3  -4  -5  -6  -2  -5   0   0  -4 -13
	// I  -3  -4  -4  -6  -5  -6  -4  -8  -7   8   0  -5   0  -1  -7  -5  -1 -11  -5   3  -5  -5  -3 -13
	// L  -5  -7  -6 -10 -12  -4  -7  -9  -5   0   6  -6   2  -1  -6  -7  -5  -5  -5  -1  -7  -5  -5 -13
	// K  -5   1   0  -3 -11  -2  -3  -6  -4  -5  -6   6  -1 -11  -5  -3  -2  -9  -8  -7  -1  -2  -4 -13
	// M  -4  -3  -6  -8 -11  -3  -5  -7  -8   0   2  -1  10  -3  -6  -4  -3 -10  -8   0  -7  -4  -4 -13
	// F  -7  -8  -7 -12 -10 -10 -11  -8  -5  -1  -1 -11  -3   9  -8  -5  -7  -3   3  -6  -9 -11  -6 -13
	// P   0  -3  -4  -6  -6  -2  -4  -4  -3  -7  -6  -5  -6  -8   8  -1  -3 -11 -11  -4  -5  -3  -4 -13
	// S   0  -2   1  -2  -2  -4  -3  -1  -4  -5  -7  -3  -4  -5  -1   6   1  -4  -5  -4  -1  -3  -2 -13
	// T   0  -5  -1  -3  -6  -4  -4  -4  -5  -1  -5  -2  -3  -7  -3   1   6 -10  -5  -2  -2  -4  -2 -13
	// W -11  -1  -7 -12 -13 -10 -13 -12  -6 -11  -5  -9 -10  -3 -11  -4 -10  13  -4 -12  -8 -11  -9 -13
	// Y  -6  -8  -3  -9  -3  -9  -7 -11  -2  -5  -5  -8  -8   3 -11  -5  -5  -4   9  -6  -5  -8  -6 -13
	// V  -1  -6  -6  -6  -5  -5  -5  -4  -5   3  -1  -7   0  -6  -4  -4  -2 -12  -6   7  -6  -5  -3 -13
	// B  -2  -5   5   6  -9  -2   2  -2   0  -5  -7  -1  -7  -9  -5  -1  -2  -8  -5  -6   5   1  -3 -13
	// Z  -2  -2  -1   2 -11   6   6  -4   0  -5  -5  -2  -4 -11  -3  -3  -4 -11  -8  -5   1   6  -3 -13
	// X  -2  -4  -2  -4  -7  -3  -3  -4  -4  -3  -5  -4  -4  -6  -4  -2  -2  -9  -6  -3  -3  -3  -4 -13
	// * -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13   1
	//
	PAM50 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 5, -2, -5, -2, -1, -7, -1, -5, -3, 0, -5, -5, -4, -2, 0, -3, -5, 0, 0, -1, -11, -2, -6, -2, -13},
		/* B */ {0, -2, 5, -9, 6, 2, -9, -2, 0, -5, 0, -1, -7, -7, 5, -5, -2, -5, -1, -2, -6, -8, -3, -5, 1, -13},
		/* C */ {0, -5, -9, 9, -11, -11, -10, -7, -6, -5, 0, -11, -12, -11, -8, -6, -11, -6, -2, -6, -5, -13, -7, -3, -11, -13},
		/* D */ {0, -2, 6, -11, 7, 3, -12, -2, -2, -6, 0, -3, -10, -8, 2, -6, -1, -7, -2, -3, -6, -12, -4, -9, 2, -13},
		/* E */ {0, -1, 2, -11, 3, 7, -11, -3, -3, -4, 0, -3, -7, -5, -1, -4, 2, -7, -3, -4, -5, -13, -3, -7, 6, -13},
		/* F */ {0, -7, -9, -10, -12, -11, 9, -8, -5, -1, 0, -11, -1, -3, -7, -8, -10, -8, -5, -7, -6, -3, -6, 3, -11, -13},
		/* G */ {0, -1, -2, -7, -2, -3, -8, 6, -7, -8, 0, -6, -9, -7, -2, -4, -5, -7, -1, -4, -4, -12, -4, -11, -4, -13},
		/* H */ {0, -5, 0, -6, -2, -3, -5, -7, 9, -7, 0, -4, -5, -8, 1, -3, 2, 0, -4, -5, -5, -6, -4, -2, 0, -13},
		/* I */ {0, -3, -5, -5, -6, -4, -1, -8, -7, 8, 0, -5, 0, 0, -4, -7, -6, -4, -5, -1, 3, -11, -3, -5, -5, -13},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -5, -1, -11, -3, -3, -11, -6, -4, -5, 0, 6, -6, -1, 0, -5, -2, 1, -3, -2, -7, -9, -4, -8, -2, -13},
		/* L */ {0, -5, -7, -12, -10, -7, -1, -9, -5, 0, 0, -6, 6, 2, -6, -6, -4, -7, -7, -5, -1, -5, -5, -5, -5, -13},
		/* M */ {0, -4, -7, -11, -8, -5, -3, -7, -8, 0, 0, -1, 2, 10, -6, -6, -3, -3, -4, -3, 0, -10, -4, -8, -4, -13},
		/* N */ {0, -2, 5, -8, 2, -1, -7, -2, 1, -4, 0, 0, -6, -6, 7, -4, -2, -4, 1, -1, -6, -7, -2, -3, -1, -13},
		/* P */ {0, 0, -5, -6, -6, -4, -8, -4, -3, -7, 0, -5, -6, -6, -4, 8, -2, -3, -1, -3, -4, -11, -4, -11, -3, -13},
		/* Q */ {0, -3, -2, -11, -1, 2, -10, -5, 2, -6, 0, -2, -4, -3, -2, -2, 8, 0, -4, -4, -5, -10, -3, -9, 6, -13},
		/* R */ {0, -5, -5, -6, -7, -7, -8, -7, 0, -4, 0, 1, -7, -3, -4, -3, 0, 8, -2, -5, -6, -1, -4, -8, -2, -13},
		/* S */ {0, 0, -1, -2, -2, -3, -5, -1, -4, -5, 0, -3, -7, -4, 1, -1, -4, -2, 6, 1, -4, -4, -2, -5, -3, -13},
		/* T */ {0, 0, -2, -6, -3, -4, -7, -4, -5, -1, 0, -2, -5, -3, -1, -3, -4, -5, 1, 6, -2, -10, -2, -5, -4, -13},
		/* V */ {0, -1, -6, -5, -6, -5, -6, -4, -5, 3, 0, -7, -1, 0, -6, -4, -5, -6, -4, -2, 7, -12, -3, -6, -5, -13},
		/* W */ {0, -11, -8, -13, -12, -13, -3, -12, -6, -11, 0, -9, -5, -10, -7, -11, -10, -1, -4, -10, -12, 13, -9, -4, -11, -13},
		/* X */ {0, -2, -3, -7, -4, -3, -6, -4, -4, -3, 0, -4, -5, -4, -2, -4, -3, -4, -2, -2, -3, -9, -4, -6, -3, -13},
		/* Y */ {0, -6, -5, -3, -9, -7, 3, -11, -2, -5, 0, -8, -5, -8, -3, -11, -9, -8, -5, -5, -6, -4, -6, 9, -8, -13},
		/* Z */ {0, -2, 1, -11, 2, 6, -11, -4, 0, -5, 0, -2, -5, -4, -1, -3, 6, -2, -3, -4, -5, -11, -3, -8, 6, -13},
		/* * */ {0, -13, -13, -13, -13, -13, -13, -13, -13, -13, 0, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 500 substitution matrix, scale = ln(2)/7 = 0.0990210
	// #
	// # Expected score = -0.401, Entropy = 0.0803 bits
	// #
	// # Lowest score = -9, Highest score = 34
	// #
	//    A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  *
	// A  1 -1  0  1 -2  0  1  1  0  0 -1  0 -1 -3  1  1  1 -6 -3  0  1  0  0 -9
	// R -1  5  1  0 -4  2  0 -1  2 -2 -2  4  0 -4  0  0  0  4 -4 -2  0  1  0 -9
	// N  0  1  1  2 -3  1  1  1  1 -1 -2  1 -1 -4  0  1  0 -5 -3 -1  1  1  0 -9
	// D  1  0  2  3 -5  2  3  1  1 -2 -3  1 -2 -5  0  1  0 -7 -5 -1  2  2  0 -9
	// C -2 -4 -3 -5 22 -5 -5 -3 -4 -2 -6 -5 -5 -3 -2  0 -2 -9  2 -2 -4 -5 -2 -9
	// Q  0  2  1  2 -5  2  2  0  2 -1 -2  1 -1 -4  1  0  0 -5 -4 -1  2  2  0 -9
	// E  1  0  1  3 -5  2  3  1  1 -2 -3  1 -1 -5  0  1  0 -7 -5 -1  2  2  0 -9
	// G  1 -1  1  1 -3  0  1  4 -1 -2 -3  0 -2 -5  1  1  1 -8 -5 -1  1  1  0 -9
	// H  0  2  1  1 -4  2  1 -1  4 -2 -2  1 -1 -2  0  0  0 -2  0 -2  1  2  0 -9
	// I  0 -2 -1 -2 -2 -1 -2 -2 -2  3  4 -2  3  2 -1 -1  0 -5  0  3 -2 -2  0 -9
	// L -1 -2 -2 -3 -6 -2 -3 -3 -2  4  7 -2  4  4 -2 -2 -1 -1  1  3 -3 -2 -1 -9
	// K  0  4  1  1 -5  1  1  0  1 -2 -2  4  0 -5  0  0  0 -3 -5 -2  1  1  0 -9
	// M -1  0 -1 -2 -5 -1 -1 -2 -1  3  4  0  4  1 -1 -1  0 -4 -1  2 -1 -1  0 -9
	// F -3 -4 -4 -5 -3 -4 -5 -5 -2  2  4 -5  1 13 -4 -3 -3  3 13  0 -4 -5 -2 -9
	// P  1  0  0  0 -2  1  0  1  0 -1 -2  0 -1 -4  4  1  1 -6 -5 -1  0  1  0 -9
	// S  1  0  1  1  0  0  1  1  0 -1 -2  0 -1 -3  1  1  1 -3 -3 -1  1  0  0 -9
	// T  1  0  0  0 -2  0  0  1  0  0 -1  0  0 -3  1  1  1 -6 -3  0  0  0  0 -9
	// W -6  4 -5 -7 -9 -5 -7 -8 -2 -5 -1 -3 -4  3 -6 -3 -6 34  2 -6 -6 -6 -4 -9
	// Y -3 -4 -3 -5  2 -4 -5 -5  0  0  1 -5 -1 13 -5 -3 -3  2 15 -1 -4 -4 -2 -9
	// V  0 -2 -1 -1 -2 -1 -1 -1 -2  3  3 -2  2  0 -1 -1  0 -6 -1  3 -1 -1  0 -9
	// B  1  0  1  2 -4  2  2  1  1 -2 -3  1 -1 -4  0  1  0 -6 -4 -1  2  2  0 -9
	// Z  0  1  1  2 -5  2  2  1  2 -2 -2  1 -1 -5  1  0  0 -6 -4 -1  2  2  0 -9
	// X  0  0  0  0 -2  0  0  0  0  0 -1  0  0 -2  0  0  0 -4 -2  0  0  0  0 -9
	// * -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9  1
	//
	PAM500 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 1, 1, -2, 1, 1, -3, 1, 0, 0, 0, 0, -1, -1, 0, 1, 0, -1, 1, 1, 0, -6, 0, -3, 0, -9},
		/* B */ {0, 1, 2, -4, 2, 2, -4, 1, 1, -2, 0, 1, -3, -1, 1, 0, 2, 0, 1, 0, -1, -6, 0, -4, 2, -9},
		/* C */ {0, -2, -4, 22, -5, -5, -3, -3, -4, -2, 0, -5, -6, -5, -3, -2, -5, -4, 0, -2, -2, -9, -2, 2, -5, -9},
		/* D */ {0, 1, 2, -5, 3, 3, -5, 1, 1, -2, 0, 1, -3, -2, 2, 0, 2, 0, 1, 0, -1, -7, 0, -5, 2, -9},
		/* E */ {0, 1, 2, -5, 3, 3, -5, 1, 1, -2, 0, 1, -3, -1, 1, 0, 2, 0, 1, 0, -1, -7, 0, -5, 2, -9},
		/* F */ {0, -3, -4, -3, -5, -5, 13, -5, -2, 2, 0, -5, 4, 1, -4, -4, -4, -4, -3, -3, 0, 3, -2, 13, -5, -9},
		/* G */ {0, 1, 1, -3, 1, 1, -5, 4, -1, -2, 0, 0, -3, -2, 1, 1, 0, -1, 1, 1, -1, -8, 0, -5, 1, -9},
		/* H */ {0, 0, 1, -4, 1, 1, -2, -1, 4, -2, 0, 1, -2, -1, 1, 0, 2, 2, 0, 0, -2, -2, 0, 0, 2, -9},
		/* I */ {0, 0, -2, -2, -2, -2, 2, -2, -2, 3, 0, -2, 4, 3, -1, -1, -1, -2, -1, 0, 3, -5, 0, 0, -2, -9},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, 0, 1, -5, 1, 1, -5, 0, 1, -2, 0, 4, -2, 0, 1, 0, 1, 4, 0, 0, -2, -3, 0, -5, 1, -9},
		/* L */ {0, -1, -3, -6, -3, -3, 4, -3, -2, 4, 0, -2, 7, 4, -2, -2, -2, -2, -2, -1, 3, -1, -1, 1, -2, -9},
		/* M */ {0, -1, -1, -5, -2, -1, 1, -2, -1, 3, 0, 0, 4, 4, -1, -1, -1, 0, -1, 0, 2, -4, 0, -1, -1, -9},
		/* N */ {0, 0, 1, -3, 2, 1, -4, 1, 1, -1, 0, 1, -2, -1, 1, 0, 1, 1, 1, 0, -1, -5, 0, -3, 1, -9},
		/* P */ {0, 1, 0, -2, 0, 0, -4, 1, 0, -1, 0, 0, -2, -1, 0, 4, 1, 0, 1, 1, -1, -6, 0, -5, 1, -9},
		/* Q */ {0, 0, 2, -5, 2, 2, -4, 0, 2, -1, 0, 1, -2, -1, 1, 1, 2, 2, 0, 0, -1, -5, 0, -4, 2, -9},
		/* R */ {0, -1, 0, -4, 0, 0, -4, -1, 2, -2, 0, 4, -2, 0, 1, 0, 2, 5, 0, 0, -2, 4, 0, -4, 1, -9},
		/* S */ {0, 1, 1, 0, 1, 1, -3, 1, 0, -1, 0, 0, -2, -1, 1, 1, 0, 0, 1, 1, -1, -3, 0, -3, 0, -9},
		/* T */ {0, 1, 0, -2, 0, 0, -3, 1, 0, 0, 0, 0, -1, 0, 0, 1, 0, 0, 1, 1, 0, -6, 0, -3, 0, -9},
		/* V */ {0, 0, -1, -2, -1, -1, 0, -1, -2, 3, 0, -2, 3, 2, -1, -1, -1, -2, -1, 0, 3, -6, 0, -1, -1, -9},
		/* W */ {0, -6, -6, -9, -7, -7, 3, -8, -2, -5, 0, -3, -1, -4, -5, -6, -5, 4, -3, -6, -6, 34, -4, 2, -6, -9},
		/* X */ {0, 0, 0, -2, 0, 0, -2, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -4, 0, -2, 0, -9},
		/* Y */ {0, -3, -4, 2, -5, -5, 13, -5, 0, 0, 0, -5, 1, -1, -3, -5, -4, -4, -3, -3, -1, 2, -2, 15, -4, -9},
		/* Z */ {0, 0, 2, -5, 2, 2, -5, 1, 2, -2, 0, 1, -2, -1, 1, 1, 2, 1, 0, 0, -1, -6, 0, -4, 2, -9},
		/* * */ {0, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 60 substitution matrix, scale = ln(2)/2 = 0.346574
	// #
	// # Expected score = -3.21, Entropy = 1.79 bits
	// #
	// # Lowest score = -12, Highest score = 13
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A   5  -5  -2  -2  -5  -3  -1   0  -5  -3  -4  -5  -3  -6   0   1   1 -10  -6  -1  -2  -2  -2 -12
	// R  -5   8  -3  -6  -6   0  -6  -7   0  -4  -6   2  -2  -7  -2  -2  -4   0  -8  -5  -5  -2  -4 -12
	// N  -2  -3   6   2  -7  -2   0  -1   1  -4  -5   0  -6  -6  -4   1  -1  -6  -3  -5   5  -1  -2 -12
	// D  -2  -6   2   7 -10  -1   3  -2  -2  -5  -9  -2  -7 -11  -5  -2  -3 -11  -8  -6   5   2  -3 -12
	// C  -5  -6  -7 -10   9 -10 -10  -7  -6  -4 -11 -10 -10  -9  -6  -1  -5 -12  -2  -4  -9 -10  -6 -12
	// Q  -3   0  -2  -1 -10   7   2  -5   2  -5  -3  -1  -2  -9  -1  -3  -4  -9  -8  -5  -1   6  -3 -12
	// E  -1  -6   0   3 -10   2   7  -2  -3  -4  -7  -3  -5 -10  -3  -2  -4 -12  -7  -4   2   5  -3 -12
	// G   0  -7  -1  -2  -7  -5  -2   6  -6  -7  -8  -5  -6  -7  -4   0  -3 -11 -10  -4  -2  -3  -3 -12
	// H  -5   0   1  -2  -6   2  -3  -6   8  -6  -4  -4  -7  -4  -2  -4  -5  -5  -2  -5   0   0  -3 -12
	// I  -3  -4  -4  -5  -4  -5  -4  -7  -6   7   0  -4   1  -1  -6  -4  -1 -10  -4   3  -4  -4  -3 -12
	// L  -4  -6  -5  -9 -11  -3  -7  -8  -4   0   6  -6   2  -1  -5  -6  -5  -4  -5  -1  -7  -5  -4 -12
	// K  -5   2   0  -2 -10  -1  -3  -5  -4  -4  -6   6   0 -10  -4  -2  -2  -8  -7  -6  -1  -2  -3 -12
	// M  -3  -2  -6  -7 -10  -2  -5  -6  -7   1   2   0  10  -2  -6  -4  -2  -9  -7   0  -6  -4  -3 -12
	// F  -6  -7  -6 -11  -9  -9 -10  -7  -4  -1  -1 -10  -2   8  -7  -5  -6  -3   3  -5  -8 -10  -5 -12
	// P   0  -2  -4  -5  -6  -1  -3  -4  -2  -6  -5  -4  -6  -7   7   0  -2 -10 -10  -4  -4  -2  -3 -12
	// S   1  -2   1  -2  -1  -3  -2   0  -4  -4  -6  -2  -4  -5   0   5   1  -4  -5  -4   0  -3  -2 -12
	// T   1  -4  -1  -3  -5  -4  -4  -3  -5  -1  -5  -2  -2  -6  -2   1   6  -9  -5  -1  -2  -4  -2 -12
	// W -10   0  -6 -11 -12  -9 -12 -11  -5 -10  -4  -8  -9  -3 -10  -4  -9  13  -3 -11  -8 -11  -8 -12
	// Y  -6  -8  -3  -8  -2  -8  -7 -10  -2  -4  -5  -7  -7   3 -10  -5  -5  -3   9  -5  -5  -7  -5 -12
	// V  -1  -5  -5  -6  -4  -5  -4  -4  -5   3  -1  -6   0  -5  -4  -4  -1 -11  -5   6  -5  -5  -3 -12
	// B  -2  -5   5   5  -9  -1   2  -2   0  -4  -7  -1  -6  -8  -4   0  -2  -8  -5  -5   5   1  -3 -12
	// Z  -2  -2  -1   2 -10   6   5  -3   0  -4  -5  -2  -4 -10  -2  -3  -4 -11  -7  -5   1   5  -3 -12
	// X  -2  -4  -2  -3  -6  -3  -3  -3  -3  -3  -4  -3  -3  -5  -3  -2  -2  -8  -5  -3  -3  -3  -3 -12
	// * -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12   1
	//
	PAM60 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 5, -2, -5, -2, -1, -6, 0, -5, -3, 0, -5, -4, -3, -2, 0, -3, -5, 1, 1, -1, -10, -2, -6, -2, -12},
		/* B */ {0, -2, 5, -9, 5, 2, -8, -2, 0, -4, 0, -1, -7, -6, 5, -4, -1, -5, 0, -2, -5, -8, -3, -5, 1, -12},
		/* C */ {0, -5, -9, 9, -10, -10, -9, -7, -6, -4, 0, -10, -11, -10, -7, -6, -10, -6, -1, -5, -4, -12, -6, -2, -10, -12},
		/* D */ {0, -2, 5, -10, 7, 3, -11, -2, -2, -5, 0, -2, -9, -7, 2, -5, -1, -6, -2, -3, -6, -11, -3, -8, 2, -12},
		/* E */ {0, -1, 2, -10, 3, 7, -10, -2, -3, -4, 0, -3, -7, -5, 0, -3, 2, -6, -2, -4, -4, -12, -3, -7, 5, -12},
		/* F */ {0, -6, -8, -9, -11, -10, 8, -7, -4, -1, 0, -10, -1, -2, -6, -7, -9, -7, -5, -6, -5, -3, -5, 3, -10, -12},
		/* G */ {0, 0, -2, -7, -2, -2, -7, 6, -6, -7, 0, -5, -8, -6, -1, -4, -5, -7, 0, -3, -4, -11, -3, -10, -3, -12},
		/* H */ {0, -5, 0, -6, -2, -3, -4, -6, 8, -6, 0, -4, -4, -7, 1, -2, 2, 0, -4, -5, -5, -5, -3, -2, 0, -12},
		/* I */ {0, -3, -4, -4, -5, -4, -1, -7, -6, 7, 0, -4, 0, 1, -4, -6, -5, -4, -4, -1, 3, -10, -3, -4, -4, -12},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -5, -1, -10, -2, -3, -10, -5, -4, -4, 0, 6, -6, 0, 0, -4, -1, 2, -2, -2, -6, -8, -3, -7, -2, -12},
		/* L */ {0, -4, -7, -11, -9, -7, -1, -8, -4, 0, 0, -6, 6, 2, -5, -5, -3, -6, -6, -5, -1, -4, -4, -5, -5, -12},
		/* M */ {0, -3, -6, -10, -7, -5, -2, -6, -7, 1, 0, 0, 2, 10, -6, -6, -2, -2, -4, -2, 0, -9, -3, -7, -4, -12},
		/* N */ {0, -2, 5, -7, 2, 0, -6, -1, 1, -4, 0, 0, -5, -6, 6, -4, -2, -3, 1, -1, -5, -6, -2, -3, -1, -12},
		/* P */ {0, 0, -4, -6, -5, -3, -7, -4, -2, -6, 0, -4, -5, -6, -4, 7, -1, -2, 0, -2, -4, -10, -3, -10, -2, -12},
		/* Q */ {0, -3, -1, -10, -1, 2, -9, -5, 2, -5, 0, -1, -3, -2, -2, -1, 7, 0, -3, -4, -5, -9, -3, -8, 6, -12},
		/* R */ {0, -5, -5, -6, -6, -6, -7, -7, 0, -4, 0, 2, -6, -2, -3, -2, 0, 8, -2, -4, -5, 0, -4, -8, -2, -12},
		/* S */ {0, 1, 0, -1, -2, -2, -5, 0, -4, -4, 0, -2, -6, -4, 1, 0, -3, -2, 5, 1, -4, -4, -2, -5, -3, -12},
		/* T */ {0, 1, -2, -5, -3, -4, -6, -3, -5, -1, 0, -2, -5, -2, -1, -2, -4, -4, 1, 6, -1, -9, -2, -5, -4, -12},
		/* V */ {0, -1, -5, -4, -6, -4, -5, -4, -5, 3, 0, -6, -1, 0, -5, -4, -5, -5, -4, -1, 6, -11, -3, -5, -5, -12},
		/* W */ {0, -10, -8, -12, -11, -12, -3, -11, -5, -10, 0, -8, -4, -9, -6, -10, -9, 0, -4, -9, -11, 13, -8, -3, -11, -12},
		/* X */ {0, -2, -3, -6, -3, -3, -5, -3, -3, -3, 0, -3, -4, -3, -2, -3, -3, -4, -2, -2, -3, -8, -3, -5, -3, -12},
		/* Y */ {0, -6, -5, -2, -8, -7, 3, -10, -2, -4, 0, -7, -5, -7, -3, -10, -8, -8, -5, -5, -5, -3, -5, 9, -7, -12},
		/* Z */ {0, -2, 1, -10, 2, 5, -10, -3, 0, -4, 0, -2, -5, -4, -1, -2, 6, -2, -3, -4, -5, -11, -3, -7, 5, -12},
		/* * */ {0, -12, -12, -12, -12, -12, -12, -12, -12, -12, 0, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 70 substitution matrix, scale = ln(2)/2 = 0.346574
	// #
	// # Expected score = -2.77, Entropy = 1.60 bits
	// #
	// # Lowest score = -11, Highest score = 13
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A   5  -4  -2  -1  -4  -2  -1   0  -4  -2  -4  -4  -3  -6   0   1   1  -9  -5  -1  -1  -1  -2 -11
	// R  -4   8  -3  -6  -5   0  -5  -6   0  -3  -6   2  -2  -7  -2  -1  -4   0  -7  -5  -4  -2  -3 -11
	// N  -2  -3   6   3  -7  -1   0  -1   1  -3  -5   0  -5  -6  -3   1   0  -6  -3  -5   5  -1  -2 -11
	// D  -1  -6   3   6  -9   0   3  -1  -1  -5  -8  -2  -7 -10  -4  -1  -2 -10  -7  -5   5   2  -3 -11
	// C  -4  -5  -7  -9   9  -9  -9  -6  -5  -4 -10  -9  -9  -8  -5  -1  -5 -11  -2  -4  -8  -9  -6 -11
	// Q  -2   0  -1   0  -9   7   2  -4   2  -5  -3  -1  -2  -9  -1  -3  -3  -8  -8  -4  -1   5  -2 -11
	// E  -1  -5   0   3  -9   2   6  -2  -2  -4  -6  -2  -4  -9  -3  -2  -3 -11  -6  -4   2   5  -3 -11
	// G   0  -6  -1  -1  -6  -4  -2   6  -6  -6  -7  -5  -6  -7  -3   0  -3 -10  -9  -3  -1  -3  -3 -11
	// H  -4   0   1  -1  -5   2  -2  -6   8  -6  -4  -3  -6  -4  -2  -3  -4  -5  -1  -4   0   1  -3 -11
	// I  -2  -3  -3  -5  -4  -5  -4  -6  -6   7   1  -4   1   0  -5  -4  -1  -9  -4   3  -4  -4  -3 -11
	// L  -4  -6  -5  -8 -10  -3  -6  -7  -4   1   6  -5   2  -1  -5  -6  -4  -4  -4   0  -6  -4  -4 -11
	// K  -4   2   0  -2  -9  -1  -2  -5  -3  -4  -5   6   0  -9  -4  -2  -1  -7  -7  -6  -1  -2  -3 -11
	// M  -3  -2  -5  -7  -9  -2  -4  -6  -6   1   2   0  10  -2  -5  -3  -2  -8  -7   0  -6  -3  -3 -11
	// F  -6  -7  -6 -10  -8  -9  -9  -7  -4   0  -1  -9  -2   8  -7  -4  -6  -2   4  -5  -7  -9  -5 -11
	// P   0  -2  -3  -4  -5  -1  -3  -3  -2  -5  -5  -4  -5  -7   7   0  -2  -9  -9  -3  -4  -2  -3 -11
	// S   1  -1   1  -1  -1  -3  -2   0  -3  -4  -6  -2  -3  -4   0   5   2  -3  -5  -3   0  -2  -1 -11
	// T   1  -4   0  -2  -5  -3  -3  -3  -4  -1  -4  -1  -2  -6  -2   2   6  -8  -4  -1  -1  -3  -2 -11
	// W  -9   0  -6 -10 -11  -8 -11 -10  -5  -9  -4  -7  -8  -2  -9  -3  -8  13  -3 -10  -7 -10  -7 -11
	// Y  -5  -7  -3  -7  -2  -8  -6  -9  -1  -4  -4  -7  -7   4  -9  -5  -4  -3   9  -5  -4  -7  -5 -11
	// V  -1  -5  -5  -5  -4  -4  -4  -3  -4   3   0  -6   0  -5  -3  -3  -1 -10  -5   6  -5  -4  -2 -11
	// B  -1  -4   5   5  -8  -1   2  -1   0  -4  -6  -1  -6  -7  -4   0  -1  -7  -4  -5   5   1  -2 -11
	// Z  -1  -2  -1   2  -9   5   5  -3   1  -4  -4  -2  -3  -9  -2  -2  -3 -10  -7  -4   1   5  -3 -11
	// X  -2  -3  -2  -3  -6  -2  -3  -3  -3  -3  -4  -3  -3  -5  -3  -1  -2  -7  -5  -2  -2  -3  -3 -11
	// * -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11   1
	//
	PAM70 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 5, -1, -4, -1, -1, -6, 0, -4, -2, 0, -4, -4, -3, -2, 0, -2, -4, 1, 1, -1, -9, -2, -5, -1, -11},
		/* B */ {0, -1, 5, -8, 5, 2, -7, -1, 0, -4, 0, -1, -6, -6, 5, -4, -1, -4, 0, -1, -5, -7, -2, -4, 1, -11},
		/* C */ {0, -4, -8, 9, -9, -9, -8, -6, -5, -4, 0, -9, -10, -9, -7, -5, -9, -5, -1, -5, -4, -11, -6, -2, -9, -11},
		/* D */ {0, -1, 5, -9, 6, 3, -10, -1, -1, -5, 0, -2, -8, -7, 3, -4, 0, -6, -1, -2, -5, -10, -3, -7, 2, -11},
		/* E */ {0, -1, 2, -9, 3, 6, -9, -2, -2, -4, 0, -2, -6, -4, 0, -3, 2, -5, -2, -3, -4, -11, -3, -6, 5, -11},
		/* F */ {0, -6, -7, -8, -10, -9, 8, -7, -4, 0, 0, -9, -1, -2, -6, -7, -9, -7, -4, -6, -5, -2, -5, 4, -9, -11},
		/* G */ {0, 0, -1, -6, -1, -2, -7, 6, -6, -6, 0, -5, -7, -6, -1, -3, -4, -6, 0, -3, -3, -10, -3, -9, -3, -11},
		/* H */ {0, -4, 0, -5, -1, -2, -4, -6, 8, -6, 0, -3, -4, -6, 1, -2, 2, 0, -3, -4, -4, -5, -3, -1, 1, -11},
		/* I */ {0, -2, -4, -4, -5, -4, 0, -6, -6, 7, 0, -4, 1, 1, -3, -5, -5, -3, -4, -1, 3, -9, -3, -4, -4, -11},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -4, -1, -9, -2, -2, -9, -5, -3, -4, 0, 6, -5, 0, 0, -4, -1, 2, -2, -1, -6, -7, -3, -7, -2, -11},
		/* L */ {0, -4, -6, -10, -8, -6, -1, -7, -4, 1, 0, -5, 6, 2, -5, -5, -3, -6, -6, -4, 0, -4, -4, -4, -4, -11},
		/* M */ {0, -3, -6, -9, -7, -4, -2, -6, -6, 1, 0, 0, 2, 10, -5, -5, -2, -2, -3, -2, 0, -8, -3, -7, -3, -11},
		/* N */ {0, -2, 5, -7, 3, 0, -6, -1, 1, -3, 0, 0, -5, -5, 6, -3, -1, -3, 1, 0, -5, -6, -2, -3, -1, -11},
		/* P */ {0, 0, -4, -5, -4, -3, -7, -3, -2, -5, 0, -4, -5, -5, -3, 7, -1, -2, 0, -2, -3, -9, -3, -9, -2, -11},
		/* Q */ {0, -2, -1, -9, 0, 2, -9, -4, 2, -5, 0, -1, -3, -2, -1, -1, 7, 0, -3, -3, -4, -8, -2, -8, 5, -11},
		/* R */ {0, -4, -4, -5, -6, -5, -7, -6, 0, -3, 0, 2, -6, -2, -3, -2, 0, 8, -1, -4, -5, 0, -3, -7, -2, -11},
		/* S */ {0, 1, 0, -1, -1, -2, -4, 0, -3, -4, 0, -2, -6, -3, 1, 0, -3, -1, 5, 2, -3, -3, -1, -5, -2, -11},
		/* T */ {0, 1, -1, -5, -2, -3, -6, -3, -4, -1, 0, -1, -4, -2, 0, -2, -3, -4, 2, 6, -1, -8, -2, -4, -3, -11},
		/* V */ {0, -1, -5, -4, -5, -4, -5, -3, -4, 3, 0, -6, 0, 0, -5, -3, -4, -5, -3, -1, 6, -10, -2, -5, -4, -11},
		/* W */ {0, -9, -7, -11, -10, -11, -2, -10, -5, -9, 0, -7, -4, -8, -6, -9, -8, 0, -3, -8, -10, 13, -7, -3, -10, -11},
		/* X */ {0, -2, -2, -6, -3, -3, -5, -3, -3, -3, 0, -3, -4, -3, -2, -3, -2, -3, -1, -2, -2, -7, -3, -5, -3, -11},
		/* Y */ {0, -5, -4, -2, -7, -6, 4, -9, -1, -4, 0, -7, -4, -7, -3, -9, -8, -7, -5, -4, -5, -3, -5, 9, -7, -11},
		/* Z */ {0, -1, 1, -9, 2, 5, -9, -3, 1, -4, 0, -2, -4, -3, -1, -2, 5, -2, -2, -3, -4, -10, -3, -7, 5, -11},
		/* * */ {0, -11, -11, -11, -11, -11, -11, -11, -11, -11, 0, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 80 substitution matrix, scale = ln(2)/2 = 0.346574
	// #
	// # Expected score = -2.55, Entropy = 1.44 bits
	// #
	// # Lowest score = -11, Highest score = 13
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A   4  -4  -1  -1  -4  -2  -1   0  -4  -2  -4  -4  -3  -5   0   1   1  -8  -5   0  -1  -1  -1 -11
	// R  -4   7  -2  -5  -5   0  -4  -6   0  -3  -5   2  -2  -6  -2  -1  -3   0  -7  -5  -3  -1  -3 -11
	// N  -1  -2   5   3  -6  -1   0  -1   2  -3  -5   0  -4  -5  -3   1   0  -5  -3  -4   4   0  -1 -11
	// D  -1  -5   3   6  -9   0   4  -1  -1  -4  -7  -2  -6  -9  -4  -1  -2 -10  -7  -5   5   2  -3 -11
	// C  -4  -5  -6  -9   9  -9  -9  -6  -5  -4  -9  -9  -8  -8  -5  -1  -4 -10  -2  -3  -7  -9  -5 -11
	// Q  -2   0  -1   0  -9   7   2  -4   2  -4  -3  -1  -2  -8  -1  -3  -3  -8  -7  -4   0   5  -2 -11
	// E  -1  -4   0   4  -9   2   6  -2  -2  -3  -6  -2  -4  -9  -3  -2  -3 -11  -6  -4   2   5  -2 -11
	// G   0  -6  -1  -1  -6  -4  -2   6  -5  -6  -7  -4  -5  -6  -3   0  -2 -10  -8  -3  -1  -2  -3 -11
	// H  -4   0   2  -1  -5   2  -2  -5   8  -5  -4  -3  -5  -3  -2  -3  -4  -4  -1  -4   0   1  -2 -11
	// I  -2  -3  -3  -4  -4  -4  -3  -6  -5   7   1  -4   1   0  -5  -4  -1  -8  -3   3  -4  -4  -2 -11
	// L  -4  -5  -5  -7  -9  -3  -6  -7  -4   1   6  -5   2   0  -4  -5  -4  -3  -4   0  -6  -4  -3 -11
	// K  -4   2   0  -2  -9  -1  -2  -4  -3  -4  -5   6   0  -9  -4  -2  -1  -7  -6  -5  -1  -1  -3 -11
	// M  -3  -2  -4  -6  -8  -2  -4  -5  -5   1   2   0   9  -2  -5  -3  -2  -7  -6   1  -5  -3  -2 -11
	// F  -5  -6  -5  -9  -8  -8  -9  -6  -3   0   0  -9  -2   8  -7  -4  -5  -2   4  -4  -7  -8  -5 -11
	// P   0  -2  -3  -4  -5  -1  -3  -3  -2  -5  -4  -4  -5  -7   7   0  -2  -9  -8  -3  -3  -2  -2 -11
	// S   1  -1   1  -1  -1  -3  -2   0  -3  -4  -5  -2  -3  -4   0   4   2  -3  -4  -3   0  -2  -1 -11
	// T   1  -3   0  -2  -4  -3  -3  -2  -4  -1  -4  -1  -2  -5  -2   2   5  -8  -4  -1  -1  -3  -1 -11
	// W  -8   0  -5 -10 -10  -8 -11 -10  -4  -8  -3  -7  -7  -2  -9  -3  -8  13  -2 -10  -7  -9  -7 -11
	// Y  -5  -7  -3  -7  -2  -7  -6  -8  -1  -3  -4  -6  -6   4  -8  -4  -4  -2   9  -5  -4  -6  -4 -11
	// V   0  -5  -4  -5  -3  -4  -4  -3  -4   3   0  -5   1  -4  -3  -3  -1 -10  -5   6  -4  -4  -2 -11
	// B  -1  -3   4   5  -7   0   2  -1   0  -4  -6  -1  -5  -7  -3   0  -1  -7  -4  -4   5   2  -2 -11
	// Z  -1  -1   0   2  -9   5   5  -2   1  -4  -4  -1  -3  -8  -2  -2  -3  -9  -6  -4   2   5  -2 -11
	// X  -1  -3  -1  -3  -5  -2  -2  -3  -2  -2  -3  -3  -2  -5  -2  -1  -1  -7  -4  -2  -2  -2  -3 -11
	// * -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11 -11   1
	//
	PAM80 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 4, -1, -4, -1, -1, -5, 0, -4, -2, 0, -4, -4, -3, -1, 0, -2, -4, 1, 1, 0, -8, -1, -5, -1, -11},
		/* B */ {0, -1, 5, -7, 5, 2, -7, -1, 0, -4, 0, -1, -6, -5, 4, -3, 0, -3, 0, -1, -4, -7, -2, -4, 2, -11},
		/* C */ {0, -4, -7, 9, -9, -9, -8, -6, -5, -4, 0, -9, -9, -8, -6, -5, -9, -5, -1, -4, -3, -10, -5, -2, -9, -11},
		/* D */ {0, -1, 5, -9, 6, 4, -9, -1, -1, -4, 0, -2, -7, -6, 3, -4, 0, -5, -1, -2, -5, -10, -3, -7, 2, -11},
		/* E */ {0, -1, 2, -9, 4, 6, -9, -2, -2, -3, 0, -2, -6, -4, 0, -3, 2, -4, -2, -3, -4, -11, -2, -6, 5, -11},
		/* F */ {0, -5, -7, -8, -9, -9, 8, -6, -3, 0, 0, -9, 0, -2, -5, -7, -8, -6, -4, -5, -4, -2, -5, 4, -8, -11},
		/* G */ {0, 0, -1, -6, -1, -2, -6, 6, -5, -6, 0, -4, -7, -5, -1, -3, -4, -6, 0, -2, -3, -10, -3, -8, -2, -11},
		/* H */ {0, -4, 0, -5, -1, -2, -3, -5, 8, -5, 0, -3, -4, -5, 2, -2, 2, 0, -3, -4, -4, -4, -2, -1, 1, -11},
		/* I */ {0, -2, -4, -4, -4, -3, 0, -6, -5, 7, 0, -4, 1, 1, -3, -5, -4, -3, -4, -1, 3, -8, -2, -3, -4, -11},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -4, -1, -9, -2, -2, -9, -4, -3, -4, 0, 6, -5, 0, 0, -4, -1, 2, -2, -1, -5, -7, -3, -6, -1, -11},
		/* L */ {0, -4, -6, -9, -7, -6, 0, -7, -4, 1, 0, -5, 6, 2, -5, -4, -3, -5, -5, -4, 0, -3, -3, -4, -4, -11},
		/* M */ {0, -3, -5, -8, -6, -4, -2, -5, -5, 1, 0, 0, 2, 9, -4, -5, -2, -2, -3, -2, 1, -7, -2, -6, -3, -11},
		/* N */ {0, -1, 4, -6, 3, 0, -5, -1, 2, -3, 0, 0, -5, -4, 5, -3, -1, -2, 1, 0, -4, -5, -1, -3, 0, -11},
		/* P */ {0, 0, -3, -5, -4, -3, -7, -3, -2, -5, 0, -4, -4, -5, -3, 7, -1, -2, 0, -2, -3, -9, -2, -8, -2, -11},
		/* Q */ {0, -2, 0, -9, 0, 2, -8, -4, 2, -4, 0, -1, -3, -2, -1, -1, 7, 0, -3, -3, -4, -8, -2, -7, 5, -11},
		/* R */ {0, -4, -3, -5, -5, -4, -6, -6, 0, -3, 0, 2, -5, -2, -2, -2, 0, 7, -1, -3, -5, 0, -3, -7, -1, -11},
		/* S */ {0, 1, 0, -1, -1, -2, -4, 0, -3, -4, 0, -2, -5, -3, 1, 0, -3, -1, 4, 2, -3, -3, -1, -4, -2, -11},
		/* T */ {0, 1, -1, -4, -2, -3, -5, -2, -4, -1, 0, -1, -4, -2, 0, -2, -3, -3, 2, 5, -1, -8, -1, -4, -3, -11},
		/* V */ {0, 0, -4, -3, -5, -4, -4, -3, -4, 3, 0, -5, 0, 1, -4, -3, -4, -5, -3, -1, 6, -10, -2, -5, -4, -11},
		/* W */ {0, -8, -7, -10, -10, -11, -2, -10, -4, -8, 0, -7, -3, -7, -5, -9, -8, 0, -3, -8, -10, 13, -7, -2, -9, -11},
		/* X */ {0, -1, -2, -5, -3, -2, -5, -3, -2, -2, 0, -3, -3, -2, -1, -2, -2, -3, -1, -1, -2, -7, -3, -4, -2, -11},
		/* Y */ {0, -5, -4, -2, -7, -6, 4, -8, -1, -3, 0, -6, -4, -6, -3, -8, -7, -7, -4, -4, -5, -2, -4, 9, -6, -11},
		/* Z */ {0, -1, 2, -9, 2, 5, -8, -2, 1, -4, 0, -1, -4, -3, 0, -2, 5, -1, -2, -3, -4, -9, -2, -6, 5, -11},
		/* * */ {0, -11, -11, -11, -11, -11, -11, -11, -11, -11, 0, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 80 substitution matrix, scale = 0.0693200
	// #
	// # Expected score = -12.6, Entropy = 1.44 bits
	// #
	// # Lowest score = -53, Highest score = 63
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A  21 -19  -6  -6 -19 -10  -3   1 -20 -10 -18 -18 -13 -27   1   5   5 -42 -25  -2  -6  -5  -6 -53
	// R -19  37 -12 -25 -26   1 -22 -28   2 -16 -26  10  -9 -31  -8  -6 -16   1 -33 -23 -17  -7 -14 -53
	// N  -6 -12  27  13 -31  -5   1  -5   8 -15 -23   2 -22 -27 -14   5  -1 -27 -13 -21  21  -1  -7 -53
	// D  -6 -25  13  30 -43   0  18  -5  -6 -22 -37  -9 -30 -45 -20  -6 -10 -49 -34 -23  24  12 -13 -53
	// C -19 -26 -31 -43  46 -43 -43 -29 -24 -19 -47 -44 -42 -39 -24  -5 -22 -52  -8 -17 -36 -43 -27 -53
	// Q -10   1  -5   0 -43  34  12 -19  12 -22 -14  -4  -9 -39  -4 -13 -14 -39 -35 -19  -2  25 -10 -53
	// E  -3 -22   1  18 -43  12  30  -9  -9 -17 -29 -10 -21 -44 -14  -9 -14 -53 -29 -18  12  24 -11 -53
	// G   1 -28  -5  -5 -29 -19  -9  28 -25 -29 -34 -21 -26 -31 -15   0 -12 -49 -42 -15  -5 -12 -13 -53
	// H -20   2   8  -6 -24  12  -9 -25  39 -26 -18 -14 -27 -17  -9 -14 -19 -22  -6 -19   2   4 -12 -53
	// I -10 -16 -15 -22 -19 -22 -17 -29 -26  34   4 -18   5  -1 -24 -18  -3 -42 -16  16 -18 -19 -11 -53
	// L -18 -26 -23 -37 -47 -14 -29 -34 -18   4  30 -25  12  -1 -22 -25 -19 -17 -19   0 -29 -20 -16 -53
	// K -18  10   2  -9 -44  -4 -10 -21 -14 -18 -25  28   0 -43 -18  -8  -6 -33 -31 -26  -3  -7 -13 -53
	// M -13  -9 -22 -30 -42  -9 -21 -26 -27   5  12   0  47  -8 -23 -15  -9 -37 -30   3 -26 -15 -12 -53
	// F -27 -31 -27 -45 -39 -39 -44 -31 -17  -1  -1 -43  -8  41 -33 -21 -26 -10  19 -20 -34 -42 -23 -53
	// P   1  -8 -14 -20 -24  -4 -14 -15  -9 -24 -22 -18 -23 -33  35   1  -8 -43 -41 -15 -17  -9 -12 -53
	// S   5  -6   5  -6  -5 -13  -9   0 -14 -18 -25  -8 -15 -21   1  22   8 -15 -21 -15   0 -10  -6 -53
	// T   5 -16  -1 -10 -22 -14 -14 -12 -19  -3 -19  -6  -9 -26  -8   8  27 -39 -20  -4  -5 -14  -7 -53
	// W -42   1 -27 -49 -52 -39 -53 -49 -22 -42 -17 -33 -37 -10 -43 -15 -39  63 -12 -49 -35 -45 -33 -53
	// Y -25 -33 -13 -34  -8 -35 -29 -42  -6 -16 -19 -31 -30  19 -41 -21 -20 -12  45 -23 -20 -31 -22 -53
	// V  -2 -23 -21 -23 -17 -19 -18 -15 -19  16   0 -26   3 -20 -15 -15  -4 -49 -23  29 -22 -19 -11 -53
	// B  -6 -17  21  24 -36  -2  12  -5   2 -18 -29  -3 -26 -34 -17   0  -5 -35 -20 -22  23   8 -10 -53
	// Z  -5  -7  -1  12 -43  25  24 -12   4 -19 -20  -7 -15 -42  -9 -10 -14 -45 -31 -19   8  25 -11 -53
	// X  -6 -14  -7 -13 -27 -10 -11 -13 -12 -11 -16 -13 -12 -23 -12  -6  -7 -33 -22 -11 -10 -11 -13 -53
	// * -53 -53 -53 -53 -53 -53 -53 -53 -53 -53 -53 -53 -53 -53 -53 -53 -53 -53 -53 -53 -53 -53 -53   1
	//
	PAM80_cdi = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 21, -6, -19, -6, -3, -27, 1, -20, -10, 0, -18, -18, -13, -6, 1, -10, -19, 5, 5, -2, -42, -6, -25, -5, -53},
		/* B */ {0, -6, 23, -36, 24, 12, -34, -5, 2, -18, 0, -3, -29, -26, 21, -17, -2, -17, 0, -5, -22, -35, -10, -20, 8, -53},
		/* C */ {0, -19, -36, 46, -43, -43, -39, -29, -24, -19, 0, -44, -47, -42, -31, -24, -43, -26, -5, -22, -17, -52, -27, -8, -43, -53},
		/* D */ {0, -6, 24, -43, 30, 18, -45, -5, -6, -22, 0, -9, -37, -30, 13, -20, 0, -25, -6, -10, -23, -49, -13, -34, 12, -53},
		/* E */ {0, -3, 12, -43, 18, 30, -44, -9, -9, -17, 0, -10, -29, -21, 1, -14, 12, -22, -9, -14, -18, -53, -11, -29, 24, -53},
		/* F */ {0, -27, -34, -39, -45, -44, 41, -31, -17, -1, 0, -43, -1, -8, -27, -33, -39, -31, -21, -26, -20, -10, -23, 19, -42, -53},
		/* G */ {0, 1, -5, -29, -5, -9, -31, 28, -25, -29, 0, -21, -34, -26, -5, -15, -19, -28, 0, -12, -15, -49, -13, -42, -12, -53},
		/* H */ {0, -20, 2, -24, -6, -9, -17, -25, 39, -26, 0, -14, -18, -27, 8, -9, 12, 2, -14, -19, -19, -22, -12, -6, 4, -53},
		/* I */ {0, -10, -18, -19, -22, -17, -1, -29, -26, 34, 0, -18, 4, 5, -15, -24, -22, -16, -18, -3, 16, -42, -11, -16, -19, -53},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -18, -3, -44, -9, -10, -43, -21, -14, -18, 0, 28, -25, 0, 2, -18, -4, 10, -8, -6, -26, -33, -13, -31, -7, -53},
		/* L */ {0, -18, -29, -47, -37, -29, -1, -34, -18, 4, 0, -25, 30, 12, -23, -22, -14, -26, -25, -19, 0, -17, -16, -19, -20, -53},
		/* M */ {0, -13, -26, -42, -30, -21, -8, -26, -27, 5, 0, 0, 12, 47, -22, -23, -9, -9, -15, -9, 3, -37, -12, -30, -15, -53},
		/* N */ {0, -6, 21, -31, 13, 1, -27, -5, 8, -15, 0, 2, -23, -22, 27, -14, -5, -12, 5, -1, -21, -27, -7, -13, -1, -53},
		/* P */ {0, 1, -17, -24, -20, -14, -33, -15, -9, -24, 0, -18, -22, -23, -14, 35, -4, -8, 1, -8, -15, -43, -12, -41, -9, -53},
		/* Q */ {0, -10, -2, -43, 0, 12, -39, -19, 12, -22, 0, -4, -14, -9, -5, -4, 34, 1, -13, -14, -19, -39, -10, -35, 25, -53},
		/* R */ {0, -19, -17, -26, -25, -22, -31, -28, 2, -16, 0, 10, -26, -9, -12, -8, 1, 37, -6, -16, -23, 1, -14, -33, -7, -53},
		/* S */ {0, 5, 0, -5, -6, -9, -21, 0, -14, -18, 0, -8, -25, -15, 5, 1, -13, -6, 22, 8, -15, -15, -6, -21, -10, -53},
		/* T */ {0, 5, -5, -22, -10, -14, -26, -12, -19, -3, 0, -6, -19, -9, -1, -8, -14, -16, 8, 27, -4, -39, -7, -20, -14, -53},
		/* V */ {0, -2, -22, -17, -23, -18, -20, -15, -19, 16, 0, -26, 0, 3, -21, -15, -19, -23, -15, -4, 29, -49, -11, -23, -19, -53},
		/* W */ {0, -42, -35, -52, -49, -53, -10, -49, -22, -42, 0, -33, -17, -37, -27, -43, -39, 1, -15, -39, -49, 63, -33, -12, -45, -53},
		/* X */ {0, -6, -10, -27, -13, -11, -23, -13, -12, -11, 0, -13, -16, -12, -7, -12, -10, -14, -6, -7, -11, -33, -13, -22, -11, -53},
		/* Y */ {0, -25, -20, -8, -34, -29, 19, -42, -6, -16, 0, -31, -19, -30, -13, -41, -35, -33, -21, -20, -23, -12, -22, 45, -31, -53},
		/* Z */ {0, -5, 8, -43, 12, 24, -42, -12, 4, -19, 0, -7, -20, -15, -1, -9, 25, -7, -10, -14, -19, -45, -11, -31, 25, -53},
		/* * */ {0, -53, -53, -53, -53, -53, -53, -53, -53, -53, 0, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, 1},
	}

	// #
	// # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	// #
	// # PAM 90 substitution matrix, scale = ln(2)/2 = 0.346574
	// #
	// # Expected score = -2.26, Entropy = 1.30 bits
	// #
	// # Lowest score = -10, Highest score = 13
	// #
	//     A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   *
	// A   4  -4  -1  -1  -3  -2   0   0  -4  -2  -3  -3  -2  -5   0   1   1  -8  -5   0  -1  -1  -1 -10
	// R  -4   7  -2  -5  -5   0  -4  -5   1  -3  -5   2  -2  -6  -1  -1  -3   0  -6  -4  -3  -1  -2 -10
	// N  -1  -2   5   3  -6  -1   0  -1   2  -3  -4   1  -4  -5  -2   1   0  -5  -2  -4   4   0  -1 -10
	// D  -1  -5   3   6  -8   0   4  -1  -1  -4  -7  -2  -5  -8  -4  -1  -2  -9  -6  -4   5   3  -2 -10
	// C  -3  -5  -6  -8   9  -8  -8  -5  -5  -3  -9  -8  -8  -7  -5  -1  -4 -10  -1  -3  -7  -8  -5 -10
	// Q  -2   0  -1   0  -8   6   2  -3   2  -4  -3  -1  -2  -7  -1  -2  -3  -7  -6  -4   0   5  -2 -10
	// E   0  -4   0   4  -8   2   6  -1  -1  -3  -5  -2  -4  -8  -2  -2  -2 -10  -6  -3   2   5  -2 -10
	// G   0  -5  -1  -1  -5  -3  -1   5  -5  -5  -6  -4  -5  -6  -3   0  -2  -9  -8  -3  -1  -2  -2 -10
	// H  -4   1   2  -1  -5   2  -1  -5   8  -5  -3  -2  -5  -3  -2  -3  -3  -4  -1  -4   1   1  -2 -10
	// I  -2  -3  -3  -4  -3  -4  -3  -5  -5   6   1  -3   1   0  -4  -3   0  -8  -3   3  -3  -3  -2 -10
	// L  -3  -5  -4  -7  -9  -3  -5  -6  -3   1   6  -5   2   0  -4  -5  -3  -3  -3   0  -5  -4  -3 -10
	// K  -3   2   1  -2  -8  -1  -2  -4  -2  -3  -5   5   0  -8  -3  -1  -1  -6  -6  -5   0  -1  -2 -10
	// M  -2  -2  -4  -5  -8  -2  -4  -5  -5   1   2   0   9  -1  -4  -3  -2  -7  -6   1  -5  -3  -2 -10
	// F  -5  -6  -5  -8  -7  -7  -8  -6  -3   0   0  -8  -1   8  -6  -4  -5  -2   4  -4  -6  -8  -4 -10
	// P   0  -1  -2  -4  -5  -1  -2  -3  -2  -4  -4  -3  -4  -6   7   0  -1  -8  -8  -3  -3  -2  -2 -10
	// S   1  -1   1  -1  -1  -2  -2   0  -3  -3  -5  -1  -3  -4   0   4   2  -3  -4  -3   0  -2  -1 -10
	// T   1  -3   0  -2  -4  -3  -2  -2  -3   0  -3  -1  -2  -5  -1   2   5  -7  -4  -1  -1  -2  -1 -10
	// W  -8   0  -5  -9 -10  -7 -10  -9  -4  -8  -3  -6  -7  -2  -8  -3  -7  13  -2  -9  -7  -8  -6 -10
	// Y  -5  -6  -2  -6  -1  -6  -6  -8  -1  -3  -3  -6  -6   4  -8  -4  -4  -2   9  -4  -4  -6  -4 -10
	// V   0  -4  -4  -4  -3  -4  -3  -3  -4   3   0  -5   1  -4  -3  -3  -1  -9  -4   6  -4  -3  -2 -10
	// B  -1  -3   4   5  -7   0   2  -1   1  -3  -5   0  -5  -6  -3   0  -1  -7  -4  -4   4   2  -2 -10
	// Z  -1  -1   0   3  -8   5   5  -2   1  -3  -4  -1  -3  -8  -2  -2  -2  -8  -6  -3   2   5  -2 -10
	// X  -1  -2  -1  -2  -5  -2  -2  -2  -2  -2  -3  -2  -2  -4  -2  -1  -1  -6  -4  -2  -2  -2  -2 -10
	// * -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10   1
	//
	PAM90 = [][]int{
		/*       - A B C D E F G H I J K L M N P Q R S T V W X Y Z * */
		/* - */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* A */ {0, 4, -1, -3, -1, 0, -5, 0, -4, -2, 0, -3, -3, -2, -1, 0, -2, -4, 1, 1, 0, -8, -1, -5, -1, -10},
		/* B */ {0, -1, 4, -7, 5, 2, -6, -1, 1, -3, 0, 0, -5, -5, 4, -3, 0, -3, 0, -1, -4, -7, -2, -4, 2, -10},
		/* C */ {0, -3, -7, 9, -8, -8, -7, -5, -5, -3, 0, -8, -9, -8, -6, -5, -8, -5, -1, -4, -3, -10, -5, -1, -8, -10},
		/* D */ {0, -1, 5, -8, 6, 4, -8, -1, -1, -4, 0, -2, -7, -5, 3, -4, 0, -5, -1, -2, -4, -9, -2, -6, 3, -10},
		/* E */ {0, 0, 2, -8, 4, 6, -8, -1, -1, -3, 0, -2, -5, -4, 0, -2, 2, -4, -2, -2, -3, -10, -2, -6, 5, -10},
		/* F */ {0, -5, -6, -7, -8, -8, 8, -6, -3, 0, 0, -8, 0, -1, -5, -6, -7, -6, -4, -5, -4, -2, -4, 4, -8, -10},
		/* G */ {0, 0, -1, -5, -1, -1, -6, 5, -5, -5, 0, -4, -6, -5, -1, -3, -3, -5, 0, -2, -3, -9, -2, -8, -2, -10},
		/* H */ {0, -4, 1, -5, -1, -1, -3, -5, 8, -5, 0, -2, -3, -5, 2, -2, 2, 1, -3, -3, -4, -4, -2, -1, 1, -10},
		/* I */ {0, -2, -3, -3, -4, -3, 0, -5, -5, 6, 0, -3, 1, 1, -3, -4, -4, -3, -3, 0, 3, -8, -2, -3, -3, -10},
		/* J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		/* K */ {0, -3, 0, -8, -2, -2, -8, -4, -2, -3, 0, 5, -5, 0, 1, -3, -1, 2, -1, -1, -5, -6, -2, -6, -1, -10},
		/* L */ {0, -3, -5, -9, -7, -5, 0, -6, -3, 1, 0, -5, 6, 2, -4, -4, -3, -5, -5, -3, 0, -3, -3, -3, -4, -10},
		/* M */ {0, -2, -5, -8, -5, -4, -1, -5, -5, 1, 0, 0, 2, 9, -4, -4, -2, -2, -3, -2, 1, -7, -2, -6, -3, -10},
		/* N */ {0, -1, 4, -6, 3, 0, -5, -1, 2, -3, 0, 1, -4, -4, 5, -2, -1, -2, 1, 0, -4, -5, -1, -2, 0, -10},
		/* P */ {0, 0, -3, -5, -4, -2, -6, -3, -2, -4, 0, -3, -4, -4, -2, 7, -1, -1, 0, -1, -3, -8, -2, -8, -2, -10},
		/* Q */ {0, -2, 0, -8, 0, 2, -7, -3, 2, -4, 0, -1, -3, -2, -1, -1, 6, 0, -2, -3, -4, -7, -2, -6, 5, -10},
		/* R */ {0, -4, -3, -5, -5, -4, -6, -5, 1, -3, 0, 2, -5, -2, -2, -1, 0, 7, -1, -3, -4, 0, -2, -6, -1, -10},
		/* S */ {0, 1, 0, -1, -1, -2, -4, 0, -3, -3, 0, -1, -5, -3, 1, 0, -2, -1, 4, 2, -3, -3, -1, -4, -2, -10},
		/* T */ {0, 1, -1, -4, -2, -2, -5, -2, -3, 0, 0, -1, -3, -2, 0, -1, -3, -3, 2, 5, -1, -7, -1, -4, -2, -10},
		/* V */ {0, 0, -4, -3, -4, -3, -4, -3, -4, 3, 0, -5, 0, 1, -4, -3, -4, -4, -3, -1, 6, -9, -2, -4, -3, -10},
		/* W */ {0, -8, -7, -10, -9, -10, -2, -9, -4, -8, 0, -6, -3, -7, -5, -8, -7, 0, -3, -7, -9, 13, -6, -2, -8, -10},
		/* X */ {0, -1, -2, -5, -2, -2, -4, -2, -2, -2, 0, -2, -3, -2, -1, -2, -2, -2, -1, -1, -2, -6, -2, -4, -2, -10},
		/* Y */ {0, -5, -4, -1, -6, -6, 4, -8, -1, -3, 0, -6, -3, -6, -2, -8, -6, -6, -4, -4, -4, -2, -4, 9, -6, -10},
		/* Z */ {0, -1, 2, -8, 3, 5, -8, -2, 1, -3, 0, -1, -4, -3, 0, -2, 5, -1, -2, -2, -3, -8, -2, -6, 5, -10},
		/* * */ {0, -10, -10, -10, -10, -10, -10, -10, -10, -10, 0, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, 1},
	}
)
