# JTS Release Guide

This guide is intended for JTS project maintainers, 
to assist them in preparing releases of the project.

## Release Checklist

### Preparation

1. Locate the [Release Milestone](https://github.com/locationtech/jts/milestones) for the release.
   
2. Apply this milestone Issues and PRs included in the release.

3. Update the [Version History](https://github.com/locationtech/jts/blob/master/doc/JTS_Version_History.md)

   1. Record significant changes (should have been done ongoing)
   
   2. Enter date of release

4. Start an eclipse release process

   Example review: [1.17.0-release-review](https://projects.eclipse.org/projects/locationtech.jts/reviews/1.17.0-release-review) page
   
   * Use the text from [Version History](https://github.com/locationtech/jts/blob/master/doc/JTS_Version_History.md) to quickly write the describe the release.
   
   * Email review page to locationtech-pmc [like this](locationtech-pmc/msg01095.html) for PMC approval.

   * Email review page emo@eclipse.org when ready, to save time you can link to the PMC approval thread.
   
   * EMO opens a [bug ticket like this](https://bugs.eclipse.org/bugs/show_bug.cgi?id=564358) to track progress
   
   The release process takes around two weeks, and are scheduled for the 1st and 15th of each month.

### Update Artifacts

On master:

1. Before you start check that the Maven build executes with no errors

   ```
   mvn clean install
   ```

2. Set the version number in Java class: [`org.locationtech.jts.JTSVersion`](https://github.com/locationtech/jts/blob/master/modules/core/src/main/java/org/locationtech/jts/JTSVersion.java)
   
   Change SNAPSHOT version:
   
   ```
   private static final String RELEASE_INFO = "SNAPSHOT";
   ```
   
   To release version:
   
   ```
   private static final String RELEASE_INFO = "";
   ```

2. Update version number in Maven POMs (run the Maven release plugin at project root:
   
   ```
   mvn versions:set -DnewVersion=1.19.0
   ```

3. Edit ``build-tools/pom.xml`` by hand, and compile to test.
   
   ```
   mvn clean install
   ```
   
3. Commit this change.

   ```
   git add .
   git commit -m "Release version 1.19.0"
   git push
   ```
      
4. Tag this commit, and push the tag to GitHub.

   ```
   git tag -a 1.19.0 -m "Release version 1.19.0"
   git push --tags
   ```

   This is the commit that will form the GitHub release below.

### Create Release Artifacts

1. Before you start double check that you have `gpg` installed and configured, with your public key distributed.
   
   References: [Working with PGP Signatures](https://central.sonatype.org/pages/working-with-pgp-signatures.html)
   

2. The `gpg-agent` will remember a passphrase for a short duration.
   
   To interact with the agent (so it asks you the passphrase):
   
   ```
   gpg --use-agent --armor --detach-sign --output - pom.xml
   ```
   
   Reference: [Configuring GPG/PGP for Maven Releases to Sonatype on Mac OS X](https://nblair.github.io/2015/10/29/maven-gpg-sonatype/)
    
2. Execute the final Maven release build which will sign jars:
   
   ```
   mvn clean install -Drelease
   ```

### Deploy the Release

1. Deploy to Maven Central, using credentials in your `~/.m2/settings.xml`:
   
   ```
   <server>
      <id>ossrh</id>
      <username>jira_user</username>
      <password>jira_password</password>
   </server>
   ```
   
   Reference: [Deploying to OSSRH with Apache Maven](https://central.sonatype.org/pages/apache-maven.html)
   
2. Deploy to Maven Central with the release property and profile 
   
   ```
   mvn deploy -Drelease
   ```

4. Create a [JTS GitHub release](https://github.com/locationtech/jts/releases)

   1. Navigate to https://github.com/locationtech/jts/releases and use "Draft new Release"
      based on your tag. 
   
   2. Copy the release notes from `JTS_Version_History.md`
   
      Example: [1.17.0](https://github.com/locationtech/jts/releases/tag/1.17.0]

   3. Add release artifacts (from the `target` folders):
      
      * jts-core-1.18.0-javadoc.jar
      * jts-core-1.18.0-sources.jar
      * jts-core-1.18.0.jar
      * jts-io-common-1.18.0-javadoc.jar
      * jts-io-common-1.18.0-sources.jar
      * jts-io-common-1.18.0.jar
      * JTSTestBuilder.jar
   
   4. Tip: Mark as a draft release (until Eclipse review process completes)

### Publish Javadocs

Update [Javadoc on JTS Github IO](http://locationtech.github.io/jts/javadoc/):

1. Javadoc is generated by the Maven build above.
   
2. Update branch [`gh-pages`](https://github.com/locationtech/jts/tree/gh-pages):
   
   ```bash
   cd ..
   git clone https://github.com/locationtech/jts.git jts-docs
   cd jts-docs
   git checkout --track origin/gh-pages
   git mv javadoc javadoc-1.18.0
   git mv javadoc-io javadoc-io-1.18.0
   cp -r ../jts/modules/core/target/apidocs/ javadoc  
   cp -r ../jts/modules/io/common/target/apidocs javadoc-io
   ```
   
   Edit ``index.html`` with new details:
   
   ```
   <li>Javadoc for JTS 1.19.0 (
       <a href="javadoc/index.html" target="javadoc">jts-core</a> |
       <a href="javadoc-io/index.html" target="javadoc">jts-io-common</a>)</li>
   <li>Javadoc for JTS 1.18.0 (
       <a href="javadoc-1.18.0/index.html" target="javadoc">jts-core</a> |
       <a href="javadoc-io-1.18.0/index.html" target="javadoc">jts-io-common</a>)</li>
   ```
   
   Commit 
   ```
   git add .
   git commit -m "JTS 1.19.0 javadocs"
   ```

### Post release

Update master to the next release version:

1. Set the version number in Java class: [`org.locationtech.jts.JTSVersion`](https://github.com/locationtech/jts/blob/master/modules/core/src/main/java/org/locationtech/jts/JTSVersion.java)
   
   Change release version:
   
   ```
   public static final int MAJOR = 1;
   public static final int MINOR = 19;
   public static final int PATCH = 0;
   private static final String RELEASE_INFO = "";
   ```
   
   To next SNAPSHOT version:
   
   ```
   public static final int MAJOR = 1;
   public static final int MINOR = 20;
   public static final int PATCH = 0;
   private static final String RELEASE_INFO = "SNAPSHOT";
   ```
   
2. Update version number in Maven POMs (run the Maven release plugin at project root:
   
   ```
   mvn versions:set -DnewVersion=1.20.0-SNAPSHOT
   ```
   
3. Edit ``build-tools/pom.xml`` by hand, and compile to test.
   
   ```
   mvn clean install
   ```
 
3. Compile to test, and commit this change.

   ```
   git add .
   git commit -m "Version 1.20.0-SNAPSHOT"
   git push
   ```  
   
4. Add a new version entry to the [Version History](https://github.com/locationtech/jts/blob/master/doc/JTS_Version_History.md)

### Announcing

* Message to [JTS Dev mail list](https://accounts.eclipse.org/mailing-list/jts-dev)
* Comment on [Gitter channel](https://gitter.im/locationtech/jts)
* Social media?
* Others?
