.\" $NCDId: @(#)auscope.man,v 1.6 1994/07/26 00:36:26 greg Exp $
.TH AUSCOPE 1 "" ""
.SH NAME
auscope \- Network Audio System Protocol Filter
.IX auscope#(1) "" "\fLauscope\fP(1)"
.SH SYNOPSIS
.B auscope
[ option ] ...
.SH DESCRIPTION
.I auscope
is an audio protocol filter that can be used to view the network
packets being sent between an audio application and an audio server.
.PP
\fIauscope\fP is written in \fIPerl\fP, so you must have \fIPerl\fP
installed on your machine in order to run \fIauscope\fP.  If your
\fIPerl\fP executable is not installed as /usr/local/bin/perl, you
should modify the first line of the \fIauscope\fP script to reflect
the \fIPerl\fP executable's location.  Or, you can invoke \fIauscope\fP as
.PP
\fBperl auscope\fP [ option ] ...
.PP
assuming the \fIPerl\fP executable is in your path.
.PP
To operate, 
.I 
auscope
must know the port on which it should listen for 
audio clients, the name of the desktop machine on which the audio server 
is running and the port to use to connect to the audio server.  Both the 
output port (server) and input port (client) are automatically biased by 
8000.  The output port defaults to 0 and the input port defaults to 1. 
.SH ARGUMENTS
.PP
.TP 8
.BI \-i "<input-port>"
Specify the port that \fIauscope\fP will use to take requests from clients. 
.PP
.TP 8
.BI \-o "<output-port>"
Determines the port that \fIauscope\fP will use to connect to the audio 
server. 
.PP
.TP 8
.BI \-h "<audio server name>"
Determines the desktop machine name that \fIauscope\fP will use to find 
the audio server.
.PP
.TP 8
.BI \-v "<print-level>"
Determines the level of printing which \fIauscope\fP will provide.  The
print-level can be 0 or 1.  The larger
numbers provide greater output detail. 
.SH EXAMPLES
.PP
In the following example, \fImcxterm\fP is the name of the desktop machine 
running the audio server, which is connected to the TCP/IP network host
\fItcphost\fP.  \fIauscope\fP 
uses the desktop machine with the 
.B
-h
command line option, will listen for client requests on port 
8001 and connect to the audio server on port 8000.
.PP
Ports (file descriptors) on the network host are used to read and 
write the audio protocol.  The audio client 
.I
auplay
will connect to the audio server via the TCP/IP network host \fItcphost\fP 
and port \fI8001\fP:
.IP 
auscope -i1 -o0 -hmcxterm
.IP
auplay -audio tcp/tcphost:8001 dial.snd 
.PP
In the following example, the auscope verbosity is increased to 1,
and the audio client 
.I
autool 
will connect to the audio server via the network host 
\fItcphost\fP, while displaying its graphical interface on another 
server \fIlabmcx\fP:
.IP
auscope -i1 -o0 -hmcxterm -v1
.IP
autool -audio tcp/tcphost:8001 -display labmcx:0.0
.SH "SEE ALSO"
nas(1), perl(1)
.SH COPYRIGHT
Copyright 1994 Network Computing Devices, Inc.
.SH AUTHOR
Greg Renda, Network Computing Devices, Inc.
