/*******************************************************************************
 * Copyright (c) 2012, 2020 Original authors and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Original authors and others - initial API and implementation
 ******************************************************************************/
package org.eclipse.nebula.widgets.nattable.layer;

import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;

/**
 * Object interested in receiving events related to a {@link ILayer}.
 */
public interface ILayerListener {

    /**
     * Handle an event notification from an {@link ILayer}
     *
     * @param event
     *            the event
     */
    public void handleLayerEvent(ILayerEvent event);

}
