# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import serialize
from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class FlowValidateList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version):
        """
        Initialize the FlowValidateList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.studio.v2.flow_validate.FlowValidateList
        :rtype: twilio.rest.studio.v2.flow_validate.FlowValidateList
        """
        super(FlowValidateList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Flows/Validate'.format(**self._solution)

    def update(self, friendly_name, status, definition,
               commit_message=values.unset):
        """
        Update the FlowValidateInstance

        :param unicode friendly_name: The friendly_name
        :param FlowValidateInstance.Status status: The status
        :param dict definition: The definition
        :param unicode commit_message: The commit_message

        :returns: The updated FlowValidateInstance
        :rtype: twilio.rest.studio.v2.flow_validate.FlowValidateInstance
        """
        data = values.of({
            'FriendlyName': friendly_name,
            'Status': status,
            'Definition': serialize.object(definition),
            'CommitMessage': commit_message,
        })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return FlowValidateInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Studio.V2.FlowValidateList>'


class FlowValidatePage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the FlowValidatePage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.studio.v2.flow_validate.FlowValidatePage
        :rtype: twilio.rest.studio.v2.flow_validate.FlowValidatePage
        """
        super(FlowValidatePage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of FlowValidateInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.studio.v2.flow_validate.FlowValidateInstance
        :rtype: twilio.rest.studio.v2.flow_validate.FlowValidateInstance
        """
        return FlowValidateInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Studio.V2.FlowValidatePage>'


class FlowValidateInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    class Status(object):
        DRAFT = "draft"
        PUBLISHED = "published"

    def __init__(self, version, payload):
        """
        Initialize the FlowValidateInstance

        :returns: twilio.rest.studio.v2.flow_validate.FlowValidateInstance
        :rtype: twilio.rest.studio.v2.flow_validate.FlowValidateInstance
        """
        super(FlowValidateInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {'valid': payload.get('valid'), }

        # Context
        self._context = None
        self._solution = {}

    @property
    def valid(self):
        """
        :returns: The valid
        :rtype: bool
        """
        return self._properties['valid']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Studio.V2.FlowValidateInstance>'
