% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printers.R
\name{flextable_to_rmd}
\alias{flextable_to_rmd}
\title{Print a flextable inside knitr loops and conditionals}
\usage{
flextable_to_rmd(x, ...)
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{...}{unused argument}
}
\description{
Print flextable in R Markdown or Quarto documents
within \code{for} loop or \code{if} statement.

The function is particularly useful when you want
to generate flextable in a loop from a R Markdown document.

Inside R Markdown document, chunk option \code{results} must be
set to 'asis'.

See \link{knit_print.flextable} for more details.
}
\examples{
\dontrun{
library(rmarkdown)
if (pandoc_available() &&
  pandoc_version() > numeric_version("2")) {
  demo_loop <- system.file(
    package = "flextable",
    "examples/rmd",
    "loop_with_flextable.Rmd"
  )
  rmd_file <- tempfile(fileext = ".Rmd")
  file.copy(demo_loop, to = rmd_file, overwrite = TRUE)
  render(
    input = rmd_file, output_format = "html_document",
    output_file = "loop_with_flextable.html"
  )
}
}
}
\seealso{
Other flextable print function: 
\code{\link{df_printer}()},
\code{\link{gen_grob}()},
\code{\link{htmltools_value}()},
\code{\link{knit_print.flextable}()},
\code{\link{plot.flextable}()},
\code{\link{print.flextable}()},
\code{\link{save_as_docx}()},
\code{\link{save_as_html}()},
\code{\link{save_as_image}()},
\code{\link{save_as_pptx}()},
\code{\link{save_as_rtf}()},
\code{\link{to_html.flextable}()},
\code{\link{wrap_flextable}()}
}
\concept{flextable print function}
