% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_string.R
\name{string_width}
\alias{string_width}
\title{Calculate the width of a string, ignoring new-lines}
\usage{
string_width(
  strings,
  family = "",
  italic = FALSE,
  weight = "normal",
  width = "undefined",
  size = 12,
  res = 72,
  include_bearing = TRUE,
  path = NULL,
  index = 0,
  bold = deprecated()
)
}
\arguments{
\item{strings}{A character vector of strings}

\item{family}{The name of the font families to match}

\item{italic}{logical indicating the font slant}

\item{weight}{The weight to query for, either in numbers (\code{0}, \code{100}, \code{200},
\code{300}, \code{400}, \code{500}, \code{600}, \code{700}, \code{800}, or \code{900}) or strings (\code{"undefined"},
\code{"thin"}, \code{"ultralight"}, \code{"light"}, \code{"normal"}, \code{"medium"}, \code{"semibold"},
\code{"bold"}, \code{"ultrabold"}, or \code{"heavy"}). \code{NA} will be interpreted as
\code{"undefined"}/\code{0}}

\item{width}{The width to query for either in numbers (\code{0}, \code{1}, \code{2},
\code{3}, \code{4}, \code{5}, \code{6}, \code{7}, \code{8}, or \code{9}) or strings (\code{"undefined"},
\code{"ultracondensed"}, \code{"extracondensed"}, \code{"condensed"}, \code{"semicondensed"},
\code{"normal"}, \code{"semiexpanded"}, \code{"expanded"}, \code{"extraexpanded"}, or
\code{"ultraexpanded"}). \code{NA} will be interpreted as \code{"undefined"}/\code{0}}

\item{size}{The pointsize of the font to use for size related measures}

\item{res}{The ppi of the size related measures}

\item{include_bearing}{Logical, should left and right bearing be included in
the string width?}

\item{path, index}{path and index of a font file to circumvent lookup based on
family and style}

\item{bold}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{weight = "bold"} instead}
}
\value{
A numeric vector giving the width of the strings in pixels. Use the
provided \code{res} value to convert it into absolute values.
}
\description{
This is a very simple alternative to \code{\link[=shape_string]{shape_string()}} that simply calculates
the width of strings without taking any newline into account. As such it is
suitable to calculate the width of words or lines that has already been
splitted by \verb{\\n}. Input is recycled to the length of \code{strings}.
}
\examples{
strings <- c('A short string', 'A very very looong string')
string_width(strings)

}
