
// THIS FILE IS AUTOMATICALLY GENERATED; DO NOT EDIT

//! AST walker. Each overridden visit method has full control over what
//! happens with its node, it can do its own traversal of the node's children,
//! call `visit::walk_*` to apply the default traversal algorithm, or prevent
//! deeper traversal by doing nothing.

use *;


#[cfg(feature = "full")]
macro_rules! full {
    ($e:expr) => { $e }
}

#[cfg(not(feature = "full"))]
macro_rules! full {
    ($e:expr) => { unreachable!() }
}


/// Each method of the Visitor trait is a hook to be potentially
/// overridden.  Each method's default implementation recursively visits
/// the substructure of the input via the corresponding `walk` method;
/// e.g. the `visit_mod` method by default calls `visit::walk_mod`.
///
/// If you want to ensure that your code handles every variant
/// explicitly, you need to override each method.  (And you also need
/// to monitor future changes to `Visitor` in case a new method with a
/// new default implementation gets introduced.)
pub trait Visitor {

fn visit_abi(&mut self, i: &Abi) { visit_abi(self, i) }

fn visit_abi_kind(&mut self, i: &AbiKind) { visit_abi_kind(self, i) }

fn visit_angle_bracketed_parameter_data(&mut self, i: &AngleBracketedParameterData) { visit_angle_bracketed_parameter_data(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_arg_captured(&mut self, i: &ArgCaptured) { visit_arg_captured(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_arg_self(&mut self, i: &ArgSelf) { visit_arg_self(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_arg_self_ref(&mut self, i: &ArgSelfRef) { visit_arg_self_ref(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_arm(&mut self, i: &Arm) { visit_arm(self, i) }

fn visit_attr_style(&mut self, i: &AttrStyle) { visit_attr_style(self, i) }

fn visit_attribute(&mut self, i: &Attribute) { visit_attribute(self, i) }

fn visit_bare_fn_arg(&mut self, i: &BareFnArg) { visit_bare_fn_arg(self, i) }

fn visit_bare_fn_arg_name(&mut self, i: &BareFnArgName) { visit_bare_fn_arg_name(self, i) }

fn visit_bare_fn_ty(&mut self, i: &BareFnTy) { visit_bare_fn_ty(self, i) }

fn visit_bin_op(&mut self, i: &BinOp) { visit_bin_op(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_binding_mode(&mut self, i: &BindingMode) { visit_binding_mode(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_block(&mut self, i: &Block) { visit_block(self, i) }

fn visit_body(&mut self, i: &Body) { visit_body(self, i) }

fn visit_body_enum(&mut self, i: &BodyEnum) { visit_body_enum(self, i) }

fn visit_body_struct(&mut self, i: &BodyStruct) { visit_body_struct(self, i) }

fn visit_bound_lifetimes(&mut self, i: &BoundLifetimes) { visit_bound_lifetimes(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_capture_by(&mut self, i: &CaptureBy) { visit_capture_by(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_constness(&mut self, i: &Constness) { visit_constness(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_defaultness(&mut self, i: &Defaultness) { visit_defaultness(self, i) }

fn visit_derive_input(&mut self, i: &DeriveInput) { visit_derive_input(self, i) }

fn visit_expr(&mut self, i: &Expr) { visit_expr(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_addr_of(&mut self, i: &ExprAddrOf) { visit_expr_addr_of(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_array(&mut self, i: &ExprArray) { visit_expr_array(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_assign(&mut self, i: &ExprAssign) { visit_expr_assign(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_assign_op(&mut self, i: &ExprAssignOp) { visit_expr_assign_op(self, i) }

fn visit_expr_binary(&mut self, i: &ExprBinary) { visit_expr_binary(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_block(&mut self, i: &ExprBlock) { visit_expr_block(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_box(&mut self, i: &ExprBox) { visit_expr_box(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_break(&mut self, i: &ExprBreak) { visit_expr_break(self, i) }

fn visit_expr_call(&mut self, i: &ExprCall) { visit_expr_call(self, i) }

fn visit_expr_cast(&mut self, i: &ExprCast) { visit_expr_cast(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_catch(&mut self, i: &ExprCatch) { visit_expr_catch(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_closure(&mut self, i: &ExprClosure) { visit_expr_closure(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_continue(&mut self, i: &ExprContinue) { visit_expr_continue(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_field(&mut self, i: &ExprField) { visit_expr_field(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_for_loop(&mut self, i: &ExprForLoop) { visit_expr_for_loop(self, i) }

fn visit_expr_group(&mut self, i: &ExprGroup) { visit_expr_group(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_if(&mut self, i: &ExprIf) { visit_expr_if(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_if_let(&mut self, i: &ExprIfLet) { visit_expr_if_let(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_in_place(&mut self, i: &ExprInPlace) { visit_expr_in_place(self, i) }

fn visit_expr_index(&mut self, i: &ExprIndex) { visit_expr_index(self, i) }

fn visit_expr_kind(&mut self, i: &ExprKind) { visit_expr_kind(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_loop(&mut self, i: &ExprLoop) { visit_expr_loop(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_match(&mut self, i: &ExprMatch) { visit_expr_match(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_method_call(&mut self, i: &ExprMethodCall) { visit_expr_method_call(self, i) }

fn visit_expr_paren(&mut self, i: &ExprParen) { visit_expr_paren(self, i) }

fn visit_expr_path(&mut self, i: &ExprPath) { visit_expr_path(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_range(&mut self, i: &ExprRange) { visit_expr_range(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_repeat(&mut self, i: &ExprRepeat) { visit_expr_repeat(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_ret(&mut self, i: &ExprRet) { visit_expr_ret(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_struct(&mut self, i: &ExprStruct) { visit_expr_struct(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_try(&mut self, i: &ExprTry) { visit_expr_try(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_tup(&mut self, i: &ExprTup) { visit_expr_tup(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_tup_field(&mut self, i: &ExprTupField) { visit_expr_tup_field(self, i) }

fn visit_expr_type(&mut self, i: &ExprType) { visit_expr_type(self, i) }

fn visit_expr_unary(&mut self, i: &ExprUnary) { visit_expr_unary(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_while(&mut self, i: &ExprWhile) { visit_expr_while(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_while_let(&mut self, i: &ExprWhileLet) { visit_expr_while_let(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_expr_yield(&mut self, i: &ExprYield) { visit_expr_yield(self, i) }

fn visit_field(&mut self, i: &Field) { visit_field(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_field_pat(&mut self, i: &FieldPat) { visit_field_pat(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_field_value(&mut self, i: &FieldValue) { visit_field_value(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_file(&mut self, i: &File) { visit_file(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_fn_arg(&mut self, i: &FnArg) { visit_fn_arg(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_fn_decl(&mut self, i: &FnDecl) { visit_fn_decl(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_foreign_item(&mut self, i: &ForeignItem) { visit_foreign_item(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_foreign_item_fn(&mut self, i: &ForeignItemFn) { visit_foreign_item_fn(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_foreign_item_kind(&mut self, i: &ForeignItemKind) { visit_foreign_item_kind(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_foreign_item_static(&mut self, i: &ForeignItemStatic) { visit_foreign_item_static(self, i) }

fn visit_function_ret_ty(&mut self, i: &FunctionRetTy) { visit_function_ret_ty(self, i) }

fn visit_generics(&mut self, i: &Generics) { visit_generics(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_impl_item(&mut self, i: &ImplItem) { visit_impl_item(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_impl_item_const(&mut self, i: &ImplItemConst) { visit_impl_item_const(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_impl_item_kind(&mut self, i: &ImplItemKind) { visit_impl_item_kind(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_impl_item_method(&mut self, i: &ImplItemMethod) { visit_impl_item_method(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_impl_item_type(&mut self, i: &ImplItemType) { visit_impl_item_type(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_impl_polarity(&mut self, i: &ImplPolarity) { visit_impl_polarity(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_in_place_kind(&mut self, i: &InPlaceKind) { visit_in_place_kind(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_item(&mut self, i: &Item) { visit_item(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_item_const(&mut self, i: &ItemConst) { visit_item_const(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_item_default_impl(&mut self, i: &ItemDefaultImpl) { visit_item_default_impl(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_item_enum(&mut self, i: &ItemEnum) { visit_item_enum(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_item_extern_crate(&mut self, i: &ItemExternCrate) { visit_item_extern_crate(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_item_fn(&mut self, i: &ItemFn) { visit_item_fn(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_item_foreign_mod(&mut self, i: &ItemForeignMod) { visit_item_foreign_mod(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_item_impl(&mut self, i: &ItemImpl) { visit_item_impl(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_item_kind(&mut self, i: &ItemKind) { visit_item_kind(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_item_mod(&mut self, i: &ItemMod) { visit_item_mod(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_item_static(&mut self, i: &ItemStatic) { visit_item_static(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_item_struct(&mut self, i: &ItemStruct) { visit_item_struct(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_item_trait(&mut self, i: &ItemTrait) { visit_item_trait(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_item_ty(&mut self, i: &ItemTy) { visit_item_ty(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_item_union(&mut self, i: &ItemUnion) { visit_item_union(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_item_use(&mut self, i: &ItemUse) { visit_item_use(self, i) }

fn visit_lifetime_def(&mut self, i: &LifetimeDef) { visit_lifetime_def(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_local(&mut self, i: &Local) { visit_local(self, i) }

fn visit_mac(&mut self, i: &Mac) { visit_mac(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_mac_stmt_style(&mut self, i: &MacStmtStyle) { visit_mac_stmt_style(self, i) }

fn visit_meta_item(&mut self, i: &MetaItem) { visit_meta_item(self, i) }

fn visit_meta_item_list(&mut self, i: &MetaItemList) { visit_meta_item_list(self, i) }

fn visit_meta_name_value(&mut self, i: &MetaNameValue) { visit_meta_name_value(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_method_sig(&mut self, i: &MethodSig) { visit_method_sig(self, i) }

fn visit_mut_ty(&mut self, i: &MutTy) { visit_mut_ty(self, i) }

fn visit_mutability(&mut self, i: &Mutability) { visit_mutability(self, i) }

fn visit_nested_meta_item(&mut self, i: &NestedMetaItem) { visit_nested_meta_item(self, i) }

fn visit_parenthesized_parameter_data(&mut self, i: &ParenthesizedParameterData) { visit_parenthesized_parameter_data(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_pat(&mut self, i: &Pat) { visit_pat(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_pat_box(&mut self, i: &PatBox) { visit_pat_box(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_pat_ident(&mut self, i: &PatIdent) { visit_pat_ident(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_pat_lit(&mut self, i: &PatLit) { visit_pat_lit(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_pat_path(&mut self, i: &PatPath) { visit_pat_path(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_pat_range(&mut self, i: &PatRange) { visit_pat_range(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_pat_ref(&mut self, i: &PatRef) { visit_pat_ref(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_pat_slice(&mut self, i: &PatSlice) { visit_pat_slice(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_pat_struct(&mut self, i: &PatStruct) { visit_pat_struct(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_pat_tuple(&mut self, i: &PatTuple) { visit_pat_tuple(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_pat_tuple_struct(&mut self, i: &PatTupleStruct) { visit_pat_tuple_struct(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_pat_wild(&mut self, i: &PatWild) { visit_pat_wild(self, i) }

fn visit_path(&mut self, i: &Path) { visit_path(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_path_glob(&mut self, i: &PathGlob) { visit_path_glob(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_path_list(&mut self, i: &PathList) { visit_path_list(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_path_list_item(&mut self, i: &PathListItem) { visit_path_list_item(self, i) }

fn visit_path_parameters(&mut self, i: &PathParameters) { visit_path_parameters(self, i) }

fn visit_path_segment(&mut self, i: &PathSegment) { visit_path_segment(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_path_simple(&mut self, i: &PathSimple) { visit_path_simple(self, i) }

fn visit_poly_trait_ref(&mut self, i: &PolyTraitRef) { visit_poly_trait_ref(self, i) }

fn visit_qself(&mut self, i: &QSelf) { visit_qself(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_range_limits(&mut self, i: &RangeLimits) { visit_range_limits(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_stmt(&mut self, i: &Stmt) { visit_stmt(self, i) }

fn visit_trait_bound_modifier(&mut self, i: &TraitBoundModifier) { visit_trait_bound_modifier(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_trait_item(&mut self, i: &TraitItem) { visit_trait_item(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_trait_item_const(&mut self, i: &TraitItemConst) { visit_trait_item_const(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_trait_item_kind(&mut self, i: &TraitItemKind) { visit_trait_item_kind(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_trait_item_method(&mut self, i: &TraitItemMethod) { visit_trait_item_method(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_trait_item_type(&mut self, i: &TraitItemType) { visit_trait_item_type(self, i) }

fn visit_ty(&mut self, i: &Ty) { visit_ty(self, i) }

fn visit_ty_array(&mut self, i: &TyArray) { visit_ty_array(self, i) }

fn visit_ty_bare_fn(&mut self, i: &TyBareFn) { visit_ty_bare_fn(self, i) }

fn visit_ty_group(&mut self, i: &TyGroup) { visit_ty_group(self, i) }

fn visit_ty_impl_trait(&mut self, i: &TyImplTrait) { visit_ty_impl_trait(self, i) }

fn visit_ty_infer(&mut self, i: &TyInfer) { visit_ty_infer(self, i) }

fn visit_ty_never(&mut self, i: &TyNever) { visit_ty_never(self, i) }

fn visit_ty_param(&mut self, i: &TyParam) { visit_ty_param(self, i) }

fn visit_ty_param_bound(&mut self, i: &TyParamBound) { visit_ty_param_bound(self, i) }

fn visit_ty_paren(&mut self, i: &TyParen) { visit_ty_paren(self, i) }

fn visit_ty_path(&mut self, i: &TyPath) { visit_ty_path(self, i) }

fn visit_ty_ptr(&mut self, i: &TyPtr) { visit_ty_ptr(self, i) }

fn visit_ty_rptr(&mut self, i: &TyRptr) { visit_ty_rptr(self, i) }

fn visit_ty_slice(&mut self, i: &TySlice) { visit_ty_slice(self, i) }

fn visit_ty_trait_object(&mut self, i: &TyTraitObject) { visit_ty_trait_object(self, i) }

fn visit_ty_tup(&mut self, i: &TyTup) { visit_ty_tup(self, i) }

fn visit_type_binding(&mut self, i: &TypeBinding) { visit_type_binding(self, i) }

fn visit_un_op(&mut self, i: &UnOp) { visit_un_op(self, i) }

fn visit_unsafety(&mut self, i: &Unsafety) { visit_unsafety(self, i) }

fn visit_variant(&mut self, i: &Variant) { visit_variant(self, i) }

fn visit_variant_data(&mut self, i: &VariantData) { visit_variant_data(self, i) }
# [ cfg ( feature = "full" ) ]
fn visit_view_path(&mut self, i: &ViewPath) { visit_view_path(self, i) }

fn visit_vis_crate(&mut self, i: &VisCrate) { visit_vis_crate(self, i) }

fn visit_vis_inherited(&mut self, i: &VisInherited) { visit_vis_inherited(self, i) }

fn visit_vis_public(&mut self, i: &VisPublic) { visit_vis_public(self, i) }

fn visit_vis_restricted(&mut self, i: &VisRestricted) { visit_vis_restricted(self, i) }

fn visit_visibility(&mut self, i: &Visibility) { visit_visibility(self, i) }

fn visit_where_bound_predicate(&mut self, i: &WhereBoundPredicate) { visit_where_bound_predicate(self, i) }

fn visit_where_clause(&mut self, i: &WhereClause) { visit_where_clause(self, i) }

fn visit_where_eq_predicate(&mut self, i: &WhereEqPredicate) { visit_where_eq_predicate(self, i) }

fn visit_where_predicate(&mut self, i: &WherePredicate) { visit_where_predicate(self, i) }

fn visit_where_region_predicate(&mut self, i: &WhereRegionPredicate) { visit_where_region_predicate(self, i) }

}


pub fn visit_abi<V: Visitor + ?Sized>(_visitor: &mut V, _i: &Abi) {
    // Skipped field _i . extern_token;
    _visitor.visit_abi_kind(&_i . kind);
}

pub fn visit_abi_kind<V: Visitor + ?Sized>(_visitor: &mut V, _i: &AbiKind) {
    use ::AbiKind::*;
    match *_i {
        Named(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Default => { }
    }
}

pub fn visit_angle_bracketed_parameter_data<V: Visitor + ?Sized>(_visitor: &mut V, _i: &AngleBracketedParameterData) {
    // Skipped field _i . turbofish;
    // Skipped field _i . lt_token;
    // Skipped field _i . lifetimes;
    for el in (_i . types).iter() { let it = el.item(); _visitor.visit_ty(&it) };
    for el in (_i . bindings).iter() { let it = el.item(); _visitor.visit_type_binding(&it) };
    // Skipped field _i . gt_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_arg_captured<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ArgCaptured) {
    _visitor.visit_pat(&_i . pat);
    // Skipped field _i . colon_token;
    _visitor.visit_ty(&_i . ty);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_arg_self<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ArgSelf) {
    _visitor.visit_mutability(&_i . mutbl);
    // Skipped field _i . self_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_arg_self_ref<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ArgSelfRef) {
    // Skipped field _i . and_token;
    // Skipped field _i . self_token;
    // Skipped field _i . lifetime;
    _visitor.visit_mutability(&_i . mutbl);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_arm<V: Visitor + ?Sized>(_visitor: &mut V, _i: &Arm) {
    for it in (_i . attrs).iter() { _visitor.visit_attribute(&it) };
    for el in (_i . pats).iter() { let it = el.item(); _visitor.visit_pat(&it) };
    // Skipped field _i . if_token;
    if let Some(ref it) = _i . guard { _visitor.visit_expr(&* it) };
    // Skipped field _i . rocket_token;
    _visitor.visit_expr(&_i . body);
    // Skipped field _i . comma;
}

pub fn visit_attr_style<V: Visitor + ?Sized>(_visitor: &mut V, _i: &AttrStyle) {
    use ::AttrStyle::*;
    match *_i {
        Outer => { }
        Inner(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
    }
}

pub fn visit_attribute<V: Visitor + ?Sized>(_visitor: &mut V, _i: &Attribute) {
    _visitor.visit_attr_style(&_i . style);
    // Skipped field _i . pound_token;
    // Skipped field _i . bracket_token;
    _visitor.visit_path(&_i . path);
    // Skipped field _i . tts;
    // Skipped field _i . is_sugared_doc;
}

pub fn visit_bare_fn_arg<V: Visitor + ?Sized>(_visitor: &mut V, _i: &BareFnArg) {
    // Skipped field _i . name;
    _visitor.visit_ty(&_i . ty);
}

pub fn visit_bare_fn_arg_name<V: Visitor + ?Sized>(_visitor: &mut V, _i: &BareFnArgName) {
    use ::BareFnArgName::*;
    match *_i {
        Named(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Wild(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
    }
}

pub fn visit_bare_fn_ty<V: Visitor + ?Sized>(_visitor: &mut V, _i: &BareFnTy) {
    if let Some(ref it) = _i . lifetimes { _visitor.visit_bound_lifetimes(&* it) };
    _visitor.visit_unsafety(&_i . unsafety);
    if let Some(ref it) = _i . abi { _visitor.visit_abi(&* it) };
    // Skipped field _i . fn_token;
    // Skipped field _i . paren_token;
    for el in (_i . inputs).iter() { let it = el.item(); _visitor.visit_bare_fn_arg(&it) };
    // Skipped field _i . variadic;
    _visitor.visit_function_ret_ty(&_i . output);
}

pub fn visit_bin_op<V: Visitor + ?Sized>(_visitor: &mut V, _i: &BinOp) {
    use ::BinOp::*;
    match *_i {
        Add(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Sub(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Mul(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Div(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Rem(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        And(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Or(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        BitXor(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        BitAnd(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        BitOr(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Shl(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Shr(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Eq(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Lt(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Le(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Ne(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Ge(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Gt(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        AddEq(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        SubEq(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        MulEq(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        DivEq(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        RemEq(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        BitXorEq(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        BitAndEq(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        BitOrEq(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        ShlEq(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        ShrEq(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn visit_binding_mode<V: Visitor + ?Sized>(_visitor: &mut V, _i: &BindingMode) {
    use ::BindingMode::*;
    match *_i {
        ByRef(ref _binding_0, ref _binding_1, ) => {
            // Skipped field * _binding_0;
            _visitor.visit_mutability(&* _binding_1);
        }
        ByValue(ref _binding_0, ) => {
            _visitor.visit_mutability(&* _binding_0);
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn visit_block<V: Visitor + ?Sized>(_visitor: &mut V, _i: &Block) {
    // Skipped field _i . brace_token;
    for it in (_i . stmts).iter() { _visitor.visit_stmt(&it) };
}

pub fn visit_body<V: Visitor + ?Sized>(_visitor: &mut V, _i: &Body) {
    use ::Body::*;
    match *_i {
        Enum(ref _binding_0, ) => {
            _visitor.visit_body_enum(&* _binding_0);
        }
        Struct(ref _binding_0, ) => {
            _visitor.visit_body_struct(&* _binding_0);
        }
    }
}

pub fn visit_body_enum<V: Visitor + ?Sized>(_visitor: &mut V, _i: &BodyEnum) {
    // Skipped field _i . enum_token;
    // Skipped field _i . brace_token;
    for el in (_i . variants).iter() { let it = el.item(); _visitor.visit_variant(&it) };
}

pub fn visit_body_struct<V: Visitor + ?Sized>(_visitor: &mut V, _i: &BodyStruct) {
    _visitor.visit_variant_data(&_i . data);
    // Skipped field _i . struct_token;
    // Skipped field _i . semi_token;
}

pub fn visit_bound_lifetimes<V: Visitor + ?Sized>(_visitor: &mut V, _i: &BoundLifetimes) {
    // Skipped field _i . for_token;
    // Skipped field _i . lt_token;
    for el in (_i . lifetimes).iter() { let it = el.item(); _visitor.visit_lifetime_def(&it) };
    // Skipped field _i . gt_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_capture_by<V: Visitor + ?Sized>(_visitor: &mut V, _i: &CaptureBy) {
    use ::CaptureBy::*;
    match *_i {
        Value(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Ref => { }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn visit_constness<V: Visitor + ?Sized>(_visitor: &mut V, _i: &Constness) {
    use ::Constness::*;
    match *_i {
        Const(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        NotConst => { }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn visit_defaultness<V: Visitor + ?Sized>(_visitor: &mut V, _i: &Defaultness) {
    use ::Defaultness::*;
    match *_i {
        Default(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Final => { }
    }
}

pub fn visit_derive_input<V: Visitor + ?Sized>(_visitor: &mut V, _i: &DeriveInput) {
    // Skipped field _i . ident;
    _visitor.visit_visibility(&_i . vis);
    for it in (_i . attrs).iter() { _visitor.visit_attribute(&it) };
    _visitor.visit_generics(&_i . generics);
    _visitor.visit_body(&_i . body);
}

pub fn visit_expr<V: Visitor + ?Sized>(_visitor: &mut V, _i: &Expr) {
    _visitor.visit_expr_kind(&_i . node);
    for it in (_i . attrs).iter() { _visitor.visit_attribute(&it) };
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_addr_of<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprAddrOf) {
    // Skipped field _i . and_token;
    _visitor.visit_mutability(&_i . mutbl);
    _visitor.visit_expr(&_i . expr);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_array<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprArray) {
    for el in (_i . exprs).iter() { let it = el.item(); _visitor.visit_expr(&it) };
    // Skipped field _i . bracket_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_assign<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprAssign) {
    _visitor.visit_expr(&_i . left);
    _visitor.visit_expr(&_i . right);
    // Skipped field _i . eq_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_assign_op<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprAssignOp) {
    _visitor.visit_bin_op(&_i . op);
    _visitor.visit_expr(&_i . left);
    _visitor.visit_expr(&_i . right);
}

pub fn visit_expr_binary<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprBinary) {
    _visitor.visit_bin_op(&_i . op);
    _visitor.visit_expr(&_i . left);
    _visitor.visit_expr(&_i . right);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_block<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprBlock) {
    _visitor.visit_unsafety(&_i . unsafety);
    _visitor.visit_block(&_i . block);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_box<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprBox) {
    _visitor.visit_expr(&_i . expr);
    // Skipped field _i . box_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_break<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprBreak) {
    // Skipped field _i . label;
    if let Some(ref it) = _i . expr { _visitor.visit_expr(&* it) };
    // Skipped field _i . break_token;
}

pub fn visit_expr_call<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprCall) {
    _visitor.visit_expr(&_i . func);
    for el in (_i . args).iter() { let it = el.item(); _visitor.visit_expr(&it) };
    // Skipped field _i . paren_token;
}

pub fn visit_expr_cast<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprCast) {
    _visitor.visit_expr(&_i . expr);
    // Skipped field _i . as_token;
    _visitor.visit_ty(&_i . ty);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_catch<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprCatch) {
    // Skipped field _i . do_token;
    // Skipped field _i . catch_token;
    _visitor.visit_block(&_i . block);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_closure<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprClosure) {
    _visitor.visit_capture_by(&_i . capture);
    _visitor.visit_fn_decl(&_i . decl);
    _visitor.visit_expr(&_i . body);
    // Skipped field _i . or1_token;
    // Skipped field _i . or2_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_continue<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprContinue) {
    // Skipped field _i . label;
    // Skipped field _i . continue_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_field<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprField) {
    _visitor.visit_expr(&_i . expr);
    // Skipped field _i . field;
    // Skipped field _i . dot_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_for_loop<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprForLoop) {
    _visitor.visit_pat(&_i . pat);
    _visitor.visit_expr(&_i . expr);
    _visitor.visit_block(&_i . body);
    // Skipped field _i . label;
    // Skipped field _i . for_token;
    // Skipped field _i . colon_token;
    // Skipped field _i . in_token;
}

pub fn visit_expr_group<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprGroup) {
    _visitor.visit_expr(&_i . expr);
    // Skipped field _i . group_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_if<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprIf) {
    _visitor.visit_expr(&_i . cond);
    _visitor.visit_block(&_i . if_true);
    if let Some(ref it) = _i . if_false { _visitor.visit_expr(&* it) };
    // Skipped field _i . if_token;
    // Skipped field _i . else_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_if_let<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprIfLet) {
    _visitor.visit_pat(&_i . pat);
    _visitor.visit_expr(&_i . expr);
    _visitor.visit_block(&_i . if_true);
    if let Some(ref it) = _i . if_false { _visitor.visit_expr(&* it) };
    // Skipped field _i . if_token;
    // Skipped field _i . let_token;
    // Skipped field _i . eq_token;
    // Skipped field _i . else_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_in_place<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprInPlace) {
    _visitor.visit_expr(&_i . place);
    _visitor.visit_in_place_kind(&_i . kind);
    _visitor.visit_expr(&_i . value);
}

pub fn visit_expr_index<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprIndex) {
    _visitor.visit_expr(&_i . expr);
    _visitor.visit_expr(&_i . index);
    // Skipped field _i . bracket_token;
}

pub fn visit_expr_kind<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprKind) {
    use ::ExprKind::*;
    match *_i {
        Box(ref _binding_0, ) => {
            full!(_visitor.visit_expr_box(&* _binding_0));
        }
        InPlace(ref _binding_0, ) => {
            full!(_visitor.visit_expr_in_place(&* _binding_0));
        }
        Array(ref _binding_0, ) => {
            full!(_visitor.visit_expr_array(&* _binding_0));
        }
        Call(ref _binding_0, ) => {
            _visitor.visit_expr_call(&* _binding_0);
        }
        MethodCall(ref _binding_0, ) => {
            full!(_visitor.visit_expr_method_call(&* _binding_0));
        }
        Tup(ref _binding_0, ) => {
            full!(_visitor.visit_expr_tup(&* _binding_0));
        }
        Binary(ref _binding_0, ) => {
            _visitor.visit_expr_binary(&* _binding_0);
        }
        Unary(ref _binding_0, ) => {
            _visitor.visit_expr_unary(&* _binding_0);
        }
        Lit(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Cast(ref _binding_0, ) => {
            _visitor.visit_expr_cast(&* _binding_0);
        }
        Type(ref _binding_0, ) => {
            _visitor.visit_expr_type(&* _binding_0);
        }
        If(ref _binding_0, ) => {
            full!(_visitor.visit_expr_if(&* _binding_0));
        }
        IfLet(ref _binding_0, ) => {
            full!(_visitor.visit_expr_if_let(&* _binding_0));
        }
        While(ref _binding_0, ) => {
            full!(_visitor.visit_expr_while(&* _binding_0));
        }
        WhileLet(ref _binding_0, ) => {
            full!(_visitor.visit_expr_while_let(&* _binding_0));
        }
        ForLoop(ref _binding_0, ) => {
            full!(_visitor.visit_expr_for_loop(&* _binding_0));
        }
        Loop(ref _binding_0, ) => {
            full!(_visitor.visit_expr_loop(&* _binding_0));
        }
        Match(ref _binding_0, ) => {
            full!(_visitor.visit_expr_match(&* _binding_0));
        }
        Closure(ref _binding_0, ) => {
            full!(_visitor.visit_expr_closure(&* _binding_0));
        }
        Block(ref _binding_0, ) => {
            full!(_visitor.visit_expr_block(&* _binding_0));
        }
        Assign(ref _binding_0, ) => {
            full!(_visitor.visit_expr_assign(&* _binding_0));
        }
        AssignOp(ref _binding_0, ) => {
            full!(_visitor.visit_expr_assign_op(&* _binding_0));
        }
        Field(ref _binding_0, ) => {
            full!(_visitor.visit_expr_field(&* _binding_0));
        }
        TupField(ref _binding_0, ) => {
            full!(_visitor.visit_expr_tup_field(&* _binding_0));
        }
        Index(ref _binding_0, ) => {
            _visitor.visit_expr_index(&* _binding_0);
        }
        Range(ref _binding_0, ) => {
            full!(_visitor.visit_expr_range(&* _binding_0));
        }
        Path(ref _binding_0, ) => {
            _visitor.visit_expr_path(&* _binding_0);
        }
        AddrOf(ref _binding_0, ) => {
            full!(_visitor.visit_expr_addr_of(&* _binding_0));
        }
        Break(ref _binding_0, ) => {
            full!(_visitor.visit_expr_break(&* _binding_0));
        }
        Continue(ref _binding_0, ) => {
            full!(_visitor.visit_expr_continue(&* _binding_0));
        }
        Ret(ref _binding_0, ) => {
            full!(_visitor.visit_expr_ret(&* _binding_0));
        }
        Mac(ref _binding_0, ) => {
            _visitor.visit_mac(&* _binding_0);
        }
        Struct(ref _binding_0, ) => {
            full!(_visitor.visit_expr_struct(&* _binding_0));
        }
        Repeat(ref _binding_0, ) => {
            full!(_visitor.visit_expr_repeat(&* _binding_0));
        }
        Paren(ref _binding_0, ) => {
            _visitor.visit_expr_paren(&* _binding_0);
        }
        Group(ref _binding_0, ) => {
            _visitor.visit_expr_group(&* _binding_0);
        }
        Try(ref _binding_0, ) => {
            full!(_visitor.visit_expr_try(&* _binding_0));
        }
        Catch(ref _binding_0, ) => {
            full!(_visitor.visit_expr_catch(&* _binding_0));
        }
        Yield(ref _binding_0, ) => {
            full!(_visitor.visit_expr_yield(&* _binding_0));
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_loop<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprLoop) {
    _visitor.visit_block(&_i . body);
    // Skipped field _i . label;
    // Skipped field _i . loop_token;
    // Skipped field _i . colon_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_match<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprMatch) {
    // Skipped field _i . match_token;
    // Skipped field _i . brace_token;
    _visitor.visit_expr(&_i . expr);
    for it in (_i . arms).iter() { _visitor.visit_arm(&it) };
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_method_call<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprMethodCall) {
    _visitor.visit_expr(&_i . expr);
    // Skipped field _i . method;
    for el in (_i . typarams).iter() { let it = el.item(); _visitor.visit_ty(&it) };
    for el in (_i . args).iter() { let it = el.item(); _visitor.visit_expr(&it) };
    // Skipped field _i . paren_token;
    // Skipped field _i . dot_token;
    // Skipped field _i . lt_token;
    // Skipped field _i . colon2_token;
    // Skipped field _i . gt_token;
}

pub fn visit_expr_paren<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprParen) {
    _visitor.visit_expr(&_i . expr);
    // Skipped field _i . paren_token;
}

pub fn visit_expr_path<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprPath) {
    if let Some(ref it) = _i . qself { _visitor.visit_qself(&* it) };
    _visitor.visit_path(&_i . path);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_range<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprRange) {
    if let Some(ref it) = _i . from { _visitor.visit_expr(&* it) };
    if let Some(ref it) = _i . to { _visitor.visit_expr(&* it) };
    _visitor.visit_range_limits(&_i . limits);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_repeat<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprRepeat) {
    // Skipped field _i . bracket_token;
    // Skipped field _i . semi_token;
    _visitor.visit_expr(&_i . expr);
    _visitor.visit_expr(&_i . amt);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_ret<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprRet) {
    if let Some(ref it) = _i . expr { _visitor.visit_expr(&* it) };
    // Skipped field _i . return_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_struct<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprStruct) {
    _visitor.visit_path(&_i . path);
    for el in (_i . fields).iter() { let it = el.item(); _visitor.visit_field_value(&it) };
    if let Some(ref it) = _i . rest { _visitor.visit_expr(&* it) };
    // Skipped field _i . dot2_token;
    // Skipped field _i . brace_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_try<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprTry) {
    _visitor.visit_expr(&_i . expr);
    // Skipped field _i . question_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_tup<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprTup) {
    for el in (_i . args).iter() { let it = el.item(); _visitor.visit_expr(&it) };
    // Skipped field _i . paren_token;
    // Skipped field _i . lone_comma;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_tup_field<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprTupField) {
    _visitor.visit_expr(&_i . expr);
    // Skipped field _i . field;
    // Skipped field _i . dot_token;
}

pub fn visit_expr_type<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprType) {
    _visitor.visit_expr(&_i . expr);
    // Skipped field _i . colon_token;
    _visitor.visit_ty(&_i . ty);
}

pub fn visit_expr_unary<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprUnary) {
    _visitor.visit_un_op(&_i . op);
    _visitor.visit_expr(&_i . expr);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_while<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprWhile) {
    _visitor.visit_expr(&_i . cond);
    _visitor.visit_block(&_i . body);
    // Skipped field _i . label;
    // Skipped field _i . colon_token;
    // Skipped field _i . while_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_while_let<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprWhileLet) {
    _visitor.visit_pat(&_i . pat);
    _visitor.visit_expr(&_i . expr);
    _visitor.visit_block(&_i . body);
    // Skipped field _i . label;
    // Skipped field _i . colon_token;
    // Skipped field _i . while_token;
    // Skipped field _i . let_token;
    // Skipped field _i . eq_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_expr_yield<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ExprYield) {
    // Skipped field _i . yield_token;
    if let Some(ref it) = _i . expr { _visitor.visit_expr(&* it) };
}

pub fn visit_field<V: Visitor + ?Sized>(_visitor: &mut V, _i: &Field) {
    // Skipped field _i . ident;
    _visitor.visit_visibility(&_i . vis);
    for it in (_i . attrs).iter() { _visitor.visit_attribute(&it) };
    _visitor.visit_ty(&_i . ty);
    // Skipped field _i . colon_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_field_pat<V: Visitor + ?Sized>(_visitor: &mut V, _i: &FieldPat) {
    // Skipped field _i . ident;
    _visitor.visit_pat(&_i . pat);
    // Skipped field _i . is_shorthand;
    // Skipped field _i . colon_token;
    for it in (_i . attrs).iter() { _visitor.visit_attribute(&it) };
}
# [ cfg ( feature = "full" ) ]
pub fn visit_field_value<V: Visitor + ?Sized>(_visitor: &mut V, _i: &FieldValue) {
    // Skipped field _i . ident;
    _visitor.visit_expr(&_i . expr);
    // Skipped field _i . is_shorthand;
    for it in (_i . attrs).iter() { _visitor.visit_attribute(&it) };
    // Skipped field _i . colon_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_file<V: Visitor + ?Sized>(_visitor: &mut V, _i: &File) {
    // Skipped field _i . shebang;
    for it in (_i . attrs).iter() { _visitor.visit_attribute(&it) };
    for it in (_i . items).iter() { _visitor.visit_item(&it) };
}
# [ cfg ( feature = "full" ) ]
pub fn visit_fn_arg<V: Visitor + ?Sized>(_visitor: &mut V, _i: &FnArg) {
    use ::FnArg::*;
    match *_i {
        SelfRef(ref _binding_0, ) => {
            _visitor.visit_arg_self_ref(&* _binding_0);
        }
        SelfValue(ref _binding_0, ) => {
            _visitor.visit_arg_self(&* _binding_0);
        }
        Captured(ref _binding_0, ) => {
            _visitor.visit_arg_captured(&* _binding_0);
        }
        Ignored(ref _binding_0, ) => {
            _visitor.visit_ty(&* _binding_0);
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn visit_fn_decl<V: Visitor + ?Sized>(_visitor: &mut V, _i: &FnDecl) {
    // Skipped field _i . fn_token;
    // Skipped field _i . paren_token;
    for el in (_i . inputs).iter() { let it = el.item(); _visitor.visit_fn_arg(&it) };
    _visitor.visit_function_ret_ty(&_i . output);
    _visitor.visit_generics(&_i . generics);
    // Skipped field _i . variadic;
    // Skipped field _i . dot_tokens;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_foreign_item<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ForeignItem) {
    // Skipped field _i . ident;
    for it in (_i . attrs).iter() { _visitor.visit_attribute(&it) };
    _visitor.visit_foreign_item_kind(&_i . node);
    _visitor.visit_visibility(&_i . vis);
    // Skipped field _i . semi_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_foreign_item_fn<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ForeignItemFn) {
    _visitor.visit_fn_decl(&_i . decl);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_foreign_item_kind<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ForeignItemKind) {
    use ::ForeignItemKind::*;
    match *_i {
        Fn(ref _binding_0, ) => {
            _visitor.visit_foreign_item_fn(&* _binding_0);
        }
        Static(ref _binding_0, ) => {
            _visitor.visit_foreign_item_static(&* _binding_0);
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn visit_foreign_item_static<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ForeignItemStatic) {
    // Skipped field _i . static_token;
    _visitor.visit_ty(&_i . ty);
    // Skipped field _i . colon_token;
    _visitor.visit_mutability(&_i . mutbl);
}

pub fn visit_function_ret_ty<V: Visitor + ?Sized>(_visitor: &mut V, _i: &FunctionRetTy) {
    use ::FunctionRetTy::*;
    match *_i {
        Default => { }
        Ty(ref _binding_0, ref _binding_1, ) => {
            _visitor.visit_ty(&* _binding_0);
            // Skipped field * _binding_1;
        }
    }
}

pub fn visit_generics<V: Visitor + ?Sized>(_visitor: &mut V, _i: &Generics) {
    // Skipped field _i . lt_token;
    // Skipped field _i . gt_token;
    for el in (_i . lifetimes).iter() { let it = el.item(); _visitor.visit_lifetime_def(&it) };
    for el in (_i . ty_params).iter() { let it = el.item(); _visitor.visit_ty_param(&it) };
    _visitor.visit_where_clause(&_i . where_clause);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_impl_item<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ImplItem) {
    for it in (_i . attrs).iter() { _visitor.visit_attribute(&it) };
    _visitor.visit_impl_item_kind(&_i . node);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_impl_item_const<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ImplItemConst) {
    _visitor.visit_visibility(&_i . vis);
    _visitor.visit_defaultness(&_i . defaultness);
    // Skipped field _i . const_token;
    // Skipped field _i . ident;
    // Skipped field _i . colon_token;
    _visitor.visit_ty(&_i . ty);
    // Skipped field _i . eq_token;
    _visitor.visit_expr(&_i . expr);
    // Skipped field _i . semi_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_impl_item_kind<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ImplItemKind) {
    use ::ImplItemKind::*;
    match *_i {
        Const(ref _binding_0, ) => {
            _visitor.visit_impl_item_const(&* _binding_0);
        }
        Method(ref _binding_0, ) => {
            _visitor.visit_impl_item_method(&* _binding_0);
        }
        Type(ref _binding_0, ) => {
            _visitor.visit_impl_item_type(&* _binding_0);
        }
        Macro(ref _binding_0, ) => {
            _visitor.visit_mac(&* _binding_0);
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn visit_impl_item_method<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ImplItemMethod) {
    _visitor.visit_visibility(&_i . vis);
    _visitor.visit_defaultness(&_i . defaultness);
    _visitor.visit_method_sig(&_i . sig);
    _visitor.visit_block(&_i . block);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_impl_item_type<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ImplItemType) {
    _visitor.visit_visibility(&_i . vis);
    _visitor.visit_defaultness(&_i . defaultness);
    // Skipped field _i . type_token;
    // Skipped field _i . ident;
    // Skipped field _i . eq_token;
    _visitor.visit_ty(&_i . ty);
    // Skipped field _i . semi_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_impl_polarity<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ImplPolarity) {
    use ::ImplPolarity::*;
    match *_i {
        Positive => { }
        Negative(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn visit_in_place_kind<V: Visitor + ?Sized>(_visitor: &mut V, _i: &InPlaceKind) {
    use ::InPlaceKind::*;
    match *_i {
        Arrow(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        In(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn visit_item<V: Visitor + ?Sized>(_visitor: &mut V, _i: &Item) {
    for it in (_i . attrs).iter() { _visitor.visit_attribute(&it) };
    _visitor.visit_item_kind(&_i . node);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_item_const<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ItemConst) {
    _visitor.visit_visibility(&_i . vis);
    // Skipped field _i . const_token;
    // Skipped field _i . ident;
    // Skipped field _i . colon_token;
    _visitor.visit_ty(&_i . ty);
    // Skipped field _i . eq_token;
    _visitor.visit_expr(&_i . expr);
    // Skipped field _i . semi_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_item_default_impl<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ItemDefaultImpl) {
    _visitor.visit_unsafety(&_i . unsafety);
    // Skipped field _i . impl_token;
    _visitor.visit_path(&_i . path);
    // Skipped field _i . for_token;
    // Skipped field _i . dot2_token;
    // Skipped field _i . brace_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_item_enum<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ItemEnum) {
    _visitor.visit_visibility(&_i . vis);
    // Skipped field _i . enum_token;
    // Skipped field _i . ident;
    _visitor.visit_generics(&_i . generics);
    // Skipped field _i . brace_token;
    for el in (_i . variants).iter() { let it = el.item(); _visitor.visit_variant(&it) };
}
# [ cfg ( feature = "full" ) ]
pub fn visit_item_extern_crate<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ItemExternCrate) {
    _visitor.visit_visibility(&_i . vis);
    // Skipped field _i . extern_token;
    // Skipped field _i . crate_token;
    // Skipped field _i . ident;
    // Skipped field _i . rename;
    // Skipped field _i . semi_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_item_fn<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ItemFn) {
    _visitor.visit_visibility(&_i . vis);
    _visitor.visit_constness(&_i . constness);
    _visitor.visit_unsafety(&_i . unsafety);
    if let Some(ref it) = _i . abi { _visitor.visit_abi(&* it) };
    _visitor.visit_fn_decl(&_i . decl);
    // Skipped field _i . ident;
    _visitor.visit_block(&_i . block);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_item_foreign_mod<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ItemForeignMod) {
    _visitor.visit_abi(&_i . abi);
    // Skipped field _i . brace_token;
    for it in (_i . items).iter() { _visitor.visit_foreign_item(&it) };
}
# [ cfg ( feature = "full" ) ]
pub fn visit_item_impl<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ItemImpl) {
    _visitor.visit_defaultness(&_i . defaultness);
    _visitor.visit_unsafety(&_i . unsafety);
    // Skipped field _i . impl_token;
    _visitor.visit_generics(&_i . generics);
    // Skipped field _i . trait_;
    _visitor.visit_ty(&_i . self_ty);
    // Skipped field _i . brace_token;
    for it in (_i . items).iter() { _visitor.visit_impl_item(&it) };
}
# [ cfg ( feature = "full" ) ]
pub fn visit_item_kind<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ItemKind) {
    use ::ItemKind::*;
    match *_i {
        ExternCrate(ref _binding_0, ) => {
            _visitor.visit_item_extern_crate(&* _binding_0);
        }
        Use(ref _binding_0, ) => {
            _visitor.visit_item_use(&* _binding_0);
        }
        Static(ref _binding_0, ) => {
            _visitor.visit_item_static(&* _binding_0);
        }
        Const(ref _binding_0, ) => {
            _visitor.visit_item_const(&* _binding_0);
        }
        Fn(ref _binding_0, ) => {
            _visitor.visit_item_fn(&* _binding_0);
        }
        Mod(ref _binding_0, ) => {
            _visitor.visit_item_mod(&* _binding_0);
        }
        ForeignMod(ref _binding_0, ) => {
            _visitor.visit_item_foreign_mod(&* _binding_0);
        }
        Ty(ref _binding_0, ) => {
            _visitor.visit_item_ty(&* _binding_0);
        }
        Enum(ref _binding_0, ) => {
            _visitor.visit_item_enum(&* _binding_0);
        }
        Struct(ref _binding_0, ) => {
            _visitor.visit_item_struct(&* _binding_0);
        }
        Union(ref _binding_0, ) => {
            _visitor.visit_item_union(&* _binding_0);
        }
        Trait(ref _binding_0, ) => {
            _visitor.visit_item_trait(&* _binding_0);
        }
        DefaultImpl(ref _binding_0, ) => {
            _visitor.visit_item_default_impl(&* _binding_0);
        }
        Impl(ref _binding_0, ) => {
            _visitor.visit_item_impl(&* _binding_0);
        }
        Mac(ref _binding_0, ) => {
            _visitor.visit_mac(&* _binding_0);
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn visit_item_mod<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ItemMod) {
    _visitor.visit_visibility(&_i . vis);
    // Skipped field _i . mod_token;
    // Skipped field _i . ident;
    // Skipped field _i . content;
    // Skipped field _i . semi;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_item_static<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ItemStatic) {
    _visitor.visit_visibility(&_i . vis);
    // Skipped field _i . static_token;
    _visitor.visit_mutability(&_i . mutbl);
    // Skipped field _i . ident;
    // Skipped field _i . colon_token;
    _visitor.visit_ty(&_i . ty);
    // Skipped field _i . eq_token;
    _visitor.visit_expr(&_i . expr);
    // Skipped field _i . semi_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_item_struct<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ItemStruct) {
    _visitor.visit_visibility(&_i . vis);
    // Skipped field _i . struct_token;
    // Skipped field _i . ident;
    _visitor.visit_generics(&_i . generics);
    _visitor.visit_variant_data(&_i . data);
    // Skipped field _i . semi_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_item_trait<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ItemTrait) {
    _visitor.visit_visibility(&_i . vis);
    _visitor.visit_unsafety(&_i . unsafety);
    // Skipped field _i . trait_token;
    // Skipped field _i . ident;
    _visitor.visit_generics(&_i . generics);
    // Skipped field _i . colon_token;
    for el in (_i . supertraits).iter() { let it = el.item(); _visitor.visit_ty_param_bound(&it) };
    // Skipped field _i . brace_token;
    for it in (_i . items).iter() { _visitor.visit_trait_item(&it) };
}
# [ cfg ( feature = "full" ) ]
pub fn visit_item_ty<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ItemTy) {
    _visitor.visit_visibility(&_i . vis);
    // Skipped field _i . type_token;
    // Skipped field _i . ident;
    _visitor.visit_generics(&_i . generics);
    // Skipped field _i . eq_token;
    _visitor.visit_ty(&_i . ty);
    // Skipped field _i . semi_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_item_union<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ItemUnion) {
    _visitor.visit_visibility(&_i . vis);
    // Skipped field _i . union_token;
    // Skipped field _i . ident;
    _visitor.visit_generics(&_i . generics);
    _visitor.visit_variant_data(&_i . data);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_item_use<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ItemUse) {
    _visitor.visit_visibility(&_i . vis);
    // Skipped field _i . use_token;
    _visitor.visit_view_path(&_i . path);
    // Skipped field _i . semi_token;
}

pub fn visit_lifetime_def<V: Visitor + ?Sized>(_visitor: &mut V, _i: &LifetimeDef) {
    for it in (_i . attrs).iter() { _visitor.visit_attribute(&it) };
    // Skipped field _i . lifetime;
    // Skipped field _i . colon_token;
    // Skipped field _i . bounds;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_local<V: Visitor + ?Sized>(_visitor: &mut V, _i: &Local) {
    // Skipped field _i . let_token;
    // Skipped field _i . colon_token;
    // Skipped field _i . eq_token;
    // Skipped field _i . semi_token;
    _visitor.visit_pat(&_i . pat);
    if let Some(ref it) = _i . ty { _visitor.visit_ty(&* it) };
    if let Some(ref it) = _i . init { _visitor.visit_expr(&* it) };
    for it in (_i . attrs).iter() { _visitor.visit_attribute(&it) };
}

pub fn visit_mac<V: Visitor + ?Sized>(_visitor: &mut V, _i: &Mac) {
    _visitor.visit_path(&_i . path);
    // Skipped field _i . bang_token;
    // Skipped field _i . ident;
    // Skipped field _i . tokens;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_mac_stmt_style<V: Visitor + ?Sized>(_visitor: &mut V, _i: &MacStmtStyle) {
    use ::MacStmtStyle::*;
    match *_i {
        Semicolon(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Braces => { }
        NoBraces => { }
    }
}

pub fn visit_meta_item<V: Visitor + ?Sized>(_visitor: &mut V, _i: &MetaItem) {
    use ::MetaItem::*;
    match *_i {
        Term(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        List(ref _binding_0, ) => {
            _visitor.visit_meta_item_list(&* _binding_0);
        }
        NameValue(ref _binding_0, ) => {
            _visitor.visit_meta_name_value(&* _binding_0);
        }
    }
}

pub fn visit_meta_item_list<V: Visitor + ?Sized>(_visitor: &mut V, _i: &MetaItemList) {
    // Skipped field _i . ident;
    // Skipped field _i . paren_token;
    for el in (_i . nested).iter() { let it = el.item(); _visitor.visit_nested_meta_item(&it) };
}

pub fn visit_meta_name_value<V: Visitor + ?Sized>(_visitor: &mut V, _i: &MetaNameValue) {
    // Skipped field _i . ident;
    // Skipped field _i . eq_token;
    // Skipped field _i . lit;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_method_sig<V: Visitor + ?Sized>(_visitor: &mut V, _i: &MethodSig) {
    _visitor.visit_constness(&_i . constness);
    _visitor.visit_unsafety(&_i . unsafety);
    if let Some(ref it) = _i . abi { _visitor.visit_abi(&* it) };
    // Skipped field _i . ident;
    _visitor.visit_fn_decl(&_i . decl);
}

pub fn visit_mut_ty<V: Visitor + ?Sized>(_visitor: &mut V, _i: &MutTy) {
    _visitor.visit_ty(&_i . ty);
    _visitor.visit_mutability(&_i . mutability);
}

pub fn visit_mutability<V: Visitor + ?Sized>(_visitor: &mut V, _i: &Mutability) {
    use ::Mutability::*;
    match *_i {
        Mutable(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Immutable => { }
    }
}

pub fn visit_nested_meta_item<V: Visitor + ?Sized>(_visitor: &mut V, _i: &NestedMetaItem) {
    use ::NestedMetaItem::*;
    match *_i {
        MetaItem(ref _binding_0, ) => {
            _visitor.visit_meta_item(&* _binding_0);
        }
        Literal(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
    }
}

pub fn visit_parenthesized_parameter_data<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ParenthesizedParameterData) {
    // Skipped field _i . paren_token;
    for el in (_i . inputs).iter() { let it = el.item(); _visitor.visit_ty(&it) };
    _visitor.visit_function_ret_ty(&_i . output);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_pat<V: Visitor + ?Sized>(_visitor: &mut V, _i: &Pat) {
    use ::Pat::*;
    match *_i {
        Wild(ref _binding_0, ) => {
            _visitor.visit_pat_wild(&* _binding_0);
        }
        Ident(ref _binding_0, ) => {
            _visitor.visit_pat_ident(&* _binding_0);
        }
        Struct(ref _binding_0, ) => {
            _visitor.visit_pat_struct(&* _binding_0);
        }
        TupleStruct(ref _binding_0, ) => {
            _visitor.visit_pat_tuple_struct(&* _binding_0);
        }
        Path(ref _binding_0, ) => {
            _visitor.visit_pat_path(&* _binding_0);
        }
        Tuple(ref _binding_0, ) => {
            _visitor.visit_pat_tuple(&* _binding_0);
        }
        Box(ref _binding_0, ) => {
            _visitor.visit_pat_box(&* _binding_0);
        }
        Ref(ref _binding_0, ) => {
            _visitor.visit_pat_ref(&* _binding_0);
        }
        Lit(ref _binding_0, ) => {
            _visitor.visit_pat_lit(&* _binding_0);
        }
        Range(ref _binding_0, ) => {
            _visitor.visit_pat_range(&* _binding_0);
        }
        Slice(ref _binding_0, ) => {
            _visitor.visit_pat_slice(&* _binding_0);
        }
        Mac(ref _binding_0, ) => {
            _visitor.visit_mac(&* _binding_0);
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn visit_pat_box<V: Visitor + ?Sized>(_visitor: &mut V, _i: &PatBox) {
    _visitor.visit_pat(&_i . pat);
    // Skipped field _i . box_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_pat_ident<V: Visitor + ?Sized>(_visitor: &mut V, _i: &PatIdent) {
    _visitor.visit_binding_mode(&_i . mode);
    // Skipped field _i . ident;
    if let Some(ref it) = _i . subpat { _visitor.visit_pat(&* it) };
    // Skipped field _i . at_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_pat_lit<V: Visitor + ?Sized>(_visitor: &mut V, _i: &PatLit) {
    _visitor.visit_expr(&_i . expr);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_pat_path<V: Visitor + ?Sized>(_visitor: &mut V, _i: &PatPath) {
    if let Some(ref it) = _i . qself { _visitor.visit_qself(&* it) };
    _visitor.visit_path(&_i . path);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_pat_range<V: Visitor + ?Sized>(_visitor: &mut V, _i: &PatRange) {
    _visitor.visit_expr(&_i . lo);
    _visitor.visit_expr(&_i . hi);
    _visitor.visit_range_limits(&_i . limits);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_pat_ref<V: Visitor + ?Sized>(_visitor: &mut V, _i: &PatRef) {
    _visitor.visit_pat(&_i . pat);
    _visitor.visit_mutability(&_i . mutbl);
    // Skipped field _i . and_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_pat_slice<V: Visitor + ?Sized>(_visitor: &mut V, _i: &PatSlice) {
    for el in (_i . front).iter() { let it = el.item(); _visitor.visit_pat(&it) };
    if let Some(ref it) = _i . middle { _visitor.visit_pat(&* it) };
    for el in (_i . back).iter() { let it = el.item(); _visitor.visit_pat(&it) };
    // Skipped field _i . dot2_token;
    // Skipped field _i . comma_token;
    // Skipped field _i . bracket_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_pat_struct<V: Visitor + ?Sized>(_visitor: &mut V, _i: &PatStruct) {
    _visitor.visit_path(&_i . path);
    for el in (_i . fields).iter() { let it = el.item(); _visitor.visit_field_pat(&it) };
    // Skipped field _i . brace_token;
    // Skipped field _i . dot2_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_pat_tuple<V: Visitor + ?Sized>(_visitor: &mut V, _i: &PatTuple) {
    for el in (_i . pats).iter() { let it = el.item(); _visitor.visit_pat(&it) };
    // Skipped field _i . dots_pos;
    // Skipped field _i . paren_token;
    // Skipped field _i . dot2_token;
    // Skipped field _i . comma_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_pat_tuple_struct<V: Visitor + ?Sized>(_visitor: &mut V, _i: &PatTupleStruct) {
    _visitor.visit_path(&_i . path);
    _visitor.visit_pat_tuple(&_i . pat);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_pat_wild<V: Visitor + ?Sized>(_visitor: &mut V, _i: &PatWild) {
    // Skipped field _i . underscore_token;
}

pub fn visit_path<V: Visitor + ?Sized>(_visitor: &mut V, _i: &Path) {
    // Skipped field _i . leading_colon;
    for el in (_i . segments).iter() { let it = el.item(); _visitor.visit_path_segment(&it) };
}
# [ cfg ( feature = "full" ) ]
pub fn visit_path_glob<V: Visitor + ?Sized>(_visitor: &mut V, _i: &PathGlob) {
    _visitor.visit_path(&_i . path);
    // Skipped field _i . colon2_token;
    // Skipped field _i . star_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_path_list<V: Visitor + ?Sized>(_visitor: &mut V, _i: &PathList) {
    _visitor.visit_path(&_i . path);
    // Skipped field _i . colon2_token;
    // Skipped field _i . brace_token;
    for el in (_i . items).iter() { let it = el.item(); _visitor.visit_path_list_item(&it) };
}
# [ cfg ( feature = "full" ) ]
pub fn visit_path_list_item<V: Visitor + ?Sized>(_visitor: &mut V, _i: &PathListItem) {
    // Skipped field _i . name;
    // Skipped field _i . rename;
    // Skipped field _i . as_token;
}

pub fn visit_path_parameters<V: Visitor + ?Sized>(_visitor: &mut V, _i: &PathParameters) {
    use ::PathParameters::*;
    match *_i {
        None => { }
        AngleBracketed(ref _binding_0, ) => {
            _visitor.visit_angle_bracketed_parameter_data(&* _binding_0);
        }
        Parenthesized(ref _binding_0, ) => {
            _visitor.visit_parenthesized_parameter_data(&* _binding_0);
        }
    }
}

pub fn visit_path_segment<V: Visitor + ?Sized>(_visitor: &mut V, _i: &PathSegment) {
    // Skipped field _i . ident;
    _visitor.visit_path_parameters(&_i . parameters);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_path_simple<V: Visitor + ?Sized>(_visitor: &mut V, _i: &PathSimple) {
    _visitor.visit_path(&_i . path);
    // Skipped field _i . as_token;
    // Skipped field _i . rename;
}

pub fn visit_poly_trait_ref<V: Visitor + ?Sized>(_visitor: &mut V, _i: &PolyTraitRef) {
    if let Some(ref it) = _i . bound_lifetimes { _visitor.visit_bound_lifetimes(&* it) };
    _visitor.visit_path(&_i . trait_ref);
}

pub fn visit_qself<V: Visitor + ?Sized>(_visitor: &mut V, _i: &QSelf) {
    // Skipped field _i . lt_token;
    _visitor.visit_ty(&_i . ty);
    // Skipped field _i . position;
    // Skipped field _i . as_token;
    // Skipped field _i . gt_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_range_limits<V: Visitor + ?Sized>(_visitor: &mut V, _i: &RangeLimits) {
    use ::RangeLimits::*;
    match *_i {
        HalfOpen(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Closed(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn visit_stmt<V: Visitor + ?Sized>(_visitor: &mut V, _i: &Stmt) {
    use ::Stmt::*;
    match *_i {
        Local(ref _binding_0, ) => {
            _visitor.visit_local(&* _binding_0);
        }
        Item(ref _binding_0, ) => {
            _visitor.visit_item(&* _binding_0);
        }
        Expr(ref _binding_0, ) => {
            _visitor.visit_expr(&* _binding_0);
        }
        Semi(ref _binding_0, ref _binding_1, ) => {
            _visitor.visit_expr(&* _binding_0);
            // Skipped field * _binding_1;
        }
        Mac(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
    }
}

pub fn visit_trait_bound_modifier<V: Visitor + ?Sized>(_visitor: &mut V, _i: &TraitBoundModifier) {
    use ::TraitBoundModifier::*;
    match *_i {
        None => { }
        Maybe(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn visit_trait_item<V: Visitor + ?Sized>(_visitor: &mut V, _i: &TraitItem) {
    for it in (_i . attrs).iter() { _visitor.visit_attribute(&it) };
    _visitor.visit_trait_item_kind(&_i . node);
}
# [ cfg ( feature = "full" ) ]
pub fn visit_trait_item_const<V: Visitor + ?Sized>(_visitor: &mut V, _i: &TraitItemConst) {
    // Skipped field _i . const_token;
    // Skipped field _i . ident;
    // Skipped field _i . colon_token;
    _visitor.visit_ty(&_i . ty);
    // Skipped field _i . default;
    // Skipped field _i . semi_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_trait_item_kind<V: Visitor + ?Sized>(_visitor: &mut V, _i: &TraitItemKind) {
    use ::TraitItemKind::*;
    match *_i {
        Const(ref _binding_0, ) => {
            _visitor.visit_trait_item_const(&* _binding_0);
        }
        Method(ref _binding_0, ) => {
            _visitor.visit_trait_item_method(&* _binding_0);
        }
        Type(ref _binding_0, ) => {
            _visitor.visit_trait_item_type(&* _binding_0);
        }
        Macro(ref _binding_0, ) => {
            _visitor.visit_mac(&* _binding_0);
        }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn visit_trait_item_method<V: Visitor + ?Sized>(_visitor: &mut V, _i: &TraitItemMethod) {
    _visitor.visit_method_sig(&_i . sig);
    if let Some(ref it) = _i . default { _visitor.visit_block(&* it) };
    // Skipped field _i . semi_token;
}
# [ cfg ( feature = "full" ) ]
pub fn visit_trait_item_type<V: Visitor + ?Sized>(_visitor: &mut V, _i: &TraitItemType) {
    // Skipped field _i . type_token;
    // Skipped field _i . ident;
    // Skipped field _i . colon_token;
    for el in (_i . bounds).iter() { let it = el.item(); _visitor.visit_ty_param_bound(&it) };
    // Skipped field _i . default;
    // Skipped field _i . semi_token;
}

pub fn visit_ty<V: Visitor + ?Sized>(_visitor: &mut V, _i: &Ty) {
    use ::Ty::*;
    match *_i {
        Slice(ref _binding_0, ) => {
            _visitor.visit_ty_slice(&* _binding_0);
        }
        Array(ref _binding_0, ) => {
            _visitor.visit_ty_array(&* _binding_0);
        }
        Ptr(ref _binding_0, ) => {
            _visitor.visit_ty_ptr(&* _binding_0);
        }
        Rptr(ref _binding_0, ) => {
            _visitor.visit_ty_rptr(&* _binding_0);
        }
        BareFn(ref _binding_0, ) => {
            _visitor.visit_ty_bare_fn(&* _binding_0);
        }
        Never(ref _binding_0, ) => {
            _visitor.visit_ty_never(&* _binding_0);
        }
        Tup(ref _binding_0, ) => {
            _visitor.visit_ty_tup(&* _binding_0);
        }
        Path(ref _binding_0, ) => {
            _visitor.visit_ty_path(&* _binding_0);
        }
        TraitObject(ref _binding_0, ) => {
            _visitor.visit_ty_trait_object(&* _binding_0);
        }
        ImplTrait(ref _binding_0, ) => {
            _visitor.visit_ty_impl_trait(&* _binding_0);
        }
        Paren(ref _binding_0, ) => {
            _visitor.visit_ty_paren(&* _binding_0);
        }
        Group(ref _binding_0, ) => {
            _visitor.visit_ty_group(&* _binding_0);
        }
        Infer(ref _binding_0, ) => {
            _visitor.visit_ty_infer(&* _binding_0);
        }
        Mac(ref _binding_0, ) => {
            _visitor.visit_mac(&* _binding_0);
        }
    }
}

pub fn visit_ty_array<V: Visitor + ?Sized>(_visitor: &mut V, _i: &TyArray) {
    // Skipped field _i . bracket_token;
    _visitor.visit_ty(&_i . ty);
    // Skipped field _i . semi_token;
    _visitor.visit_expr(&_i . amt);
}

pub fn visit_ty_bare_fn<V: Visitor + ?Sized>(_visitor: &mut V, _i: &TyBareFn) {
    _visitor.visit_bare_fn_ty(&_i . ty);
}

pub fn visit_ty_group<V: Visitor + ?Sized>(_visitor: &mut V, _i: &TyGroup) {
    // Skipped field _i . group_token;
    _visitor.visit_ty(&_i . ty);
}

pub fn visit_ty_impl_trait<V: Visitor + ?Sized>(_visitor: &mut V, _i: &TyImplTrait) {
    // Skipped field _i . impl_token;
    for el in (_i . bounds).iter() { let it = el.item(); _visitor.visit_ty_param_bound(&it) };
}

pub fn visit_ty_infer<V: Visitor + ?Sized>(_visitor: &mut V, _i: &TyInfer) {
    // Skipped field _i . underscore_token;
}

pub fn visit_ty_never<V: Visitor + ?Sized>(_visitor: &mut V, _i: &TyNever) {
    // Skipped field _i . bang_token;
}

pub fn visit_ty_param<V: Visitor + ?Sized>(_visitor: &mut V, _i: &TyParam) {
    for it in (_i . attrs).iter() { _visitor.visit_attribute(&it) };
    // Skipped field _i . ident;
    // Skipped field _i . colon_token;
    for el in (_i . bounds).iter() { let it = el.item(); _visitor.visit_ty_param_bound(&it) };
    // Skipped field _i . eq_token;
    if let Some(ref it) = _i . default { _visitor.visit_ty(&* it) };
}

pub fn visit_ty_param_bound<V: Visitor + ?Sized>(_visitor: &mut V, _i: &TyParamBound) {
    use ::TyParamBound::*;
    match *_i {
        Trait(ref _binding_0, ref _binding_1, ) => {
            _visitor.visit_poly_trait_ref(&* _binding_0);
            _visitor.visit_trait_bound_modifier(&* _binding_1);
        }
        Region(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
    }
}

pub fn visit_ty_paren<V: Visitor + ?Sized>(_visitor: &mut V, _i: &TyParen) {
    // Skipped field _i . paren_token;
    _visitor.visit_ty(&_i . ty);
}

pub fn visit_ty_path<V: Visitor + ?Sized>(_visitor: &mut V, _i: &TyPath) {
    if let Some(ref it) = _i . qself { _visitor.visit_qself(&* it) };
    _visitor.visit_path(&_i . path);
}

pub fn visit_ty_ptr<V: Visitor + ?Sized>(_visitor: &mut V, _i: &TyPtr) {
    // Skipped field _i . star_token;
    // Skipped field _i . const_token;
    _visitor.visit_mut_ty(&_i . ty);
}

pub fn visit_ty_rptr<V: Visitor + ?Sized>(_visitor: &mut V, _i: &TyRptr) {
    // Skipped field _i . and_token;
    // Skipped field _i . lifetime;
    _visitor.visit_mut_ty(&_i . ty);
}

pub fn visit_ty_slice<V: Visitor + ?Sized>(_visitor: &mut V, _i: &TySlice) {
    _visitor.visit_ty(&_i . ty);
    // Skipped field _i . bracket_token;
}

pub fn visit_ty_trait_object<V: Visitor + ?Sized>(_visitor: &mut V, _i: &TyTraitObject) {
    for el in (_i . bounds).iter() { let it = el.item(); _visitor.visit_ty_param_bound(&it) };
}

pub fn visit_ty_tup<V: Visitor + ?Sized>(_visitor: &mut V, _i: &TyTup) {
    // Skipped field _i . paren_token;
    for el in (_i . tys).iter() { let it = el.item(); _visitor.visit_ty(&it) };
    // Skipped field _i . lone_comma;
}

pub fn visit_type_binding<V: Visitor + ?Sized>(_visitor: &mut V, _i: &TypeBinding) {
    // Skipped field _i . ident;
    // Skipped field _i . eq_token;
    _visitor.visit_ty(&_i . ty);
}

pub fn visit_un_op<V: Visitor + ?Sized>(_visitor: &mut V, _i: &UnOp) {
    use ::UnOp::*;
    match *_i {
        Deref(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Not(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Neg(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
    }
}

pub fn visit_unsafety<V: Visitor + ?Sized>(_visitor: &mut V, _i: &Unsafety) {
    use ::Unsafety::*;
    match *_i {
        Unsafe(ref _binding_0, ) => {
            // Skipped field * _binding_0;
        }
        Normal => { }
    }
}

pub fn visit_variant<V: Visitor + ?Sized>(_visitor: &mut V, _i: &Variant) {
    // Skipped field _i . ident;
    for it in (_i . attrs).iter() { _visitor.visit_attribute(&it) };
    _visitor.visit_variant_data(&_i . data);
    if let Some(ref it) = _i . discriminant { _visitor.visit_expr(&* it) };
    // Skipped field _i . eq_token;
}

pub fn visit_variant_data<V: Visitor + ?Sized>(_visitor: &mut V, _i: &VariantData) {
    use ::VariantData::*;
    match *_i {
        Struct(ref _binding_0, ref _binding_1, ) => {
            for el in (* _binding_0).iter() { let it = el.item(); _visitor.visit_field(&it) };
            // Skipped field * _binding_1;
        }
        Tuple(ref _binding_0, ref _binding_1, ) => {
            for el in (* _binding_0).iter() { let it = el.item(); _visitor.visit_field(&it) };
            // Skipped field * _binding_1;
        }
        Unit => { }
    }
}
# [ cfg ( feature = "full" ) ]
pub fn visit_view_path<V: Visitor + ?Sized>(_visitor: &mut V, _i: &ViewPath) {
    use ::ViewPath::*;
    match *_i {
        Simple(ref _binding_0, ) => {
            _visitor.visit_path_simple(&* _binding_0);
        }
        Glob(ref _binding_0, ) => {
            _visitor.visit_path_glob(&* _binding_0);
        }
        List(ref _binding_0, ) => {
            _visitor.visit_path_list(&* _binding_0);
        }
    }
}

pub fn visit_vis_crate<V: Visitor + ?Sized>(_visitor: &mut V, _i: &VisCrate) {
    // Skipped field _i . pub_token;
    // Skipped field _i . paren_token;
    // Skipped field _i . crate_token;
}

pub fn visit_vis_inherited<V: Visitor + ?Sized>(_visitor: &mut V, _i: &VisInherited) {
}

pub fn visit_vis_public<V: Visitor + ?Sized>(_visitor: &mut V, _i: &VisPublic) {
    // Skipped field _i . pub_token;
}

pub fn visit_vis_restricted<V: Visitor + ?Sized>(_visitor: &mut V, _i: &VisRestricted) {
    // Skipped field _i . pub_token;
    // Skipped field _i . paren_token;
    // Skipped field _i . in_token;
    _visitor.visit_path(&_i . path);
}

pub fn visit_visibility<V: Visitor + ?Sized>(_visitor: &mut V, _i: &Visibility) {
    use ::Visibility::*;
    match *_i {
        Public(ref _binding_0, ) => {
            _visitor.visit_vis_public(&* _binding_0);
        }
        Crate(ref _binding_0, ) => {
            _visitor.visit_vis_crate(&* _binding_0);
        }
        Restricted(ref _binding_0, ) => {
            _visitor.visit_vis_restricted(&* _binding_0);
        }
        Inherited(ref _binding_0, ) => {
            _visitor.visit_vis_inherited(&* _binding_0);
        }
    }
}

pub fn visit_where_bound_predicate<V: Visitor + ?Sized>(_visitor: &mut V, _i: &WhereBoundPredicate) {
    if let Some(ref it) = _i . bound_lifetimes { _visitor.visit_bound_lifetimes(&* it) };
    _visitor.visit_ty(&_i . bounded_ty);
    // Skipped field _i . colon_token;
    for el in (_i . bounds).iter() { let it = el.item(); _visitor.visit_ty_param_bound(&it) };
}

pub fn visit_where_clause<V: Visitor + ?Sized>(_visitor: &mut V, _i: &WhereClause) {
    // Skipped field _i . where_token;
    for el in (_i . predicates).iter() { let it = el.item(); _visitor.visit_where_predicate(&it) };
}

pub fn visit_where_eq_predicate<V: Visitor + ?Sized>(_visitor: &mut V, _i: &WhereEqPredicate) {
    _visitor.visit_ty(&_i . lhs_ty);
    // Skipped field _i . eq_token;
    _visitor.visit_ty(&_i . rhs_ty);
}

pub fn visit_where_predicate<V: Visitor + ?Sized>(_visitor: &mut V, _i: &WherePredicate) {
    use ::WherePredicate::*;
    match *_i {
        BoundPredicate(ref _binding_0, ) => {
            _visitor.visit_where_bound_predicate(&* _binding_0);
        }
        RegionPredicate(ref _binding_0, ) => {
            _visitor.visit_where_region_predicate(&* _binding_0);
        }
        EqPredicate(ref _binding_0, ) => {
            _visitor.visit_where_eq_predicate(&* _binding_0);
        }
    }
}

pub fn visit_where_region_predicate<V: Visitor + ?Sized>(_visitor: &mut V, _i: &WhereRegionPredicate) {
    // Skipped field _i . lifetime;
    // Skipped field _i . colon_token;
    // Skipped field _i . bounds;
}

