# 2024-02-27 Triage Log

A rare week where regressions out powered improvements to make the compiler roughly half a percent slower on average on nearly 100 benchmarks. Some regressions have fixes in the pipeline, but some remain elusive or were introduced to address correctness issues.

Triage done by **@rylev**.
Revision range: [5af21304..71ffdf7f](https://perf.rust-lang.org/?start=5af2130440c198afefbe5b8099342057cf272ef4&end=71ffdf7ff7ac6df5f9f64de7e780b8345797e8a0&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0%  | [0.2%, 4.4%]   | 69    |
| Regressions ❌ <br /> (secondary)  | 1.4%  | [0.2%, 4.9%]   | 66    |
| Improvements ✅ <br /> (primary)   | -1.1% | [-3.3%, -0.2%] | 28    |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.5%, -0.2%] | 33    |
| All ❌✅ (primary)                 | 0.4%  | [-3.3%, 4.4%]  | 97    |


4 Regressions, 6 Improvements, 5 Mixed; 2 of them in rollups
58 artifact comparisons made in total

#### Regressions

Always evaluate free constants and statics, even if previous errors occurred [#121087](https://github.com/rust-lang/rust/pull/121087) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5af2130440c198afefbe5b8099342057cf272ef4&end=cce6a6e22e715bd74455f2560a956ab920c3a914&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8% | [0.4%, 2.0%] | 4     |
| Regressions ❌ <br /> (secondary)  | 1.0% | [0.3%, 5.2%] | 11    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.8% | [0.4%, 2.0%] | 4     |
- Regressions in primary benchmarks are real and addressed in #121387
- Regressions in secondary benchmarks seem to be all noise.


Use intrinsics::debug_assertions in debug_assert_nounwind [#120863](https://github.com/rust-lang/rust/pull/120863) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=29f87ade9d78d233e85ef6ca2d6153d0d4fd38d6&end=2b43e75c98cc5ae32328c8b49657bcd882eb5e75&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8%  | [0.3%, 1.7%]   | 13    |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.4%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.7%  | [-0.4%, 1.7%]  | 14    |
- Pinged the author on what next steps are. Regression is in codegen which would be expected given the nature of the change, but it's unclear how one would address the issue.


wasm: Store rlib metadata in wasm object files [#120588](https://github.com/rust-lang/rust/pull/120588) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0987e41d1ccbae7a8a55fdcde4af0ea76ebfe2d3&end=7168c13579a550f2c47f7eea22f5e226a436cd00&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 3.1% | [3.0%, 3.3%] | 4     |
| Regressions ❌ <br /> (secondary)  | 1.5% | [0.2%, 2.9%] | 33    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 3.1% | [3.0%, 3.3%] | 4     |
- Regressions seem legit but nothing in self profiling stands out as a likely culprit. 
- Asked the author for more investigation.


Subtree update of `rust-analyzer` [#121581](https://github.com/rust-lang/rust/pull/121581) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=710048f790ebc9ebfac6039c6733570f8084c9de&end=43fdd4916d19f4004e23d422b5547637ad67ab21&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.7%, 0.8%] | 4     |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.2%, 0.7%] | 23    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.7%, 0.8%] | 4     |
- This is all noise - regressions revert in the next run.


#### Improvements

Improve codegen diagnostic handling [#121129](https://github.com/rust-lang/rust/pull/121129) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=026b3b8e955e0571db39aa96fc9d7aba25cc4d66&end=f70f19fef41cfdda75c92f163434c29ad046cf09&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -5.1% | [-5.1%, -5.1%] | 1     |
| All ❌✅ (primary)                 | -     | -              | 0     |


remove `sub_relations` from the `InferCtxt` [#119989](https://github.com/rust-lang/rust/pull/119989) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d9ae43c7879c83f08ea2e886b55ea0f6839c9ead&end=397937d812852f9bbeb671005cb399dbcb357cde&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.5%, -0.2%] | 28    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.7%, -0.2%] | 28    |
| All ❌✅ (primary)                 | -0.3% | [-0.5%, -0.2%] | 28    |


Rollup of 7 pull requests [#121549](https://github.com/rust-lang/rust/pull/121549) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6bdb8a4a96945527677f4b3dc7161875834189a4&end=381d69953bb7c3390cec0fee200f24529cb6320f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -2.8% | [-2.8%, -2.8%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -2.8% | [-2.8%, -2.8%] | 1     |


Use `br` instead of a conditional when switching on a constant boolean [#120650](https://github.com/rust-lang/rust/pull/120650) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2ae1bb671183a072b54ed8ed39abfcd72990a3e7&end=89d8e3116ccb7f55760825b731de4f4e0fd76770&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-2.2%, -0.1%] | 19    |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.9% | [-2.2%, -0.1%] | 19    |


speed up `x install` by skipping archiving and compression [#118724](https://github.com/rust-lang/rust/pull/118724) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=43fdd4916d19f4004e23d422b5547637ad67ab21&end=26cd5d862e22c013ecb3396b177d3af80e95c836&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.8%, -0.6%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.7%, -0.2%] | 24    |
| All ❌✅ (primary)                 | -0.7% | [-0.8%, -0.6%] | 4     |


Use generic `NonZero` in tests. [#121461](https://github.com/rust-lang/rust/pull/121461) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0ecbd0605770f45c9151715e66ba2b3cae367fcb&end=0250ef2571185b05701ed9d74fc904c17508a397&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -3.6% | [-3.6%, -3.6%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -3.6% | [-3.6%, -3.6%] | 1     |


#### Mixed

Rollup of 8 pull requests [#121345](https://github.com/rust-lang/rust/pull/121345) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2b43e75c98cc5ae32328c8b49657bcd882eb5e75&end=bb594538fc6e84213a6b8d5e165442570aa48923&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.4%, 1.1%]   | 9     |
| Regressions ❌ <br /> (secondary)  | 1.7%  | [1.7%, 1.7%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.8%, -0.2%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.8% | [-2.1%, -0.3%] | 17    |
| All ❌✅ (primary)                 | 0.2%  | [-0.8%, 1.1%]  | 15    |
- Lots of seemingly risky PRs in this roll up. Need to run through them.


match lowering: eagerly simplify match pairs [#120904](https://github.com/rust-lang/rust/pull/120904) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2dc0170233689435f988579a2080f27b02027d21&end=4e650749337bd4b0b464ebb5252d122b7cb98c8d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 3     |
| Improvements ✅ <br /> (primary)   | -2.0% | [-3.1%, -0.2%] | 7     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -2.0% | [-3.1%, -0.2%] | 7     |
- Improvements far outweigh the regressions so I don't think this needs further investigation.


compiler: clippy::complexity fixes [#121523](https://github.com/rust-lang/rust/pull/121523) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8f359beca4e58bc3ae795a666301a8f47023044c&end=6bdb8a4a96945527677f4b3dc7161875834189a4&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.5%  | [0.2%, 2.7%]   | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.2% | [-1.2%, -1.2%] | 1     |
| All ❌✅ (primary)                 | 1.5%  | [0.2%, 2.7%]   | 2     |
- The large regression that caused this to be marked overall as a regression is just noise.


Add `#[rustc_no_mir_inline]` for standard library UB checks [#121114](https://github.com/rust-lang/rust/pull/121114) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=89d8e3116ccb7f55760825b731de4f4e0fd76770&end=e9f95949138125bb1b98ed213a41b9aa825bacf5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 1.2%]   | 33    |
| Regressions ❌ <br /> (secondary)  | 1.5%  | [0.3%, 5.5%]   | 12    |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.3%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.2%] | 8     |
| All ❌✅ (primary)                 | 0.4%  | [-0.3%, 1.2%]  | 36    |
- Consider necessary for fixing some pathological performance cases as well as addressing another critical issue. (See [this analysis](https://github.com/rust-lang/rust/pull/121114#issuecomment-1962316858) for more detail.)


Implement RFC 3373: Avoid non-local definitions in functions [#120393](https://github.com/rust-lang/rust/pull/120393) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8c0b1fcd2914caaf1c3a1071028fb74b70c519e9&end=b0d3e04ca9f848c5fce3ad4bab6153009be06db0&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.2%  | [0.5%, 4.2%]   | 12    |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.1%, 1.8%]   | 5     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.8%, -0.1%] | 27    |
| All ❌✅ (primary)                 | 2.2%  | [0.5%, 4.2%]   | 12    |
- [#121625](https://github.com/rust-lang/rust/pull/121625) is meant to try to address this. 
- Given the complex nature of the change, I imagine a revert is not desirable even if performance can't be gained back. 

