/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.labelformatters;

import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.labelformatters.ALabelFormatter;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterNumber;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterSimple;
import info.monitorenter.util.Range;
import info.monitorenter.util.units.AUnit;
import info.monitorenter.util.units.UnitFactory;
import info.monitorenter.util.units.UnitSystemSI;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelFormatterAutoUnits
extends ALabelFormatter {
    private static final Map<AUnit, Integer> UNITS_2_POWER = new HashMap<AUnit, Integer>();
    private ALabelFormatter m_delegate;
    private AUnit m_unit = ALabelFormatter.UNIT_UNCHANGED;

    public LabelFormatterAutoUnits() {
        this.m_delegate = new LabelFormatterSimple();
    }

    public LabelFormatterAutoUnits(ALabelFormatter delegate) {
        this.m_delegate = delegate;
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.m_delegate.addPropertyChangeListener(propertyName, listener);
    }

    private final void chooseUnit(double min, double max) {
        double range = this.getAxis().getRange().getExtent();
        if (range == 0.0) {
            range = 1.0;
        }
        this.m_unit = UnitFactory.getInstance().getUnit(range, UnitSystemSI.getInstance());
    }

    @Override
    public String format(double value) {
        double tmp = value / this.m_unit.getFactor();
        return this.m_delegate.format(tmp);
    }

    @Override
    public IAxis<?> getAxis() {
        return this.m_delegate.getAxis();
    }

    final ALabelFormatter getDelegate() {
        return this.m_delegate;
    }

    @Override
    public int getMaxAmountChars() {
        int fractionDigits = 0;
        Range range = this.getAxis().getRange();
        double dRange = range.getExtent() / this.m_unit.getFactor();
        if (dRange < 1.0) {
            if (dRange == 0.0) {
                fractionDigits = 1;
            } else if (dRange == 0.0) {
                fractionDigits = 1;
            } else {
                while (dRange < 1.0) {
                    dRange *= 10.0;
                    ++fractionDigits;
                }
            }
        } else {
            fractionDigits = dRange < 10.0 ? 2 : (dRange < 100.0 ? 1 : 0);
        }
        int integerDigits = 0;
        double max = range.getMax() / this.m_unit.getFactor();
        double min = Math.abs(range.getMin()) / this.m_unit.getFactor();
        if (max == 0.0 && min == 0.0) {
            integerDigits = 1;
        } else if (max < min) {
            while (min > 1.0) {
                min /= 10.0;
                ++integerDigits;
            }
        } else {
            while (max > 1.0) {
                max /= 10.0;
                ++integerDigits;
            }
        }
        if (this.m_delegate instanceof LabelFormatterNumber) {
            NumberFormat nf = ((LabelFormatterNumber)this.m_delegate).getNumberFormat();
            if (integerDigits > nf.getMaximumIntegerDigits()) {
                nf.setMaximumIntegerDigits(integerDigits);
            }
            if (fractionDigits > nf.getMaximumFractionDigits()) {
                nf.setMaximumFractionDigits(fractionDigits);
            }
        }
        return 1 + integerDigits + 1 + fractionDigits;
    }

    @Override
    public double getMinimumValueShiftForChange() {
        return this.m_delegate.getMinimumValueShiftForChange() * this.m_unit.getFactor();
    }

    @Override
    public double getNextEvenValue(double value, boolean ceiling) {
        return this.m_delegate.getNextEvenValue(value, ceiling);
    }

    @Override
    public AUnit getUnit() {
        return this.m_unit;
    }

    @Override
    public void initPaintIteration() {
        this.m_delegate.initPaintIteration();
        Range domain = this.m_delegate.getAxis().getRange();
        this.chooseUnit(domain.getMin(), domain.getMax());
    }

    @Override
    public Number parse(String formatted) throws NumberFormatException {
        double parsed = this.m_delegate.parse(formatted).doubleValue();
        return new Double(parsed *= this.m_unit.getFactor());
    }

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.m_delegate.removePropertyChangeListener(property, listener);
    }

    @Override
    public void setAxis(IAxis<?> axis) {
        this.m_delegate.setAxis(axis);
        Range range = axis.getRange();
        this.chooseUnit(range.getMin(), range.getMax());
    }

    final void setDelegate(ALabelFormatter delegate) {
        this.m_delegate = delegate;
    }

    public String toString() {
        return this.m_delegate.toString();
    }

    static {
        double factor = 0.0;
        for (AUnit unit : UnitFactory.getInstance().getUnits(UnitSystemSI.getInstance())) {
            int power = 0;
            factor = unit.getFactor();
            if (factor > 1.0) {
                while (factor > 1.0) {
                    factor /= 10.0;
                    ++power;
                }
            } else if (factor < 1.0) {
                while (factor < 1.0) {
                    factor *= 10.0;
                    --power;
                }
            }
            UNITS_2_POWER.put(unit, new Integer(power));
        }
    }
}

