/*
 * xdx - GTK+ DX-cluster client for amateur radio
 * Copyright (C) 2002-2006 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/*
 * gui_settingsdialog.c
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif

#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "gtksourceiter.h"
#include "gui.h"
#include "gui_settingsdialog.h"
#include "preferences.h"
#include "utils.h"


GtkWidget *preferencesdialog;
extern preferencestype preferences;

static void
on_pautologincheckbutton_toggled(GtkToggleButton *togglebutton,
                                 gpointer         user_data)
{
    GtkWidget *ploginhseparator, *pcommandslabel, *pcommandsentry;
    gboolean state;

    ploginhseparator = g_object_get_data(G_OBJECT(preferencesdialog),
                                         "ploginhseparator");
    pcommandslabel = g_object_get_data(G_OBJECT(preferencesdialog),
                                       "pcommandslabel");
    pcommandsentry = g_object_get_data(G_OBJECT(preferencesdialog),
                                       "pcommandsentry");

    state = gtk_toggle_button_get_active(togglebutton);

    if (state) {
        gtk_widget_set_sensitive(ploginhseparator, TRUE);
        gtk_widget_set_sensitive(pcommandslabel, TRUE);
        gtk_widget_set_sensitive(pcommandsentry, TRUE);
    } else {
        gtk_widget_set_sensitive(ploginhseparator, FALSE);
        gtk_widget_set_sensitive(pcommandslabel, FALSE);
        gtk_widget_set_sensitive(pcommandsentry, FALSE);
    }
}


static void
on_phamlibcheckbutton_toggled(GtkToggleButton *togglebutton,
                              gpointer         user_data)
{
    GtkWidget *phamlibhseparator, *priglabel, *prigentry;
    gboolean state;

    phamlibhseparator = g_object_get_data(G_OBJECT(preferencesdialog),
                                          "phamlibhseparator");
    priglabel = g_object_get_data(G_OBJECT(preferencesdialog),
                                  "priglabel");
    prigentry = g_object_get_data(G_OBJECT(preferencesdialog),
                                  "prigentry");

    state = gtk_toggle_button_get_active(togglebutton);

    if (state) {
        gtk_widget_set_sensitive(phamlibhseparator, TRUE);
        gtk_widget_set_sensitive(priglabel, TRUE);
        gtk_widget_set_sensitive(prigentry, TRUE);
    } else {
        gtk_widget_set_sensitive(phamlibhseparator, FALSE);
        gtk_widget_set_sensitive(priglabel, FALSE);
        gtk_widget_set_sensitive(prigentry, FALSE);
    }
}


static void
on_fontbutton_clicked(GtkButton     *button,
                      gpointer       user_data)
{
    GtkWidget *fontselectiondialog, *pfontsdxentry, *pfontsallentry;
    GdkPixbuf *fontselectiondialog_icon_pixbuf;
    gchar *font, *path;
    gint response;

    fontselectiondialog = gtk_font_chooser_dialog_new(
                            _("Xdx - Select a font"),
                            NULL);
    path = g_build_filename(PACKAGE_DATA_DIR, "pixmaps", "xdx.png", NULL);
    fontselectiondialog_icon_pixbuf = gdk_pixbuf_new_from_file(path, NULL);
    g_free(path);

    if (fontselectiondialog_icon_pixbuf) {
        gtk_window_set_icon(GTK_WINDOW(fontselectiondialog),
                            fontselectiondialog_icon_pixbuf);
        g_object_unref(fontselectiondialog_icon_pixbuf);
    }

    /* Commenting these lines out quells the error generated by
     * CFLAGS+="-DGSEAL_ENABLE".  This results in the Apply button being
     * shown, but it acts like the Cancel button.  This doesn't matter since
     * this function will likely be replaced with the transition to GTK+3 as
     * gtk_font_selection_dialog_new() has been replaced by
     * gtk_font_chooser_dialog_new().
     */
//    gtk_widget_destroy(GTK_FONT_SELECTION_DIALOG
//                       (fontselectiondialog)->apply_button);
    gtk_font_chooser_set_preview_text(
                            GTK_FONT_CHOOSER(fontselectiondialog),
                            _("How about this font?"));

    if (GPOINTER_TO_INT(user_data) == 1)
        gtk_font_chooser_set_font(
                            GTK_FONT_CHOOSER(fontselectiondialog),
                            preferences.dxfont);
    else
        gtk_font_chooser_set_font(
                            GTK_FONT_CHOOSER(fontselectiondialog),
                            preferences.allfont);

    gtk_widget_show_all(fontselectiondialog);
    response = gtk_dialog_run(GTK_DIALOG(fontselectiondialog));

    if (response == GTK_RESPONSE_OK) {
        font = gtk_font_chooser_get_font(
                            GTK_FONT_CHOOSER(fontselectiondialog));

        if (GPOINTER_TO_INT(user_data) == 1) {
            pfontsdxentry = g_object_get_data(G_OBJECT(preferencesdialog),
                                              "pfontsdxentry");
            gtk_entry_set_text(GTK_ENTRY(pfontsdxentry), font);
        } else {
            pfontsallentry = g_object_get_data(G_OBJECT(preferencesdialog),
                                               "pfontsallentry");
            gtk_entry_set_text(GTK_ENTRY(pfontsallentry), font);
        }

        g_free(font);
    }

    gtk_widget_destroy(fontselectiondialog);
}


/*
 * called from the menu
 */
void
on_settings_activate(GtkMenuItem    *menuitem,
                     gpointer        user_data)
{
    GtkWidget *pdialog_vbox, *pvbox1, *pvbox2, *pvbox3, *pvbox4,

              *pnotebook, *plabel1, *plabel2, *plabel3, *plabel4,

              *pcallsignframe, *pcallsignhbox, *pcallsignlabel, *pcallsignentry,

              *ploginframe, *ploginvbox, *pautologincheckbutton,
              *ploginhseparator, *pcommandshbox, *pcommandslabel, *pcommandsentry,

              *psavingframe, *psavingvbox, *psavedxcheckbutton, *psavewwvcheckbutton,
              *psavetoallcheckbutton, *psavewxcheckbutton, *psavinghbox,
              *psavingvbox2, *psavingvbox3,

              *phamlibframe, *phamlibvbox, *phamlibcheckbutton, *phamlibhseparator,
              *phamlibhbox, *priglabel, *prigentry,

              *pprogframe, *pprog_grid, *pprogbrowserlabel, *pprogbrowserentry,
              *pprogmaillabel, *pprogmailentry, *pprogsoundlabel,
              *pprogsoundentry,

              *pechoframe, *pechocheckbutton, *pechovbox, *plivecheckbutton,

              *pcolumnsframe, *pcolumnsvbox, *pcolumnsvboxlabel,
              *pcolumnshseparator, *pspottercheckbutton, *pqrgcheckbutton,
              *pdxcheckbutton, *premarkscheckbutton, *ptimecheckbutton,
              *pinfocheckbutton, *pcountrycheckbutton, *pcolumnshbox,
              *pcolumnsvbox2, *pcolumnsvbox3,

              *pfontsframe, *pfontsdxlabel, *pfontsalllabel, *pfontsdxentry,
              *pfontsallentry, *pfontsdxbutton, *pfontsallbutton,
              *pfontshseparator, *pfontshseparator2, *pfonts_grid,

              *pcolorsframe, *pcolorslabel, *pcolorsvbox, *promptcolorlabel,
              *promptcolorbutton, *sentcolorlabel, *pcolors_grid,
              *pcolors_separator, *sentcolorbutton, *wwvcolorlabel,
              *wwvcolorbutton, *wxcolorlabel, *wxcolorbutton,

              *phighframe, *phighvbox, *phighlabel, *phighseparator,
              *phighlight_grid,
              *phighlabel1, *colorbutton1, *phighlabel2, *colorbutton2,
              *phighlabel3, *colorbutton3, *phighlabel4, *colorbutton4,
              *phighlabel5, *colorbutton5, *phighlabel6, *colorbutton6,
              *phighlabel7, *colorbutton7, *phighlabel8, *colorbutton8;

    GtkTreeViewColumn *column;
    GtkWidget *treeview, *maintext, *mainentry;
    GtkWidget *highentry1, *highentry2, *highentry3, *highentry4, *highentry5,
              *highentry6, *highentry7, *highentry8;
    PangoFontDescription *font_description;
    gint response, pango_size;
    gboolean state;
    gchar *str;
    GtkTextBuffer *buffer;
    GdkRGBA color;

    gtk_widget_set_sensitive(gui->window, 0);
    preferencesdialog = gtk_dialog_new_with_buttons(_("Xdx - Preferences"),
                        GTK_WINDOW(gui->window),
                        GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                        _("_Cancel"),
                        GTK_RESPONSE_CANCEL,
                        _("_OK"),
                        GTK_RESPONSE_OK,
                        NULL);


    pdialog_vbox = gtk_dialog_get_content_area(GTK_DIALOG(preferencesdialog));

    pnotebook = gtk_notebook_new();

    pvbox1 = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    gtk_container_add(GTK_CONTAINER(pnotebook), pvbox1);

    pvbox2 = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    gtk_container_add(GTK_CONTAINER(pnotebook), pvbox2);

    pvbox3 = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    gtk_container_add(GTK_CONTAINER(pnotebook), pvbox3);

    pvbox4 = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    gtk_container_add(GTK_CONTAINER(pnotebook), pvbox4);

    plabel1 = gtk_label_new(_("General"));
    gtk_notebook_set_tab_label(GTK_NOTEBOOK(pnotebook),
                               gtk_notebook_get_nth_page(
                                   GTK_NOTEBOOK(pnotebook), 0), plabel1);

    plabel2 = gtk_label_new(_("Output"));
    gtk_notebook_set_tab_label(GTK_NOTEBOOK(pnotebook),
                               gtk_notebook_get_nth_page(
                                   GTK_NOTEBOOK(pnotebook), 1), plabel2);

    plabel3 = gtk_label_new(_("Fonts"));
    gtk_notebook_set_tab_label(GTK_NOTEBOOK(pnotebook),
                               gtk_notebook_get_nth_page(
                                   GTK_NOTEBOOK(pnotebook), 2), plabel3);

    plabel4 = gtk_label_new(_("Colors"));
    gtk_notebook_set_tab_label(GTK_NOTEBOOK(pnotebook),
                               gtk_notebook_get_nth_page(
                                   GTK_NOTEBOOK(pnotebook), 3), plabel4);
    gtk_box_pack_start(GTK_BOX(pdialog_vbox), pnotebook, TRUE, TRUE, 0);


    /* General tab */
    /* Callsign frame */
    pcallsignframe = gtk_frame_new(_("Callsign"));
    gtk_widget_set_margin_start(GTK_WIDGET(pcallsignframe), 5);
    gtk_widget_set_margin_end(GTK_WIDGET(pcallsignframe), 5);
    gtk_box_pack_start(GTK_BOX(pvbox1), pcallsignframe, TRUE, TRUE, 5);

    pcallsignhbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
    gtk_widget_set_margin_bottom(GTK_WIDGET(pcallsignhbox), 8);
    gtk_container_add(GTK_CONTAINER(pcallsignframe), pcallsignhbox);

    pcallsignlabel = gtk_label_new(_("Your callsign"));
    gtk_box_pack_start(GTK_BOX(pcallsignhbox), pcallsignlabel, FALSE, FALSE, 5);

    pcallsignentry = gtk_entry_new();
    gtk_entry_set_max_length(GTK_ENTRY(pcallsignentry), 15);
    gtk_box_pack_start(GTK_BOX(pcallsignhbox), pcallsignentry, TRUE, TRUE, 5);

    gtk_widget_set_tooltip_text(pcallsignentry,
                                _("Callsign to be used for login"));

    if (g_ascii_strcasecmp(preferences.callsign, "?"))
        gtk_entry_set_text(GTK_ENTRY(pcallsignentry), preferences.callsign);


    /* Login frame */
    ploginframe = gtk_frame_new(_("Login"));
    gtk_widget_set_margin_start(GTK_WIDGET(ploginframe), 5);
    gtk_widget_set_margin_end(GTK_WIDGET(ploginframe), 5);
    gtk_box_pack_start(GTK_BOX(pvbox1), ploginframe, TRUE, TRUE, 5);

    ploginvbox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    gtk_widget_set_margin_top(GTK_WIDGET(ploginvbox), 4);
    gtk_widget_set_margin_bottom(GTK_WIDGET(ploginvbox), 8);
    gtk_container_add(GTK_CONTAINER(ploginframe), ploginvbox);

    pautologincheckbutton = gtk_check_button_new_with_label(_("Enable autologin"));
    gtk_box_pack_start(GTK_BOX(ploginvbox), pautologincheckbutton, FALSE, FALSE, 0);

    ploginhseparator = gtk_separator_new(GTK_ORIENTATION_HORIZONTAL);
    gtk_box_pack_start(GTK_BOX(ploginvbox), ploginhseparator, TRUE, TRUE, 5);

    pcommandshbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
    gtk_box_pack_start(GTK_BOX(ploginvbox), pcommandshbox, TRUE, TRUE, 0);

    pcommandslabel = gtk_label_new(_("Commands"));
    gtk_box_pack_start(GTK_BOX(pcommandshbox), pcommandslabel, FALSE, FALSE, 5);

    pcommandsentry = gtk_entry_new();
    gtk_entry_set_max_length(GTK_ENTRY(pcommandsentry), 80);
    gtk_box_pack_start(GTK_BOX(pcommandshbox), pcommandsentry, TRUE, TRUE, 5);

    gtk_widget_set_tooltip_text(pcommandsentry,
                _("Comma separated list of commands to send at login"));

    if (preferences.autologin == 1) {
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pautologincheckbutton), TRUE);
        gtk_widget_set_sensitive(ploginhseparator, TRUE);
        gtk_widget_set_sensitive(pcommandslabel, TRUE);
        gtk_widget_set_sensitive(pcommandsentry, TRUE);
    } else {
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pautologincheckbutton), FALSE);
        gtk_widget_set_sensitive(ploginhseparator, FALSE);
        gtk_widget_set_sensitive(pcommandslabel, FALSE);
        gtk_widget_set_sensitive(pcommandsentry, FALSE);
    }

    if (g_ascii_strcasecmp(preferences.commands, "?"))
        gtk_entry_set_text(GTK_ENTRY(pcommandsentry), preferences.commands);


    /* Hamlib frame */
    phamlibframe = gtk_frame_new(_("Hamlib"));
    gtk_widget_set_margin_start(GTK_WIDGET(phamlibframe), 5);
    gtk_widget_set_margin_end(GTK_WIDGET(phamlibframe), 5);
    gtk_box_pack_start(GTK_BOX(pvbox1), phamlibframe, TRUE, TRUE, 5);

    phamlibvbox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    gtk_widget_set_margin_top(GTK_WIDGET(phamlibvbox), 4);
    gtk_widget_set_margin_bottom(GTK_WIDGET(phamlibvbox), 8);
    gtk_container_add(GTK_CONTAINER(phamlibframe), phamlibvbox);

    phamlibcheckbutton = gtk_check_button_new_with_label(_("Enable hamlib"));
    gtk_box_pack_start(GTK_BOX(phamlibvbox), phamlibcheckbutton, FALSE, FALSE, 0);

    phamlibhseparator = gtk_separator_new(GTK_ORIENTATION_HORIZONTAL);
    gtk_box_pack_start(GTK_BOX(phamlibvbox), phamlibhseparator, TRUE, TRUE, 5);

    phamlibhbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
    gtk_box_pack_start(GTK_BOX(phamlibvbox), phamlibhbox, TRUE, TRUE, 0);

    priglabel = gtk_label_new(_("Command for rigctl"));
    gtk_box_pack_start(GTK_BOX(phamlibhbox), priglabel, FALSE, FALSE, 5);

    prigentry = gtk_entry_new();
    gtk_entry_set_max_length(GTK_ENTRY(prigentry), 80);
    gtk_box_pack_start(GTK_BOX(phamlibhbox), prigentry, TRUE, TRUE, 5);

    gtk_widget_set_tooltip_text(prigentry, _(
        "When double clicking on a dx-spot this will set the frequency of your "
        "radio using rigctl (%d = the frequency retrieved from the DX spot)"));

    if (preferences.hamlib == 1) {
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(phamlibcheckbutton), TRUE);
        gtk_widget_set_sensitive(phamlibhseparator, TRUE);
        gtk_widget_set_sensitive(priglabel, TRUE);
        gtk_widget_set_sensitive(prigentry, TRUE);
    } else {
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(phamlibcheckbutton), FALSE);
        gtk_widget_set_sensitive(phamlibhseparator, FALSE);
        gtk_widget_set_sensitive(priglabel, FALSE);
        gtk_widget_set_sensitive(prigentry, FALSE);
    }

    if (g_ascii_strcasecmp(preferences.rigctl, "?"))
        gtk_entry_set_text(GTK_ENTRY(prigentry), preferences.rigctl);


    /* Programs frame */
    pprogframe = gtk_frame_new(_("Programs"));
    gtk_widget_set_margin_start(GTK_WIDGET(pprogframe), 5);
    gtk_widget_set_margin_end(GTK_WIDGET(pprogframe), 5);
    gtk_box_pack_start(GTK_BOX(pvbox1), pprogframe, TRUE, TRUE, 5);

    pprog_grid = gtk_grid_new();
    gtk_grid_set_column_spacing(GTK_GRID(pprog_grid), 10);
    gtk_grid_set_row_spacing(GTK_GRID(pprog_grid), 8);
    gtk_widget_set_margin_top(GTK_WIDGET(pprog_grid), 4);
    gtk_widget_set_margin_bottom(GTK_WIDGET(pprog_grid), 8);
    gtk_widget_set_margin_start(GTK_WIDGET(pprog_grid), 5);
    gtk_widget_set_margin_end(GTK_WIDGET(pprog_grid), 5);
    gtk_container_add(GTK_CONTAINER(pprogframe), pprog_grid);

    pprogbrowserlabel = gtk_label_new(_("Web browser"));
    gtk_grid_attach(GTK_GRID(pprog_grid), pprogbrowserlabel, 0, 0, 1, 1);

    pprogbrowserentry = gtk_entry_new();
    gtk_entry_set_width_chars(GTK_ENTRY(pprogbrowserentry), 25);
    gtk_entry_set_max_length(GTK_ENTRY(pprogbrowserentry), 80);
    gtk_grid_attach(GTK_GRID(pprog_grid), pprogbrowserentry, 1, 0, 1, 1);

    pprogmaillabel = gtk_label_new(_("Mail program"));
    gtk_grid_attach(GTK_GRID(pprog_grid), pprogmaillabel, 0, 1, 1, 1);

    pprogmailentry = gtk_entry_new();
    gtk_entry_set_max_length(GTK_ENTRY(pprogmailentry), 80);
    gtk_grid_attach(GTK_GRID(pprog_grid), pprogmailentry, 1, 1, 1, 1);

    pprogsoundlabel = gtk_label_new(_("Sound playing"));
    gtk_grid_attach(GTK_GRID(pprog_grid), pprogsoundlabel, 0, 2, 1, 1);

    pprogsoundentry = gtk_entry_new();
    gtk_entry_set_max_length(GTK_ENTRY(pprogmailentry), 80);
    gtk_grid_attach(GTK_GRID(pprog_grid), pprogsoundentry, 1, 2, 1, 1);

    gtk_widget_set_tooltip_text(pprogbrowserentry,
            _("Web browser to start after clicking on a url (%s = url)"));
    gtk_widget_set_tooltip_text(pprogmailentry,
            _("Mail program to start after clicking on a mail url (%s = mail url)"));
    gtk_widget_set_tooltip_text(pprogsoundentry,
            _("Program used to play sound (%s = sound file)"));

    if (g_ascii_strcasecmp(preferences.browserapp, "?"))
        gtk_entry_set_text(GTK_ENTRY(pprogbrowserentry), preferences.browserapp);

    if (g_ascii_strcasecmp(preferences.mailapp, "?"))
        gtk_entry_set_text(GTK_ENTRY(pprogmailentry), preferences.mailapp);

    if (g_ascii_strcasecmp(preferences.soundapp, "?"))
        gtk_entry_set_text(GTK_ENTRY(pprogsoundentry), preferences.soundapp);


    /* Output tab */
    /* General frame */
    pechoframe = gtk_frame_new(_("General"));
    gtk_widget_set_margin_start(GTK_WIDGET(pechoframe), 5);
    gtk_widget_set_margin_end(GTK_WIDGET(pechoframe), 5);
    gtk_box_pack_start(GTK_BOX(pvbox2), pechoframe, TRUE, TRUE, 5);

    pechovbox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    gtk_widget_set_margin_bottom(GTK_WIDGET(pechovbox), 8);
    gtk_container_add(GTK_CONTAINER(pechoframe), pechovbox);

    pechocheckbutton = gtk_check_button_new_with_label
                       (_("Echo sent text to the screen"));
    gtk_box_pack_start(GTK_BOX(pechovbox), pechocheckbutton, FALSE, FALSE, 5);

    plivecheckbutton = gtk_check_button_new_with_label
                       (_("Send keepalive packets (read the manual)"));
    gtk_box_pack_start(GTK_BOX(pechovbox), plivecheckbutton, FALSE, FALSE, 5);

    if (preferences.localecho == 1)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pechocheckbutton), TRUE);
    else
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pechocheckbutton), FALSE);

    if (preferences.keepalive == 1)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(plivecheckbutton), TRUE);
    else
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(plivecheckbutton), FALSE);


    /* Columns frame */
    pcolumnsframe = gtk_frame_new(_("Columns"));
    gtk_widget_set_margin_start(GTK_WIDGET(pcolumnsframe), 5);
    gtk_widget_set_margin_end(GTK_WIDGET(pcolumnsframe), 5);
    gtk_box_pack_start(GTK_BOX(pvbox2), pcolumnsframe, TRUE, TRUE, 5);

    pcolumnsvbox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    gtk_widget_set_margin_top(GTK_WIDGET(pcolumnsvbox), 4);
    gtk_widget_set_margin_bottom(GTK_WIDGET(pcolumnsvbox), 8);
    gtk_container_add(GTK_CONTAINER(pcolumnsframe), pcolumnsvbox);

    pcolumnsvboxlabel = gtk_label_new(_("Columns to show on the screen"));
    gtk_box_pack_start(GTK_BOX(pcolumnsvbox), pcolumnsvboxlabel, FALSE, FALSE, 5);

    pcolumnshseparator = gtk_separator_new(GTK_ORIENTATION_HORIZONTAL);
    gtk_box_pack_start(GTK_BOX(pcolumnsvbox), pcolumnshseparator, FALSE, FALSE, 5);

    pcolumnshbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
    gtk_box_pack_start(GTK_BOX(pcolumnsvbox), pcolumnshbox, FALSE, FALSE, 0);

    pcolumnsvbox2 = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    gtk_box_pack_start(GTK_BOX(pcolumnshbox), pcolumnsvbox2, TRUE, TRUE, 0);

    pspottercheckbutton = gtk_check_button_new_with_label(_("Spotter"));
    gtk_box_pack_start(GTK_BOX(pcolumnsvbox2), pspottercheckbutton, FALSE, FALSE, 0);

    pqrgcheckbutton = gtk_check_button_new_with_label("QRG");
    gtk_box_pack_start(GTK_BOX(pcolumnsvbox2), pqrgcheckbutton, FALSE, FALSE, 0);

    pdxcheckbutton = gtk_check_button_new_with_label("DX");
    gtk_box_pack_start(GTK_BOX(pcolumnsvbox2), pdxcheckbutton, FALSE, FALSE, 0);

    pcolumnsvbox3 = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    gtk_box_pack_start(GTK_BOX(pcolumnshbox), pcolumnsvbox3, TRUE, TRUE, 0);

    premarkscheckbutton = gtk_check_button_new_with_label(_("Remarks"));
    gtk_box_pack_start(GTK_BOX(pcolumnsvbox3), premarkscheckbutton, FALSE, FALSE, 0);

    ptimecheckbutton = gtk_check_button_new_with_label(_("Time"));
    gtk_box_pack_start(GTK_BOX(pcolumnsvbox3), ptimecheckbutton, FALSE, FALSE, 0);

    pinfocheckbutton = gtk_check_button_new_with_label(_("Info"));
    gtk_box_pack_start(GTK_BOX(pcolumnsvbox3), pinfocheckbutton, FALSE, FALSE, 0);

    pcountrycheckbutton = gtk_check_button_new_with_label(_("Country"));
    gtk_box_pack_start(GTK_BOX(pcolumnsvbox3), pcountrycheckbutton, FALSE, FALSE, 0);

    if (preferences.col0visible == 1)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pspottercheckbutton), TRUE);
    else
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pspottercheckbutton), FALSE);

    if (preferences.col1visible == 1)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pqrgcheckbutton), TRUE);
    else
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pqrgcheckbutton), FALSE);

    if (preferences.col2visible == 1)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pdxcheckbutton), TRUE);
    else
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pdxcheckbutton), FALSE);

    if (preferences.col3visible == 1)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(premarkscheckbutton), TRUE);
    else
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(premarkscheckbutton), FALSE);

    if (preferences.col4visible == 1)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ptimecheckbutton), TRUE);
    else
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ptimecheckbutton), FALSE);

    if (preferences.col5visible == 1)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pinfocheckbutton), TRUE);
    else
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pinfocheckbutton), FALSE);

    if (preferences.col6visible == 1)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pcountrycheckbutton), TRUE);
    else
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pcountrycheckbutton), FALSE);


    /* Saving frame */
    psavingframe = gtk_frame_new(_("Saving"));
    gtk_widget_set_margin_start(GTK_WIDGET(psavingframe), 5);
    gtk_widget_set_margin_end(GTK_WIDGET(psavingframe), 5);
    gtk_box_pack_start(GTK_BOX(pvbox2), psavingframe, TRUE, TRUE, 5);

    psavingvbox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    gtk_widget_set_margin_top(GTK_WIDGET(psavingvbox), 4);
    gtk_widget_set_margin_bottom(GTK_WIDGET(psavingvbox), 8);
    gtk_container_add(GTK_CONTAINER(psavingframe), psavingvbox);

    psavinghbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
    gtk_box_pack_start(GTK_BOX(psavingvbox), psavinghbox, FALSE, FALSE, 0);

    psavingvbox2 = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    gtk_box_pack_start(GTK_BOX(psavinghbox), psavingvbox2, TRUE, TRUE, 0);

    psavedxcheckbutton = gtk_check_button_new_with_label(_("Save DX spots"));
    gtk_box_pack_start(GTK_BOX(psavingvbox2), psavedxcheckbutton, FALSE, FALSE, 0);

    psavewwvcheckbutton = gtk_check_button_new_with_label(_("Save WCY/WWV"));
    gtk_box_pack_start(GTK_BOX(psavingvbox2), psavewwvcheckbutton, FALSE, FALSE, 0);

    psavingvbox3 = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    gtk_box_pack_start(GTK_BOX(psavinghbox), psavingvbox3, TRUE, TRUE, 0);

    psavetoallcheckbutton = gtk_check_button_new_with_label(_("Save \"To all\""));
    gtk_box_pack_start(GTK_BOX(psavingvbox3), psavetoallcheckbutton, FALSE, FALSE, 0);

    psavewxcheckbutton = gtk_check_button_new_with_label(_("Save WX"));
    gtk_box_pack_start(GTK_BOX(psavingvbox3), psavewxcheckbutton, FALSE, FALSE, 0);

    if (preferences.savedx == 1)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(psavedxcheckbutton), TRUE);
    else
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(psavedxcheckbutton), FALSE);

    if (preferences.savewwv == 1)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(psavewwvcheckbutton), TRUE);
    else
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(psavewwvcheckbutton), FALSE);

    if (preferences.savetoall == 1)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(psavetoallcheckbutton), TRUE);
    else
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(psavetoallcheckbutton), FALSE);

    if (preferences.savewx == 1)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(psavewxcheckbutton), TRUE);
    else
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(psavewxcheckbutton), FALSE);


    /* Fonts tab */
    /* General frame */
    pfontsframe = gtk_frame_new(_("Fonts"));
    gtk_widget_set_margin_start(GTK_WIDGET(pfontsframe), 5);
    gtk_widget_set_margin_end(GTK_WIDGET(pfontsframe), 5);
    gtk_box_pack_start(GTK_BOX(pvbox3), pfontsframe, TRUE, TRUE, 5);

    pfonts_grid = gtk_grid_new();
    gtk_grid_set_column_spacing(GTK_GRID(pfonts_grid), 10);
    gtk_grid_set_row_spacing(GTK_GRID(pfonts_grid), 8);
    gtk_widget_set_margin_top(GTK_WIDGET(pfonts_grid), 4);
    gtk_widget_set_margin_bottom(GTK_WIDGET(pfonts_grid), 8);
    gtk_widget_set_margin_start(GTK_WIDGET(pfonts_grid), 5);
    gtk_widget_set_margin_end(GTK_WIDGET(pfonts_grid), 5);
    gtk_container_add(GTK_CONTAINER(pfontsframe), pfonts_grid);

    pfontsdxlabel = gtk_label_new(_("Font for DX spots window"));
    gtk_grid_attach(GTK_GRID(pfonts_grid), pfontsdxlabel, 0, 0, 2, 1);

    pfontshseparator = gtk_separator_new(GTK_ORIENTATION_HORIZONTAL);
    gtk_grid_attach(GTK_GRID(pfonts_grid), pfontshseparator, 0, 1, 2, 1);

    pfontsdxentry = gtk_entry_new();
    gtk_entry_set_text(GTK_ENTRY(pfontsdxentry), preferences.dxfont);
    gtk_editable_set_editable(GTK_EDITABLE(pfontsdxentry), FALSE);
    gtk_entry_set_width_chars(GTK_ENTRY(pfontsdxentry), 25);
    gtk_grid_attach(GTK_GRID(pfonts_grid), pfontsdxentry, 0, 2, 1, 1);

    pfontsdxbutton = gtk_button_new_with_mnemonic(_("Select _DX Font"));
    gtk_grid_attach(GTK_GRID(pfonts_grid), pfontsdxbutton, 1, 2, 1, 1);

    pfontsalllabel = gtk_label_new(_("Font for message/chat window"));
    gtk_grid_attach(GTK_GRID(pfonts_grid), pfontsalllabel, 0, 3, 2, 1);

    pfontshseparator2 = gtk_separator_new(GTK_ORIENTATION_HORIZONTAL);
    gtk_grid_attach(GTK_GRID(pfonts_grid), pfontshseparator2, 0, 4, 2, 1);

    pfontsallentry = gtk_entry_new();
    gtk_entry_set_text(GTK_ENTRY(pfontsallentry), preferences.allfont);
    gtk_editable_set_editable(GTK_EDITABLE(pfontsallentry), FALSE);
    gtk_grid_attach(GTK_GRID(pfonts_grid), pfontsallentry, 0, 5, 1, 1);

    pfontsallbutton = gtk_button_new_with_mnemonic(_("Select _Other Fonts"));
    gtk_grid_attach(GTK_GRID(pfonts_grid), pfontsallbutton, 1, 5, 1, 1);


    /* Colors tab */
    /* Chat Window Colors frame */
    pcolorsframe = gtk_frame_new(_("DX cluster messsage highlighting"));
    gtk_widget_set_margin_start(GTK_WIDGET(pcolorsframe), 5);
    gtk_widget_set_margin_end(GTK_WIDGET(pcolorsframe), 5);
    gtk_box_pack_start(GTK_BOX(pvbox4), pcolorsframe, FALSE, FALSE, 5);

    pcolorsvbox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    gtk_widget_set_margin_top(GTK_WIDGET(pcolorsvbox), 4);
    gtk_widget_set_margin_bottom(GTK_WIDGET(pcolorsvbox), 8);
    gtk_container_add(GTK_CONTAINER(pcolorsframe), pcolorsvbox);

    pcolorslabel = gtk_label_new(
            _("Colors for DX Cluster highlighting"));
    gtk_label_set_line_wrap(GTK_LABEL(pcolorslabel), TRUE);
    gtk_box_pack_start(GTK_BOX(pcolorsvbox), pcolorslabel, FALSE, FALSE, 5);

    pcolors_separator =  gtk_separator_new(GTK_ORIENTATION_HORIZONTAL);
    gtk_box_pack_start(GTK_BOX(pcolorsvbox), pcolors_separator, FALSE, FALSE, 5);

    pcolors_grid = gtk_grid_new();
    gtk_grid_set_column_spacing(GTK_GRID(pcolors_grid), 10);
    gtk_grid_set_row_spacing(GTK_GRID(pcolors_grid), 8);
    gtk_widget_set_margin_top(GTK_WIDGET(pcolors_grid), 4);
    gtk_widget_set_margin_bottom(GTK_WIDGET(pcolors_grid), 8);
    gtk_widget_set_margin_start(GTK_WIDGET(pcolors_grid), 5);
    gtk_widget_set_margin_end(GTK_WIDGET(pcolors_grid), 5);
    gtk_grid_set_column_homogeneous(GTK_GRID(pcolors_grid), TRUE);
    gtk_container_add(GTK_CONTAINER(pcolorsvbox), pcolors_grid);

    promptcolorlabel = gtk_label_new(_("Prompt"));
    gtk_widget_set_halign(GTK_WIDGET(promptcolorlabel), GTK_ALIGN_END);
    gtk_grid_attach(GTK_GRID(pcolors_grid), promptcolorlabel, 0, 0, 1, 1);

    promptcolorbutton = gtk_color_button_new_with_rgba(&preferences.promptcolor);
    gtk_grid_attach(GTK_GRID(pcolors_grid), promptcolorbutton, 1, 0, 1, 1);

    sentcolorlabel = gtk_label_new(_("Sent text"));
    gtk_widget_set_halign(GTK_WIDGET(sentcolorlabel), GTK_ALIGN_END);
    gtk_grid_attach(GTK_GRID(pcolors_grid), sentcolorlabel, 0, 1, 1, 1);

    sentcolorbutton = gtk_color_button_new_with_rgba(&preferences.sentcolor);
    gtk_grid_attach(GTK_GRID(pcolors_grid), sentcolorbutton, 1, 1, 1, 1);

    wwvcolorlabel = gtk_label_new("WWV / WCY");
    gtk_widget_set_halign(GTK_WIDGET(wwvcolorlabel), GTK_ALIGN_END);
    gtk_grid_attach(GTK_GRID(pcolors_grid), wwvcolorlabel, 2, 0, 1, 1);

    wwvcolorbutton = gtk_color_button_new_with_rgba(&preferences.wwvcolor);
    gtk_grid_attach(GTK_GRID(pcolors_grid), wwvcolorbutton, 3, 0, 1, 1);

    wxcolorlabel = gtk_label_new("WX");
    gtk_widget_set_halign(GTK_WIDGET(wxcolorlabel), GTK_ALIGN_END);
    gtk_grid_attach(GTK_GRID(pcolors_grid), wxcolorlabel, 2, 1, 1, 1);

    wxcolorbutton = gtk_color_button_new_with_rgba(&preferences.wxcolor);
    gtk_grid_attach(GTK_GRID(pcolors_grid), wxcolorbutton, 3, 1, 1, 1);


    /* Highlighting frame */
    phighframe = gtk_frame_new(_("Chat window user highlighting"));
    gtk_widget_set_margin_start(GTK_WIDGET(phighframe), 5);
    gtk_widget_set_margin_end(GTK_WIDGET(phighframe), 5);
    gtk_box_pack_start(GTK_BOX(pvbox4), phighframe, TRUE, TRUE, 5);

    phighvbox = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    gtk_widget_set_margin_top(GTK_WIDGET(phighvbox), 4);
    gtk_widget_set_margin_bottom(GTK_WIDGET(phighvbox), 8);
    gtk_container_add(GTK_CONTAINER(phighframe), phighvbox);

    phighlabel = gtk_label_new(
            _("Colors for user selected highlighting"));
    gtk_label_set_line_wrap(GTK_LABEL(phighlabel), TRUE);
    gtk_box_pack_start(GTK_BOX(phighvbox), phighlabel, FALSE, FALSE, 5);

    phighseparator =  gtk_separator_new(GTK_ORIENTATION_HORIZONTAL);
    gtk_box_pack_start(GTK_BOX(phighvbox), phighseparator, FALSE, FALSE, 5);

    phighlight_grid = gtk_grid_new();
    gtk_grid_set_column_spacing(GTK_GRID(phighlight_grid), 10);
    gtk_grid_set_row_spacing(GTK_GRID(phighlight_grid), 8);
    gtk_widget_set_margin_top(GTK_WIDGET(phighlight_grid), 4);
    gtk_widget_set_margin_bottom(GTK_WIDGET(phighlight_grid), 8);
    gtk_widget_set_margin_start(GTK_WIDGET(phighlight_grid), 5);
    gtk_widget_set_margin_end(GTK_WIDGET(phighlight_grid), 5);
    gtk_grid_set_column_homogeneous(GTK_GRID(phighlight_grid), TRUE);
    gtk_container_add(GTK_CONTAINER(phighvbox), phighlight_grid);

    phighlabel1 = gtk_label_new(_("Color 1"));
    gtk_widget_set_halign(GTK_WIDGET(phighlabel1), GTK_ALIGN_END);
    gtk_grid_attach(GTK_GRID(phighlight_grid), phighlabel1, 0, 0, 1, 1);

    colorbutton1 = gtk_color_button_new_with_rgba(&preferences.highcolor1);
    gtk_grid_attach(GTK_GRID(phighlight_grid), colorbutton1, 1, 0, 1, 1);

    phighlabel2 = gtk_label_new(_("Color 2"));
    gtk_widget_set_halign(GTK_WIDGET(phighlabel2), GTK_ALIGN_END);
    gtk_grid_attach(GTK_GRID(phighlight_grid), phighlabel2, 0, 1, 1, 1);

    colorbutton2 = gtk_color_button_new_with_rgba(&preferences.highcolor2);
    gtk_grid_attach(GTK_GRID(phighlight_grid), colorbutton2, 1, 1, 1, 1);

    phighlabel3 = gtk_label_new(_("Color 3"));
    gtk_widget_set_halign(GTK_WIDGET(phighlabel3), GTK_ALIGN_END);
    gtk_grid_attach(GTK_GRID(phighlight_grid), phighlabel3, 0, 2, 1, 1);

    colorbutton3 = gtk_color_button_new_with_rgba(&preferences.highcolor3);
    gtk_grid_attach(GTK_GRID(phighlight_grid), colorbutton3, 1, 2, 1, 1);

    phighlabel4 = gtk_label_new(_("Color 4"));
    gtk_widget_set_halign(GTK_WIDGET(phighlabel4), GTK_ALIGN_END);
    gtk_grid_attach(GTK_GRID(phighlight_grid), phighlabel4, 0, 3, 1, 1);

    colorbutton4 = gtk_color_button_new_with_rgba(&preferences.highcolor4);
    gtk_grid_attach(GTK_GRID(phighlight_grid), colorbutton4, 1, 3, 1, 1);

    phighlabel5 = gtk_label_new(_("Color 5"));
    gtk_widget_set_halign(GTK_WIDGET(phighlabel5), GTK_ALIGN_END);
    gtk_grid_attach(GTK_GRID(phighlight_grid), phighlabel5, 2, 0, 1, 1);

    colorbutton5 = gtk_color_button_new_with_rgba(&preferences.highcolor5);
    gtk_grid_attach(GTK_GRID(phighlight_grid), colorbutton5, 3, 0, 1, 1);

    phighlabel6 = gtk_label_new(_("Color 6"));
    gtk_widget_set_halign(GTK_WIDGET(phighlabel6), GTK_ALIGN_END);
    gtk_grid_attach(GTK_GRID(phighlight_grid), phighlabel6, 2, 1, 1, 1);

    colorbutton6 = gtk_color_button_new_with_rgba(&preferences.highcolor6);
    gtk_grid_attach(GTK_GRID(phighlight_grid), colorbutton6, 3, 1, 1, 1);

    phighlabel7 = gtk_label_new(_("Color 7"));
    gtk_widget_set_halign(GTK_WIDGET(phighlabel7), GTK_ALIGN_END);
    gtk_grid_attach(GTK_GRID(phighlight_grid), phighlabel7, 2, 2, 1, 1);

    colorbutton7 = gtk_color_button_new_with_rgba(&preferences.highcolor7);
    gtk_grid_attach(GTK_GRID(phighlight_grid), colorbutton7, 3, 2, 1, 1);

    phighlabel8 = gtk_label_new(_("Color 8"));
    gtk_widget_set_halign(GTK_WIDGET(phighlabel8), GTK_ALIGN_END);
    gtk_grid_attach(GTK_GRID(phighlight_grid), phighlabel8, 2, 3, 1, 1);

    colorbutton8 = gtk_color_button_new_with_rgba(&preferences.highcolor8);
    gtk_grid_attach(GTK_GRID(phighlight_grid), colorbutton8, 3, 3, 1, 1);


    g_signal_connect((gpointer) pautologincheckbutton, "toggled",
                     G_CALLBACK(on_pautologincheckbutton_toggled), NULL);
    g_signal_connect((gpointer) phamlibcheckbutton, "toggled",
                     G_CALLBACK(on_phamlibcheckbutton_toggled), NULL);
    g_signal_connect((gpointer) pfontsdxbutton, "clicked",
                     G_CALLBACK(on_fontbutton_clicked), GINT_TO_POINTER(1));
    g_signal_connect((gpointer) pfontsallbutton, "clicked",
                     G_CALLBACK(on_fontbutton_clicked), GINT_TO_POINTER(2));

    g_object_set_data(G_OBJECT(preferencesdialog), "ploginhseparator",
                      ploginhseparator);
    g_object_set_data(G_OBJECT(preferencesdialog), "pcallsignlabel",
                      pcallsignlabel);
    g_object_set_data(G_OBJECT(preferencesdialog), "pcallsignentry",
                      pcallsignentry);
    g_object_set_data(G_OBJECT(preferencesdialog), "pcommandslabel",
                      pcommandslabel);
    g_object_set_data(G_OBJECT(preferencesdialog), "pcommandsentry",
                      pcommandsentry);

    g_object_set_data(G_OBJECT(preferencesdialog), "phamlibhseparator",
                      phamlibhseparator);
    g_object_set_data(G_OBJECT(preferencesdialog), "priglabel",
                      priglabel);
    g_object_set_data(G_OBJECT(preferencesdialog), "prigentry",
                      prigentry);

    g_object_set_data(G_OBJECT(preferencesdialog), "pfontsdxentry",
                      pfontsdxentry);
    g_object_set_data(G_OBJECT(preferencesdialog), "pfontsallentry",
                      pfontsallentry);

    gtk_widget_show_all(pnotebook);
    response = gtk_dialog_run(GTK_DIALOG(preferencesdialog));

    if (response == GTK_RESPONSE_OK) {
        /* callsign frame */
        str = gtk_editable_get_chars(GTK_EDITABLE(pcallsignentry), 0, -1);

        if (strlen(str) == 0)
            preferences.callsign = g_strdup("N0CALL");
        else
            preferences.callsign = g_strdup(str);

        /* login frame */
        state = gtk_toggle_button_get_active
                (GTK_TOGGLE_BUTTON(pautologincheckbutton));

        if (state)
            preferences.autologin = 1;
        else
            preferences.autologin = 0;

        str = gtk_editable_get_chars(GTK_EDITABLE(pcommandsentry), 0, -1);

        if (strlen(str) == 0)
            preferences.commands = g_strdup("?");
        else
            preferences.commands = g_strdup(str);

        /* saving frame */
        state = gtk_toggle_button_get_active
                (GTK_TOGGLE_BUTTON(psavedxcheckbutton));

        if (state)
            preferences.savedx = 1;
        else
            preferences.savedx = 0;

        state = gtk_toggle_button_get_active
                (GTK_TOGGLE_BUTTON(psavewwvcheckbutton));

        if (state)
            preferences.savewwv = 1;
        else
            preferences.savewwv = 0;

        state = gtk_toggle_button_get_active
                (GTK_TOGGLE_BUTTON(psavetoallcheckbutton));

        if (state)
            preferences.savetoall = 1;
        else
            preferences.savetoall = 0;

        state = gtk_toggle_button_get_active
                (GTK_TOGGLE_BUTTON(psavewxcheckbutton));

        if (state)
            preferences.savewx = 1;
        else
            preferences.savewx = 0;

        /* hamlib frame */
        state = gtk_toggle_button_get_active
                (GTK_TOGGLE_BUTTON(phamlibcheckbutton));

        if (state)
            preferences.hamlib = 1;
        else
            preferences.hamlib = 0;

        str = gtk_editable_get_chars(GTK_EDITABLE(prigentry), 0, -1);

        if (strlen(str) == 0)
            preferences.rigctl = g_strdup("?");
        else
            preferences.rigctl = g_strdup(str);

        /* programs frame */
        str = gtk_editable_get_chars(GTK_EDITABLE(pprogbrowserentry), 0, -1);

        if (strlen(str) == 0)
            preferences.browserapp = g_strdup("?");
        else
            preferences.browserapp = g_strdup(str);

        str = gtk_editable_get_chars(GTK_EDITABLE(pprogmailentry), 0, -1);

        if (strlen(str) == 0)
            preferences.mailapp = g_strdup("?");
        else
            preferences.mailapp = g_strdup(str);

        str = gtk_editable_get_chars(GTK_EDITABLE(pprogsoundentry), 0, -1);

        if (strlen(str) == 0)
            preferences.soundapp = g_strdup("?");
        else
            preferences.soundapp = g_strdup(str);

        /* general frame */
        state = gtk_toggle_button_get_active
                (GTK_TOGGLE_BUTTON(pechocheckbutton));

        if (state)
            preferences.localecho = 1;
        else
            preferences.localecho = 0;

        state = gtk_toggle_button_get_active
                (GTK_TOGGLE_BUTTON(plivecheckbutton));

        if (state)
            preferences.keepalive = 1;
        else
            preferences.keepalive = 0;

        /* columns frame */
        treeview = g_object_get_data(G_OBJECT(gui->window), "treeview");
        state = gtk_toggle_button_get_active
                (GTK_TOGGLE_BUTTON(pspottercheckbutton));
        column = gtk_tree_view_get_column(GTK_TREE_VIEW(treeview), 0);

        if (state) {
            gtk_tree_view_column_set_visible(GTK_TREE_VIEW_COLUMN(column), TRUE);

            if (preferences.col0visible == 0)
                gtk_tree_view_column_set_fixed_width(column, COL0WIDTH);

            preferences.col0visible = 1;
        } else {
            gtk_tree_view_column_set_visible(GTK_TREE_VIEW_COLUMN(column), FALSE);
            preferences.col0visible = 0;
        }

        state = gtk_toggle_button_get_active
                (GTK_TOGGLE_BUTTON(pqrgcheckbutton));
        column = gtk_tree_view_get_column(GTK_TREE_VIEW(treeview), 1);

        if (state) {
            gtk_tree_view_column_set_visible(GTK_TREE_VIEW_COLUMN(column), TRUE);

            if (preferences.col1visible == 0)
                gtk_tree_view_column_set_fixed_width(column, COL1WIDTH);

            preferences.col1visible = 1;
        } else {
            gtk_tree_view_column_set_visible(GTK_TREE_VIEW_COLUMN(column), FALSE);
            preferences.col1visible = 0;
        }

        state = gtk_toggle_button_get_active
                (GTK_TOGGLE_BUTTON(pdxcheckbutton));
        column = gtk_tree_view_get_column(GTK_TREE_VIEW(treeview), 2);

        if (state) {
            gtk_tree_view_column_set_visible(GTK_TREE_VIEW_COLUMN(column), TRUE);

            if (preferences.col2visible == 0)
                gtk_tree_view_column_set_fixed_width(column, COL2WIDTH);

            preferences.col2visible = 1;
        } else {
            gtk_tree_view_column_set_visible(GTK_TREE_VIEW_COLUMN(column), FALSE);
            preferences.col2visible = 0;
        }

        state = gtk_toggle_button_get_active
                (GTK_TOGGLE_BUTTON(premarkscheckbutton));
        column = gtk_tree_view_get_column(GTK_TREE_VIEW(treeview), 3);

        if (state) {
            gtk_tree_view_column_set_visible(GTK_TREE_VIEW_COLUMN(column), TRUE);

            if (preferences.col3visible == 0)
                gtk_tree_view_column_set_fixed_width(column, COL3WIDTH);

            preferences.col3visible = 1;
        } else {
            gtk_tree_view_column_set_visible(GTK_TREE_VIEW_COLUMN(column), FALSE);
            preferences.col3visible = 0;
        }

        state = gtk_toggle_button_get_active
                (GTK_TOGGLE_BUTTON(ptimecheckbutton));
        column = gtk_tree_view_get_column(GTK_TREE_VIEW(treeview), 4);

        if (state) {
            gtk_tree_view_column_set_visible(GTK_TREE_VIEW_COLUMN(column), TRUE);

            if (preferences.col4visible == 0)
                gtk_tree_view_column_set_fixed_width(column, COL4WIDTH);

            preferences.col4visible = 1;
        } else {
            gtk_tree_view_column_set_visible(GTK_TREE_VIEW_COLUMN(column), FALSE);
            preferences.col4visible = 0;
        }

        state = gtk_toggle_button_get_active
                (GTK_TOGGLE_BUTTON(pinfocheckbutton));
        column = gtk_tree_view_get_column(GTK_TREE_VIEW(treeview), 5);

        if (state) {
            gtk_tree_view_column_set_visible(GTK_TREE_VIEW_COLUMN(column), TRUE);

            if (preferences.col5visible == 0)
                gtk_tree_view_column_set_fixed_width(column, COL5WIDTH);

            preferences.col5visible = 1;
        } else {
            gtk_tree_view_column_set_visible(GTK_TREE_VIEW_COLUMN(column), FALSE);
            preferences.col5visible = 0;
        }

        state = gtk_toggle_button_get_active
                (GTK_TOGGLE_BUTTON(pcountrycheckbutton));
        column = gtk_tree_view_get_column(GTK_TREE_VIEW(treeview), 6);

        if (state) {
            gtk_tree_view_column_set_visible(GTK_TREE_VIEW_COLUMN(column), TRUE);

            if (preferences.col6visible == 0)
                gtk_tree_view_column_set_fixed_width(column, COL6WIDTH);

            preferences.col6visible = 1;
        } else {
            gtk_tree_view_column_set_visible(GTK_TREE_VIEW_COLUMN(column), FALSE);
            preferences.col6visible = 0;
        }

        /* fonts frame */
        str = gtk_editable_get_chars(GTK_EDITABLE(pfontsdxentry), 0, -1);
        font_description = pango_font_description_from_string(str);
/* Employ GCC diagnostic pragma to suppress warnings on these "deprecated"
 * functions.  This absurdity is brought about due to the intent that CSS
 * is used for theming but if using already existing interfaces such as pango
 * font names the developer must come up with a solution to convert such names
 * to CSS.  The library does not have such support.
 *
 * Source:  https://discourse.gnome.org/t/converting-fontchooser-font-style-to-css-font-style/6599
 */
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
        gtk_widget_override_font(GTK_WIDGET(treeview), font_description);
#pragma GCC diagnostic pop
        pango_font_description_free(font_description);
        preferences.dxfont = g_strdup(str);

        str = gtk_editable_get_chars(GTK_EDITABLE(pfontsallentry), 0, -1);
        font_description = pango_font_description_from_string(str);
        maintext = g_object_get_data(G_OBJECT(gui->window), "maintext");
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
        gtk_widget_override_font(GTK_WIDGET(maintext), font_description);
#pragma GCC diagnostic pop
        pango_size = pango_font_description_get_size(font_description);
        /* line spacing is half character size */
        g_object_set(G_OBJECT(maintext), "pixels-below-lines",
                     PANGO_PIXELS(pango_size) / 2, NULL);
        pango_font_description_free(font_description);
        preferences.allfont = g_strdup(str);

        /* highlights frame*/
        buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(maintext));

        /* User selected colors for user defined word highlighting. */
        gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(colorbutton1), &color);

        if (! gdk_rgba_equal(&color, &preferences.highcolor1)) {
            gui->high1tagname = g_strdup_printf("%d", rand());
            gtk_text_buffer_create_tag(buffer,
                                       gui->high1tagname,
                                       "foreground-rgba",
                                       &color,
                                       NULL);
            highentry1 = g_object_get_data(G_OBJECT(gui->window), "highentry1");
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
            gtk_widget_override_color(highentry1,
                                      GTK_STATE_FLAG_NORMAL,
                                      &color);
#pragma GCC diagnostic pop
            preferences.highcolor1 = color;
        }

        gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(colorbutton2), &color);

        if (! gdk_rgba_equal(&color, &preferences.highcolor2)) {
            gui->high2tagname = g_strdup_printf("%d", rand());
            gtk_text_buffer_create_tag(buffer,
                                       gui->high2tagname,
                                       "foreground-rgba",
                                       &color,
                                       NULL);
            highentry2 = g_object_get_data(G_OBJECT(gui->window), "highentry2");
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
            gtk_widget_override_color(highentry2,
                                      GTK_STATE_FLAG_NORMAL,
                                      &color);
#pragma GCC diagnostic pop
            preferences.highcolor2 = color;
        }

        gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(colorbutton3), &color);

        if (! gdk_rgba_equal(&color, &preferences.highcolor3)) {
            gui->high3tagname = g_strdup_printf("%d", rand());
            gtk_text_buffer_create_tag(buffer,
                                       gui->high3tagname,
                                       "foreground-rgba",
                                       &color,
                                       NULL);
            highentry3 = g_object_get_data(G_OBJECT(gui->window), "highentry3");
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
            gtk_widget_override_color(highentry3,
                                      GTK_STATE_FLAG_NORMAL,
                                      &color);
#pragma GCC diagnostic pop
            preferences.highcolor3 = color;
        }

        gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(colorbutton4), &color);

        if (! gdk_rgba_equal(&color, &preferences.highcolor4)) {
            gui->high4tagname = g_strdup_printf("%d", rand());
            gtk_text_buffer_create_tag(buffer,
                                       gui->high4tagname,
                                       "foreground-rgba",
                                       &color,
                                       NULL);
            highentry4 = g_object_get_data(G_OBJECT(gui->window), "highentry4");
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
            gtk_widget_override_color(highentry4,
                                      GTK_STATE_FLAG_NORMAL,
                                      &color);
#pragma GCC diagnostic pop
            preferences.highcolor4 = color;
        }

        gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(colorbutton5), &color);

        if (! gdk_rgba_equal(&color, &preferences.highcolor5)) {
            gui->high5tagname = g_strdup_printf("%d", rand());
            gtk_text_buffer_create_tag(buffer,
                                       gui->high5tagname,
                                       "foreground-rgba",
                                       &color,
                                       NULL);
            highentry5 = g_object_get_data(G_OBJECT(gui->window), "highentry5");
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
            gtk_widget_override_color(highentry5,
                                      GTK_STATE_FLAG_NORMAL,
                                      &color);
#pragma GCC diagnostic pop
            preferences.highcolor5 = color;
        }

        gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(colorbutton6), &color);

        if (! gdk_rgba_equal(&color, &preferences.highcolor6)) {
            gui->high6tagname = g_strdup_printf("%d", rand());
            gtk_text_buffer_create_tag(buffer,
                                       gui->high6tagname,
                                       "foreground-rgba",
                                       &color,
                                       NULL);
            highentry6 = g_object_get_data(G_OBJECT(gui->window), "highentry6");
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
            gtk_widget_override_color(highentry6,
                                      GTK_STATE_FLAG_NORMAL,
                                      &color);
#pragma GCC diagnostic pop
            preferences.highcolor6 = color;
        }

        gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(colorbutton7), &color);

        if (! gdk_rgba_equal(&color, &preferences.highcolor7)) {
            gui->high7tagname = g_strdup_printf("%d", rand());
            gtk_text_buffer_create_tag(buffer,
                                       gui->high7tagname,
                                       "foreground-rgba",
                                       &color,
                                       NULL);
            highentry7 = g_object_get_data(G_OBJECT(gui->window), "highentry7");
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
            gtk_widget_override_color(highentry7,
                                      GTK_STATE_FLAG_NORMAL,
                                      &color);
#pragma GCC diagnostic pop
            preferences.highcolor7 = color;
        }

        gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(colorbutton8), &color);

        if (! gdk_rgba_equal(&color, &preferences.highcolor8)) {
            gui->high8tagname = g_strdup_printf("%d", rand());
            gtk_text_buffer_create_tag(buffer,
                                       gui->high8tagname,
                                       "foreground-rgba",
                                       &color,
                                       NULL);
            highentry8 = g_object_get_data(G_OBJECT(gui->window), "highentry8");
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
            gtk_widget_override_color(highentry8,
                                      GTK_STATE_FLAG_NORMAL,
                                      &color);
#pragma GCC diagnostic pop
            preferences.highcolor8 = color;
        }

        /* User selected colors for Xdx defined string highlighting. */
        gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(promptcolorbutton), &color);

        if (! gdk_rgba_equal(&color, &preferences.promptcolor)) {
            gui->prompttagname = g_strdup_printf("%d", rand());
            gtk_text_buffer_create_tag(buffer,
                                       gui->prompttagname,
                                       "foreground-rgba",
                                       &color,
                                       NULL);
            gui->calltagname = g_strdup_printf("%d", rand());
            gtk_text_buffer_create_tag(buffer,
                                       gui->calltagname,
                                       "foreground-rgba",
                                       &color,
                                       "weight",
                                       PANGO_WEIGHT_BOLD,
                                       NULL);
            preferences.promptcolor = color;
        }

        gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(sentcolorbutton), &color);

        if (! gdk_rgba_equal(&color, &preferences.sentcolor)) {
            gui->senttagname = g_strdup_printf("%d", rand());
            gtk_text_buffer_create_tag(buffer,
                                       gui->senttagname,
                                       "foreground-rgba",
                                       &color,
                                       NULL);
            preferences.sentcolor = color;
        }

        gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(wwvcolorbutton), &color);

        if (! gdk_rgba_equal(&color, &preferences.wwvcolor)) {
            gui->wwvtagname = g_strdup_printf("%d", rand());
            gtk_text_buffer_create_tag(buffer,
                                       gui->wwvtagname,
                                       "foreground-rgba",
                                       &color,
                                       NULL);
            preferences.wwvcolor = color;
        }

        gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(wxcolorbutton), &color);

        if (! gdk_rgba_equal(&color, &preferences.wxcolor)) {
            gui->wxtagname = g_strdup_printf("%d", rand());
            gtk_text_buffer_create_tag(buffer,
                                       gui->wxtagname,
                                       "foreground-rgba",
                                       &color,
                                       NULL);
            preferences.wxcolor = color;
        }

        g_free(str);
    }

    gtk_widget_destroy(preferencesdialog);
    mainentry = g_object_get_data(G_OBJECT(gui->window), "mainentry");
    gtk_widget_set_sensitive(gui->window, 1);
    gtk_widget_grab_focus(GTK_WIDGET(mainentry));

}
