//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdns

// ARecord - An A record.
type ARecord struct {
	// The IPv4 address of this A record.
	IPv4Address *string `json:"ipv4Address,omitempty"`
}

// AaaaRecord - An AAAA record.
type AaaaRecord struct {
	// The IPv6 address of this AAAA record.
	IPv6Address *string `json:"ipv6Address,omitempty"`
}

// CaaRecord - A CAA record.
type CaaRecord struct {
	// The flags for this CAA record as an integer between 0 and 255.
	Flags *int32 `json:"flags,omitempty"`

	// The tag for this CAA record.
	Tag *string `json:"tag,omitempty"`

	// The value for this CAA record.
	Value *string `json:"value,omitempty"`
}

// CloudError - An error response from the service.
type CloudError struct {
	// Cloud error body.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody - An error response from the service.
type CloudErrorBody struct {
	// An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`

	// A list of additional details about the error.
	Details []*CloudErrorBody `json:"details,omitempty"`

	// A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`

	// The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
}

// CnameRecord - A CNAME record.
type CnameRecord struct {
	// The canonical name for this CNAME record.
	Cname *string `json:"cname,omitempty"`
}

// MxRecord - An MX record.
type MxRecord struct {
	// The domain name of the mail host for this MX record.
	Exchange *string `json:"exchange,omitempty"`

	// The preference value for this MX record.
	Preference *int32 `json:"preference,omitempty"`
}

// NsRecord - An NS record.
type NsRecord struct {
	// The name server name for this NS record.
	Nsdname *string `json:"nsdname,omitempty"`
}

// PtrRecord - A PTR record.
type PtrRecord struct {
	// The PTR target domain name for this PTR record.
	Ptrdname *string `json:"ptrdname,omitempty"`
}

// RecordSet - Describes a DNS record set (a collection of DNS records with the same name and type).
type RecordSet struct {
	// The etag of the record set.
	Etag *string `json:"etag,omitempty"`

	// The properties of the record set.
	Properties *RecordSetProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the record set.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the record set.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the record set.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RecordSetListResult - The response to a record set List operation.
type RecordSetListResult struct {
	// Information about the record sets in the response.
	Value []*RecordSet `json:"value,omitempty"`

	// READ-ONLY; The continuation token for the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// RecordSetProperties - Represents the properties of the records in the record set.
type RecordSetProperties struct {
	// The list of A records in the record set.
	ARecords []*ARecord `json:"ARecords,omitempty"`

	// The list of AAAA records in the record set.
	AaaaRecords []*AaaaRecord `json:"AAAARecords,omitempty"`

	// The list of CAA records in the record set.
	CaaRecords []*CaaRecord `json:"caaRecords,omitempty"`

	// The CNAME record in the record set.
	CnameRecord *CnameRecord `json:"CNAMERecord,omitempty"`

	// The metadata attached to the record set.
	Metadata map[string]*string `json:"metadata,omitempty"`

	// The list of MX records in the record set.
	MxRecords []*MxRecord `json:"MXRecords,omitempty"`

	// The list of NS records in the record set.
	NsRecords []*NsRecord `json:"NSRecords,omitempty"`

	// The list of PTR records in the record set.
	PtrRecords []*PtrRecord `json:"PTRRecords,omitempty"`

	// The SOA record in the record set.
	SoaRecord *SoaRecord `json:"SOARecord,omitempty"`

	// The list of SRV records in the record set.
	SrvRecords []*SrvRecord `json:"SRVRecords,omitempty"`

	// The TTL (time-to-live) of the records in the record set.
	TTL *int64 `json:"TTL,omitempty"`

	// A reference to an azure resource from where the dns resource value is taken.
	TargetResource *SubResource `json:"targetResource,omitempty"`

	// The list of TXT records in the record set.
	TxtRecords []*TxtRecord `json:"TXTRecords,omitempty"`

	// READ-ONLY; Fully qualified domain name of the record set.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`

	// READ-ONLY; provisioning State of the record set.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// RecordSetUpdateParameters - Parameters supplied to update a record set.
type RecordSetUpdateParameters struct {
	// Specifies information about the record set being updated.
	RecordSet *RecordSet `json:"RecordSet,omitempty"`
}

// RecordSetsClientCreateOrUpdateOptions contains the optional parameters for the RecordSetsClient.CreateOrUpdate method.
type RecordSetsClientCreateOrUpdateOptions struct {
	// The etag of the record set. Omit this value to always overwrite the current record set. Specify the last-seen etag value
	// to prevent accidentally overwriting any concurrent changes.
	IfMatch *string
	// Set to '*' to allow a new record set to be created, but to prevent updating an existing record set. Other values will be
	// ignored.
	IfNoneMatch *string
}

// RecordSetsClientDeleteOptions contains the optional parameters for the RecordSetsClient.Delete method.
type RecordSetsClientDeleteOptions struct {
	// The etag of the record set. Omit this value to always delete the current record set. Specify the last-seen etag value to
	// prevent accidentally deleting any concurrent changes.
	IfMatch *string
}

// RecordSetsClientGetOptions contains the optional parameters for the RecordSetsClient.Get method.
type RecordSetsClientGetOptions struct {
	// placeholder for future optional parameters
}

// RecordSetsClientListAllByDNSZoneOptions contains the optional parameters for the RecordSetsClient.ListAllByDNSZone method.
type RecordSetsClientListAllByDNSZoneOptions struct {
	// The suffix label of the record set name that has to be used to filter the record set enumerations. If this parameter is
	// specified, Enumeration will return only records that end with .
	RecordSetNameSuffix *string
	// The maximum number of record sets to return. If not specified, returns up to 100 record sets.
	Top *int32
}

// RecordSetsClientListByDNSZoneOptions contains the optional parameters for the RecordSetsClient.ListByDNSZone method.
type RecordSetsClientListByDNSZoneOptions struct {
	// The suffix label of the record set name that has to be used to filter the record set enumerations. If this parameter is
	// specified, Enumeration will return only records that end with .
	Recordsetnamesuffix *string
	// The maximum number of record sets to return. If not specified, returns up to 100 record sets.
	Top *int32
}

// RecordSetsClientListByTypeOptions contains the optional parameters for the RecordSetsClient.ListByType method.
type RecordSetsClientListByTypeOptions struct {
	// The suffix label of the record set name that has to be used to filter the record set enumerations. If this parameter is
	// specified, Enumeration will return only records that end with .
	Recordsetnamesuffix *string
	// The maximum number of record sets to return. If not specified, returns up to 100 record sets.
	Top *int32
}

// RecordSetsClientUpdateOptions contains the optional parameters for the RecordSetsClient.Update method.
type RecordSetsClientUpdateOptions struct {
	// The etag of the record set. Omit this value to always overwrite the current record set. Specify the last-seen etag value
	// to prevent accidentally overwriting concurrent changes.
	IfMatch *string
}

// Resource - Common properties of an Azure Resource Manager resource
type Resource struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceReference - Represents a single Azure resource and its referencing DNS records.
type ResourceReference struct {
	// A list of dns Records
	DNSResources []*SubResource `json:"dnsResources,omitempty"`

	// A reference to an azure resource from where the dns resource value is taken.
	TargetResource *SubResource `json:"targetResource,omitempty"`
}

// ResourceReferenceClientGetByTargetResourcesOptions contains the optional parameters for the ResourceReferenceClient.GetByTargetResources
// method.
type ResourceReferenceClientGetByTargetResourcesOptions struct {
	// placeholder for future optional parameters
}

// ResourceReferenceRequest - Represents the properties of the Dns Resource Reference Request.
type ResourceReferenceRequest struct {
	// The properties of the Resource Reference Request.
	Properties *ResourceReferenceRequestProperties `json:"properties,omitempty"`
}

// ResourceReferenceRequestProperties - Represents the properties of the Dns Resource Reference Request.
type ResourceReferenceRequestProperties struct {
	// A list of references to azure resources for which referencing dns records need to be queried.
	TargetResources []*SubResource `json:"targetResources,omitempty"`
}

// ResourceReferenceResult - Represents the properties of the Dns Resource Reference Result.
type ResourceReferenceResult struct {
	// The result of dns resource reference request. Returns a list of dns resource references for each of the azure resource
	// in the request.
	Properties *ResourceReferenceResultProperties `json:"properties,omitempty"`
}

// ResourceReferenceResultProperties - The result of dns resource reference request. Returns a list of dns resource references
// for each of the azure resource in the request.
type ResourceReferenceResultProperties struct {
	// The result of dns resource reference request. A list of dns resource references for each of the azure resource in the request
	DNSResourceReferences []*ResourceReference `json:"dnsResourceReferences,omitempty"`
}

// SoaRecord - An SOA record.
type SoaRecord struct {
	// The email contact for this SOA record.
	Email *string `json:"email,omitempty"`

	// The expire time for this SOA record.
	ExpireTime *int64 `json:"expireTime,omitempty"`

	// The domain name of the authoritative name server for this SOA record.
	Host *string `json:"host,omitempty"`

	// The minimum value for this SOA record. By convention this is used to determine the negative caching duration.
	MinimumTTL *int64 `json:"minimumTTL,omitempty"`

	// The refresh value for this SOA record.
	RefreshTime *int64 `json:"refreshTime,omitempty"`

	// The retry time for this SOA record.
	RetryTime *int64 `json:"retryTime,omitempty"`

	// The serial number for this SOA record.
	SerialNumber *int64 `json:"serialNumber,omitempty"`
}

// SrvRecord - An SRV record.
type SrvRecord struct {
	// The port value for this SRV record.
	Port *int32 `json:"port,omitempty"`

	// The priority value for this SRV record.
	Priority *int32 `json:"priority,omitempty"`

	// The target domain name for this SRV record.
	Target *string `json:"target,omitempty"`

	// The weight value for this SRV record.
	Weight *int32 `json:"weight,omitempty"`
}

// SubResource - A reference to a another resource
type SubResource struct {
	// Resource Id.
	ID *string `json:"id,omitempty"`
}

// TxtRecord - A TXT record.
type TxtRecord struct {
	// The text value of this TXT record.
	Value []*string `json:"value,omitempty"`
}

// Zone - Describes a DNS zone.
type Zone struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// The etag of the zone.
	Etag *string `json:"etag,omitempty"`

	// The properties of the zone.
	Properties *ZoneProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ZoneListResult - The response to a Zone List or ListAll operation.
type ZoneListResult struct {
	// Information about the DNS zones.
	Value []*Zone `json:"value,omitempty"`

	// READ-ONLY; The continuation token for the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ZoneProperties - Represents the properties of the zone.
type ZoneProperties struct {
	// A list of references to virtual networks that register hostnames in this DNS zone. This is a only when ZoneType is Private.
	RegistrationVirtualNetworks []*SubResource `json:"registrationVirtualNetworks,omitempty"`

	// A list of references to virtual networks that resolve records in this DNS zone. This is a only when ZoneType is Private.
	ResolutionVirtualNetworks []*SubResource `json:"resolutionVirtualNetworks,omitempty"`

	// The type of this DNS zone (Public or Private).
	ZoneType *ZoneType `json:"zoneType,omitempty"`

	// READ-ONLY; The maximum number of record sets that can be created in this DNS zone. This is a read-only property and any
	// attempt to set this value will be ignored.
	MaxNumberOfRecordSets *int64 `json:"maxNumberOfRecordSets,omitempty" azure:"ro"`

	// READ-ONLY; The maximum number of records per record set that can be created in this DNS zone. This is a read-only property
	// and any attempt to set this value will be ignored.
	MaxNumberOfRecordsPerRecordSet *int64 `json:"maxNumberOfRecordsPerRecordSet,omitempty" azure:"ro"`

	// READ-ONLY; The name servers for this DNS zone. This is a read-only property and any attempt to set this value will be ignored.
	NameServers []*string `json:"nameServers,omitempty" azure:"ro"`

	// READ-ONLY; The current number of record sets in this DNS zone. This is a read-only property and any attempt to set this
	// value will be ignored.
	NumberOfRecordSets *int64 `json:"numberOfRecordSets,omitempty" azure:"ro"`
}

// ZoneUpdate - Describes a request to update a DNS zone.
type ZoneUpdate struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ZonesClientBeginDeleteOptions contains the optional parameters for the ZonesClient.BeginDelete method.
type ZonesClientBeginDeleteOptions struct {
	// The etag of the DNS zone. Omit this value to always delete the current zone. Specify the last-seen etag value to prevent
	// accidentally deleting any concurrent changes.
	IfMatch *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ZonesClientCreateOrUpdateOptions contains the optional parameters for the ZonesClient.CreateOrUpdate method.
type ZonesClientCreateOrUpdateOptions struct {
	// The etag of the DNS zone. Omit this value to always overwrite the current zone. Specify the last-seen etag value to prevent
	// accidentally overwriting any concurrent changes.
	IfMatch *string
	// Set to '*' to allow a new DNS zone to be created, but to prevent updating an existing zone. Other values will be ignored.
	IfNoneMatch *string
}

// ZonesClientGetOptions contains the optional parameters for the ZonesClient.Get method.
type ZonesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ZonesClientListByResourceGroupOptions contains the optional parameters for the ZonesClient.ListByResourceGroup method.
type ZonesClientListByResourceGroupOptions struct {
	// The maximum number of record sets to return. If not specified, returns up to 100 record sets.
	Top *int32
}

// ZonesClientListOptions contains the optional parameters for the ZonesClient.List method.
type ZonesClientListOptions struct {
	// The maximum number of DNS zones to return. If not specified, returns up to 100 zones.
	Top *int32
}

// ZonesClientUpdateOptions contains the optional parameters for the ZonesClient.Update method.
type ZonesClientUpdateOptions struct {
	// The etag of the DNS zone. Omit this value to always overwrite the current zone. Specify the last-seen etag value to prevent
	// accidentally overwriting any concurrent changes.
	IfMatch *string
}
