// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/quicksight/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the IAM policy assignments in the current Amazon QuickSight account.
func (c *Client) ListIAMPolicyAssignments(ctx context.Context, params *ListIAMPolicyAssignmentsInput, optFns ...func(*Options)) (*ListIAMPolicyAssignmentsOutput, error) {
	if params == nil {
		params = &ListIAMPolicyAssignmentsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListIAMPolicyAssignments", params, optFns, c.addOperationListIAMPolicyAssignmentsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListIAMPolicyAssignmentsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListIAMPolicyAssignmentsInput struct {

	// The ID of the Amazon Web Services account that contains these IAM policy
	// assignments.
	//
	// This member is required.
	AwsAccountId *string

	// The namespace for the assignments.
	//
	// This member is required.
	Namespace *string

	// The status of the assignments.
	AssignmentStatus types.AssignmentStatus

	// The maximum number of results to be returned per request.
	MaxResults *int32

	// The token for the next set of results, or null if there are no more results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListIAMPolicyAssignmentsOutput struct {

	// Information describing the IAM policy assignments.
	IAMPolicyAssignments []types.IAMPolicyAssignmentSummary

	// The token for the next set of results, or null if there are no more results.
	NextToken *string

	// The Amazon Web Services request ID for this operation.
	RequestId *string

	// The HTTP status of the request.
	Status int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListIAMPolicyAssignmentsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListIAMPolicyAssignments{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListIAMPolicyAssignments{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListIAMPolicyAssignments"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListIAMPolicyAssignmentsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListIAMPolicyAssignments(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListIAMPolicyAssignmentsAPIClient is a client that implements the
// ListIAMPolicyAssignments operation.
type ListIAMPolicyAssignmentsAPIClient interface {
	ListIAMPolicyAssignments(context.Context, *ListIAMPolicyAssignmentsInput, ...func(*Options)) (*ListIAMPolicyAssignmentsOutput, error)
}

var _ ListIAMPolicyAssignmentsAPIClient = (*Client)(nil)

// ListIAMPolicyAssignmentsPaginatorOptions is the paginator options for
// ListIAMPolicyAssignments
type ListIAMPolicyAssignmentsPaginatorOptions struct {
	// The maximum number of results to be returned per request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListIAMPolicyAssignmentsPaginator is a paginator for ListIAMPolicyAssignments
type ListIAMPolicyAssignmentsPaginator struct {
	options   ListIAMPolicyAssignmentsPaginatorOptions
	client    ListIAMPolicyAssignmentsAPIClient
	params    *ListIAMPolicyAssignmentsInput
	nextToken *string
	firstPage bool
}

// NewListIAMPolicyAssignmentsPaginator returns a new
// ListIAMPolicyAssignmentsPaginator
func NewListIAMPolicyAssignmentsPaginator(client ListIAMPolicyAssignmentsAPIClient, params *ListIAMPolicyAssignmentsInput, optFns ...func(*ListIAMPolicyAssignmentsPaginatorOptions)) *ListIAMPolicyAssignmentsPaginator {
	if params == nil {
		params = &ListIAMPolicyAssignmentsInput{}
	}

	options := ListIAMPolicyAssignmentsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListIAMPolicyAssignmentsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListIAMPolicyAssignmentsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListIAMPolicyAssignments page.
func (p *ListIAMPolicyAssignmentsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListIAMPolicyAssignmentsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListIAMPolicyAssignments(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListIAMPolicyAssignments(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListIAMPolicyAssignments",
	}
}
