// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// The directory is already in use by another WorkMail organization in the same
// account and Region.
type DirectoryInUseException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DirectoryInUseException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DirectoryInUseException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DirectoryInUseException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DirectoryInUseException"
	}
	return *e.ErrorCodeOverride
}
func (e *DirectoryInUseException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The directory service doesn't recognize the credentials supplied by WorkMail.
type DirectoryServiceAuthenticationFailedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DirectoryServiceAuthenticationFailedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DirectoryServiceAuthenticationFailedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DirectoryServiceAuthenticationFailedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DirectoryServiceAuthenticationFailedException"
	}
	return *e.ErrorCodeOverride
}
func (e *DirectoryServiceAuthenticationFailedException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The directory is unavailable. It might be located in another Region or deleted.
type DirectoryUnavailableException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DirectoryUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DirectoryUnavailableException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DirectoryUnavailableException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DirectoryUnavailableException"
	}
	return *e.ErrorCodeOverride
}
func (e *DirectoryUnavailableException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The email address that you're trying to assign is already created for a
// different user, group, or resource.
type EmailAddressInUseException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EmailAddressInUseException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EmailAddressInUseException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EmailAddressInUseException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "EmailAddressInUseException"
	}
	return *e.ErrorCodeOverride
}
func (e *EmailAddressInUseException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The user, group, or resource that you're trying to register is already
// registered.
type EntityAlreadyRegisteredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EntityAlreadyRegisteredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EntityAlreadyRegisteredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EntityAlreadyRegisteredException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "EntityAlreadyRegisteredException"
	}
	return *e.ErrorCodeOverride
}
func (e *EntityAlreadyRegisteredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The identifier supplied for the user, group, or resource does not exist in your
// organization.
type EntityNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EntityNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EntityNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EntityNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "EntityNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *EntityNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You are performing an operation on a user, group, or resource that isn't in the
// expected state, such as trying to delete an active user.
type EntityStateException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EntityStateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EntityStateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EntityStateException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "EntityStateException"
	}
	return *e.ErrorCodeOverride
}
func (e *EntityStateException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The configuration for a resource isn't valid. A resource must either be able to
// auto-respond to requests or have at least one delegate associated that can do so
// on its behalf.
type InvalidConfigurationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidConfigurationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidConfigurationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidConfigurationException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidConfigurationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You SES configuration has customizations that WorkMail cannot save. The error
// message lists the invalid setting. For examples of invalid settings, refer to [CreateReceiptRule].
//
// [CreateReceiptRule]: https://docs.aws.amazon.com/ses/latest/APIReference/API_CreateReceiptRule.html
type InvalidCustomSesConfigurationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidCustomSesConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidCustomSesConfigurationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidCustomSesConfigurationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidCustomSesConfigurationException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidCustomSesConfigurationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// One or more of the input parameters don't match the service's restrictions.
type InvalidParameterException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidParameterException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidParameterException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidParameterException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidParameterException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The supplied password doesn't match the minimum security constraints, such as
// length or use of special characters.
type InvalidPasswordException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidPasswordException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidPasswordException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidPasswordException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidPasswordException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidPasswordException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request exceeds the limit of the resource.
type LimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "LimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *LimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The domain you're trying to change is in use by another user or organization in
// your account. See the error message for details.
type MailDomainInUseException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MailDomainInUseException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MailDomainInUseException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MailDomainInUseException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MailDomainInUseException"
	}
	return *e.ErrorCodeOverride
}
func (e *MailDomainInUseException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The domain specified is not found in your organization.
type MailDomainNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MailDomainNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MailDomainNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MailDomainNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MailDomainNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *MailDomainNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// After a domain has been added to the organization, it must be verified. The
// domain is not yet verified.
type MailDomainStateException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MailDomainStateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MailDomainStateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MailDomainStateException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MailDomainStateException"
	}
	return *e.ErrorCodeOverride
}
func (e *MailDomainStateException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The user, group, or resource name isn't unique in WorkMail.
type NameAvailabilityException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NameAvailabilityException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NameAvailabilityException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NameAvailabilityException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NameAvailabilityException"
	}
	return *e.ErrorCodeOverride
}
func (e *NameAvailabilityException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An operation received a valid organization identifier that either doesn't
// belong or exist in the system.
type OrganizationNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OrganizationNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OrganizationNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OrganizationNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OrganizationNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *OrganizationNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The organization must have a valid state to perform certain operations on the
// organization or its members.
type OrganizationStateException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OrganizationStateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OrganizationStateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OrganizationStateException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OrganizationStateException"
	}
	return *e.ErrorCodeOverride
}
func (e *OrganizationStateException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This user, group, or resource name is not allowed in WorkMail.
type ReservedNameException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReservedNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReservedNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReservedNameException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ReservedNameException"
	}
	return *e.ErrorCodeOverride
}
func (e *ReservedNameException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The resource cannot be found.
type ResourceNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The resource can have up to 50 user-applied tags.
type TooManyTagsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyTagsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyTagsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyTagsException"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyTagsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You can't perform a write operation against a read-only directory.
type UnsupportedOperationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnsupportedOperationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedOperationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedOperationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnsupportedOperationException"
	}
	return *e.ErrorCodeOverride
}
func (e *UnsupportedOperationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
