//go:build !ignore_autogenerated

// Copyright (c) 2024 Tigera, Inc. All rights reserved.
/*

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by controller-gen. DO NOT EDIT.

package v1

import (
	monitoringv1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	appsv1 "k8s.io/api/apps/v1"
	corev1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
)

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *APIServer) DeepCopyInto(out *APIServer) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new APIServer.
func (in *APIServer) DeepCopy() *APIServer {
	if in == nil {
		return nil
	}
	out := new(APIServer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *APIServer) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *APIServerDeployment) DeepCopyInto(out *APIServerDeployment) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(APIServerDeploymentSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new APIServerDeployment.
func (in *APIServerDeployment) DeepCopy() *APIServerDeployment {
	if in == nil {
		return nil
	}
	out := new(APIServerDeployment)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *APIServerDeploymentContainer) DeepCopyInto(out *APIServerDeploymentContainer) {
	*out = *in
	if in.Ports != nil {
		in, out := &in.Ports, &out.Ports
		*out = make([]APIServerDeploymentContainerPort, len(*in))
		copy(*out, *in)
	}
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new APIServerDeploymentContainer.
func (in *APIServerDeploymentContainer) DeepCopy() *APIServerDeploymentContainer {
	if in == nil {
		return nil
	}
	out := new(APIServerDeploymentContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *APIServerDeploymentContainerPort) DeepCopyInto(out *APIServerDeploymentContainerPort) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new APIServerDeploymentContainerPort.
func (in *APIServerDeploymentContainerPort) DeepCopy() *APIServerDeploymentContainerPort {
	if in == nil {
		return nil
	}
	out := new(APIServerDeploymentContainerPort)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *APIServerDeploymentInitContainer) DeepCopyInto(out *APIServerDeploymentInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new APIServerDeploymentInitContainer.
func (in *APIServerDeploymentInitContainer) DeepCopy() *APIServerDeploymentInitContainer {
	if in == nil {
		return nil
	}
	out := new(APIServerDeploymentInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *APIServerDeploymentPodSpec) DeepCopyInto(out *APIServerDeploymentPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]APIServerDeploymentInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]APIServerDeploymentContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Affinity != nil {
		in, out := &in.Affinity, &out.Affinity
		*out = new(corev1.Affinity)
		(*in).DeepCopyInto(*out)
	}
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.TopologySpreadConstraints != nil {
		in, out := &in.TopologySpreadConstraints, &out.TopologySpreadConstraints
		*out = make([]corev1.TopologySpreadConstraint, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new APIServerDeploymentPodSpec.
func (in *APIServerDeploymentPodSpec) DeepCopy() *APIServerDeploymentPodSpec {
	if in == nil {
		return nil
	}
	out := new(APIServerDeploymentPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *APIServerDeploymentPodTemplateSpec) DeepCopyInto(out *APIServerDeploymentPodTemplateSpec) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(APIServerDeploymentPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new APIServerDeploymentPodTemplateSpec.
func (in *APIServerDeploymentPodTemplateSpec) DeepCopy() *APIServerDeploymentPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(APIServerDeploymentPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *APIServerDeploymentSpec) DeepCopyInto(out *APIServerDeploymentSpec) {
	*out = *in
	if in.MinReadySeconds != nil {
		in, out := &in.MinReadySeconds, &out.MinReadySeconds
		*out = new(int32)
		**out = **in
	}
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(APIServerDeploymentPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new APIServerDeploymentSpec.
func (in *APIServerDeploymentSpec) DeepCopy() *APIServerDeploymentSpec {
	if in == nil {
		return nil
	}
	out := new(APIServerDeploymentSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *APIServerList) DeepCopyInto(out *APIServerList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]APIServer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new APIServerList.
func (in *APIServerList) DeepCopy() *APIServerList {
	if in == nil {
		return nil
	}
	out := new(APIServerList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *APIServerList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *APIServerLogging) DeepCopyInto(out *APIServerLogging) {
	*out = *in
	if in.LogSeverity != nil {
		in, out := &in.LogSeverity, &out.LogSeverity
		*out = new(LogSeverity)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new APIServerLogging.
func (in *APIServerLogging) DeepCopy() *APIServerLogging {
	if in == nil {
		return nil
	}
	out := new(APIServerLogging)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *APIServerPodLogging) DeepCopyInto(out *APIServerPodLogging) {
	*out = *in
	if in.APIServerLogging != nil {
		in, out := &in.APIServerLogging, &out.APIServerLogging
		*out = new(APIServerLogging)
		(*in).DeepCopyInto(*out)
	}
	if in.QueryServerLogging != nil {
		in, out := &in.QueryServerLogging, &out.QueryServerLogging
		*out = new(QueryServerLogging)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new APIServerPodLogging.
func (in *APIServerPodLogging) DeepCopy() *APIServerPodLogging {
	if in == nil {
		return nil
	}
	out := new(APIServerPodLogging)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *APIServerSpec) DeepCopyInto(out *APIServerSpec) {
	*out = *in
	if in.Logging != nil {
		in, out := &in.Logging, &out.Logging
		*out = new(APIServerPodLogging)
		(*in).DeepCopyInto(*out)
	}
	if in.APIServerDeployment != nil {
		in, out := &in.APIServerDeployment, &out.APIServerDeployment
		*out = new(APIServerDeployment)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new APIServerSpec.
func (in *APIServerSpec) DeepCopy() *APIServerSpec {
	if in == nil {
		return nil
	}
	out := new(APIServerSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *APIServerStatus) DeepCopyInto(out *APIServerStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]metav1.Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new APIServerStatus.
func (in *APIServerStatus) DeepCopy() *APIServerStatus {
	if in == nil {
		return nil
	}
	out := new(APIServerStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AWSEgressGateway) DeepCopyInto(out *AWSEgressGateway) {
	*out = *in
	if in.NativeIP != nil {
		in, out := &in.NativeIP, &out.NativeIP
		*out = new(NativeIP)
		**out = **in
	}
	if in.ElasticIPs != nil {
		in, out := &in.ElasticIPs, &out.ElasticIPs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AWSEgressGateway.
func (in *AWSEgressGateway) DeepCopy() *AWSEgressGateway {
	if in == nil {
		return nil
	}
	out := new(AWSEgressGateway)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AdditionalLogSourceSpec) DeepCopyInto(out *AdditionalLogSourceSpec) {
	*out = *in
	if in.EksCloudwatchLog != nil {
		in, out := &in.EksCloudwatchLog, &out.EksCloudwatchLog
		*out = new(EksCloudwatchLogsSpec)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AdditionalLogSourceSpec.
func (in *AdditionalLogSourceSpec) DeepCopy() *AdditionalLogSourceSpec {
	if in == nil {
		return nil
	}
	out := new(AdditionalLogSourceSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AdditionalLogStoreSpec) DeepCopyInto(out *AdditionalLogStoreSpec) {
	*out = *in
	if in.S3 != nil {
		in, out := &in.S3, &out.S3
		*out = new(S3StoreSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Syslog != nil {
		in, out := &in.Syslog, &out.Syslog
		*out = new(SyslogStoreSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Splunk != nil {
		in, out := &in.Splunk, &out.Splunk
		*out = new(SplunkStoreSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AdditionalLogStoreSpec.
func (in *AdditionalLogStoreSpec) DeepCopy() *AdditionalLogStoreSpec {
	if in == nil {
		return nil
	}
	out := new(AdditionalLogStoreSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AlertManager) DeepCopyInto(out *AlertManager) {
	*out = *in
	if in.AlertManagerSpec != nil {
		in, out := &in.AlertManagerSpec, &out.AlertManagerSpec
		*out = new(AlertManagerSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AlertManager.
func (in *AlertManager) DeepCopy() *AlertManager {
	if in == nil {
		return nil
	}
	out := new(AlertManager)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AlertManagerSpec) DeepCopyInto(out *AlertManagerSpec) {
	*out = *in
	in.Resources.DeepCopyInto(&out.Resources)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AlertManagerSpec.
func (in *AlertManagerSpec) DeepCopy() *AlertManagerSpec {
	if in == nil {
		return nil
	}
	out := new(AlertManagerSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AnomalyDetectionSpec) DeepCopyInto(out *AnomalyDetectionSpec) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AnomalyDetectionSpec.
func (in *AnomalyDetectionSpec) DeepCopy() *AnomalyDetectionSpec {
	if in == nil {
		return nil
	}
	out := new(AnomalyDetectionSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ApplicationLayer) DeepCopyInto(out *ApplicationLayer) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ApplicationLayer.
func (in *ApplicationLayer) DeepCopy() *ApplicationLayer {
	if in == nil {
		return nil
	}
	out := new(ApplicationLayer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ApplicationLayer) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ApplicationLayerList) DeepCopyInto(out *ApplicationLayerList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ApplicationLayer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ApplicationLayerList.
func (in *ApplicationLayerList) DeepCopy() *ApplicationLayerList {
	if in == nil {
		return nil
	}
	out := new(ApplicationLayerList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ApplicationLayerList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ApplicationLayerSpec) DeepCopyInto(out *ApplicationLayerSpec) {
	*out = *in
	if in.WebApplicationFirewall != nil {
		in, out := &in.WebApplicationFirewall, &out.WebApplicationFirewall
		*out = new(WAFStatusType)
		**out = **in
	}
	if in.LogCollection != nil {
		in, out := &in.LogCollection, &out.LogCollection
		*out = new(LogCollectionSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.ApplicationLayerPolicy != nil {
		in, out := &in.ApplicationLayerPolicy, &out.ApplicationLayerPolicy
		*out = new(ApplicationLayerPolicyStatusType)
		**out = **in
	}
	if in.EnvoySettings != nil {
		in, out := &in.EnvoySettings, &out.EnvoySettings
		*out = new(EnvoySettings)
		**out = **in
	}
	if in.L7LogCollectorDaemonSet != nil {
		in, out := &in.L7LogCollectorDaemonSet, &out.L7LogCollectorDaemonSet
		*out = new(L7LogCollectorDaemonSet)
		(*in).DeepCopyInto(*out)
	}
	if in.SidecarInjection != nil {
		in, out := &in.SidecarInjection, &out.SidecarInjection
		*out = new(SidecarStatusType)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ApplicationLayerSpec.
func (in *ApplicationLayerSpec) DeepCopy() *ApplicationLayerSpec {
	if in == nil {
		return nil
	}
	out := new(ApplicationLayerSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ApplicationLayerStatus) DeepCopyInto(out *ApplicationLayerStatus) {
	*out = *in
	if in.SidecarWebhook != nil {
		in, out := &in.SidecarWebhook, &out.SidecarWebhook
		*out = new(SidecarWebhookStateType)
		**out = **in
	}
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]metav1.Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ApplicationLayerStatus.
func (in *ApplicationLayerStatus) DeepCopy() *ApplicationLayerStatus {
	if in == nil {
		return nil
	}
	out := new(ApplicationLayerStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Authentication) DeepCopyInto(out *Authentication) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Authentication.
func (in *Authentication) DeepCopy() *Authentication {
	if in == nil {
		return nil
	}
	out := new(Authentication)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *Authentication) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AuthenticationLDAP) DeepCopyInto(out *AuthenticationLDAP) {
	*out = *in
	if in.StartTLS != nil {
		in, out := &in.StartTLS, &out.StartTLS
		*out = new(bool)
		**out = **in
	}
	if in.UserSearch != nil {
		in, out := &in.UserSearch, &out.UserSearch
		*out = new(UserSearch)
		**out = **in
	}
	if in.GroupSearch != nil {
		in, out := &in.GroupSearch, &out.GroupSearch
		*out = new(GroupSearch)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AuthenticationLDAP.
func (in *AuthenticationLDAP) DeepCopy() *AuthenticationLDAP {
	if in == nil {
		return nil
	}
	out := new(AuthenticationLDAP)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AuthenticationList) DeepCopyInto(out *AuthenticationList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Authentication, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AuthenticationList.
func (in *AuthenticationList) DeepCopy() *AuthenticationList {
	if in == nil {
		return nil
	}
	out := new(AuthenticationList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *AuthenticationList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AuthenticationOIDC) DeepCopyInto(out *AuthenticationOIDC) {
	*out = *in
	if in.RequestedScopes != nil {
		in, out := &in.RequestedScopes, &out.RequestedScopes
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.EmailVerification != nil {
		in, out := &in.EmailVerification, &out.EmailVerification
		*out = new(EmailVerificationType)
		**out = **in
	}
	if in.PromptTypes != nil {
		in, out := &in.PromptTypes, &out.PromptTypes
		*out = make([]PromptType, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AuthenticationOIDC.
func (in *AuthenticationOIDC) DeepCopy() *AuthenticationOIDC {
	if in == nil {
		return nil
	}
	out := new(AuthenticationOIDC)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AuthenticationOpenshift) DeepCopyInto(out *AuthenticationOpenshift) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AuthenticationOpenshift.
func (in *AuthenticationOpenshift) DeepCopy() *AuthenticationOpenshift {
	if in == nil {
		return nil
	}
	out := new(AuthenticationOpenshift)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AuthenticationSpec) DeepCopyInto(out *AuthenticationSpec) {
	*out = *in
	if in.OIDC != nil {
		in, out := &in.OIDC, &out.OIDC
		*out = new(AuthenticationOIDC)
		(*in).DeepCopyInto(*out)
	}
	if in.Openshift != nil {
		in, out := &in.Openshift, &out.Openshift
		*out = new(AuthenticationOpenshift)
		**out = **in
	}
	if in.LDAP != nil {
		in, out := &in.LDAP, &out.LDAP
		*out = new(AuthenticationLDAP)
		(*in).DeepCopyInto(*out)
	}
	if in.DexDeployment != nil {
		in, out := &in.DexDeployment, &out.DexDeployment
		*out = new(DexDeployment)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AuthenticationSpec.
func (in *AuthenticationSpec) DeepCopy() *AuthenticationSpec {
	if in == nil {
		return nil
	}
	out := new(AuthenticationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AuthenticationStatus) DeepCopyInto(out *AuthenticationStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]metav1.Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AuthenticationStatus.
func (in *AuthenticationStatus) DeepCopy() *AuthenticationStatus {
	if in == nil {
		return nil
	}
	out := new(AuthenticationStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Azure) DeepCopyInto(out *Azure) {
	*out = *in
	if in.PolicyMode != nil {
		in, out := &in.PolicyMode, &out.PolicyMode
		*out = new(PolicyMode)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Azure.
func (in *Azure) DeepCopy() *Azure {
	if in == nil {
		return nil
	}
	out := new(Azure)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CNILogging) DeepCopyInto(out *CNILogging) {
	*out = *in
	if in.LogSeverity != nil {
		in, out := &in.LogSeverity, &out.LogSeverity
		*out = new(LogLevel)
		**out = **in
	}
	if in.LogFileMaxSize != nil {
		in, out := &in.LogFileMaxSize, &out.LogFileMaxSize
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.LogFileMaxAgeDays != nil {
		in, out := &in.LogFileMaxAgeDays, &out.LogFileMaxAgeDays
		*out = new(uint32)
		**out = **in
	}
	if in.LogFileMaxCount != nil {
		in, out := &in.LogFileMaxCount, &out.LogFileMaxCount
		*out = new(uint32)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CNILogging.
func (in *CNILogging) DeepCopy() *CNILogging {
	if in == nil {
		return nil
	}
	out := new(CNILogging)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CNISpec) DeepCopyInto(out *CNISpec) {
	*out = *in
	if in.IPAM != nil {
		in, out := &in.IPAM, &out.IPAM
		*out = new(IPAMSpec)
		**out = **in
	}
	if in.BinDir != nil {
		in, out := &in.BinDir, &out.BinDir
		*out = new(string)
		**out = **in
	}
	if in.ConfDir != nil {
		in, out := &in.ConfDir, &out.ConfDir
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CNISpec.
func (in *CNISpec) DeepCopy() *CNISpec {
	if in == nil {
		return nil
	}
	out := new(CNISpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CSINodeDriverDaemonSet) DeepCopyInto(out *CSINodeDriverDaemonSet) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(CSINodeDriverDaemonSetSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CSINodeDriverDaemonSet.
func (in *CSINodeDriverDaemonSet) DeepCopy() *CSINodeDriverDaemonSet {
	if in == nil {
		return nil
	}
	out := new(CSINodeDriverDaemonSet)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CSINodeDriverDaemonSetContainer) DeepCopyInto(out *CSINodeDriverDaemonSetContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CSINodeDriverDaemonSetContainer.
func (in *CSINodeDriverDaemonSetContainer) DeepCopy() *CSINodeDriverDaemonSetContainer {
	if in == nil {
		return nil
	}
	out := new(CSINodeDriverDaemonSetContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CSINodeDriverDaemonSetPodSpec) DeepCopyInto(out *CSINodeDriverDaemonSetPodSpec) {
	*out = *in
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]CSINodeDriverDaemonSetContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Affinity != nil {
		in, out := &in.Affinity, &out.Affinity
		*out = new(corev1.Affinity)
		(*in).DeepCopyInto(*out)
	}
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CSINodeDriverDaemonSetPodSpec.
func (in *CSINodeDriverDaemonSetPodSpec) DeepCopy() *CSINodeDriverDaemonSetPodSpec {
	if in == nil {
		return nil
	}
	out := new(CSINodeDriverDaemonSetPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CSINodeDriverDaemonSetPodTemplateSpec) DeepCopyInto(out *CSINodeDriverDaemonSetPodTemplateSpec) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(CSINodeDriverDaemonSetPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CSINodeDriverDaemonSetPodTemplateSpec.
func (in *CSINodeDriverDaemonSetPodTemplateSpec) DeepCopy() *CSINodeDriverDaemonSetPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(CSINodeDriverDaemonSetPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CSINodeDriverDaemonSetSpec) DeepCopyInto(out *CSINodeDriverDaemonSetSpec) {
	*out = *in
	if in.MinReadySeconds != nil {
		in, out := &in.MinReadySeconds, &out.MinReadySeconds
		*out = new(int32)
		**out = **in
	}
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(CSINodeDriverDaemonSetPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CSINodeDriverDaemonSetSpec.
func (in *CSINodeDriverDaemonSetSpec) DeepCopy() *CSINodeDriverDaemonSetSpec {
	if in == nil {
		return nil
	}
	out := new(CSINodeDriverDaemonSetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoKubeControllersDeployment) DeepCopyInto(out *CalicoKubeControllersDeployment) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(CalicoKubeControllersDeploymentSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoKubeControllersDeployment.
func (in *CalicoKubeControllersDeployment) DeepCopy() *CalicoKubeControllersDeployment {
	if in == nil {
		return nil
	}
	out := new(CalicoKubeControllersDeployment)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoKubeControllersDeploymentContainer) DeepCopyInto(out *CalicoKubeControllersDeploymentContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoKubeControllersDeploymentContainer.
func (in *CalicoKubeControllersDeploymentContainer) DeepCopy() *CalicoKubeControllersDeploymentContainer {
	if in == nil {
		return nil
	}
	out := new(CalicoKubeControllersDeploymentContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoKubeControllersDeploymentPodSpec) DeepCopyInto(out *CalicoKubeControllersDeploymentPodSpec) {
	*out = *in
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]CalicoKubeControllersDeploymentContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Affinity != nil {
		in, out := &in.Affinity, &out.Affinity
		*out = new(corev1.Affinity)
		(*in).DeepCopyInto(*out)
	}
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoKubeControllersDeploymentPodSpec.
func (in *CalicoKubeControllersDeploymentPodSpec) DeepCopy() *CalicoKubeControllersDeploymentPodSpec {
	if in == nil {
		return nil
	}
	out := new(CalicoKubeControllersDeploymentPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoKubeControllersDeploymentPodTemplateSpec) DeepCopyInto(out *CalicoKubeControllersDeploymentPodTemplateSpec) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(CalicoKubeControllersDeploymentPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoKubeControllersDeploymentPodTemplateSpec.
func (in *CalicoKubeControllersDeploymentPodTemplateSpec) DeepCopy() *CalicoKubeControllersDeploymentPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(CalicoKubeControllersDeploymentPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoKubeControllersDeploymentSpec) DeepCopyInto(out *CalicoKubeControllersDeploymentSpec) {
	*out = *in
	if in.MinReadySeconds != nil {
		in, out := &in.MinReadySeconds, &out.MinReadySeconds
		*out = new(int32)
		**out = **in
	}
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(CalicoKubeControllersDeploymentPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoKubeControllersDeploymentSpec.
func (in *CalicoKubeControllersDeploymentSpec) DeepCopy() *CalicoKubeControllersDeploymentSpec {
	if in == nil {
		return nil
	}
	out := new(CalicoKubeControllersDeploymentSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNetworkSpec) DeepCopyInto(out *CalicoNetworkSpec) {
	*out = *in
	if in.LinuxDataplane != nil {
		in, out := &in.LinuxDataplane, &out.LinuxDataplane
		*out = new(LinuxDataplaneOption)
		**out = **in
	}
	if in.WindowsDataplane != nil {
		in, out := &in.WindowsDataplane, &out.WindowsDataplane
		*out = new(WindowsDataplaneOption)
		**out = **in
	}
	if in.BGP != nil {
		in, out := &in.BGP, &out.BGP
		*out = new(BGPOption)
		**out = **in
	}
	if in.IPPools != nil {
		in, out := &in.IPPools, &out.IPPools
		*out = make([]IPPool, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.MTU != nil {
		in, out := &in.MTU, &out.MTU
		*out = new(int32)
		**out = **in
	}
	if in.NodeAddressAutodetectionV4 != nil {
		in, out := &in.NodeAddressAutodetectionV4, &out.NodeAddressAutodetectionV4
		*out = new(NodeAddressAutodetection)
		(*in).DeepCopyInto(*out)
	}
	if in.NodeAddressAutodetectionV6 != nil {
		in, out := &in.NodeAddressAutodetectionV6, &out.NodeAddressAutodetectionV6
		*out = new(NodeAddressAutodetection)
		(*in).DeepCopyInto(*out)
	}
	if in.HostPorts != nil {
		in, out := &in.HostPorts, &out.HostPorts
		*out = new(HostPortsType)
		**out = **in
	}
	if in.MultiInterfaceMode != nil {
		in, out := &in.MultiInterfaceMode, &out.MultiInterfaceMode
		*out = new(MultiInterfaceMode)
		**out = **in
	}
	if in.ContainerIPForwarding != nil {
		in, out := &in.ContainerIPForwarding, &out.ContainerIPForwarding
		*out = new(ContainerIPForwardingType)
		**out = **in
	}
	if in.Sysctl != nil {
		in, out := &in.Sysctl, &out.Sysctl
		*out = make([]Sysctl, len(*in))
		copy(*out, *in)
	}
	if in.LinuxPolicySetupTimeoutSeconds != nil {
		in, out := &in.LinuxPolicySetupTimeoutSeconds, &out.LinuxPolicySetupTimeoutSeconds
		*out = new(int32)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNetworkSpec.
func (in *CalicoNetworkSpec) DeepCopy() *CalicoNetworkSpec {
	if in == nil {
		return nil
	}
	out := new(CalicoNetworkSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNodeDaemonSet) DeepCopyInto(out *CalicoNodeDaemonSet) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(CalicoNodeDaemonSetSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNodeDaemonSet.
func (in *CalicoNodeDaemonSet) DeepCopy() *CalicoNodeDaemonSet {
	if in == nil {
		return nil
	}
	out := new(CalicoNodeDaemonSet)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNodeDaemonSetContainer) DeepCopyInto(out *CalicoNodeDaemonSetContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNodeDaemonSetContainer.
func (in *CalicoNodeDaemonSetContainer) DeepCopy() *CalicoNodeDaemonSetContainer {
	if in == nil {
		return nil
	}
	out := new(CalicoNodeDaemonSetContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNodeDaemonSetInitContainer) DeepCopyInto(out *CalicoNodeDaemonSetInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNodeDaemonSetInitContainer.
func (in *CalicoNodeDaemonSetInitContainer) DeepCopy() *CalicoNodeDaemonSetInitContainer {
	if in == nil {
		return nil
	}
	out := new(CalicoNodeDaemonSetInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNodeDaemonSetPodSpec) DeepCopyInto(out *CalicoNodeDaemonSetPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]CalicoNodeDaemonSetInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]CalicoNodeDaemonSetContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Affinity != nil {
		in, out := &in.Affinity, &out.Affinity
		*out = new(corev1.Affinity)
		(*in).DeepCopyInto(*out)
	}
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNodeDaemonSetPodSpec.
func (in *CalicoNodeDaemonSetPodSpec) DeepCopy() *CalicoNodeDaemonSetPodSpec {
	if in == nil {
		return nil
	}
	out := new(CalicoNodeDaemonSetPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNodeDaemonSetPodTemplateSpec) DeepCopyInto(out *CalicoNodeDaemonSetPodTemplateSpec) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(CalicoNodeDaemonSetPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNodeDaemonSetPodTemplateSpec.
func (in *CalicoNodeDaemonSetPodTemplateSpec) DeepCopy() *CalicoNodeDaemonSetPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(CalicoNodeDaemonSetPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNodeDaemonSetSpec) DeepCopyInto(out *CalicoNodeDaemonSetSpec) {
	*out = *in
	if in.MinReadySeconds != nil {
		in, out := &in.MinReadySeconds, &out.MinReadySeconds
		*out = new(int32)
		**out = **in
	}
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(CalicoNodeDaemonSetPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNodeDaemonSetSpec.
func (in *CalicoNodeDaemonSetSpec) DeepCopy() *CalicoNodeDaemonSetSpec {
	if in == nil {
		return nil
	}
	out := new(CalicoNodeDaemonSetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNodeWindowsDaemonSet) DeepCopyInto(out *CalicoNodeWindowsDaemonSet) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(CalicoNodeWindowsDaemonSetSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNodeWindowsDaemonSet.
func (in *CalicoNodeWindowsDaemonSet) DeepCopy() *CalicoNodeWindowsDaemonSet {
	if in == nil {
		return nil
	}
	out := new(CalicoNodeWindowsDaemonSet)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNodeWindowsDaemonSetContainer) DeepCopyInto(out *CalicoNodeWindowsDaemonSetContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNodeWindowsDaemonSetContainer.
func (in *CalicoNodeWindowsDaemonSetContainer) DeepCopy() *CalicoNodeWindowsDaemonSetContainer {
	if in == nil {
		return nil
	}
	out := new(CalicoNodeWindowsDaemonSetContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNodeWindowsDaemonSetInitContainer) DeepCopyInto(out *CalicoNodeWindowsDaemonSetInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNodeWindowsDaemonSetInitContainer.
func (in *CalicoNodeWindowsDaemonSetInitContainer) DeepCopy() *CalicoNodeWindowsDaemonSetInitContainer {
	if in == nil {
		return nil
	}
	out := new(CalicoNodeWindowsDaemonSetInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNodeWindowsDaemonSetPodSpec) DeepCopyInto(out *CalicoNodeWindowsDaemonSetPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]CalicoNodeWindowsDaemonSetInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]CalicoNodeWindowsDaemonSetContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Affinity != nil {
		in, out := &in.Affinity, &out.Affinity
		*out = new(corev1.Affinity)
		(*in).DeepCopyInto(*out)
	}
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNodeWindowsDaemonSetPodSpec.
func (in *CalicoNodeWindowsDaemonSetPodSpec) DeepCopy() *CalicoNodeWindowsDaemonSetPodSpec {
	if in == nil {
		return nil
	}
	out := new(CalicoNodeWindowsDaemonSetPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNodeWindowsDaemonSetPodTemplateSpec) DeepCopyInto(out *CalicoNodeWindowsDaemonSetPodTemplateSpec) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(CalicoNodeWindowsDaemonSetPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNodeWindowsDaemonSetPodTemplateSpec.
func (in *CalicoNodeWindowsDaemonSetPodTemplateSpec) DeepCopy() *CalicoNodeWindowsDaemonSetPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(CalicoNodeWindowsDaemonSetPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNodeWindowsDaemonSetSpec) DeepCopyInto(out *CalicoNodeWindowsDaemonSetSpec) {
	*out = *in
	if in.MinReadySeconds != nil {
		in, out := &in.MinReadySeconds, &out.MinReadySeconds
		*out = new(int32)
		**out = **in
	}
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(CalicoNodeWindowsDaemonSetPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNodeWindowsDaemonSetSpec.
func (in *CalicoNodeWindowsDaemonSetSpec) DeepCopy() *CalicoNodeWindowsDaemonSetSpec {
	if in == nil {
		return nil
	}
	out := new(CalicoNodeWindowsDaemonSetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoWindowsUpgradeDaemonSet) DeepCopyInto(out *CalicoWindowsUpgradeDaemonSet) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(CalicoWindowsUpgradeDaemonSetSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoWindowsUpgradeDaemonSet.
func (in *CalicoWindowsUpgradeDaemonSet) DeepCopy() *CalicoWindowsUpgradeDaemonSet {
	if in == nil {
		return nil
	}
	out := new(CalicoWindowsUpgradeDaemonSet)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoWindowsUpgradeDaemonSetContainer) DeepCopyInto(out *CalicoWindowsUpgradeDaemonSetContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoWindowsUpgradeDaemonSetContainer.
func (in *CalicoWindowsUpgradeDaemonSetContainer) DeepCopy() *CalicoWindowsUpgradeDaemonSetContainer {
	if in == nil {
		return nil
	}
	out := new(CalicoWindowsUpgradeDaemonSetContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoWindowsUpgradeDaemonSetPodSpec) DeepCopyInto(out *CalicoWindowsUpgradeDaemonSetPodSpec) {
	*out = *in
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]CalicoWindowsUpgradeDaemonSetContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Affinity != nil {
		in, out := &in.Affinity, &out.Affinity
		*out = new(corev1.Affinity)
		(*in).DeepCopyInto(*out)
	}
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoWindowsUpgradeDaemonSetPodSpec.
func (in *CalicoWindowsUpgradeDaemonSetPodSpec) DeepCopy() *CalicoWindowsUpgradeDaemonSetPodSpec {
	if in == nil {
		return nil
	}
	out := new(CalicoWindowsUpgradeDaemonSetPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoWindowsUpgradeDaemonSetPodTemplateSpec) DeepCopyInto(out *CalicoWindowsUpgradeDaemonSetPodTemplateSpec) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(CalicoWindowsUpgradeDaemonSetPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoWindowsUpgradeDaemonSetPodTemplateSpec.
func (in *CalicoWindowsUpgradeDaemonSetPodTemplateSpec) DeepCopy() *CalicoWindowsUpgradeDaemonSetPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(CalicoWindowsUpgradeDaemonSetPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoWindowsUpgradeDaemonSetSpec) DeepCopyInto(out *CalicoWindowsUpgradeDaemonSetSpec) {
	*out = *in
	if in.MinReadySeconds != nil {
		in, out := &in.MinReadySeconds, &out.MinReadySeconds
		*out = new(int32)
		**out = **in
	}
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(CalicoWindowsUpgradeDaemonSetPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoWindowsUpgradeDaemonSetSpec.
func (in *CalicoWindowsUpgradeDaemonSetSpec) DeepCopy() *CalicoWindowsUpgradeDaemonSetSpec {
	if in == nil {
		return nil
	}
	out := new(CalicoWindowsUpgradeDaemonSetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CertificateManagement) DeepCopyInto(out *CertificateManagement) {
	*out = *in
	if in.CACert != nil {
		in, out := &in.CACert, &out.CACert
		*out = make([]byte, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CertificateManagement.
func (in *CertificateManagement) DeepCopy() *CertificateManagement {
	if in == nil {
		return nil
	}
	out := new(CertificateManagement)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CommonPrometheusFields) DeepCopyInto(out *CommonPrometheusFields) {
	*out = *in
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]PrometheusContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	in.Resources.DeepCopyInto(&out.Resources)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CommonPrometheusFields.
func (in *CommonPrometheusFields) DeepCopy() *CommonPrometheusFields {
	if in == nil {
		return nil
	}
	out := new(CommonPrometheusFields)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Compliance) DeepCopyInto(out *Compliance) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Compliance.
func (in *Compliance) DeepCopy() *Compliance {
	if in == nil {
		return nil
	}
	out := new(Compliance)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *Compliance) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceBenchmarkerDaemonSet) DeepCopyInto(out *ComplianceBenchmarkerDaemonSet) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(ComplianceBenchmarkerDaemonSetSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceBenchmarkerDaemonSet.
func (in *ComplianceBenchmarkerDaemonSet) DeepCopy() *ComplianceBenchmarkerDaemonSet {
	if in == nil {
		return nil
	}
	out := new(ComplianceBenchmarkerDaemonSet)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceBenchmarkerDaemonSetContainer) DeepCopyInto(out *ComplianceBenchmarkerDaemonSetContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceBenchmarkerDaemonSetContainer.
func (in *ComplianceBenchmarkerDaemonSetContainer) DeepCopy() *ComplianceBenchmarkerDaemonSetContainer {
	if in == nil {
		return nil
	}
	out := new(ComplianceBenchmarkerDaemonSetContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceBenchmarkerDaemonSetInitContainer) DeepCopyInto(out *ComplianceBenchmarkerDaemonSetInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceBenchmarkerDaemonSetInitContainer.
func (in *ComplianceBenchmarkerDaemonSetInitContainer) DeepCopy() *ComplianceBenchmarkerDaemonSetInitContainer {
	if in == nil {
		return nil
	}
	out := new(ComplianceBenchmarkerDaemonSetInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceBenchmarkerDaemonSetPodSpec) DeepCopyInto(out *ComplianceBenchmarkerDaemonSetPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]ComplianceBenchmarkerDaemonSetInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]ComplianceBenchmarkerDaemonSetContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceBenchmarkerDaemonSetPodSpec.
func (in *ComplianceBenchmarkerDaemonSetPodSpec) DeepCopy() *ComplianceBenchmarkerDaemonSetPodSpec {
	if in == nil {
		return nil
	}
	out := new(ComplianceBenchmarkerDaemonSetPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceBenchmarkerDaemonSetPodTemplateSpec) DeepCopyInto(out *ComplianceBenchmarkerDaemonSetPodTemplateSpec) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(ComplianceBenchmarkerDaemonSetPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceBenchmarkerDaemonSetPodTemplateSpec.
func (in *ComplianceBenchmarkerDaemonSetPodTemplateSpec) DeepCopy() *ComplianceBenchmarkerDaemonSetPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(ComplianceBenchmarkerDaemonSetPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceBenchmarkerDaemonSetSpec) DeepCopyInto(out *ComplianceBenchmarkerDaemonSetSpec) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(ComplianceBenchmarkerDaemonSetPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceBenchmarkerDaemonSetSpec.
func (in *ComplianceBenchmarkerDaemonSetSpec) DeepCopy() *ComplianceBenchmarkerDaemonSetSpec {
	if in == nil {
		return nil
	}
	out := new(ComplianceBenchmarkerDaemonSetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceControllerDeployment) DeepCopyInto(out *ComplianceControllerDeployment) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(ComplianceControllerDeploymentSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceControllerDeployment.
func (in *ComplianceControllerDeployment) DeepCopy() *ComplianceControllerDeployment {
	if in == nil {
		return nil
	}
	out := new(ComplianceControllerDeployment)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceControllerDeploymentContainer) DeepCopyInto(out *ComplianceControllerDeploymentContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceControllerDeploymentContainer.
func (in *ComplianceControllerDeploymentContainer) DeepCopy() *ComplianceControllerDeploymentContainer {
	if in == nil {
		return nil
	}
	out := new(ComplianceControllerDeploymentContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceControllerDeploymentInitContainer) DeepCopyInto(out *ComplianceControllerDeploymentInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceControllerDeploymentInitContainer.
func (in *ComplianceControllerDeploymentInitContainer) DeepCopy() *ComplianceControllerDeploymentInitContainer {
	if in == nil {
		return nil
	}
	out := new(ComplianceControllerDeploymentInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceControllerDeploymentPodSpec) DeepCopyInto(out *ComplianceControllerDeploymentPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]ComplianceControllerDeploymentInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]ComplianceControllerDeploymentContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceControllerDeploymentPodSpec.
func (in *ComplianceControllerDeploymentPodSpec) DeepCopy() *ComplianceControllerDeploymentPodSpec {
	if in == nil {
		return nil
	}
	out := new(ComplianceControllerDeploymentPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceControllerDeploymentPodTemplateSpec) DeepCopyInto(out *ComplianceControllerDeploymentPodTemplateSpec) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(ComplianceControllerDeploymentPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceControllerDeploymentPodTemplateSpec.
func (in *ComplianceControllerDeploymentPodTemplateSpec) DeepCopy() *ComplianceControllerDeploymentPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(ComplianceControllerDeploymentPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceControllerDeploymentSpec) DeepCopyInto(out *ComplianceControllerDeploymentSpec) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(ComplianceControllerDeploymentPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceControllerDeploymentSpec.
func (in *ComplianceControllerDeploymentSpec) DeepCopy() *ComplianceControllerDeploymentSpec {
	if in == nil {
		return nil
	}
	out := new(ComplianceControllerDeploymentSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceList) DeepCopyInto(out *ComplianceList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Compliance, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceList.
func (in *ComplianceList) DeepCopy() *ComplianceList {
	if in == nil {
		return nil
	}
	out := new(ComplianceList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ComplianceList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceReporterPodSpec) DeepCopyInto(out *ComplianceReporterPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]ComplianceReporterPodTemplateInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]ComplianceReporterPodTemplateContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceReporterPodSpec.
func (in *ComplianceReporterPodSpec) DeepCopy() *ComplianceReporterPodSpec {
	if in == nil {
		return nil
	}
	out := new(ComplianceReporterPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceReporterPodTemplate) DeepCopyInto(out *ComplianceReporterPodTemplate) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(ComplianceReporterPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceReporterPodTemplate.
func (in *ComplianceReporterPodTemplate) DeepCopy() *ComplianceReporterPodTemplate {
	if in == nil {
		return nil
	}
	out := new(ComplianceReporterPodTemplate)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceReporterPodTemplateContainer) DeepCopyInto(out *ComplianceReporterPodTemplateContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceReporterPodTemplateContainer.
func (in *ComplianceReporterPodTemplateContainer) DeepCopy() *ComplianceReporterPodTemplateContainer {
	if in == nil {
		return nil
	}
	out := new(ComplianceReporterPodTemplateContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceReporterPodTemplateInitContainer) DeepCopyInto(out *ComplianceReporterPodTemplateInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceReporterPodTemplateInitContainer.
func (in *ComplianceReporterPodTemplateInitContainer) DeepCopy() *ComplianceReporterPodTemplateInitContainer {
	if in == nil {
		return nil
	}
	out := new(ComplianceReporterPodTemplateInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceReporterPodTemplateSpec) DeepCopyInto(out *ComplianceReporterPodTemplateSpec) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(ComplianceReporterPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceReporterPodTemplateSpec.
func (in *ComplianceReporterPodTemplateSpec) DeepCopy() *ComplianceReporterPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(ComplianceReporterPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceServerDeployment) DeepCopyInto(out *ComplianceServerDeployment) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(ComplianceServerDeploymentSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceServerDeployment.
func (in *ComplianceServerDeployment) DeepCopy() *ComplianceServerDeployment {
	if in == nil {
		return nil
	}
	out := new(ComplianceServerDeployment)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceServerDeploymentContainer) DeepCopyInto(out *ComplianceServerDeploymentContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceServerDeploymentContainer.
func (in *ComplianceServerDeploymentContainer) DeepCopy() *ComplianceServerDeploymentContainer {
	if in == nil {
		return nil
	}
	out := new(ComplianceServerDeploymentContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceServerDeploymentInitContainer) DeepCopyInto(out *ComplianceServerDeploymentInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceServerDeploymentInitContainer.
func (in *ComplianceServerDeploymentInitContainer) DeepCopy() *ComplianceServerDeploymentInitContainer {
	if in == nil {
		return nil
	}
	out := new(ComplianceServerDeploymentInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceServerDeploymentPodSpec) DeepCopyInto(out *ComplianceServerDeploymentPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]ComplianceServerDeploymentInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]ComplianceServerDeploymentContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceServerDeploymentPodSpec.
func (in *ComplianceServerDeploymentPodSpec) DeepCopy() *ComplianceServerDeploymentPodSpec {
	if in == nil {
		return nil
	}
	out := new(ComplianceServerDeploymentPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceServerDeploymentPodTemplateSpec) DeepCopyInto(out *ComplianceServerDeploymentPodTemplateSpec) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(ComplianceServerDeploymentPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceServerDeploymentPodTemplateSpec.
func (in *ComplianceServerDeploymentPodTemplateSpec) DeepCopy() *ComplianceServerDeploymentPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(ComplianceServerDeploymentPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceServerDeploymentSpec) DeepCopyInto(out *ComplianceServerDeploymentSpec) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(ComplianceServerDeploymentPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceServerDeploymentSpec.
func (in *ComplianceServerDeploymentSpec) DeepCopy() *ComplianceServerDeploymentSpec {
	if in == nil {
		return nil
	}
	out := new(ComplianceServerDeploymentSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceSnapshotterDeployment) DeepCopyInto(out *ComplianceSnapshotterDeployment) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(ComplianceSnapshotterDeploymentSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceSnapshotterDeployment.
func (in *ComplianceSnapshotterDeployment) DeepCopy() *ComplianceSnapshotterDeployment {
	if in == nil {
		return nil
	}
	out := new(ComplianceSnapshotterDeployment)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceSnapshotterDeploymentContainer) DeepCopyInto(out *ComplianceSnapshotterDeploymentContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceSnapshotterDeploymentContainer.
func (in *ComplianceSnapshotterDeploymentContainer) DeepCopy() *ComplianceSnapshotterDeploymentContainer {
	if in == nil {
		return nil
	}
	out := new(ComplianceSnapshotterDeploymentContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceSnapshotterDeploymentInitContainer) DeepCopyInto(out *ComplianceSnapshotterDeploymentInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceSnapshotterDeploymentInitContainer.
func (in *ComplianceSnapshotterDeploymentInitContainer) DeepCopy() *ComplianceSnapshotterDeploymentInitContainer {
	if in == nil {
		return nil
	}
	out := new(ComplianceSnapshotterDeploymentInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceSnapshotterDeploymentPodSpec) DeepCopyInto(out *ComplianceSnapshotterDeploymentPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]ComplianceSnapshotterDeploymentInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]ComplianceSnapshotterDeploymentContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceSnapshotterDeploymentPodSpec.
func (in *ComplianceSnapshotterDeploymentPodSpec) DeepCopy() *ComplianceSnapshotterDeploymentPodSpec {
	if in == nil {
		return nil
	}
	out := new(ComplianceSnapshotterDeploymentPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceSnapshotterDeploymentPodTemplateSpec) DeepCopyInto(out *ComplianceSnapshotterDeploymentPodTemplateSpec) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(ComplianceSnapshotterDeploymentPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceSnapshotterDeploymentPodTemplateSpec.
func (in *ComplianceSnapshotterDeploymentPodTemplateSpec) DeepCopy() *ComplianceSnapshotterDeploymentPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(ComplianceSnapshotterDeploymentPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceSnapshotterDeploymentSpec) DeepCopyInto(out *ComplianceSnapshotterDeploymentSpec) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(ComplianceSnapshotterDeploymentPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceSnapshotterDeploymentSpec.
func (in *ComplianceSnapshotterDeploymentSpec) DeepCopy() *ComplianceSnapshotterDeploymentSpec {
	if in == nil {
		return nil
	}
	out := new(ComplianceSnapshotterDeploymentSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceSpec) DeepCopyInto(out *ComplianceSpec) {
	*out = *in
	if in.ComplianceControllerDeployment != nil {
		in, out := &in.ComplianceControllerDeployment, &out.ComplianceControllerDeployment
		*out = new(ComplianceControllerDeployment)
		(*in).DeepCopyInto(*out)
	}
	if in.ComplianceSnapshotterDeployment != nil {
		in, out := &in.ComplianceSnapshotterDeployment, &out.ComplianceSnapshotterDeployment
		*out = new(ComplianceSnapshotterDeployment)
		(*in).DeepCopyInto(*out)
	}
	if in.ComplianceBenchmarkerDaemonSet != nil {
		in, out := &in.ComplianceBenchmarkerDaemonSet, &out.ComplianceBenchmarkerDaemonSet
		*out = new(ComplianceBenchmarkerDaemonSet)
		(*in).DeepCopyInto(*out)
	}
	if in.ComplianceServerDeployment != nil {
		in, out := &in.ComplianceServerDeployment, &out.ComplianceServerDeployment
		*out = new(ComplianceServerDeployment)
		(*in).DeepCopyInto(*out)
	}
	if in.ComplianceReporterPodTemplate != nil {
		in, out := &in.ComplianceReporterPodTemplate, &out.ComplianceReporterPodTemplate
		*out = new(ComplianceReporterPodTemplate)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceSpec.
func (in *ComplianceSpec) DeepCopy() *ComplianceSpec {
	if in == nil {
		return nil
	}
	out := new(ComplianceSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComplianceStatus) DeepCopyInto(out *ComplianceStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]metav1.Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComplianceStatus.
func (in *ComplianceStatus) DeepCopy() *ComplianceStatus {
	if in == nil {
		return nil
	}
	out := new(ComplianceStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ComponentResource) DeepCopyInto(out *ComponentResource) {
	*out = *in
	if in.ResourceRequirements != nil {
		in, out := &in.ResourceRequirements, &out.ResourceRequirements
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ComponentResource.
func (in *ComponentResource) DeepCopy() *ComponentResource {
	if in == nil {
		return nil
	}
	out := new(ComponentResource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DPIDaemonsetInitContainer) DeepCopyInto(out *DPIDaemonsetInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DPIDaemonsetInitContainer.
func (in *DPIDaemonsetInitContainer) DeepCopy() *DPIDaemonsetInitContainer {
	if in == nil {
		return nil
	}
	out := new(DPIDaemonsetInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DPIDaemonsetSpec) DeepCopyInto(out *DPIDaemonsetSpec) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(DPIDaemonsetTemplate)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DPIDaemonsetSpec.
func (in *DPIDaemonsetSpec) DeepCopy() *DPIDaemonsetSpec {
	if in == nil {
		return nil
	}
	out := new(DPIDaemonsetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DPIDaemonsetTemplate) DeepCopyInto(out *DPIDaemonsetTemplate) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(DPIDaemonsetTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DPIDaemonsetTemplate.
func (in *DPIDaemonsetTemplate) DeepCopy() *DPIDaemonsetTemplate {
	if in == nil {
		return nil
	}
	out := new(DPIDaemonsetTemplate)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DPIDaemonsetTemplateSpec) DeepCopyInto(out *DPIDaemonsetTemplateSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]DPIDaemonsetInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DPIDaemonsetTemplateSpec.
func (in *DPIDaemonsetTemplateSpec) DeepCopy() *DPIDaemonsetTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(DPIDaemonsetTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DashboardsJob) DeepCopyInto(out *DashboardsJob) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(DashboardsJobSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DashboardsJob.
func (in *DashboardsJob) DeepCopy() *DashboardsJob {
	if in == nil {
		return nil
	}
	out := new(DashboardsJob)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DashboardsJobContainer) DeepCopyInto(out *DashboardsJobContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DashboardsJobContainer.
func (in *DashboardsJobContainer) DeepCopy() *DashboardsJobContainer {
	if in == nil {
		return nil
	}
	out := new(DashboardsJobContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DashboardsJobPodSpec) DeepCopyInto(out *DashboardsJobPodSpec) {
	*out = *in
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]DashboardsJobContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DashboardsJobPodSpec.
func (in *DashboardsJobPodSpec) DeepCopy() *DashboardsJobPodSpec {
	if in == nil {
		return nil
	}
	out := new(DashboardsJobPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DashboardsJobPodTemplateSpec) DeepCopyInto(out *DashboardsJobPodTemplateSpec) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(DashboardsJobPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DashboardsJobPodTemplateSpec.
func (in *DashboardsJobPodTemplateSpec) DeepCopy() *DashboardsJobPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(DashboardsJobPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DashboardsJobSpec) DeepCopyInto(out *DashboardsJobSpec) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(DashboardsJobPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DashboardsJobSpec.
func (in *DashboardsJobSpec) DeepCopy() *DashboardsJobSpec {
	if in == nil {
		return nil
	}
	out := new(DashboardsJobSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DeepPacketInspectionDaemonset) DeepCopyInto(out *DeepPacketInspectionDaemonset) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(DPIDaemonsetSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DeepPacketInspectionDaemonset.
func (in *DeepPacketInspectionDaemonset) DeepCopy() *DeepPacketInspectionDaemonset {
	if in == nil {
		return nil
	}
	out := new(DeepPacketInspectionDaemonset)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DexDeployment) DeepCopyInto(out *DexDeployment) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(DexDeploymentSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DexDeployment.
func (in *DexDeployment) DeepCopy() *DexDeployment {
	if in == nil {
		return nil
	}
	out := new(DexDeployment)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DexDeploymentContainer) DeepCopyInto(out *DexDeploymentContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DexDeploymentContainer.
func (in *DexDeploymentContainer) DeepCopy() *DexDeploymentContainer {
	if in == nil {
		return nil
	}
	out := new(DexDeploymentContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DexDeploymentInitContainer) DeepCopyInto(out *DexDeploymentInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DexDeploymentInitContainer.
func (in *DexDeploymentInitContainer) DeepCopy() *DexDeploymentInitContainer {
	if in == nil {
		return nil
	}
	out := new(DexDeploymentInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DexDeploymentPodSpec) DeepCopyInto(out *DexDeploymentPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]DexDeploymentInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]DexDeploymentContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DexDeploymentPodSpec.
func (in *DexDeploymentPodSpec) DeepCopy() *DexDeploymentPodSpec {
	if in == nil {
		return nil
	}
	out := new(DexDeploymentPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DexDeploymentPodTemplateSpec) DeepCopyInto(out *DexDeploymentPodTemplateSpec) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(DexDeploymentPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DexDeploymentPodTemplateSpec.
func (in *DexDeploymentPodTemplateSpec) DeepCopy() *DexDeploymentPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(DexDeploymentPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DexDeploymentSpec) DeepCopyInto(out *DexDeploymentSpec) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(DexDeploymentPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DexDeploymentSpec.
func (in *DexDeploymentSpec) DeepCopy() *DexDeploymentSpec {
	if in == nil {
		return nil
	}
	out := new(DexDeploymentSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ECKOperatorStatefulSet) DeepCopyInto(out *ECKOperatorStatefulSet) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(ECKOperatorStatefulSetSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ECKOperatorStatefulSet.
func (in *ECKOperatorStatefulSet) DeepCopy() *ECKOperatorStatefulSet {
	if in == nil {
		return nil
	}
	out := new(ECKOperatorStatefulSet)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ECKOperatorStatefulSetContainer) DeepCopyInto(out *ECKOperatorStatefulSetContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ECKOperatorStatefulSetContainer.
func (in *ECKOperatorStatefulSetContainer) DeepCopy() *ECKOperatorStatefulSetContainer {
	if in == nil {
		return nil
	}
	out := new(ECKOperatorStatefulSetContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ECKOperatorStatefulSetInitContainer) DeepCopyInto(out *ECKOperatorStatefulSetInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ECKOperatorStatefulSetInitContainer.
func (in *ECKOperatorStatefulSetInitContainer) DeepCopy() *ECKOperatorStatefulSetInitContainer {
	if in == nil {
		return nil
	}
	out := new(ECKOperatorStatefulSetInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ECKOperatorStatefulSetPodSpec) DeepCopyInto(out *ECKOperatorStatefulSetPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]ECKOperatorStatefulSetInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]ECKOperatorStatefulSetContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ECKOperatorStatefulSetPodSpec.
func (in *ECKOperatorStatefulSetPodSpec) DeepCopy() *ECKOperatorStatefulSetPodSpec {
	if in == nil {
		return nil
	}
	out := new(ECKOperatorStatefulSetPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ECKOperatorStatefulSetPodTemplateSpec) DeepCopyInto(out *ECKOperatorStatefulSetPodTemplateSpec) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(ECKOperatorStatefulSetPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ECKOperatorStatefulSetPodTemplateSpec.
func (in *ECKOperatorStatefulSetPodTemplateSpec) DeepCopy() *ECKOperatorStatefulSetPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(ECKOperatorStatefulSetPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ECKOperatorStatefulSetSpec) DeepCopyInto(out *ECKOperatorStatefulSetSpec) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(ECKOperatorStatefulSetPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ECKOperatorStatefulSetSpec.
func (in *ECKOperatorStatefulSetSpec) DeepCopy() *ECKOperatorStatefulSetSpec {
	if in == nil {
		return nil
	}
	out := new(ECKOperatorStatefulSetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EGWDeploymentContainer) DeepCopyInto(out *EGWDeploymentContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EGWDeploymentContainer.
func (in *EGWDeploymentContainer) DeepCopy() *EGWDeploymentContainer {
	if in == nil {
		return nil
	}
	out := new(EGWDeploymentContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EGWDeploymentInitContainer) DeepCopyInto(out *EGWDeploymentInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EGWDeploymentInitContainer.
func (in *EGWDeploymentInitContainer) DeepCopy() *EGWDeploymentInitContainer {
	if in == nil {
		return nil
	}
	out := new(EGWDeploymentInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EKSLogForwarderDeployment) DeepCopyInto(out *EKSLogForwarderDeployment) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(EKSLogForwarderDeploymentSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EKSLogForwarderDeployment.
func (in *EKSLogForwarderDeployment) DeepCopy() *EKSLogForwarderDeployment {
	if in == nil {
		return nil
	}
	out := new(EKSLogForwarderDeployment)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EKSLogForwarderDeploymentContainer) DeepCopyInto(out *EKSLogForwarderDeploymentContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EKSLogForwarderDeploymentContainer.
func (in *EKSLogForwarderDeploymentContainer) DeepCopy() *EKSLogForwarderDeploymentContainer {
	if in == nil {
		return nil
	}
	out := new(EKSLogForwarderDeploymentContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EKSLogForwarderDeploymentInitContainer) DeepCopyInto(out *EKSLogForwarderDeploymentInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EKSLogForwarderDeploymentInitContainer.
func (in *EKSLogForwarderDeploymentInitContainer) DeepCopy() *EKSLogForwarderDeploymentInitContainer {
	if in == nil {
		return nil
	}
	out := new(EKSLogForwarderDeploymentInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EKSLogForwarderDeploymentPodSpec) DeepCopyInto(out *EKSLogForwarderDeploymentPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]EKSLogForwarderDeploymentInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]EKSLogForwarderDeploymentContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EKSLogForwarderDeploymentPodSpec.
func (in *EKSLogForwarderDeploymentPodSpec) DeepCopy() *EKSLogForwarderDeploymentPodSpec {
	if in == nil {
		return nil
	}
	out := new(EKSLogForwarderDeploymentPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EKSLogForwarderDeploymentPodTemplateSpec) DeepCopyInto(out *EKSLogForwarderDeploymentPodTemplateSpec) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(EKSLogForwarderDeploymentPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EKSLogForwarderDeploymentPodTemplateSpec.
func (in *EKSLogForwarderDeploymentPodTemplateSpec) DeepCopy() *EKSLogForwarderDeploymentPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(EKSLogForwarderDeploymentPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EKSLogForwarderDeploymentSpec) DeepCopyInto(out *EKSLogForwarderDeploymentSpec) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(EKSLogForwarderDeploymentPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EKSLogForwarderDeploymentSpec.
func (in *EKSLogForwarderDeploymentSpec) DeepCopy() *EKSLogForwarderDeploymentSpec {
	if in == nil {
		return nil
	}
	out := new(EKSLogForwarderDeploymentSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ESGatewayDeployment) DeepCopyInto(out *ESGatewayDeployment) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(ESGatewayDeploymentSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ESGatewayDeployment.
func (in *ESGatewayDeployment) DeepCopy() *ESGatewayDeployment {
	if in == nil {
		return nil
	}
	out := new(ESGatewayDeployment)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ESGatewayDeploymentContainer) DeepCopyInto(out *ESGatewayDeploymentContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ESGatewayDeploymentContainer.
func (in *ESGatewayDeploymentContainer) DeepCopy() *ESGatewayDeploymentContainer {
	if in == nil {
		return nil
	}
	out := new(ESGatewayDeploymentContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ESGatewayDeploymentInitContainer) DeepCopyInto(out *ESGatewayDeploymentInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ESGatewayDeploymentInitContainer.
func (in *ESGatewayDeploymentInitContainer) DeepCopy() *ESGatewayDeploymentInitContainer {
	if in == nil {
		return nil
	}
	out := new(ESGatewayDeploymentInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ESGatewayDeploymentPodSpec) DeepCopyInto(out *ESGatewayDeploymentPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]ESGatewayDeploymentInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]ESGatewayDeploymentContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ESGatewayDeploymentPodSpec.
func (in *ESGatewayDeploymentPodSpec) DeepCopy() *ESGatewayDeploymentPodSpec {
	if in == nil {
		return nil
	}
	out := new(ESGatewayDeploymentPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ESGatewayDeploymentPodTemplateSpec) DeepCopyInto(out *ESGatewayDeploymentPodTemplateSpec) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(ESGatewayDeploymentPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ESGatewayDeploymentPodTemplateSpec.
func (in *ESGatewayDeploymentPodTemplateSpec) DeepCopy() *ESGatewayDeploymentPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(ESGatewayDeploymentPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ESGatewayDeploymentSpec) DeepCopyInto(out *ESGatewayDeploymentSpec) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(ESGatewayDeploymentPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ESGatewayDeploymentSpec.
func (in *ESGatewayDeploymentSpec) DeepCopy() *ESGatewayDeploymentSpec {
	if in == nil {
		return nil
	}
	out := new(ESGatewayDeploymentSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EgressGateway) DeepCopyInto(out *EgressGateway) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EgressGateway.
func (in *EgressGateway) DeepCopy() *EgressGateway {
	if in == nil {
		return nil
	}
	out := new(EgressGateway)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *EgressGateway) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EgressGatewayDeploymentPodSpec) DeepCopyInto(out *EgressGatewayDeploymentPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]EGWDeploymentInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]EGWDeploymentContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Affinity != nil {
		in, out := &in.Affinity, &out.Affinity
		*out = new(corev1.Affinity)
		(*in).DeepCopyInto(*out)
	}
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.TerminationGracePeriodSeconds != nil {
		in, out := &in.TerminationGracePeriodSeconds, &out.TerminationGracePeriodSeconds
		*out = new(int64)
		**out = **in
	}
	if in.TopologySpreadConstraints != nil {
		in, out := &in.TopologySpreadConstraints, &out.TopologySpreadConstraints
		*out = make([]corev1.TopologySpreadConstraint, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EgressGatewayDeploymentPodSpec.
func (in *EgressGatewayDeploymentPodSpec) DeepCopy() *EgressGatewayDeploymentPodSpec {
	if in == nil {
		return nil
	}
	out := new(EgressGatewayDeploymentPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EgressGatewayDeploymentPodTemplateSpec) DeepCopyInto(out *EgressGatewayDeploymentPodTemplateSpec) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(EgressGatewayMetadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(EgressGatewayDeploymentPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EgressGatewayDeploymentPodTemplateSpec.
func (in *EgressGatewayDeploymentPodTemplateSpec) DeepCopy() *EgressGatewayDeploymentPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(EgressGatewayDeploymentPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EgressGatewayFailureDetection) DeepCopyInto(out *EgressGatewayFailureDetection) {
	*out = *in
	if in.HealthTimeoutDataStoreSeconds != nil {
		in, out := &in.HealthTimeoutDataStoreSeconds, &out.HealthTimeoutDataStoreSeconds
		*out = new(int32)
		**out = **in
	}
	if in.ICMPProbe != nil {
		in, out := &in.ICMPProbe, &out.ICMPProbe
		*out = new(ICMPProbe)
		(*in).DeepCopyInto(*out)
	}
	if in.HTTPProbe != nil {
		in, out := &in.HTTPProbe, &out.HTTPProbe
		*out = new(HTTPProbe)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EgressGatewayFailureDetection.
func (in *EgressGatewayFailureDetection) DeepCopy() *EgressGatewayFailureDetection {
	if in == nil {
		return nil
	}
	out := new(EgressGatewayFailureDetection)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EgressGatewayIPPool) DeepCopyInto(out *EgressGatewayIPPool) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EgressGatewayIPPool.
func (in *EgressGatewayIPPool) DeepCopy() *EgressGatewayIPPool {
	if in == nil {
		return nil
	}
	out := new(EgressGatewayIPPool)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EgressGatewayList) DeepCopyInto(out *EgressGatewayList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]EgressGateway, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EgressGatewayList.
func (in *EgressGatewayList) DeepCopy() *EgressGatewayList {
	if in == nil {
		return nil
	}
	out := new(EgressGatewayList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *EgressGatewayList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EgressGatewayMetadata) DeepCopyInto(out *EgressGatewayMetadata) {
	*out = *in
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Annotations != nil {
		in, out := &in.Annotations, &out.Annotations
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EgressGatewayMetadata.
func (in *EgressGatewayMetadata) DeepCopy() *EgressGatewayMetadata {
	if in == nil {
		return nil
	}
	out := new(EgressGatewayMetadata)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EgressGatewaySpec) DeepCopyInto(out *EgressGatewaySpec) {
	*out = *in
	if in.Replicas != nil {
		in, out := &in.Replicas, &out.Replicas
		*out = new(int32)
		**out = **in
	}
	if in.IPPools != nil {
		in, out := &in.IPPools, &out.IPPools
		*out = make([]EgressGatewayIPPool, len(*in))
		copy(*out, *in)
	}
	if in.ExternalNetworks != nil {
		in, out := &in.ExternalNetworks, &out.ExternalNetworks
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.LogSeverity != nil {
		in, out := &in.LogSeverity, &out.LogSeverity
		*out = new(LogSeverity)
		**out = **in
	}
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(EgressGatewayDeploymentPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.EgressGatewayFailureDetection != nil {
		in, out := &in.EgressGatewayFailureDetection, &out.EgressGatewayFailureDetection
		*out = new(EgressGatewayFailureDetection)
		(*in).DeepCopyInto(*out)
	}
	if in.AWS != nil {
		in, out := &in.AWS, &out.AWS
		*out = new(AWSEgressGateway)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EgressGatewaySpec.
func (in *EgressGatewaySpec) DeepCopy() *EgressGatewaySpec {
	if in == nil {
		return nil
	}
	out := new(EgressGatewaySpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EgressGatewayStatus) DeepCopyInto(out *EgressGatewayStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]metav1.Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EgressGatewayStatus.
func (in *EgressGatewayStatus) DeepCopy() *EgressGatewayStatus {
	if in == nil {
		return nil
	}
	out := new(EgressGatewayStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EksCloudwatchLogsSpec) DeepCopyInto(out *EksCloudwatchLogsSpec) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EksCloudwatchLogsSpec.
func (in *EksCloudwatchLogsSpec) DeepCopy() *EksCloudwatchLogsSpec {
	if in == nil {
		return nil
	}
	out := new(EksCloudwatchLogsSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ElasticsearchMetricsDeployment) DeepCopyInto(out *ElasticsearchMetricsDeployment) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(ElasticsearchMetricsDeploymentSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ElasticsearchMetricsDeployment.
func (in *ElasticsearchMetricsDeployment) DeepCopy() *ElasticsearchMetricsDeployment {
	if in == nil {
		return nil
	}
	out := new(ElasticsearchMetricsDeployment)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ElasticsearchMetricsDeploymentContainer) DeepCopyInto(out *ElasticsearchMetricsDeploymentContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ElasticsearchMetricsDeploymentContainer.
func (in *ElasticsearchMetricsDeploymentContainer) DeepCopy() *ElasticsearchMetricsDeploymentContainer {
	if in == nil {
		return nil
	}
	out := new(ElasticsearchMetricsDeploymentContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ElasticsearchMetricsDeploymentInitContainer) DeepCopyInto(out *ElasticsearchMetricsDeploymentInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ElasticsearchMetricsDeploymentInitContainer.
func (in *ElasticsearchMetricsDeploymentInitContainer) DeepCopy() *ElasticsearchMetricsDeploymentInitContainer {
	if in == nil {
		return nil
	}
	out := new(ElasticsearchMetricsDeploymentInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ElasticsearchMetricsDeploymentPodSpec) DeepCopyInto(out *ElasticsearchMetricsDeploymentPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]ElasticsearchMetricsDeploymentInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]ElasticsearchMetricsDeploymentContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ElasticsearchMetricsDeploymentPodSpec.
func (in *ElasticsearchMetricsDeploymentPodSpec) DeepCopy() *ElasticsearchMetricsDeploymentPodSpec {
	if in == nil {
		return nil
	}
	out := new(ElasticsearchMetricsDeploymentPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ElasticsearchMetricsDeploymentPodTemplateSpec) DeepCopyInto(out *ElasticsearchMetricsDeploymentPodTemplateSpec) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(ElasticsearchMetricsDeploymentPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ElasticsearchMetricsDeploymentPodTemplateSpec.
func (in *ElasticsearchMetricsDeploymentPodTemplateSpec) DeepCopy() *ElasticsearchMetricsDeploymentPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(ElasticsearchMetricsDeploymentPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ElasticsearchMetricsDeploymentSpec) DeepCopyInto(out *ElasticsearchMetricsDeploymentSpec) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(ElasticsearchMetricsDeploymentPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ElasticsearchMetricsDeploymentSpec.
func (in *ElasticsearchMetricsDeploymentSpec) DeepCopy() *ElasticsearchMetricsDeploymentSpec {
	if in == nil {
		return nil
	}
	out := new(ElasticsearchMetricsDeploymentSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Endpoint) DeepCopyInto(out *Endpoint) {
	*out = *in
	if in.Params != nil {
		in, out := &in.Params, &out.Params
		*out = make(map[string][]string, len(*in))
		for key, val := range *in {
			var outVal []string
			if val == nil {
				(*out)[key] = nil
			} else {
				inVal := (*in)[key]
				in, out := &inVal, &outVal
				*out = make([]string, len(*in))
				copy(*out, *in)
			}
			(*out)[key] = outVal
		}
	}
	in.BearerTokenSecret.DeepCopyInto(&out.BearerTokenSecret)
	if in.HonorTimestamps != nil {
		in, out := &in.HonorTimestamps, &out.HonorTimestamps
		*out = new(bool)
		**out = **in
	}
	if in.MetricRelabelConfigs != nil {
		in, out := &in.MetricRelabelConfigs, &out.MetricRelabelConfigs
		*out = make([]monitoringv1.RelabelConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.RelabelConfigs != nil {
		in, out := &in.RelabelConfigs, &out.RelabelConfigs
		*out = make([]monitoringv1.RelabelConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Endpoint.
func (in *Endpoint) DeepCopy() *Endpoint {
	if in == nil {
		return nil
	}
	out := new(Endpoint)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EnvoySettings) DeepCopyInto(out *EnvoySettings) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EnvoySettings.
func (in *EnvoySettings) DeepCopy() *EnvoySettings {
	if in == nil {
		return nil
	}
	out := new(EnvoySettings)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalPrometheus) DeepCopyInto(out *ExternalPrometheus) {
	*out = *in
	if in.ServiceMonitor != nil {
		in, out := &in.ServiceMonitor, &out.ServiceMonitor
		*out = new(ServiceMonitor)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalPrometheus.
func (in *ExternalPrometheus) DeepCopy() *ExternalPrometheus {
	if in == nil {
		return nil
	}
	out := new(ExternalPrometheus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FluentdDaemonSet) DeepCopyInto(out *FluentdDaemonSet) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(FluentdDaemonSetSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FluentdDaemonSet.
func (in *FluentdDaemonSet) DeepCopy() *FluentdDaemonSet {
	if in == nil {
		return nil
	}
	out := new(FluentdDaemonSet)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FluentdDaemonSetContainer) DeepCopyInto(out *FluentdDaemonSetContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FluentdDaemonSetContainer.
func (in *FluentdDaemonSetContainer) DeepCopy() *FluentdDaemonSetContainer {
	if in == nil {
		return nil
	}
	out := new(FluentdDaemonSetContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FluentdDaemonSetInitContainer) DeepCopyInto(out *FluentdDaemonSetInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FluentdDaemonSetInitContainer.
func (in *FluentdDaemonSetInitContainer) DeepCopy() *FluentdDaemonSetInitContainer {
	if in == nil {
		return nil
	}
	out := new(FluentdDaemonSetInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FluentdDaemonSetPodSpec) DeepCopyInto(out *FluentdDaemonSetPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]FluentdDaemonSetInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]FluentdDaemonSetContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FluentdDaemonSetPodSpec.
func (in *FluentdDaemonSetPodSpec) DeepCopy() *FluentdDaemonSetPodSpec {
	if in == nil {
		return nil
	}
	out := new(FluentdDaemonSetPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FluentdDaemonSetPodTemplateSpec) DeepCopyInto(out *FluentdDaemonSetPodTemplateSpec) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(FluentdDaemonSetPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FluentdDaemonSetPodTemplateSpec.
func (in *FluentdDaemonSetPodTemplateSpec) DeepCopy() *FluentdDaemonSetPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(FluentdDaemonSetPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FluentdDaemonSetSpec) DeepCopyInto(out *FluentdDaemonSetSpec) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(FluentdDaemonSetPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FluentdDaemonSetSpec.
func (in *FluentdDaemonSetSpec) DeepCopy() *FluentdDaemonSetSpec {
	if in == nil {
		return nil
	}
	out := new(FluentdDaemonSetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayAPI) DeepCopyInto(out *GatewayAPI) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayAPI.
func (in *GatewayAPI) DeepCopy() *GatewayAPI {
	if in == nil {
		return nil
	}
	out := new(GatewayAPI)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *GatewayAPI) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayAPIList) DeepCopyInto(out *GatewayAPIList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]GatewayAPI, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayAPIList.
func (in *GatewayAPIList) DeepCopy() *GatewayAPIList {
	if in == nil {
		return nil
	}
	out := new(GatewayAPIList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *GatewayAPIList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayAPISpec) DeepCopyInto(out *GatewayAPISpec) {
	*out = *in
	if in.EnvoyGatewayConfigRef != nil {
		in, out := &in.EnvoyGatewayConfigRef, &out.EnvoyGatewayConfigRef
		*out = new(NamespacedName)
		**out = **in
	}
	if in.GatewayClasses != nil {
		in, out := &in.GatewayClasses, &out.GatewayClasses
		*out = make([]GatewayClassSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.GatewayControllerDeployment != nil {
		in, out := &in.GatewayControllerDeployment, &out.GatewayControllerDeployment
		*out = new(GatewayControllerDeployment)
		(*in).DeepCopyInto(*out)
	}
	if in.GatewayCertgenJob != nil {
		in, out := &in.GatewayCertgenJob, &out.GatewayCertgenJob
		*out = new(GatewayCertgenJob)
		(*in).DeepCopyInto(*out)
	}
	if in.CRDManagement != nil {
		in, out := &in.CRDManagement, &out.CRDManagement
		*out = new(CRDManagement)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayAPISpec.
func (in *GatewayAPISpec) DeepCopy() *GatewayAPISpec {
	if in == nil {
		return nil
	}
	out := new(GatewayAPISpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayCertgenJob) DeepCopyInto(out *GatewayCertgenJob) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(GatewayCertgenJobSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayCertgenJob.
func (in *GatewayCertgenJob) DeepCopy() *GatewayCertgenJob {
	if in == nil {
		return nil
	}
	out := new(GatewayCertgenJob)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayCertgenJobContainer) DeepCopyInto(out *GatewayCertgenJobContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayCertgenJobContainer.
func (in *GatewayCertgenJobContainer) DeepCopy() *GatewayCertgenJobContainer {
	if in == nil {
		return nil
	}
	out := new(GatewayCertgenJobContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayCertgenJobPodSpec) DeepCopyInto(out *GatewayCertgenJobPodSpec) {
	*out = *in
	if in.Affinity != nil {
		in, out := &in.Affinity, &out.Affinity
		*out = new(corev1.Affinity)
		(*in).DeepCopyInto(*out)
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]GatewayCertgenJobContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayCertgenJobPodSpec.
func (in *GatewayCertgenJobPodSpec) DeepCopy() *GatewayCertgenJobPodSpec {
	if in == nil {
		return nil
	}
	out := new(GatewayCertgenJobPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayCertgenJobPodTemplate) DeepCopyInto(out *GatewayCertgenJobPodTemplate) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(GatewayCertgenJobPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayCertgenJobPodTemplate.
func (in *GatewayCertgenJobPodTemplate) DeepCopy() *GatewayCertgenJobPodTemplate {
	if in == nil {
		return nil
	}
	out := new(GatewayCertgenJobPodTemplate)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayCertgenJobSpec) DeepCopyInto(out *GatewayCertgenJobSpec) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(GatewayCertgenJobPodTemplate)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayCertgenJobSpec.
func (in *GatewayCertgenJobSpec) DeepCopy() *GatewayCertgenJobSpec {
	if in == nil {
		return nil
	}
	out := new(GatewayCertgenJobSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayClassSpec) DeepCopyInto(out *GatewayClassSpec) {
	*out = *in
	if in.EnvoyProxyRef != nil {
		in, out := &in.EnvoyProxyRef, &out.EnvoyProxyRef
		*out = new(NamespacedName)
		**out = **in
	}
	if in.GatewayKind != nil {
		in, out := &in.GatewayKind, &out.GatewayKind
		*out = new(GatewayKind)
		**out = **in
	}
	if in.GatewayDeployment != nil {
		in, out := &in.GatewayDeployment, &out.GatewayDeployment
		*out = new(GatewayDeployment)
		(*in).DeepCopyInto(*out)
	}
	if in.GatewayDaemonSet != nil {
		in, out := &in.GatewayDaemonSet, &out.GatewayDaemonSet
		*out = new(GatewayDaemonSet)
		(*in).DeepCopyInto(*out)
	}
	if in.GatewayService != nil {
		in, out := &in.GatewayService, &out.GatewayService
		*out = new(GatewayService)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayClassSpec.
func (in *GatewayClassSpec) DeepCopy() *GatewayClassSpec {
	if in == nil {
		return nil
	}
	out := new(GatewayClassSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayControllerDeployment) DeepCopyInto(out *GatewayControllerDeployment) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(GatewayControllerDeploymentSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayControllerDeployment.
func (in *GatewayControllerDeployment) DeepCopy() *GatewayControllerDeployment {
	if in == nil {
		return nil
	}
	out := new(GatewayControllerDeployment)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayControllerDeploymentContainer) DeepCopyInto(out *GatewayControllerDeploymentContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayControllerDeploymentContainer.
func (in *GatewayControllerDeploymentContainer) DeepCopy() *GatewayControllerDeploymentContainer {
	if in == nil {
		return nil
	}
	out := new(GatewayControllerDeploymentContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayControllerDeploymentPodSpec) DeepCopyInto(out *GatewayControllerDeploymentPodSpec) {
	*out = *in
	if in.Affinity != nil {
		in, out := &in.Affinity, &out.Affinity
		*out = new(corev1.Affinity)
		(*in).DeepCopyInto(*out)
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]GatewayControllerDeploymentContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.TopologySpreadConstraints != nil {
		in, out := &in.TopologySpreadConstraints, &out.TopologySpreadConstraints
		*out = make([]corev1.TopologySpreadConstraint, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayControllerDeploymentPodSpec.
func (in *GatewayControllerDeploymentPodSpec) DeepCopy() *GatewayControllerDeploymentPodSpec {
	if in == nil {
		return nil
	}
	out := new(GatewayControllerDeploymentPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayControllerDeploymentPodTemplate) DeepCopyInto(out *GatewayControllerDeploymentPodTemplate) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(GatewayControllerDeploymentPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayControllerDeploymentPodTemplate.
func (in *GatewayControllerDeploymentPodTemplate) DeepCopy() *GatewayControllerDeploymentPodTemplate {
	if in == nil {
		return nil
	}
	out := new(GatewayControllerDeploymentPodTemplate)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayControllerDeploymentSpec) DeepCopyInto(out *GatewayControllerDeploymentSpec) {
	*out = *in
	if in.Replicas != nil {
		in, out := &in.Replicas, &out.Replicas
		*out = new(int32)
		**out = **in
	}
	if in.MinReadySeconds != nil {
		in, out := &in.MinReadySeconds, &out.MinReadySeconds
		*out = new(int32)
		**out = **in
	}
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(GatewayControllerDeploymentPodTemplate)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayControllerDeploymentSpec.
func (in *GatewayControllerDeploymentSpec) DeepCopy() *GatewayControllerDeploymentSpec {
	if in == nil {
		return nil
	}
	out := new(GatewayControllerDeploymentSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayDaemonSet) DeepCopyInto(out *GatewayDaemonSet) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(GatewayDaemonSetSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayDaemonSet.
func (in *GatewayDaemonSet) DeepCopy() *GatewayDaemonSet {
	if in == nil {
		return nil
	}
	out := new(GatewayDaemonSet)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayDaemonSetContainer) DeepCopyInto(out *GatewayDaemonSetContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayDaemonSetContainer.
func (in *GatewayDaemonSetContainer) DeepCopy() *GatewayDaemonSetContainer {
	if in == nil {
		return nil
	}
	out := new(GatewayDaemonSetContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayDaemonSetPodSpec) DeepCopyInto(out *GatewayDaemonSetPodSpec) {
	*out = *in
	if in.Affinity != nil {
		in, out := &in.Affinity, &out.Affinity
		*out = new(corev1.Affinity)
		(*in).DeepCopyInto(*out)
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]GatewayDaemonSetContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.TopologySpreadConstraints != nil {
		in, out := &in.TopologySpreadConstraints, &out.TopologySpreadConstraints
		*out = make([]corev1.TopologySpreadConstraint, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayDaemonSetPodSpec.
func (in *GatewayDaemonSetPodSpec) DeepCopy() *GatewayDaemonSetPodSpec {
	if in == nil {
		return nil
	}
	out := new(GatewayDaemonSetPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayDaemonSetPodTemplate) DeepCopyInto(out *GatewayDaemonSetPodTemplate) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(GatewayDaemonSetPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayDaemonSetPodTemplate.
func (in *GatewayDaemonSetPodTemplate) DeepCopy() *GatewayDaemonSetPodTemplate {
	if in == nil {
		return nil
	}
	out := new(GatewayDaemonSetPodTemplate)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayDaemonSetSpec) DeepCopyInto(out *GatewayDaemonSetSpec) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(GatewayDaemonSetPodTemplate)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayDaemonSetSpec.
func (in *GatewayDaemonSetSpec) DeepCopy() *GatewayDaemonSetSpec {
	if in == nil {
		return nil
	}
	out := new(GatewayDaemonSetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayDeployment) DeepCopyInto(out *GatewayDeployment) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(GatewayDeploymentSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayDeployment.
func (in *GatewayDeployment) DeepCopy() *GatewayDeployment {
	if in == nil {
		return nil
	}
	out := new(GatewayDeployment)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayDeploymentContainer) DeepCopyInto(out *GatewayDeploymentContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayDeploymentContainer.
func (in *GatewayDeploymentContainer) DeepCopy() *GatewayDeploymentContainer {
	if in == nil {
		return nil
	}
	out := new(GatewayDeploymentContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayDeploymentPodSpec) DeepCopyInto(out *GatewayDeploymentPodSpec) {
	*out = *in
	if in.Affinity != nil {
		in, out := &in.Affinity, &out.Affinity
		*out = new(corev1.Affinity)
		(*in).DeepCopyInto(*out)
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]GatewayDeploymentContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.TopologySpreadConstraints != nil {
		in, out := &in.TopologySpreadConstraints, &out.TopologySpreadConstraints
		*out = make([]corev1.TopologySpreadConstraint, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayDeploymentPodSpec.
func (in *GatewayDeploymentPodSpec) DeepCopy() *GatewayDeploymentPodSpec {
	if in == nil {
		return nil
	}
	out := new(GatewayDeploymentPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayDeploymentPodTemplate) DeepCopyInto(out *GatewayDeploymentPodTemplate) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(GatewayDeploymentPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayDeploymentPodTemplate.
func (in *GatewayDeploymentPodTemplate) DeepCopy() *GatewayDeploymentPodTemplate {
	if in == nil {
		return nil
	}
	out := new(GatewayDeploymentPodTemplate)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayDeploymentSpec) DeepCopyInto(out *GatewayDeploymentSpec) {
	*out = *in
	if in.Replicas != nil {
		in, out := &in.Replicas, &out.Replicas
		*out = new(int32)
		**out = **in
	}
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(GatewayDeploymentPodTemplate)
		(*in).DeepCopyInto(*out)
	}
	if in.Strategy != nil {
		in, out := &in.Strategy, &out.Strategy
		*out = new(GatewayDeploymentStrategy)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayDeploymentSpec.
func (in *GatewayDeploymentSpec) DeepCopy() *GatewayDeploymentSpec {
	if in == nil {
		return nil
	}
	out := new(GatewayDeploymentSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayDeploymentStrategy) DeepCopyInto(out *GatewayDeploymentStrategy) {
	*out = *in
	if in.RollingUpdate != nil {
		in, out := &in.RollingUpdate, &out.RollingUpdate
		*out = new(appsv1.RollingUpdateDeployment)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayDeploymentStrategy.
func (in *GatewayDeploymentStrategy) DeepCopy() *GatewayDeploymentStrategy {
	if in == nil {
		return nil
	}
	out := new(GatewayDeploymentStrategy)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayService) DeepCopyInto(out *GatewayService) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(GatewayServiceSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayService.
func (in *GatewayService) DeepCopy() *GatewayService {
	if in == nil {
		return nil
	}
	out := new(GatewayService)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewayServiceSpec) DeepCopyInto(out *GatewayServiceSpec) {
	*out = *in
	if in.LoadBalancerClass != nil {
		in, out := &in.LoadBalancerClass, &out.LoadBalancerClass
		*out = new(string)
		**out = **in
	}
	if in.AllocateLoadBalancerNodePorts != nil {
		in, out := &in.AllocateLoadBalancerNodePorts, &out.AllocateLoadBalancerNodePorts
		*out = new(bool)
		**out = **in
	}
	if in.LoadBalancerSourceRanges != nil {
		in, out := &in.LoadBalancerSourceRanges, &out.LoadBalancerSourceRanges
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.LoadBalancerIP != nil {
		in, out := &in.LoadBalancerIP, &out.LoadBalancerIP
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewayServiceSpec.
func (in *GatewayServiceSpec) DeepCopy() *GatewayServiceSpec {
	if in == nil {
		return nil
	}
	out := new(GatewayServiceSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Goldmane) DeepCopyInto(out *Goldmane) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Goldmane.
func (in *Goldmane) DeepCopy() *Goldmane {
	if in == nil {
		return nil
	}
	out := new(Goldmane)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *Goldmane) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GoldmaneDeployment) DeepCopyInto(out *GoldmaneDeployment) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(GoldmaneDeploymentSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GoldmaneDeployment.
func (in *GoldmaneDeployment) DeepCopy() *GoldmaneDeployment {
	if in == nil {
		return nil
	}
	out := new(GoldmaneDeployment)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GoldmaneDeploymentContainer) DeepCopyInto(out *GoldmaneDeploymentContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GoldmaneDeploymentContainer.
func (in *GoldmaneDeploymentContainer) DeepCopy() *GoldmaneDeploymentContainer {
	if in == nil {
		return nil
	}
	out := new(GoldmaneDeploymentContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GoldmaneDeploymentPodSpec) DeepCopyInto(out *GoldmaneDeploymentPodSpec) {
	*out = *in
	if in.Affinity != nil {
		in, out := &in.Affinity, &out.Affinity
		*out = new(corev1.Affinity)
		(*in).DeepCopyInto(*out)
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]GoldmaneDeploymentContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.TerminationGracePeriodSeconds != nil {
		in, out := &in.TerminationGracePeriodSeconds, &out.TerminationGracePeriodSeconds
		*out = new(int64)
		**out = **in
	}
	if in.TopologySpreadConstraints != nil {
		in, out := &in.TopologySpreadConstraints, &out.TopologySpreadConstraints
		*out = make([]corev1.TopologySpreadConstraint, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GoldmaneDeploymentPodSpec.
func (in *GoldmaneDeploymentPodSpec) DeepCopy() *GoldmaneDeploymentPodSpec {
	if in == nil {
		return nil
	}
	out := new(GoldmaneDeploymentPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GoldmaneDeploymentPodTemplateSpec) DeepCopyInto(out *GoldmaneDeploymentPodTemplateSpec) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(GoldmaneDeploymentPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GoldmaneDeploymentPodTemplateSpec.
func (in *GoldmaneDeploymentPodTemplateSpec) DeepCopy() *GoldmaneDeploymentPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(GoldmaneDeploymentPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GoldmaneDeploymentSpec) DeepCopyInto(out *GoldmaneDeploymentSpec) {
	*out = *in
	if in.MinReadySeconds != nil {
		in, out := &in.MinReadySeconds, &out.MinReadySeconds
		*out = new(int32)
		**out = **in
	}
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(GoldmaneDeploymentPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Strategy != nil {
		in, out := &in.Strategy, &out.Strategy
		*out = new(GoldmaneDeploymentStrategy)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GoldmaneDeploymentSpec.
func (in *GoldmaneDeploymentSpec) DeepCopy() *GoldmaneDeploymentSpec {
	if in == nil {
		return nil
	}
	out := new(GoldmaneDeploymentSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GoldmaneDeploymentStrategy) DeepCopyInto(out *GoldmaneDeploymentStrategy) {
	*out = *in
	if in.RollingUpdate != nil {
		in, out := &in.RollingUpdate, &out.RollingUpdate
		*out = new(appsv1.RollingUpdateDeployment)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GoldmaneDeploymentStrategy.
func (in *GoldmaneDeploymentStrategy) DeepCopy() *GoldmaneDeploymentStrategy {
	if in == nil {
		return nil
	}
	out := new(GoldmaneDeploymentStrategy)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GoldmaneList) DeepCopyInto(out *GoldmaneList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Goldmane, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GoldmaneList.
func (in *GoldmaneList) DeepCopy() *GoldmaneList {
	if in == nil {
		return nil
	}
	out := new(GoldmaneList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *GoldmaneList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GoldmaneSpec) DeepCopyInto(out *GoldmaneSpec) {
	*out = *in
	if in.GoldmaneDeployment != nil {
		in, out := &in.GoldmaneDeployment, &out.GoldmaneDeployment
		*out = new(GoldmaneDeployment)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GoldmaneSpec.
func (in *GoldmaneSpec) DeepCopy() *GoldmaneSpec {
	if in == nil {
		return nil
	}
	out := new(GoldmaneSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GoldmaneStatus) DeepCopyInto(out *GoldmaneStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]metav1.Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GoldmaneStatus.
func (in *GoldmaneStatus) DeepCopy() *GoldmaneStatus {
	if in == nil {
		return nil
	}
	out := new(GoldmaneStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GroupSearch) DeepCopyInto(out *GroupSearch) {
	*out = *in
	if in.UserMatchers != nil {
		in, out := &in.UserMatchers, &out.UserMatchers
		*out = make([]UserMatch, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GroupSearch.
func (in *GroupSearch) DeepCopy() *GroupSearch {
	if in == nil {
		return nil
	}
	out := new(GroupSearch)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GuardianDeployment) DeepCopyInto(out *GuardianDeployment) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(GuardianDeploymentSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GuardianDeployment.
func (in *GuardianDeployment) DeepCopy() *GuardianDeployment {
	if in == nil {
		return nil
	}
	out := new(GuardianDeployment)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GuardianDeploymentContainer) DeepCopyInto(out *GuardianDeploymentContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GuardianDeploymentContainer.
func (in *GuardianDeploymentContainer) DeepCopy() *GuardianDeploymentContainer {
	if in == nil {
		return nil
	}
	out := new(GuardianDeploymentContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GuardianDeploymentInitContainer) DeepCopyInto(out *GuardianDeploymentInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GuardianDeploymentInitContainer.
func (in *GuardianDeploymentInitContainer) DeepCopy() *GuardianDeploymentInitContainer {
	if in == nil {
		return nil
	}
	out := new(GuardianDeploymentInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GuardianDeploymentPodSpec) DeepCopyInto(out *GuardianDeploymentPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]GuardianDeploymentInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]GuardianDeploymentContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GuardianDeploymentPodSpec.
func (in *GuardianDeploymentPodSpec) DeepCopy() *GuardianDeploymentPodSpec {
	if in == nil {
		return nil
	}
	out := new(GuardianDeploymentPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GuardianDeploymentPodTemplateSpec) DeepCopyInto(out *GuardianDeploymentPodTemplateSpec) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(GuardianDeploymentPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GuardianDeploymentPodTemplateSpec.
func (in *GuardianDeploymentPodTemplateSpec) DeepCopy() *GuardianDeploymentPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(GuardianDeploymentPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GuardianDeploymentSpec) DeepCopyInto(out *GuardianDeploymentSpec) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(GuardianDeploymentPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GuardianDeploymentSpec.
func (in *GuardianDeploymentSpec) DeepCopy() *GuardianDeploymentSpec {
	if in == nil {
		return nil
	}
	out := new(GuardianDeploymentSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HTTPProbe) DeepCopyInto(out *HTTPProbe) {
	*out = *in
	if in.URLs != nil {
		in, out := &in.URLs, &out.URLs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.IntervalSeconds != nil {
		in, out := &in.IntervalSeconds, &out.IntervalSeconds
		*out = new(int32)
		**out = **in
	}
	if in.TimeoutSeconds != nil {
		in, out := &in.TimeoutSeconds, &out.TimeoutSeconds
		*out = new(int32)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HTTPProbe.
func (in *HTTPProbe) DeepCopy() *HTTPProbe {
	if in == nil {
		return nil
	}
	out := new(HTTPProbe)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ICMPProbe) DeepCopyInto(out *ICMPProbe) {
	*out = *in
	if in.IPs != nil {
		in, out := &in.IPs, &out.IPs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.IntervalSeconds != nil {
		in, out := &in.IntervalSeconds, &out.IntervalSeconds
		*out = new(int32)
		**out = **in
	}
	if in.TimeoutSeconds != nil {
		in, out := &in.TimeoutSeconds, &out.TimeoutSeconds
		*out = new(int32)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ICMPProbe.
func (in *ICMPProbe) DeepCopy() *ICMPProbe {
	if in == nil {
		return nil
	}
	out := new(ICMPProbe)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IPAMSpec) DeepCopyInto(out *IPAMSpec) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IPAMSpec.
func (in *IPAMSpec) DeepCopy() *IPAMSpec {
	if in == nil {
		return nil
	}
	out := new(IPAMSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IPPool) DeepCopyInto(out *IPPool) {
	*out = *in
	if in.BlockSize != nil {
		in, out := &in.BlockSize, &out.BlockSize
		*out = new(int32)
		**out = **in
	}
	if in.DisableBGPExport != nil {
		in, out := &in.DisableBGPExport, &out.DisableBGPExport
		*out = new(bool)
		**out = **in
	}
	if in.DisableNewAllocations != nil {
		in, out := &in.DisableNewAllocations, &out.DisableNewAllocations
		*out = new(bool)
		**out = **in
	}
	if in.AllowedUses != nil {
		in, out := &in.AllowedUses, &out.AllowedUses
		*out = make([]IPPoolAllowedUse, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IPPool.
func (in *IPPool) DeepCopy() *IPPool {
	if in == nil {
		return nil
	}
	out := new(IPPool)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Image) DeepCopyInto(out *Image) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Image.
func (in *Image) DeepCopy() *Image {
	if in == nil {
		return nil
	}
	out := new(Image)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ImageSet) DeepCopyInto(out *ImageSet) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ImageSet.
func (in *ImageSet) DeepCopy() *ImageSet {
	if in == nil {
		return nil
	}
	out := new(ImageSet)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ImageSet) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ImageSetList) DeepCopyInto(out *ImageSetList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ImageSet, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ImageSetList.
func (in *ImageSetList) DeepCopy() *ImageSetList {
	if in == nil {
		return nil
	}
	out := new(ImageSetList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ImageSetList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ImageSetSpec) DeepCopyInto(out *ImageSetSpec) {
	*out = *in
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]Image, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ImageSetSpec.
func (in *ImageSetSpec) DeepCopy() *ImageSetSpec {
	if in == nil {
		return nil
	}
	out := new(ImageSetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Index) DeepCopyInto(out *Index) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Index.
func (in *Index) DeepCopy() *Index {
	if in == nil {
		return nil
	}
	out := new(Index)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Indices) DeepCopyInto(out *Indices) {
	*out = *in
	if in.Replicas != nil {
		in, out := &in.Replicas, &out.Replicas
		*out = new(int32)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Indices.
func (in *Indices) DeepCopy() *Indices {
	if in == nil {
		return nil
	}
	out := new(Indices)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Installation) DeepCopyInto(out *Installation) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Installation.
func (in *Installation) DeepCopy() *Installation {
	if in == nil {
		return nil
	}
	out := new(Installation)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *Installation) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InstallationList) DeepCopyInto(out *InstallationList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Installation, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InstallationList.
func (in *InstallationList) DeepCopy() *InstallationList {
	if in == nil {
		return nil
	}
	out := new(InstallationList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *InstallationList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InstallationSpec) DeepCopyInto(out *InstallationSpec) {
	*out = *in
	if in.ImagePullSecrets != nil {
		in, out := &in.ImagePullSecrets, &out.ImagePullSecrets
		*out = make([]corev1.LocalObjectReference, len(*in))
		copy(*out, *in)
	}
	if in.CNI != nil {
		in, out := &in.CNI, &out.CNI
		*out = new(CNISpec)
		(*in).DeepCopyInto(*out)
	}
	if in.CalicoNetwork != nil {
		in, out := &in.CalicoNetwork, &out.CalicoNetwork
		*out = new(CalicoNetworkSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.TyphaAffinity != nil {
		in, out := &in.TyphaAffinity, &out.TyphaAffinity
		*out = new(TyphaAffinity)
		(*in).DeepCopyInto(*out)
	}
	if in.ControlPlaneNodeSelector != nil {
		in, out := &in.ControlPlaneNodeSelector, &out.ControlPlaneNodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.ControlPlaneTolerations != nil {
		in, out := &in.ControlPlaneTolerations, &out.ControlPlaneTolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.ControlPlaneReplicas != nil {
		in, out := &in.ControlPlaneReplicas, &out.ControlPlaneReplicas
		*out = new(int32)
		**out = **in
	}
	if in.NodeMetricsPort != nil {
		in, out := &in.NodeMetricsPort, &out.NodeMetricsPort
		*out = new(int32)
		**out = **in
	}
	if in.TyphaMetricsPort != nil {
		in, out := &in.TyphaMetricsPort, &out.TyphaMetricsPort
		*out = new(int32)
		**out = **in
	}
	in.NodeUpdateStrategy.DeepCopyInto(&out.NodeUpdateStrategy)
	if in.ComponentResources != nil {
		in, out := &in.ComponentResources, &out.ComponentResources
		*out = make([]ComponentResource, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.CertificateManagement != nil {
		in, out := &in.CertificateManagement, &out.CertificateManagement
		*out = new(CertificateManagement)
		(*in).DeepCopyInto(*out)
	}
	if in.TLSCipherSuites != nil {
		in, out := &in.TLSCipherSuites, &out.TLSCipherSuites
		*out = make(TLSCipherSuites, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.NonPrivileged != nil {
		in, out := &in.NonPrivileged, &out.NonPrivileged
		*out = new(NonPrivilegedType)
		**out = **in
	}
	if in.CalicoNodeDaemonSet != nil {
		in, out := &in.CalicoNodeDaemonSet, &out.CalicoNodeDaemonSet
		*out = new(CalicoNodeDaemonSet)
		(*in).DeepCopyInto(*out)
	}
	if in.CSINodeDriverDaemonSet != nil {
		in, out := &in.CSINodeDriverDaemonSet, &out.CSINodeDriverDaemonSet
		*out = new(CSINodeDriverDaemonSet)
		(*in).DeepCopyInto(*out)
	}
	if in.CalicoKubeControllersDeployment != nil {
		in, out := &in.CalicoKubeControllersDeployment, &out.CalicoKubeControllersDeployment
		*out = new(CalicoKubeControllersDeployment)
		(*in).DeepCopyInto(*out)
	}
	if in.TyphaDeployment != nil {
		in, out := &in.TyphaDeployment, &out.TyphaDeployment
		*out = new(TyphaDeployment)
		(*in).DeepCopyInto(*out)
	}
	if in.CalicoWindowsUpgradeDaemonSet != nil {
		in, out := &in.CalicoWindowsUpgradeDaemonSet, &out.CalicoWindowsUpgradeDaemonSet
		*out = new(CalicoWindowsUpgradeDaemonSet)
		(*in).DeepCopyInto(*out)
	}
	if in.CalicoNodeWindowsDaemonSet != nil {
		in, out := &in.CalicoNodeWindowsDaemonSet, &out.CalicoNodeWindowsDaemonSet
		*out = new(CalicoNodeWindowsDaemonSet)
		(*in).DeepCopyInto(*out)
	}
	if in.FIPSMode != nil {
		in, out := &in.FIPSMode, &out.FIPSMode
		*out = new(FIPSMode)
		**out = **in
	}
	if in.Logging != nil {
		in, out := &in.Logging, &out.Logging
		*out = new(Logging)
		(*in).DeepCopyInto(*out)
	}
	if in.WindowsNodes != nil {
		in, out := &in.WindowsNodes, &out.WindowsNodes
		*out = new(WindowsNodeSpec)
		**out = **in
	}
	if in.ServiceCIDRs != nil {
		in, out := &in.ServiceCIDRs, &out.ServiceCIDRs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Azure != nil {
		in, out := &in.Azure, &out.Azure
		*out = new(Azure)
		(*in).DeepCopyInto(*out)
	}
	if in.Proxy != nil {
		in, out := &in.Proxy, &out.Proxy
		*out = new(Proxy)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InstallationSpec.
func (in *InstallationSpec) DeepCopy() *InstallationSpec {
	if in == nil {
		return nil
	}
	out := new(InstallationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InstallationStatus) DeepCopyInto(out *InstallationStatus) {
	*out = *in
	if in.Computed != nil {
		in, out := &in.Computed, &out.Computed
		*out = new(InstallationSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]metav1.Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InstallationStatus.
func (in *InstallationStatus) DeepCopy() *InstallationStatus {
	if in == nil {
		return nil
	}
	out := new(InstallationStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IntrusionDetection) DeepCopyInto(out *IntrusionDetection) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IntrusionDetection.
func (in *IntrusionDetection) DeepCopy() *IntrusionDetection {
	if in == nil {
		return nil
	}
	out := new(IntrusionDetection)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IntrusionDetection) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IntrusionDetectionComponentResource) DeepCopyInto(out *IntrusionDetectionComponentResource) {
	*out = *in
	if in.ResourceRequirements != nil {
		in, out := &in.ResourceRequirements, &out.ResourceRequirements
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IntrusionDetectionComponentResource.
func (in *IntrusionDetectionComponentResource) DeepCopy() *IntrusionDetectionComponentResource {
	if in == nil {
		return nil
	}
	out := new(IntrusionDetectionComponentResource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IntrusionDetectionControllerDeployment) DeepCopyInto(out *IntrusionDetectionControllerDeployment) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(IntrusionDetectionControllerDeploymentSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IntrusionDetectionControllerDeployment.
func (in *IntrusionDetectionControllerDeployment) DeepCopy() *IntrusionDetectionControllerDeployment {
	if in == nil {
		return nil
	}
	out := new(IntrusionDetectionControllerDeployment)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IntrusionDetectionControllerDeploymentContainer) DeepCopyInto(out *IntrusionDetectionControllerDeploymentContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IntrusionDetectionControllerDeploymentContainer.
func (in *IntrusionDetectionControllerDeploymentContainer) DeepCopy() *IntrusionDetectionControllerDeploymentContainer {
	if in == nil {
		return nil
	}
	out := new(IntrusionDetectionControllerDeploymentContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IntrusionDetectionControllerDeploymentInitContainer) DeepCopyInto(out *IntrusionDetectionControllerDeploymentInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IntrusionDetectionControllerDeploymentInitContainer.
func (in *IntrusionDetectionControllerDeploymentInitContainer) DeepCopy() *IntrusionDetectionControllerDeploymentInitContainer {
	if in == nil {
		return nil
	}
	out := new(IntrusionDetectionControllerDeploymentInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IntrusionDetectionControllerDeploymentPodSpec) DeepCopyInto(out *IntrusionDetectionControllerDeploymentPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]IntrusionDetectionControllerDeploymentInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]IntrusionDetectionControllerDeploymentContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IntrusionDetectionControllerDeploymentPodSpec.
func (in *IntrusionDetectionControllerDeploymentPodSpec) DeepCopy() *IntrusionDetectionControllerDeploymentPodSpec {
	if in == nil {
		return nil
	}
	out := new(IntrusionDetectionControllerDeploymentPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IntrusionDetectionControllerDeploymentPodTemplateSpec) DeepCopyInto(out *IntrusionDetectionControllerDeploymentPodTemplateSpec) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(IntrusionDetectionControllerDeploymentPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IntrusionDetectionControllerDeploymentPodTemplateSpec.
func (in *IntrusionDetectionControllerDeploymentPodTemplateSpec) DeepCopy() *IntrusionDetectionControllerDeploymentPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(IntrusionDetectionControllerDeploymentPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IntrusionDetectionControllerDeploymentSpec) DeepCopyInto(out *IntrusionDetectionControllerDeploymentSpec) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(IntrusionDetectionControllerDeploymentPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IntrusionDetectionControllerDeploymentSpec.
func (in *IntrusionDetectionControllerDeploymentSpec) DeepCopy() *IntrusionDetectionControllerDeploymentSpec {
	if in == nil {
		return nil
	}
	out := new(IntrusionDetectionControllerDeploymentSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IntrusionDetectionList) DeepCopyInto(out *IntrusionDetectionList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IntrusionDetection, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IntrusionDetectionList.
func (in *IntrusionDetectionList) DeepCopy() *IntrusionDetectionList {
	if in == nil {
		return nil
	}
	out := new(IntrusionDetectionList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IntrusionDetectionList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IntrusionDetectionSpec) DeepCopyInto(out *IntrusionDetectionSpec) {
	*out = *in
	if in.ComponentResources != nil {
		in, out := &in.ComponentResources, &out.ComponentResources
		*out = make([]IntrusionDetectionComponentResource, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	out.AnomalyDetection = in.AnomalyDetection
	if in.IntrusionDetectionControllerDeployment != nil {
		in, out := &in.IntrusionDetectionControllerDeployment, &out.IntrusionDetectionControllerDeployment
		*out = new(IntrusionDetectionControllerDeployment)
		(*in).DeepCopyInto(*out)
	}
	if in.DeepPacketInspectionDaemonset != nil {
		in, out := &in.DeepPacketInspectionDaemonset, &out.DeepPacketInspectionDaemonset
		*out = new(DeepPacketInspectionDaemonset)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IntrusionDetectionSpec.
func (in *IntrusionDetectionSpec) DeepCopy() *IntrusionDetectionSpec {
	if in == nil {
		return nil
	}
	out := new(IntrusionDetectionSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IntrusionDetectionStatus) DeepCopyInto(out *IntrusionDetectionStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]metav1.Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IntrusionDetectionStatus.
func (in *IntrusionDetectionStatus) DeepCopy() *IntrusionDetectionStatus {
	if in == nil {
		return nil
	}
	out := new(IntrusionDetectionStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Kibana) DeepCopyInto(out *Kibana) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(KibanaSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Kibana.
func (in *Kibana) DeepCopy() *Kibana {
	if in == nil {
		return nil
	}
	out := new(Kibana)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KibanaContainer) DeepCopyInto(out *KibanaContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KibanaContainer.
func (in *KibanaContainer) DeepCopy() *KibanaContainer {
	if in == nil {
		return nil
	}
	out := new(KibanaContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KibanaInitContainer) DeepCopyInto(out *KibanaInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KibanaInitContainer.
func (in *KibanaInitContainer) DeepCopy() *KibanaInitContainer {
	if in == nil {
		return nil
	}
	out := new(KibanaInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KibanaPodSpec) DeepCopyInto(out *KibanaPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]KibanaInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]KibanaContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KibanaPodSpec.
func (in *KibanaPodSpec) DeepCopy() *KibanaPodSpec {
	if in == nil {
		return nil
	}
	out := new(KibanaPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KibanaPodTemplateSpec) DeepCopyInto(out *KibanaPodTemplateSpec) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(KibanaPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KibanaPodTemplateSpec.
func (in *KibanaPodTemplateSpec) DeepCopy() *KibanaPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(KibanaPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KibanaSpec) DeepCopyInto(out *KibanaSpec) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(KibanaPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KibanaSpec.
func (in *KibanaSpec) DeepCopy() *KibanaSpec {
	if in == nil {
		return nil
	}
	out := new(KibanaSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *L7LogCollectorDaemonSet) DeepCopyInto(out *L7LogCollectorDaemonSet) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(L7LogCollectorDaemonSetSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new L7LogCollectorDaemonSet.
func (in *L7LogCollectorDaemonSet) DeepCopy() *L7LogCollectorDaemonSet {
	if in == nil {
		return nil
	}
	out := new(L7LogCollectorDaemonSet)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *L7LogCollectorDaemonSetContainer) DeepCopyInto(out *L7LogCollectorDaemonSetContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new L7LogCollectorDaemonSetContainer.
func (in *L7LogCollectorDaemonSetContainer) DeepCopy() *L7LogCollectorDaemonSetContainer {
	if in == nil {
		return nil
	}
	out := new(L7LogCollectorDaemonSetContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *L7LogCollectorDaemonSetInitContainer) DeepCopyInto(out *L7LogCollectorDaemonSetInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new L7LogCollectorDaemonSetInitContainer.
func (in *L7LogCollectorDaemonSetInitContainer) DeepCopy() *L7LogCollectorDaemonSetInitContainer {
	if in == nil {
		return nil
	}
	out := new(L7LogCollectorDaemonSetInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *L7LogCollectorDaemonSetPodSpec) DeepCopyInto(out *L7LogCollectorDaemonSetPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]L7LogCollectorDaemonSetInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]L7LogCollectorDaemonSetContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new L7LogCollectorDaemonSetPodSpec.
func (in *L7LogCollectorDaemonSetPodSpec) DeepCopy() *L7LogCollectorDaemonSetPodSpec {
	if in == nil {
		return nil
	}
	out := new(L7LogCollectorDaemonSetPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *L7LogCollectorDaemonSetPodTemplateSpec) DeepCopyInto(out *L7LogCollectorDaemonSetPodTemplateSpec) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(L7LogCollectorDaemonSetPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new L7LogCollectorDaemonSetPodTemplateSpec.
func (in *L7LogCollectorDaemonSetPodTemplateSpec) DeepCopy() *L7LogCollectorDaemonSetPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(L7LogCollectorDaemonSetPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *L7LogCollectorDaemonSetSpec) DeepCopyInto(out *L7LogCollectorDaemonSetSpec) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(L7LogCollectorDaemonSetPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new L7LogCollectorDaemonSetSpec.
func (in *L7LogCollectorDaemonSetSpec) DeepCopy() *L7LogCollectorDaemonSetSpec {
	if in == nil {
		return nil
	}
	out := new(L7LogCollectorDaemonSetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LinseedDeployment) DeepCopyInto(out *LinseedDeployment) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(LinseedDeploymentSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LinseedDeployment.
func (in *LinseedDeployment) DeepCopy() *LinseedDeployment {
	if in == nil {
		return nil
	}
	out := new(LinseedDeployment)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LinseedDeploymentContainer) DeepCopyInto(out *LinseedDeploymentContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LinseedDeploymentContainer.
func (in *LinseedDeploymentContainer) DeepCopy() *LinseedDeploymentContainer {
	if in == nil {
		return nil
	}
	out := new(LinseedDeploymentContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LinseedDeploymentInitContainer) DeepCopyInto(out *LinseedDeploymentInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LinseedDeploymentInitContainer.
func (in *LinseedDeploymentInitContainer) DeepCopy() *LinseedDeploymentInitContainer {
	if in == nil {
		return nil
	}
	out := new(LinseedDeploymentInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LinseedDeploymentPodSpec) DeepCopyInto(out *LinseedDeploymentPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]LinseedDeploymentInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]LinseedDeploymentContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LinseedDeploymentPodSpec.
func (in *LinseedDeploymentPodSpec) DeepCopy() *LinseedDeploymentPodSpec {
	if in == nil {
		return nil
	}
	out := new(LinseedDeploymentPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LinseedDeploymentPodTemplateSpec) DeepCopyInto(out *LinseedDeploymentPodTemplateSpec) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(LinseedDeploymentPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LinseedDeploymentPodTemplateSpec.
func (in *LinseedDeploymentPodTemplateSpec) DeepCopy() *LinseedDeploymentPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(LinseedDeploymentPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LinseedDeploymentSpec) DeepCopyInto(out *LinseedDeploymentSpec) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(LinseedDeploymentPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LinseedDeploymentSpec.
func (in *LinseedDeploymentSpec) DeepCopy() *LinseedDeploymentSpec {
	if in == nil {
		return nil
	}
	out := new(LinseedDeploymentSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LogCollectionSpec) DeepCopyInto(out *LogCollectionSpec) {
	*out = *in
	if in.CollectLogs != nil {
		in, out := &in.CollectLogs, &out.CollectLogs
		*out = new(LogCollectionStatusType)
		**out = **in
	}
	if in.LogIntervalSeconds != nil {
		in, out := &in.LogIntervalSeconds, &out.LogIntervalSeconds
		*out = new(int64)
		**out = **in
	}
	if in.LogRequestsPerInterval != nil {
		in, out := &in.LogRequestsPerInterval, &out.LogRequestsPerInterval
		*out = new(int64)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LogCollectionSpec.
func (in *LogCollectionSpec) DeepCopy() *LogCollectionSpec {
	if in == nil {
		return nil
	}
	out := new(LogCollectionSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LogCollector) DeepCopyInto(out *LogCollector) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LogCollector.
func (in *LogCollector) DeepCopy() *LogCollector {
	if in == nil {
		return nil
	}
	out := new(LogCollector)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *LogCollector) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LogCollectorList) DeepCopyInto(out *LogCollectorList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]LogCollector, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LogCollectorList.
func (in *LogCollectorList) DeepCopy() *LogCollectorList {
	if in == nil {
		return nil
	}
	out := new(LogCollectorList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *LogCollectorList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LogCollectorSpec) DeepCopyInto(out *LogCollectorSpec) {
	*out = *in
	if in.AdditionalStores != nil {
		in, out := &in.AdditionalStores, &out.AdditionalStores
		*out = new(AdditionalLogStoreSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.AdditionalSources != nil {
		in, out := &in.AdditionalSources, &out.AdditionalSources
		*out = new(AdditionalLogSourceSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.CollectProcessPath != nil {
		in, out := &in.CollectProcessPath, &out.CollectProcessPath
		*out = new(CollectProcessPathOption)
		**out = **in
	}
	if in.FluentdDaemonSet != nil {
		in, out := &in.FluentdDaemonSet, &out.FluentdDaemonSet
		*out = new(FluentdDaemonSet)
		(*in).DeepCopyInto(*out)
	}
	if in.EKSLogForwarderDeployment != nil {
		in, out := &in.EKSLogForwarderDeployment, &out.EKSLogForwarderDeployment
		*out = new(EKSLogForwarderDeployment)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LogCollectorSpec.
func (in *LogCollectorSpec) DeepCopy() *LogCollectorSpec {
	if in == nil {
		return nil
	}
	out := new(LogCollectorSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LogCollectorStatus) DeepCopyInto(out *LogCollectorStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]metav1.Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LogCollectorStatus.
func (in *LogCollectorStatus) DeepCopy() *LogCollectorStatus {
	if in == nil {
		return nil
	}
	out := new(LogCollectorStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LogStorage) DeepCopyInto(out *LogStorage) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LogStorage.
func (in *LogStorage) DeepCopy() *LogStorage {
	if in == nil {
		return nil
	}
	out := new(LogStorage)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *LogStorage) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LogStorageComponentResource) DeepCopyInto(out *LogStorageComponentResource) {
	*out = *in
	if in.ResourceRequirements != nil {
		in, out := &in.ResourceRequirements, &out.ResourceRequirements
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LogStorageComponentResource.
func (in *LogStorageComponentResource) DeepCopy() *LogStorageComponentResource {
	if in == nil {
		return nil
	}
	out := new(LogStorageComponentResource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LogStorageList) DeepCopyInto(out *LogStorageList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]LogStorage, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LogStorageList.
func (in *LogStorageList) DeepCopy() *LogStorageList {
	if in == nil {
		return nil
	}
	out := new(LogStorageList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *LogStorageList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LogStorageSpec) DeepCopyInto(out *LogStorageSpec) {
	*out = *in
	if in.Nodes != nil {
		in, out := &in.Nodes, &out.Nodes
		*out = new(Nodes)
		(*in).DeepCopyInto(*out)
	}
	if in.Indices != nil {
		in, out := &in.Indices, &out.Indices
		*out = new(Indices)
		(*in).DeepCopyInto(*out)
	}
	if in.Retention != nil {
		in, out := &in.Retention, &out.Retention
		*out = new(Retention)
		(*in).DeepCopyInto(*out)
	}
	if in.DataNodeSelector != nil {
		in, out := &in.DataNodeSelector, &out.DataNodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.ComponentResources != nil {
		in, out := &in.ComponentResources, &out.ComponentResources
		*out = make([]LogStorageComponentResource, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.ECKOperatorStatefulSet != nil {
		in, out := &in.ECKOperatorStatefulSet, &out.ECKOperatorStatefulSet
		*out = new(ECKOperatorStatefulSet)
		(*in).DeepCopyInto(*out)
	}
	if in.Kibana != nil {
		in, out := &in.Kibana, &out.Kibana
		*out = new(Kibana)
		(*in).DeepCopyInto(*out)
	}
	if in.LinseedDeployment != nil {
		in, out := &in.LinseedDeployment, &out.LinseedDeployment
		*out = new(LinseedDeployment)
		(*in).DeepCopyInto(*out)
	}
	if in.ElasticsearchMetricsDeployment != nil {
		in, out := &in.ElasticsearchMetricsDeployment, &out.ElasticsearchMetricsDeployment
		*out = new(ElasticsearchMetricsDeployment)
		(*in).DeepCopyInto(*out)
	}
	if in.ESGatewayDeployment != nil {
		in, out := &in.ESGatewayDeployment, &out.ESGatewayDeployment
		*out = new(ESGatewayDeployment)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LogStorageSpec.
func (in *LogStorageSpec) DeepCopy() *LogStorageSpec {
	if in == nil {
		return nil
	}
	out := new(LogStorageSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LogStorageStatus) DeepCopyInto(out *LogStorageStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]metav1.Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LogStorageStatus.
func (in *LogStorageStatus) DeepCopy() *LogStorageStatus {
	if in == nil {
		return nil
	}
	out := new(LogStorageStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Logging) DeepCopyInto(out *Logging) {
	*out = *in
	if in.CNI != nil {
		in, out := &in.CNI, &out.CNI
		*out = new(CNILogging)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Logging.
func (in *Logging) DeepCopy() *Logging {
	if in == nil {
		return nil
	}
	out := new(Logging)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ManagementCluster) DeepCopyInto(out *ManagementCluster) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ManagementCluster.
func (in *ManagementCluster) DeepCopy() *ManagementCluster {
	if in == nil {
		return nil
	}
	out := new(ManagementCluster)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ManagementCluster) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ManagementClusterConnection) DeepCopyInto(out *ManagementClusterConnection) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ManagementClusterConnection.
func (in *ManagementClusterConnection) DeepCopy() *ManagementClusterConnection {
	if in == nil {
		return nil
	}
	out := new(ManagementClusterConnection)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ManagementClusterConnection) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ManagementClusterConnectionList) DeepCopyInto(out *ManagementClusterConnectionList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ManagementClusterConnection, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ManagementClusterConnectionList.
func (in *ManagementClusterConnectionList) DeepCopy() *ManagementClusterConnectionList {
	if in == nil {
		return nil
	}
	out := new(ManagementClusterConnectionList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ManagementClusterConnectionList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ManagementClusterConnectionSpec) DeepCopyInto(out *ManagementClusterConnectionSpec) {
	*out = *in
	if in.TLS != nil {
		in, out := &in.TLS, &out.TLS
		*out = new(ManagementClusterTLS)
		**out = **in
	}
	if in.GuardianDeployment != nil {
		in, out := &in.GuardianDeployment, &out.GuardianDeployment
		*out = new(GuardianDeployment)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ManagementClusterConnectionSpec.
func (in *ManagementClusterConnectionSpec) DeepCopy() *ManagementClusterConnectionSpec {
	if in == nil {
		return nil
	}
	out := new(ManagementClusterConnectionSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ManagementClusterConnectionStatus) DeepCopyInto(out *ManagementClusterConnectionStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]metav1.Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ManagementClusterConnectionStatus.
func (in *ManagementClusterConnectionStatus) DeepCopy() *ManagementClusterConnectionStatus {
	if in == nil {
		return nil
	}
	out := new(ManagementClusterConnectionStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ManagementClusterList) DeepCopyInto(out *ManagementClusterList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ManagementCluster, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ManagementClusterList.
func (in *ManagementClusterList) DeepCopy() *ManagementClusterList {
	if in == nil {
		return nil
	}
	out := new(ManagementClusterList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ManagementClusterList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ManagementClusterSpec) DeepCopyInto(out *ManagementClusterSpec) {
	*out = *in
	if in.TLS != nil {
		in, out := &in.TLS, &out.TLS
		*out = new(TLS)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ManagementClusterSpec.
func (in *ManagementClusterSpec) DeepCopy() *ManagementClusterSpec {
	if in == nil {
		return nil
	}
	out := new(ManagementClusterSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ManagementClusterTLS) DeepCopyInto(out *ManagementClusterTLS) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ManagementClusterTLS.
func (in *ManagementClusterTLS) DeepCopy() *ManagementClusterTLS {
	if in == nil {
		return nil
	}
	out := new(ManagementClusterTLS)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Manager) DeepCopyInto(out *Manager) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Manager.
func (in *Manager) DeepCopy() *Manager {
	if in == nil {
		return nil
	}
	out := new(Manager)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *Manager) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ManagerDeployment) DeepCopyInto(out *ManagerDeployment) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(ManagerDeploymentSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ManagerDeployment.
func (in *ManagerDeployment) DeepCopy() *ManagerDeployment {
	if in == nil {
		return nil
	}
	out := new(ManagerDeployment)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ManagerDeploymentContainer) DeepCopyInto(out *ManagerDeploymentContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ManagerDeploymentContainer.
func (in *ManagerDeploymentContainer) DeepCopy() *ManagerDeploymentContainer {
	if in == nil {
		return nil
	}
	out := new(ManagerDeploymentContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ManagerDeploymentInitContainer) DeepCopyInto(out *ManagerDeploymentInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ManagerDeploymentInitContainer.
func (in *ManagerDeploymentInitContainer) DeepCopy() *ManagerDeploymentInitContainer {
	if in == nil {
		return nil
	}
	out := new(ManagerDeploymentInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ManagerDeploymentPodSpec) DeepCopyInto(out *ManagerDeploymentPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]ManagerDeploymentInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]ManagerDeploymentContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ManagerDeploymentPodSpec.
func (in *ManagerDeploymentPodSpec) DeepCopy() *ManagerDeploymentPodSpec {
	if in == nil {
		return nil
	}
	out := new(ManagerDeploymentPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ManagerDeploymentPodTemplateSpec) DeepCopyInto(out *ManagerDeploymentPodTemplateSpec) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(ManagerDeploymentPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ManagerDeploymentPodTemplateSpec.
func (in *ManagerDeploymentPodTemplateSpec) DeepCopy() *ManagerDeploymentPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(ManagerDeploymentPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ManagerDeploymentSpec) DeepCopyInto(out *ManagerDeploymentSpec) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(ManagerDeploymentPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ManagerDeploymentSpec.
func (in *ManagerDeploymentSpec) DeepCopy() *ManagerDeploymentSpec {
	if in == nil {
		return nil
	}
	out := new(ManagerDeploymentSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ManagerList) DeepCopyInto(out *ManagerList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Manager, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ManagerList.
func (in *ManagerList) DeepCopy() *ManagerList {
	if in == nil {
		return nil
	}
	out := new(ManagerList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ManagerList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ManagerSpec) DeepCopyInto(out *ManagerSpec) {
	*out = *in
	if in.ManagerDeployment != nil {
		in, out := &in.ManagerDeployment, &out.ManagerDeployment
		*out = new(ManagerDeployment)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ManagerSpec.
func (in *ManagerSpec) DeepCopy() *ManagerSpec {
	if in == nil {
		return nil
	}
	out := new(ManagerSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ManagerStatus) DeepCopyInto(out *ManagerStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]metav1.Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ManagerStatus.
func (in *ManagerStatus) DeepCopy() *ManagerStatus {
	if in == nil {
		return nil
	}
	out := new(ManagerStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Metadata) DeepCopyInto(out *Metadata) {
	*out = *in
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Annotations != nil {
		in, out := &in.Annotations, &out.Annotations
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Metadata.
func (in *Metadata) DeepCopy() *Metadata {
	if in == nil {
		return nil
	}
	out := new(Metadata)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Monitor) DeepCopyInto(out *Monitor) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Monitor.
func (in *Monitor) DeepCopy() *Monitor {
	if in == nil {
		return nil
	}
	out := new(Monitor)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *Monitor) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MonitorList) DeepCopyInto(out *MonitorList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Monitor, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MonitorList.
func (in *MonitorList) DeepCopy() *MonitorList {
	if in == nil {
		return nil
	}
	out := new(MonitorList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *MonitorList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MonitorSpec) DeepCopyInto(out *MonitorSpec) {
	*out = *in
	if in.ExternalPrometheus != nil {
		in, out := &in.ExternalPrometheus, &out.ExternalPrometheus
		*out = new(ExternalPrometheus)
		(*in).DeepCopyInto(*out)
	}
	if in.Prometheus != nil {
		in, out := &in.Prometheus, &out.Prometheus
		*out = new(Prometheus)
		(*in).DeepCopyInto(*out)
	}
	if in.AlertManager != nil {
		in, out := &in.AlertManager, &out.AlertManager
		*out = new(AlertManager)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MonitorSpec.
func (in *MonitorSpec) DeepCopy() *MonitorSpec {
	if in == nil {
		return nil
	}
	out := new(MonitorSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MonitorStatus) DeepCopyInto(out *MonitorStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]metav1.Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MonitorStatus.
func (in *MonitorStatus) DeepCopy() *MonitorStatus {
	if in == nil {
		return nil
	}
	out := new(MonitorStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NamespacedName) DeepCopyInto(out *NamespacedName) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NamespacedName.
func (in *NamespacedName) DeepCopy() *NamespacedName {
	if in == nil {
		return nil
	}
	out := new(NamespacedName)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NodeAddressAutodetection) DeepCopyInto(out *NodeAddressAutodetection) {
	*out = *in
	if in.FirstFound != nil {
		in, out := &in.FirstFound, &out.FirstFound
		*out = new(bool)
		**out = **in
	}
	if in.Kubernetes != nil {
		in, out := &in.Kubernetes, &out.Kubernetes
		*out = new(KubernetesAutodetectionMethod)
		**out = **in
	}
	if in.CIDRS != nil {
		in, out := &in.CIDRS, &out.CIDRS
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NodeAddressAutodetection.
func (in *NodeAddressAutodetection) DeepCopy() *NodeAddressAutodetection {
	if in == nil {
		return nil
	}
	out := new(NodeAddressAutodetection)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NodeAffinity) DeepCopyInto(out *NodeAffinity) {
	*out = *in
	if in.PreferredDuringSchedulingIgnoredDuringExecution != nil {
		in, out := &in.PreferredDuringSchedulingIgnoredDuringExecution, &out.PreferredDuringSchedulingIgnoredDuringExecution
		*out = make([]corev1.PreferredSchedulingTerm, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.RequiredDuringSchedulingIgnoredDuringExecution != nil {
		in, out := &in.RequiredDuringSchedulingIgnoredDuringExecution, &out.RequiredDuringSchedulingIgnoredDuringExecution
		*out = new(corev1.NodeSelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NodeAffinity.
func (in *NodeAffinity) DeepCopy() *NodeAffinity {
	if in == nil {
		return nil
	}
	out := new(NodeAffinity)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NodeSet) DeepCopyInto(out *NodeSet) {
	*out = *in
	if in.SelectionAttributes != nil {
		in, out := &in.SelectionAttributes, &out.SelectionAttributes
		*out = make([]NodeSetSelectionAttribute, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NodeSet.
func (in *NodeSet) DeepCopy() *NodeSet {
	if in == nil {
		return nil
	}
	out := new(NodeSet)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NodeSetSelectionAttribute) DeepCopyInto(out *NodeSetSelectionAttribute) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NodeSetSelectionAttribute.
func (in *NodeSetSelectionAttribute) DeepCopy() *NodeSetSelectionAttribute {
	if in == nil {
		return nil
	}
	out := new(NodeSetSelectionAttribute)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Nodes) DeepCopyInto(out *Nodes) {
	*out = *in
	if in.NodeSets != nil {
		in, out := &in.NodeSets, &out.NodeSets
		*out = make([]NodeSet, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.ResourceRequirements != nil {
		in, out := &in.ResourceRequirements, &out.ResourceRequirements
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Nodes.
func (in *Nodes) DeepCopy() *Nodes {
	if in == nil {
		return nil
	}
	out := new(Nodes)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NonClusterHost) DeepCopyInto(out *NonClusterHost) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NonClusterHost.
func (in *NonClusterHost) DeepCopy() *NonClusterHost {
	if in == nil {
		return nil
	}
	out := new(NonClusterHost)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *NonClusterHost) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NonClusterHostList) DeepCopyInto(out *NonClusterHostList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]NonClusterHost, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NonClusterHostList.
func (in *NonClusterHostList) DeepCopy() *NonClusterHostList {
	if in == nil {
		return nil
	}
	out := new(NonClusterHostList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *NonClusterHostList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NonClusterHostSpec) DeepCopyInto(out *NonClusterHostSpec) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NonClusterHostSpec.
func (in *NonClusterHostSpec) DeepCopy() *NonClusterHostSpec {
	if in == nil {
		return nil
	}
	out := new(NonClusterHostSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PacketCaptureAPI) DeepCopyInto(out *PacketCaptureAPI) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PacketCaptureAPI.
func (in *PacketCaptureAPI) DeepCopy() *PacketCaptureAPI {
	if in == nil {
		return nil
	}
	out := new(PacketCaptureAPI)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *PacketCaptureAPI) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PacketCaptureAPIDeployment) DeepCopyInto(out *PacketCaptureAPIDeployment) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(PacketCaptureAPIDeploymentSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PacketCaptureAPIDeployment.
func (in *PacketCaptureAPIDeployment) DeepCopy() *PacketCaptureAPIDeployment {
	if in == nil {
		return nil
	}
	out := new(PacketCaptureAPIDeployment)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PacketCaptureAPIDeploymentContainer) DeepCopyInto(out *PacketCaptureAPIDeploymentContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PacketCaptureAPIDeploymentContainer.
func (in *PacketCaptureAPIDeploymentContainer) DeepCopy() *PacketCaptureAPIDeploymentContainer {
	if in == nil {
		return nil
	}
	out := new(PacketCaptureAPIDeploymentContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PacketCaptureAPIDeploymentInitContainer) DeepCopyInto(out *PacketCaptureAPIDeploymentInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PacketCaptureAPIDeploymentInitContainer.
func (in *PacketCaptureAPIDeploymentInitContainer) DeepCopy() *PacketCaptureAPIDeploymentInitContainer {
	if in == nil {
		return nil
	}
	out := new(PacketCaptureAPIDeploymentInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PacketCaptureAPIDeploymentPodSpec) DeepCopyInto(out *PacketCaptureAPIDeploymentPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]PacketCaptureAPIDeploymentInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]PacketCaptureAPIDeploymentContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PacketCaptureAPIDeploymentPodSpec.
func (in *PacketCaptureAPIDeploymentPodSpec) DeepCopy() *PacketCaptureAPIDeploymentPodSpec {
	if in == nil {
		return nil
	}
	out := new(PacketCaptureAPIDeploymentPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PacketCaptureAPIDeploymentPodTemplateSpec) DeepCopyInto(out *PacketCaptureAPIDeploymentPodTemplateSpec) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(PacketCaptureAPIDeploymentPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PacketCaptureAPIDeploymentPodTemplateSpec.
func (in *PacketCaptureAPIDeploymentPodTemplateSpec) DeepCopy() *PacketCaptureAPIDeploymentPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(PacketCaptureAPIDeploymentPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PacketCaptureAPIDeploymentSpec) DeepCopyInto(out *PacketCaptureAPIDeploymentSpec) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(PacketCaptureAPIDeploymentPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PacketCaptureAPIDeploymentSpec.
func (in *PacketCaptureAPIDeploymentSpec) DeepCopy() *PacketCaptureAPIDeploymentSpec {
	if in == nil {
		return nil
	}
	out := new(PacketCaptureAPIDeploymentSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PacketCaptureAPIList) DeepCopyInto(out *PacketCaptureAPIList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]PacketCaptureAPI, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PacketCaptureAPIList.
func (in *PacketCaptureAPIList) DeepCopy() *PacketCaptureAPIList {
	if in == nil {
		return nil
	}
	out := new(PacketCaptureAPIList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *PacketCaptureAPIList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PacketCaptureAPISpec) DeepCopyInto(out *PacketCaptureAPISpec) {
	*out = *in
	if in.PacketCaptureAPIDeployment != nil {
		in, out := &in.PacketCaptureAPIDeployment, &out.PacketCaptureAPIDeployment
		*out = new(PacketCaptureAPIDeployment)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PacketCaptureAPISpec.
func (in *PacketCaptureAPISpec) DeepCopy() *PacketCaptureAPISpec {
	if in == nil {
		return nil
	}
	out := new(PacketCaptureAPISpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PacketCaptureAPIStatus) DeepCopyInto(out *PacketCaptureAPIStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]metav1.Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PacketCaptureAPIStatus.
func (in *PacketCaptureAPIStatus) DeepCopy() *PacketCaptureAPIStatus {
	if in == nil {
		return nil
	}
	out := new(PacketCaptureAPIStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PathMatch) DeepCopyInto(out *PathMatch) {
	*out = *in
	if in.PathRegexp != nil {
		in, out := &in.PathRegexp, &out.PathRegexp
		*out = new(string)
		**out = **in
	}
	if in.PathReplace != nil {
		in, out := &in.PathReplace, &out.PathReplace
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PathMatch.
func (in *PathMatch) DeepCopy() *PathMatch {
	if in == nil {
		return nil
	}
	out := new(PathMatch)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PolicyRecommendation) DeepCopyInto(out *PolicyRecommendation) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	out.Status = in.Status
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PolicyRecommendation.
func (in *PolicyRecommendation) DeepCopy() *PolicyRecommendation {
	if in == nil {
		return nil
	}
	out := new(PolicyRecommendation)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *PolicyRecommendation) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PolicyRecommendationDeployment) DeepCopyInto(out *PolicyRecommendationDeployment) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(PolicyRecommendationDeploymentSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PolicyRecommendationDeployment.
func (in *PolicyRecommendationDeployment) DeepCopy() *PolicyRecommendationDeployment {
	if in == nil {
		return nil
	}
	out := new(PolicyRecommendationDeployment)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PolicyRecommendationDeploymentContainer) DeepCopyInto(out *PolicyRecommendationDeploymentContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PolicyRecommendationDeploymentContainer.
func (in *PolicyRecommendationDeploymentContainer) DeepCopy() *PolicyRecommendationDeploymentContainer {
	if in == nil {
		return nil
	}
	out := new(PolicyRecommendationDeploymentContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PolicyRecommendationDeploymentInitContainer) DeepCopyInto(out *PolicyRecommendationDeploymentInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PolicyRecommendationDeploymentInitContainer.
func (in *PolicyRecommendationDeploymentInitContainer) DeepCopy() *PolicyRecommendationDeploymentInitContainer {
	if in == nil {
		return nil
	}
	out := new(PolicyRecommendationDeploymentInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PolicyRecommendationDeploymentPodSpec) DeepCopyInto(out *PolicyRecommendationDeploymentPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]PolicyRecommendationDeploymentInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]PolicyRecommendationDeploymentContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PolicyRecommendationDeploymentPodSpec.
func (in *PolicyRecommendationDeploymentPodSpec) DeepCopy() *PolicyRecommendationDeploymentPodSpec {
	if in == nil {
		return nil
	}
	out := new(PolicyRecommendationDeploymentPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PolicyRecommendationDeploymentPodTemplateSpec) DeepCopyInto(out *PolicyRecommendationDeploymentPodTemplateSpec) {
	*out = *in
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(PolicyRecommendationDeploymentPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PolicyRecommendationDeploymentPodTemplateSpec.
func (in *PolicyRecommendationDeploymentPodTemplateSpec) DeepCopy() *PolicyRecommendationDeploymentPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(PolicyRecommendationDeploymentPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PolicyRecommendationDeploymentSpec) DeepCopyInto(out *PolicyRecommendationDeploymentSpec) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(PolicyRecommendationDeploymentPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PolicyRecommendationDeploymentSpec.
func (in *PolicyRecommendationDeploymentSpec) DeepCopy() *PolicyRecommendationDeploymentSpec {
	if in == nil {
		return nil
	}
	out := new(PolicyRecommendationDeploymentSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PolicyRecommendationList) DeepCopyInto(out *PolicyRecommendationList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]PolicyRecommendation, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PolicyRecommendationList.
func (in *PolicyRecommendationList) DeepCopy() *PolicyRecommendationList {
	if in == nil {
		return nil
	}
	out := new(PolicyRecommendationList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *PolicyRecommendationList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PolicyRecommendationSpec) DeepCopyInto(out *PolicyRecommendationSpec) {
	*out = *in
	if in.PolicyRecommendationDeployment != nil {
		in, out := &in.PolicyRecommendationDeployment, &out.PolicyRecommendationDeployment
		*out = new(PolicyRecommendationDeployment)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PolicyRecommendationSpec.
func (in *PolicyRecommendationSpec) DeepCopy() *PolicyRecommendationSpec {
	if in == nil {
		return nil
	}
	out := new(PolicyRecommendationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PolicyRecommendationStatus) DeepCopyInto(out *PolicyRecommendationStatus) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PolicyRecommendationStatus.
func (in *PolicyRecommendationStatus) DeepCopy() *PolicyRecommendationStatus {
	if in == nil {
		return nil
	}
	out := new(PolicyRecommendationStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Prometheus) DeepCopyInto(out *Prometheus) {
	*out = *in
	if in.PrometheusSpec != nil {
		in, out := &in.PrometheusSpec, &out.PrometheusSpec
		*out = new(PrometheusSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Prometheus.
func (in *Prometheus) DeepCopy() *Prometheus {
	if in == nil {
		return nil
	}
	out := new(Prometheus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PrometheusContainer) DeepCopyInto(out *PrometheusContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PrometheusContainer.
func (in *PrometheusContainer) DeepCopy() *PrometheusContainer {
	if in == nil {
		return nil
	}
	out := new(PrometheusContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PrometheusSpec) DeepCopyInto(out *PrometheusSpec) {
	*out = *in
	if in.CommonPrometheusFields != nil {
		in, out := &in.CommonPrometheusFields, &out.CommonPrometheusFields
		*out = new(CommonPrometheusFields)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PrometheusSpec.
func (in *PrometheusSpec) DeepCopy() *PrometheusSpec {
	if in == nil {
		return nil
	}
	out := new(PrometheusSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Proxy) DeepCopyInto(out *Proxy) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Proxy.
func (in *Proxy) DeepCopy() *Proxy {
	if in == nil {
		return nil
	}
	out := new(Proxy)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *QueryServerLogging) DeepCopyInto(out *QueryServerLogging) {
	*out = *in
	if in.LogSeverity != nil {
		in, out := &in.LogSeverity, &out.LogSeverity
		*out = new(LogSeverity)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new QueryServerLogging.
func (in *QueryServerLogging) DeepCopy() *QueryServerLogging {
	if in == nil {
		return nil
	}
	out := new(QueryServerLogging)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Retention) DeepCopyInto(out *Retention) {
	*out = *in
	if in.Flows != nil {
		in, out := &in.Flows, &out.Flows
		*out = new(int32)
		**out = **in
	}
	if in.AuditReports != nil {
		in, out := &in.AuditReports, &out.AuditReports
		*out = new(int32)
		**out = **in
	}
	if in.Snapshots != nil {
		in, out := &in.Snapshots, &out.Snapshots
		*out = new(int32)
		**out = **in
	}
	if in.ComplianceReports != nil {
		in, out := &in.ComplianceReports, &out.ComplianceReports
		*out = new(int32)
		**out = **in
	}
	if in.DNSLogs != nil {
		in, out := &in.DNSLogs, &out.DNSLogs
		*out = new(int32)
		**out = **in
	}
	if in.BGPLogs != nil {
		in, out := &in.BGPLogs, &out.BGPLogs
		*out = new(int32)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Retention.
func (in *Retention) DeepCopy() *Retention {
	if in == nil {
		return nil
	}
	out := new(Retention)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *S3StoreSpec) DeepCopyInto(out *S3StoreSpec) {
	*out = *in
	if in.HostScope != nil {
		in, out := &in.HostScope, &out.HostScope
		*out = new(HostScope)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new S3StoreSpec.
func (in *S3StoreSpec) DeepCopy() *S3StoreSpec {
	if in == nil {
		return nil
	}
	out := new(S3StoreSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SNIMatch) DeepCopyInto(out *SNIMatch) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SNIMatch.
func (in *SNIMatch) DeepCopy() *SNIMatch {
	if in == nil {
		return nil
	}
	out := new(SNIMatch)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ServiceMonitor) DeepCopyInto(out *ServiceMonitor) {
	*out = *in
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Endpoints != nil {
		in, out := &in.Endpoints, &out.Endpoints
		*out = make([]Endpoint, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ServiceMonitor.
func (in *ServiceMonitor) DeepCopy() *ServiceMonitor {
	if in == nil {
		return nil
	}
	out := new(ServiceMonitor)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SplunkStoreSpec) DeepCopyInto(out *SplunkStoreSpec) {
	*out = *in
	if in.HostScope != nil {
		in, out := &in.HostScope, &out.HostScope
		*out = new(HostScope)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SplunkStoreSpec.
func (in *SplunkStoreSpec) DeepCopy() *SplunkStoreSpec {
	if in == nil {
		return nil
	}
	out := new(SplunkStoreSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Sysctl) DeepCopyInto(out *Sysctl) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Sysctl.
func (in *Sysctl) DeepCopy() *Sysctl {
	if in == nil {
		return nil
	}
	out := new(Sysctl)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SyslogStoreSpec) DeepCopyInto(out *SyslogStoreSpec) {
	*out = *in
	if in.PacketSize != nil {
		in, out := &in.PacketSize, &out.PacketSize
		*out = new(int32)
		**out = **in
	}
	if in.LogTypes != nil {
		in, out := &in.LogTypes, &out.LogTypes
		*out = make([]SyslogLogType, len(*in))
		copy(*out, *in)
	}
	if in.HostScope != nil {
		in, out := &in.HostScope, &out.HostScope
		*out = new(HostScope)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SyslogStoreSpec.
func (in *SyslogStoreSpec) DeepCopy() *SyslogStoreSpec {
	if in == nil {
		return nil
	}
	out := new(SyslogStoreSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TLS) DeepCopyInto(out *TLS) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TLS.
func (in *TLS) DeepCopy() *TLS {
	if in == nil {
		return nil
	}
	out := new(TLS)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TLSCipherSuite) DeepCopyInto(out *TLSCipherSuite) {
	*out = *in
	if in.Name != nil {
		in, out := &in.Name, &out.Name
		*out = new(TLSCipher)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TLSCipherSuite.
func (in *TLSCipherSuite) DeepCopy() *TLSCipherSuite {
	if in == nil {
		return nil
	}
	out := new(TLSCipherSuite)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in TLSCipherSuites) DeepCopyInto(out *TLSCipherSuites) {
	{
		in := &in
		*out = make(TLSCipherSuites, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TLSCipherSuites.
func (in TLSCipherSuites) DeepCopy() TLSCipherSuites {
	if in == nil {
		return nil
	}
	out := new(TLSCipherSuites)
	in.DeepCopyInto(out)
	return *out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TLSPassThroughRoute) DeepCopyInto(out *TLSPassThroughRoute) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TLSPassThroughRoute.
func (in *TLSPassThroughRoute) DeepCopy() *TLSPassThroughRoute {
	if in == nil {
		return nil
	}
	out := new(TLSPassThroughRoute)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *TLSPassThroughRoute) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TLSPassThroughRouteList) DeepCopyInto(out *TLSPassThroughRouteList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]TLSPassThroughRoute, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TLSPassThroughRouteList.
func (in *TLSPassThroughRouteList) DeepCopy() *TLSPassThroughRouteList {
	if in == nil {
		return nil
	}
	out := new(TLSPassThroughRouteList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *TLSPassThroughRouteList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TLSPassThroughRouteSpec) DeepCopyInto(out *TLSPassThroughRouteSpec) {
	*out = *in
	if in.SNIMatch != nil {
		in, out := &in.SNIMatch, &out.SNIMatch
		*out = new(SNIMatch)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TLSPassThroughRouteSpec.
func (in *TLSPassThroughRouteSpec) DeepCopy() *TLSPassThroughRouteSpec {
	if in == nil {
		return nil
	}
	out := new(TLSPassThroughRouteSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TLSTerminatedRoute) DeepCopyInto(out *TLSTerminatedRoute) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TLSTerminatedRoute.
func (in *TLSTerminatedRoute) DeepCopy() *TLSTerminatedRoute {
	if in == nil {
		return nil
	}
	out := new(TLSTerminatedRoute)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *TLSTerminatedRoute) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TLSTerminatedRouteList) DeepCopyInto(out *TLSTerminatedRouteList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]TLSTerminatedRoute, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TLSTerminatedRouteList.
func (in *TLSTerminatedRouteList) DeepCopy() *TLSTerminatedRouteList {
	if in == nil {
		return nil
	}
	out := new(TLSTerminatedRouteList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *TLSTerminatedRouteList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TLSTerminatedRouteSpec) DeepCopyInto(out *TLSTerminatedRouteSpec) {
	*out = *in
	if in.PathMatch != nil {
		in, out := &in.PathMatch, &out.PathMatch
		*out = new(PathMatch)
		(*in).DeepCopyInto(*out)
	}
	if in.CABundle != nil {
		in, out := &in.CABundle, &out.CABundle
		*out = new(corev1.ConfigMapKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.ForwardingMTLSCert != nil {
		in, out := &in.ForwardingMTLSCert, &out.ForwardingMTLSCert
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.ForwardingMTLSKey != nil {
		in, out := &in.ForwardingMTLSKey, &out.ForwardingMTLSKey
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.Unauthenticated != nil {
		in, out := &in.Unauthenticated, &out.Unauthenticated
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TLSTerminatedRouteSpec.
func (in *TLSTerminatedRouteSpec) DeepCopy() *TLSTerminatedRouteSpec {
	if in == nil {
		return nil
	}
	out := new(TLSTerminatedRouteSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Tenant) DeepCopyInto(out *Tenant) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	out.Status = in.Status
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Tenant.
func (in *Tenant) DeepCopy() *Tenant {
	if in == nil {
		return nil
	}
	out := new(Tenant)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *Tenant) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TenantElasticSpec) DeepCopyInto(out *TenantElasticSpec) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TenantElasticSpec.
func (in *TenantElasticSpec) DeepCopy() *TenantElasticSpec {
	if in == nil {
		return nil
	}
	out := new(TenantElasticSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TenantList) DeepCopyInto(out *TenantList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Tenant, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TenantList.
func (in *TenantList) DeepCopy() *TenantList {
	if in == nil {
		return nil
	}
	out := new(TenantList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *TenantList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TenantSpec) DeepCopyInto(out *TenantSpec) {
	*out = *in
	if in.Indices != nil {
		in, out := &in.Indices, &out.Indices
		*out = make([]Index, len(*in))
		copy(*out, *in)
	}
	if in.Elastic != nil {
		in, out := &in.Elastic, &out.Elastic
		*out = new(TenantElasticSpec)
		**out = **in
	}
	if in.ControlPlaneReplicas != nil {
		in, out := &in.ControlPlaneReplicas, &out.ControlPlaneReplicas
		*out = new(int32)
		**out = **in
	}
	if in.LinseedDeployment != nil {
		in, out := &in.LinseedDeployment, &out.LinseedDeployment
		*out = new(LinseedDeployment)
		(*in).DeepCopyInto(*out)
	}
	if in.ESKubeControllerDeployment != nil {
		in, out := &in.ESKubeControllerDeployment, &out.ESKubeControllerDeployment
		*out = new(CalicoKubeControllersDeployment)
		(*in).DeepCopyInto(*out)
	}
	if in.DashboardsJob != nil {
		in, out := &in.DashboardsJob, &out.DashboardsJob
		*out = new(DashboardsJob)
		(*in).DeepCopyInto(*out)
	}
	if in.ManagedClusterVariant != nil {
		in, out := &in.ManagedClusterVariant, &out.ManagedClusterVariant
		*out = new(ProductVariant)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TenantSpec.
func (in *TenantSpec) DeepCopy() *TenantSpec {
	if in == nil {
		return nil
	}
	out := new(TenantSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TenantStatus) DeepCopyInto(out *TenantStatus) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TenantStatus.
func (in *TenantStatus) DeepCopy() *TenantStatus {
	if in == nil {
		return nil
	}
	out := new(TenantStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TigeraStatus) DeepCopyInto(out *TigeraStatus) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TigeraStatus.
func (in *TigeraStatus) DeepCopy() *TigeraStatus {
	if in == nil {
		return nil
	}
	out := new(TigeraStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *TigeraStatus) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TigeraStatusCondition) DeepCopyInto(out *TigeraStatusCondition) {
	*out = *in
	in.LastTransitionTime.DeepCopyInto(&out.LastTransitionTime)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TigeraStatusCondition.
func (in *TigeraStatusCondition) DeepCopy() *TigeraStatusCondition {
	if in == nil {
		return nil
	}
	out := new(TigeraStatusCondition)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TigeraStatusList) DeepCopyInto(out *TigeraStatusList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]TigeraStatus, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TigeraStatusList.
func (in *TigeraStatusList) DeepCopy() *TigeraStatusList {
	if in == nil {
		return nil
	}
	out := new(TigeraStatusList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *TigeraStatusList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TigeraStatusSpec) DeepCopyInto(out *TigeraStatusSpec) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TigeraStatusSpec.
func (in *TigeraStatusSpec) DeepCopy() *TigeraStatusSpec {
	if in == nil {
		return nil
	}
	out := new(TigeraStatusSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TigeraStatusStatus) DeepCopyInto(out *TigeraStatusStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]TigeraStatusCondition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TigeraStatusStatus.
func (in *TigeraStatusStatus) DeepCopy() *TigeraStatusStatus {
	if in == nil {
		return nil
	}
	out := new(TigeraStatusStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TyphaAffinity) DeepCopyInto(out *TyphaAffinity) {
	*out = *in
	if in.NodeAffinity != nil {
		in, out := &in.NodeAffinity, &out.NodeAffinity
		*out = new(NodeAffinity)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TyphaAffinity.
func (in *TyphaAffinity) DeepCopy() *TyphaAffinity {
	if in == nil {
		return nil
	}
	out := new(TyphaAffinity)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TyphaDeployment) DeepCopyInto(out *TyphaDeployment) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(TyphaDeploymentSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TyphaDeployment.
func (in *TyphaDeployment) DeepCopy() *TyphaDeployment {
	if in == nil {
		return nil
	}
	out := new(TyphaDeployment)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TyphaDeploymentContainer) DeepCopyInto(out *TyphaDeploymentContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TyphaDeploymentContainer.
func (in *TyphaDeploymentContainer) DeepCopy() *TyphaDeploymentContainer {
	if in == nil {
		return nil
	}
	out := new(TyphaDeploymentContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TyphaDeploymentInitContainer) DeepCopyInto(out *TyphaDeploymentInitContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TyphaDeploymentInitContainer.
func (in *TyphaDeploymentInitContainer) DeepCopy() *TyphaDeploymentInitContainer {
	if in == nil {
		return nil
	}
	out := new(TyphaDeploymentInitContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TyphaDeploymentPodSpec) DeepCopyInto(out *TyphaDeploymentPodSpec) {
	*out = *in
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]TyphaDeploymentInitContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]TyphaDeploymentContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Affinity != nil {
		in, out := &in.Affinity, &out.Affinity
		*out = new(corev1.Affinity)
		(*in).DeepCopyInto(*out)
	}
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.TerminationGracePeriodSeconds != nil {
		in, out := &in.TerminationGracePeriodSeconds, &out.TerminationGracePeriodSeconds
		*out = new(int64)
		**out = **in
	}
	if in.TopologySpreadConstraints != nil {
		in, out := &in.TopologySpreadConstraints, &out.TopologySpreadConstraints
		*out = make([]corev1.TopologySpreadConstraint, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TyphaDeploymentPodSpec.
func (in *TyphaDeploymentPodSpec) DeepCopy() *TyphaDeploymentPodSpec {
	if in == nil {
		return nil
	}
	out := new(TyphaDeploymentPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TyphaDeploymentPodTemplateSpec) DeepCopyInto(out *TyphaDeploymentPodTemplateSpec) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(TyphaDeploymentPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TyphaDeploymentPodTemplateSpec.
func (in *TyphaDeploymentPodTemplateSpec) DeepCopy() *TyphaDeploymentPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(TyphaDeploymentPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TyphaDeploymentSpec) DeepCopyInto(out *TyphaDeploymentSpec) {
	*out = *in
	if in.MinReadySeconds != nil {
		in, out := &in.MinReadySeconds, &out.MinReadySeconds
		*out = new(int32)
		**out = **in
	}
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(TyphaDeploymentPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Strategy != nil {
		in, out := &in.Strategy, &out.Strategy
		*out = new(TyphaDeploymentStrategy)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TyphaDeploymentSpec.
func (in *TyphaDeploymentSpec) DeepCopy() *TyphaDeploymentSpec {
	if in == nil {
		return nil
	}
	out := new(TyphaDeploymentSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TyphaDeploymentStrategy) DeepCopyInto(out *TyphaDeploymentStrategy) {
	*out = *in
	if in.RollingUpdate != nil {
		in, out := &in.RollingUpdate, &out.RollingUpdate
		*out = new(appsv1.RollingUpdateDeployment)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TyphaDeploymentStrategy.
func (in *TyphaDeploymentStrategy) DeepCopy() *TyphaDeploymentStrategy {
	if in == nil {
		return nil
	}
	out := new(TyphaDeploymentStrategy)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UserMatch) DeepCopyInto(out *UserMatch) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UserMatch.
func (in *UserMatch) DeepCopy() *UserMatch {
	if in == nil {
		return nil
	}
	out := new(UserMatch)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UserSearch) DeepCopyInto(out *UserSearch) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UserSearch.
func (in *UserSearch) DeepCopy() *UserSearch {
	if in == nil {
		return nil
	}
	out := new(UserSearch)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Whisker) DeepCopyInto(out *Whisker) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Whisker.
func (in *Whisker) DeepCopy() *Whisker {
	if in == nil {
		return nil
	}
	out := new(Whisker)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *Whisker) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WhiskerDeployment) DeepCopyInto(out *WhiskerDeployment) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(WhiskerDeploymentSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WhiskerDeployment.
func (in *WhiskerDeployment) DeepCopy() *WhiskerDeployment {
	if in == nil {
		return nil
	}
	out := new(WhiskerDeployment)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WhiskerDeploymentContainer) DeepCopyInto(out *WhiskerDeploymentContainer) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = new(corev1.ResourceRequirements)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WhiskerDeploymentContainer.
func (in *WhiskerDeploymentContainer) DeepCopy() *WhiskerDeploymentContainer {
	if in == nil {
		return nil
	}
	out := new(WhiskerDeploymentContainer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WhiskerDeploymentPodSpec) DeepCopyInto(out *WhiskerDeploymentPodSpec) {
	*out = *in
	if in.Affinity != nil {
		in, out := &in.Affinity, &out.Affinity
		*out = new(corev1.Affinity)
		(*in).DeepCopyInto(*out)
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]WhiskerDeploymentContainer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.TerminationGracePeriodSeconds != nil {
		in, out := &in.TerminationGracePeriodSeconds, &out.TerminationGracePeriodSeconds
		*out = new(int64)
		**out = **in
	}
	if in.TopologySpreadConstraints != nil {
		in, out := &in.TopologySpreadConstraints, &out.TopologySpreadConstraints
		*out = make([]corev1.TopologySpreadConstraint, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WhiskerDeploymentPodSpec.
func (in *WhiskerDeploymentPodSpec) DeepCopy() *WhiskerDeploymentPodSpec {
	if in == nil {
		return nil
	}
	out := new(WhiskerDeploymentPodSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WhiskerDeploymentPodTemplateSpec) DeepCopyInto(out *WhiskerDeploymentPodTemplateSpec) {
	*out = *in
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(Metadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Spec != nil {
		in, out := &in.Spec, &out.Spec
		*out = new(WhiskerDeploymentPodSpec)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WhiskerDeploymentPodTemplateSpec.
func (in *WhiskerDeploymentPodTemplateSpec) DeepCopy() *WhiskerDeploymentPodTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(WhiskerDeploymentPodTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WhiskerDeploymentSpec) DeepCopyInto(out *WhiskerDeploymentSpec) {
	*out = *in
	if in.MinReadySeconds != nil {
		in, out := &in.MinReadySeconds, &out.MinReadySeconds
		*out = new(int32)
		**out = **in
	}
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(WhiskerDeploymentPodTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Strategy != nil {
		in, out := &in.Strategy, &out.Strategy
		*out = new(WhiskerDeploymentStrategy)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WhiskerDeploymentSpec.
func (in *WhiskerDeploymentSpec) DeepCopy() *WhiskerDeploymentSpec {
	if in == nil {
		return nil
	}
	out := new(WhiskerDeploymentSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WhiskerDeploymentStrategy) DeepCopyInto(out *WhiskerDeploymentStrategy) {
	*out = *in
	if in.RollingUpdate != nil {
		in, out := &in.RollingUpdate, &out.RollingUpdate
		*out = new(appsv1.RollingUpdateDeployment)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WhiskerDeploymentStrategy.
func (in *WhiskerDeploymentStrategy) DeepCopy() *WhiskerDeploymentStrategy {
	if in == nil {
		return nil
	}
	out := new(WhiskerDeploymentStrategy)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WhiskerList) DeepCopyInto(out *WhiskerList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Whisker, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WhiskerList.
func (in *WhiskerList) DeepCopy() *WhiskerList {
	if in == nil {
		return nil
	}
	out := new(WhiskerList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *WhiskerList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WhiskerSpec) DeepCopyInto(out *WhiskerSpec) {
	*out = *in
	if in.WhiskerDeployment != nil {
		in, out := &in.WhiskerDeployment, &out.WhiskerDeployment
		*out = new(WhiskerDeployment)
		(*in).DeepCopyInto(*out)
	}
	if in.Notifications != nil {
		in, out := &in.Notifications, &out.Notifications
		*out = new(NotificationMode)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WhiskerSpec.
func (in *WhiskerSpec) DeepCopy() *WhiskerSpec {
	if in == nil {
		return nil
	}
	out := new(WhiskerSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WhiskerStatus) DeepCopyInto(out *WhiskerStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]metav1.Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WhiskerStatus.
func (in *WhiskerStatus) DeepCopy() *WhiskerStatus {
	if in == nil {
		return nil
	}
	out := new(WhiskerStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WindowsNodeSpec) DeepCopyInto(out *WindowsNodeSpec) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WindowsNodeSpec.
func (in *WindowsNodeSpec) DeepCopy() *WindowsNodeSpec {
	if in == nil {
		return nil
	}
	out := new(WindowsNodeSpec)
	in.DeepCopyInto(out)
	return out
}
