/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha2

import (
	v1 "k8s.io/client-go/applyconfigurations/meta/v1"
	apisv1alpha2 "sigs.k8s.io/network-policy-api/apis/v1alpha2"
)

// ClusterNetworkPolicyEgressPeerApplyConfiguration represents a declarative configuration of the ClusterNetworkPolicyEgressPeer type for use
// with apply.
type ClusterNetworkPolicyEgressPeerApplyConfiguration struct {
	Namespaces  *v1.LabelSelectorApplyConfiguration `json:"namespaces,omitempty"`
	Pods        *NamespacedPodApplyConfiguration    `json:"pods,omitempty"`
	Nodes       *v1.LabelSelectorApplyConfiguration `json:"nodes,omitempty"`
	Networks    []apisv1alpha2.CIDR                 `json:"networks,omitempty"`
	DomainNames []apisv1alpha2.DomainName           `json:"domainNames,omitempty"`
}

// ClusterNetworkPolicyEgressPeerApplyConfiguration constructs a declarative configuration of the ClusterNetworkPolicyEgressPeer type for use with
// apply.
func ClusterNetworkPolicyEgressPeer() *ClusterNetworkPolicyEgressPeerApplyConfiguration {
	return &ClusterNetworkPolicyEgressPeerApplyConfiguration{}
}

// WithNamespaces sets the Namespaces field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Namespaces field is set to the value of the last call.
func (b *ClusterNetworkPolicyEgressPeerApplyConfiguration) WithNamespaces(value *v1.LabelSelectorApplyConfiguration) *ClusterNetworkPolicyEgressPeerApplyConfiguration {
	b.Namespaces = value
	return b
}

// WithPods sets the Pods field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Pods field is set to the value of the last call.
func (b *ClusterNetworkPolicyEgressPeerApplyConfiguration) WithPods(value *NamespacedPodApplyConfiguration) *ClusterNetworkPolicyEgressPeerApplyConfiguration {
	b.Pods = value
	return b
}

// WithNodes sets the Nodes field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Nodes field is set to the value of the last call.
func (b *ClusterNetworkPolicyEgressPeerApplyConfiguration) WithNodes(value *v1.LabelSelectorApplyConfiguration) *ClusterNetworkPolicyEgressPeerApplyConfiguration {
	b.Nodes = value
	return b
}

// WithNetworks adds the given value to the Networks field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Networks field.
func (b *ClusterNetworkPolicyEgressPeerApplyConfiguration) WithNetworks(values ...apisv1alpha2.CIDR) *ClusterNetworkPolicyEgressPeerApplyConfiguration {
	for i := range values {
		b.Networks = append(b.Networks, values[i])
	}
	return b
}

// WithDomainNames adds the given value to the DomainNames field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the DomainNames field.
func (b *ClusterNetworkPolicyEgressPeerApplyConfiguration) WithDomainNames(values ...apisv1alpha2.DomainName) *ClusterNetworkPolicyEgressPeerApplyConfiguration {
	for i := range values {
		b.DomainNames = append(b.DomainNames, values[i])
	}
	return b
}
