FST Module
==========

**NOTE: This module is currently in an early and highly experimental state.**

The Flow State Table (FST) DAQ module is a wrapper module that mimics operating
on top of a flow-tracking dataplane.  It will perform basic decoding of packet
messages received from the lower modules in the stack and use that information
to classify packets into flows and track state for those flows.

By default, the FST module will enforce binding verdicts on flows that it is
tracking.  That means future packets received on flows that have received a
whitelist or blacklist verdict will immediately be finalized with a WHITELIST
or BLACKLIST verdict respectively.  To disable this behavior, the
'no_binding_verdicts' variable can be given.

Start and End of Flow messages will be generated by the module when it creates
a new flow entry or deletes an old one for any reason (pruning, timeout,
shutdown, etc.).

The set of timeout values are currently hardcoded to:

* TCP Short (30 seconds)
* TCP Long (3600 seconds)
* UDP (180 seconds)
* ICMP (30 seconds)
* Other (60 seconds)

At the moment, TCP flows will always be assigned the TCP Short timeout.  In the
near future, some amount of TCP state tracking will be added to allow for the
transition to the TCP Long timeout.

Note: The decoder will bail on packets with bad checksums and fail to classify
them.  Specifying the 'ignore_checksums' variable will disable this behavior
(use with caution - garbage in, garbage out).

There is a hardcoded flow state table size of 1024 entries.  This will become
configurable in the future.

TCP Bare ACK Filtering
------------------

The FST DAQ module supports an experimental mode where it will filter bare ACKs
on established TCP flows and provide the sequence number and window size from
those ACKs as metadata on subsequent data packets going the opposite direction
on the same flow.

This feature is enabled by configuring the module with the 'enable_meta_ack'
variable.

IOCTLs
------

The following IOCTLs are implemented by the FST DAQ module for performing
operations on the flows that it is tracking:

* SET_FLOW_OPAQUE
* SET_FLOW_HA_STATE
* GET_FLOW_HA_STATE

The packet message header flags related to HA state, opaque value, and flow ID
will be set accordinly for the state present in the table.

Requirements
------------
* Compiler and runtime support for the C++11 specification
